/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.order.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.order.dao.OmAppointmentMapper;
import com.yqbsoft.laser.service.order.domain.OmAppointmentDomain;
import com.yqbsoft.laser.service.order.domain.OmApptimeDomain;
import com.yqbsoft.laser.service.order.model.OmAppointment;
import com.yqbsoft.laser.service.order.service.AppointmentService;
import com.yqbsoft.laser.service.order.service.OmApptimeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppointmentServiceImpl
extends BaseServiceImpl
implements AppointmentService {
    public static final String SYS_CODE = "om.ORDER.AppointmentServiceImpl";
    private OmAppointmentMapper omAppointmentMapper;
    private OmApptimeService omApptimeService;

    public void setOmAppointmentMapper(OmAppointmentMapper omAppointmentMapper) {
        this.omAppointmentMapper = omAppointmentMapper;
    }

    public void setOmApptimeService(OmApptimeService omApptimeService) {
        this.omApptimeService = omApptimeService;
    }

    private Date getSysDate() {
        try {
            return this.omAppointmentMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.AppointmentServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAppointment(OmAppointmentDomain omAppointmentDomain) {
        if (null == omAppointmentDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setAppointmentDefault(OmAppointment omAppointment) {
        if (null == omAppointment) {
            return;
        }
        if (null == omAppointment.getDataState()) {
            omAppointment.setDataState(0);
        }
        if (null == omAppointment.getGmtCreate()) {
            omAppointment.setGmtCreate(this.getSysDate());
        }
        omAppointment.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)omAppointment.getAppointmentCode())) {
            omAppointment.setAppointmentCode(this.getNo(null, OmAppointment.class.getSimpleName(), "appointmentCode", omAppointment.getTenantCode()));
        }
    }

    private int getAppointmentMaxCode() {
        int code = 0;
        try {
            return this.omAppointmentMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.AppointmentServiceImpl.getAppointmentMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAppointmentUpdataDefault(OmAppointment omAppointment) {
        if (null == omAppointment) {
            return;
        }
        omAppointment.setGmtModified(this.getSysDate());
    }

    private void saveAppointmentModel(OmAppointment omAppointment) throws ApiException {
        if (null == omAppointment) {
            return;
        }
        try {
            this.omAppointmentMapper.insert(omAppointment);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.saveAppointmentModel.ex", (Throwable)e);
        }
    }

    private OmAppointment getAppointmentModelById(Integer appointmentId) {
        if (null == appointmentId) {
            return null;
        }
        try {
            return this.omAppointmentMapper.selectByPrimaryKey(appointmentId);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.AppointmentServiceImpl.getAppointmentModelById", (Throwable)e);
            return null;
        }
    }

    public OmAppointment getAppointmentModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.omAppointmentMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.AppointmentServiceImpl.getAppointmentModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAppointmentModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.omAppointmentMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.delAppointmentModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.delAppointmentModelByCode.num");
        }
    }

    private void deleteAppointmentModel(Integer appointmentId) throws ApiException {
        if (null == appointmentId) {
            return;
        }
        int i = 0;
        try {
            i = this.omAppointmentMapper.deleteByPrimaryKey(appointmentId);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.deleteAppointmentModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.deleteAppointmentModel.num");
        }
    }

    private void updateAppointmentModel(OmAppointment omAppointment) throws ApiException {
        if (null == omAppointment) {
            return;
        }
        try {
            this.omAppointmentMapper.updateByPrimaryKeySelective(omAppointment);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.updateAppointmentModel.ex", (Throwable)e);
        }
    }

    private void updateStateAppointmentModel(Integer appointmentId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appointmentId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appointmentId", appointmentId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.omAppointmentMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.updateStateAppointmentModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.updateStateAppointmentModel.null");
        }
    }

    private OmAppointment makeAppointment(OmAppointmentDomain omAppointmentDomain, OmAppointment omAppointment) {
        if (null == omAppointmentDomain) {
            return null;
        }
        if (null == omAppointment) {
            omAppointment = new OmAppointment();
        }
        try {
            BeanUtils.copyAllPropertys((Object)omAppointment, (Object)omAppointmentDomain);
            return omAppointment;
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.AppointmentServiceImpl.makeAppointment", (Throwable)e);
            return null;
        }
    }

    private List<OmAppointment> queryAppointmentModelPage(Map<String, Object> parammap) {
        try {
            return this.omAppointmentMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.AppointmentServiceImpl.queryAppointmentModel", (Throwable)e);
            return null;
        }
    }

    private int countAppointment(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.omAppointmentMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.AppointmentServiceImpl.countAppointment", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveAppointment(OmAppointmentDomain omAppointmentDomain) throws ApiException {
        String msg = this.checkAppointment(omAppointmentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.saveAppointment.checkAppointment", msg);
        }
        OmAppointment omAppointment = this.makeAppointment(omAppointmentDomain, null);
        this.setAppointmentDefault(omAppointment);
        this.saveAppointmentModel(omAppointment);
        if (omAppointmentDomain.getOmApptimeDomain() != null) {
            this.omApptimeService.saveApptime(omAppointmentDomain.getOmApptimeDomain());
        } else {
            OmApptimeDomain apptimeDomain = new OmApptimeDomain();
            apptimeDomain.setMemberCode(omAppointment.getMemberBcode());
            apptimeDomain.setMemberName(omAppointment.getMemberBname());
            apptimeDomain.setApptimeSdate(omAppointment.getAppointmentEdate());
            apptimeDomain.setApptimeEdate(DateUtil.addMinutes((Date)omAppointment.getAppointmentEdate(), (int)60));
            apptimeDomain.setTenantCode(omAppointment.getTenantCode());
            this.omApptimeService.saveApptime(apptimeDomain);
        }
        return omAppointment.getAppointmentCode();
    }

    @Override
    public void updateAppointmentState(Integer appointmentId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppointmentModel(appointmentId, dataState, oldDataState);
    }

    @Override
    public void updateAppointment(OmAppointmentDomain omAppointmentDomain) throws ApiException {
        String msg = this.checkAppointment(omAppointmentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.updateAppointment.checkAppointment", msg);
        }
        OmAppointment oldOmAppointment = this.getAppointmentModelById(omAppointmentDomain.getAppointmentId());
        if (null == oldOmAppointment) {
            throw new ApiException("om.ORDER.AppointmentServiceImpl.updateAppointment.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OmAppointment omAppointment = this.makeAppointment(omAppointmentDomain, oldOmAppointment);
        this.setAppointmentUpdataDefault(omAppointment);
        this.updateAppointmentModel(omAppointment);
    }

    @Override
    public OmAppointment getAppointment(Integer appointmentId) {
        return this.getAppointmentModelById(appointmentId);
    }

    @Override
    public void deleteAppointment(Integer appointmentId) throws ApiException {
        this.deleteAppointmentModel(appointmentId);
    }

    @Override
    public QueryResult<OmAppointment> queryAppointmentPage(Map<String, Object> map) {
        List<OmAppointment> omAppointmentList = this.queryAppointmentModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAppointment(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(omAppointmentList);
        return queryResult;
    }

    @Override
    public OmAppointment getAppointmentByCode(Map<String, Object> map) {
        return this.getAppointmentModelByCode(map);
    }

    @Override
    public void delAppointmentByCode(Map<String, Object> map) throws ApiException {
        this.delAppointmentModelByCode(map);
    }
}

