/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.order.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.order.dao.OmApptimeMapper;
import com.yqbsoft.laser.service.order.domain.OmApptimeDomain;
import com.yqbsoft.laser.service.order.model.OmApptime;
import com.yqbsoft.laser.service.order.service.OmApptimeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OmApptimeServiceImpl
extends BaseServiceImpl
implements OmApptimeService {
    public static final String SYS_CODE = "om.ORDER.OmApptimeServiceImpl";
    private OmApptimeMapper omApptimeMapper;

    public void setOmApptimeMapper(OmApptimeMapper omApptimeMapper) {
        this.omApptimeMapper = omApptimeMapper;
    }

    private Date getSysDate() {
        try {
            return this.omApptimeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OmApptimeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkApptime(OmApptimeDomain omApptimeDomain) {
        if (null == omApptimeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setApptimeDefault(OmApptime omApptime) {
        if (null == omApptime) {
            return;
        }
        if (null == omApptime.getDataState()) {
            omApptime.setDataState(0);
        }
        if (null == omApptime.getGmtCreate()) {
            omApptime.setGmtCreate(this.getSysDate());
        }
        omApptime.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)omApptime.getApptimeCode())) {
            omApptime.setApptimeCode(this.createUUIDString());
        }
    }

    private int getApptimeMaxCode() {
        int code = 0;
        try {
            return this.omApptimeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OmApptimeServiceImpl.getApptimeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setApptimeUpdataDefault(OmApptime omApptime) {
        if (null == omApptime) {
            return;
        }
        omApptime.setGmtModified(this.getSysDate());
    }

    private void saveApptimeModel(OmApptime omApptime) throws ApiException {
        if (null == omApptime) {
            return;
        }
        try {
            this.omApptimeMapper.insert(omApptime);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.saveApptimeModel.ex", (Throwable)e);
        }
    }

    private OmApptime getApptimeModelById(Integer apptimeId) {
        if (null == apptimeId) {
            return null;
        }
        try {
            return this.omApptimeMapper.selectByPrimaryKey(apptimeId);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OmApptimeServiceImpl.getApptimeModelById", (Throwable)e);
            return null;
        }
    }

    public OmApptime getApptimeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.omApptimeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OmApptimeServiceImpl.getApptimeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delApptimeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.omApptimeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.delApptimeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.delApptimeModelByCode.num");
        }
    }

    private void deleteApptimeModel(Integer apptimeId) throws ApiException {
        if (null == apptimeId) {
            return;
        }
        int i = 0;
        try {
            i = this.omApptimeMapper.deleteByPrimaryKey(apptimeId);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.deleteApptimeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.deleteApptimeModel.num");
        }
    }

    private void updateApptimeModel(OmApptime omApptime) throws ApiException {
        if (null == omApptime) {
            return;
        }
        try {
            this.omApptimeMapper.updateByPrimaryKeySelective(omApptime);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.updateApptimeModel.ex", (Throwable)e);
        }
    }

    private void updateStateApptimeModel(Integer apptimeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == apptimeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("apptimeId", apptimeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.omApptimeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.updateStateApptimeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.updateStateApptimeModel.null");
        }
    }

    private OmApptime makeApptime(OmApptimeDomain omApptimeDomain, OmApptime omApptime) {
        if (null == omApptimeDomain) {
            return null;
        }
        if (null == omApptime) {
            omApptime = new OmApptime();
        }
        try {
            BeanUtils.copyAllPropertys((Object)omApptime, (Object)omApptimeDomain);
            return omApptime;
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OmApptimeServiceImpl.makeApptime", (Throwable)e);
            return null;
        }
    }

    private List<OmApptime> queryApptimeModelPage(Map<String, Object> parammap) {
        try {
            return this.omApptimeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OmApptimeServiceImpl.queryApptimeModel", (Throwable)e);
            return null;
        }
    }

    private int countApptime(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.omApptimeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OmApptimeServiceImpl.countApptime", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveApptime(OmApptimeDomain omApptimeDomain) throws ApiException {
        String msg = this.checkApptime(omApptimeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.saveApptime.checkApptime", msg);
        }
        OmApptime omApptime = this.makeApptime(omApptimeDomain, null);
        this.setApptimeDefault(omApptime);
        this.saveApptimeModel(omApptime);
        return omApptime.getApptimeCode();
    }

    @Override
    public void updateApptimeState(Integer apptimeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateApptimeModel(apptimeId, dataState, oldDataState);
    }

    @Override
    public void updateApptime(OmApptimeDomain omApptimeDomain) throws ApiException {
        String msg = this.checkApptime(omApptimeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.updateApptime.checkApptime", msg);
        }
        OmApptime oldOmApptime = this.getApptimeModelById(omApptimeDomain.getApptimeId());
        if (null == oldOmApptime) {
            throw new ApiException("om.ORDER.OmApptimeServiceImpl.updateApptime.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OmApptime omApptime = this.makeApptime(omApptimeDomain, oldOmApptime);
        this.setApptimeUpdataDefault(omApptime);
        this.updateApptimeModel(omApptime);
    }

    @Override
    public OmApptime getApptime(Integer apptimeId) {
        return this.getApptimeModelById(apptimeId);
    }

    @Override
    public void deleteApptime(Integer apptimeId) throws ApiException {
        this.deleteApptimeModel(apptimeId);
    }

    @Override
    public QueryResult<OmApptime> queryApptimePage(Map<String, Object> map) {
        List<OmApptime> omApptimeList = this.queryApptimeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApptime(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(omApptimeList);
        return queryResult;
    }

    @Override
    public OmApptime getApptimeByCode(Map<String, Object> map) {
        return this.getApptimeModelByCode(map);
    }

    @Override
    public void delApptimeByCode(Map<String, Object> map) throws ApiException {
        this.delApptimeModelByCode(map);
    }
}

