/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.order.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.order.dao.OrmOrderMapper;
import com.yqbsoft.laser.service.order.domain.OrmOrderDomain;
import com.yqbsoft.laser.service.order.model.OrmOrder;
import com.yqbsoft.laser.service.order.service.OrderService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    public static final String SYS_CODE = "om.ORDER.OrderServiceImpl";
    private OrmOrderMapper ormOrderMapper;

    public void setormOrderMapper(OrmOrderMapper ormOrderMapper) {
        this.ormOrderMapper = ormOrderMapper;
    }

    private Date getSysDate() {
        try {
            return this.ormOrderMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OrderServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrder(OrmOrderDomain omOrderDomain) {
        if (null == omOrderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setOrderDefault(OrmOrder omOrder) {
        if (null == omOrder) {
            return;
        }
        if (null == omOrder.getDataState()) {
            omOrder.setDataState(1);
        }
        if (null == omOrder.getGmtCreate()) {
            omOrder.setGmtCreate(this.getSysDate());
        }
        omOrder.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)omOrder.getOrderCode())) {
            int code = this.getMaxCode();
            omOrder.setOrderCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ormOrderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OrderServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrderUpdataDefault(OrmOrder omOrder) {
        if (null == omOrder) {
            return;
        }
        omOrder.setGmtModified(this.getSysDate());
    }

    private void saveOrderModel(OrmOrder omOrder) throws ApiException {
        if (null == omOrder) {
            return;
        }
        try {
            this.ormOrderMapper.insert(omOrder);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.OrderServiceImpl.saveFtpserverModel.ex");
        }
    }

    private OrmOrder getOrderModelById(Integer orderId) {
        if (null == orderId) {
            return null;
        }
        try {
            return this.ormOrderMapper.selectByPrimaryKey(orderId);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OrderServiceImpl.getOrderModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteOrderModel(Integer orderId) throws ApiException {
        if (null == orderId) {
            return;
        }
        int i = 0;
        try {
            i = this.ormOrderMapper.deleteByPrimaryKey(orderId);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.OrderServiceImpl.deleteOrderModel.ex");
        }
        if (1 != i) {
            throw new ApiException("om.ORDER.OrderServiceImpl.deleteOrderModel.num");
        }
    }

    private void updateOrderModel(OrmOrder omOrder) throws ApiException {
        if (null == omOrder) {
            return;
        }
        try {
            this.ormOrderMapper.updateByPrimaryKeySelective(omOrder);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.OrderServiceImpl.updateOrderModel.ex");
        }
    }

    private void updateStateOrderModel(Integer orderId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == orderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderId", orderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ormOrderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("om.ORDER.OrderServiceImpl.updateStateOrderModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("om.ORDER.OrderServiceImpl.updateStateOrderModel.null");
        }
    }

    private OrmOrder makeOrder(OrmOrderDomain omOrderDomain, OrmOrder omOrder) {
        if (null == omOrderDomain) {
            return null;
        }
        if (null == omOrder) {
            omOrder = new OrmOrder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)omOrder, (Object)omOrderDomain);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OrderServiceImpl.makeOrder", (Throwable)e);
        }
        return omOrder;
    }

    private List<OrmOrder> queryOrderModelPage(Map<String, Object> parammap) {
        try {
            return this.ormOrderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OrderServiceImpl.queryOrderModel", (Throwable)e);
            return null;
        }
    }

    private int countOrder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ormOrderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("om.ORDER.OrderServiceImpl.countOrder", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveOrder(OrmOrderDomain omOrderDomain) throws ApiException {
        String msg = this.checkOrder(omOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.ORDER.OrderServiceImpl.saveOrder.checkOrder", msg);
        }
        OrmOrder omOrder = this.makeOrder(omOrderDomain, null);
        this.setOrderDefault(omOrder);
        this.saveOrderModel(omOrder);
    }

    @Override
    public void updateOrderState(Integer orderId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOrderModel(orderId, dataState, oldDataState);
    }

    @Override
    public void updateOrder(OrmOrderDomain omOrderDomain) throws ApiException {
        String msg = this.checkOrder(omOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.ORDER.OrderServiceImpl.updateOrder.checkOrder", msg);
        }
        OrmOrder oldOmOrder = this.getOrderModelById(omOrderDomain.getOrderId());
        if (null == oldOmOrder) {
            throw new ApiException("om.ORDER.OrderServiceImpl.updateOrder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrmOrder omOrder = this.makeOrder(omOrderDomain, oldOmOrder);
        this.setOrderUpdataDefault(omOrder);
        this.updateOrderModel(omOrder);
    }

    @Override
    public OrmOrder getOrder(Integer orderId) {
        return this.getOrderModelById(orderId);
    }

    @Override
    public void deleteOrder(Integer orderId) throws ApiException {
        this.deleteOrderModel(orderId);
    }

    @Override
    public QueryResult<OrmOrder> queryOrderPage(Map<String, Object> map) {
        List<OrmOrder> omOrderList = this.queryOrderModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(omOrderList);
        return queryResult;
    }
}

