/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.dao.PeProtClearagCycleMapper;
import com.yqbsoft.laser.service.payengine.dao.PeProtClearagFaMapper;
import com.yqbsoft.laser.service.payengine.dao.PeProtClearagMapper;
import com.yqbsoft.laser.service.payengine.dao.PeProtClearinfoMapper;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearagCycleDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearagCycleReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearagDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearagFaDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearagFaReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearagReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearinfoDomain;
import com.yqbsoft.laser.service.payengine.domain.PeReorderDomain;
import com.yqbsoft.laser.service.payengine.model.PeProtClearag;
import com.yqbsoft.laser.service.payengine.model.PeProtClearagCycle;
import com.yqbsoft.laser.service.payengine.model.PeProtClearagFa;
import com.yqbsoft.laser.service.payengine.model.PeProtClearinfo;
import com.yqbsoft.laser.service.payengine.service.PeProtClearagService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PeProtClearagServiceImpl
extends BaseServiceImpl
implements PeProtClearagService {
    public static final String SYS_CODE = "pe.PeProtClearagServiceImpl";
    private PeProtClearagMapper peProtClearagMapper;
    private PeProtClearagFaMapper peProtClearagFaMapper;
    private PeProtClearagCycleMapper peProtClearagCycleMapper;
    private PeProtClearinfoMapper peProtClearinfoMapper;
    private Integer statDate = 1;
    public static final String CACHE_KEY_CLEARAG = "PeProtClearag";

    public void setPeProtClearagMapper(PeProtClearagMapper peProtClearagMapper) {
        this.peProtClearagMapper = peProtClearagMapper;
    }

    public void setPeProtClearagFaMapper(PeProtClearagFaMapper peProtClearagFaMapper) {
        this.peProtClearagFaMapper = peProtClearagFaMapper;
    }

    public void setPeProtClearagCycleMapper(PeProtClearagCycleMapper peProtClearagCycleMapper) {
        this.peProtClearagCycleMapper = peProtClearagCycleMapper;
    }

    public void setPeProtClearinfoMapper(PeProtClearinfoMapper peProtClearinfoMapper) {
        this.peProtClearinfoMapper = peProtClearinfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.peProtClearagMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProtClearag(PeProtClearagDomain peProtClearagDomain) {
        if (null == peProtClearagDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProtClearagDefault(PeProtClearag peProtClearag) {
        if (null == peProtClearag) {
            return;
        }
        if (null == peProtClearag.getDataState()) {
            peProtClearag.setDataState(0);
        }
        if (null == peProtClearag.getGmtCreate()) {
            peProtClearag.setGmtCreate(this.getSysDate());
        }
        peProtClearag.setGmtModified(this.getSysDate());
    }

    private int getProtClearagMaxCode() {
        int code = 0;
        try {
            return this.peProtClearagMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearagMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProtClearagUpdataDefault(PeProtClearag peProtClearag) {
        if (null == peProtClearag) {
            return;
        }
        peProtClearag.setGmtModified(this.getSysDate());
    }

    private void saveProtClearagModel(PeProtClearag peProtClearag) throws ApiException {
        if (null == peProtClearag) {
            return;
        }
        try {
            this.peProtClearagMapper.insert(peProtClearag);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.saveProtClearagModel.ex", (Throwable)e);
        }
    }

    private PeProtClearag getProtClearagModelById(Integer protClearagId) {
        if (null == protClearagId) {
            return null;
        }
        try {
            return this.peProtClearagMapper.selectByPrimaryKey(protClearagId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearagModelById", (Throwable)e);
            return null;
        }
    }

    public PeProtClearag getProtClearagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peProtClearagMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearagModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProtClearagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtClearagMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.delProtClearagModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtClearagServiceImpl.delProtClearagModelByCode.num");
        }
    }

    private void deleteProtClearagModel(Integer protClearagId) throws ApiException {
        if (null == protClearagId) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtClearagMapper.deleteByPrimaryKey(protClearagId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.deleteProtClearagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtClearagServiceImpl.deleteProtClearagModel.num");
        }
    }

    private void updateProtClearagModel(PeProtClearag peProtClearag) throws ApiException {
        if (null == peProtClearag) {
            return;
        }
        try {
            this.peProtClearagMapper.updateByPrimaryKeySelective(peProtClearag);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearagModel.ex", (Throwable)e);
        }
    }

    private void updateStateProtClearagModel(Integer protClearagId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == protClearagId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protClearagId", protClearagId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (this.statDate.equals(dataState) || this.statDate.equals(oldDataState)) {
            PeProtClearag peProtClearag = this.getProtClearagModelById(protClearagId);
            if (null == peProtClearag) {
                throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearagModel.peProtClearag", "null");
            }
            if (this.statDate.equals(dataState)) {
                this.updateCache(peProtClearag);
            } else {
                this.delCache(peProtClearag);
            }
        }
        int i = 0;
        try {
            i = this.peProtClearagMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearagModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearagModel.null");
        }
    }

    private PeProtClearag makeProtClearag(PeProtClearagDomain peProtClearagDomain, PeProtClearag peProtClearag) {
        if (null == peProtClearagDomain) {
            return null;
        }
        if (null == peProtClearag) {
            peProtClearag = new PeProtClearag();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peProtClearag, (Object)peProtClearagDomain);
            return peProtClearag;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.makeProtClearag", (Throwable)e);
            return null;
        }
    }

    private List<PeProtClearag> queryProtClearagModelPage(Map<String, Object> parammap) {
        try {
            return this.peProtClearagMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.queryProtClearagModel", (Throwable)e);
            return null;
        }
    }

    private int countProtClearag(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peProtClearagMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.countProtClearag", (Throwable)e);
        }
        return i;
    }

    private String checkProtClearagFa(PeProtClearagFaDomain peProtClearagFaDomain) {
        if (null == peProtClearagFaDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProtClearagFaDefault(PeProtClearagFa peProtClearagFa) {
        if (null == peProtClearagFa) {
            return;
        }
        if (null == peProtClearagFa.getDataState()) {
            peProtClearagFa.setDataState(0);
        }
        if (null == peProtClearagFa.getGmtCreate()) {
            peProtClearagFa.setGmtCreate(this.getSysDate());
        }
        peProtClearagFa.setGmtModified(this.getSysDate());
    }

    private int getProtClearagFaMaxCode() {
        int code = 0;
        try {
            return this.peProtClearagFaMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearagFaMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProtClearagFaUpdataDefault(PeProtClearagFa peProtClearagFa) {
        if (null == peProtClearagFa) {
            return;
        }
        peProtClearagFa.setGmtModified(this.getSysDate());
    }

    private void saveProtClearagFaModel(PeProtClearagFa peProtClearagFa) throws ApiException {
        if (null == peProtClearagFa) {
            return;
        }
        try {
            this.peProtClearagFaMapper.insert(peProtClearagFa);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.saveProtClearagFaModel.ex", (Throwable)e);
        }
    }

    private PeProtClearagFa getProtClearagFaModelById(Integer protClearagFaId) {
        if (null == protClearagFaId) {
            return null;
        }
        try {
            return this.peProtClearagFaMapper.selectByPrimaryKey(protClearagFaId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearagFaModelById", (Throwable)e);
            return null;
        }
    }

    public PeProtClearagFa getProtClearagFaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peProtClearagFaMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearagFaModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProtClearagFaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtClearagFaMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.delProtClearagFaModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtClearagServiceImpl.delProtClearagFaModelByCode.num");
        }
    }

    private void deleteProtClearagFaModel(Integer protClearagFaId) throws ApiException {
        if (null == protClearagFaId) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtClearagFaMapper.deleteByPrimaryKey(protClearagFaId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.deleteProtClearagFaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtClearagServiceImpl.deleteProtClearagFaModel.num");
        }
    }

    private void updateProtClearagFaModel(PeProtClearagFa peProtClearagFa) throws ApiException {
        if (null == peProtClearagFa) {
            return;
        }
        try {
            this.peProtClearagFaMapper.updateByPrimaryKeySelective(peProtClearagFa);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearagFaModel.ex", (Throwable)e);
        }
    }

    private void updateStateProtClearagFaModel(Integer protClearagFaId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == protClearagFaId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protClearagFaId", protClearagFaId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peProtClearagFaMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearagFaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearagFaModel.null");
        }
    }

    private PeProtClearagFa makeProtClearagFa(PeProtClearagFaDomain peProtClearagFaDomain, PeProtClearagFa peProtClearagFa) {
        if (null == peProtClearagFaDomain) {
            return null;
        }
        if (null == peProtClearagFa) {
            peProtClearagFa = new PeProtClearagFa();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peProtClearagFa, (Object)peProtClearagFaDomain);
            return peProtClearagFa;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.makeProtClearagFa", (Throwable)e);
            return null;
        }
    }

    private List<PeProtClearagFa> queryProtClearagFaModelPage(Map<String, Object> parammap) {
        try {
            return this.peProtClearagFaMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.queryProtClearagFaModel", (Throwable)e);
            return null;
        }
    }

    private int countProtClearagFa(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peProtClearagFaMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.countProtClearagFa", (Throwable)e);
        }
        return i;
    }

    private String checkProtClearagCycle(PeProtClearagCycleDomain peProtClearagCycleDomain) {
        if (null == peProtClearagCycleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProtClearagCycleDefault(PeProtClearagCycle peProtClearagCycle) {
        if (null == peProtClearagCycle) {
            return;
        }
        if (null == peProtClearagCycle.getDataState()) {
            peProtClearagCycle.setDataState(0);
        }
        if (null == peProtClearagCycle.getGmtCreate()) {
            peProtClearagCycle.setGmtCreate(this.getSysDate());
        }
        peProtClearagCycle.setGmtModified(this.getSysDate());
    }

    private int getProtClearagCycleMaxCode() {
        int code = 0;
        try {
            return this.peProtClearagCycleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearagCycleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProtClearagCycleUpdataDefault(PeProtClearagCycle peProtClearagCycle) {
        if (null == peProtClearagCycle) {
            return;
        }
        peProtClearagCycle.setGmtModified(this.getSysDate());
    }

    private void saveProtClearagCycleModel(PeProtClearagCycle peProtClearagCycle) throws ApiException {
        if (null == peProtClearagCycle) {
            return;
        }
        try {
            this.peProtClearagCycleMapper.insert(peProtClearagCycle);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.saveProtClearagCycleModel.ex", (Throwable)e);
        }
    }

    private PeProtClearagCycle getProtClearagCycleModelById(Integer protClearagCycleId) {
        if (null == protClearagCycleId) {
            return null;
        }
        try {
            return this.peProtClearagCycleMapper.selectByPrimaryKey(protClearagCycleId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearagCycleModelById", (Throwable)e);
            return null;
        }
    }

    public PeProtClearagCycle getProtClearagCycleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peProtClearagCycleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearagCycleModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProtClearagCycleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtClearagCycleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.delProtClearagCycleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtClearagServiceImpl.delProtClearagCycleModelByCode.num");
        }
    }

    private void deleteProtClearagCycleModel(Integer protClearagCycleId) throws ApiException {
        if (null == protClearagCycleId) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtClearagCycleMapper.deleteByPrimaryKey(protClearagCycleId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.deleteProtClearagCycleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtClearagServiceImpl.deleteProtClearagCycleModel.num");
        }
    }

    private void updateProtClearagCycleModel(PeProtClearagCycle peProtClearagCycle) throws ApiException {
        if (null == peProtClearagCycle) {
            return;
        }
        try {
            this.peProtClearagCycleMapper.updateByPrimaryKeySelective(peProtClearagCycle);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearagCycleModel.ex", (Throwable)e);
        }
    }

    private void updateStateProtClearagCycleModel(Integer protClearagCycleId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == protClearagCycleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protClearagCycleId", protClearagCycleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peProtClearagCycleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearagCycleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearagCycleModel.null");
        }
    }

    private PeProtClearagCycle makeProtClearagCycle(PeProtClearagCycleDomain peProtClearagCycleDomain, PeProtClearagCycle peProtClearagCycle) {
        if (null == peProtClearagCycleDomain) {
            return null;
        }
        if (null == peProtClearagCycle) {
            peProtClearagCycle = new PeProtClearagCycle();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peProtClearagCycle, (Object)peProtClearagCycleDomain);
            return peProtClearagCycle;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.makeProtClearagCycle", (Throwable)e);
            return null;
        }
    }

    private List<PeProtClearagCycle> queryProtClearagCycleModelPage(Map<String, Object> parammap) {
        try {
            return this.peProtClearagCycleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.queryProtClearagCycleModel", (Throwable)e);
            return null;
        }
    }

    private int countProtClearagCycle(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peProtClearagCycleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.countProtClearagCycle", (Throwable)e);
        }
        return i;
    }

    private String checkProtClearinfo(PeProtClearinfoDomain peProtClearinfoDomain) {
        if (null == peProtClearinfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProtClearinfoDefault(PeProtClearinfo peProtClearinfo) {
        if (null == peProtClearinfo) {
            return;
        }
        if (null == peProtClearinfo.getDataState()) {
            peProtClearinfo.setDataState(0);
        }
        if (null == peProtClearinfo.getGmtCreate()) {
            peProtClearinfo.setGmtCreate(this.getSysDate());
        }
        peProtClearinfo.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)peProtClearinfo.getProtClearinfoSeqno())) {
            peProtClearinfo.setProtClearinfoSeqno(this.createUUIDString());
        }
    }

    private int getProtClearinfoMaxCode() {
        int code = 0;
        try {
            return this.peProtClearinfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearinfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProtClearinfoUpdataDefault(PeProtClearinfo peProtClearinfo) {
        if (null == peProtClearinfo) {
            return;
        }
        peProtClearinfo.setGmtModified(this.getSysDate());
    }

    private void saveProtClearinfoModel(PeProtClearinfo peProtClearinfo) throws ApiException {
        if (null == peProtClearinfo) {
            return;
        }
        try {
            this.peProtClearinfoMapper.insert(peProtClearinfo);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.saveProtClearinfoModel.ex", (Throwable)e);
        }
    }

    private void saveBatchProtClearinfoModel(List<PeProtClearinfo> peProtClearinfoList) throws ApiException {
        if (null == peProtClearinfoList || peProtClearinfoList.isEmpty()) {
            return;
        }
        try {
            this.peProtClearinfoMapper.insertBatch(peProtClearinfoList);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.saveProtClearinfoModel.ex", (Throwable)e);
        }
    }

    private PeProtClearinfo getProtClearinfoModelById(Integer protClearinfoId) {
        if (null == protClearinfoId) {
            return null;
        }
        try {
            return this.peProtClearinfoMapper.selectByPrimaryKey(protClearinfoId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearinfoModelById", (Throwable)e);
            return null;
        }
    }

    public PeProtClearinfo getProtClearinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peProtClearinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.getProtClearinfoModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProtClearinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtClearinfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.delProtClearinfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtClearagServiceImpl.delProtClearinfoModelByCode.num");
        }
    }

    private void deleteProtClearinfoModel(Integer protClearinfoId) throws ApiException {
        if (null == protClearinfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtClearinfoMapper.deleteByPrimaryKey(protClearinfoId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.deleteProtClearinfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtClearagServiceImpl.deleteProtClearinfoModel.num");
        }
    }

    private void updateProtClearinfoModel(PeProtClearinfo peProtClearinfo) throws ApiException {
        if (null == peProtClearinfo) {
            return;
        }
        try {
            this.peProtClearinfoMapper.updateByPrimaryKeySelective(peProtClearinfo);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearinfoModel.ex", (Throwable)e);
        }
    }

    private void updateStateProtClearinfoModel(Integer protClearinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == protClearinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protClearinfoId", protClearinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peProtClearinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearinfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearinfoModel.null");
        }
    }

    private void updateStateProtClearinfoModelByCode(String protClearinfoSeqno, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)protClearinfoSeqno) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protClearinfoSeqno", protClearinfoSeqno);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peProtClearinfoMapper.updateStateCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearinfoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearinfoModelByCode.null", ((Object)map).toString());
        }
    }

    private void updateStateProtClearinfoModelByEtc(String protEtcSeqno, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == protEtcSeqno || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protEtcSeqno", protEtcSeqno);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peProtClearinfoMapper.updateStateByEtc(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearinfoModelByEtc.ex", (Throwable)e);
        }
        if (i < 0) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateStateProtClearinfoModelByEtc.null");
        }
    }

    private PeProtClearinfo makeProtClearinfo(PeProtClearinfoDomain peProtClearinfoDomain, PeProtClearinfo peProtClearinfo) {
        if (null == peProtClearinfoDomain) {
            return null;
        }
        if (null == peProtClearinfo) {
            peProtClearinfo = new PeProtClearinfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peProtClearinfo, (Object)peProtClearinfoDomain);
            peProtClearinfo.setClearAsync(peProtClearinfoDomain.isClearAsync());
            return peProtClearinfo;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.makeProtClearinfo", (Throwable)e);
            return null;
        }
    }

    private List<PeProtClearinfo> queryProtClearinfoModelPage(Map<String, Object> parammap) {
        try {
            return this.peProtClearinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.queryProtClearinfoModel", (Throwable)e);
            return null;
        }
    }

    private int countProtClearinfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peProtClearinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.countProtClearinfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveProtClearag(PeProtClearagDomain peProtClearagDomain) throws ApiException {
        String msg = this.checkProtClearag(peProtClearagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtClearagServiceImpl.saveProtClearag.checkProtClearag", msg);
        }
        PeProtClearag peProtClearag = this.makeProtClearag(peProtClearagDomain, null);
        this.setProtClearagDefault(peProtClearag);
        this.saveProtClearagModel(peProtClearag);
    }

    @Override
    public void updateProtClearagState(Integer protClearagId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProtClearagModel(protClearagId, dataState, oldDataState);
    }

    @Override
    public void updateProtClearag(PeProtClearagDomain peProtClearagDomain) throws ApiException {
        String msg = this.checkProtClearag(peProtClearagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearag.checkProtClearag", msg);
        }
        PeProtClearag oldPeProtClearag = this.getProtClearagModelById(peProtClearagDomain.getProtClearagId());
        if (null == oldPeProtClearag) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearag.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeProtClearag peProtClearag = this.makeProtClearag(peProtClearagDomain, oldPeProtClearag);
        this.setProtClearagUpdataDefault(peProtClearag);
        this.updateProtClearagModel(peProtClearag);
    }

    @Override
    public PeProtClearag getProtClearag(Integer protClearagId) {
        return this.getProtClearagModelById(protClearagId);
    }

    @Override
    public void deleteProtClearag(Integer protClearagId) throws ApiException {
        this.deleteProtClearagModel(protClearagId);
    }

    @Override
    public QueryResult<PeProtClearag> queryProtClearagPage(Map<String, Object> map) {
        List<PeProtClearag> peProtClearagList = this.queryProtClearagModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProtClearag(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peProtClearagList);
        return queryResult;
    }

    @Override
    public void saveProtClearagFa(PeProtClearagFaDomain peProtClearagFaDomain) throws ApiException {
        String msg = this.checkProtClearagFa(peProtClearagFaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtClearagServiceImpl.saveProtClearagFa.checkProtClearagFa", msg);
        }
        PeProtClearagFa peProtClearagFa = this.makeProtClearagFa(peProtClearagFaDomain, null);
        this.setProtClearagFaDefault(peProtClearagFa);
        this.saveProtClearagFaModel(peProtClearagFa);
    }

    @Override
    public void updateProtClearagFaState(Integer protClearagFaId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProtClearagFaModel(protClearagFaId, dataState, oldDataState);
    }

    @Override
    public void updateProtClearagFa(PeProtClearagFaDomain peProtClearagFaDomain) throws ApiException {
        String msg = this.checkProtClearagFa(peProtClearagFaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearagFa.checkProtClearagFa", msg);
        }
        PeProtClearagFa oldPeProtClearagFa = this.getProtClearagFaModelById(peProtClearagFaDomain.getProtClearagFaId());
        if (null == oldPeProtClearagFa) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearagFa.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeProtClearagFa peProtClearagFa = this.makeProtClearagFa(peProtClearagFaDomain, oldPeProtClearagFa);
        this.setProtClearagFaUpdataDefault(peProtClearagFa);
        this.updateProtClearagFaModel(peProtClearagFa);
    }

    @Override
    public PeProtClearagFa getProtClearagFa(Integer protClearagFaId) {
        return this.getProtClearagFaModelById(protClearagFaId);
    }

    @Override
    public void deleteProtClearagFa(Integer protClearagFaId) throws ApiException {
        this.deleteProtClearagFaModel(protClearagFaId);
    }

    @Override
    public QueryResult<PeProtClearagFa> queryProtClearagFaPage(Map<String, Object> map) {
        List<PeProtClearagFa> peProtClearagFaList = this.queryProtClearagFaModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProtClearagFa(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peProtClearagFaList);
        return queryResult;
    }

    @Override
    public void saveProtClearagCycle(PeProtClearagCycleDomain peProtClearagCycleDomain) throws ApiException {
        String msg = this.checkProtClearagCycle(peProtClearagCycleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtClearagServiceImpl.saveProtClearagCycle.checkProtClearagCycle", msg);
        }
        PeProtClearagCycle peProtClearagCycle = this.makeProtClearagCycle(peProtClearagCycleDomain, null);
        this.setProtClearagCycleDefault(peProtClearagCycle);
        this.saveProtClearagCycleModel(peProtClearagCycle);
    }

    @Override
    public void updateProtClearagCycleState(Integer protClearagCycleId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProtClearagCycleModel(protClearagCycleId, dataState, oldDataState);
    }

    @Override
    public void updateProtClearagCycle(PeProtClearagCycleDomain peProtClearagCycleDomain) throws ApiException {
        String msg = this.checkProtClearagCycle(peProtClearagCycleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearagCycle.checkProtClearagCycle", msg);
        }
        PeProtClearagCycle oldPeProtClearagCycle = this.getProtClearagCycleModelById(peProtClearagCycleDomain.getProtClearagCycleId());
        if (null == oldPeProtClearagCycle) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearagCycle.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeProtClearagCycle peProtClearagCycle = this.makeProtClearagCycle(peProtClearagCycleDomain, oldPeProtClearagCycle);
        this.setProtClearagCycleUpdataDefault(peProtClearagCycle);
        this.updateProtClearagCycleModel(peProtClearagCycle);
    }

    @Override
    public PeProtClearagCycle getProtClearagCycle(Integer protClearagCycleId) {
        return this.getProtClearagCycleModelById(protClearagCycleId);
    }

    @Override
    public void deleteProtClearagCycle(Integer protClearagCycleId) throws ApiException {
        this.deleteProtClearagCycleModel(protClearagCycleId);
    }

    @Override
    public QueryResult<PeProtClearagCycle> queryProtClearagCyclePage(Map<String, Object> map) {
        List<PeProtClearagCycle> peProtClearagCycleList = this.queryProtClearagCycleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProtClearagCycle(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peProtClearagCycleList);
        return queryResult;
    }

    @Override
    public PeProtClearinfo saveProtClearinfo(PeProtClearinfoDomain peProtClearinfoDomain) throws ApiException {
        PeProtClearinfo peProtClearinfo = this.createClearinfo(peProtClearinfoDomain);
        this.saveProtClearinfoModel(peProtClearinfo);
        return peProtClearinfo;
    }

    private PeProtClearinfo createClearinfo(PeProtClearinfoDomain peProtClearinfoDomain) {
        String msg = this.checkProtClearinfo(peProtClearinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtClearagServiceImpl.createClearinfo.checkProtClearinfo", msg);
        }
        PeProtClearinfo peProtClearinfo = this.makeProtClearinfo(peProtClearinfoDomain, null);
        this.setProtClearinfoDefault(peProtClearinfo);
        return peProtClearinfo;
    }

    @Override
    public List<PeProtClearinfo> saveProtClearinfoBatch(List<PeProtClearinfoDomain> peProtClearinfoDomainList) throws ApiException {
        if (null == peProtClearinfoDomainList || peProtClearinfoDomainList.isEmpty()) {
            throw new ApiException("pe.PeProtClearagServiceImpl.saveProtClearinfoBatch.null", "null");
        }
        ArrayList<PeProtClearinfo> peProtClearinfoList = new ArrayList<PeProtClearinfo>();
        for (PeProtClearinfoDomain peProtClearinfoDomain : peProtClearinfoDomainList) {
            peProtClearinfoList.add(this.createClearinfo(peProtClearinfoDomain));
        }
        this.saveBatchProtClearinfoModel(peProtClearinfoList);
        return peProtClearinfoList;
    }

    @Override
    public void updateProtClearinfoState(Integer protClearinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProtClearinfoModel(protClearinfoId, dataState, oldDataState);
    }

    @Override
    public void updateProtClearinfoStateByEtc(String protEtcSeqno, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProtClearinfoModelByEtc(protEtcSeqno, dataState, oldDataState);
    }

    @Override
    public void updateProtClearinfo(PeProtClearinfoDomain peProtClearinfoDomain) throws ApiException {
        String msg = this.checkProtClearinfo(peProtClearinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearinfo.checkProtClearinfo", msg);
        }
        PeProtClearinfo oldPeProtClearinfo = this.getProtClearinfoModelById(peProtClearinfoDomain.getProtClearinfoId());
        if (null == oldPeProtClearinfo) {
            throw new ApiException("pe.PeProtClearagServiceImpl.updateProtClearinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeProtClearinfo peProtClearinfo = this.makeProtClearinfo(peProtClearinfoDomain, oldPeProtClearinfo);
        this.setProtClearinfoUpdataDefault(peProtClearinfo);
        this.updateProtClearinfoModel(peProtClearinfo);
    }

    @Override
    public PeProtClearinfo getProtClearinfo(Integer protClearinfoId) {
        return this.getProtClearinfoModelById(protClearinfoId);
    }

    @Override
    public void deleteProtClearinfo(Integer protClearinfoId) throws ApiException {
        this.deleteProtClearinfoModel(protClearinfoId);
    }

    @Override
    public QueryResult<PeProtClearinfo> queryProtClearinfoPage(Map<String, Object> map) {
        List<PeProtClearinfo> peProtClearinfoList = this.queryProtClearinfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProtClearinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peProtClearinfoList);
        return queryResult;
    }

    @Override
    public void saveProtClearinfoNext(List<PeReorderDomain> peReorderDomainList) {
        if (null == peReorderDomainList || peReorderDomainList.isEmpty()) {
            return;
        }
        Integer dataState = 1;
        Integer oldDataState = 0;
        for (PeReorderDomain peReorderDomain : peReorderDomainList) {
            this.updateStateProtClearinfoModelByCode(peReorderDomain.getOrderCode(), peReorderDomain.getTenantCode(), dataState, oldDataState);
        }
    }

    @Override
    public void queryProtClearagCache() {
        this.info("pe.PeProtClearagServiceImpl.queryProtClearagCache.start", "=======\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1L);
        List<PeProtClearag> clearagList = this.queryProtClearagModelPage(params);
        if (CollectionUtils.isEmpty(clearagList)) {
            DisUtil.delVer((String)CACHE_KEY_CLEARAG);
            this.info("pe.PeProtClearagServiceImpl.queryProtClearagCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        String key = "";
        for (PeProtClearag peProtClearag : clearagList) {
            PeProtClearagReDomain peProtClearagReDomain = this.makeClearagReDomain(peProtClearag);
            if (StringUtils.isBlank((String)peProtClearag.getProtClearagType())) {
                peProtClearag.setProtClearagType("*");
            }
            if (StringUtils.isBlank((String)peProtClearag.getProtClearagTid())) {
                peProtClearag.setProtClearagTid("*");
            }
            key = key + peProtClearag.getTenantCode();
            key = key + "-" + peProtClearag.getProtClearagType() + "-" + peProtClearag.getProtClearagTid();
            mmap.put(key, JsonUtil.buildNormalBinder().toJson((Object)peProtClearagReDomain));
        }
        DisUtil.setMap((String)CACHE_KEY_CLEARAG, mmap);
        this.info("pe.PeProtClearagServiceImpl.queryProtClearagCache.end", "=======\u8c03\u5ea6end=======");
    }

    private void updateCache(PeProtClearag peProtClearag) {
        if (null == peProtClearag) {
            return;
        }
        String key = "";
        key = key + peProtClearag.getTenantCode();
        key = key + "-" + peProtClearag.getProtClearagType() + "-" + peProtClearag.getProtClearagTid();
        Map mmap = DisUtil.getMapAll((String)CACHE_KEY_CLEARAG);
        mmap.put(key, JsonUtil.buildNormalBinder().toJson((Object)this.makeClearagReDomain(peProtClearag)));
        DisUtil.setMap((String)CACHE_KEY_CLEARAG, (Map)mmap);
    }

    private void delCache(PeProtClearag peProtClearag) {
        if (null == peProtClearag) {
            return;
        }
        String key = "";
        key = key + peProtClearag.getTenantCode();
        key = key + "-" + peProtClearag.getProtClearagType() + "-" + peProtClearag.getProtClearagTid();
        Map mmap = DisUtil.getMapAll((String)CACHE_KEY_CLEARAG);
        mmap.remove(key);
        DisUtil.setMap((String)CACHE_KEY_CLEARAG, (Map)mmap);
    }

    private PeProtClearagReDomain makeClearagReDomain(PeProtClearag peProtClearag) {
        if (null == peProtClearag) {
            return null;
        }
        PeProtClearagReDomain peProtClearagReDomain = new PeProtClearagReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peProtClearagReDomain, (Object)peProtClearag);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.makeClearagReDomain.e", (Throwable)e);
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("protClearagCode", peProtClearag.getProtClearagCode());
        params.put("tenantCode", peProtClearag.getTenantCode());
        List<PeProtClearagCycle> cycleList = this.queryProtClearagCycleModelPage(params);
        peProtClearagReDomain.setCycleReDomainList(this.makeCycleReDomainList(cycleList));
        List<PeProtClearagFa> faList = this.queryProtClearagFaModelPage(params);
        peProtClearagReDomain.setFaReDomainList(this.makeFaReDomainList(faList));
        return peProtClearagReDomain;
    }

    private List<PeProtClearagCycleReDomain> makeCycleReDomainList(List<PeProtClearagCycle> cycleList) {
        if (null == cycleList || cycleList.isEmpty()) {
            return null;
        }
        ArrayList<PeProtClearagCycleReDomain> cycleReDomainList = new ArrayList<PeProtClearagCycleReDomain>();
        for (PeProtClearagCycle peProtClearagCycle : cycleList) {
            cycleReDomainList.add(this.makeCycleReDomain(peProtClearagCycle));
        }
        return cycleReDomainList;
    }

    private PeProtClearagCycleReDomain makeCycleReDomain(PeProtClearagCycle peProtClearagCycle) {
        if (null == peProtClearagCycle) {
            return null;
        }
        PeProtClearagCycleReDomain peProtClearagCycleReDomain = new PeProtClearagCycleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peProtClearagCycleReDomain, (Object)peProtClearagCycle);
            return peProtClearagCycleReDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.makeCycleReDomain.e", (Throwable)e);
            return null;
        }
    }

    private List<PeProtClearagFaReDomain> makeFaReDomainList(List<PeProtClearagFa> faList) {
        if (null == faList || faList.isEmpty()) {
            return null;
        }
        ArrayList<PeProtClearagFaReDomain> faReDomainList = new ArrayList<PeProtClearagFaReDomain>();
        for (PeProtClearagFa peProtClearagFa : faList) {
            faReDomainList.add(this.makeFaReDomain(peProtClearagFa));
        }
        return faReDomainList;
    }

    private PeProtClearagFaReDomain makeFaReDomain(PeProtClearagFa peProtClearagFa) {
        if (null == peProtClearagFa) {
            return null;
        }
        PeProtClearagFaReDomain peProtClearagFaReDomain = new PeProtClearagFaReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peProtClearagFaReDomain, (Object)peProtClearagFa);
            return peProtClearagFaReDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtClearagServiceImpl.makeFaReDomain.e", (Throwable)e);
            return null;
        }
    }
}

