/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.dao.UpOpdataMapper;
import com.yqbsoft.laser.service.permis.dao.UpOpdatascMapper;
import com.yqbsoft.laser.service.permis.domain.OrgDepartReDomain;
import com.yqbsoft.laser.service.permis.domain.UpOpdataDomainBean;
import com.yqbsoft.laser.service.permis.domain.UpOpdataListDomain;
import com.yqbsoft.laser.service.permis.domain.UpOpdataReDomainBean;
import com.yqbsoft.laser.service.permis.domain.UpOpdatascDomainBean;
import com.yqbsoft.laser.service.permis.domain.UpOpdatascReDomainBean;
import com.yqbsoft.laser.service.permis.model.UpOpdata;
import com.yqbsoft.laser.service.permis.model.UpOpdataList;
import com.yqbsoft.laser.service.permis.model.UpOpdatasc;
import com.yqbsoft.laser.service.permis.service.UpOpdataListService;
import com.yqbsoft.laser.service.permis.service.UpOpdataService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UpOpdataServiceImpl
extends BaseServiceImpl
implements UpOpdataService {
    private static final String SYS_CODE = "up.PERMIS.UpOpdataServiceImpl";
    private UpOpdataMapper upOpdataMapper;
    private UpOpdatascMapper upOpdatascMapper;
    private UpOpdataListService upOpdataListService;
    private String cachekey = "UpOpdata-opdatascsType";
    static Map<String, String> TABLE_CL = new HashMap<String, String>();

    public void setUpOpdataMapper(UpOpdataMapper upOpdataMapper) {
        this.upOpdataMapper = upOpdataMapper;
    }

    public void setUpOpdatascMapper(UpOpdatascMapper upOpdatascMapper) {
        this.upOpdatascMapper = upOpdatascMapper;
    }

    public UpOpdataListService getUpOpdataListService() {
        if (null == this.upOpdataListService) {
            this.upOpdataListService = (UpOpdataListService)ApplicationContextUtil.getService((String)"upOpdataListService");
        }
        return this.upOpdataListService;
    }

    private Date getSysDate() {
        try {
            return this.upOpdataMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpdata(UpOpdataDomainBean upOpdataDomainBean) {
        if (null == upOpdataDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upOpdataDomainBean.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpdataDefault(UpOpdata upOpdata) {
        if (null == upOpdata) {
            return;
        }
        if (null == upOpdata.getDataState()) {
            upOpdata.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == upOpdata.getGmtCreate()) {
            upOpdata.setGmtCreate(date);
        }
        upOpdata.setGmtModified(date);
        if (StringUtils.isBlank((String)upOpdata.getOpdataCode())) {
            upOpdata.setOpdataCode(this.getNo(null, "UpOpdata", "upOpdata", upOpdata.getTenantCode()));
        }
    }

    private int getOpdataMaxCode() {
        int code = 0;
        try {
            return this.upOpdataMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.getOpdataMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpdataUpdataDefault(UpOpdata upOpdata) {
        if (null == upOpdata) {
            return;
        }
        upOpdata.setGmtModified(this.getSysDate());
    }

    private void saveOpdataModel(UpOpdata upOpdata) throws ApiException {
        if (null == upOpdata) {
            return;
        }
        try {
            this.upOpdataMapper.insert(upOpdata);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.saveOpdataModel.ex", (Throwable)e);
        }
    }

    public void saveOpdataBatchModel(List<UpOpdata> upOpdataList) throws ApiException {
        if (null == upOpdataList || upOpdataList.isEmpty()) {
            return;
        }
        try {
            this.upOpdataMapper.insertBatch(upOpdataList);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.saveOpdataBatchModel.ex", (Throwable)e);
        }
    }

    private UpOpdata getOpdataModelById(Integer opdataId) {
        if (null == opdataId) {
            return null;
        }
        try {
            return this.upOpdataMapper.selectByPrimaryKey(opdataId);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.getOpdataModelById", (Throwable)e);
            return null;
        }
    }

    private UpOpdata getOpdataModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upOpdataMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.getOpdataModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpdataModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdataMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.delOpdataModelByCode.ex", (Throwable)e);
        }
    }

    private void deleteOpdataModel(Integer opdataId) throws ApiException {
        if (null == opdataId) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdataMapper.deleteByPrimaryKey(opdataId);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.deleteOpdataModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.deleteOpdataModel.num");
        }
    }

    private void updateOpdataModel(UpOpdata upOpdata) throws ApiException {
        if (null == upOpdata) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdataMapper.updateByPrimaryKey(upOpdata);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateOpdataModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateOpdataModel.num");
        }
    }

    private void updateStateOpdataModel(Integer opdataId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opdataId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opdataId", opdataId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upOpdataMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateStateOpdataModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateStateOpdataModel.null");
        }
    }

    private void updateStateOpdataModelByCode(String tenantCode, String opdataCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opdataCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdataCode", opdataCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upOpdataMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateStateOpdataModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateStateOpdataModelByCode.null");
        }
    }

    private UpOpdata makeOpdata(UpOpdataDomainBean upOpdataDomainBean, UpOpdata upOpdata) {
        if (null == upOpdataDomainBean) {
            return null;
        }
        if (null == upOpdata) {
            upOpdata = new UpOpdata();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upOpdata, (Object)upOpdataDomainBean);
            return upOpdata;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.makeOpdata", (Throwable)e);
            return null;
        }
    }

    private UpOpdataReDomainBean makeUpOpdataReDomainBean(UpOpdata upOpdata) {
        if (null == upOpdata) {
            return null;
        }
        UpOpdataReDomainBean upOpdataReDomainBean = new UpOpdataReDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)upOpdataReDomainBean, (Object)upOpdata);
            List<UpOpdatasc> scList = this.queryOpdatascModelPage(this.getQueryMapParam("opdataCode,tenantCode", new Object[]{upOpdata.getOpdataCode(), upOpdata.getTenantCode()}));
            if (ListUtil.isNotEmpty(scList)) {
                ArrayList<UpOpdatascDomainBean> upOpdatascDomainBeanList = new ArrayList<UpOpdatascDomainBean>();
                for (UpOpdatasc upOpdatasc : scList) {
                    upOpdatascDomainBeanList.add(this.makeUpOpdatascDomain(upOpdatasc));
                }
                upOpdataReDomainBean.setUpOpdatascDomainBeanList(upOpdatascDomainBeanList);
            }
            return upOpdataReDomainBean;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.makeUpOpdataReDomainBean", (Throwable)e);
            return null;
        }
    }

    private UpOpdatascDomainBean makeUpOpdatascDomain(UpOpdatasc upOpdatasc) {
        if (null == upOpdatasc) {
            return null;
        }
        UpOpdatascDomainBean upOpdatascDomainBean = new UpOpdatascDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)upOpdatascDomainBean, (Object)upOpdatasc);
            return upOpdatascDomainBean;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<UpOpdata> queryOpdataModelPage(Map<String, Object> parammap) {
        try {
            return this.upOpdataMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.queryOpdataModel", (Throwable)e);
            return null;
        }
    }

    private int countOpdata(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upOpdataMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.countOpdata", (Throwable)e);
        }
        return i;
    }

    private UpOpdata createUpOpdata(UpOpdataDomainBean upOpdataDomainBean) {
        String msg = this.checkOpdata(upOpdataDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.saveOpdata.checkOpdata", msg);
        }
        UpOpdata upOpdata = this.makeOpdata(upOpdataDomainBean, null);
        this.setOpdataDefault(upOpdata);
        return upOpdata;
    }

    @Override
    public String saveOpdata(UpOpdataDomainBean upOpdataDomainBean) throws ApiException {
        UpOpdata upOpdata = this.createUpOpdata(upOpdataDomainBean);
        this.saveOpdataModel(upOpdata);
        this.saveUpOpdatascDomainBeanList(upOpdata, upOpdataDomainBean.getUpOpdatascDomainBeanList());
        this.saveUpOpdataListDomainBeanList(upOpdata, upOpdataDomainBean.getUpOpdataListDomainList());
        upOpdataDomainBean.setOpdataCode(upOpdata.getOpdataCode());
        this.updateUpOpdataCache(upOpdata);
        return upOpdata.getOpdataCode();
    }

    private void saveUpOpdataListDomainBeanList(UpOpdata upOpdata, List<UpOpdataListDomain> upOpdataListDomainBeanList) {
        if (null == upOpdata || ListUtil.isEmpty(upOpdataListDomainBeanList)) {
            return;
        }
        for (UpOpdataListDomain upOpdataListDomain : upOpdataListDomainBeanList) {
            upOpdataListDomain.setTenantCode(upOpdata.getTenantCode());
            upOpdataListDomain.setOpdataCode(upOpdata.getOpdataCode());
        }
        this.getUpOpdataListService().saveOpdataListBatch(upOpdataListDomainBeanList);
    }

    private void saveUpOpdatascDomainBeanList(UpOpdata upOpdata, List<UpOpdatascDomainBean> upOpdatascDomainBeanList) {
        if (null == upOpdata || ListUtil.isEmpty(upOpdatascDomainBeanList)) {
            return;
        }
        for (UpOpdatascDomainBean upOpdatascDomainBean : upOpdatascDomainBeanList) {
            upOpdatascDomainBean.setTenantCode(upOpdata.getTenantCode());
            upOpdatascDomainBean.setOpdataCode(upOpdata.getOpdataCode());
        }
        this.saveOpdatascBatch(upOpdatascDomainBeanList);
    }

    @Override
    public String saveOpdataBatch(List<UpOpdataDomainBean> upOpdataDomainBeanList) throws ApiException {
        if (null == upOpdataDomainBeanList || upOpdataDomainBeanList.isEmpty()) {
            return null;
        }
        String code = "";
        for (UpOpdataDomainBean upOpdataDomainBean : upOpdataDomainBeanList) {
            code = this.saveOpdata(upOpdataDomainBean);
        }
        return code;
    }

    @Override
    public void updateOpdataState(Integer opdataId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opdataId) {
            return;
        }
        this.updateStateOpdataModel(opdataId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpdataStateByCode(String tenantCode, String opdataCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opdataCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpdataModelByCode(tenantCode, opdataCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpdata(UpOpdataDomainBean upOpdataDomainBean) throws ApiException {
        String msg = this.checkOpdata(upOpdataDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateOpdata.checkOpdata", msg);
        }
        UpOpdata oldUpOpdata = this.getOpdataModelById(upOpdataDomainBean.getOpdataId());
        if (null == oldUpOpdata) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateOpdata.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpOpdata upOpdata = this.makeOpdata(upOpdataDomainBean, oldUpOpdata);
        this.setOpdataUpdataDefault(upOpdata);
        this.updateOpdataModel(upOpdata);
        this.updateUpOpdataCache(upOpdata);
    }

    @Override
    public UpOpdataReDomainBean getOpdata(Integer opdataId) {
        if (null == opdataId) {
            return null;
        }
        UpOpdataReDomainBean upOpdataReDomainBean = this.makeUpOpdataReDomainBean(this.getOpdataModelById(opdataId));
        return upOpdataReDomainBean;
    }

    @Override
    public void deleteOpdata(Integer opdataId) throws ApiException {
        if (null == opdataId) {
            return;
        }
        this.deleteOpdataModel(opdataId);
        this.deleteUpOpdataCache(this.getOpdata(opdataId));
    }

    @Override
    public QueryResult<UpOpdata> queryOpdataPage(Map<String, Object> map) {
        List<UpOpdata> upOpdataList = this.queryOpdataModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpdata(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        if (ListUtil.isNotEmpty(upOpdataList)) {
            for (UpOpdata upOpdata : upOpdataList) {
                QueryResult<UpOpdatasc> upOpdatascQueryResult = this.queryOpdatascPage(this.getQueryParamMap("tenantCode,opdataCode", new Object[]{upOpdata.getTenantCode(), upOpdata.getOpdataCode()}));
                if (!ListUtil.isNotEmpty((Collection)upOpdatascQueryResult.getList())) continue;
                upOpdata.setUpOpdatascDomainBeanList(upOpdatascQueryResult.getList());
            }
        }
        queryResult.setList(upOpdataList);
        return queryResult;
    }

    @Override
    public UpOpdataReDomainBean getOpdataByCode(String tenantCode, String opdataCode) throws ApiException {
        if (StringUtils.isBlank((String)opdataCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdataCode", opdataCode);
        return this.makeUpOpdataReDomainBean(this.getOpdataModelByCode(map));
    }

    @Override
    public void deleteOpdataByCode(String tenantCode, String opdataCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdataCode", opdataCode);
        this.delOpdataModelByCode(map);
        if (StringUtils.isNotBlank((String)opdataCode)) {
            this.deleteUpOpdataCache(this.getOpdataByCode(tenantCode, opdataCode));
        }
    }

    private String checkOpdatasc(UpOpdatascDomainBean upOpdatascDomainBean) {
        if (null == upOpdatascDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upOpdatascDomainBean.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpdatascDefault(UpOpdatasc upOpdatasc) {
        if (null == upOpdatasc) {
            return;
        }
        if (null == upOpdatasc.getDataState()) {
            upOpdatasc.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == upOpdatasc.getGmtCreate()) {
            upOpdatasc.setGmtCreate(date);
        }
        upOpdatasc.setGmtModified(date);
        if (StringUtils.isBlank((String)upOpdatasc.getOpdatascCode())) {
            upOpdatasc.setOpdatascCode(this.getNo(null, "UpOpdatasc", "upOpdatasc", upOpdatasc.getTenantCode()));
        }
    }

    private int getOpdatascMaxCode() {
        int code = 0;
        try {
            return this.upOpdatascMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.getOpdatascMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpdatascUpdataDefault(UpOpdatasc upOpdatasc) {
        if (null == upOpdatasc) {
            return;
        }
        upOpdatasc.setGmtModified(this.getSysDate());
    }

    private void saveOpdatascModel(UpOpdatasc upOpdatasc) throws ApiException {
        if (null == upOpdatasc) {
            return;
        }
        try {
            this.upOpdatascMapper.insert(upOpdatasc);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.saveOpdatascModel.ex", (Throwable)e);
        }
    }

    private void saveOpdatascBatchModel(List<UpOpdatasc> upOpdatascList) throws ApiException {
        if (null == upOpdatascList || upOpdatascList.isEmpty()) {
            return;
        }
        try {
            this.upOpdatascMapper.insertBatch(upOpdatascList);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.saveOpdatascBatchModel.ex", (Throwable)e);
        }
    }

    private UpOpdatasc getOpdatascModelById(Integer opdatascId) {
        if (null == opdatascId) {
            return null;
        }
        try {
            return this.upOpdatascMapper.selectByPrimaryKey(opdatascId);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.getOpdatascModelById", (Throwable)e);
            return null;
        }
    }

    private UpOpdatasc getOpdatascModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upOpdatascMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.getOpdatascModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpdatascModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdatascMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.delOpdatascModelByCode.ex", (Throwable)e);
        }
    }

    private void deleteOpdatascModel(Integer opdatascId) throws ApiException {
        if (null == opdatascId) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdatascMapper.deleteByPrimaryKey(opdatascId);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.deleteOpdatascModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.deleteOpdatascModel.num");
        }
    }

    private void updateOpdatascModel(UpOpdatasc upOpdatasc) throws ApiException {
        if (null == upOpdatasc) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdatascMapper.updateByPrimaryKey(upOpdatasc);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateOpdatascModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateOpdatascModel.num");
        }
    }

    private void updateStateOpdatascModel(Integer opdatascId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opdatascId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opdatascId", opdatascId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upOpdatascMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateStateOpdatascModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateStateOpdatascModel.null");
        }
    }

    private void updateStateOpdatascModelByCode(String tenantCode, String opdatascCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opdatascCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdatascCode", opdatascCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upOpdatascMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateStateOpdatascModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateStateOpdatascModelByCode.null");
        }
    }

    private UpOpdatasc makeOpdatasc(UpOpdatascDomainBean upOpdatascDomainBean, UpOpdatasc upOpdatasc) {
        if (null == upOpdatascDomainBean) {
            return null;
        }
        if (null == upOpdatasc) {
            upOpdatasc = new UpOpdatasc();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upOpdatasc, (Object)upOpdatascDomainBean);
            return upOpdatasc;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.makeOpdatasc", (Throwable)e);
            return null;
        }
    }

    private UpOpdatascReDomainBean makeUpOpdatascReDomainBean(UpOpdatasc upOpdatasc) {
        if (null == upOpdatasc) {
            return null;
        }
        UpOpdatascReDomainBean upOpdatascReDomainBean = new UpOpdatascReDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)upOpdatascReDomainBean, (Object)upOpdatasc);
            return upOpdatascReDomainBean;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.makeUpOpdatascReDomainBean", (Throwable)e);
            return null;
        }
    }

    private List<UpOpdatasc> queryOpdatascModelPage(Map<String, Object> parammap) {
        try {
            return this.upOpdatascMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.queryOpdatascModel", (Throwable)e);
            return null;
        }
    }

    private int countOpdatasc(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upOpdatascMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.countOpdatasc", (Throwable)e);
        }
        return i;
    }

    private UpOpdatasc createUpOpdatasc(UpOpdatascDomainBean upOpdatascDomainBean) {
        String msg = this.checkOpdatasc(upOpdatascDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.saveOpdatasc.checkOpdatasc", msg);
        }
        UpOpdatasc upOpdatasc = this.makeOpdatasc(upOpdatascDomainBean, null);
        this.setOpdatascDefault(upOpdatasc);
        return upOpdatasc;
    }

    @Override
    public String saveOpdatasc(UpOpdatascDomainBean upOpdatascDomainBean) throws ApiException {
        UpOpdatasc upOpdatasc = this.createUpOpdatasc(upOpdatascDomainBean);
        this.saveOpdatascModel(upOpdatasc);
        return upOpdatasc.getOpdatascCode();
    }

    @Override
    public String saveOpdatascBatch(List<UpOpdatascDomainBean> upOpdatascDomainBeanList) throws ApiException {
        if (null == upOpdatascDomainBeanList || upOpdatascDomainBeanList.isEmpty()) {
            return null;
        }
        ArrayList<UpOpdatasc> upOpdatascList = new ArrayList<UpOpdatasc>();
        String code = "";
        for (UpOpdatascDomainBean upOpdatascDomainBean : upOpdatascDomainBeanList) {
            UpOpdatasc upOpdatasc = this.createUpOpdatasc(upOpdatascDomainBean);
            code = upOpdatasc.getOpdatascCode();
            upOpdatascList.add(upOpdatasc);
        }
        this.saveOpdatascBatchModel(upOpdatascList);
        return code;
    }

    @Override
    public void updateOpdatascState(Integer opdatascId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opdatascId) {
            return;
        }
        this.updateStateOpdatascModel(opdatascId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpdatascStateByCode(String tenantCode, String opdatascCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opdatascCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpdatascModelByCode(tenantCode, opdatascCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpdatasc(UpOpdatascDomainBean upOpdatascDomainBean) throws ApiException {
        String msg = this.checkOpdatasc(upOpdatascDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateOpdatasc.checkOpdatasc", msg);
        }
        UpOpdatasc oldUpOpdatasc = this.getOpdatascModelById(upOpdatascDomainBean.getOpdatascId());
        if (null == oldUpOpdatasc) {
            throw new ApiException("up.PERMIS.UpOpdataServiceImpl.updateOpdatasc.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpOpdatasc upOpdatasc = this.makeOpdatasc(upOpdatascDomainBean, oldUpOpdatasc);
        this.setOpdatascUpdataDefault(upOpdatasc);
        this.updateOpdatascModel(upOpdatasc);
    }

    @Override
    public UpOpdatasc getOpdatasc(Integer opdatascId) {
        if (null == opdatascId) {
            return null;
        }
        return this.getOpdatascModelById(opdatascId);
    }

    @Override
    public void deleteOpdatasc(Integer opdatascId) throws ApiException {
        if (null == opdatascId) {
            return;
        }
        this.deleteOpdatascModel(opdatascId);
    }

    @Override
    public QueryResult<UpOpdatasc> queryOpdatascPage(Map<String, Object> map) {
        List<UpOpdatasc> upOpdatascList = this.queryOpdatascModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpdatasc(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upOpdatascList);
        return queryResult;
    }

    @Override
    public UpOpdatasc getOpdatascByCode(String tenantCode, String opdatascCode) throws ApiException {
        if (StringUtils.isBlank((String)opdatascCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdatascCode", opdatascCode);
        return this.getOpdatascModelByCode(map);
    }

    @Override
    public void deleteOpdatascByCode(String tenantCode, String opdatascCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdatascCode", opdatascCode);
        this.delOpdatascModelByCode(map);
    }

    private String createListToStr(List<UpOpdataList> upOpdataListList) {
        if (ListUtil.isEmpty(upOpdataListList)) {
            return null;
        }
        String str = "";
        for (UpOpdataList upOpdataList : upOpdataListList) {
            if (StringUtils.isNotBlank((String)str)) {
                str = str + ",";
            }
            str = str + upOpdataList.getOpdataOpocode();
        }
        return str;
    }

    @Override
    public void queryOpdataLoadCache() {
        this.logger.info("up.PERMIS.UpOpdataServiceImpl.queryOpdataLoadCache", (Object)"=========add-start==========");
        QueryResult<UpOpdata> upOpdataQueryResult = this.queryOpdataPage(null);
        if (null == upOpdataQueryResult || ListUtil.isEmpty((Collection)upOpdataQueryResult.getList())) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("up.PERMIS.UpOpdataServiceImpl.queryOpdataLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap memberMap = new ConcurrentHashMap();
        String group = "";
        for (UpOpdata upOpdata : upOpdataQueryResult.getList()) {
            QueryResult<UpOpdataList> upOpdataListQueryResult = this.getUpOpdataListService().queryOpdataListPage(this.getQueryParamMap("tenantCode,opdataCode", new Object[]{upOpdata.getTenantCode(), upOpdata.getOpdataCode()}));
            List<UpOpdatasc> UpOpdatascList = upOpdata.getUpOpdatascDomainBeanList();
            if (ListUtil.isEmpty(UpOpdatascList) || null == upOpdataListQueryResult || ListUtil.isEmpty((Collection)upOpdataListQueryResult.getList())) continue;
            group = upOpdata.getOpdataOpotype();
            if (StringUtils.isBlank((String)group)) {
                group = "";
            }
            String cloumnkey = "";
            for (UpOpdatasc upOpdatasc : UpOpdatascList) {
                String memberKey = upOpdata.getOpdataType() + "-" + upOpdata.getOpdataOpcode() + "-" + upOpdatasc.getOpdatascsType() + "-" + upOpdata.getTenantCode();
                HashMap<String, String> memberValue = (HashMap<String, String>)memberMap.get(memberKey);
                if (null == memberValue) {
                    memberValue = new HashMap<String, String>();
                    memberMap.put(memberKey, memberValue);
                }
                if (StringUtils.isBlank((String)(group = upOpdata.getOpdataOpotype()))) {
                    group = "";
                }
                cloumnkey = upOpdatasc.getOpdatascsColumns();
                group = StringUtils.isNotBlank((String)group) ? group + "|" + cloumnkey : cloumnkey;
                memberValue.put(group, this.createListToStr(upOpdataListQueryResult.getList()));
            }
            ConcurrentHashMap<String, String> memberKeyStr = new ConcurrentHashMap<String, String>();
            for (String key : memberMap.keySet()) {
                memberKeyStr.put(key, JsonUtil.buildNormalBinder().toJson(memberMap.get(key)));
            }
            DisUtil.setMapVer((String)this.cachekey, memberKeyStr);
        }
        this.logger.info("up.PERMIS.UpOpdataServiceImpl.queryOpdataLoadCache", (Object)"===========add-end==========");
    }

    @Override
    public void resetData() {
        this.logger.error("up.PERMIS.UpOpdataServiceImpl.resetData", (Object)"==============reset start===================");
        String tenantCode = "2020050600004084";
        this.deleteOpdataByCode(tenantCode, null);
        this.deleteOpdatascByCode(tenantCode, null);
        this.getUpOpdataListService().deleteOpdataListByCode(tenantCode, null);
        this.logger.error("up.PERMIS.UpOpdataServiceImpl.resetData.delete", (Object)"==============reset delete success===================");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        String result = this.internalInvoke("org.depart.queryDepartPage", paramMap);
        if (StringUtils.isNotBlank((String)result)) {
            QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, QueryResult.class);
            String departListStr = JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList());
            this.logger.error("up.PERMIS.UpOpdataServiceImpl.resetData.departListStr", (Object)departListStr);
            List domainList = (List)JsonUtil.buildNormalBinder().getJsonToList(departListStr, OrgDepartReDomain.class);
            HashMap<String, List<OrgDepartReDomain>> domainMap = new HashMap<String, List<OrgDepartReDomain>>();
            this.makeDomainMap(domainMap, domainList);
            ArrayList<UpOpdataDomainBean> opDataList = new ArrayList<UpOpdataDomainBean>();
            this.makeUpData(domainList, opDataList, domainMap);
            if (opDataList.size() > 0) {
                this.saveOpdataBatch(opDataList);
            }
        }
        this.queryOpdataLoadCache();
        this.logger.error("up.PERMIS.UpOpdataServiceImpl.resetData", (Object)"==============reset end===================");
    }

    @Override
    public void appendDataByAddUser(String userInfoCode, String departCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("departPcode", departCode);
        String object = this.internalInvoke("org.depart.queryDepartByPcode", map);
        ArrayList<UpOpdataListDomain> upOpdataListDomainList = new ArrayList<UpOpdataListDomain>();
        if (StringUtils.isNotBlank((String)object)) {
            JSONArray jsonArray = JSONArray.json2array((String)object);
            for (JSONObject jsonObject : jsonArray) {
                UpOpdataListDomain upOpdataListDomain = new UpOpdataListDomain();
                upOpdataListDomain.setOpdataCode(jsonObject.getString("departCode"));
                upOpdataListDomain.setOpdataOpocode(userInfoCode);
                upOpdataListDomain.setTenantCode(tenantCode);
                upOpdataListDomainList.add(upOpdataListDomain);
            }
            this.getUpOpdataListService().saveOpdataListBatch(upOpdataListDomainList);
            this.queryOpdataLoadCache();
        }
    }

    private void makeDomainMap(Map<String, List<OrgDepartReDomain>> domainMap, List<OrgDepartReDomain> domainList) {
        for (OrgDepartReDomain orgDepartReDomain : domainList) {
            if (domainMap.containsKey(orgDepartReDomain.getDepartPcode())) {
                domainMap.get(orgDepartReDomain.getDepartPcode()).add(orgDepartReDomain);
                continue;
            }
            ArrayList<OrgDepartReDomain> list = new ArrayList<OrgDepartReDomain>();
            list.add(orgDepartReDomain);
            domainMap.put(orgDepartReDomain.getDepartPcode(), list);
        }
    }

    private void makeUpData(List<OrgDepartReDomain> domainList, List<UpOpdataDomainBean> opDataList, Map<String, List<OrgDepartReDomain>> domainMap) {
        HashMap<String, JSONArray> userMap = new HashMap<String, JSONArray>();
        for (OrgDepartReDomain orgDepartReDomain : domainList) {
            UpOpdataDomainBean upOpdata = new UpOpdataDomainBean();
            upOpdata.setTenantCode(orgDepartReDomain.getTenantCode());
            upOpdata.setOpdataType("0");
            upOpdata.setOpdataCode(orgDepartReDomain.getDepartCode());
            upOpdata.setOpdataOpcode(orgDepartReDomain.getDepartCode());
            upOpdata.setOpdataApp(0);
            upOpdata.setOpdataOpocode(orgDepartReDomain.getDepartCode());
            upOpdata.setOpdataOponame(orgDepartReDomain.getDepartName());
            upOpdata.setOpdataState(0);
            ArrayList<UpOpdataListDomain> upOpdataListDomainList = new ArrayList<UpOpdataListDomain>();
            this.makeUpOpDataList(upOpdataListDomainList, domainMap, orgDepartReDomain.getDepartCode(), orgDepartReDomain.getTenantCode(), userMap);
            upOpdata.setUpOpdataListDomainList(upOpdataListDomainList);
            ArrayList<UpOpdatascDomainBean> upOpdatascDomainBeans = new ArrayList<UpOpdatascDomainBean>();
            this.makeUpOpDataSc(upOpdatascDomainBeans, orgDepartReDomain.getDepartCode());
            upOpdata.setUpOpdatascDomainBeanList(upOpdatascDomainBeans);
            opDataList.add(upOpdata);
        }
    }

    private void makeUpOpDataList(List<UpOpdataListDomain> upOpdataListDomainList, Map<String, List<OrgDepartReDomain>> domainMap, String departCode, String tenantCode, Map<String, JSONArray> userMap) {
        if (domainMap.containsKey(departCode)) {
            for (OrgDepartReDomain orgDepartReDomain : domainMap.get(departCode)) {
                this.makeUpOpDataList(upOpdataListDomainList, domainMap, orgDepartReDomain.getDepartCode(), tenantCode, userMap);
            }
        } else if (userMap.containsKey(departCode)) {
            this.makeUpOpDataList(upOpdataListDomainList, userMap.get(departCode), departCode, tenantCode);
        } else {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantCode", tenantCode);
            param.put("departCode", departCode);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
            String result = this.internalInvoke("um.user.queryUserinfoList", paramMap);
            if (StringUtils.isNotBlank((String)result)) {
                JSONArray jsonArray = JSONArray.json2array((String)result);
                if (jsonArray != null && jsonArray.size() > 0) {
                    this.makeUpOpDataList(upOpdataListDomainList, jsonArray, departCode, tenantCode);
                }
                userMap.put(departCode, jsonArray);
            }
        }
    }

    private void makeUpOpDataSc(List<UpOpdatascDomainBean> upOpdatascDomainBeans, String opdataCode) {
        for (String key : TABLE_CL.keySet()) {
            UpOpdatascDomainBean bean = new UpOpdatascDomainBean();
            bean.setOpdatascsType(key);
            bean.setOpdatascsColumns(TABLE_CL.get(key));
            bean.setOpdataCode(opdataCode);
            upOpdatascDomainBeans.add(bean);
        }
    }

    private void makeUpOpDataList(List<UpOpdataListDomain> upOpdataListDomainList, JSONArray jsonArray, String departCode, String tenantCode) {
        for (JSONObject jsonObject : jsonArray) {
            UpOpdataListDomain upOpdataListDomain = new UpOpdataListDomain();
            upOpdataListDomain.setOpdataCode(departCode);
            upOpdataListDomain.setOpdataOpocode(jsonObject.getString("userinfoCode"));
            upOpdataListDomain.setTenantCode(tenantCode);
            upOpdataListDomainList.add(upOpdataListDomain);
        }
    }

    private void deleteUpOpdataCache(UpOpdataDomainBean upOpdataDomain) {
        if (null == upOpdataDomain) {
            return;
        }
        QueryResult<UpOpdatasc> upOpdatascQueryResult = this.queryOpdatascPage(this.getQueryParamMap("tenantCode,opdataCode", new Object[]{upOpdataDomain.getTenantCode(), upOpdataDomain.getOpdataCode()}));
        List UpOpdatascList = upOpdatascQueryResult.getList();
        if (ListUtil.isEmpty((Collection)UpOpdatascList)) {
            return;
        }
        for (UpOpdatasc upOpdatasc : UpOpdatascList) {
            String key = upOpdataDomain.getOpdataType() + "-" + upOpdataDomain.getOpdataOpcode() + "-" + upOpdatasc.getOpdatascsType() + "-" + upOpdatasc.getTenantCode();
            DisUtil.delMap((String)this.cachekey, (String[])new String[]{key});
        }
    }

    private void updateUpOpdataCache(UpOpdata upOpdataDomain) {
        if (null == upOpdataDomain) {
            return;
        }
        QueryResult<UpOpdataList> upOpdataListQueryResult = this.getUpOpdataListService().queryOpdataListPage(this.getQueryParamMap("tenantCode,opdataCode", new Object[]{upOpdataDomain.getTenantCode(), upOpdataDomain.getOpdataCode()}));
        QueryResult<UpOpdatasc> upOpdatascQueryResult = this.queryOpdatascPage(this.getQueryParamMap("tenantCode,opdataCode", new Object[]{upOpdataDomain.getTenantCode(), upOpdataDomain.getOpdataCode()}));
        List UpOpdatascList = upOpdatascQueryResult.getList();
        if (ListUtil.isEmpty((Collection)UpOpdatascList)) {
            return;
        }
        ConcurrentHashMap memberMap = new ConcurrentHashMap();
        String group = upOpdataDomain.getOpdataOpotype();
        if (StringUtils.isBlank((String)group)) {
            group = "";
        }
        String cloumnkey = "";
        for (UpOpdatasc upOpdatasc : UpOpdatascList) {
            String memberKey = upOpdataDomain.getOpdataType() + "-" + upOpdataDomain.getOpdataOpcode() + "-" + upOpdatasc.getOpdatascsType() + "-" + upOpdatasc.getTenantCode();
            HashMap<String, String> memberValue = (HashMap<String, String>)memberMap.get(memberKey);
            if (null == memberValue) {
                memberValue = new HashMap<String, String>();
                memberMap.put(memberKey, memberValue);
            }
            if (StringUtils.isBlank((String)(group = upOpdataDomain.getOpdataOpotype()))) {
                group = "";
            }
            cloumnkey = upOpdatasc.getOpdatascsColumns();
            if (StringUtils.isNotBlank((String)group)) {
                group = group + "|" + cloumnkey;
            }
            memberValue.put(group, this.createListToStr(upOpdataListQueryResult.getList()));
        }
        for (String key : memberMap.keySet()) {
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(memberMap.get(key)));
        }
    }

    @Override
    public String saveOpdataBatchToMsc(List<UpOpdataDomainBean> upOpdataDomainBeanList) throws ApiException {
        if (null == upOpdataDomainBeanList || upOpdataDomainBeanList.isEmpty()) {
            return null;
        }
        String code = "";
        for (UpOpdataDomainBean upOpdataDomainBean : upOpdataDomainBeanList) {
            code = this.saveOpdataToMsc(upOpdataDomainBean);
        }
        return code;
    }

    public String saveOpdataToMsc(UpOpdataDomainBean upOpdataDomainBean) throws ApiException {
        UpOpdata upOpdata = this.createUpOpdata(upOpdataDomainBean);
        this.saveOpdataModel(upOpdata);
        this.saveUpOpdatascDomainBeanList(upOpdata, upOpdataDomainBean.getUpOpdatascDomainBeanList());
        this.saveUpOpdataListDomainBeanList(upOpdata, upOpdataDomainBean.getUpOpdataListDomainList());
        upOpdataDomainBean.setOpdataCode(upOpdata.getOpdataCode());
        this.updateUpOpdataCacheToMsc(upOpdata);
        return upOpdata.getOpdataCode();
    }

    private void updateUpOpdataCacheToMsc(UpOpdata upOpdataDomain) {
        if (null == upOpdataDomain) {
            return;
        }
        QueryResult<UpOpdata> queryRes = this.queryOpdataPage(this.getQueryParamMap("tenantCode,opdataOpcode", new Object[]{upOpdataDomain.getTenantCode(), upOpdataDomain.getOpdataOpcode()}));
        if (null == queryRes || ListUtil.isEmpty((Collection)queryRes.getList())) {
            this.logger.error("queryRes==", (Object)JsonUtil.buildNormalBinder().toJson((Object)upOpdataDomain));
            return;
        }
        ArrayList<UpOpdataList> list = new ArrayList<UpOpdataList>();
        for (UpOpdata data : queryRes.getList()) {
            QueryResult<UpOpdataList> upOpdataListQueryResult = this.getUpOpdataListService().queryOpdataListPage(this.getQueryParamMap("tenantCode,opdataCode", new Object[]{data.getTenantCode(), data.getOpdataCode()}));
            list.addAll(upOpdataListQueryResult.getList());
        }
        List<UpOpdatasc> UpOpdatascList = ((UpOpdata)queryRes.getList().get(0)).getUpOpdatascDomainBeanList();
        if (ListUtil.isEmpty(UpOpdatascList)) {
            this.logger.error("UpOpdatascList====-===", (Object)JsonUtil.buildNormalBinder().toJson(UpOpdatascList));
            return;
        }
        ConcurrentHashMap memberMap = new ConcurrentHashMap();
        String group = upOpdataDomain.getOpdataOpotype();
        if (StringUtils.isBlank((String)group)) {
            group = "";
        }
        String cloumnkey = "";
        UpOpdatasc upOpdatasc = UpOpdatascList.get(0);
        String memberKey = upOpdataDomain.getOpdataType() + "-" + upOpdataDomain.getOpdataOpcode() + "-" + upOpdatasc.getOpdatascsType() + "-" + upOpdatasc.getTenantCode();
        HashMap<String, Map<String, Object>> memberValue = new HashMap<String, Map<String, Object>>();
        cloumnkey = upOpdatasc.getOpdatascsColumns();
        memberValue.put(cloumnkey, this.createListToMscStr(list));
        memberMap.put(memberKey, memberValue);
        this.logger.error("memberMap==" + JsonUtil.buildNonDefaultBinder().toJson(memberMap));
        for (String key : memberMap.keySet()) {
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(memberMap.get(key)));
        }
    }

    private Map<String, Object> createListToMscStr(List<UpOpdataList> upOpdataListList) {
        if (ListUtil.isEmpty(upOpdataListList)) {
            return null;
        }
        HashMap<String, Object> mscMap = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> listMsc = new ArrayList<String>();
        for (UpOpdataList upOpdataList : upOpdataListList) {
            Object object;
            if ("-1".equals(upOpdataList.getAppmanageIcode())) {
                object = mscMap.get("-1");
                if (null == object) {
                    mscMap.put("-1", list);
                }
                list.add(upOpdataList.getOpdataOpocode());
                continue;
            }
            object = mscMap.get("2");
            if (null == object) {
                mscMap.put("2", listMsc);
            }
            listMsc.add(upOpdataList.getOpdataOpocode());
        }
        return mscMap;
    }

    static {
        TABLE_CL.put("um_userinfo", "USERINFO_CODE");
        TABLE_CL.put("rs_resource_goods", "MEMBER_CODE");
        TABLE_CL.put("oc_contract", "MEMBER_BCODE");
        TABLE_CL.put("um_userinfoblak", "USERINFO_CODE");
        TABLE_CL.put("sg_occontract", "MEMBER_BCODE");
        TABLE_CL.put("sg_sendgoods", "MEMBER_BCODE");
        TABLE_CL.put("crms_sorder", "MEMBER_BCODE");
        TABLE_CL.put("dis_channel", "MEMBER_CODE");
        TABLE_CL.put("dis_dprice", "MEMBER_CODE");
        TABLE_CL.put("oc_refund", "MEMBER_BCODE");
        TABLE_CL.put("vd_faccount_outer", "MERCHANT_CODE");
        TABLE_CL.put("cp_recharge", "USERINFO_CODE");
        TABLE_CL.put("crms_urecharge", "USERINFO_CODE");
        TABLE_CL.put("crp_urecharge", "USERINFO_CODE");
        TABLE_CL.put("crp_recharge", "USERINFO_CODE");
        TABLE_CL.put("pm_coupon_batch", "CUSTREL_CODE");
        TABLE_CL.put("pro_project", "CUSTREL_CODE");
    }
}

