/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.dao.UpOpdatascsMapper;
import com.yqbsoft.laser.service.permis.domain.UpOpdatascsDomainBean;
import com.yqbsoft.laser.service.permis.domain.UpOpdatascsReDomainBean;
import com.yqbsoft.laser.service.permis.model.UpOpdatascs;
import com.yqbsoft.laser.service.permis.service.UpOpdatascsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpOpdatascsServiceImpl
extends BaseServiceImpl
implements UpOpdatascsService {
    private static final String SYS_CODE = "up.PERMIS.UpOpdatascsServiceImpl";
    private UpOpdatascsMapper upOpdatascsMapper;

    public void setUpOpdatascsMapper(UpOpdatascsMapper upOpdatascsMapper) {
        this.upOpdatascsMapper = upOpdatascsMapper;
    }

    private Date getSysDate() {
        try {
            return this.upOpdatascsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdatascsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpdatascs(UpOpdatascsDomainBean upOpdatascsDomainBean) {
        if (null == upOpdatascsDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upOpdatascsDomainBean.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpdatascsDefault(UpOpdatascs upOpdatascs) {
        if (null == upOpdatascs) {
            return;
        }
        if (null == upOpdatascs.getDataState()) {
            upOpdatascs.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == upOpdatascs.getGmtCreate()) {
            upOpdatascs.setGmtCreate(date);
        }
        upOpdatascs.setGmtModified(date);
        if (StringUtils.isBlank((String)upOpdatascs.getOpdatascsCode())) {
            upOpdatascs.setOpdatascsCode(this.getNo(null, "UpOpdatascs", "upOpdatascs", upOpdatascs.getTenantCode()));
        }
    }

    private int getOpdatascsMaxCode() {
        int code = 0;
        try {
            return this.upOpdatascsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdatascsServiceImpl.getOpdatascsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpdatascsUpdataDefault(UpOpdatascs upOpdatascs) {
        if (null == upOpdatascs) {
            return;
        }
        upOpdatascs.setGmtModified(this.getSysDate());
    }

    private void saveOpdatascsModel(UpOpdatascs upOpdatascs) throws ApiException {
        if (null == upOpdatascs) {
            return;
        }
        try {
            this.upOpdatascsMapper.insert(upOpdatascs);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.saveOpdatascsModel.ex", (Throwable)e);
        }
    }

    private void saveOpdatascsBatchModel(List<UpOpdatascs> upOpdatascsList) throws ApiException {
        if (null == upOpdatascsList || upOpdatascsList.isEmpty()) {
            return;
        }
        try {
            this.upOpdatascsMapper.insertBatch(upOpdatascsList);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.saveOpdatascsBatchModel.ex", (Throwable)e);
        }
    }

    private UpOpdatascs getOpdatascsModelById(Integer opdatascsId) {
        if (null == opdatascsId) {
            return null;
        }
        try {
            return this.upOpdatascsMapper.selectByPrimaryKey(opdatascsId);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdatascsServiceImpl.getOpdatascsModelById", (Throwable)e);
            return null;
        }
    }

    private UpOpdatascs getOpdatascsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upOpdatascsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdatascsServiceImpl.getOpdatascsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpdatascsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdatascsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.delOpdatascsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.delOpdatascsModelByCode.num");
        }
    }

    private void deleteOpdatascsModel(Integer opdatascsId) throws ApiException {
        if (null == opdatascsId) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdatascsMapper.deleteByPrimaryKey(opdatascsId);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.deleteOpdatascsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.deleteOpdatascsModel.num");
        }
    }

    private void updateOpdatascsModel(UpOpdatascs upOpdatascs) throws ApiException {
        if (null == upOpdatascs) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdatascsMapper.updateByPrimaryKey(upOpdatascs);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.updateOpdatascsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.updateOpdatascsModel.num");
        }
    }

    private void updateStateOpdatascsModel(Integer opdatascsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opdatascsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opdatascsId", opdatascsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upOpdatascsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.updateStateOpdatascsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.updateStateOpdatascsModel.null");
        }
    }

    private void updateStateOpdatascsModelByCode(String tenantCode, String opdatascsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opdatascsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdatascsCode", opdatascsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upOpdatascsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.updateStateOpdatascsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.updateStateOpdatascsModelByCode.null");
        }
    }

    private UpOpdatascs makeOpdatascs(UpOpdatascsDomainBean upOpdatascsDomainBean, UpOpdatascs upOpdatascs) {
        if (null == upOpdatascsDomainBean) {
            return null;
        }
        if (null == upOpdatascs) {
            upOpdatascs = new UpOpdatascs();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upOpdatascs, (Object)upOpdatascsDomainBean);
            return upOpdatascs;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdatascsServiceImpl.makeOpdatascs", (Throwable)e);
            return null;
        }
    }

    private UpOpdatascsReDomainBean makeUpOpdatascsReDomainBean(UpOpdatascs upOpdatascs) {
        if (null == upOpdatascs) {
            return null;
        }
        UpOpdatascsReDomainBean upOpdatascsReDomainBean = new UpOpdatascsReDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)upOpdatascsReDomainBean, (Object)upOpdatascs);
            return upOpdatascsReDomainBean;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdatascsServiceImpl.makeUpOpdatascsReDomainBean", (Throwable)e);
            return null;
        }
    }

    private List<UpOpdatascs> queryOpdatascsModelPage(Map<String, Object> parammap) {
        try {
            return this.upOpdatascsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdatascsServiceImpl.queryOpdatascsModel", (Throwable)e);
            return null;
        }
    }

    private int countOpdatascs(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upOpdatascsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdatascsServiceImpl.countOpdatascs", (Throwable)e);
        }
        return i;
    }

    private UpOpdatascs createUpOpdatascs(UpOpdatascsDomainBean upOpdatascsDomainBean) {
        String msg = this.checkOpdatascs(upOpdatascsDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.saveOpdatascs.checkOpdatascs", msg);
        }
        UpOpdatascs upOpdatascs = this.makeOpdatascs(upOpdatascsDomainBean, null);
        this.setOpdatascsDefault(upOpdatascs);
        return upOpdatascs;
    }

    @Override
    public String saveOpdatascs(UpOpdatascsDomainBean upOpdatascsDomainBean) throws ApiException {
        UpOpdatascs upOpdatascs = this.createUpOpdatascs(upOpdatascsDomainBean);
        this.saveOpdatascsModel(upOpdatascs);
        return upOpdatascs.getOpdatascsCode();
    }

    @Override
    public String saveOpdatascsBatch(List<UpOpdatascsDomainBean> upOpdatascsDomainBeanList) throws ApiException {
        if (null == upOpdatascsDomainBeanList || upOpdatascsDomainBeanList.isEmpty()) {
            return null;
        }
        ArrayList<UpOpdatascs> upOpdatascsList = new ArrayList<UpOpdatascs>();
        String code = "";
        for (UpOpdatascsDomainBean upOpdatascsDomainBean : upOpdatascsDomainBeanList) {
            UpOpdatascs upOpdatascs = this.createUpOpdatascs(upOpdatascsDomainBean);
            code = upOpdatascs.getOpdatascsCode();
            upOpdatascsList.add(upOpdatascs);
        }
        this.saveOpdatascsBatchModel(upOpdatascsList);
        return code;
    }

    @Override
    public void updateOpdatascsState(Integer opdatascsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opdatascsId) {
            return;
        }
        this.updateStateOpdatascsModel(opdatascsId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpdatascsStateByCode(String tenantCode, String opdatascsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opdatascsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpdatascsModelByCode(tenantCode, opdatascsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpdatascs(UpOpdatascsDomainBean upOpdatascsDomainBean) throws ApiException {
        String msg = this.checkOpdatascs(upOpdatascsDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.updateOpdatascs.checkOpdatascs", msg);
        }
        UpOpdatascs oldUpOpdatascs = this.getOpdatascsModelById(upOpdatascsDomainBean.getOpdatascsId());
        if (null == oldUpOpdatascs) {
            throw new ApiException("up.PERMIS.UpOpdatascsServiceImpl.updateOpdatascs.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpOpdatascs upOpdatascs = this.makeOpdatascs(upOpdatascsDomainBean, oldUpOpdatascs);
        this.setOpdatascsUpdataDefault(upOpdatascs);
        this.updateOpdatascsModel(upOpdatascs);
    }

    @Override
    public UpOpdatascs getOpdatascs(Integer opdatascsId) {
        if (null == opdatascsId) {
            return null;
        }
        return this.getOpdatascsModelById(opdatascsId);
    }

    @Override
    public void deleteOpdatascs(Integer opdatascsId) throws ApiException {
        if (null == opdatascsId) {
            return;
        }
        this.deleteOpdatascsModel(opdatascsId);
    }

    @Override
    public QueryResult<UpOpdatascs> queryOpdatascsPage(Map<String, Object> map) {
        List<UpOpdatascs> upOpdatascsList = this.queryOpdatascsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpdatascs(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upOpdatascsList);
        return queryResult;
    }

    @Override
    public UpOpdatascs getOpdatascsByCode(String tenantCode, String opdatascsCode) throws ApiException {
        if (StringUtils.isBlank((String)opdatascsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdatascsCode", opdatascsCode);
        return this.getOpdatascsModelByCode(map);
    }

    @Override
    public void deleteOpdatascsByCode(String tenantCode, String opdatascsCode) throws ApiException {
        if (StringUtils.isBlank((String)opdatascsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdatascsCode", opdatascsCode);
        this.delOpdatascsModelByCode(map);
    }
}

