/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.plugin;

import com.yqbsoft.laser.service.esb.annotation.ColumnName;
import com.yqbsoft.laser.service.plugin.ColumnBean;
import com.yqbsoft.laser.service.plugin.ControlConfig;
import com.yqbsoft.laser.service.plugin.FtlTranslationService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlCode {
    public static String javaOutputDir = "src\\main\\java\\com\\yqbsoft\\laser\\html\\{pagename}\\controller\\";
    public static String javaBeanOutputDir = "src\\main\\java\\com\\yqbsoft\\laser\\html\\{pagename}\\bean\\";
    public static String htmlOutputDir = "src\\main\\resources\\META-INF\\html\\{context}\\";
    private static FtlTranslationService ftlTranslationService = new FtlTranslationService();
    public static final Map<String, String> colMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1549926805156219813L;
        {
            this.put("gmtCreate", "gmtCreate");
            this.put("serialVersionUID", "serialVersionUID");
            this.put("gmtModified", "gmtModified");
            this.put("memo", "memo");
            this.put("dataState", "dataState");
        }
    };

    public static void createControl(ControlConfig controlConfig) {
        if (!ControlCode.check(controlConfig)) {
            return;
        }
        try {
            ftlTranslationService.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, ControlConfig> data = new HashMap<String, ControlConfig>();
        data.put("controlConfig", controlConfig);
        javaOutputDir = controlConfig.getProjectPath() + javaOutputDir.replace("{pagename}", controlConfig.getPagename());
        htmlOutputDir = controlConfig.getProjectPath() + htmlOutputDir.replace("{context}", controlConfig.getContext());
        javaBeanOutputDir = controlConfig.getProjectPath() + javaBeanOutputDir.replace("{pagename}", controlConfig.getPagename());
        try {
            ftlTranslationService.translate(data, "htmlInbean.ftl", javaBeanOutputDir + "/" + controlConfig.getUpContext() + "Bean.java");
            ftlTranslationService.translate(data, "htmlRebean.ftl", javaBeanOutputDir + "/" + controlConfig.getUpContext() + "ReBean.java");
            ftlTranslationService.translate(data, "control.ftl", javaOutputDir + "/" + controlConfig.getUpContext() + "Con.java");
            ftlTranslationService.translate(data, "html-add.ftl", htmlOutputDir + "/add.ftl");
            ftlTranslationService.translate(data, "html-list.ftl", htmlOutputDir + "/list.ftl");
            ftlTranslationService.translate(data, "html-edit.ftl", htmlOutputDir + "/edit.ftl");
            ftlTranslationService.translate(data, "html-view.ftl", htmlOutputDir + "/view.ftl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkObjectNull(Object obj) {
        if (null == obj) {
            return true;
        }
        return "".equals(String.valueOf(obj));
    }

    public static boolean check(ControlConfig controlConfig) {
        if (null == controlConfig) {
            return false;
        }
        boolean flag = true;
        if (ControlCode.checkObjectNull(controlConfig.getIdName())) {
            System.out.println("IdName\u4e3a\u7a7a");
            flag = false;
        }
        if (ControlCode.checkObjectNull(controlConfig.getModel())) {
            System.out.println("Model\u4e3a\u7a7a");
            flag = false;
        }
        if (ControlCode.checkObjectNull(controlConfig.getName())) {
            System.out.println("Name\u4e3a\u7a7a");
            flag = false;
        }
        if (ControlCode.checkObjectNull(controlConfig.getNameNick())) {
            System.out.println("NameNick\u4e3a\u7a7a");
            flag = false;
        }
        if (ControlCode.checkObjectNull(controlConfig.getModelName())) {
            System.out.println("modelName\u4e3a\u7a7a");
            flag = false;
        }
        if (flag) {
            String s = controlConfig.getNameNick();
            s = s.substring(0, 1).toLowerCase() + s.substring(1);
            System.out.println(controlConfig.getNameNick() + "====>" + s);
            controlConfig.setLnameNick(s);
            s = controlConfig.getModelName();
            s = s.substring(0, 1).toLowerCase() + s.substring(1);
            System.out.println(controlConfig.getModelName() + "====>" + s);
            controlConfig.setLmodelName(s);
            try {
                Class<?> clazz = Class.forName("com.yqbsoft.laser.service." + controlConfig.getServicePagename() + ".domain." + controlConfig.getModelName() + controlConfig.getDomainName());
                ControlCode.createColumn(controlConfig, clazz);
                clazz = Class.forName("com.yqbsoft.laser.service." + controlConfig.getServicePagename() + ".domain." + controlConfig.getModelName() + controlConfig.getReDomainName());
                ControlCode.createColumn(controlConfig, clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    private static void createColumn(ControlConfig controlConfig, Class<?> clazz) {
        try {
            Field[] fieldList = clazz.getDeclaredFields();
            if (null != fieldList) {
                Map<String, String> columnNameMap;
                List<String> columnList;
                List<ColumnBean> refieldList;
                List<ColumnBean> infieldList = controlConfig.getInfieldList();
                if (null == infieldList) {
                    infieldList = new ArrayList<ColumnBean>();
                    controlConfig.setInfieldList(infieldList);
                }
                if (null == (refieldList = controlConfig.getRefieldList())) {
                    refieldList = new ArrayList<ColumnBean>();
                    controlConfig.setRefieldList(refieldList);
                }
                if (null == (columnList = controlConfig.getColumnList())) {
                    columnList = new ArrayList<String>();
                    controlConfig.setColumnList(columnList);
                }
                if (null == (columnNameMap = controlConfig.getColumnNameMap())) {
                    columnNameMap = new HashMap<String, String>();
                    controlConfig.setColumnNameMap(columnNameMap);
                }
                ColumnBean columnBean = null;
                for (Field field : fieldList) {
                    columnBean = new ColumnBean();
                    columnBean.setDoc("");
                    if (!colMap.containsKey(field.getName()) && !controlConfig.getIdName().equals(field.getName())) {
                        columnList.add(field.getName());
                        ColumnName colname = field.getAnnotation(ColumnName.class);
                        if (null != colname && null != field.getName()) {
                            columnNameMap.put(field.getName(), colname.value().equals("") ? field.getName() : colname.value());
                            columnBean.setDoc(columnNameMap.get(field.getName()));
                        }
                    }
                    if ("serialVersionUID".equals(field.getName())) continue;
                    columnBean.setName(field.getName());
                    columnBean.setSimpleTypeClass(field.getType().getSimpleName());
                    columnBean.setGetterName("get" + ControlCode.toUpperCaseFirstOne(columnBean.getName()));
                    columnBean.setSetterName("set" + ControlCode.toUpperCaseFirstOne(columnBean.getName()));
                    if (colMap.containsKey(field.getName())) {
                        refieldList.add(columnBean);
                        continue;
                    }
                    infieldList.add(columnBean);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

