<#include '/common/copyright.ftl' />
<#assign serviceImplConfig={}>
<#if data??>
    <#if data.serviceImplConfig??>
        <#assign serviceImplConfig=data.serviceImplConfig>
    </#if>
</#if>
<#if serviceImplConfig.intefacePackagePath??>
package ${serviceImplConfig.intefacePackagePath}.service.impl;
</#if>

<#if serviceImplConfig.importClasses??>
    <#list serviceImplConfig.importClasses as importClass>
        <#if importClass??>
import ${importClass};
        </#if>
    </#list>
</#if>
import ${serviceImplConfig.intefacePackagePath}.service.${serviceImplConfig.interfaceName};

${serviceImplConfig.javaDoc}
public class ${serviceImplConfig.interfaceName}Impl extends AdapterBaseServiceImpl implements ${serviceImplConfig.interfaceName} {
	
	private static final String SYS_CODE = "${serviceImplConfig.module}.SYS_CODE" + ".${serviceImplConfig.interfaceName}Impl";

	OpenLogUtil logger = new OpenLogUtil(getClass());
	
	protected static final String APP_KEY = "${serviceImplConfig.module}";

<#list serviceImplConfig.methods as method>
	@Override
	public ${method.returnType} ${method.name}(<#list method.paramStrList as param>${param}<#if param_has_next>, </#if></#list>) throws ApiException {
		String wsdlAddress = getCallUrl(APP_KEY, "/${serviceImplConfig.facadeName?uncap_first}?wsdl", sys_product_code, test_router_flag);

    ${serviceImplConfig.facadeName} facade = (${serviceImplConfig.facadeName}) SaaSFacadeFactory.newFacade(wsdlAddress, ${serviceImplConfig.facadeName}.class);
    <#if method.containEnv>
		OperationEnvironment environment = new OperationEnvironment();
    </#if>
    ${method.returnType} rsp = null;
		try {
			rsp = facade.${method.name}(<#list method.facadeMethodParaNameList as facadeMethodParaName>${facadeMethodParaName}<#if facadeMethodParaName_has_next>, </#if></#list>);
		} catch (Exception e) {
			logger.error(SYS_CODE + "${method.name}", e);
			throw new ApiException(SYS_CODE + "${method.name}", e);
		}

		if (null == rsp) {
			logger.error(SYS_CODE + "${method.name}. return rsp is null.");
			throw new ApiException(SYS_CODE + "${method.name}. return rsp is null.");
		}
		logger.debug(SYS_CODE, rsp);
		return rsp;
	}

</#list>

}
