/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.PromotionConstants;
import com.yqbsoft.laser.service.pm.dao.PmPromotionMapper;
import com.yqbsoft.laser.service.pm.domain.DiscountDataDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionCalcDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionConditionDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDiscountDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionRangelistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionReDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionTargetlistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionTerminalDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserOrderDomain;
import com.yqbsoft.laser.service.pm.domain.SkuInfoDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmPromotionCondition;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscount;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscountlist;
import com.yqbsoft.laser.service.pm.model.PmPromotionRangelist;
import com.yqbsoft.laser.service.pm.model.PmPromotionTargetlist;
import com.yqbsoft.laser.service.pm.model.PmPromotionTerminal;
import com.yqbsoft.laser.service.pm.model.PmUserOrder;
import com.yqbsoft.laser.service.pm.service.PmPromotionConditionService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountlistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionRangelistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmPromotionTargetlistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionTerminalService;
import com.yqbsoft.laser.service.pm.service.PmUserOrderService;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionServiceImpl
extends BaseServiceImpl
implements PmPromotionService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionServiceImpl";
    private PmPromotionMapper pmPromotionMapper;
    private PmPromotionTargetlistService pmPromotionTargetlistService;
    private PmPromotionTerminalService pmPromotionTerminalService;
    private PmPromotionRangelistService pmPromotionRangelistService;
    private PmPromotionConditionService pmPromotionConditionService;
    private PmPromotionDiscountService pmPromotionDiscountService;
    private PmPromotionDiscountlistService pmPromotionDiscountlistService;
    private RsResourceGoodsService rsResourceGoodsService;
    private RsSkuService rsSkuService;
    private PmUserOrderService pmUserOrderService;

    public void setPmUserOrderService(PmUserOrderService pmUserOrderService) {
        this.pmUserOrderService = pmUserOrderService;
    }

    public void setRsSkuService(RsSkuService rsSkuService) {
        this.rsSkuService = rsSkuService;
    }

    public void setPmPromotionDiscountlistService(PmPromotionDiscountlistService pmPromotionDiscountlistService) {
        this.pmPromotionDiscountlistService = pmPromotionDiscountlistService;
    }

    public void setRsResourceGoodsService(RsResourceGoodsService rsResourceGoodsService) {
        this.rsResourceGoodsService = rsResourceGoodsService;
    }

    public void setPmPromotionDiscountService(PmPromotionDiscountService pmPromotionDiscountService) {
        this.pmPromotionDiscountService = pmPromotionDiscountService;
    }

    public void setPmPromotionTerminalService(PmPromotionTerminalService pmPromotionTerminalService) {
        this.pmPromotionTerminalService = pmPromotionTerminalService;
    }

    public void setPmPromotionConditionService(PmPromotionConditionService pmPromotionConditionService) {
        this.pmPromotionConditionService = pmPromotionConditionService;
    }

    public void setPmPromotionRangelistService(PmPromotionRangelistService pmPromotionRangelistService) {
        this.pmPromotionRangelistService = pmPromotionRangelistService;
    }

    public void setPmPromotionTargetlistService(PmPromotionTargetlistService pmPromotionTargetlistService) {
        this.pmPromotionTargetlistService = pmPromotionTargetlistService;
    }

    public void setPmPromotionMapper(PmPromotionMapper pmPromotionMapper) {
        this.pmPromotionMapper = pmPromotionMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotion(PmPromotionDomain pmPromotionDomain) {
        if (null == pmPromotionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionDefault(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        if (null == pmPromotion.getDataState()) {
            pmPromotion.setDataState(0);
        }
        if (null == pmPromotion.getGmtCreate()) {
            pmPromotion.setGmtCreate(this.getSysDate());
        }
        pmPromotion.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmPromotion.getPromotionCode())) {
            pmPromotion.setPromotionCode(this.createUUIDString());
        }
    }

    private int getPromotionMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getPromotionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionUpdataDefault(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        pmPromotion.setGmtModified(this.getSysDate());
    }

    private void savePromotionModel(PmPromotion pmPromotion) throws ApiException {
        if (null == pmPromotion) {
            return;
        }
        try {
            this.pmPromotionMapper.insert(pmPromotion);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.savePromotionModel.ex", (Throwable)e);
        }
    }

    private void savePromotionBatchModel(List<PmPromotion> pmPromotionList) throws ApiException {
        if (null == pmPromotionList || pmPromotionList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionMapper.insertBatch(pmPromotionList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.savePromotionBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotion getPromotionModelById(Integer promotionId) {
        if (null == promotionId) {
            return null;
        }
        try {
            return this.pmPromotionMapper.selectByPrimaryKey(promotionId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getPromotionModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotion getPromotionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getPromotionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.delPromotionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.delPromotionModelByCode.num");
        }
    }

    private void deletePromotionModel(Integer promotionId) throws ApiException {
        if (null == promotionId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMapper.deleteByPrimaryKey(promotionId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.deletePromotionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.deletePromotionModel.num");
        }
    }

    private void updatePromotionModel(PmPromotion pmPromotion) throws ApiException {
        if (null == pmPromotion) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateByPrimaryKeySelective(pmPromotion);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotionModel.num");
        }
    }

    private void updateStatePromotionModel(Integer promotionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == promotionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promotionId", promotionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModel.null");
        }
    }

    private void updateStatePromotionModelByCode(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)promotionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModelByCode.null");
        }
    }

    private PmPromotion makePromotion(PmPromotionDomain pmPromotionDomain, PmPromotion pmPromotion) {
        if (null == pmPromotionDomain) {
            return null;
        }
        if (null == pmPromotion) {
            pmPromotion = new PmPromotion();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotion, (Object)pmPromotionDomain);
            return pmPromotion;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makePromotion", (Throwable)e);
            return null;
        }
    }

    private PmPromotionReDomain makePmPromotionReDomain(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = new PmPromotionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionReDomain, (Object)pmPromotion);
            return pmPromotionReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makePmPromotionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotion> queryPromotionModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.queryPromotionModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotion(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.countPromotion", (Throwable)e);
        }
        return i;
    }

    private PmPromotion createPmPromotion(PmPromotionDomain pmPromotionDomain) {
        String msg = this.checkPromotion(pmPromotionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.savePromotion.checkPromotion", msg);
        }
        PmPromotion pmPromotion = this.makePromotion(pmPromotionDomain, null);
        this.setPromotionDefault(pmPromotion);
        return pmPromotion;
    }

    @Override
    public String savePromotion(PmPromotionDomain pmPromotionDomain) throws ApiException {
        PmPromotion pmPromotion = this.createPmPromotion(pmPromotionDomain);
        pmPromotion.setDataState(this.checkPromotionDataState(pmPromotionDomain.getPromotionBegintime(), pmPromotionDomain.getPromotionEndtime()));
        this.savePromotionModel(pmPromotion);
        String promotionCode = pmPromotion.getPromotionCode();
        this.savePromotionReRelatedData(pmPromotionDomain, promotionCode);
        return promotionCode;
    }

    private Integer checkPromotionDataState(Date beginTime, Date endTime) {
        Integer dataState = PromotionConstants.DATA_STATE_0;
        Date nowDate = new Date();
        if (DateUtils.compareDate((Date)nowDate, (Date)beginTime) < 0 && DateUtils.compareDate((Date)nowDate, (Date)endTime) > 0) {
            dataState = PromotionConstants.DATA_STATE_1;
        } else if (DateUtils.compareDate((Date)nowDate, (Date)endTime) < 0) {
            dataState = PromotionConstants.DATA_STATE_2;
        }
        return dataState;
    }

    private void savePromotionReRelatedData(PmPromotionDomain pmPromotionDomain, String promotionCode) {
        List<PmPromotionDiscountDomain> discountDomainList;
        List<PmPromotionConditionDomain> conditionDomainList;
        List<PmPromotionTerminalDomain> terminalDomainList;
        List<PmPromotionRangelistDomain> rangelistDomainList;
        List<PmPromotionTargetlistDomain> targetlistDomainList = pmPromotionDomain.getPmPromotionTargetList();
        if (null != targetlistDomainList && targetlistDomainList.size() > 0) {
            for (PmPromotionTargetlistDomain targetlistDomain : targetlistDomainList) {
                targetlistDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                targetlistDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                targetlistDomain.setMemberName(pmPromotionDomain.getMemberName());
                targetlistDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                targetlistDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionTargetlistService.savePromotionTargetlistBatch(targetlistDomainList);
        }
        if (null != (rangelistDomainList = pmPromotionDomain.getPmPromotionRangeList()) && rangelistDomainList.size() > 0) {
            for (PmPromotionRangelistDomain rangelistDomain : rangelistDomainList) {
                rangelistDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                rangelistDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                rangelistDomain.setMemberName(pmPromotionDomain.getMemberName());
                rangelistDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                rangelistDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionRangelistService.savePromotionRangelistBatch(rangelistDomainList);
        }
        if (null != (terminalDomainList = pmPromotionDomain.getPmPromotionTerminalList()) && terminalDomainList.size() > 0) {
            for (PmPromotionTerminalDomain terminalDomain : terminalDomainList) {
                terminalDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                terminalDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                terminalDomain.setMemberName(pmPromotionDomain.getMemberName());
                terminalDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                terminalDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionTerminalService.savePromotionTerminalBatch(terminalDomainList);
        }
        if (null != (conditionDomainList = pmPromotionDomain.getPmPromotionConditionList()) && conditionDomainList.size() > 0) {
            for (PmPromotionConditionDomain conditionDomain : conditionDomainList) {
                conditionDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                conditionDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                conditionDomain.setMemberName(pmPromotionDomain.getMemberName());
                conditionDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                conditionDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionConditionService.savePromotionConditionBatch(conditionDomainList);
        }
        if (null != (discountDomainList = pmPromotionDomain.getPmPromotionDiscountList()) && discountDomainList.size() > 0) {
            for (PmPromotionDiscountDomain discountDomain : discountDomainList) {
                discountDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                discountDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                discountDomain.setMemberName(pmPromotionDomain.getMemberName());
                discountDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                discountDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionDiscountService.savePromotionDiscountBatch(discountDomainList);
        }
    }

    private void delPromotionReRelatedData(String tenantCode, String promotionCode) {
        this.pmPromotionTargetlistService.deletePromotionTargetlistByCode(tenantCode, promotionCode);
        this.pmPromotionRangelistService.deletePromotionRangelistByCode(tenantCode, promotionCode);
        this.pmPromotionTerminalService.deletePromotionTerminalByCode(tenantCode, promotionCode);
        this.pmPromotionConditionService.deletePromotionConditionByCode(tenantCode, promotionCode);
        this.pmPromotionDiscountService.deletePromotionDiscountByCode(tenantCode, promotionCode);
        this.pmPromotionDiscountlistService.deletePromotionDiscountlistByCode(tenantCode, promotionCode);
    }

    private void getPromotionReRelatedData(PmPromotion pmPromotion) {
        QueryResult<PmPromotionCondition> conditionQueryResult;
        QueryResult<PmPromotionTerminal> terminalQueryResult;
        QueryResult<PmPromotionRangelist> rangelistQueryResult;
        String tenantCode = pmPromotion.getTenantCode();
        String promotionCode = pmPromotion.getPromotionCode();
        Map paramMap = this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode});
        QueryResult<PmPromotionTargetlist> targetlistQueryResult = this.pmPromotionTargetlistService.queryPromotionTargetlistPage(paramMap);
        if (null != targetlistQueryResult && null != targetlistQueryResult.getList()) {
            pmPromotion.setPmPromotionTargetList(targetlistQueryResult.getList());
        }
        if (null != (rangelistQueryResult = this.pmPromotionRangelistService.queryPromotionRangelistPage(paramMap)) && null != rangelistQueryResult.getList()) {
            pmPromotion.setPmPromotionRangeList(rangelistQueryResult.getList());
        }
        if (null != (terminalQueryResult = this.pmPromotionTerminalService.queryPromotionTerminalPage(paramMap)) && null != terminalQueryResult.getList()) {
            pmPromotion.setPmPromotionTerminalList(terminalQueryResult.getList());
        }
        if (null != (conditionQueryResult = this.pmPromotionConditionService.queryPromotionConditionPage(paramMap)) && null != conditionQueryResult.getList()) {
            pmPromotion.setPmPromotionConditionList(conditionQueryResult.getList());
        }
        this.processDiscountInfo(pmPromotion, tenantCode);
    }

    @Override
    public String savePromotionBatch(List<PmPromotionDomain> pmPromotionDomainList) throws ApiException {
        if (null == pmPromotionDomainList || pmPromotionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotion> pmPromotionList = new ArrayList<PmPromotion>();
        String code = "";
        for (PmPromotionDomain pmPromotionDomain : pmPromotionDomainList) {
            PmPromotion pmPromotion = this.createPmPromotion(pmPromotionDomain);
            code = pmPromotion.getPromotionCode();
            pmPromotionList.add(pmPromotion);
        }
        this.savePromotionBatchModel(pmPromotionList);
        return code;
    }

    @Override
    public void updatePromotionState(Integer promotionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionModel(promotionId, dataState, oldDataState);
    }

    @Override
    public void updatePromotionStateByCode(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionModelByCode(tenantCode, promotionCode, dataState, oldDataState);
    }

    @Override
    public void updatePromotion(PmPromotionDomain pmPromotionDomain) throws ApiException {
        String msg = this.checkPromotion(pmPromotionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotion.checkPromotion", msg);
        }
        PmPromotion oldPmPromotion = this.getPromotionModelById(pmPromotionDomain.getPromotionId());
        if (null == oldPmPromotion) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotion.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotion pmPromotion = this.makePromotion(pmPromotionDomain, oldPmPromotion);
        this.setPromotionUpdataDefault(pmPromotion);
        pmPromotion.setDataState(this.checkPromotionDataState(pmPromotionDomain.getPromotionBegintime(), pmPromotionDomain.getPromotionEndtime()));
        this.updatePromotionModel(pmPromotion);
        this.delPromotionReRelatedData(pmPromotion.getTenantCode(), pmPromotion.getPromotionCode());
        this.savePromotionReRelatedData(pmPromotionDomain, pmPromotion.getPromotionCode());
    }

    @Override
    public PmPromotion getPromotion(Integer promotionId) {
        PmPromotion pmPromotion = this.getPromotionModelById(promotionId);
        this.getPromotionReRelatedData(pmPromotion);
        return pmPromotion;
    }

    @Override
    public void deletePromotion(Integer promotionId) throws ApiException {
        this.deletePromotionModel(promotionId);
    }

    @Override
    public QueryResult<PmPromotion> queryPromotionPage(Map<String, Object> map) {
        List<PmPromotion> pmPromotionList = this.queryPromotionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotion(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionList);
        return queryResult;
    }

    @Override
    public QueryResult<PmPromotion> checkPromotionListByGoodsCode(String tenantCode, String goodsCode, String userCode, Integer terminalType) {
        ArrayList<PmPromotion> resultPromotionList = new ArrayList<PmPromotion>();
        Map param = this.getQueryMapParam("dataState,tenantCode", new Object[]{PromotionConstants.DATA_STATE_1, tenantCode});
        param.put("orderStr", " PRIORITY desc , PROMOTION_BEGINTIME desc ");
        param.put("order", true);
        QueryResult<PmPromotion> queryResult = this.queryPromotionPage(param);
        List pmPromotionList = queryResult.getList();
        if (null != pmPromotionList && pmPromotionList.size() > 0) {
            Date nowDate = new Date();
            for (PmPromotion pmPromotion : pmPromotionList) {
                if (DateUtils.compareDate((Date)pmPromotion.getPromotionBegintime(), (Date)nowDate) < 0) continue;
                if (DateUtils.compareDate((Date)nowDate, (Date)pmPromotion.getPromotionEndtime()) < 0) {
                    this.updateStatePromotionModel(pmPromotion.getPromotionId(), PromotionConstants.DATA_STATE_2, PromotionConstants.DATA_STATE_1);
                    continue;
                }
                String promotionCode = pmPromotion.getPromotionCode();
                Integer rangeType = pmPromotion.getRangeType();
                Integer sendType = pmPromotion.getSendtype();
                if (!sendType.equals(PromotionConstants.SEND_TYPE_1) && !sendType.equals(PromotionConstants.SEND_TYPE_3)) continue;
                if (rangeType.equals(PromotionConstants.RANGE_TYPE_0)) {
                    resultPromotionList.add(pmPromotion);
                    continue;
                }
                if (rangeType.equals(PromotionConstants.RANGE_TYPE_1) || !rangeType.equals(PromotionConstants.RANGE_TYPE_2) && !rangeType.equals(PromotionConstants.RANGE_TYPE_3) && !rangeType.equals(PromotionConstants.RANGE_TYPE_4) && !rangeType.equals(PromotionConstants.RANGE_TYPE_5) || !this.checkPromotionRangeByGoodsCode(promotionCode, goodsCode, tenantCode, rangeType)) continue;
                resultPromotionList.add(pmPromotion);
            }
        }
        if (null != resultPromotionList && resultPromotionList.size() > 0) {
            for (PmPromotion pmPromotion : resultPromotionList) {
                QueryResult<PmPromotionCondition> conditionQueryResult = this.pmPromotionConditionService.queryPromotionConditionPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{pmPromotion.getPromotionCode(), tenantCode}));
                if (null != conditionQueryResult && null != conditionQueryResult.getList()) {
                    pmPromotion.setPmPromotionConditionList(conditionQueryResult.getList());
                }
                this.processDiscountInfo(pmPromotion, tenantCode);
            }
        }
        queryResult.setList(resultPromotionList);
        return queryResult;
    }

    private void processDiscountInfo(PmPromotion pmPromotion, String tenantCode) {
        QueryResult<PmPromotionDiscount> discountQueryResult = this.pmPromotionDiscountService.queryPromotionDiscountPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{pmPromotion.getPromotionCode(), tenantCode}));
        if (null != discountQueryResult && null != discountQueryResult.getList()) {
            List pmPromotionDiscountList = discountQueryResult.getList();
            pmPromotion.setPmPromotionDiscountList(pmPromotionDiscountList);
            for (PmPromotionDiscount pmPromotionDiscount : pmPromotionDiscountList) {
                QueryResult<PmPromotionDiscountlist> discountlistQueryResult = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(this.getQueryParamMap("ppdCode,tenantCode", new Object[]{pmPromotionDiscount.getPpdCode(), tenantCode}));
                List promotionDiscountlists = discountlistQueryResult.getList();
                if (pmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_5 && null != promotionDiscountlists && null != promotionDiscountlists) {
                    for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                        RsSku rsSku = this.rsSkuService.getSkuByCode(this.getQueryParamMap("skuCode,tenantCode", new Object[]{pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode()}));
                        if (null == rsSku) continue;
                        RsResourceGoods rsResourceGoods = this.rsResourceGoodsService.getResourceGoodsByCode(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode()}));
                        rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                        pmPromotionDiscountlist.setRsSku(rsSku);
                    }
                }
                pmPromotionDiscount.setPmPromotionDiscountlistList(promotionDiscountlists);
            }
        }
    }

    @Override
    public Map<String, Object> calcPromotionByOrder(List<PmPromotionCalcDomain> calcDomainList, String contractBillCode, String tenantCode, String userCode, Integer terminalType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DecimalFormat df2 = new DecimalFormat("#.00");
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal selectedAllAmount = BigDecimal.ZERO;
        BigDecimal promotionAllAmount = BigDecimal.ZERO;
        BigDecimal selectedPromotionAllAmount = BigDecimal.ZERO;
        BigDecimal promotionAllBuyAmount = BigDecimal.ZERO;
        BigDecimal selectedPromotionAllBuyAmount = BigDecimal.ZERO;
        HashMap<String, ArrayList<RsSku>> rsSkuMap = new HashMap<String, ArrayList<RsSku>>();
        ArrayList<String> userorderCodeList = new ArrayList<String>();
        ArrayList<Map<String, String>> promotionResultInfo = new ArrayList<Map<String, String>>();
        for (PmPromotionCalcDomain pmPromotionCalcDomain : calcDomainList) {
            PmPromotion pmPromotion;
            int promotionId = pmPromotionCalcDomain.getPromotionId();
            List<SkuInfoDomain> skuInfoDomainList = pmPromotionCalcDomain.getSkuList();
            HashMap<String, BigDecimal> skuPriceMap = new HashMap<String, BigDecimal>();
            if (null != skuInfoDomainList && skuInfoDomainList.size() > 0) {
                for (SkuInfoDomain skuInfoDomain : skuInfoDomainList) {
                    RsSku rsSku = this.rsSkuService.getSkuByCode(this.getQueryParamMap("skuCode,tenantCode", new Object[]{skuInfoDomain.getSkuCode(), tenantCode}));
                    if (null == rsSku) continue;
                    BigDecimal price = skuInfoDomain.getGoodsCamount().multiply(rsSku.getPricesetNprice());
                    skuPriceMap.put(rsSku.getSkuCode(), price);
                    selectedAllAmount = selectedAllAmount.add(price);
                    if (promotionId <= 0) continue;
                    promotionAllAmount = promotionAllAmount.add(price);
                    promotionAllBuyAmount = promotionAllBuyAmount.add(skuInfoDomain.getGoodsCamount());
                    if (skuInfoDomain.getShoppingGoodsCheck() != 0) continue;
                    selectedPromotionAllAmount = selectedPromotionAllAmount.add(price);
                    selectedPromotionAllBuyAmount = selectedPromotionAllBuyAmount.add(skuInfoDomain.getGoodsCamount());
                }
            }
            if (promotionId <= 0 || null == (pmPromotion = this.getPromotionByIdWithoutRelatatedData(promotionId)) || pmPromotion.getDataState() != PromotionConstants.DATA_STATE_1) continue;
            String promotionCode = pmPromotion.getPromotionCode();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("promotionId", promotionId + "");
            map1.put("pbCode", pmPromotion.getPbCode());
            if (pmPromotion.getPbCode().equals("0001")) {
                QueryResult<PmPromotionDiscountlist> discountlistQueryResult;
                PmPromotionDiscount pmPromotionDiscount;
                PmPromotionCondition pmPromotionCondition = null;
                QueryResult<PmPromotionCondition> conditionQueryResult = this.pmPromotionConditionService.queryPromotionConditionPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode}));
                if (null != conditionQueryResult && null != conditionQueryResult.getList()) {
                    pmPromotionCondition = (PmPromotionCondition)conditionQueryResult.getList().get(0);
                    if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
                        if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0 ? promotionAllAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0 : pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1 && promotionAllBuyAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0) {
                            continue;
                        }
                    } else if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_1) {
                        // empty if block
                    }
                }
                if (null == pmPromotionCondition) continue;
                QueryResult<PmPromotionDiscount> discountQueryResult = this.pmPromotionDiscountService.queryPromotionDiscountPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode}));
                if (null != discountQueryResult && null != discountQueryResult.getList() && (pmPromotionDiscount = (PmPromotionDiscount)discountQueryResult.getList().get(0)).getDiscType() == PromotionConstants.DISCOUNT_TYPE_5 && null != (discountlistQueryResult = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(this.getQueryParamMap("ppdCode,tenantCode", new Object[]{pmPromotionDiscount.getPpdCode(), tenantCode}))) && null != discountlistQueryResult.getList()) {
                    List promotionDiscountlists = discountlistQueryResult.getList();
                    for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                        RsSku rsSku = this.rsSkuService.getSkuByCode(this.getQueryParamMap("skuCode,tenantCode", new Object[]{pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode()}));
                        if (null == rsSku) continue;
                        RsResourceGoods rsResourceGoods = this.rsResourceGoodsService.getResourceGoodsByCode(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode()}));
                        rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                        ArrayList<RsSku> rsSkuList = (ArrayList<RsSku>)rsSkuMap.get(pmPromotionDiscount.getMemberCode());
                        if (null == rsSkuList || rsSkuList.size() == 0) {
                            rsSkuList = new ArrayList<RsSku>();
                        }
                        rsSkuList.add(rsSku);
                        rsSkuMap.put(pmPromotionDiscount.getMemberCode(), rsSkuList);
                    }
                    map1.put("pmName", pmPromotion.getPromotionName());
                    promotionResultInfo.add(map1);
                }
                PmUserOrderDomain pmUserOrderDomain = new PmUserOrderDomain();
                pmUserOrderDomain.setAppmanageIcode(pmPromotion.getAppmanageIcode());
                pmUserOrderDomain.setContractBillcode(contractBillCode);
                pmUserOrderDomain.setPromotionCode(pmPromotion.getPromotionCode());
                pmUserOrderDomain.setTenantCode(pmPromotion.getTenantCode());
                pmUserOrderDomain.setUserCode(userCode);
                pmUserOrderDomain.setOriginalAmount(promotionAllAmount);
                pmUserOrderDomain.setDiscountAmount(discountAmount);
                String userorderCode = this.pmUserOrderService.saveUserOrder(pmUserOrderDomain);
                userorderCodeList.add(userorderCode);
                continue;
            }
            if (!pmPromotion.getPbCode().equals("0002")) continue;
            BigDecimal disAmount = this.calcManJianForOrder(promotionResultInfo, pmPromotion, promotionId, promotionAllAmount, promotionAllBuyAmount, selectedPromotionAllAmount, selectedPromotionAllBuyAmount, tenantCode);
            disAmount = pmPromotion.getPromotionMoling() == PromotionConstants.MOLING_1 ? new BigDecimal(disAmount.intValue()) : new BigDecimal(df2.format(disAmount));
            ArrayList<DiscountDataDomain> discountDataDomains = new ArrayList<DiscountDataDomain>();
            int size = skuInfoDomainList.size();
            BigDecimal tempDisAmount = disAmount;
            for (int a = 0; a < size; ++a) {
                DiscountDataDomain discountDataDomain = new DiscountDataDomain();
                SkuInfoDomain skuInfoDomain = skuInfoDomainList.get(a);
                if (a == size - 1) {
                    discountDataDomain.setSkuCode(skuInfoDomain.getSkuCode());
                    discountDataDomain.setDiscountAmount(new BigDecimal(df2.format(tempDisAmount)));
                    discountDataDomains.add(discountDataDomain);
                    break;
                }
                BigDecimal skuPrice = (BigDecimal)skuPriceMap.get(skuInfoDomain.getSkuCode());
                BigDecimal rate = skuPrice.divide(selectedAllAmount);
                BigDecimal skuDiscount = tempDisAmount.multiply(rate);
                discountDataDomain.setSkuCode(skuInfoDomain.getSkuCode());
                discountDataDomain.setDiscountAmount(new BigDecimal(df2.format(skuDiscount)));
                tempDisAmount = tempDisAmount.subtract(skuDiscount);
                discountDataDomains.add(discountDataDomain);
            }
            String discountData = JsonUtil.buildNormalBinder().jsonObject(discountDataDomains);
            PmUserOrderDomain pmUserOrderDomain = new PmUserOrderDomain();
            pmUserOrderDomain.setAppmanageIcode(pmPromotion.getAppmanageIcode());
            pmUserOrderDomain.setContractBillcode(contractBillCode);
            pmUserOrderDomain.setPromotionCode(pmPromotion.getPromotionCode());
            pmUserOrderDomain.setTenantCode(pmPromotion.getTenantCode());
            pmUserOrderDomain.setUserCode(userCode);
            pmUserOrderDomain.setDiscountData(discountData);
            pmUserOrderDomain.setOriginalAmount(promotionAllAmount);
            pmUserOrderDomain.setDiscountAmount(disAmount);
            String userorderCode = this.pmUserOrderService.saveUserOrder(pmUserOrderDomain);
            userorderCodeList.add(userorderCode);
            discountAmount = discountAmount.add(disAmount);
        }
        resultMap.put("promotionResultInfo", promotionResultInfo);
        resultMap.put("discountAmount", new BigDecimal(df2.format(discountAmount)));
        resultMap.put("totalAmount", new BigDecimal(df2.format(selectedAllAmount)));
        resultMap.put("discountGoods", rsSkuMap);
        resultMap.put("userorderCode", userorderCodeList);
        return resultMap;
    }

    @Override
    public Map<String, Object> calcPromotionForShoppingGoods(List<PmPromotionCalcDomain> calcDomainList, String contractBillCode, String tenantCode, String userCode, Integer terminalType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DecimalFormat df2 = new DecimalFormat("#.00");
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal selectedAllAmount = BigDecimal.ZERO;
        BigDecimal promotionAllAmount = BigDecimal.ZERO;
        BigDecimal selectedPromotionAllAmount = BigDecimal.ZERO;
        BigDecimal promotionAllBuyAmount = BigDecimal.ZERO;
        BigDecimal selectedPromotionAllBuyAmount = BigDecimal.ZERO;
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        String userorderCode = "";
        ArrayList<Map<String, String>> promotionResultInfo = new ArrayList<Map<String, String>>();
        for (PmPromotionCalcDomain pmPromotionCalcDomain : calcDomainList) {
            PmPromotion pmPromotion;
            int promotionId = pmPromotionCalcDomain.getPromotionId();
            List<SkuInfoDomain> skuInfoDomainList = pmPromotionCalcDomain.getSkuList();
            if (null != skuInfoDomainList && skuInfoDomainList.size() > 0) {
                for (SkuInfoDomain skuInfoDomain : skuInfoDomainList) {
                    RsSku rsSku = this.rsSkuService.getSkuByCode(this.getQueryParamMap("skuCode,tenantCode", new Object[]{skuInfoDomain.getSkuCode(), tenantCode}));
                    if (null == rsSku) continue;
                    BigDecimal price = skuInfoDomain.getGoodsCamount().multiply(rsSku.getPricesetNprice());
                    if (skuInfoDomain.getShoppingGoodsCheck() == 0) {
                        selectedAllAmount = selectedAllAmount.add(price);
                    }
                    if (promotionId <= 0) continue;
                    promotionAllAmount = promotionAllAmount.add(price);
                    promotionAllBuyAmount = promotionAllBuyAmount.add(skuInfoDomain.getGoodsCamount());
                    if (skuInfoDomain.getShoppingGoodsCheck() != 0) continue;
                    selectedPromotionAllAmount = selectedPromotionAllAmount.add(price);
                    selectedPromotionAllBuyAmount = selectedPromotionAllBuyAmount.add(skuInfoDomain.getGoodsCamount());
                }
            }
            if (promotionId <= 0 || null == (pmPromotion = this.getPromotionByIdWithoutRelatatedData(promotionId)) || pmPromotion.getDataState() != PromotionConstants.DATA_STATE_1) continue;
            String promotionCode = pmPromotion.getPromotionCode();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("promotionId", promotionId + "");
            map1.put("pbCode", pmPromotion.getPbCode());
            if (pmPromotion.getPbCode().equals("0001")) {
                BigDecimal condAmount;
                QueryResult<PmPromotionDiscountlist> discountlistQueryResult;
                PmPromotionDiscount pmPromotionDiscount;
                QueryResult<PmPromotionDiscount> discountQueryResult;
                PmPromotionCondition pmPromotionCondition = null;
                QueryResult<PmPromotionCondition> conditionQueryResult = this.pmPromotionConditionService.queryPromotionConditionPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode}));
                if (null != conditionQueryResult && null != conditionQueryResult.getList()) {
                    pmPromotionCondition = (PmPromotionCondition)conditionQueryResult.getList().get(0);
                    if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
                        String disDesc;
                        BigDecimal condAmount2;
                        BigDecimal needAmount;
                        if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                            if (promotionAllAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0) {
                                needAmount = pmPromotionCondition.getCondAmount().subtract(selectedPromotionAllAmount);
                                needAmount = new BigDecimal(df2.format(needAmount));
                                condAmount2 = new BigDecimal(df2.format(pmPromotionCondition.getCondAmount()));
                                map1.put("disAmonut", "-" + needAmount);
                                disDesc = "\u8d2d\u4e70" + condAmount2 + "\u5143\u9001\u8d60\u54c1,\u8fd8\u5dee" + needAmount + "\u5143";
                                map1.put("disDesc", disDesc);
                                promotionResultInfo.add(map1);
                                continue;
                            }
                        } else if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1 && promotionAllBuyAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0) {
                            needAmount = pmPromotionCondition.getCondAmount().subtract(selectedPromotionAllBuyAmount);
                            needAmount = new BigDecimal(needAmount.intValue());
                            condAmount2 = new BigDecimal(pmPromotionCondition.getCondAmount().intValue());
                            map1.put("disAmonut", "-" + needAmount);
                            disDesc = "\u8d2d\u4e70" + condAmount2 + "\u4ef6\u9001\u8d60\u54c1,\u8fd8\u5dee" + needAmount + "\u4ef6";
                            map1.put("disAmonut", "-" + needAmount);
                            map1.put("disDesc", disDesc);
                            promotionResultInfo.add(map1);
                            continue;
                        }
                    } else if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_1) {
                        // empty if block
                    }
                }
                if (null == pmPromotionCondition || null == (discountQueryResult = this.pmPromotionDiscountService.queryPromotionDiscountPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode}))) || null == discountQueryResult.getList() || (pmPromotionDiscount = (PmPromotionDiscount)discountQueryResult.getList().get(0)).getDiscType() != PromotionConstants.DISCOUNT_TYPE_5 || null == (discountlistQueryResult = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(this.getQueryParamMap("ppdCode,tenantCode", new Object[]{pmPromotionDiscount.getPpdCode(), tenantCode}))) || null == discountlistQueryResult.getList()) continue;
                List promotionDiscountlists = discountlistQueryResult.getList();
                for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                    RsSku rsSku = this.rsSkuService.getSkuByCode(this.getQueryParamMap("skuCode,tenantCode", new Object[]{pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode()}));
                    if (null == rsSku) continue;
                    RsResourceGoods rsResourceGoods = this.rsResourceGoodsService.getResourceGoodsByCode(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode()}));
                    rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                    rsSkuList.add(rsSku);
                }
                String disDesc = "\u5df2\u8d2d\u6ee1";
                if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                    condAmount = new BigDecimal(df2.format(pmPromotionCondition.getCondAmount()));
                    disDesc = disDesc + condAmount + "\u5143,\u5df2\u83b7\u5f97\u8d60\u54c1";
                } else if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1) {
                    condAmount = new BigDecimal(pmPromotionCondition.getCondAmount().intValue());
                    disDesc = disDesc + condAmount + "\u4ef6,\u5df2\u83b7\u5f97\u8d60\u54c1";
                }
                map1.put("disAmonut", "-");
                map1.put("disDesc", disDesc);
                promotionResultInfo.add(map1);
                continue;
            }
            if (!pmPromotion.getPbCode().equals("0002")) continue;
            BigDecimal disAmount = this.calcManJian(promotionResultInfo, pmPromotion.getPbCode(), promotionId, promotionAllAmount, promotionAllBuyAmount, selectedPromotionAllAmount, selectedPromotionAllBuyAmount, promotionCode, tenantCode);
            disAmount = pmPromotion.getPromotionMoling() == PromotionConstants.MOLING_1 ? new BigDecimal(disAmount.intValue()) : new BigDecimal(df2.format(disAmount));
            discountAmount = discountAmount.add(disAmount);
        }
        resultMap.put("promotionResultInfo", promotionResultInfo);
        resultMap.put("discountAmount", new BigDecimal(df2.format(discountAmount)));
        resultMap.put("totalAmount", new BigDecimal(df2.format(selectedAllAmount)));
        resultMap.put("discountGoods", rsSkuList);
        resultMap.put("userorderCode", userorderCode);
        return resultMap;
    }

    private BigDecimal calcManJianForOrder(List<Map<String, String>> promotionResultInfo, PmPromotion pmPromotion, int promotionId, BigDecimal promotionAllAmount, BigDecimal promotionAllBuyAmount, BigDecimal selectedPromotionAllAmount, BigDecimal selectedPromotionAllBuyAmount, String tenantCode) {
        DecimalFormat df2 = new DecimalFormat("#.00");
        QueryResult<PmPromotionCondition> conditionQueryResult = this.pmPromotionConditionService.queryPromotionConditionPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{pmPromotion.getPromotionCode(), tenantCode}));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("promotionId", promotionId + "");
        map1.put("pbCode", pmPromotion.getPbCode());
        map1.put("pmName", pmPromotion.getPromotionName());
        if (null != conditionQueryResult && null != conditionQueryResult.getList()) {
            List conditionList = conditionQueryResult.getList();
            PmPromotionCondition finalCondition = null;
            for (PmPromotionCondition condition : conditionList) {
                if (condition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
                    int resultAmount = promotionAllAmount.compareTo(condition.getCondAmount());
                    int resultBuyAmount = promotionAllBuyAmount.compareTo(condition.getCondAmount());
                    if (condition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                        if (resultAmount >= 0) {
                            finalCondition = condition;
                            continue;
                        }
                        promotionResultInfo.add(map1);
                        break;
                    }
                    if (condition.getCondConstraint() != PromotionConstants.CONDITION_CONSTRAINT_TYPE_1) continue;
                    if (resultBuyAmount >= 0) {
                        finalCondition = condition;
                        continue;
                    }
                    promotionResultInfo.add(map1);
                    break;
                }
                if (condition.getCondType() != PromotionConstants.CONDITION_TYPE_1) continue;
            }
            BigDecimal disAmonut = new BigDecimal(0);
            if (null != finalCondition) {
                int resultBuyAmount;
                if (finalCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                    int resultAmount = selectedPromotionAllAmount.compareTo(finalCondition.getCondAmount());
                    if (resultAmount < 0) {
                        promotionResultInfo.add(map1);
                        return disAmonut;
                    }
                } else if (finalCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1 && (resultBuyAmount = selectedPromotionAllBuyAmount.compareTo(finalCondition.getCondAmount())) < 0) {
                    promotionResultInfo.add(map1);
                    return disAmonut;
                }
                BigDecimal discountAmount = BigDecimal.ZERO;
                if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_0) {
                    if (finalCondition.getCondLimit() == PromotionConstants.CONDITION_LIMIT_1) {
                        BigDecimal times = selectedPromotionAllAmount.divideToIntegralValue(finalCondition.getCondAmount());
                        discountAmount = selectedPromotionAllAmount.subtract(finalCondition.getCondResultAmount().multiply(times));
                    } else {
                        discountAmount = selectedPromotionAllAmount.subtract(finalCondition.getCondResultAmount());
                    }
                    disAmonut = new BigDecimal(df2.format(selectedPromotionAllAmount.subtract(discountAmount)));
                } else if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_1) {
                    discountAmount = selectedPromotionAllAmount.multiply(finalCondition.getCondResultAmount().divide(new BigDecimal(100)));
                    disAmonut = new BigDecimal(df2.format(selectedPromotionAllAmount.subtract(discountAmount)));
                }
                promotionResultInfo.add(map1);
                return disAmonut;
            }
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal calcManJian(List<Map<String, String>> promotionResultInfo, String pbCode, int promotionId, BigDecimal promotionAllAmount, BigDecimal promotionAllBuyAmount, BigDecimal selectedPromotionAllAmount, BigDecimal selectedPromotionAllBuyAmount, String promotionCode, String tenantCode) {
        DecimalFormat df2 = new DecimalFormat("#.00");
        QueryResult<PmPromotionCondition> conditionQueryResult = this.pmPromotionConditionService.queryPromotionConditionPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode}));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("promotionId", promotionId + "");
        map1.put("pbCode", pbCode);
        if (null != conditionQueryResult && null != conditionQueryResult.getList()) {
            int resultAmount;
            List conditionList = conditionQueryResult.getList();
            PmPromotionCondition finalCondition = null;
            for (PmPromotionCondition condition : conditionList) {
                if (condition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
                    resultAmount = promotionAllAmount.compareTo(condition.getCondAmount());
                    int resultBuyAmount = promotionAllBuyAmount.compareTo(condition.getCondAmount());
                    if (condition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                        if (resultAmount >= 0) {
                            finalCondition = condition;
                            continue;
                        }
                        map1.put("disDesc", this.showPmDisDescForType0(finalCondition, selectedPromotionAllAmount, map1));
                        promotionResultInfo.add(map1);
                        break;
                    }
                    if (condition.getCondConstraint() != PromotionConstants.CONDITION_CONSTRAINT_TYPE_1) continue;
                    if (resultBuyAmount >= 0) {
                        finalCondition = condition;
                        continue;
                    }
                    map1.put("disDesc", this.showPmDisDescForType1(finalCondition, selectedPromotionAllBuyAmount, map1));
                    promotionResultInfo.add(map1);
                    break;
                }
                if (condition.getCondType() != PromotionConstants.CONDITION_TYPE_1) continue;
            }
            BigDecimal disAmonut = new BigDecimal(0);
            if (null != finalCondition) {
                String disDesc = "\u5df2\u8d2d\u6ee1";
                if (finalCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                    resultAmount = selectedPromotionAllAmount.compareTo(finalCondition.getCondAmount());
                    if (resultAmount < 0) {
                        map1.put("disDesc", this.showPmDisDescForType0(finalCondition, selectedPromotionAllAmount, map1));
                        promotionResultInfo.add(map1);
                        return disAmonut;
                    }
                    BigDecimal condAmount = new BigDecimal(df2.format(finalCondition.getCondAmount()));
                    disDesc = disDesc + condAmount + "\u5143,";
                } else if (finalCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1) {
                    int resultBuyAmount = selectedPromotionAllBuyAmount.compareTo(finalCondition.getCondAmount());
                    if (resultBuyAmount < 0) {
                        map1.put("disDesc", this.showPmDisDescForType1(finalCondition, selectedPromotionAllBuyAmount, map1));
                        promotionResultInfo.add(map1);
                        return disAmonut;
                    }
                    BigDecimal condAmount = new BigDecimal(finalCondition.getCondAmount().intValue());
                    disDesc = disDesc + condAmount + "\u4ef6,";
                }
                BigDecimal discountAmount = new BigDecimal(0);
                if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_0) {
                    if (finalCondition.getCondLimit() == PromotionConstants.CONDITION_LIMIT_1) {
                        BigDecimal times = selectedPromotionAllAmount.divideToIntegralValue(finalCondition.getCondAmount());
                        discountAmount = selectedPromotionAllAmount.subtract(finalCondition.getCondResultAmount().multiply(times));
                    } else {
                        discountAmount = selectedPromotionAllAmount.subtract(finalCondition.getCondResultAmount());
                    }
                    disAmonut = new BigDecimal(df2.format(selectedPromotionAllAmount.subtract(discountAmount)));
                    disDesc = disDesc + "\u5df2\u51cf" + disAmonut + "\u5143";
                } else if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_1) {
                    discountAmount = selectedPromotionAllAmount.multiply(finalCondition.getCondResultAmount().divide(new BigDecimal(100)));
                    BigDecimal zhe = finalCondition.getCondResultAmount().divide(new BigDecimal(10));
                    disDesc = disDesc + "\u5df2\u6253" + zhe.stripTrailingZeros().toPlainString() + "\u6298";
                    disAmonut = new BigDecimal(df2.format(selectedPromotionAllAmount.subtract(discountAmount)));
                }
                map1.put("disAmonut", "" + disAmonut);
                map1.put("disDesc", disDesc);
                promotionResultInfo.add(map1);
                return disAmonut;
            }
        }
        return new BigDecimal(0);
    }

    private String showPmDisDescForType0(PmPromotionCondition finalCondition, BigDecimal selectedPromotionAllAmount, Map<String, String> map1) {
        BigDecimal needAmount = finalCondition.getCondAmount().subtract(selectedPromotionAllAmount);
        DecimalFormat df2 = new DecimalFormat("#.00");
        needAmount = new BigDecimal(df2.format(needAmount));
        BigDecimal condAmount = new BigDecimal(df2.format(finalCondition.getCondAmount()));
        map1.put("disAmonut", "-" + needAmount);
        String disDesc = "\u8d2d\u6ee1" + condAmount + "\u5143" + this.processPmDisDesc(finalCondition) + ",\u8fd8\u5dee" + needAmount + "\u5143";
        return disDesc;
    }

    private String processPmDisDesc(PmPromotionCondition finalCondition) {
        String disDesc = "";
        if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_0) {
            DecimalFormat df2 = new DecimalFormat("#.00");
            BigDecimal condResultAmount = new BigDecimal(df2.format(finalCondition.getCondResultAmount()));
            disDesc = disDesc + "\u51cf" + condResultAmount + "\u5143";
        } else if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_1) {
            BigDecimal zhe = finalCondition.getCondResultAmount().divide(new BigDecimal(10));
            disDesc = disDesc + "\u6253" + zhe.stripTrailingZeros().toPlainString() + "\u6298";
        }
        return disDesc;
    }

    private String showPmDisDescForType1(PmPromotionCondition finalCondition, BigDecimal selectedPromotionAllBuyAmount, Map<String, String> map1) {
        BigDecimal needAmount = finalCondition.getCondAmount().subtract(selectedPromotionAllBuyAmount);
        needAmount = new BigDecimal(needAmount.intValue());
        BigDecimal condAmount = new BigDecimal(finalCondition.getCondAmount().intValue());
        map1.put("disAmonut", "-" + needAmount);
        String disDesc = "\u8d2d\u6ee1" + condAmount + "\u4ef6" + this.processPmDisDesc(finalCondition) + ",\u8fd8\u5dee" + needAmount + "\u4ef6";
        return disDesc;
    }

    @Override
    public Map<String, Object> checkPromotionUserOrder(String contractBillCode, String tenantCode, String userorderCode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        PmUserOrder pmUserOrder = this.pmUserOrderService.getUserOrderByCode(tenantCode, userorderCode);
        BigDecimal discountAmount = new BigDecimal(0);
        if (null != pmUserOrder) {
            discountAmount = pmUserOrder.getDiscountAmount();
        }
        resultMap.put("discountAmount", discountAmount);
        return resultMap;
    }

    @Override
    public Map<String, Object> promotionByFinishOrder(String contractBillCode, String tenantCode, String userCode) {
        QueryResult<PmUserOrder> userOrderQueryResult = this.pmUserOrderService.queryUserOrderPage(this.getQueryParamMap("contractBillcode,userCode,tenantCode", new Object[]{contractBillCode, userCode, tenantCode}));
        if (null != userOrderQueryResult && null != userOrderQueryResult.getList()) {
            PmUserOrder pmUserOrder = (PmUserOrder)userOrderQueryResult.getList().get(0);
            PmPromotion pmPromotion = this.getPromotionByCodeWithoutRelatatedData(tenantCode, pmUserOrder.getPromotionCode());
            if (null != pmPromotion && pmPromotion.getDataState() != PromotionConstants.DATA_STATE_1) {
                return null;
            }
            if (pmPromotion.getPbCode().equals("0001")) {
                // empty if block
            }
            this.pmUserOrderService.updateUserOrderStateByCode(pmUserOrder.getTenantCode(), pmUserOrder.getUserorderCode(), PromotionConstants.USERORDER_DATA_STATE_1, PromotionConstants.USERORDER_DATA_STATE_0);
        }
        return null;
    }

    private boolean checkPromotionRangeByGoodsCode(String promotionCode, String goodsCode, String tenantCode, Integer rangeType) {
        Map rsParam = this.getQueryMapParam("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode});
        RsResourceGoods rsResourceGoods = this.rsResourceGoodsService.getResourceGoodsByCode(rsParam);
        if (null != rsResourceGoods) {
            String rangeCode = "";
            if (rangeType.equals(PromotionConstants.RANGE_TYPE_2)) {
                rangeCode = rsResourceGoods.getPntreeCode();
            } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_3)) {
                rangeCode = rsResourceGoods.getBrandCode();
            } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_4)) {
                rangeCode = rsResourceGoods.getClasstreeCode();
            } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_5)) {
                rangeCode = rsResourceGoods.getGoodsCode();
            }
            QueryResult<PmPromotionRangelist> rangelistQueryResult = this.pmPromotionRangelistService.queryPromotionRangelistPage(this.getQueryMapParam("promotionCode,rangeCode,tenantCode", new Object[]{promotionCode, rangeCode, tenantCode}));
            return null != rangelistQueryResult && null != rangelistQueryResult.getList() && rangelistQueryResult.getList().size() > 0;
        }
        return false;
    }

    private PmPromotion getPromotionByCodeWithoutRelatatedData(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        PmPromotion pmPromotion = this.getPromotionModelByCode(map);
        return pmPromotion;
    }

    private PmPromotion getPromotionByIdWithoutRelatatedData(Integer promotionId) throws ApiException {
        HashMap map = new HashMap();
        PmPromotion pmPromotion = this.getPromotionModelById(promotionId);
        return pmPromotion;
    }

    @Override
    public PmPromotion getPromotionByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        PmPromotion pmPromotion = this.getPromotionModelByCode(map);
        this.getPromotionReRelatedData(pmPromotion);
        return pmPromotion;
    }

    @Override
    public void deletePromotionByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionModelByCode(map);
    }
}

