/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPromotionTerminalMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionTerminalDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionTerminalReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotionTerminal;
import com.yqbsoft.laser.service.pm.service.PmPromotionTerminalService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionTerminalServiceImpl
extends BaseServiceImpl
implements PmPromotionTerminalService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionTerminalServiceImpl";
    private PmPromotionTerminalMapper pmPromotionTerminalMapper;

    public void setPmPromotionTerminalMapper(PmPromotionTerminalMapper pmPromotionTerminalMapper) {
        this.pmPromotionTerminalMapper = pmPromotionTerminalMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionTerminalMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionTerminalServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotionTerminal(PmPromotionTerminalDomain pmPromotionTerminalDomain) {
        if (null == pmPromotionTerminalDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionTerminalDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionTerminalDefault(PmPromotionTerminal pmPromotionTerminal) {
        if (null == pmPromotionTerminal) {
            return;
        }
        if (null == pmPromotionTerminal.getDataState()) {
            pmPromotionTerminal.setDataState(0);
        }
        if (null == pmPromotionTerminal.getGmtCreate()) {
            pmPromotionTerminal.setGmtCreate(this.getSysDate());
        }
        pmPromotionTerminal.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmPromotionTerminal.getPptCode())) {
            pmPromotionTerminal.setPptCode(this.createUUIDString());
        }
    }

    private int getPromotionTerminalMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionTerminalMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionTerminalServiceImpl.getPromotionTerminalMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionTerminalUpdataDefault(PmPromotionTerminal pmPromotionTerminal) {
        if (null == pmPromotionTerminal) {
            return;
        }
        pmPromotionTerminal.setGmtModified(this.getSysDate());
    }

    private void savePromotionTerminalModel(PmPromotionTerminal pmPromotionTerminal) throws ApiException {
        if (null == pmPromotionTerminal) {
            return;
        }
        try {
            this.pmPromotionTerminalMapper.insert(pmPromotionTerminal);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.savePromotionTerminalModel.ex", (Throwable)e);
        }
    }

    private void savePromotionTerminalBatchModel(List<PmPromotionTerminal> pmPromotionTerminalList) throws ApiException {
        if (null == pmPromotionTerminalList || pmPromotionTerminalList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionTerminalMapper.insertBatch(pmPromotionTerminalList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.savePromotionTerminalBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotionTerminal getPromotionTerminalModelById(Integer pptId) {
        if (null == pptId) {
            return null;
        }
        try {
            return this.pmPromotionTerminalMapper.selectByPrimaryKey(pptId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionTerminalServiceImpl.getPromotionTerminalModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotionTerminal getPromotionTerminalModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionTerminalMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionTerminalServiceImpl.getPromotionTerminalModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionTerminalModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionTerminalMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.delPromotionTerminalModelByCode.ex", (Throwable)e);
        }
    }

    private void deletePromotionTerminalModel(Integer pptId) throws ApiException {
        if (null == pptId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionTerminalMapper.deleteByPrimaryKey(pptId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.deletePromotionTerminalModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.deletePromotionTerminalModel.num");
        }
    }

    private void updatePromotionTerminalModel(PmPromotionTerminal pmPromotionTerminal) throws ApiException {
        if (null == pmPromotionTerminal) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionTerminalMapper.updateByPrimaryKeySelective(pmPromotionTerminal);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.updatePromotionTerminalModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.updatePromotionTerminalModel.num");
        }
    }

    private void updateStatePromotionTerminalModel(Integer pptId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pptId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pptId", pptId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionTerminalMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.updateStatePromotionTerminalModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.updateStatePromotionTerminalModel.null");
        }
    }

    private void updateStatePromotionTerminalModelByCode(String tenantCode, String pptCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)pptCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pptCode", pptCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionTerminalMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.updateStatePromotionTerminalModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.updateStatePromotionTerminalModelByCode.null");
        }
    }

    private PmPromotionTerminal makePromotionTerminal(PmPromotionTerminalDomain pmPromotionTerminalDomain, PmPromotionTerminal pmPromotionTerminal) {
        if (null == pmPromotionTerminalDomain) {
            return null;
        }
        if (null == pmPromotionTerminal) {
            pmPromotionTerminal = new PmPromotionTerminal();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionTerminal, (Object)pmPromotionTerminalDomain);
            return pmPromotionTerminal;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionTerminalServiceImpl.makePromotionTerminal", (Throwable)e);
            return null;
        }
    }

    private PmPromotionTerminalReDomain makePmPromotionTerminalReDomain(PmPromotionTerminal pmPromotionTerminal) {
        if (null == pmPromotionTerminal) {
            return null;
        }
        PmPromotionTerminalReDomain pmPromotionTerminalReDomain = new PmPromotionTerminalReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionTerminalReDomain, (Object)pmPromotionTerminal);
            return pmPromotionTerminalReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionTerminalServiceImpl.makePmPromotionTerminalReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotionTerminal> queryPromotionTerminalModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionTerminalMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionTerminalServiceImpl.queryPromotionTerminalModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionTerminal(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionTerminalMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionTerminalServiceImpl.countPromotionTerminal", (Throwable)e);
        }
        return i;
    }

    private PmPromotionTerminal createPmPromotionTerminal(PmPromotionTerminalDomain pmPromotionTerminalDomain) {
        String msg = this.checkPromotionTerminal(pmPromotionTerminalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.savePromotionTerminal.checkPromotionTerminal", msg);
        }
        PmPromotionTerminal pmPromotionTerminal = this.makePromotionTerminal(pmPromotionTerminalDomain, null);
        this.setPromotionTerminalDefault(pmPromotionTerminal);
        return pmPromotionTerminal;
    }

    @Override
    public String savePromotionTerminal(PmPromotionTerminalDomain pmPromotionTerminalDomain) throws ApiException {
        PmPromotionTerminal pmPromotionTerminal = this.createPmPromotionTerminal(pmPromotionTerminalDomain);
        this.savePromotionTerminalModel(pmPromotionTerminal);
        return pmPromotionTerminal.getPptCode();
    }

    @Override
    public String savePromotionTerminalBatch(List<PmPromotionTerminalDomain> pmPromotionTerminalDomainList) throws ApiException {
        if (null == pmPromotionTerminalDomainList || pmPromotionTerminalDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotionTerminal> pmPromotionTerminalList = new ArrayList<PmPromotionTerminal>();
        String code = "";
        for (PmPromotionTerminalDomain pmPromotionTerminalDomain : pmPromotionTerminalDomainList) {
            PmPromotionTerminal pmPromotionTerminal = this.createPmPromotionTerminal(pmPromotionTerminalDomain);
            code = pmPromotionTerminal.getPptCode();
            pmPromotionTerminalList.add(pmPromotionTerminal);
        }
        this.savePromotionTerminalBatchModel(pmPromotionTerminalList);
        return code;
    }

    @Override
    public void updatePromotionTerminalState(Integer pptId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionTerminalModel(pptId, dataState, oldDataState);
    }

    @Override
    public void updatePromotionTerminalStateByCode(String tenantCode, String pptCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionTerminalModelByCode(tenantCode, pptCode, dataState, oldDataState);
    }

    @Override
    public void updatePromotionTerminal(PmPromotionTerminalDomain pmPromotionTerminalDomain) throws ApiException {
        String msg = this.checkPromotionTerminal(pmPromotionTerminalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.updatePromotionTerminal.checkPromotionTerminal", msg);
        }
        PmPromotionTerminal oldPmPromotionTerminal = this.getPromotionTerminalModelById(pmPromotionTerminalDomain.getPptId());
        if (null == oldPmPromotionTerminal) {
            throw new ApiException("pm.PROMOTION.PmPromotionTerminalServiceImpl.updatePromotionTerminal.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotionTerminal pmPromotionTerminal = this.makePromotionTerminal(pmPromotionTerminalDomain, oldPmPromotionTerminal);
        this.setPromotionTerminalUpdataDefault(pmPromotionTerminal);
        this.updatePromotionTerminalModel(pmPromotionTerminal);
    }

    @Override
    public PmPromotionTerminal getPromotionTerminal(Integer pptId) {
        return this.getPromotionTerminalModelById(pptId);
    }

    @Override
    public void deletePromotionTerminal(Integer pptId) throws ApiException {
        this.deletePromotionTerminalModel(pptId);
    }

    @Override
    public QueryResult<PmPromotionTerminal> queryPromotionTerminalPage(Map<String, Object> map) {
        List<PmPromotionTerminal> pmPromotionTerminalList = this.queryPromotionTerminalModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionTerminal(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionTerminalList);
        return queryResult;
    }

    @Override
    public PmPromotionTerminal getPromotionTerminalByCode(String tenantCode, String pptCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pptCode", pptCode);
        return this.getPromotionTerminalModelByCode(map);
    }

    @Override
    public void deletePromotionTerminalByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionTerminalModelByCode(map);
    }
}

