/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPromotionBaseMapper;
import com.yqbsoft.laser.service.pm.dao.PmPromotionMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionBaseDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionBaseReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotionBase;
import com.yqbsoft.laser.service.pm.service.PmPromotionBaseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionBaseServiceImpl
extends BaseServiceImpl
implements PmPromotionBaseService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionBaseServiceImpl";
    private PmPromotionBaseMapper pmPromotionBaseMapper;
    private PmPromotionMapper pmPromotionMapper;

    public void setPmPromotionBaseMapper(PmPromotionBaseMapper pmPromotionBaseMapper) {
        this.pmPromotionBaseMapper = pmPromotionBaseMapper;
    }

    public void setPmPromotionMapper(PmPromotionMapper pmPromotionMapper) {
        this.pmPromotionMapper = pmPromotionMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionBaseMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionBaseServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotionBase(PmPromotionBaseDomain pmPromotionBaseDomain) {
        if (null == pmPromotionBaseDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionBaseDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionBaseDefault(PmPromotionBase pmPromotionBase) {
        if (null == pmPromotionBase) {
            return;
        }
        if (null == pmPromotionBase.getDataState()) {
            pmPromotionBase.setDataState(0);
        }
        if (null == pmPromotionBase.getGmtCreate()) {
            pmPromotionBase.setGmtCreate(this.getSysDate());
        }
        pmPromotionBase.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmPromotionBase.getPbCode())) {
            pmPromotionBase.setPbCode(this.createUUIDString());
        }
    }

    private int getPromotionBaseMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionBaseMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionBaseServiceImpl.getPromotionBaseMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionBaseUpdataDefault(PmPromotionBase pmPromotionBase) {
        if (null == pmPromotionBase) {
            return;
        }
        pmPromotionBase.setGmtModified(this.getSysDate());
    }

    private void savePromotionBaseModel(PmPromotionBase pmPromotionBase) throws ApiException {
        if (null == pmPromotionBase) {
            return;
        }
        try {
            this.pmPromotionBaseMapper.insert(pmPromotionBase);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.savePromotionBaseModel.ex", (Throwable)e);
        }
    }

    private void savePromotionBaseBatchModel(List<PmPromotionBase> pmPromotionBaseList) throws ApiException {
        if (null == pmPromotionBaseList || pmPromotionBaseList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionBaseMapper.insertBatch(pmPromotionBaseList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.savePromotionBaseBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotionBase getPromotionBaseModelById(Integer pbId) {
        if (null == pbId) {
            return null;
        }
        try {
            return this.pmPromotionBaseMapper.selectByPrimaryKey(pbId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionBaseServiceImpl.getPromotionBaseModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotionBase getPromotionBaseModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionBaseMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionBaseServiceImpl.getPromotionBaseModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionBaseModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionBaseMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.delPromotionBaseModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.delPromotionBaseModelByCode.num");
        }
    }

    private void deletePromotionBaseModel(Integer pbId) throws ApiException {
        if (null == pbId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionBaseMapper.deleteByPrimaryKey(pbId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.deletePromotionBaseModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.deletePromotionBaseModel.num");
        }
    }

    private void updatePromotionBaseModel(PmPromotionBase pmPromotionBase) throws ApiException {
        if (null == pmPromotionBase) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionBaseMapper.updateByPrimaryKeySelective(pmPromotionBase);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updatePromotionBaseModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updatePromotionBaseModel.num");
        }
    }

    private void updateStatePromotionBaseModel(Integer pbId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pbId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pbId", pbId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionBaseMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updateStatePromotionBaseModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updateStatePromotionBaseModel.null");
        }
    }

    private void updateStatePromotionBaseModelByCode(String tenantCode, String pbCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)pbCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pbCode", pbCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionBaseMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updateStatePromotionBaseModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updateStatePromotionBaseModelByCode.null");
        }
    }

    private void updatePriorityPromotionBaseModelById(Integer pbId, Integer priority) throws ApiException {
        if (StringUtils.isBlank((Integer)pbId) || null == pbId) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pbId", pbId);
        map.put("priority", priority);
        int i = 0;
        try {
            i = this.pmPromotionBaseMapper.updatePriorityById(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updatePriorityPromotionBaseModelById.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updatePriorityPromotionBaseModelById.null");
        }
    }

    @Override
    public int updatePromotionBasePriority(Integer pbId, Integer priority, String tenantCode) {
        PmPromotionBase pmPromotionBase = this.pmPromotionBaseMapper.getPromotionByPriority(this.getQueryParamMap("priority,tenantCode", new Object[]{priority, tenantCode}));
        if (null != pmPromotionBase) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("tenantCode", tenantCode);
            paramMap.put("pbCode", pmPromotionBase.getPbCode());
            paramMap.put("priority", priority);
            this.pmPromotionMapper.updatePmPriorityByPbCode(paramMap);
            return 0;
        }
        this.updatePriorityPromotionBaseModelById(pbId, priority);
        return 1;
    }

    private PmPromotionBase makePromotionBase(PmPromotionBaseDomain pmPromotionBaseDomain, PmPromotionBase pmPromotionBase) {
        if (null == pmPromotionBaseDomain) {
            return null;
        }
        if (null == pmPromotionBase) {
            pmPromotionBase = new PmPromotionBase();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionBase, (Object)pmPromotionBaseDomain);
            return pmPromotionBase;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionBaseServiceImpl.makePromotionBase", (Throwable)e);
            return null;
        }
    }

    private PmPromotionBaseReDomain makePmPromotionBaseReDomain(PmPromotionBase pmPromotionBase) {
        if (null == pmPromotionBase) {
            return null;
        }
        PmPromotionBaseReDomain pmPromotionBaseReDomain = new PmPromotionBaseReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionBaseReDomain, (Object)pmPromotionBase);
            return pmPromotionBaseReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionBaseServiceImpl.makePmPromotionBaseReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotionBase> queryPromotionBaseModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionBaseMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionBaseServiceImpl.queryPromotionBaseModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionBase(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionBaseMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionBaseServiceImpl.countPromotionBase", (Throwable)e);
        }
        return i;
    }

    private PmPromotionBase createPmPromotionBase(PmPromotionBaseDomain pmPromotionBaseDomain) {
        String msg = this.checkPromotionBase(pmPromotionBaseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.savePromotionBase.checkPromotionBase", msg);
        }
        PmPromotionBase pmPromotionBase = this.makePromotionBase(pmPromotionBaseDomain, null);
        this.setPromotionBaseDefault(pmPromotionBase);
        return pmPromotionBase;
    }

    @Override
    public String savePromotionBase(PmPromotionBaseDomain pmPromotionBaseDomain) throws ApiException {
        PmPromotionBase pmPromotionBase = this.createPmPromotionBase(pmPromotionBaseDomain);
        this.savePromotionBaseModel(pmPromotionBase);
        return pmPromotionBase.getPbCode();
    }

    @Override
    public String savePromotionBaseBatch(List<PmPromotionBaseDomain> pmPromotionBaseDomainList) throws ApiException {
        if (null == pmPromotionBaseDomainList || pmPromotionBaseDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotionBase> pmPromotionBaseList = new ArrayList<PmPromotionBase>();
        String code = "";
        for (PmPromotionBaseDomain pmPromotionBaseDomain : pmPromotionBaseDomainList) {
            PmPromotionBase pmPromotionBase = this.createPmPromotionBase(pmPromotionBaseDomain);
            code = pmPromotionBase.getPbCode();
            pmPromotionBaseList.add(pmPromotionBase);
        }
        this.savePromotionBaseBatchModel(pmPromotionBaseList);
        return code;
    }

    @Override
    public void updatePromotionBaseState(Integer pbId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionBaseModel(pbId, dataState, oldDataState);
    }

    @Override
    public void updatePromotionBaseStateByCode(String tenantCode, String pbCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionBaseModelByCode(tenantCode, pbCode, dataState, oldDataState);
    }

    @Override
    public void updatePromotionBase(PmPromotionBaseDomain pmPromotionBaseDomain) throws ApiException {
        String msg = this.checkPromotionBase(pmPromotionBaseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updatePromotionBase.checkPromotionBase", msg);
        }
        PmPromotionBase oldPmPromotionBase = this.getPromotionBaseModelById(pmPromotionBaseDomain.getPbId());
        if (null == oldPmPromotionBase) {
            throw new ApiException("pm.PROMOTION.PmPromotionBaseServiceImpl.updatePromotionBase.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotionBase pmPromotionBase = this.makePromotionBase(pmPromotionBaseDomain, oldPmPromotionBase);
        this.setPromotionBaseUpdataDefault(pmPromotionBase);
        this.updatePromotionBaseModel(pmPromotionBase);
    }

    @Override
    public PmPromotionBase getPromotionBase(Integer pbId) {
        return this.getPromotionBaseModelById(pbId);
    }

    @Override
    public void deletePromotionBase(Integer pbId) throws ApiException {
        this.deletePromotionBaseModel(pbId);
    }

    @Override
    public QueryResult<PmPromotionBase> queryPromotionBasePage(Map<String, Object> map) {
        List<PmPromotionBase> pmPromotionBaseList = this.queryPromotionBaseModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionBase(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionBaseList);
        return queryResult;
    }

    @Override
    public PmPromotionBase getPromotionBaseByCode(String tenantCode, String pbCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pbCode", pbCode);
        return this.getPromotionBaseModelByCode(map);
    }

    @Override
    public void deletePromotionBaseByCode(String tenantCode, String pbCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pbCode", pbCode);
        this.delPromotionBaseModelByCode(map);
    }
}

