/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPromotionInMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionInDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionInReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotionIn;
import com.yqbsoft.laser.service.pm.service.PmPromotionInService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionInServiceImpl
extends BaseServiceImpl
implements PmPromotionInService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionInServiceImpl";
    private PmPromotionInMapper pmPromotionInMapper;

    public void setPmPromotionInMapper(PmPromotionInMapper pmPromotionInMapper) {
        this.pmPromotionInMapper = pmPromotionInMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionInMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionInServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotionIn(PmPromotionInDomain pmPromotionInDomain) {
        if (null == pmPromotionInDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionInDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionInDefault(PmPromotionIn pmPromotionIn) {
        if (null == pmPromotionIn) {
            return;
        }
        if (null == pmPromotionIn.getDataState()) {
            pmPromotionIn.setDataState(1);
        }
        if (null == pmPromotionIn.getGmtCreate()) {
            pmPromotionIn.setGmtCreate(this.getSysDate());
        }
        pmPromotionIn.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmPromotionIn.getPromotionInCode())) {
            pmPromotionIn.setPromotionInCode(this.createUUIDString());
        }
    }

    private int getPromotionInMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionInMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionInServiceImpl.getPromotionInMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionInUpdataDefault(PmPromotionIn pmPromotionIn) {
        if (null == pmPromotionIn) {
            return;
        }
        pmPromotionIn.setGmtModified(this.getSysDate());
    }

    private void savePromotionInModel(PmPromotionIn pmPromotionIn) throws ApiException {
        if (null == pmPromotionIn) {
            return;
        }
        try {
            this.pmPromotionInMapper.insert(pmPromotionIn);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.savePromotionInModel.ex", (Throwable)e);
        }
    }

    private void savePromotionInBatchModel(List<PmPromotionIn> pmPromotionInList) throws ApiException {
        if (null == pmPromotionInList || pmPromotionInList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionInMapper.insertBatch(pmPromotionInList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.savePromotionInBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotionIn getPromotionInModelById(Integer promotionInId) {
        if (null == promotionInId) {
            return null;
        }
        try {
            return this.pmPromotionInMapper.selectByPrimaryKey(promotionInId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionInServiceImpl.getPromotionInModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotionIn getPromotionInModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionInMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionInServiceImpl.getPromotionInModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionInModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionInMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.delPromotionInModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.delPromotionInModelByCode.num");
        }
    }

    private void delPromotionInModelByPromotionCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionInMapper.delByPromotionCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.delPromotionInModelByPromotionCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.delPromotionInModelByPromotionCode.num");
        }
    }

    private void deletePromotionInModel(Integer promotionInId) throws ApiException {
        if (null == promotionInId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionInMapper.deleteByPrimaryKey(promotionInId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.deletePromotionInModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.deletePromotionInModel.num");
        }
    }

    private void updatePromotionInModel(PmPromotionIn pmPromotionIn) throws ApiException {
        if (null == pmPromotionIn) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionInMapper.updateByPrimaryKey(pmPromotionIn);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updatePromotionInModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updatePromotionInModel.num");
        }
    }

    private void updateStatePromotionInModel(Integer promotionInId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == promotionInId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promotionInId", promotionInId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPromotionInMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateStatePromotionInModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateStatePromotionInModel.null");
        }
    }

    private void updateStatePromotionInModelByCode(String tenantCode, String promotionInCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)promotionInCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionInCode", promotionInCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPromotionInMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateStatePromotionInModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateStatePromotionInModelByCode.null");
        }
    }

    private PmPromotionIn makePromotionIn(PmPromotionInDomain pmPromotionInDomain, PmPromotionIn pmPromotionIn) {
        if (null == pmPromotionInDomain) {
            return null;
        }
        if (null == pmPromotionIn) {
            pmPromotionIn = new PmPromotionIn();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionIn, (Object)pmPromotionInDomain);
            return pmPromotionIn;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionInServiceImpl.makePromotionIn", (Throwable)e);
            return null;
        }
    }

    private PmPromotionInReDomain makePmPromotionInReDomain(PmPromotionIn pmPromotionIn) {
        if (null == pmPromotionIn) {
            return null;
        }
        PmPromotionInReDomain pmPromotionInReDomain = new PmPromotionInReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionInReDomain, (Object)pmPromotionIn);
            return pmPromotionInReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionInServiceImpl.makePmPromotionInReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotionIn> queryPromotionInModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionInMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionInServiceImpl.queryPromotionInModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionIn(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionInMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionInServiceImpl.countPromotionIn", (Throwable)e);
        }
        return i;
    }

    private PmPromotionIn createPmPromotionIn(PmPromotionInDomain pmPromotionInDomain) {
        String msg = this.checkPromotionIn(pmPromotionInDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.savePromotionIn.checkPromotionIn", msg);
        }
        PmPromotionIn pmPromotionIn = this.makePromotionIn(pmPromotionInDomain, null);
        this.setPromotionInDefault(pmPromotionIn);
        return pmPromotionIn;
    }

    @Override
    public String savePromotionIn(PmPromotionInDomain pmPromotionInDomain) throws ApiException {
        PmPromotionIn pmPromotionIn = this.createPmPromotionIn(pmPromotionInDomain);
        this.savePromotionInModel(pmPromotionIn);
        return pmPromotionIn.getPromotionInCode();
    }

    @Override
    public String savePromotionInBatch(List<PmPromotionInDomain> pmPromotionInDomainList) throws ApiException {
        if (null == pmPromotionInDomainList || pmPromotionInDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotionIn> pmPromotionInList = new ArrayList<PmPromotionIn>();
        String code = "";
        for (PmPromotionInDomain pmPromotionInDomain : pmPromotionInDomainList) {
            PmPromotionIn pmPromotionIn = this.createPmPromotionIn(pmPromotionInDomain);
            code = pmPromotionIn.getPromotionInCode();
            pmPromotionInList.add(pmPromotionIn);
        }
        this.savePromotionInBatchModel(pmPromotionInList);
        return code;
    }

    @Override
    public void updatePromotionInState(Integer promotionInId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePromotionInModel(promotionInId, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionInStateByCode(String tenantCode, String promotionInCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePromotionInModelByCode(tenantCode, promotionInCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionIn(PmPromotionInDomain pmPromotionInDomain) throws ApiException {
        String msg = this.checkPromotionIn(pmPromotionInDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updatePromotionIn.checkPromotionIn", msg);
        }
        PmPromotionIn oldPmPromotionIn = this.getPromotionInModelById(pmPromotionInDomain.getPromotionInId());
        if (null == oldPmPromotionIn) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updatePromotionIn.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotionIn pmPromotionIn = this.makePromotionIn(pmPromotionInDomain, oldPmPromotionIn);
        this.setPromotionInUpdataDefault(pmPromotionIn);
        this.updatePromotionInModel(pmPromotionIn);
    }

    @Override
    public PmPromotionIn getPromotionIn(Integer promotionInId) {
        return this.getPromotionInModelById(promotionInId);
    }

    @Override
    public void deletePromotionIn(Integer promotionInId) throws ApiException {
        this.deletePromotionInModel(promotionInId);
    }

    @Override
    public QueryResult<PmPromotionIn> queryPromotionInPage(Map<String, Object> map) {
        List<PmPromotionIn> pmPromotionInList = this.queryPromotionInModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionIn(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionInList);
        return queryResult;
    }

    @Override
    public PmPromotionIn getPromotionInByCode(String tenantCode, String promotionInCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionInCode", promotionInCode);
        return this.getPromotionInModelByCode(map);
    }

    @Override
    public void deletePromotionInByCode(String tenantCode, String promotionInCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionInCode", promotionInCode);
        this.delPromotionInModelByCode(map);
    }

    @Override
    public void deletePromotionInByPromotionCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionInModelByPromotionCode(map);
    }

    @Override
    public void updateSendNum(String tenantCode, String promotionCode, int num) throws ApiException {
        this.updateSendNumPromotionModel(tenantCode, promotionCode, num);
    }

    @Override
    public void updateSendNump(String tenantCode, String promotionCode, int num) throws ApiException {
        this.updateSendNumPromotionpModel(tenantCode, promotionCode, num);
    }

    @Override
    public void updateState(String tenantCode, String promotionCode, Integer promotionState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionModel(tenantCode, promotionCode, promotionState, oldDataState);
    }

    public void updateSendNumPromotionModel(String tenantCode, String promotionCode, int num) {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("couponOnceNumd", num);
        int i = 0;
        try {
            i = this.pmPromotionInMapper.updateSendNum(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateSendNumPromotionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateSendNumPromotionModel.null", "\u5df2\u53d1\u653e\u5b8c");
        }
    }

    public void updateStatePromotionModel(String tenantCode, String promotionCode, Integer promotionState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("promotionState", promotionState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionInMapper.updatePromotionState(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateStatePromotionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateStatePromotionModel.null", "\u5df2\u53d1\u653e\u5b8c");
        }
    }

    public void updateSendNumPromotionpModel(String tenantCode, String promotionCode, int num) {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("couponOnceNump", num);
        int i = 0;
        try {
            i = this.pmPromotionInMapper.updateSendNump(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateSendNumPromotionpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionInServiceImpl.updateSendNumPromotionpModel.null", "\u5df2\u53d1\u653e\u5b8c");
        }
    }
}

