/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.pm.PromotionConstants;
import com.yqbsoft.laser.service.pm.domain.DisChannel;
import com.yqbsoft.laser.service.pm.domain.DisChannelsendDomain;
import com.yqbsoft.laser.service.pm.domain.DisPmPromotionDomain;
import com.yqbsoft.laser.service.pm.domain.OrderCallBackBean;
import com.yqbsoft.laser.service.pm.domain.PmChannelsendDomain;
import com.yqbsoft.laser.service.pm.domain.PmChannelsendlistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDisDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionMemDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionSupDomain;
import com.yqbsoft.laser.service.pm.es.EsSendEnginePutThread;
import com.yqbsoft.laser.service.pm.es.SendPutThread;
import com.yqbsoft.laser.service.pm.model.PmChannelsend;
import com.yqbsoft.laser.service.pm.model.PmChannelsendlist;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.service.PmChannelsendBaseService;
import com.yqbsoft.laser.service.pm.service.PmChannelsendService;
import com.yqbsoft.laser.service.pm.service.PmChannelsendlistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.impl.PmChannelsendServiceImpl;
import com.yqbsoft.laser.service.pm.service.impl.PmChannelsendlistServiceImpl;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class PmChannelsendBaseServiceImpl
extends BaseServiceImpl
implements PmChannelsendBaseService {
    private static final String SYS_CODE = "pm.PROMOTION.DisChannelsendBaseServiceImpl";
    public static String DISCHANNEL_TYPE_ONLINE = "0";
    public static String DISCHANNEL_TYPE_THRID = "2";
    public static String DISCHANNEL_TYPE_STORE = "1";
    public static String DISCHANNEL_SALE = "0";
    public static String DISCHANNEL_CON = "1";
    public static String DISCHANNEL_BUS = "2";
    PmChannelsendService pmChannelsendService;
    PmChannelsendlistService pmChannelsendlistService;
    PmPromotionService pmPromotionService;

    public void setPmChannelsendService(PmChannelsendService pmChannelsendService) {
        this.pmChannelsendService = pmChannelsendService;
    }

    public void setPmChannelsendlistService(PmChannelsendlistService pmChannelsendlistService) {
        this.pmChannelsendlistService = pmChannelsendlistService;
    }

    public void setPmPromotionService(PmPromotionService pmPromotionService) {
        this.pmPromotionService = pmPromotionService;
    }

    @Override
    public String sendChannelsendBatch(List<PmChannelsendDomain> pmChannelsendDomains) throws ApiException {
        List<PmChannelsend> disChannelsendList = this.pmChannelsendService.saveChannelsendBatch(pmChannelsendDomains);
        if (ListUtil.isNotEmpty(disChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), disChannelsendList));
        }
        return "";
    }

    @Override
    public List<PmChannelsendlist> sendChannelsendlistBatch(List<PmChannelsendlistDomain> pmChannelsendlistDomainList) throws ApiException {
        return this.pmChannelsendlistService.saveChannelsendlistBatch(pmChannelsendlistDomainList);
    }

    @Override
    public String sendChannelsendlistAuto(List<PmChannelsendlist> pmChannelsendlistList) throws ApiException {
        if (ListUtil.isNotEmpty(pmChannelsendlistList)) {
            PmChannelsendlistServiceImpl.getEsSendEngineService().addPutPool(new EsSendEnginePutThread(PmChannelsendlistServiceImpl.getEsSendEngineService(), pmChannelsendlistList));
        }
        return null;
    }

    @Override
    public void sendSaveSendChannelsend(PmChannelsend pmChannelsend) {
        List<PmChannelsendlist> pmChannelsendlistList = this.pmChannelsendService.saveSendChannelsend(pmChannelsend);
        this.sendChannelsendlistAuto(pmChannelsendlistList);
    }

    @Override
    public String sendSavePromotion(PmPromotionDomain pmPromotionDomain) throws ApiException {
        List<PmChannelsend> pmChannelsendList = this.pmPromotionService.savePromotion(pmPromotionDomain);
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
        }
        return pmChannelsendList.get(0).getChannelsendOpcode();
    }

    @Override
    public String sendUpdatePromotionRangelist(PmPromotionDomain pmPromotionDomain) throws ApiException {
        List<PmChannelsend> pmChannelsendList = this.pmPromotionService.updatePromotionRangelist(pmPromotionDomain);
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
        }
        return pmChannelsendList.get(0).getChannelsendOpcode();
    }

    @Override
    public String sendSavePromotionBatch(List<PmPromotionDomain> pmPromotionDomainList) throws ApiException {
        List<PmChannelsend> pmChannelsendList = this.pmPromotionService.savePromotionBatch(pmPromotionDomainList);
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
            return pmChannelsendList.get(0).getChannelsendOpcode();
        }
        return null;
    }

    @Override
    public void sendUpdatePromotionState(Integer promotionId, Integer dataState, Integer oldDataState) throws ApiException {
        List<PmChannelsend> pmChannelsendList = this.pmPromotionService.updatePromotionState(promotionId, dataState, oldDataState);
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
        }
    }

    @Override
    public void sendUpdatePromotionStateByCode(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState) throws ApiException {
        List<PmChannelsend> pmChannelsendList = this.pmPromotionService.updatePromotionStateByCode(tenantCode, promotionCode, dataState, oldDataState);
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
        }
    }

    @Override
    public void sendUpdatePromotion(PmPromotionDomain pmPromotionDomain) throws ApiException {
        List<PmChannelsend> pmChannelsendList = this.pmPromotionService.updatePromotion(pmPromotionDomain);
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
        }
    }

    @Override
    public void sendDeletePromotion(Integer promotionId) throws ApiException {
        List<PmChannelsend> pmChannelsendList = this.pmPromotionService.deletePromotion(promotionId);
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
        }
    }

    @Override
    public void sendDeletePromotionByCode(String tenantCode, String promotionCode) throws ApiException {
        List<PmChannelsend> pmChannelsendList = this.pmPromotionService.deletePromotionByCode(tenantCode, promotionCode);
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
        }
    }

    @Override
    public void sendSaveCouponBatch(PmPromotion promotion) {
        List<PmChannelsend> pmChannelsendList = this.pmPromotionService.saveCouponBatch(promotion);
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
        }
    }

    @Override
    public String sendUpdateCouponByOrderCallBack(OrderCallBackBean orderCallBackBean) {
        try {
            List<PmChannelsend> pmChannelsendList = this.pmPromotionService.updateCouponByOrderCallBack(orderCallBackBean);
            if (ListUtil.isNotEmpty(pmChannelsendList)) {
                PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
            }
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.sendUpdateCouponByOrderCallBack", (Throwable)e);
            return "ERROR";
        }
        return "SUCCESS";
    }

    @Override
    public String sendSaveDisPromotion(PmChannelsendlist pmChannelsendlist) throws ApiException {
        List<DisChannel> channelList;
        if (null == pmChannelsendlist) {
            return "success";
        }
        String channelCode = pmChannelsendlist.getChannelCode();
        if (StringUtils.isNotBlank((String)channelCode)) {
            DisChannel disChannel = this.getChannel(channelCode, pmChannelsendlist.getTenantCode());
            if (null == disChannel) {
                this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.sendSaveDisPromotion.disChannel", (Object)(channelCode + "-" + pmChannelsendlist.getTenantCode() + "-" + pmChannelsendlist.getChannelsendlistCode()));
                return "error";
            }
            if (DISCHANNEL_TYPE_THRID.equals(disChannel.getChannelType())) {
                return this.sendDisPm(pmChannelsendlist, disChannel, false);
            }
        }
        if (ListUtil.isEmpty(channelList = this.queryChannel(pmChannelsendlist.getMemberCode(), pmChannelsendlist.getTenantCode()))) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.sendSaveDisPromotion.channelList", (Object)(pmChannelsendlist.getMemberCode() + "-" + pmChannelsendlist.getTenantCode() + "-" + pmChannelsendlist.getChannelsendlistCode()));
            return "success";
        }
        String promotionCode = pmChannelsendlist.getChannelsendOpcode();
        String tenantCode = pmChannelsendlist.getTenantCode();
        List<PmChannelsend> pmChannelsendList = null;
        if ("delete".equals(pmChannelsendlist.getChannelsendDir())) {
            pmChannelsendList = this.pmPromotionService.deleteDisPromotionByOldcode(tenantCode, promotionCode);
        } else if ("insert".equals(pmChannelsendlist.getChannelsendDir())) {
            List<DisPmPromotionDomain> disPmPromotionDomainList = this.getDisPmPromotionDomainList(pmChannelsendlist, channelList);
            if (ListUtil.isEmpty(disPmPromotionDomainList)) {
                this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.sendSaveDisPromotion.disPmPromotionDomainList", (Object)(pmChannelsendlist.getMemberCode() + "-" + pmChannelsendlist.getTenantCode() + "-" + pmChannelsendlist.getChannelsendlistCode()));
                if (null != disPmPromotionDomainList) {
                    return "success";
                }
                return "success";
            }
            pmChannelsendList = this.pmPromotionService.saveDisPromotionBatch(disPmPromotionDomainList);
        } else if ("updataGs".equals(pmChannelsendlist.getChannelsendDir())) {
            List<DisPmPromotionDomain> disPmPromotionDomainList = this.getDisPmPromotionDomainList(pmChannelsendlist, channelList);
            if (ListUtil.isEmpty(disPmPromotionDomainList)) {
                if (null != disPmPromotionDomainList) {
                    return "success";
                }
                return "success";
            }
            pmChannelsendList = this.pmPromotionService.updateDisPromotionRangelistBatch(disPmPromotionDomainList);
        } else if ("edit".equals(pmChannelsendlist.getChannelsendDir())) {
            List<DisPmPromotionDomain> disPmPromotionDomainList = this.getDisPmPromotionDomainList(pmChannelsendlist, channelList);
            if (ListUtil.isEmpty(disPmPromotionDomainList)) {
                if (null != disPmPromotionDomainList) {
                    return "success";
                }
                return "success";
            }
            pmChannelsendList = this.pmPromotionService.updateDisPromotionBatch(disPmPromotionDomainList);
        } else if ("deleteop".equals(pmChannelsendlist.getChannelsendDir())) {
            pmChannelsendList = this.pmPromotionService.updateDisPromotionStateByOldcode(tenantCode, promotionCode, PromotionConstants.DATA_STATE_DEL, null);
        } else if ("down".equals(pmChannelsendlist.getChannelsendDir())) {
            pmChannelsendList = this.pmPromotionService.updateDisPromotionStateByOldcode(tenantCode, promotionCode, PromotionConstants.DATA_STATE_0, null);
        } else if ("up".equals(pmChannelsendlist.getChannelsendDir())) {
            pmChannelsendList = this.pmPromotionService.updateDisPromotionStateByOldcode(tenantCode, promotionCode, PromotionConstants.DATA_STATE_4, PromotionConstants.DATA_STATE_0);
        }
        if (ListUtil.isNotEmpty(pmChannelsendList)) {
            PmChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PmChannelsendServiceImpl.getSendService(), pmChannelsendList));
        }
        return "success";
    }

    private List<DisPmPromotionDomain> getDisPmPromotionDomainList(PmChannelsendlist pmChannelsendlist, List<DisChannel> channelList) {
        if (null == pmChannelsendlist || ListUtil.isEmpty(channelList)) {
            return null;
        }
        PmPromotionDomain disPmPromotionDomain = null;
        if (StringUtils.isNotBlank((String)pmChannelsendlist.getChannelsendTxt())) {
            disPmPromotionDomain = (DisPmPromotionDomain)JsonUtil.buildNormalBinder().getJsonToObject(pmChannelsendlist.getChannelsendTxt(), DisPmPromotionDomain.class);
        }
        if (null == disPmPromotionDomain) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.getDisPmPromotionDomainList.disPmPromotionDomain", (Object)(pmChannelsendlist.getMemberCode() + "-" + pmChannelsendlist.getTenantCode() + "-" + pmChannelsendlist.getChannelsendlistCode()));
            return null;
        }
        boolean flag = this.checkChannelEnd(disPmPromotionDomain.getChannelCode(), disPmPromotionDomain.getTenantCode(), channelList);
        if (!flag) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.getDisPmPromotionDomainList.checkChannelEnd", (Object)(disPmPromotionDomain.getChannelCode() + "-" + disPmPromotionDomain.getTenantCode() + "-" + pmChannelsendlist.getChannelsendlistCode() + "=" + JsonUtil.buildNormalBinder().toJson(channelList)));
            return null;
        }
        ArrayList<DisPmPromotionDomain> reDisPmPromotionDomainList = new ArrayList<DisPmPromotionDomain>();
        for (DisChannel disChannel : channelList) {
            DisPmPromotionDomain reDisPmPromotionDomain = this.makeDisPmPromotionDomain((DisPmPromotionDomain)disPmPromotionDomain, disChannel);
            if (null == reDisPmPromotionDomain) continue;
            reDisPmPromotionDomainList.add(reDisPmPromotionDomain);
        }
        return reDisPmPromotionDomainList;
    }

    private DisPmPromotionDomain makeDisPmPromotionDomain(DisPmPromotionDomain disPmPromotionDomain, DisChannel disChannel) {
        if (null == disPmPromotionDomain || null == disChannel) {
            return null;
        }
        DisPmPromotionDomain reDisPmPromotionDomain = new DisPmPromotionDomain();
        try {
            BeanUtils.copyAllPropertys((Object)reDisPmPromotionDomain, (Object)disPmPromotionDomain);
            reDisPmPromotionDomain.setPromotionCode(null);
            reDisPmPromotionDomain.setPromotionId(null);
            reDisPmPromotionDomain.setPromotionPcode(null);
            reDisPmPromotionDomain.setPromotionOldcode(disPmPromotionDomain.getPromotionCode());
            reDisPmPromotionDomain.setPromotionOrgin(PromotionConstants.ORGIN_1);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.makeDisPmPromotionDomain.reDisPmPromotionDomain", (Throwable)e);
            return null;
        }
        reDisPmPromotionDomain.setMemberCode(disChannel.getMemberCode());
        reDisPmPromotionDomain.setMemberName(disChannel.getMemberName());
        reDisPmPromotionDomain.setChannelCode(disChannel.getChannelCode());
        reDisPmPromotionDomain.setChannelName(disChannel.getChannelName());
        if (StringUtils.isBlank((String)reDisPmPromotionDomain.getMemberCcode()) && (DISCHANNEL_TYPE_STORE.equals(disChannel.getChannelType()) || DISCHANNEL_CON.equals(disChannel.getChannelSort()))) {
            reDisPmPromotionDomain.setMemberCcode(disChannel.getMemberCcode());
            reDisPmPromotionDomain.setMemberCname(disChannel.getMemberCname());
        }
        List<PmPromotionSupDomain> pmPromotionSupList = disPmPromotionDomain.getPmPromotionSupList();
        List<PmPromotionMemDomain> pmPromotionMemList = disPmPromotionDomain.getPmPromotionMemList();
        List<PmPromotionDisDomain> pmPromotionDisList = disPmPromotionDomain.getPmPromotionDisList();
        reDisPmPromotionDomain.setUp(false);
        if (ListUtil.isEmpty(pmPromotionSupList) && ListUtil.isEmpty(pmPromotionMemList) && ListUtil.isEmpty(pmPromotionDisList)) {
            reDisPmPromotionDomain.setUp(true);
        }
        if (this.checkDis(pmPromotionDisList, reDisPmPromotionDomain) && this.checkSup(pmPromotionSupList, reDisPmPromotionDomain) && this.checkMem(pmPromotionMemList, reDisPmPromotionDomain)) {
            reDisPmPromotionDomain.setUp(true);
        }
        if (!reDisPmPromotionDomain.isUp()) {
            reDisPmPromotionDomain.setPromotionOrgin(PromotionConstants.ORGIN_2);
        }
        boolean flag = this.checkChannelEnd(reDisPmPromotionDomain.getChannelCode(), disPmPromotionDomain.getTenantCode());
        if (!reDisPmPromotionDomain.isUp() && !flag) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.getDisPmPromotionDomainList.checkChannelEnd", (Object)(disPmPromotionDomain.getChannelCode() + "-" + disPmPromotionDomain.getTenantCode()));
            return null;
        }
        return reDisPmPromotionDomain;
    }

    private boolean checkSup(List<PmPromotionSupDomain> pmPromotionSupList, DisPmPromotionDomain reDisPmPromotionDomain) {
        if (ListUtil.isEmpty(pmPromotionSupList)) {
            return true;
        }
        if (null == reDisPmPromotionDomain) {
            return false;
        }
        for (PmPromotionSupDomain pmPromotionSupDomain : pmPromotionSupList) {
            if (!pmPromotionSupDomain.getPpsupMemcode().equals(reDisPmPromotionDomain.getMemberCcode())) continue;
            return true;
        }
        return false;
    }

    private boolean checkDis(List<PmPromotionDisDomain> pmPromotionDisList, DisPmPromotionDomain reDisPmPromotionDomain) {
        if (ListUtil.isEmpty(pmPromotionDisList)) {
            return true;
        }
        if (null == reDisPmPromotionDomain) {
            return false;
        }
        for (PmPromotionDisDomain pmPromotionDisDomain : pmPromotionDisList) {
            if (!pmPromotionDisDomain.getChannelCode().equals(reDisPmPromotionDomain.getChannelCode())) continue;
            return true;
        }
        return false;
    }

    private boolean checkMem(List<PmPromotionMemDomain> pmPromotionMemList, DisPmPromotionDomain reDisPmPromotionDomain) {
        if (ListUtil.isEmpty(pmPromotionMemList)) {
            return true;
        }
        if (null == reDisPmPromotionDomain) {
            return false;
        }
        for (PmPromotionMemDomain pmPromotionMemDomain : pmPromotionMemList) {
            if (!pmPromotionMemDomain.getPpmemMemcode().equals(reDisPmPromotionDomain.getMemberCode())) continue;
            return true;
        }
        return false;
    }

    private boolean checkChannelEnd(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.checkChannelEnd.null", (Object)(channelCode + "-" + tenantCode));
            return true;
        }
        DisChannel oldDisChannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        if (null == oldDisChannel) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.checkChannelEnd.oldDisChannel.0", (Object)(channelCode + "-" + tenantCode));
            return false;
        }
        if (null != oldDisChannel && "0".equals(oldDisChannel.getChannelType()) && "2".equals(oldDisChannel.getChannelSort())) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.checkChannelEnd.oldDisChannel.1", (Object)(channelCode + "-" + tenantCode));
            return false;
        }
        if (DISCHANNEL_TYPE_THRID.equals(oldDisChannel.getChannelType())) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.checkChannelEnd.oldDisChannel.2", (Object)(channelCode + "-" + tenantCode));
            return false;
        }
        return true;
    }

    private boolean checkChannelEnd(String channelCode, String tenantCode, List<DisChannel> channelList) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode) || ListUtil.isEmpty(channelList)) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.checkChannelEnd.null", (Object)(channelCode + "-" + tenantCode));
            return true;
        }
        DisChannel oldDisChannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        if (null == oldDisChannel) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.checkChannelEnd.oldDisChannel.0", (Object)(channelCode + "-" + tenantCode));
            return false;
        }
        if (null != oldDisChannel && "0".equals(oldDisChannel.getChannelType()) && "2".equals(oldDisChannel.getChannelSort())) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.checkChannelEnd.oldDisChannel.1", (Object)(channelCode + "-" + tenantCode));
            return false;
        }
        for (DisChannel toDisChannel : channelList) {
            if (null == toDisChannel.getMemberCcode()) {
                toDisChannel.setMemberCcode("");
            }
            if (null == oldDisChannel.getMemberCcode()) {
                oldDisChannel.setMemberCcode("");
            }
            if (null == toDisChannel.getMemberCode()) {
                toDisChannel.setMemberCode("");
            }
            if (null == oldDisChannel.getMemberCode()) {
                oldDisChannel.setMemberCode("");
            }
            if ("1".equals(oldDisChannel.getChannelType()) && "1".equals(toDisChannel.getChannelSort()) && oldDisChannel.getMemberMcode().equals(toDisChannel.getMemberCode()) && oldDisChannel.getMemberCcode().equals(toDisChannel.getMemberCcode())) {
                this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.checkChannelEnd.oldDisChannel.2", (Object)(channelCode + "-" + tenantCode));
                return false;
            }
            if (!"0".equals(oldDisChannel.getChannelType()) || !"1".equals(toDisChannel.getChannelSort()) && !"2".equals(toDisChannel.getChannelSort()) || !oldDisChannel.getMemberCode().equals(toDisChannel.getMemberCode()) || !oldDisChannel.getMemberCcode().equals(toDisChannel.getMemberCcode())) continue;
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.checkChannelEnd.oldDisChannel.3", (Object)(channelCode + "-" + tenantCode));
            return false;
        }
        return true;
    }

    private List<DisChannel> queryChannel(String memberCode, String tenantCode) {
        List memchannelList1;
        DisChannel memchannel;
        if (StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        ArrayList<DisChannel> channelList = new ArrayList<DisChannel>();
        List memchannelList = DisUtil.getMapListJson((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_SALE + "-" + tenantCode), DisChannel.class);
        if (ListUtil.isNotEmpty((Collection)memchannelList)) {
            channelList.addAll(memchannelList);
        }
        if (null != (memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-memberCcode", (String)(memberCode + "-" + DISCHANNEL_CON + "-" + tenantCode), DisChannel.class))) {
            channelList.add(memchannel);
        }
        if (ListUtil.isNotEmpty((Collection)(memchannelList1 = DisUtil.getMapListJson((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_BUS + "-" + tenantCode), DisChannel.class)))) {
            channelList.addAll(memchannelList1);
        }
        return channelList;
    }

    private String sendDisPm(PmChannelsendlist pmChannelsendlist, DisChannel disChannel, boolean centFlag) {
        if (null == pmChannelsendlist || null == disChannel) {
            return "";
        }
        String apiCode = "dis.channelsendBase.sendChannelsendBatch";
        DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disChannelsendDomain, (Object)pmChannelsendlist);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.DisChannelsendBaseServiceImpl.sendDisPm.e", (Throwable)e);
        }
        disChannelsendDomain.setChannelCode(disChannel.getChannelCode());
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        disChannelsendDomainList.add(disChannelsendDomain);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(disChannelsendDomainList));
        this.internalInvoke(apiCode, paramMap);
        return "success";
    }

    private DisChannel getChannel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisChannel memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        return memchannel;
    }
}

