/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmBiddingInformationMapper;
import com.yqbsoft.laser.service.pm.domain.PmBiddingInformationDomain;
import com.yqbsoft.laser.service.pm.domain.PmBiddingInformationReDomain;
import com.yqbsoft.laser.service.pm.model.PmBiddingInformation;
import com.yqbsoft.laser.service.pm.model.PmBiddingSource;
import com.yqbsoft.laser.service.pm.service.PmBiddingInformationService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

public class PmBiddingInformationServiceImpl
extends BaseServiceImpl
implements PmBiddingInformationService {
    private static final String SYS_CODE = "pm.PROMOTION.PmBiddingInformationServiceImpl";
    private PmBiddingInformationMapper pmBiddingInformationMapper;

    public void setPmBiddingInformationMapper(PmBiddingInformationMapper pmBiddingInformationMapper) {
        this.pmBiddingInformationMapper = pmBiddingInformationMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmBiddingInformationMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) {
        if (null == pmBiddingInformationDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setBiddingInformationDefault(PmBiddingInformation pmBiddingInformation) {
        if (null == pmBiddingInformation) {
            return;
        }
        if (null == pmBiddingInformation.getDataState()) {
            pmBiddingInformation.setDataState(1);
        }
        Date date = this.getSysDate();
        if (null == pmBiddingInformation.getGmtCreate()) {
            pmBiddingInformation.setGmtCreate(date);
        }
        pmBiddingInformation.setGmtModified(date);
        if (StringUtils.isBlank((String)pmBiddingInformation.getInformationCode())) {
            pmBiddingInformation.setInformationCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)pmBiddingInformation.getTenantCode())) {
            pmBiddingInformation.setTenantCode("2020021100000063");
        }
    }

    private int getBiddingInformationMaxCode() {
        int code = 0;
        try {
            return this.pmBiddingInformationMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.getBiddingInformationMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBiddingInformationUpdataDefault(PmBiddingInformation pmBiddingInformation) {
        if (null == pmBiddingInformation) {
            return;
        }
        pmBiddingInformation.setGmtModified(this.getSysDate());
    }

    private void saveBiddingInformationModel(PmBiddingInformation pmBiddingInformation) throws ApiException {
        if (null == pmBiddingInformation) {
            return;
        }
        try {
            this.pmBiddingInformationMapper.insert(pmBiddingInformation);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.saveBiddingInformationModel.ex", (Throwable)e);
        }
    }

    private void saveBiddingInformationBatchModel(List<PmBiddingInformation> pmBiddingInformationList) throws ApiException {
        if (null == pmBiddingInformationList || pmBiddingInformationList.isEmpty()) {
            return;
        }
        try {
            this.pmBiddingInformationMapper.insertBatch(pmBiddingInformationList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.saveBiddingInformationBatchModel.ex", (Throwable)e);
        }
    }

    private PmBiddingInformation getBiddingInformationModelById(Integer informationId) {
        if (null == informationId) {
            return null;
        }
        try {
            return this.pmBiddingInformationMapper.selectByPrimaryKey(informationId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.getBiddingInformationModelById", (Throwable)e);
            return null;
        }
    }

    private PmBiddingInformation getBiddingInformationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmBiddingInformationMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.getBiddingInformationModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBiddingInformationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.delBiddingInformationModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.delBiddingInformationModelByCode.num");
        }
    }

    private void deleteBiddingInformationModel(Integer informationId) throws ApiException {
        if (null == informationId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.deleteByPrimaryKey(informationId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.deleteBiddingInformationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.deleteBiddingInformationModel.num");
        }
    }

    private void updateBiddingInformationModel(PmBiddingInformation pmBiddingInformation) throws ApiException {
        if (null == pmBiddingInformation) {
            return;
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.updateByPrimaryKey(pmBiddingInformation);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateBiddingInformationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateBiddingInformationModel.num");
        }
    }

    private void updateStateBiddingInformationModel(Integer informationId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == informationId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("informationId", informationId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateStateBiddingInformationModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateStateBiddingInformationModel.null");
        }
    }

    private void updateStateBiddingInformationModelByCode(String tenantCode, String informationCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)informationCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("informationCode", informationCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateStateBiddingInformationModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateStateBiddingInformationModelByCode.null");
        }
    }

    private PmBiddingInformation makeBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain, PmBiddingInformation pmBiddingInformation) {
        if (null == pmBiddingInformationDomain) {
            return null;
        }
        if (null == pmBiddingInformation) {
            pmBiddingInformation = new PmBiddingInformation();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmBiddingInformation, (Object)pmBiddingInformationDomain);
            return pmBiddingInformation;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.makeBiddingInformation", (Throwable)e);
            return null;
        }
    }

    private PmBiddingInformationReDomain makePmBiddingInformationReDomain(PmBiddingInformation pmBiddingInformation) {
        if (null == pmBiddingInformation) {
            return null;
        }
        PmBiddingInformationReDomain pmBiddingInformationReDomain = new PmBiddingInformationReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmBiddingInformationReDomain, (Object)pmBiddingInformation);
            return pmBiddingInformationReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.makePmBiddingInformationReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmBiddingInformation> queryBiddingInformationModelPage(Map<String, Object> parammap) {
        try {
            return this.pmBiddingInformationMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.queryBiddingInformationModel", (Throwable)e);
            return null;
        }
    }

    private int countBiddingInformation(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.countBiddingInformation", (Throwable)e);
        }
        return i;
    }

    private PmBiddingInformation createPmBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) {
        String msg = this.checkBiddingInformation(pmBiddingInformationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.saveBiddingInformation.checkBiddingInformation", msg);
        }
        PmBiddingInformation pmBiddingInformation = this.makeBiddingInformation(pmBiddingInformationDomain, null);
        this.setBiddingInformationDefault(pmBiddingInformation);
        return pmBiddingInformation;
    }

    @Override
    public String saveBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) throws ApiException {
        PmBiddingInformation pmBiddingInformation = this.createPmBiddingInformation(pmBiddingInformationDomain);
        this.saveBiddingInformationModel(pmBiddingInformation);
        return pmBiddingInformation.getInformationCode();
    }

    @Override
    public String saveBiddingInformationBatch(List<PmBiddingInformationDomain> pmBiddingInformationDomainList) throws ApiException {
        if (null == pmBiddingInformationDomainList || pmBiddingInformationDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmBiddingInformation> pmBiddingInformationList = new ArrayList<PmBiddingInformation>();
        String code = "";
        for (PmBiddingInformationDomain pmBiddingInformationDomain : pmBiddingInformationDomainList) {
            PmBiddingInformation pmBiddingInformation = this.createPmBiddingInformation(pmBiddingInformationDomain);
            code = pmBiddingInformation.getInformationCode();
            pmBiddingInformationList.add(pmBiddingInformation);
        }
        this.saveBiddingInformationBatchModel(pmBiddingInformationList);
        return code;
    }

    @Override
    public void updateBiddingInformationState(Integer informationId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == informationId) {
            return;
        }
        this.updateStateBiddingInformationModel(informationId, dataState, oldDataState, map);
    }

    @Override
    public void updateBiddingInformationStateByCode(String tenantCode, String informationCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)informationCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateBiddingInformationModelByCode(tenantCode, informationCode, dataState, oldDataState, map);
    }

    @Override
    public void updateBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) throws ApiException {
        String msg = this.checkBiddingInformation(pmBiddingInformationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateBiddingInformation.checkBiddingInformation", msg);
        }
        PmBiddingInformation oldPmBiddingInformation = this.getBiddingInformationModelById(pmBiddingInformationDomain.getInformationId());
        if (null == oldPmBiddingInformation) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateBiddingInformation.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmBiddingInformation pmBiddingInformation = this.makeBiddingInformation(pmBiddingInformationDomain, oldPmBiddingInformation);
        this.setBiddingInformationUpdataDefault(pmBiddingInformation);
        this.updateBiddingInformationModel(pmBiddingInformation);
    }

    @Override
    public PmBiddingInformation getBiddingInformation(Integer informationId) {
        if (null == informationId) {
            return null;
        }
        return this.getBiddingInformationModelById(informationId);
    }

    @Override
    public void deleteBiddingInformation(Integer informationId) throws ApiException {
        if (null == informationId) {
            return;
        }
        this.deleteBiddingInformationModel(informationId);
    }

    @Override
    public QueryResult<PmBiddingInformation> queryBiddingInformationPage(Map<String, Object> map) {
        List<PmBiddingInformation> pmBiddingInformationList = this.queryBiddingInformationModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBiddingInformation(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmBiddingInformationList);
        return queryResult;
    }

    @Override
    public PmBiddingInformation getBiddingInformationByCode(String tenantCode, String informationCode) throws ApiException {
        if (StringUtils.isBlank((String)informationCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("informationCode", informationCode);
        return this.getBiddingInformationModelByCode(map);
    }

    @Override
    public void deleteBiddingInformationByCode(String tenantCode, String informationCode) throws ApiException {
        if (StringUtils.isBlank((String)informationCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("informationCode", informationCode);
        this.delBiddingInformationModelByCode(map);
    }

    @Override
    public boolean existBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)pmBiddingInformationDomain.getUuIdValue())) {
            map.put("uuIdValue", pmBiddingInformationDomain.getUuIdValue());
            map.put("sourceCode", pmBiddingInformationDomain.getSourceCode());
        } else {
            map.put("showUrl", pmBiddingInformationDomain.getShowUrl());
            map.put("informationTitle", pmBiddingInformationDomain.getInformationTitle());
            map.put("sourceCode", pmBiddingInformationDomain.getSourceCode());
        }
        return this.pmBiddingInformationMapper.count(map) > 0;
    }

    @Override
    public void tsaveInfo(PmBiddingSource pmBiddingSource) throws ApiException {
        this.createBiddingInfo(pmBiddingSource, 1);
    }

    @Override
    public void saveInfo(PmBiddingSource pmBiddingSource) throws ApiException {
        this.createBiddingInfo(pmBiddingSource, 1);
    }

    private void createBiddingInfo(PmBiddingSource pmBiddingSource, Integer page) {
        Boolean getNextPage = false;
        String httpData = null;
        try {
            httpData = this.getHttpData(pmBiddingSource, page);
        }
        catch (IOException e) {
            try {
                this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.createBiddingInfo", (Throwable)e);
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
            catch (Exception e1) {
                return;
            }
            return;
        }
        if (StringUtils.isNotBlank((String)httpData)) {
            getNextPage = this.saveHttpData(httpData, pmBiddingSource);
        }
        if (getNextPage.booleanValue()) {
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
            if (page > 2000) {
                return;
            }
            this.createBiddingInfo(pmBiddingSource, page);
        }
    }

    private Boolean saveHttpData(String httpData, PmBiddingSource pmBiddingSource) {
        String listData = this.getList(httpData, pmBiddingSource.getListPath());
        JSONArray jsonArray = null;
        if (pmBiddingSource.getResponseType() == 0) {
            jsonArray = JSONArray.json2array((String)listData);
        } else if (pmBiddingSource.getResponseType() == 2) {
            listData = StringEscapeUtils.unescapeJava((String)listData);
            jsonArray = JSONArray.json2array((String)listData);
        } else {
            jsonArray = this.createJson(listData, pmBiddingSource.getObjectMatch());
        }
        List<PmBiddingInformationDomain> pmBiddingInformationList = this.createPmBiddingInfo(jsonArray, pmBiddingSource);
        return this.savePmBiddingInformationList(pmBiddingInformationList);
    }

    private JSONArray createJson(String listData, String objectMatch) {
        JSONArray jsonArray = new JSONArray();
        Pattern r = Pattern.compile(objectMatch, 34);
        Matcher m = r.matcher(listData);
        while (m.find()) {
            JSONObject jsonObject = new JSONObject();
            for (int i = 0; i <= m.groupCount(); ++i) {
                jsonObject.put("MATCH" + String.valueOf(i), (Object)m.group(i));
            }
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    private Boolean savePmBiddingInformationList(List<PmBiddingInformationDomain> pmBiddingInformationList) {
        if (ListUtil.isEmpty(pmBiddingInformationList)) {
            return false;
        }
        Boolean exitNew = false;
        Boolean allTop = true;
        ArrayList<PmBiddingInformationDomain> pmBiddingInformationDomainListNew = new ArrayList<PmBiddingInformationDomain>();
        for (PmBiddingInformationDomain pmBiddingInformationDomain : pmBiddingInformationList) {
            if (!this.existBiddingInformation(pmBiddingInformationDomain)) {
                pmBiddingInformationDomainListNew.add(pmBiddingInformationDomain);
                exitNew = true;
                continue;
            }
            if (pmBiddingInformationDomain.getTopValue().booleanValue()) continue;
            allTop = false;
        }
        this.saveBiddingInformationBatch(pmBiddingInformationDomainListNew);
        return exitNew != false || allTop != false;
    }

    private List<PmBiddingInformationDomain> createPmBiddingInfo(JSONArray jsonArray, PmBiddingSource pmBiddingSource) {
        ArrayList<PmBiddingInformationDomain> pmBiddingInformationList = new ArrayList<PmBiddingInformationDomain>();
        if (jsonArray != null && jsonArray.size() > 0) {
            for (JSONObject jsonObject : jsonArray) {
                PmBiddingInformationDomain pmBiddingInformationDomain = new PmBiddingInformationDomain();
                this.setPmBiddingInformationValue(pmBiddingInformationDomain, jsonObject, pmBiddingSource.getCodeMap());
                if (StringUtils.isBlank((String)pmBiddingInformationDomain.getInformationDate())) {
                    pmBiddingInformationDomain.setInformationDate(DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd"));
                }
                if (StringUtils.isNotBlank((String)pmBiddingInformationDomain.getInformationDate())) {
                    try {
                        pmBiddingInformationDomain.setInformationDateFormate(DateUtils.parseDate((String)pmBiddingInformationDomain.getInformationDate(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd HH:mm", "yyyy\u5e74MM\u6708dd\u65e5"}));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isBlank((String)pmBiddingInformationDomain.getShowUrl()) && StringUtils.isNotBlank((String)pmBiddingSource.getShowUrl())) {
                    String showUrl = this.createShowUrl(pmBiddingSource.getShowUrl(), jsonObject);
                    pmBiddingInformationDomain.setShowUrl(showUrl);
                }
                if (jsonObject.containsKey((Object)pmBiddingSource.getTopKey()) && jsonObject.getString(pmBiddingSource.getTopKey()).equals(pmBiddingSource.getTopValue())) {
                    pmBiddingInformationDomain.setTopValue(true);
                }
                pmBiddingInformationDomain.setOriginalInfo(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonObject));
                pmBiddingInformationDomain.setSourceId(pmBiddingSource.getSourceId());
                pmBiddingInformationDomain.setSourceCode(pmBiddingSource.getSourceCode());
                pmBiddingInformationDomain.setSourceName(pmBiddingSource.getSourceName());
                pmBiddingInformationDomain.setSourceUrl(pmBiddingSource.getSourceUrl());
                pmBiddingInformationList.add(pmBiddingInformationDomain);
            }
        }
        return pmBiddingInformationList;
    }

    private String createShowUrl(String showUrl, JSONObject jsonObject) {
        Pattern r = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = r.matcher(showUrl);
        while (m.find()) {
            String matchKey = m.group(1);
            String reValue = "";
            reValue = matchKey.startsWith("#") ? jsonObject.getString(matchKey.replace("#", "")).replace("-", "") : (matchKey.startsWith("2#") ? jsonObject.getString(matchKey.replace("2#", "")).replace("\\r\\n", "") : (matchKey.startsWith("3#") ? StringEscapeUtils.unescapeHtml4((String)jsonObject.getString(matchKey.replace("3#", ""))) : jsonObject.getString(matchKey)));
            showUrl = showUrl.replaceFirst("\\{" + matchKey + "\\}", reValue);
        }
        return showUrl;
    }

    private void setPmBiddingInformationValue(PmBiddingInformationDomain pmBiddingInformationDomain, JSONObject jsonObject, String codeMapStr) {
        HashMap codeMap = (HashMap)JsonUtil.buildNonDefaultBinder().getJsonToMap(codeMapStr, String.class, Object.class);
        Iterator iterator = codeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String value = codeMap.get(key).toString();
            if (!jsonObject.containsKey((Object)key)) continue;
            BeanUtils.setObjValue((Object)pmBiddingInformationDomain, (String)value, (String)jsonObject.getString(key));
        }
    }

    private String getList(String httpData, String listPattern) {
        Pattern r = Pattern.compile(listPattern, 34);
        Matcher m = r.matcher(httpData);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    private String getHttpData(PmBiddingSource pmBiddingSource, Integer page) throws IOException {
        String result = "";
        String requestURL = pmBiddingSource.getCollectionUrl();
        if ("POSTJSON".equals(pmBiddingSource.getRequestMethod())) {
            HashMap jsonToObject = (HashMap)JsonUtil.buildNonDefaultBinder().getJsonToMap(pmBiddingSource.getCollectionParameter(), String.class, Object.class);
            if (jsonToObject != null && jsonToObject.containsKey(pmBiddingSource.getPageKey())) {
                jsonToObject.put(pmBiddingSource.getPageKey(), page);
            }
            result = WebUtils.doPostJson((String)requestURL, (Map)jsonToObject, (int)60000, (int)120000);
        } else if ("GET".equals(pmBiddingSource.getRequestMethod())) {
            HashMap jsonToObject = (HashMap)JsonUtil.buildNonDefaultBinder().getJsonToMap(pmBiddingSource.getCollectionParameter(), String.class, String.class);
            if (jsonToObject != null && jsonToObject.containsKey(pmBiddingSource.getPageKey())) {
                jsonToObject.put(pmBiddingSource.getPageKey(), String.valueOf(page));
            } else {
                requestURL = requestURL.replace("{page}", String.valueOf(page));
            }
            result = WebUtils.doGet((String)requestURL, (Map)jsonToObject, (int)60000, (int)120000);
        } else if ("POST".equals(pmBiddingSource.getRequestMethod())) {
            HashMap jsonToObject = (HashMap)JsonUtil.buildNonDefaultBinder().getJsonToMap(pmBiddingSource.getCollectionParameter(), String.class, String.class);
            if (jsonToObject != null && jsonToObject.containsKey(pmBiddingSource.getPageKey())) {
                jsonToObject.put(pmBiddingSource.getPageKey(), String.valueOf(page));
            } else {
                requestURL = requestURL.replace("{page}", String.valueOf(page));
            }
            result = WebUtils.doPostY((String)requestURL, (Map)jsonToObject, (int)60000, (int)120000, (String)"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.97 Safari/537.36");
        }
        return result;
    }
}

