/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPtaskMapper;
import com.yqbsoft.laser.service.pm.domain.PmPtaskDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskReDomain;
import com.yqbsoft.laser.service.pm.model.PmPtask;
import com.yqbsoft.laser.service.pm.model.PmPtasklist;
import com.yqbsoft.laser.service.pm.service.PmPtaskService;
import com.yqbsoft.laser.service.pm.service.PmPtasklistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class PmPtaskServiceImpl
extends BaseServiceImpl
implements PmPtaskService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPtaskServiceImpl";
    private PmPtaskMapper pmPtaskMapper;
    @Autowired
    private PmPtasklistService pmPtasklistService;

    public void setPmPtaskMapper(PmPtaskMapper pmPtaskMapper) {
        this.pmPtaskMapper = pmPtaskMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPtaskMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtask(PmPtaskDomain pmPtaskDomain) {
        if (null == pmPtaskDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPtaskDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtaskDefault(PmPtask pmPtask) {
        if (null == pmPtask) {
            return;
        }
        if (null == pmPtask.getDataState()) {
            pmPtask.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPtask.getGmtCreate()) {
            pmPtask.setGmtCreate(date);
        }
        pmPtask.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPtask.getPtaskCode())) {
            pmPtask.setPtaskCode(this.getNo(null, "PmPtask", "pmPtask", pmPtask.getTenantCode()));
        }
    }

    private int getPtaskMaxCode() {
        int code = 0;
        try {
            return this.pmPtaskMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskServiceImpl.getPtaskMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtaskUpdataDefault(PmPtask pmPtask) {
        if (null == pmPtask) {
            return;
        }
        pmPtask.setGmtModified(this.getSysDate());
    }

    private void savePtaskModel(PmPtask pmPtask) throws ApiException {
        if (null == pmPtask) {
            return;
        }
        try {
            this.pmPtaskMapper.insert(pmPtask);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.savePtaskModel.ex", (Throwable)e);
        }
    }

    private void savePtaskBatchModel(List<PmPtask> pmPtaskList) throws ApiException {
        if (null == pmPtaskList || pmPtaskList.isEmpty()) {
            return;
        }
        try {
            this.pmPtaskMapper.insertBatch(pmPtaskList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.savePtaskBatchModel.ex", (Throwable)e);
        }
    }

    private PmPtask getPtaskModelById(Integer ptaskId) {
        if (null == ptaskId) {
            return null;
        }
        try {
            return this.pmPtaskMapper.selectByPrimaryKey(ptaskId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskServiceImpl.getPtaskModelById", (Throwable)e);
            return null;
        }
    }

    private PmPtask getPtaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPtaskMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskServiceImpl.getPtaskModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.delPtaskModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.delPtaskModelByCode.num");
        }
    }

    private void deletePtaskModel(Integer ptaskId) throws ApiException {
        if (null == ptaskId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.deleteByPrimaryKey(ptaskId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.deletePtaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.deletePtaskModel.num");
        }
    }

    private void updatePtaskModel(PmPtask pmPtask) throws ApiException {
        if (null == pmPtask) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.updateByPrimaryKey(pmPtask);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.updatePtaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.updatePtaskModel.num");
        }
    }

    private void updateStatePtaskModel(Integer ptaskId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ptaskId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptaskId", ptaskId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.updateStatePtaskModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.updateStatePtaskModel.null");
        }
    }

    private void updateStatePtaskModelByCode(String tenantCode, String ptaskCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskCode", ptaskCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.updateStatePtaskModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.updateStatePtaskModelByCode.null");
        }
    }

    private PmPtask makePtask(PmPtaskDomain pmPtaskDomain, PmPtask pmPtask) {
        if (null == pmPtaskDomain) {
            return null;
        }
        if (null == pmPtask) {
            pmPtask = new PmPtask();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPtask, (Object)pmPtaskDomain);
            return pmPtask;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskServiceImpl.makePtask", (Throwable)e);
            return null;
        }
    }

    private PmPtaskReDomain makePmPtaskReDomain(PmPtask pmPtask) {
        if (null == pmPtask) {
            return null;
        }
        PmPtaskReDomain pmPtaskReDomain = new PmPtaskReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskReDomain, (Object)pmPtask);
            return pmPtaskReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskServiceImpl.makePmPtaskReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPtask> queryPtaskModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPtaskMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskServiceImpl.queryPtaskModel", (Throwable)e);
            return null;
        }
    }

    private int countPtask(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPtaskMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskServiceImpl.countPtask", (Throwable)e);
        }
        return i;
    }

    private PmPtask createPmPtask(PmPtaskDomain pmPtaskDomain) {
        String msg = this.checkPtask(pmPtaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.savePtask.checkPtask", msg);
        }
        PmPtask pmPtask = this.makePtask(pmPtaskDomain, null);
        this.setPtaskDefault(pmPtask);
        return pmPtask;
    }

    @Override
    public String savePtask(PmPtaskDomain pmPtaskDomain) throws ApiException {
        PmPtask pmPtask = this.createPmPtask(pmPtaskDomain);
        this.savePtaskModel(pmPtask);
        if (null != pmPtaskDomain.getPmPtasklistDomainList()) {
            this.pmPtasklistService.savePtasklistBatch(pmPtaskDomain.getPmPtasklistDomainList());
        }
        return pmPtask.getPtaskCode();
    }

    @Override
    public String savePtaskBatch(List<PmPtaskDomain> pmPtaskDomainList) throws ApiException {
        if (null == pmPtaskDomainList || pmPtaskDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPtask> pmPtaskList = new ArrayList<PmPtask>();
        String code = "";
        for (PmPtaskDomain pmPtaskDomain : pmPtaskDomainList) {
            PmPtask pmPtask = this.createPmPtask(pmPtaskDomain);
            code = pmPtask.getPtaskCode();
            pmPtaskList.add(pmPtask);
        }
        this.savePtaskBatchModel(pmPtaskList);
        return code;
    }

    @Override
    public void updatePtaskState(Integer ptaskId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ptaskId) {
            return;
        }
        this.updateStatePtaskModel(ptaskId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtaskStateByCode(String tenantCode, String ptaskCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtaskModelByCode(tenantCode, ptaskCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtask(PmPtaskDomain pmPtaskDomain) throws ApiException {
        String msg = this.checkPtask(pmPtaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.updatePtask.checkPtask", msg);
        }
        PmPtask oldPmPtask = this.getPtaskModelById(pmPtaskDomain.getPtaskId());
        if (null == oldPmPtask) {
            throw new ApiException("pm.PROMOTION.PmPtaskServiceImpl.updatePtask.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPtask pmPtask = this.makePtask(pmPtaskDomain, oldPmPtask);
        this.setPtaskUpdataDefault(pmPtask);
        this.updatePtaskModel(pmPtask);
    }

    @Override
    public PmPtask getPtask(Integer ptaskId) {
        if (null == ptaskId) {
            return null;
        }
        return this.getPtaskModelById(ptaskId);
    }

    @Override
    public void deletePtask(Integer ptaskId) throws ApiException {
        if (null == ptaskId) {
            return;
        }
        this.deletePtaskModel(ptaskId);
    }

    @Override
    public QueryResult<PmPtask> queryPtaskPage(Map<String, Object> map) {
        List<PmPtask> pmPtaskList = this.queryPtaskModelPage(map);
        if (map.containsKey("childFlag") && map.get("childFlag").equals("true")) {
            for (PmPtask pmPtask : pmPtaskList) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("tenantCode", pmPtask.getTenantCode());
                paramMap.put("ptaskCode", pmPtask.getPtaskCode());
                QueryResult<PmPtasklist> queryResult = this.pmPtasklistService.queryPtasklistPage(paramMap);
                if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) continue;
                pmPtask.setPmPtasklistList(queryResult.getList());
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtask(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtaskList);
        return queryResult;
    }

    @Override
    public PmPtask getPtaskByCode(String tenantCode, String ptaskCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskCode", ptaskCode);
        return this.getPtaskModelByCode(map);
    }

    @Override
    public void deletePtaskByCode(String tenantCode, String ptaskCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskCode", ptaskCode);
        this.delPtaskModelByCode(map);
    }
}

