/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPtasklistMapper;
import com.yqbsoft.laser.service.pm.domain.PmPtasklistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtasklistReDomain;
import com.yqbsoft.laser.service.pm.model.PmPtasklist;
import com.yqbsoft.laser.service.pm.service.PmPtasklistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPtasklistServiceImpl
extends BaseServiceImpl
implements PmPtasklistService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPtasklistServiceImpl";
    private PmPtasklistMapper pmPtasklistMapper;

    public void setPmPtasklistMapper(PmPtasklistMapper pmPtasklistMapper) {
        this.pmPtasklistMapper = pmPtasklistMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPtasklistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtasklistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtasklist(PmPtasklistDomain pmPtasklistDomain) {
        if (null == pmPtasklistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPtasklistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtasklistDefault(PmPtasklist pmPtasklist) {
        if (null == pmPtasklist) {
            return;
        }
        if (null == pmPtasklist.getDataState()) {
            pmPtasklist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPtasklist.getGmtCreate()) {
            pmPtasklist.setGmtCreate(date);
        }
        pmPtasklist.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPtasklist.getPtasklistCode())) {
            pmPtasklist.setPtasklistCode(this.getNo(null, "PmPtasklist", "pmPtasklist", pmPtasklist.getTenantCode()));
        }
    }

    private int getPtasklistMaxCode() {
        int code = 0;
        try {
            return this.pmPtasklistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtasklistServiceImpl.getPtasklistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtasklistUpdataDefault(PmPtasklist pmPtasklist) {
        if (null == pmPtasklist) {
            return;
        }
        pmPtasklist.setGmtModified(this.getSysDate());
    }

    private void savePtasklistModel(PmPtasklist pmPtasklist) throws ApiException {
        if (null == pmPtasklist) {
            return;
        }
        try {
            this.pmPtasklistMapper.insert(pmPtasklist);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.savePtasklistModel.ex", (Throwable)e);
        }
    }

    private void savePtasklistBatchModel(List<PmPtasklist> pmPtasklistList) throws ApiException {
        if (null == pmPtasklistList || pmPtasklistList.isEmpty()) {
            return;
        }
        try {
            this.pmPtasklistMapper.insertBatch(pmPtasklistList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.savePtasklistBatchModel.ex", (Throwable)e);
        }
    }

    private PmPtasklist getPtasklistModelById(Integer ptasklistId) {
        if (null == ptasklistId) {
            return null;
        }
        try {
            return this.pmPtasklistMapper.selectByPrimaryKey(ptasklistId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtasklistServiceImpl.getPtasklistModelById", (Throwable)e);
            return null;
        }
    }

    private PmPtasklist getPtasklistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPtasklistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtasklistServiceImpl.getPtasklistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtasklistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.delPtasklistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.delPtasklistModelByCode.num");
        }
    }

    private void deletePtasklistModel(Integer ptasklistId) throws ApiException {
        if (null == ptasklistId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.deleteByPrimaryKey(ptasklistId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.deletePtasklistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.deletePtasklistModel.num");
        }
    }

    private void updatePtasklistModel(PmPtasklist pmPtasklist) throws ApiException {
        if (null == pmPtasklist) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.updateByPrimaryKey(pmPtasklist);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.updatePtasklistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.updatePtasklistModel.num");
        }
    }

    private void updateStatePtasklistModel(Integer ptasklistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ptasklistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptasklistId", ptasklistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.updateStatePtasklistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.updateStatePtasklistModel.null");
        }
    }

    private void updateStatePtasklistModelByCode(String tenantCode, String ptasklistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ptasklistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptasklistCode", ptasklistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.updateStatePtasklistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.updateStatePtasklistModelByCode.null");
        }
    }

    private PmPtasklist makePtasklist(PmPtasklistDomain pmPtasklistDomain, PmPtasklist pmPtasklist) {
        if (null == pmPtasklistDomain) {
            return null;
        }
        if (null == pmPtasklist) {
            pmPtasklist = new PmPtasklist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPtasklist, (Object)pmPtasklistDomain);
            return pmPtasklist;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtasklistServiceImpl.makePtasklist", (Throwable)e);
            return null;
        }
    }

    private PmPtasklistReDomain makePmPtasklistReDomain(PmPtasklist pmPtasklist) {
        if (null == pmPtasklist) {
            return null;
        }
        PmPtasklistReDomain pmPtasklistReDomain = new PmPtasklistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtasklistReDomain, (Object)pmPtasklist);
            return pmPtasklistReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtasklistServiceImpl.makePmPtasklistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPtasklist> queryPtasklistModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPtasklistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtasklistServiceImpl.queryPtasklistModel", (Throwable)e);
            return null;
        }
    }

    private int countPtasklist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPtasklistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtasklistServiceImpl.countPtasklist", (Throwable)e);
        }
        return i;
    }

    private PmPtasklist createPmPtasklist(PmPtasklistDomain pmPtasklistDomain) {
        String msg = this.checkPtasklist(pmPtasklistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.savePtasklist.checkPtasklist", msg);
        }
        PmPtasklist pmPtasklist = this.makePtasklist(pmPtasklistDomain, null);
        this.setPtasklistDefault(pmPtasklist);
        return pmPtasklist;
    }

    @Override
    public String savePtasklist(PmPtasklistDomain pmPtasklistDomain) throws ApiException {
        PmPtasklist pmPtasklist = this.createPmPtasklist(pmPtasklistDomain);
        this.savePtasklistModel(pmPtasklist);
        return pmPtasklist.getPtasklistCode();
    }

    @Override
    public String savePtasklistBatch(List<PmPtasklistDomain> pmPtasklistDomainList) throws ApiException {
        if (null == pmPtasklistDomainList || pmPtasklistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPtasklist> pmPtasklistList = new ArrayList<PmPtasklist>();
        String code = "";
        for (PmPtasklistDomain pmPtasklistDomain : pmPtasklistDomainList) {
            PmPtasklist pmPtasklist = this.createPmPtasklist(pmPtasklistDomain);
            code = pmPtasklist.getPtasklistCode();
            pmPtasklistList.add(pmPtasklist);
        }
        this.savePtasklistBatchModel(pmPtasklistList);
        return code;
    }

    @Override
    public void updatePtasklistState(Integer ptasklistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ptasklistId) {
            return;
        }
        this.updateStatePtasklistModel(ptasklistId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtasklistStateByCode(String tenantCode, String ptasklistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ptasklistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtasklistModelByCode(tenantCode, ptasklistCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtasklist(PmPtasklistDomain pmPtasklistDomain) throws ApiException {
        String msg = this.checkPtasklist(pmPtasklistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.updatePtasklist.checkPtasklist", msg);
        }
        PmPtasklist oldPmPtasklist = this.getPtasklistModelById(pmPtasklistDomain.getPtasklistId());
        if (null == oldPmPtasklist) {
            throw new ApiException("pm.PROMOTION.PmPtasklistServiceImpl.updatePtasklist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPtasklist pmPtasklist = this.makePtasklist(pmPtasklistDomain, oldPmPtasklist);
        this.setPtasklistUpdataDefault(pmPtasklist);
        this.updatePtasklistModel(pmPtasklist);
    }

    @Override
    public PmPtasklist getPtasklist(Integer ptasklistId) {
        if (null == ptasklistId) {
            return null;
        }
        return this.getPtasklistModelById(ptasklistId);
    }

    @Override
    public void deletePtasklist(Integer ptasklistId) throws ApiException {
        if (null == ptasklistId) {
            return;
        }
        this.deletePtasklistModel(ptasklistId);
    }

    @Override
    public QueryResult<PmPtasklist> queryPtasklistPage(Map<String, Object> map) {
        List<PmPtasklist> pmPtasklistList = this.queryPtasklistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtasklist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtasklistList);
        return queryResult;
    }

    @Override
    public PmPtasklist getPtasklistByCode(String tenantCode, String ptasklistCode) throws ApiException {
        if (StringUtils.isBlank((String)ptasklistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptasklistCode", ptasklistCode);
        return this.getPtasklistModelByCode(map);
    }

    @Override
    public void deletePtasklistByCode(String tenantCode, String ptasklistCode) throws ApiException {
        if (StringUtils.isBlank((String)ptasklistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptasklistCode", ptasklistCode);
        this.delPtasklistModelByCode(map);
    }
}

