/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmRsgiftMapper;
import com.yqbsoft.laser.service.pm.domain.PmRsgiftDomain;
import com.yqbsoft.laser.service.pm.domain.PmRsgiftReDomain;
import com.yqbsoft.laser.service.pm.model.PmRsgift;
import com.yqbsoft.laser.service.pm.service.PmRsgiftService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmRsgiftServiceImpl
extends BaseServiceImpl
implements PmRsgiftService {
    private static final String SYS_CODE = "pm.PROMOTION.PmRsgiftServiceImpl";
    private PmRsgiftMapper pmRsgiftMapper;

    public void setPmRsgiftMapper(PmRsgiftMapper pmRsgiftMapper) {
        this.pmRsgiftMapper = pmRsgiftMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmRsgiftMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRsgift(PmRsgiftDomain pmRsgiftDomain) {
        if (null == pmRsgiftDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmRsgiftDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRsgiftDefault(PmRsgift pmRsgift) {
        if (null == pmRsgift) {
            return;
        }
        if (null == pmRsgift.getDataState()) {
            pmRsgift.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmRsgift.getGmtCreate()) {
            pmRsgift.setGmtCreate(date);
        }
        pmRsgift.setGmtModified(date);
        if (StringUtils.isBlank((String)pmRsgift.getRsgiftCode())) {
            pmRsgift.setRsgiftCode(this.getNo(null, "PmRsgift", "pmRsgift", pmRsgift.getTenantCode()));
        }
    }

    private int getRsgiftMaxCode() {
        int code = 0;
        try {
            return this.pmRsgiftMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftServiceImpl.getRsgiftMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRsgiftUpdataDefault(PmRsgift pmRsgift) {
        if (null == pmRsgift) {
            return;
        }
        pmRsgift.setGmtModified(this.getSysDate());
    }

    private void saveRsgiftModel(PmRsgift pmRsgift) throws ApiException {
        if (null == pmRsgift) {
            return;
        }
        try {
            this.pmRsgiftMapper.insert(pmRsgift);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.saveRsgiftModel.ex", (Throwable)e);
        }
    }

    private void saveRsgiftBatchModel(List<PmRsgift> pmRsgiftList) throws ApiException {
        if (null == pmRsgiftList || pmRsgiftList.isEmpty()) {
            return;
        }
        try {
            this.pmRsgiftMapper.insertBatch(pmRsgiftList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.saveRsgiftBatchModel.ex", (Throwable)e);
        }
    }

    private PmRsgift getRsgiftModelById(Integer rsgiftId) {
        if (null == rsgiftId) {
            return null;
        }
        try {
            return this.pmRsgiftMapper.selectByPrimaryKey(rsgiftId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftServiceImpl.getRsgiftModelById", (Throwable)e);
            return null;
        }
    }

    private PmRsgift getRsgiftModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmRsgiftMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftServiceImpl.getRsgiftModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRsgiftModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmRsgiftMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.delRsgiftModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.delRsgiftModelByCode.num");
        }
    }

    private void deleteRsgiftModel(Integer rsgiftId) throws ApiException {
        if (null == rsgiftId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmRsgiftMapper.deleteByPrimaryKey(rsgiftId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.deleteRsgiftModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.deleteRsgiftModel.num");
        }
    }

    private void updateRsgiftModel(PmRsgift pmRsgift) throws ApiException {
        if (null == pmRsgift) {
            return;
        }
        int i = 0;
        try {
            i = this.pmRsgiftMapper.updateByPrimaryKey(pmRsgift);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.updateRsgiftModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.updateRsgiftModel.num");
        }
    }

    private void updateStateRsgiftModel(Integer rsgiftId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rsgiftId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rsgiftId", rsgiftId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmRsgiftMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.updateStateRsgiftModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.updateStateRsgiftModel.null");
        }
    }

    private void updateStateRsgiftModelByCode(String tenantCode, String rsgiftCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rsgiftCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsgiftCode", rsgiftCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmRsgiftMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.updateStateRsgiftModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.updateStateRsgiftModelByCode.null");
        }
    }

    private PmRsgift makeRsgift(PmRsgiftDomain pmRsgiftDomain, PmRsgift pmRsgift) {
        if (null == pmRsgiftDomain) {
            return null;
        }
        if (null == pmRsgift) {
            pmRsgift = new PmRsgift();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmRsgift, (Object)pmRsgiftDomain);
            return pmRsgift;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftServiceImpl.makeRsgift", (Throwable)e);
            return null;
        }
    }

    private PmRsgiftReDomain makePmRsgiftReDomain(PmRsgift pmRsgift) {
        if (null == pmRsgift) {
            return null;
        }
        PmRsgiftReDomain pmRsgiftReDomain = new PmRsgiftReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmRsgiftReDomain, (Object)pmRsgift);
            return pmRsgiftReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftServiceImpl.makePmRsgiftReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmRsgift> queryRsgiftModelPage(Map<String, Object> parammap) {
        try {
            return this.pmRsgiftMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftServiceImpl.queryRsgiftModel", (Throwable)e);
            return null;
        }
    }

    private int countRsgift(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmRsgiftMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftServiceImpl.countRsgift", (Throwable)e);
        }
        return i;
    }

    private PmRsgift createPmRsgift(PmRsgiftDomain pmRsgiftDomain) {
        String msg = this.checkRsgift(pmRsgiftDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.saveRsgift.checkRsgift", msg);
        }
        PmRsgift pmRsgift = this.makeRsgift(pmRsgiftDomain, null);
        this.setRsgiftDefault(pmRsgift);
        return pmRsgift;
    }

    @Override
    public String saveRsgift(PmRsgiftDomain pmRsgiftDomain) throws ApiException {
        PmRsgift pmRsgift = this.createPmRsgift(pmRsgiftDomain);
        this.saveRsgiftModel(pmRsgift);
        return pmRsgift.getRsgiftCode();
    }

    @Override
    public String saveRsgiftBatch(List<PmRsgiftDomain> pmRsgiftDomainList) throws ApiException {
        if (null == pmRsgiftDomainList || pmRsgiftDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmRsgift> pmRsgiftList = new ArrayList<PmRsgift>();
        String code = "";
        for (PmRsgiftDomain pmRsgiftDomain : pmRsgiftDomainList) {
            PmRsgift pmRsgift = this.createPmRsgift(pmRsgiftDomain);
            code = pmRsgift.getRsgiftCode();
            pmRsgiftList.add(pmRsgift);
        }
        this.saveRsgiftBatchModel(pmRsgiftList);
        return code;
    }

    @Override
    public void updateRsgiftState(Integer rsgiftId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == rsgiftId) {
            return;
        }
        this.updateStateRsgiftModel(rsgiftId, dataState, oldDataState, map);
    }

    @Override
    public void updateRsgiftStateByCode(String tenantCode, String rsgiftCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)rsgiftCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRsgiftModelByCode(tenantCode, rsgiftCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRsgift(PmRsgiftDomain pmRsgiftDomain) throws ApiException {
        String msg = this.checkRsgift(pmRsgiftDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.updateRsgift.checkRsgift", msg);
        }
        PmRsgift oldPmRsgift = this.getRsgiftModelById(pmRsgiftDomain.getRsgiftId());
        if (null == oldPmRsgift) {
            throw new ApiException("pm.PROMOTION.PmRsgiftServiceImpl.updateRsgift.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmRsgift pmRsgift = this.makeRsgift(pmRsgiftDomain, oldPmRsgift);
        this.setRsgiftUpdataDefault(pmRsgift);
        this.updateRsgiftModel(pmRsgift);
    }

    @Override
    public PmRsgift getRsgift(Integer rsgiftId) {
        if (null == rsgiftId) {
            return null;
        }
        return this.getRsgiftModelById(rsgiftId);
    }

    @Override
    public void deleteRsgift(Integer rsgiftId) throws ApiException {
        if (null == rsgiftId) {
            return;
        }
        this.deleteRsgiftModel(rsgiftId);
    }

    @Override
    public QueryResult<PmRsgift> queryRsgiftPage(Map<String, Object> map) {
        List<PmRsgift> pmRsgiftList = this.queryRsgiftModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRsgift(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmRsgiftList);
        return queryResult;
    }

    @Override
    public PmRsgift getRsgiftByCode(String tenantCode, String rsgiftCode) throws ApiException {
        if (StringUtils.isBlank((String)rsgiftCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsgiftCode", rsgiftCode);
        return this.getRsgiftModelByCode(map);
    }

    @Override
    public void deleteRsgiftByCode(String tenantCode, String rsgiftCode) throws ApiException {
        if (StringUtils.isBlank((String)rsgiftCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsgiftCode", rsgiftCode);
        this.delRsgiftModelByCode(map);
    }
}

