/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsContlistConfMapper;
import com.yqbsoft.laser.service.portal.domain.CmsContlistConfDomain;
import com.yqbsoft.laser.service.portal.domain.CmsContlistConfReDomain;
import com.yqbsoft.laser.service.portal.model.CmsContlistConf;
import com.yqbsoft.laser.service.portal.service.CmsContlistConfService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsContlistConfServiceImpl
extends BaseServiceImpl
implements CmsContlistConfService {
    private static final String SYS_CODE = "cms.CmsContlistConfServiceImpl";
    private CmsContlistConfMapper cmsContlistConfMapper;
    private String cachekey = "contlistCode-tenantCode";

    public void setCmsContlistConfMapper(CmsContlistConfMapper cmsContlistConfMapper) {
        this.cmsContlistConfMapper = cmsContlistConfMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsContlistConfMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistConfServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContlistConf(CmsContlistConfDomain cmsContlistConfDomain) {
        if (null == cmsContlistConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsContlistConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContlistConfDefault(CmsContlistConf cmsContlistConf) {
        if (null == cmsContlistConf) {
            return;
        }
        if (null == cmsContlistConf.getDataState()) {
            cmsContlistConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cmsContlistConf.getGmtCreate()) {
            cmsContlistConf.setGmtCreate(date);
        }
        cmsContlistConf.setGmtModified(date);
        if (StringUtils.isBlank((String)cmsContlistConf.getContlistConfCode())) {
            cmsContlistConf.setContlistConfCode(this.getNo(null, "CmsContlistConf", "cmsContlistConf", cmsContlistConf.getTenantCode()));
        }
    }

    private int getContlistConfMaxCode() {
        int code = 0;
        try {
            return this.cmsContlistConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistConfServiceImpl.getContlistConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContlistConfUpdataDefault(CmsContlistConf cmsContlistConf) {
        if (null == cmsContlistConf) {
            return;
        }
        cmsContlistConf.setGmtModified(this.getSysDate());
    }

    private void saveContlistConfModel(CmsContlistConf cmsContlistConf) throws ApiException {
        if (null == cmsContlistConf) {
            return;
        }
        try {
            this.cmsContlistConfMapper.insert(cmsContlistConf);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.saveContlistConfModel.ex", (Throwable)e);
        }
    }

    private void saveContlistConfBatchModel(List<CmsContlistConf> cmsContlistConfList) throws ApiException {
        if (null == cmsContlistConfList || cmsContlistConfList.isEmpty()) {
            return;
        }
        try {
            this.cmsContlistConfMapper.insertBatch(cmsContlistConfList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.saveContlistConfBatchModel.ex", (Throwable)e);
        }
    }

    private CmsContlistConf getContlistConfModelById(Integer contlistConfId) {
        if (null == contlistConfId) {
            return null;
        }
        try {
            return this.cmsContlistConfMapper.selectByPrimaryKey(contlistConfId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistConfServiceImpl.getContlistConfModelById", (Throwable)e);
            return null;
        }
    }

    private CmsContlistConf getContlistConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsContlistConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistConfServiceImpl.getContlistConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContlistConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.delContlistConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.delContlistConfModelByCode.num");
        }
    }

    private void deleteContlistConfModel(Integer contlistConfId) throws ApiException {
        if (null == contlistConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistConfMapper.deleteByPrimaryKey(contlistConfId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.deleteContlistConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.deleteContlistConfModel.num");
        }
    }

    private void updateContlistConfModel(CmsContlistConf cmsContlistConf) throws ApiException {
        if (null == cmsContlistConf) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistConfMapper.updateByPrimaryKey(cmsContlistConf);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.updateContlistConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.updateContlistConfModel.num");
        }
    }

    private void updateStateContlistConfModel(Integer contlistConfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contlistConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contlistConfId", contlistConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsContlistConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.updateStateContlistConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.updateStateContlistConfModel.null");
        }
    }

    private void updateStateContlistConfModelByCode(String tenantCode, String contlistConfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contlistConfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistConfCode", contlistConfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsContlistConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.updateStateContlistConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.updateStateContlistConfModelByCode.null");
        }
    }

    private CmsContlistConf makeContlistConf(CmsContlistConfDomain cmsContlistConfDomain, CmsContlistConf cmsContlistConf) {
        if (null == cmsContlistConfDomain) {
            return null;
        }
        if (null == cmsContlistConf) {
            cmsContlistConf = new CmsContlistConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlistConf, (Object)cmsContlistConfDomain);
            return cmsContlistConf;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistConfServiceImpl.makeContlistConf", (Throwable)e);
            return null;
        }
    }

    private CmsContlistConfReDomain makeCmsContlistConfReDomain(CmsContlistConf cmsContlistConf) {
        if (null == cmsContlistConf) {
            return null;
        }
        CmsContlistConfReDomain cmsContlistConfReDomain = new CmsContlistConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlistConfReDomain, (Object)cmsContlistConf);
            return cmsContlistConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistConfServiceImpl.makeCmsContlistConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsContlistConf> queryContlistConfModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsContlistConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistConfServiceImpl.queryContlistConfModel", (Throwable)e);
            return null;
        }
    }

    private int countContlistConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsContlistConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistConfServiceImpl.countContlistConf", (Throwable)e);
        }
        return i;
    }

    private CmsContlistConf createCmsContlistConf(CmsContlistConfDomain cmsContlistConfDomain) {
        String msg = this.checkContlistConf(cmsContlistConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.saveContlistConf.checkContlistConf", msg);
        }
        CmsContlistConf cmsContlistConf = this.makeContlistConf(cmsContlistConfDomain, null);
        this.setContlistConfDefault(cmsContlistConf);
        return cmsContlistConf;
    }

    @Override
    public String saveContlistConf(CmsContlistConfDomain cmsContlistConfDomain) throws ApiException {
        CmsContlistConf cmsContlistConf = this.createCmsContlistConf(cmsContlistConfDomain);
        this.saveContlistConfModel(cmsContlistConf);
        return cmsContlistConf.getContlistConfCode();
    }

    @Override
    public String saveContlistConfBatch(List<CmsContlistConfDomain> cmsContlistConfDomainList) throws ApiException {
        if (null == cmsContlistConfDomainList || cmsContlistConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsContlistConf> cmsContlistConfList = new ArrayList<CmsContlistConf>();
        String code = "";
        for (CmsContlistConfDomain cmsContlistConfDomain : cmsContlistConfDomainList) {
            CmsContlistConf cmsContlistConf = this.createCmsContlistConf(cmsContlistConfDomain);
            code = cmsContlistConf.getContlistConfCode();
            cmsContlistConfList.add(cmsContlistConf);
        }
        this.saveContlistConfBatchModel(cmsContlistConfList);
        this.saveContlistConfToCache(cmsContlistConfDomainList);
        return code;
    }

    public void saveContlistConfToCache(List<CmsContlistConfDomain> cmsContlistConfDomainList) {
        if (ListUtil.isEmpty(cmsContlistConfDomainList)) {
            return;
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        String key = "";
        for (CmsContlistConfDomain cmsConflist : cmsContlistConfDomainList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)cmsConflist.getContlistConfTerm())) {
                cmsConflist.setContlistConfTerm("=");
            }
            if (ListUtil.isEmpty((Collection)(list = (ArrayList<String>)map.get(cmsConflist.getContlistConfType())))) {
                list = new ArrayList<String>();
                map.put(cmsConflist.getContlistConfType(), list);
            }
            list.add(cmsConflist.getContlistConfOp() + "|" + cmsConflist.getContlistConfTerm());
            key = cmsConflist.getContlistCode() + "-" + cmsConflist.getTenantCode();
        }
        DisUtil.del((String)key);
        DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    @Override
    public void updateContlistConfState(Integer contlistConfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contlistConfId) {
            return;
        }
        this.updateStateContlistConfModel(contlistConfId, dataState, oldDataState, map);
    }

    @Override
    public void updateContlistConfStateByCode(String tenantCode, String contlistConfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contlistConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContlistConfModelByCode(tenantCode, contlistConfCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContlistConf(CmsContlistConfDomain cmsContlistConfDomain) throws ApiException {
        String msg = this.checkContlistConf(cmsContlistConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.updateContlistConf.checkContlistConf", msg);
        }
        CmsContlistConf oldCmsContlistConf = this.getContlistConfModelById(cmsContlistConfDomain.getContlistConfId());
        if (null == oldCmsContlistConf) {
            throw new ApiException("cms.CmsContlistConfServiceImpl.updateContlistConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsContlistConf cmsContlistConf = this.makeContlistConf(cmsContlistConfDomain, oldCmsContlistConf);
        this.setContlistConfUpdataDefault(cmsContlistConf);
        this.updateContlistConfModel(cmsContlistConf);
    }

    @Override
    public CmsContlistConf getContlistConf(Integer contlistConfId) {
        if (null == contlistConfId) {
            return null;
        }
        return this.getContlistConfModelById(contlistConfId);
    }

    @Override
    public void deleteContlistConf(Integer contlistConfId) throws ApiException {
        if (null == contlistConfId) {
            return;
        }
        this.deleteContlistConfModel(contlistConfId);
    }

    @Override
    public QueryResult<CmsContlistConf> queryContlistConfPage(Map<String, Object> map) {
        List<CmsContlistConf> cmsContlistConfList = this.queryContlistConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContlistConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsContlistConfList);
        return queryResult;
    }

    @Override
    public CmsContlistConf getContlistConfByCode(String tenantCode, String contlistConfCode) throws ApiException {
        if (StringUtils.isBlank((String)contlistConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistConfCode", contlistConfCode);
        return this.getContlistConfModelByCode(map);
    }

    @Override
    public void deleteContlistConfByCode(String tenantCode, String contlistConfCode) throws ApiException {
        if (StringUtils.isBlank((String)contlistConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistConfCode", contlistConfCode);
        this.delContlistConfModelByCode(map);
    }
}

