/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsContlistMapper;
import com.yqbsoft.laser.service.portal.dao.CmsConttitleMapper;
import com.yqbsoft.laser.service.portal.domain.CmsContlistDomain;
import com.yqbsoft.laser.service.portal.domain.CmsContlistReDomain;
import com.yqbsoft.laser.service.portal.domain.CmsConttitleDomain;
import com.yqbsoft.laser.service.portal.domain.CmsConttitleReDomain;
import com.yqbsoft.laser.service.portal.model.CmsContlist;
import com.yqbsoft.laser.service.portal.model.CmsConttitle;
import com.yqbsoft.laser.service.portal.service.CmsConttitleService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsConttitleServiceImpl
extends BaseServiceImpl
implements CmsConttitleService {
    private static final String SYS_CODE = "cms.CmsConttitleServiceImpl";
    private CmsConttitleMapper cmsConttitleMapper;
    private CmsContlistMapper cmsContlistMapper;

    public void setCmsConttitleMapper(CmsConttitleMapper cmsConttitleMapper) {
        this.cmsConttitleMapper = cmsConttitleMapper;
    }

    public void setCmsContlistMapper(CmsContlistMapper cmsContlistMapper) {
        this.cmsContlistMapper = cmsContlistMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsConttitleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkConttitle(CmsConttitleDomain cmsConttitleDomain) {
        if (null == cmsConttitleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsConttitleDomain.getConttitleType())) {
            msg = msg + "ConttitleType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmsConttitleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setConttitleDefault(CmsConttitle cmsConttitle) {
        if (null == cmsConttitle) {
            return;
        }
        if (null == cmsConttitle.getDataState()) {
            cmsConttitle.setDataState(0);
        }
        if (null == cmsConttitle.getGmtCreate()) {
            cmsConttitle.setGmtCreate(this.getSysDate());
        }
        cmsConttitle.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsConttitle.getConttitleCode())) {
            cmsConttitle.setConttitleCode(this.createUUIDString());
        }
    }

    private int getConttitleMaxCode() {
        int code = 0;
        try {
            return this.cmsConttitleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.getConttitleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setConttitleUpdataDefault(CmsConttitle cmsConttitle) {
        if (null == cmsConttitle) {
            return;
        }
        cmsConttitle.setGmtModified(this.getSysDate());
    }

    private void saveConttitleModel(CmsConttitle cmsConttitle) throws ApiException {
        if (null == cmsConttitle) {
            return;
        }
        try {
            this.cmsConttitleMapper.insert(cmsConttitle);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.saveConttitleModel.ex", (Throwable)e);
        }
    }

    private void saveConttitleBatchModel(List<CmsConttitle> cmsConttitleList) throws ApiException {
        if (null == cmsConttitleList || cmsConttitleList.isEmpty()) {
            return;
        }
        try {
            this.cmsConttitleMapper.insertBatch(cmsConttitleList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.saveConttitleBatchModel.ex", (Throwable)e);
        }
    }

    private CmsConttitle getConttitleModelById(Integer conttitleId) {
        if (null == conttitleId) {
            return null;
        }
        try {
            return this.cmsConttitleMapper.selectByPrimaryKey(conttitleId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.getConttitleModelById", (Throwable)e);
            return null;
        }
    }

    private CmsConttitle getConttitleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsConttitleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.getConttitleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delConttitleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsConttitleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.delConttitleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsConttitleServiceImpl.delConttitleModelByCode.num");
        }
    }

    private void deleteConttitleModel(Integer conttitleId) throws ApiException {
        if (null == conttitleId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsConttitleMapper.deleteByPrimaryKey(conttitleId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.deleteConttitleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsConttitleServiceImpl.deleteConttitleModel.num");
        }
    }

    private void updateConttitleModel(CmsConttitle cmsConttitle) throws ApiException {
        if (null == cmsConttitle) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsConttitleMapper.updateByPrimaryKeySelective(cmsConttitle);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateConttitleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateConttitleModel.num");
        }
    }

    private void updateConttitleOrderModel(String contlistOrder, String contlistCode, String tenantCode) throws ApiException {
        if (null == contlistOrder || null == contlistCode || null == tenantCode) {
            return;
        }
        int i = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistOrder", contlistOrder);
        map.put("contlistCode", contlistCode);
        CmsContlist oldCmsContlist = this.cmsContlistMapper.getByCode(map);
        if (null == oldCmsContlist) {
            return;
        }
        if (2 == oldCmsContlist.getDataState()) {
            map.put("dataState", 1);
        }
        try {
            i = this.cmsContlistMapper.updateOrderByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateConttitleOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateConttitleOrderModel.num");
        }
    }

    private void updateStateConttitleModel(Integer conttitleId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == conttitleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", dataState);
        map.put("conttitleId", conttitleId);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsConttitleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateConttitleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateConttitleModel.null");
        }
    }

    private void updateStateConttitleModelByCode(String tenantCode, String conttitleCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)conttitleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("conttitleCode", conttitleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsConttitleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateConttitleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateConttitleModelByCode.null");
        }
    }

    private CmsConttitle makeConttitle(CmsConttitleDomain cmsConttitleDomain, CmsConttitle cmsConttitle) {
        if (null == cmsConttitleDomain) {
            return null;
        }
        if (null == cmsConttitle) {
            cmsConttitle = new CmsConttitle();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsConttitle, (Object)cmsConttitleDomain);
            return cmsConttitle;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.makeConttitle", (Throwable)e);
            return null;
        }
    }

    private CmsConttitleReDomain makeCmsConttitleReDomain(CmsConttitle cmsConttitle) {
        if (null == cmsConttitle) {
            return null;
        }
        CmsConttitleReDomain cmsConttitleReDomain = new CmsConttitleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsConttitleReDomain, (Object)cmsConttitle);
            return cmsConttitleReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.makeCmsConttitleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsConttitle> queryConttitleModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsConttitleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.queryConttitleModel", (Throwable)e);
            return null;
        }
    }

    private int countConttitle(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsConttitleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.countConttitle", (Throwable)e);
        }
        return i;
    }

    private CmsConttitle createCmsConttitle(CmsConttitleDomain cmsConttitleDomain) {
        String msg = this.checkConttitle(cmsConttitleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsConttitleServiceImpl.saveConttitle.checkConttitle", msg);
        }
        CmsConttitle cmsConttitle = this.makeConttitle(cmsConttitleDomain, null);
        this.setConttitleDefault(cmsConttitle);
        return cmsConttitle;
    }

    private String checkContlist(CmsContlistDomain cmsContlistDomain) {
        if (null == cmsContlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsContlistDomain.getConttitleCode())) {
            msg = msg + "ConttitleCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmsContlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContlistDefault(CmsContlist cmsContlist) {
        if (null == cmsContlist) {
            return;
        }
        if (null == cmsContlist.getDataState()) {
            cmsContlist.setDataState(0);
        }
        if (null == cmsContlist.getGmtCreate()) {
            cmsContlist.setGmtCreate(this.getSysDate());
        }
        cmsContlist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsContlist.getContlistCode())) {
            cmsContlist.setContlistCode(this.createUUIDString());
        }
    }

    private int getContlistMaxCode() {
        int code = 0;
        try {
            return this.cmsContlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.getContlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContlistUpdataDefault(CmsContlist cmsContlist) {
        if (null == cmsContlist) {
            return;
        }
        cmsContlist.setGmtModified(this.getSysDate());
    }

    private void saveContlistModel(CmsContlist cmsContlist) throws ApiException {
        if (null == cmsContlist) {
            return;
        }
        try {
            this.cmsContlistMapper.insert(cmsContlist);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.saveContlistModel.ex", (Throwable)e);
        }
    }

    private void saveContlistBatchModel(List<CmsContlist> cmsContlistList) throws ApiException {
        if (null == cmsContlistList || cmsContlistList.isEmpty()) {
            return;
        }
        try {
            this.cmsContlistMapper.insertBatch(cmsContlistList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.saveContlistBatchModel.ex", (Throwable)e);
        }
    }

    private CmsContlist getContlistModelById(Integer contlistId) {
        if (null == contlistId) {
            return null;
        }
        try {
            return this.cmsContlistMapper.selectByPrimaryKey(contlistId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.getContlistModelById", (Throwable)e);
            return null;
        }
    }

    private CmsContlist getContlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsContlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.getContlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.delContlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsConttitleServiceImpl.delContlistModelByCode.num");
        }
    }

    private void deleteContlistModel(Integer contlistId) throws ApiException {
        if (null == contlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistMapper.deleteByPrimaryKey(contlistId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.deleteContlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsConttitleServiceImpl.deleteContlistModel.num");
        }
    }

    private void updateContlistModel(CmsContlist cmsContlist) throws ApiException {
        if (null == cmsContlist) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistMapper.updateByPrimaryKeySelective(cmsContlist);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateContlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateContlistModel.num");
        }
    }

    private void updateStateContlistModel(Integer contlistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contlistId", contlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsContlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateContlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateContlistModel.null");
        }
    }

    private void updateStateContlistModelByCode(String tenantCode, String contlistCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)contlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistCode", contlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsContlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateContlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateContlistModelByCode.null");
        }
    }

    private CmsContlist makeContlist(CmsContlistDomain cmsContlistDomain, CmsContlist cmsContlist) {
        if (null == cmsContlistDomain) {
            return null;
        }
        if (null == cmsContlist) {
            cmsContlist = new CmsContlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlist, (Object)cmsContlistDomain);
            return cmsContlist;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.makeContlist", (Throwable)e);
            return null;
        }
    }

    private CmsContlistReDomain makeCmsContlistReDomain(CmsContlist cmsContlist) {
        if (null == cmsContlist) {
            return null;
        }
        CmsContlistReDomain cmsContlistReDomain = new CmsContlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlistReDomain, (Object)cmsContlist);
            return cmsContlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.makeCmsContlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsContlist> queryContlistModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsContlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.queryContlistModel", (Throwable)e);
            return null;
        }
    }

    private int countContlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsContlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.countContlist", (Throwable)e);
        }
        return i;
    }

    private CmsContlist createCmsContlist(CmsContlistDomain cmsContlistDomain) {
        String msg = this.checkContlist(cmsContlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsConttitleServiceImpl.saveContlist.checkContlist", msg);
        }
        CmsContlist cmsContlist = this.makeContlist(cmsContlistDomain, null);
        this.setContlistDefault(cmsContlist);
        return cmsContlist;
    }

    @Override
    public String saveConttitle(CmsConttitleDomain cmsConttitleDomain) throws ApiException {
        CmsConttitle cmsConttitle = this.createCmsConttitle(cmsConttitleDomain);
        this.saveConttitleModel(cmsConttitle);
        this.saveList(cmsConttitle, cmsConttitleDomain.getCmsContlistDomainList());
        return cmsConttitle.getConttitleCode();
    }

    private void saveList(CmsConttitle cmsConttitle, List<CmsContlistDomain> cmsContlistDomainList) {
        if (ListUtil.isEmpty(cmsContlistDomainList) || null == cmsConttitle) {
            return;
        }
        for (CmsContlistDomain cmsContlistDomain : cmsContlistDomainList) {
            cmsContlistDomain.setTenantCode(cmsConttitle.getTenantCode());
            cmsContlistDomain.setConttitleCode(cmsConttitle.getConttitleCode());
            cmsContlistDomain.setConttitleType(cmsConttitle.getConttitleType());
        }
        this.saveContlistBatch(cmsContlistDomainList);
    }

    @Override
    public String saveConttitleBatch(List<CmsConttitleDomain> cmsConttitleDomainList) throws ApiException {
        if (null == cmsConttitleDomainList || cmsConttitleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsConttitle> cmsConttitleList = new ArrayList<CmsConttitle>();
        String code = "";
        for (CmsConttitleDomain cmsConttitleDomain : cmsConttitleDomainList) {
            CmsConttitle cmsConttitle = this.createCmsConttitle(cmsConttitleDomain);
            code = cmsConttitle.getConttitleCode();
            cmsConttitleList.add(cmsConttitle);
        }
        this.saveConttitleBatchModel(cmsConttitleList);
        return code;
    }

    @Override
    public void updateConttitleState(Integer conttitleId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateConttitleModel(conttitleId, dataState, oldDataState);
    }

    @Override
    public void updateConttitleTreleaseByCode(String tenantCode, String tginfoMenuCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoMenuCode", tginfoMenuCode);
        map.put("dataState", 1);
        List<CmsConttitle> list = this.queryConttitleModelPage(map);
        map.put("dataState", 2);
        List<CmsConttitle> list2 = this.queryConttitleModelPage(map);
        if (ListUtil.isEmpty(list) && ListUtil.isEmpty(list2)) {
            return;
        }
        if (ListUtil.isNotEmpty(list)) {
            for (CmsConttitle cmsConttitle : list) {
                this.updateRelease(cmsConttitle);
            }
        }
        if (ListUtil.isNotEmpty(list2)) {
            for (CmsConttitle cmsConttitle : list2) {
                this.updateRelease(cmsConttitle);
            }
        }
        List<CmsConttitleReDomain> relist = this.queryConttitleReDomainByCode(tenantCode, tginfoMenuCode);
        DisUtil.setMap((String)"conttitle-menu-tenantCode", (String)(tginfoMenuCode + "-" + tenantCode), (String)JsonUtil.buildNormalBinder().toJson(relist));
        this.updateTitleListHtml(tenantCode, tginfoMenuCode);
    }

    @Override
    public void loadcache() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 2);
        map.put("order", true);
        map.put("orderStr", "TENANT_CODE,TGINFO_MENU_CODE,CONTTITLE_ORDER asc");
        List<CmsConttitle> list = this.queryConttitleModelPage(map);
        if (list == null || list.isEmpty()) {
            DisUtil.delVer((String)"conttitle-menu-tenantCode");
            return;
        }
        String key = "";
        HashMap<String, ArrayList<CmsConttitleReDomain>> cachemap = new HashMap<String, ArrayList<CmsConttitleReDomain>>();
        for (CmsConttitle cmsConttitle : list) {
            CmsConttitleReDomain cmsConttitleReDomain = this.makeTitle(cmsConttitle);
            if (null == cmsConttitleReDomain) continue;
            key = cmsConttitle.getTginfoMenuCode() + "-" + cmsConttitle.getTenantCode();
            ArrayList<CmsConttitleReDomain> relist = (ArrayList<CmsConttitleReDomain>)cachemap.get(key);
            if (ListUtil.isEmpty((Collection)relist)) {
                relist = new ArrayList<CmsConttitleReDomain>();
            }
            relist.add(cmsConttitleReDomain);
            cachemap.put(key, relist);
        }
        for (String key1 : cachemap.keySet()) {
            DisUtil.setMap((String)"conttitle-menu-tenantCode", (String)key1, (String)JsonUtil.buildNormalBinder().toJson(cachemap.get(key1)));
        }
    }

    private void updateTitleListHtml(String tenantCode, String tginfoMenuCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("htmldataMenutype", "TG");
        params.put("htmldataMenu", tginfoMenuCode);
        params.put("htmldataCode", "CmsConttitle");
        params.put("tenantCode", tenantCode);
        params.put("htmldataFilename", tginfoMenuCode + ".html");
        params.put("htmlcontOpparam", "{\"tenantCode\":\"" + tenantCode + "\",\"tginfoMenuCode\":\"" + tginfoMenuCode + "\"}");
        Date gmtCreate = this.getSysDate();
        String separator = "/";
        String docPath = separator + DateUtils.getDateString((Date)gmtCreate, (String)"yyyyMM") + separator + DateUtils.getDateString((Date)gmtCreate, (String)"dd") + separator;
        params.put("htmldataFilepath", docPath);
        map.put("htmlRelease", JsonUtil.buildNormalBinder().toJson(params));
        this.internalInvoke("pfs.htmlcont.sendHtmlcontOpData", map);
    }

    private void updateRelease(CmsConttitle cmsConttitle) {
        if (null == cmsConttitle) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateRelease.cmsConttitle");
        }
        cmsConttitle.setConttitleReleasetime(this.getSysDate());
        cmsConttitle.setConttitlePicurlNow(cmsConttitle.getConttitlePicurl());
        cmsConttitle.setConttitlePicurl3Now(cmsConttitle.getConttitlePicurl3());
        cmsConttitle.setConttitlePicurl1Now(cmsConttitle.getConttitlePicurl1());
        cmsConttitle.setConttitlePicurl2Now(cmsConttitle.getConttitlePicurl2());
        cmsConttitle.setConttitleOrderNow(cmsConttitle.getConttitleOrder());
        cmsConttitle.setConttitleNameNow(cmsConttitle.getConttitleName());
        cmsConttitle.setConttitleUrlNow(cmsConttitle.getConttitleUrl());
        cmsConttitle.setDataState(2);
        this.updateConttitleModel(cmsConttitle);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", cmsConttitle.getTenantCode());
        map.put("conttitleCode", cmsConttitle.getConttitleCode());
        map.put("dataState", 1);
        List<CmsContlist> cmsContlistList = this.queryContlistModelPage(map);
        if (ListUtil.isEmpty(cmsContlistList)) {
            return;
        }
        for (CmsContlist cmsContlist : cmsContlistList) {
            this.updateListRelease(cmsContlist);
        }
        map.put("dataState", 2);
        List<CmsContlist> cmsContlistList2 = this.queryContlistModelPage(map);
        if (ListUtil.isEmpty(cmsContlistList2)) {
            return;
        }
        for (CmsContlist cmsContlist : cmsContlistList2) {
            this.updateListRelease(cmsContlist);
        }
    }

    @Override
    public void updateConttitleStateByCode(String tenantCode, String conttitleCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateConttitleModelByCode(tenantCode, conttitleCode, dataState, oldDataState);
    }

    @Override
    public void updateConttitle(CmsConttitleDomain cmsConttitleDomain) throws ApiException {
        String msg = this.checkConttitle(cmsConttitleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateConttitle.checkConttitle", msg);
        }
        CmsConttitle oldCmsConttitle = this.getConttitleModelById(cmsConttitleDomain.getConttitleId());
        if (null == oldCmsConttitle) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateConttitle.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsConttitle cmsConttitle = this.makeConttitle(cmsConttitleDomain, oldCmsConttitle);
        if (2 == oldCmsConttitle.getDataState()) {
            cmsConttitle.setDataState(1);
        }
        this.setConttitleUpdataDefault(cmsConttitle);
        this.updateConttitleModel(cmsConttitle);
    }

    @Override
    public CmsConttitle getConttitle(Integer conttitleId) {
        return this.getConttitleModelById(conttitleId);
    }

    @Override
    public void deleteConttitle(Integer conttitleId) throws ApiException {
        this.deleteConttitleModel(conttitleId);
    }

    @Override
    public QueryResult<CmsConttitle> queryConttitlePage(Map<String, Object> map) {
        List<CmsConttitle> cmsConttitleList = this.queryConttitleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countConttitle(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsConttitleList);
        return queryResult;
    }

    @Override
    public CmsConttitle getConttitleByCode(String tenantCode, String conttitleCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("conttitleCode", conttitleCode);
        return this.getConttitleModelByCode(map);
    }

    @Override
    public void deleteConttitleByCode(String tenantCode, String conttitleCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("conttitleCode", conttitleCode);
        this.delConttitleModelByCode(map);
    }

    @Override
    public String saveContlist(CmsContlistDomain cmsContlistDomain) throws ApiException {
        CmsContlist cmsContlist = this.createCmsContlist(cmsContlistDomain);
        this.saveContlistModel(cmsContlist);
        return cmsContlist.getContlistCode();
    }

    @Override
    public void updateContlistOrder(String contlistOrder, String contlistCode, String tenantCode) throws ApiException {
        this.updateConttitleOrderModel(contlistOrder, contlistCode, tenantCode);
    }

    @Override
    public String saveContlistBatch(List<CmsContlistDomain> cmsContlistDomainList) throws ApiException {
        if (null == cmsContlistDomainList || cmsContlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsContlist> cmsContlistList = new ArrayList<CmsContlist>();
        String code = "";
        for (CmsContlistDomain cmsContlistDomain : cmsContlistDomainList) {
            CmsContlist cmsContlist = this.createCmsContlist(cmsContlistDomain);
            code = cmsContlist.getContlistCode();
            cmsContlistList.add(cmsContlist);
        }
        this.saveContlistBatchModel(cmsContlistList);
        return code;
    }

    @Override
    public void updateContlistState(Integer contlistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContlistModel(contlistId, dataState, oldDataState);
        if (2 == dataState) {
            CmsContlist cmsContlist = this.getContlist(contlistId);
            this.updateListRelease(cmsContlist);
        }
    }

    private void updateListRelease(CmsContlist cmsContlist) {
        if (null == cmsContlist) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateListRelease.cmsContlist");
        }
        cmsContlist.setContlistReleasetime(this.getSysDate());
        cmsContlist.setContlistPriceNow(cmsContlist.getContlistPrice());
        cmsContlist.setContlistPrice1Now(cmsContlist.getContlistPrice1());
        cmsContlist.setContlistPrice2Now(cmsContlist.getContlistPrice2());
        cmsContlist.setContlistPicurlNow(cmsContlist.getContlistPicurl());
        cmsContlist.setContlistPicurl3Now(cmsContlist.getContlistPicurl3());
        cmsContlist.setContlistPicurl1Now(cmsContlist.getContlistPicurl1());
        cmsContlist.setContlistPicurl2Now(cmsContlist.getContlistPicurl2());
        cmsContlist.setContlistOrderNow(cmsContlist.getContlistOrder());
        cmsContlist.setContlistNameNow(cmsContlist.getContlistName());
        cmsContlist.setContlistUrlNow(cmsContlist.getContlistUrl());
        cmsContlist.setDataState(2);
        this.updateContlistModel(cmsContlist);
    }

    public void updateTitleReleaseHtml(CmsConttitle cmsConttitle) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("htmldataMenutype", "TG");
        params.put("htmldataMenu", cmsConttitle.getTginfoMenuCode());
        params.put("htmldataCode", "CmsConttitle");
        params.put("tenantCode", cmsConttitle.getTenantCode());
        params.put("htmldataFilename", cmsConttitle.getTginfoMenuCode() + ".html");
        params.put("htmlcontOpparam", JsonUtil.buildNormalBinder().toJson((Object)cmsConttitle));
        Date gmtCreate = cmsConttitle.getConttitleReleasetime();
        String separator = "/";
        String docPath = separator + DateUtils.getDateString((Date)gmtCreate, (String)"yyyyMM") + separator + DateUtils.getDateString((Date)gmtCreate, (String)"dd") + separator;
        params.put("htmldataFilepath", docPath);
        map.put("htmlRelease", JsonUtil.buildNormalBinder().toJson(params));
        this.internalInvoke("pfs.htmlcont.sendHtmlcontOpData", map);
    }

    public void updateListReleaseHtml(CmsContlist cmsContlist) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("htmldataMenutype", "TG");
        params.put("htmldataMenu", cmsContlist.getTginfoMenuCode());
        params.put("htmldataCode", "CmsContlist");
        params.put("tenantCode", cmsContlist.getTenantCode());
        params.put("htmldataFilename", cmsContlist.getTginfoMenuCode() + ".html");
        params.put("htmlcontOpparam", JsonUtil.buildNormalBinder().toJson((Object)cmsContlist));
        Date gmtCreate = cmsContlist.getContlistReleasetime();
        String separator = "/";
        String docPath = separator + DateUtils.getDateString((Date)gmtCreate, (String)"yyyyMM") + separator + DateUtils.getDateString((Date)gmtCreate, (String)"dd") + separator;
        params.put("htmldataFilepath", docPath);
        map.put("htmlRelease", JsonUtil.buildNormalBinder().toJson(params));
        this.internalInvoke("pfs.htmlcont.sendHtmlcontOpData", map);
    }

    @Override
    public void updateContlistStateByCode(String tenantCode, String contlistCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContlistModelByCode(tenantCode, contlistCode, dataState, oldDataState);
        if (2 == dataState) {
            CmsContlist cmsContlist = this.getContlistByCode(tenantCode, contlistCode);
            this.updateListRelease(cmsContlist);
        }
    }

    @Override
    public void updateContlist(CmsContlistDomain cmsContlistDomain) throws ApiException {
        String msg = this.checkContlist(cmsContlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateContlist.checkContlist", msg);
        }
        CmsContlist oldCmsContlist = this.getContlistModelById(cmsContlistDomain.getContlistId());
        if (null == oldCmsContlist) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateContlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsContlist cmsContlist = this.makeContlist(cmsContlistDomain, oldCmsContlist);
        if (2 == oldCmsContlist.getDataState()) {
            cmsContlist.setDataState(1);
        }
        this.setContlistUpdataDefault(cmsContlist);
        this.updateContlistModel(cmsContlist);
    }

    @Override
    public CmsContlist getContlist(Integer contlistId) {
        return this.getContlistModelById(contlistId);
    }

    @Override
    public void deleteContlist(Integer contlistId) throws ApiException {
        this.deleteContlistModel(contlistId);
    }

    @Override
    public QueryResult<CmsContlist> queryContlistPage(Map<String, Object> map) {
        List<CmsContlist> cmsContlistList = this.queryContlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsContlistList);
        return queryResult;
    }

    @Override
    public CmsContlist getContlistByCode(String tenantCode, String contlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistCode", contlistCode);
        return this.getContlistModelByCode(map);
    }

    @Override
    public void deleteContlistByCode(String tenantCode, String contlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistCode", contlistCode);
        this.delContlistModelByCode(map);
    }

    @Override
    public CmsConttitleReDomain getConttitleReDomainByCode(String tenantCode, String conttitleCode) throws ApiException {
        CmsConttitle cmsConttitle = this.getConttitleByCode(tenantCode, conttitleCode);
        if (null == cmsConttitle) {
            return null;
        }
        return this.makeTitle(cmsConttitle);
    }

    @Override
    public List<CmsConttitleReDomain> queryConttitleReDomainByCode(String tenantCode, String tginfoMenuCode) throws ApiException {
        if (StringUtils.isBlank((String)tginfoMenuCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoMenuCode", tginfoMenuCode);
        map.put("dataState", 2);
        map.put("order", true);
        map.put("orderStr", "CONTTITLE_ORDER asc");
        List<CmsConttitle> list = this.queryConttitleModelPage(map);
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<CmsConttitleReDomain> reList = new ArrayList<CmsConttitleReDomain>();
        for (CmsConttitle cmsConttitle : list) {
            CmsConttitleReDomain cmsConttitleReDomain = this.makeTitle(cmsConttitle);
            if (null == cmsConttitleReDomain) continue;
            reList.add(cmsConttitleReDomain);
        }
        return reList;
    }

    private CmsConttitleReDomain makeTitle(CmsConttitle cmsConttitle) {
        if (null == cmsConttitle) {
            return null;
        }
        CmsConttitleReDomain cmsConttitleReDomain = new CmsConttitleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsConttitleReDomain, (Object)cmsConttitle);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.makeTitle.null", (Throwable)e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", cmsConttitle.getTenantCode());
        map.put("conttitleCode", cmsConttitle.getConttitleCode());
        map.put("dataState", 2);
        map.put("order", true);
        map.put("orderStr", "CONTLIST_ORDER asc");
        List<CmsContlist> cmsContlistList = this.queryContlistModelPage(map);
        if (ListUtil.isEmpty(cmsContlistList)) {
            return cmsConttitleReDomain;
        }
        cmsConttitleReDomain.setCmsContlistReDomainList(this.makeListReDomain(cmsContlistList));
        return cmsConttitleReDomain;
    }

    private List<CmsContlistReDomain> makeListReDomain(List<CmsContlist> cmsContlistList) {
        if (ListUtil.isEmpty(cmsContlistList)) {
            return null;
        }
        ArrayList<CmsContlistReDomain> list = new ArrayList<CmsContlistReDomain>();
        for (CmsContlist cmsContlist : cmsContlistList) {
            CmsContlistReDomain cmsContlistReDomain = this.makeReDomain(cmsContlist);
            if (null == cmsContlistReDomain) continue;
            list.add(cmsContlistReDomain);
        }
        return list;
    }

    private CmsContlistReDomain makeReDomain(CmsContlist cmsContlist) {
        if (null == cmsContlist) {
            return null;
        }
        CmsContlistReDomain cmsContlistReDomain = new CmsContlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlistReDomain, (Object)cmsContlist);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsConttitleServiceImpl.makeReDomain.null", (Throwable)e);
        }
        return cmsContlistReDomain;
    }

    @Override
    public void saveConttitleInit(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", "00000000");
        List<CmsConttitle> cmsConttitleList = this.queryConttitleModelPage(parammap);
        if (ListUtil.isEmpty(cmsConttitleList)) {
            return;
        }
        HashMap<String, String> menuOcodeMap = new HashMap<String, String>();
        for (CmsConttitle cmsConttitle : cmsConttitleList) {
            CmsConttitle oldCmsConttitle = this.getConttitleByCode(tenantCode, cmsConttitle.getConttitleCode());
            String menuOcode = cmsConttitle.getTginfoMenuCode();
            if (StringUtils.isNotBlank((String)menuOcode)) {
                menuOcodeMap.put(menuOcode, menuOcode);
            }
            if (null == oldCmsConttitle) {
                cmsConttitle.setConttitleId(null);
                cmsConttitle.setTenantCode(tenantCode);
                this.saveConttitleModel(cmsConttitle);
            } else {
                Integer conttitleId = oldCmsConttitle.getConttitleId();
                try {
                    BeanUtils.copyAllPropertys((Object)oldCmsConttitle, (Object)cmsConttitle);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                oldCmsConttitle.setTenantCode(tenantCode);
                oldCmsConttitle.setConttitleId(conttitleId);
                this.updateConttitleModel(oldCmsConttitle);
            }
            this.saveContlistInit(tenantCode, cmsConttitle.getConttitleCode());
        }
        if (MapUtil.isEmpty(menuOcodeMap)) {
            return;
        }
        for (String key : menuOcodeMap.keySet()) {
            this.updateConttitleTreleaseByCode(tenantCode, key);
        }
    }

    @Override
    public void updateConttitleByConttitleId(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateConttitleByConttitleId.map");
        }
        this.updateConttitleById(map);
    }

    private void updateConttitleById(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistMapper.updateConttitleById(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateConttitleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsConttitleServiceImpl.updateStateConttitleModelByCode.null");
        }
    }

    private void saveContlistInit(String tenantCode, String conttitleCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", "00000000");
        parammap.put("conttitleCode", conttitleCode);
        List<CmsContlist> cmsContlistList = this.queryContlistModelPage(parammap);
        if (ListUtil.isEmpty(cmsContlistList)) {
            return;
        }
        for (CmsContlist cmsContlist : cmsContlistList) {
            CmsContlist oldCmsContlist = this.getContlistByCode(tenantCode, cmsContlist.getContlistCode());
            if (null == oldCmsContlist) {
                cmsContlist.setContlistId(null);
                cmsContlist.setTenantCode(tenantCode);
                this.saveContlistModel(cmsContlist);
                continue;
            }
            Integer contlistId = oldCmsContlist.getContlistId();
            try {
                BeanUtils.copyAllPropertys((Object)oldCmsContlist, (Object)cmsContlist);
            }
            catch (Exception exception) {
                // empty catch block
            }
            oldCmsContlist.setTenantCode(tenantCode);
            oldCmsContlist.setContlistId(contlistId);
            this.updateContlistModel(oldCmsContlist);
        }
    }
}

