/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebUpointsListMapper;
import com.yqbsoft.laser.service.reb.dao.RebUpointsMapper;
import com.yqbsoft.laser.service.reb.domain.RebUpointsDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsListDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsListReDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsReDomain;
import com.yqbsoft.laser.service.reb.model.RebUpoints;
import com.yqbsoft.laser.service.reb.model.RebUpointsList;
import com.yqbsoft.laser.service.reb.service.RebUpointsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebUpointsServiceImpl
extends BaseServiceImpl
implements RebUpointsService {
    private static final String SYS_CODE = "reb.RebUpointsServiceImpl";
    private RebUpointsMapper rebUpointsMapper;
    private RebUpointsListMapper rebUpointsListMapper;

    public void setRebUpointsMapper(RebUpointsMapper rebUpointsMapper) {
        this.rebUpointsMapper = rebUpointsMapper;
    }

    public void setRebUpointsListMapper(RebUpointsListMapper rebUpointsListMapper) {
        this.rebUpointsListMapper = rebUpointsListMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebUpointsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUpoints(RebUpointsDomain rebUpointsDomain) {
        if (null == rebUpointsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebUpointsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUpointsDefault(RebUpoints rebUpoints) {
        if (null == rebUpoints) {
            return;
        }
        if (null == rebUpoints.getDataState()) {
            rebUpoints.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebUpoints.getGmtCreate()) {
            rebUpoints.setGmtCreate(date);
        }
        rebUpoints.setGmtModified(date);
        if (StringUtils.isBlank((String)rebUpoints.getUpointsCode())) {
            rebUpoints.setUpointsCode(this.getNo(null, "RebUpoints", "rebUpoints", rebUpoints.getTenantCode()));
        }
    }

    private int getUpointsMaxCode() {
        int code = 0;
        try {
            return this.rebUpointsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpointsUpdataDefault(RebUpoints rebUpoints) {
        if (null == rebUpoints) {
            return;
        }
        rebUpoints.setGmtModified(this.getSysDate());
    }

    private void saveUpointsModel(RebUpoints rebUpoints) throws ApiException {
        if (null == rebUpoints) {
            return;
        }
        try {
            this.rebUpointsMapper.insert(rebUpoints);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsModel.ex", (Throwable)e);
        }
    }

    private void saveUpointsBatchModel(List<RebUpoints> rebUpointsList) throws ApiException {
        if (null == rebUpointsList || rebUpointsList.isEmpty()) {
            return;
        }
        try {
            this.rebUpointsMapper.insertBatch(rebUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsBatchModel.ex", (Throwable)e);
        }
    }

    private RebUpoints getUpointsModelById(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        try {
            return this.rebUpointsMapper.selectByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsModelById", (Throwable)e);
            return null;
        }
    }

    private RebUpoints getUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebUpointsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.delUpointsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.delUpointsModelByCode.num");
        }
    }

    private void deleteUpointsModel(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.deleteByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.deleteUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.deleteUpointsModel.num");
        }
    }

    private void updateUpointsModel(RebUpoints rebUpoints) throws ApiException {
        if (null == rebUpoints) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.updateByPrimaryKey(rebUpoints);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsModel.num");
        }
    }

    private void updateStateUpointsModel(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upointsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upointsId", upointsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsModel.null");
        }
    }

    private void updateStateUpointsModelByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsModelByCode.null");
        }
    }

    private RebUpoints makeUpoints(RebUpointsDomain rebUpointsDomain, RebUpoints rebUpoints) {
        if (null == rebUpointsDomain) {
            return null;
        }
        if (null == rebUpoints) {
            rebUpoints = new RebUpoints();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebUpoints, (Object)rebUpointsDomain);
            return rebUpoints;
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.makeUpoints", (Throwable)e);
            return null;
        }
    }

    private RebUpointsReDomain makeRebUpointsReDomain(RebUpoints rebUpoints) {
        if (null == rebUpoints) {
            return null;
        }
        RebUpointsReDomain rebUpointsReDomain = new RebUpointsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsReDomain, (Object)rebUpoints);
            return rebUpointsReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.makeRebUpointsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebUpoints> queryUpointsModelPage(Map<String, Object> parammap) {
        try {
            return this.rebUpointsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.queryUpointsModel", (Throwable)e);
            return null;
        }
    }

    private int countUpoints(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebUpointsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.countUpoints", (Throwable)e);
        }
        return i;
    }

    private RebUpoints createRebUpoints(RebUpointsDomain rebUpointsDomain) {
        String msg = this.checkUpoints(rebUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpoints.checkUpoints", msg);
        }
        RebUpoints rebUpoints = this.makeUpoints(rebUpointsDomain, null);
        this.setUpointsDefault(rebUpoints);
        return rebUpoints;
    }

    private String checkUpointsList(RebUpointsListDomain rebUpointsListDomain) {
        if (null == rebUpointsListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebUpointsListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUpointsListDefault(RebUpointsList rebUpointsList) {
        if (null == rebUpointsList) {
            return;
        }
        if (null == rebUpointsList.getDataState()) {
            rebUpointsList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebUpointsList.getGmtCreate()) {
            rebUpointsList.setGmtCreate(date);
        }
        rebUpointsList.setGmtModified(date);
        if (StringUtils.isBlank((String)rebUpointsList.getUpointsListCode())) {
            rebUpointsList.setUpointsListCode(this.getNo(null, "RebUpointsList", "rebUpointsList", rebUpointsList.getTenantCode()));
        }
    }

    private int getUpointsListMaxCode() {
        int code = 0;
        try {
            return this.rebUpointsListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpointsListUpdataDefault(RebUpointsList rebUpointsList) {
        if (null == rebUpointsList) {
            return;
        }
        rebUpointsList.setGmtModified(this.getSysDate());
    }

    private void saveUpointsListModel(RebUpointsList rebUpointsList) throws ApiException {
        if (null == rebUpointsList) {
            return;
        }
        try {
            this.rebUpointsListMapper.insert(rebUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsListModel.ex", (Throwable)e);
        }
    }

    private void saveUpointsListBatchModel(List<RebUpointsList> rebUpointsListList) throws ApiException {
        if (null == rebUpointsListList || rebUpointsListList.isEmpty()) {
            return;
        }
        try {
            this.rebUpointsListMapper.insertBatch(rebUpointsListList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsListBatchModel.ex", (Throwable)e);
        }
    }

    private RebUpointsList getUpointsListModelById(Integer upointsListId) {
        if (null == upointsListId) {
            return null;
        }
        try {
            return this.rebUpointsListMapper.selectByPrimaryKey(upointsListId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsListModelById", (Throwable)e);
            return null;
        }
    }

    private RebUpointsList getUpointsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebUpointsListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUpointsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.delUpointsListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.delUpointsListModelByCode.num");
        }
    }

    private void deleteUpointsListModel(Integer upointsListId) throws ApiException {
        if (null == upointsListId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.deleteByPrimaryKey(upointsListId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.deleteUpointsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.deleteUpointsListModel.num");
        }
    }

    private void updateUpointsListModel(RebUpointsList rebUpointsList) throws ApiException {
        if (null == rebUpointsList) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.updateByPrimaryKey(rebUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsListModel.num");
        }
    }

    private void updateStateUpointsListModel(Integer upointsListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upointsListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upointsListId", upointsListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsListModel.null");
        }
    }

    private void updateStateUpointsListModelByCode(String tenantCode, String upointsListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsListCode", upointsListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsListModelByCode.null");
        }
    }

    private RebUpointsList makeUpointsList(RebUpointsListDomain rebUpointsListDomain, RebUpointsList rebUpointsList) {
        if (null == rebUpointsListDomain) {
            return null;
        }
        if (null == rebUpointsList) {
            rebUpointsList = new RebUpointsList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsList, (Object)rebUpointsListDomain);
            return rebUpointsList;
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.makeUpointsList", (Throwable)e);
            return null;
        }
    }

    private RebUpointsListReDomain makeRebUpointsListReDomain(RebUpointsList rebUpointsList) {
        if (null == rebUpointsList) {
            return null;
        }
        RebUpointsListReDomain rebUpointsListReDomain = new RebUpointsListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsListReDomain, (Object)rebUpointsList);
            return rebUpointsListReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.makeRebUpointsListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebUpointsList> queryUpointsListModelPage(Map<String, Object> parammap) {
        try {
            return this.rebUpointsListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.queryUpointsListModel", (Throwable)e);
            return null;
        }
    }

    private int countUpointsList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebUpointsListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.countUpointsList", (Throwable)e);
        }
        return i;
    }

    private RebUpointsList createRebUpointsList(RebUpointsListDomain rebUpointsListDomain) {
        String msg = this.checkUpointsList(rebUpointsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsList.checkUpointsList", msg);
        }
        RebUpointsList rebUpointsList = this.makeUpointsList(rebUpointsListDomain, null);
        this.setUpointsListDefault(rebUpointsList);
        return rebUpointsList;
    }

    @Override
    public String saveUpoints(RebUpointsDomain rebUpointsDomain) throws ApiException {
        RebUpoints rebUpoints = this.createRebUpoints(rebUpointsDomain);
        this.saveUpointsModel(rebUpoints);
        return rebUpoints.getUpointsCode();
    }

    @Override
    public String saveUpointsBatch(List<RebUpointsDomain> rebUpointsDomainList) throws ApiException {
        if (null == rebUpointsDomainList || rebUpointsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebUpoints> rebUpointsList = new ArrayList<RebUpoints>();
        String code = "";
        for (RebUpointsDomain rebUpointsDomain : rebUpointsDomainList) {
            RebUpoints rebUpoints = this.createRebUpoints(rebUpointsDomain);
            code = rebUpoints.getUpointsCode();
            rebUpointsList.add(rebUpoints);
        }
        this.saveUpointsBatchModel(rebUpointsList);
        return code;
    }

    @Override
    public void updateUpointsState(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.updateStateUpointsModel(upointsId, dataState, oldDataState, map);
    }

    @Override
    public void updateUpointsStateByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUpointsModelByCode(tenantCode, upointsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUpoints(RebUpointsDomain rebUpointsDomain) throws ApiException {
        String msg = this.checkUpoints(rebUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpoints.checkUpoints", msg);
        }
        RebUpoints oldRebUpoints = this.getUpointsModelById(rebUpointsDomain.getUpointsId());
        if (null == oldRebUpoints) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpoints.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebUpoints rebUpoints = this.makeUpoints(rebUpointsDomain, oldRebUpoints);
        this.setUpointsUpdataDefault(rebUpoints);
        this.updateUpointsModel(rebUpoints);
    }

    @Override
    public RebUpoints getUpoints(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        return this.getUpointsModelById(upointsId);
    }

    @Override
    public void deleteUpoints(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.deleteUpointsModel(upointsId);
    }

    @Override
    public QueryResult<RebUpoints> queryUpointsPage(Map<String, Object> map) {
        List<RebUpoints> rebUpointsList = this.queryUpointsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUpoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebUpointsList);
        return queryResult;
    }

    @Override
    public RebUpoints getUpointsByCode(String tenantCode, String upointsCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        return this.getUpointsModelByCode(map);
    }

    @Override
    public void deleteUpointsByCode(String tenantCode, String upointsCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        this.delUpointsModelByCode(map);
    }

    @Override
    public String saveUpointsList(RebUpointsListDomain rebUpointsListDomain) throws ApiException {
        RebUpointsList rebUpointsList = this.createRebUpointsList(rebUpointsListDomain);
        this.saveUpointsListModel(rebUpointsList);
        return rebUpointsList.getUpointsListCode();
    }

    @Override
    public String saveUpointsListBatch(List<RebUpointsListDomain> rebUpointsListDomainList) throws ApiException {
        if (null == rebUpointsListDomainList || rebUpointsListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebUpointsList> rebUpointsListList = new ArrayList<RebUpointsList>();
        String code = "";
        for (RebUpointsListDomain rebUpointsListDomain : rebUpointsListDomainList) {
            RebUpointsList rebUpointsList = this.createRebUpointsList(rebUpointsListDomain);
            code = rebUpointsList.getUpointsListCode();
            rebUpointsListList.add(rebUpointsList);
        }
        this.saveUpointsListBatchModel(rebUpointsListList);
        return code;
    }

    @Override
    public void updateUpointsListState(Integer upointsListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upointsListId) {
            return;
        }
        this.updateStateUpointsListModel(upointsListId, dataState, oldDataState, map);
    }

    @Override
    public void updateUpointsListStateByCode(String tenantCode, String upointsListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUpointsListModelByCode(tenantCode, upointsListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUpointsList(RebUpointsListDomain rebUpointsListDomain) throws ApiException {
        String msg = this.checkUpointsList(rebUpointsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsList.checkUpointsList", msg);
        }
        RebUpointsList oldRebUpointsList = this.getUpointsListModelById(rebUpointsListDomain.getUpointsListId());
        if (null == oldRebUpointsList) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebUpointsList rebUpointsList = this.makeUpointsList(rebUpointsListDomain, oldRebUpointsList);
        this.setUpointsListUpdataDefault(rebUpointsList);
        this.updateUpointsListModel(rebUpointsList);
    }

    @Override
    public RebUpointsList getUpointsList(Integer upointsListId) {
        if (null == upointsListId) {
            return null;
        }
        return this.getUpointsListModelById(upointsListId);
    }

    @Override
    public void deleteUpointsList(Integer upointsListId) throws ApiException {
        if (null == upointsListId) {
            return;
        }
        this.deleteUpointsListModel(upointsListId);
    }

    @Override
    public QueryResult<RebUpointsList> queryUpointsListPage(Map<String, Object> map) {
        List<RebUpointsList> rebUpointsListList = this.queryUpointsListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUpointsList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebUpointsListList);
        return queryResult;
    }

    @Override
    public RebUpointsList getUpointsListByCode(String tenantCode, String upointsListCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsListCode", upointsListCode);
        return this.getUpointsListModelByCode(map);
    }

    @Override
    public void deleteUpointsListByCode(String tenantCode, String upointsListCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsListCode", upointsListCode);
        this.delUpointsListModelByCode(map);
    }
}

