/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecRecruitGroupMapper;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitGroupDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitGroupReDomain;
import com.yqbsoft.laser.service.recruit.model.RecRecruitGroup;
import com.yqbsoft.laser.service.recruit.service.RecRecruitGroupService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecRecruitGroupServiceImpl
extends BaseServiceImpl
implements RecRecruitGroupService {
    private static final String SYS_CODE = "rec.RecRecruitGroupServiceImpl";
    private RecRecruitGroupMapper recRecruitGroupMapper;

    public void setRecRecruitGroupMapper(RecRecruitGroupMapper recRecruitGroupMapper) {
        this.recRecruitGroupMapper = recRecruitGroupMapper;
    }

    private Date getSysDate() {
        try {
            return this.recRecruitGroupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecruitGroup(RecRecruitGroupDomain recRecruitGroupDomain) {
        if (null == recRecruitGroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recRecruitGroupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRecruitGroupDefault(RecRecruitGroup recRecruitGroup) {
        if (null == recRecruitGroup) {
            return;
        }
        if (null == recRecruitGroup.getDataState()) {
            recRecruitGroup.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recRecruitGroup.getGmtCreate()) {
            recRecruitGroup.setGmtCreate(date);
        }
        recRecruitGroup.setGmtModified(date);
        if (StringUtils.isBlank((String)recRecruitGroup.getRecruitGroupCode())) {
            recRecruitGroup.setRecruitGroupCode(this.createUUIDString());
        }
    }

    private int getRecruitGroupMaxCode() {
        int code = 0;
        try {
            return this.recRecruitGroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.getRecruitGroupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecruitGroupUpdataDefault(RecRecruitGroup recRecruitGroup) {
        if (null == recRecruitGroup) {
            return;
        }
        recRecruitGroup.setGmtModified(this.getSysDate());
    }

    private void saveRecruitGroupModel(RecRecruitGroup recRecruitGroup) throws ApiException {
        if (null == recRecruitGroup) {
            return;
        }
        try {
            Integer result = this.recRecruitGroupMapper.insert(recRecruitGroup);
            this.logger.info("result =    " + result);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.saveRecruitGroupModel.ex", (Throwable)e);
        }
    }

    private void saveRecruitGroupBatchModel(List<RecRecruitGroup> recRecruitGroupList) throws ApiException {
        if (null == recRecruitGroupList || recRecruitGroupList.isEmpty()) {
            return;
        }
        try {
            this.recRecruitGroupMapper.insertBatch(recRecruitGroupList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.saveRecruitGroupBatchModel.ex", (Throwable)e);
        }
    }

    private RecRecruitGroup getRecruitGroupModelById(Integer recruitGroupId) {
        if (null == recruitGroupId) {
            return null;
        }
        try {
            return this.recRecruitGroupMapper.selectByPrimaryKey(recruitGroupId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.getRecruitGroupModelById", (Throwable)e);
            return null;
        }
    }

    private RecRecruitGroup getRecruitGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recRecruitGroupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.getRecruitGroupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRecruitGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitGroupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.delRecruitGroupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.delRecruitGroupModelByCode.num");
        }
    }

    private void deleteRecruitGroupModel(Integer recruitGroupId) throws ApiException {
        if (null == recruitGroupId) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitGroupMapper.deleteByPrimaryKey(recruitGroupId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.deleteRecruitGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.deleteRecruitGroupModel.num");
        }
    }

    private void updateRecruitGroupModel(RecRecruitGroup recRecruitGroup) throws ApiException {
        if (null == recRecruitGroup) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitGroupMapper.updateByPrimaryKey(recRecruitGroup);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.updateRecruitGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.updateRecruitGroupModel.num");
        }
    }

    private void updateStateRecruitGroupModel(Integer recruitGroupId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitGroupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitGroupId", recruitGroupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitGroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.updateStateRecruitGroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.updateStateRecruitGroupModel.null");
        }
    }

    private void updateStateRecruitGroupModelByCode(String tenantCode, String recruitGroupCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitGroupCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitGroupCode", recruitGroupCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitGroupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.updateStateRecruitGroupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.updateStateRecruitGroupModelByCode.null");
        }
    }

    private RecRecruitGroup makeRecruitGroup(RecRecruitGroupDomain recRecruitGroupDomain, RecRecruitGroup recRecruitGroup) {
        if (null == recRecruitGroupDomain) {
            return null;
        }
        if (null == recRecruitGroup) {
            recRecruitGroup = new RecRecruitGroup();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)recRecruitGroup, (Object)recRecruitGroupDomain);
            return recRecruitGroup;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.makeRecruitGroup", (Throwable)e);
            return null;
        }
    }

    private RecRecruitGroupReDomain makeRecRecruitGroupReDomain(RecRecruitGroup recRecruitGroup) {
        if (null == recRecruitGroup) {
            return null;
        }
        RecRecruitGroupReDomain recRecruitGroupReDomain = new RecRecruitGroupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitGroupReDomain, (Object)recRecruitGroup);
            return recRecruitGroupReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.makeRecRecruitGroupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruitGroup> queryRecruitGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.recRecruitGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.queryRecruitGroupModel", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruitGroup> findRecruitGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.recRecruitGroupMapper.queryOr(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.queryRecruitGroupModel", (Throwable)e);
            return null;
        }
    }

    private int countRecruitGroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitGroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.countRecruitGroup", (Throwable)e);
        }
        return i;
    }

    private int countRecruitGroupOr(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitGroupMapper.countOr(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitGroupServiceImpl.countRecruitGroup", (Throwable)e);
        }
        return i;
    }

    private RecRecruitGroup createRecRecruitGroup(RecRecruitGroupDomain recRecruitGroupDomain) {
        String msg = this.checkRecruitGroup(recRecruitGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.saveRecruitGroup.checkRecruitGroup", msg);
        }
        RecRecruitGroup recRecruitGroup = this.makeRecruitGroup(recRecruitGroupDomain, null);
        this.setRecruitGroupDefault(recRecruitGroup);
        return recRecruitGroup;
    }

    @Override
    public String saveRecruitGroup(RecRecruitGroupDomain recRecruitGroupDomain) throws ApiException {
        RecRecruitGroup recRecruitGroup = this.createRecRecruitGroup(recRecruitGroupDomain);
        this.saveRecruitGroupModel(recRecruitGroup);
        return recRecruitGroup.getRecruitGroupCode();
    }

    @Override
    public String saveRecruitGroupBatch(List<RecRecruitGroupDomain> recRecruitGroupDomainList) throws ApiException {
        if (null == recRecruitGroupDomainList || recRecruitGroupDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecRecruitGroup> recRecruitGroupList = new ArrayList<RecRecruitGroup>();
        String code = "";
        for (RecRecruitGroupDomain recRecruitGroupDomain : recRecruitGroupDomainList) {
            RecRecruitGroup recRecruitGroup = this.createRecRecruitGroup(recRecruitGroupDomain);
            code = recRecruitGroup.getRecruitGroupCode();
            recRecruitGroupList.add(recRecruitGroup);
        }
        this.saveRecruitGroupBatchModel(recRecruitGroupList);
        return code;
    }

    @Override
    public void updateRecruitGroupState(Integer recruitGroupId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitGroupId) {
            return;
        }
        this.updateStateRecruitGroupModel(recruitGroupId, dataState, oldDataState, map);
    }

    @Override
    public void updateRecruitGroupStateByCode(String tenantCode, String recruitGroupCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitGroupCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRecruitGroupModelByCode(tenantCode, recruitGroupCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRecruitGroup(RecRecruitGroupDomain recRecruitGroupDomain) throws ApiException {
        String msg = this.checkRecruitGroup(recRecruitGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.updateRecruitGroup.checkRecruitGroup", msg);
        }
        RecRecruitGroup oldRecRecruitGroup = this.getRecruitGroupModelById(recRecruitGroupDomain.getRecruitGroupId());
        if (null == oldRecRecruitGroup) {
            throw new ApiException("rec.RecRecruitGroupServiceImpl.updateRecruitGroup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecRecruitGroup recRecruitGroup = this.makeRecruitGroup(recRecruitGroupDomain, oldRecRecruitGroup);
        this.setRecruitGroupUpdataDefault(recRecruitGroup);
        this.updateRecruitGroupModel(recRecruitGroup);
    }

    @Override
    public RecRecruitGroup getRecruitGroup(Integer recruitGroupId) {
        if (null == recruitGroupId) {
            return null;
        }
        return this.getRecruitGroupModelById(recruitGroupId);
    }

    @Override
    public void deleteRecruitGroup(Integer recruitGroupId) throws ApiException {
        if (null == recruitGroupId) {
            return;
        }
        this.deleteRecruitGroupModel(recruitGroupId);
    }

    @Override
    public QueryResult<RecRecruitGroup> queryRecruitGroupPage(Map<String, Object> map) {
        List<RecRecruitGroup> recRecruitGroupList = this.queryRecruitGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecruitGroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitGroupList);
        return queryResult;
    }

    @Override
    public QueryResult<RecRecruitGroup> findRecruitGroupPage(Map<String, Object> map) {
        List<RecRecruitGroup> recRecruitGroupList = this.findRecruitGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecruitGroupOr(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitGroupList);
        return queryResult;
    }

    @Override
    public RecRecruitGroup getRecruitGroupByCode(String tenantCode, String recruitGroupCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitGroupCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitGroupCode", recruitGroupCode);
        return this.getRecruitGroupModelByCode(map);
    }

    @Override
    public void deleteRecruitGroupByCode(String tenantCode, String recruitGroupCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitGroupCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitGroupCode", recruitGroupCode);
        this.delRecruitGroupModelByCode(map);
    }
}

