/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecRecruitTeamMapper;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitPersonnelDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitPersonnelReDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitTeamDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitTeamReDomain;
import com.yqbsoft.laser.service.recruit.model.RecRecruitPersonnel;
import com.yqbsoft.laser.service.recruit.model.RecRecruitTeam;
import com.yqbsoft.laser.service.recruit.service.RecRecruitPersonnelService;
import com.yqbsoft.laser.service.recruit.service.RecRecruitTeamService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecRecruitTeamServiceImpl
extends BaseServiceImpl
implements RecRecruitTeamService {
    private static final String SYS_CODE = "rec.RecRecruitTeamServiceImpl";
    private RecRecruitTeamMapper recRecruitTeamMapper;
    private RecRecruitPersonnelService recRecruitPersonnelService;

    public void setRecRecruitTeamMapper(RecRecruitTeamMapper recRecruitTeamMapper) {
        this.recRecruitTeamMapper = recRecruitTeamMapper;
    }

    public RecRecruitPersonnelService getRecRecruitPersonnelService() {
        return this.recRecruitPersonnelService;
    }

    public void setRecRecruitPersonnelService(RecRecruitPersonnelService recRecruitPersonnelService) {
        this.recRecruitPersonnelService = recRecruitPersonnelService;
    }

    private Date getSysDate() {
        try {
            return this.recRecruitTeamMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecRecruitTeam(RecRecruitTeamDomain recRecruitTeamDomain) {
        if (null == recRecruitTeamDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recRecruitTeamDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRecRecruitTeamDefault(RecRecruitTeam recRecruitTeam) {
        if (null == recRecruitTeam) {
            return;
        }
        if (null == recRecruitTeam.getDataState()) {
            recRecruitTeam.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recRecruitTeam.getGmtCreate()) {
            recRecruitTeam.setGmtCreate(date);
        }
        recRecruitTeam.setGmtModified(date);
        if (StringUtils.isBlank((String)recRecruitTeam.getRecruitTeamCode())) {
            recRecruitTeam.setRecruitTeamCode(this.getNo(null, "RecRecruitTeam", "recRecruitTeam", recRecruitTeam.getTenantCode()));
        }
    }

    private int getRecRecruitTeamMaxCode() {
        int code = 0;
        try {
            return this.recRecruitTeamMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.getRecRecruitTeamMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecRecruitTeamUpdataDefault(RecRecruitTeam recRecruitTeam) {
        if (null == recRecruitTeam) {
            return;
        }
        recRecruitTeam.setGmtModified(this.getSysDate());
    }

    private void saveRecRecruitTeamModel(RecRecruitTeam recRecruitTeam) throws ApiException {
        if (null == recRecruitTeam) {
            return;
        }
        try {
            this.recRecruitTeamMapper.insert(recRecruitTeam);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.saveRecRecruitTeamModel.ex", (Throwable)e);
        }
    }

    private void saveRecRecruitTeamBatchModel(List<RecRecruitTeam> recRecruitTeamList) throws ApiException {
        if (null == recRecruitTeamList || recRecruitTeamList.isEmpty()) {
            return;
        }
        try {
            this.recRecruitTeamMapper.insertBatch(recRecruitTeamList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.saveRecRecruitTeamBatchModel.ex", (Throwable)e);
        }
    }

    private RecRecruitTeam getRecRecruitTeamModelById(Integer recruitTeamId) {
        if (null == recruitTeamId) {
            return null;
        }
        try {
            return this.recRecruitTeamMapper.selectByPrimaryKey(recruitTeamId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.getRecRecruitTeamModelById", (Throwable)e);
            return null;
        }
    }

    private RecRecruitTeam getRecRecruitTeamModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recRecruitTeamMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.getRecRecruitTeamModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRecRecruitTeamModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitTeamMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.delRecRecruitTeamModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.delRecRecruitTeamModelByCode.num");
        }
    }

    private void deleteRecRecruitTeamModel(Integer recruitTeamId) throws ApiException {
        if (null == recruitTeamId) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitTeamMapper.deleteByPrimaryKey(recruitTeamId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.deleteRecRecruitTeamModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.deleteRecRecruitTeamModel.num");
        }
    }

    private void updateRecRecruitTeamModel(RecRecruitTeam recRecruitTeam) throws ApiException {
        if (null == recRecruitTeam) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitTeamMapper.updateByPrimaryKey(recRecruitTeam);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.updateRecRecruitTeamModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.updateRecRecruitTeamModel.num");
        }
    }

    private void updateStateRecRecruitTeamModel(Integer recruitTeamId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitTeamId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitTeamId", recruitTeamId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitTeamMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.updateStateRecRecruitTeamModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.updateStateRecRecruitTeamModel.null");
        }
    }

    private void updateStateRecRecruitTeamModelByCode(String tenantCode, String recruitTeamCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitTeamCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitTeamCode", recruitTeamCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitTeamMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.updateStateRecRecruitTeamModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.updateStateRecRecruitTeamModelByCode.null");
        }
    }

    private RecRecruitTeam makeRecRecruitTeam(RecRecruitTeamDomain recRecruitTeamDomain, RecRecruitTeam recRecruitTeam) {
        if (null == recRecruitTeamDomain) {
            return null;
        }
        if (null == recRecruitTeam) {
            recRecruitTeam = new RecRecruitTeam();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)recRecruitTeam, (Object)recRecruitTeamDomain);
            return recRecruitTeam;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.makeRecRecruitTeam", (Throwable)e);
            return null;
        }
    }

    private RecRecruitTeamReDomain makeRecRecruitTeamReDomain(RecRecruitTeam recRecruitTeam) {
        if (null == recRecruitTeam) {
            return null;
        }
        RecRecruitTeamReDomain recRecruitTeamReDomain = new RecRecruitTeamReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitTeamReDomain, (Object)recRecruitTeam);
            return recRecruitTeamReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.makeRecRecruitTeamReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruitTeam> queryRecRecruitTeamModelPage(Map<String, Object> parammap) {
        try {
            return this.recRecruitTeamMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.queryRecRecruitTeamModel", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruitTeam> findRecRecruitTeamModelPage(Map<String, Object> parammap) {
        try {
            return this.recRecruitTeamMapper.queryOr(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.queryRecRecruitTeamModel", (Throwable)e);
            return null;
        }
    }

    private int countRecRecruitTeam(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitTeamMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.countRecRecruitTeam", (Throwable)e);
        }
        return i;
    }

    private int countRecRecruitTeamOr(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitTeamMapper.countOr(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitTeamServiceImpl.countRecRecruitTeam", (Throwable)e);
        }
        return i;
    }

    private RecRecruitTeam createRecRecruitTeam(RecRecruitTeamDomain recRecruitTeamDomain) {
        String msg = this.checkRecRecruitTeam(recRecruitTeamDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.saveRecRecruitTeam.checkRecRecruitTeam", msg);
        }
        RecRecruitTeam recRecruitTeam = this.makeRecRecruitTeam(recRecruitTeamDomain, null);
        this.setRecRecruitTeamDefault(recRecruitTeam);
        return recRecruitTeam;
    }

    @Override
    public String saveRecRecruitTeam(RecRecruitTeamDomain recRecruitTeamDomain) throws ApiException {
        RecRecruitTeam recRecruitTeam = this.createRecRecruitTeam(recRecruitTeamDomain);
        this.saveRecRecruitTeamModel(recRecruitTeam);
        String recruitTeamCode = recRecruitTeam.getRecruitTeamCode();
        if (ListUtil.isNotEmpty(recRecruitTeamDomain.getRecRecruitPersonnelDomainList())) {
            for (RecRecruitPersonnelDomain recRecruitPersonnelDomain : recRecruitTeamDomain.getRecRecruitPersonnelDomainList()) {
                recRecruitPersonnelDomain.setRecruitCode(recruitTeamCode);
                recRecruitPersonnelDomain.setTenantCode(recRecruitTeam.getTenantCode());
                recRecruitPersonnelDomain.setMemberCode(recRecruitTeam.getMemberCode());
                recRecruitPersonnelDomain.setMemberName(recRecruitTeam.getMemberName());
            }
            this.recRecruitPersonnelService.saveRecRecruitPersonnelBatch(recRecruitTeamDomain.getRecRecruitPersonnelDomainList());
        }
        return recruitTeamCode;
    }

    @Override
    public String saveRecRecruitTeamBatch(List<RecRecruitTeamDomain> recRecruitTeamDomainList) throws ApiException {
        if (null == recRecruitTeamDomainList || recRecruitTeamDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecRecruitTeam> recRecruitTeamList = new ArrayList<RecRecruitTeam>();
        String code = "";
        for (RecRecruitTeamDomain recRecruitTeamDomain : recRecruitTeamDomainList) {
            RecRecruitTeam recRecruitTeam = this.createRecRecruitTeam(recRecruitTeamDomain);
            code = recRecruitTeam.getRecruitTeamCode();
            recRecruitTeamList.add(recRecruitTeam);
        }
        this.saveRecRecruitTeamBatchModel(recRecruitTeamList);
        return code;
    }

    @Override
    public void updateRecRecruitTeamState(Integer recruitTeamId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitTeamId) {
            return;
        }
        this.updateStateRecRecruitTeamModel(recruitTeamId, dataState, oldDataState, map);
    }

    @Override
    public void updateRecRecruitTeamStateByCode(String tenantCode, String recruitTeamCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitTeamCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRecRecruitTeamModelByCode(tenantCode, recruitTeamCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRecRecruitTeam(RecRecruitTeamDomain recRecruitTeamDomain) throws ApiException {
        String msg = this.checkRecRecruitTeam(recRecruitTeamDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.updateRecRecruitTeam.checkRecRecruitTeam", msg);
        }
        RecRecruitTeam oldRecRecruitTeam = this.getRecRecruitTeamModelById(recRecruitTeamDomain.getRecruitTeamId());
        if (null == oldRecRecruitTeam) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.updateRecRecruitTeam.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecRecruitTeam recRecruitTeam = this.makeRecRecruitTeam(recRecruitTeamDomain, oldRecRecruitTeam);
        this.setRecRecruitTeamUpdataDefault(recRecruitTeam);
        this.updateRecRecruitTeamModel(recRecruitTeam);
        if (ListUtil.isNotEmpty(recRecruitTeamDomain.getRecRecruitPersonnelDomainList())) {
            this.recRecruitPersonnelService.deleteRecRecruitPersonnelByRCode(recRecruitTeam.getTenantCode(), recRecruitTeam.getRecruitTeamCode());
            for (RecRecruitPersonnelDomain recRecruitPersonnelDomain : recRecruitTeamDomain.getRecRecruitPersonnelDomainList()) {
                recRecruitPersonnelDomain.setRecruitCode(recRecruitTeam.getRecruitTeamCode());
                recRecruitPersonnelDomain.setTenantCode(recRecruitTeam.getTenantCode());
                recRecruitPersonnelDomain.setMemberCode(recRecruitTeam.getMemberCode());
                recRecruitPersonnelDomain.setMemberName(recRecruitTeam.getMemberName());
            }
            this.recRecruitPersonnelService.saveRecRecruitPersonnelBatch(recRecruitTeamDomain.getRecRecruitPersonnelDomainList());
        }
    }

    @Override
    public RecRecruitTeam getRecRecruitTeam(Integer recruitTeamId) {
        if (null == recruitTeamId) {
            return null;
        }
        RecRecruitTeam recRecruitTeamModelById = this.getRecRecruitTeamModelById(recruitTeamId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", recRecruitTeamModelById.getTenantCode());
        map.put("recruitCode", recRecruitTeamModelById.getRecruitTeamCode());
        QueryResult<RecRecruitPersonnel> recRecruitPersonnelQueryResult = this.recRecruitPersonnelService.queryRecRecruitPersonnelPage(map);
        if (ListUtil.isNotEmpty((Collection)recRecruitPersonnelQueryResult.getList())) {
            ArrayList<RecRecruitPersonnelReDomain> recRecruitPersonnelReDomainList = new ArrayList<RecRecruitPersonnelReDomain>();
            for (RecRecruitPersonnel recRecruitPersonnel : recRecruitPersonnelQueryResult.getList()) {
                RecRecruitPersonnelReDomain recRecruitPersonnelReDomain = new RecRecruitPersonnelReDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)recRecruitPersonnelReDomain, (Object)recRecruitPersonnel);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                recRecruitPersonnelReDomainList.add(recRecruitPersonnelReDomain);
            }
            recRecruitTeamModelById.setRecRecruitPersonnelReDomainList(recRecruitPersonnelReDomainList);
        }
        return recRecruitTeamModelById;
    }

    @Override
    public void deleteRecRecruitTeam(Integer recruitTeamId) throws ApiException {
        if (null == recruitTeamId) {
            return;
        }
        RecRecruitTeam oldRecRecruitTeam = this.getRecRecruitTeamModelById(recruitTeamId);
        if (null == oldRecRecruitTeam) {
            throw new ApiException("rec.RecRecruitTeamServiceImpl.updateRecRecruitTeam.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.recRecruitPersonnelService.deleteRecRecruitPersonnelByRCode(oldRecRecruitTeam.getTenantCode(), oldRecRecruitTeam.getRecruitTeamCode());
        this.deleteRecRecruitTeamModel(recruitTeamId);
    }

    @Override
    public QueryResult<RecRecruitTeam> queryRecRecruitTeamPage(Map<String, Object> map) {
        List<RecRecruitTeam> recRecruitTeamList = this.queryRecRecruitTeamModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecRecruitTeam(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitTeamList);
        return queryResult;
    }

    @Override
    public QueryResult<RecRecruitTeam> findRecRecruitTeamPage(Map<String, Object> map) {
        List<RecRecruitTeam> recRecruitTeamList = this.findRecRecruitTeamModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecRecruitTeamOr(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitTeamList);
        return queryResult;
    }

    @Override
    public RecRecruitTeam getRecRecruitTeamByCode(String tenantCode, String recruitTeamCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitTeamCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitTeamCode", recruitTeamCode);
        return this.getRecRecruitTeamModelByCode(map);
    }

    @Override
    public void deleteRecRecruitTeamByCode(String tenantCode, String recruitTeamCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitTeamCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitTeamCode", recruitTeamCode);
        this.delRecRecruitTeamModelByCode(map);
    }
}

