/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecRecruitFileMapper;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitFileDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitFileReDomain;
import com.yqbsoft.laser.service.recruit.model.RecRecruitFile;
import com.yqbsoft.laser.service.recruit.service.RecRecruitFileService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecRecruitFileServiceImpl
extends BaseServiceImpl
implements RecRecruitFileService {
    private static final String SYS_CODE = "rec.RecRecruitFileServiceImpl";
    private RecRecruitFileMapper recRecruitFileMapper;

    public void setRecRecruitFileMapper(RecRecruitFileMapper recRecruitFileMapper) {
        this.recRecruitFileMapper = recRecruitFileMapper;
    }

    private Date getSysDate() {
        try {
            return this.recRecruitFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitFileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecruitFile(RecRecruitFileDomain recRecruitFileDomain) {
        if (null == recRecruitFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recRecruitFileDomain.getRecruitCode())) {
            msg = msg + "RecruitCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)recRecruitFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRecruitFileDefault(RecRecruitFile recRecruitFile) {
        if (null == recRecruitFile) {
            return;
        }
        if (null == recRecruitFile.getDataState()) {
            recRecruitFile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recRecruitFile.getGmtCreate()) {
            recRecruitFile.setGmtCreate(date);
        }
        recRecruitFile.setGmtModified(date);
        if (StringUtils.isBlank((String)recRecruitFile.getRecruitFilecode())) {
            recRecruitFile.setRecruitFilecode(this.createUUIDString());
        }
    }

    private int getRecruitFileMaxCode() {
        int code = 0;
        try {
            return this.recRecruitFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitFileServiceImpl.getRecruitFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecruitFileUpdataDefault(RecRecruitFile recRecruitFile) {
        if (null == recRecruitFile) {
            return;
        }
        recRecruitFile.setGmtModified(this.getSysDate());
    }

    private void saveRecruitFileModel(RecRecruitFile recRecruitFile) throws ApiException {
        if (null == recRecruitFile) {
            return;
        }
        try {
            this.recRecruitFileMapper.insert(recRecruitFile);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.saveRecruitFileModel.ex", (Throwable)e);
        }
    }

    private void saveRecruitFileBatchModel(List<RecRecruitFile> recRecruitFileList) throws ApiException {
        if (null == recRecruitFileList || recRecruitFileList.isEmpty()) {
            return;
        }
        try {
            this.recRecruitFileMapper.insertBatch(recRecruitFileList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.saveRecruitFileBatchModel.ex", (Throwable)e);
        }
    }

    private RecRecruitFile getRecruitFileModelById(Integer recruitFileId) {
        if (null == recruitFileId) {
            return null;
        }
        try {
            return this.recRecruitFileMapper.selectByPrimaryKey(recruitFileId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitFileServiceImpl.getRecruitFileModelById", (Throwable)e);
            return null;
        }
    }

    private RecRecruitFile getRecruitFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recRecruitFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitFileServiceImpl.getRecruitFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRecruitFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.delRecruitFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.delRecruitFileModelByCode.num");
        }
    }

    private void deleteRecruitFileModelByRecruitCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitFileMapper.delByRecruitCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.deleteRecruitFileModelByRecruitCode.ex", (Throwable)e);
        }
    }

    private void deleteRecruitFileModel(Integer recruitFileId) throws ApiException {
        if (null == recruitFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitFileMapper.deleteByPrimaryKey(recruitFileId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.deleteRecruitFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.deleteRecruitFileModel.num");
        }
    }

    private void updateRecruitFileModel(RecRecruitFile recRecruitFile) throws ApiException {
        if (null == recRecruitFile) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitFileMapper.updateByPrimaryKey(recRecruitFile);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.updateRecruitFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.updateRecruitFileModel.num");
        }
    }

    private void updateStateRecruitFileModel(Integer recruitFileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitFileId", recruitFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.updateStateRecruitFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.updateStateRecruitFileModel.null");
        }
    }

    private void updateStateRecruitFileModelByCode(String tenantCode, String recruitFilecode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitFilecode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitFilecode", recruitFilecode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.updateStateRecruitFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.updateStateRecruitFileModelByCode.null");
        }
    }

    private RecRecruitFile makeRecruitFile(RecRecruitFileDomain recRecruitFileDomain, RecRecruitFile recRecruitFile) {
        if (null == recRecruitFileDomain) {
            return null;
        }
        if (null == recRecruitFile) {
            recRecruitFile = new RecRecruitFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitFile, (Object)recRecruitFileDomain);
            return recRecruitFile;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitFileServiceImpl.makeRecruitFile", (Throwable)e);
            return null;
        }
    }

    private RecRecruitFileReDomain makeRecRecruitFileReDomain(RecRecruitFile recRecruitFile) {
        if (null == recRecruitFile) {
            return null;
        }
        RecRecruitFileReDomain recRecruitFileReDomain = new RecRecruitFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitFileReDomain, (Object)recRecruitFile);
            return recRecruitFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitFileServiceImpl.makeRecRecruitFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruitFile> queryRecruitFileModelPage(Map<String, Object> parammap) {
        try {
            return this.recRecruitFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitFileServiceImpl.queryRecruitFileModel", (Throwable)e);
            return null;
        }
    }

    private int countRecruitFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitFileServiceImpl.countRecruitFile", (Throwable)e);
        }
        return i;
    }

    private RecRecruitFile createRecRecruitFile(RecRecruitFileDomain recRecruitFileDomain) {
        String msg = this.checkRecruitFile(recRecruitFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.saveRecruitFile.checkRecruitFile", msg);
        }
        RecRecruitFile recRecruitFile = this.makeRecruitFile(recRecruitFileDomain, null);
        this.setRecruitFileDefault(recRecruitFile);
        return recRecruitFile;
    }

    @Override
    public String saveRecruitFile(RecRecruitFileDomain recRecruitFileDomain) throws ApiException {
        RecRecruitFile recRecruitFile = this.createRecRecruitFile(recRecruitFileDomain);
        this.saveRecruitFileModel(recRecruitFile);
        return recRecruitFile.getRecruitFilecode();
    }

    @Override
    public String saveRecruitFileBatch(List<RecRecruitFileDomain> recRecruitFileDomainList) throws ApiException {
        if (null == recRecruitFileDomainList || recRecruitFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecRecruitFile> recRecruitFileList = new ArrayList<RecRecruitFile>();
        String code = "";
        for (RecRecruitFileDomain recRecruitFileDomain : recRecruitFileDomainList) {
            RecRecruitFile recRecruitFile = this.createRecRecruitFile(recRecruitFileDomain);
            code = recRecruitFile.getRecruitFilecode();
            recRecruitFileList.add(recRecruitFile);
        }
        this.saveRecruitFileBatchModel(recRecruitFileList);
        return code;
    }

    @Override
    public void updateRecruitFileState(Integer recruitFileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitFileId) {
            return;
        }
        this.updateStateRecruitFileModel(recruitFileId, dataState, oldDataState, map);
    }

    @Override
    public void updateRecruitFileStateByCode(String tenantCode, String recruitFilecode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitFilecode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRecruitFileModelByCode(tenantCode, recruitFilecode, dataState, oldDataState, map);
    }

    @Override
    public void updateRecruitFile(RecRecruitFileDomain recRecruitFileDomain) throws ApiException {
        String msg = this.checkRecruitFile(recRecruitFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.updateRecruitFile.checkRecruitFile", msg);
        }
        RecRecruitFile oldRecRecruitFile = this.getRecruitFileModelById(recRecruitFileDomain.getRecruitFileId());
        if (null == oldRecRecruitFile) {
            throw new ApiException("rec.RecRecruitFileServiceImpl.updateRecruitFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecRecruitFile recRecruitFile = this.makeRecruitFile(recRecruitFileDomain, oldRecRecruitFile);
        this.setRecruitFileUpdataDefault(recRecruitFile);
        this.updateRecruitFileModel(recRecruitFile);
    }

    @Override
    public RecRecruitFile getRecruitFile(Integer recruitFileId) {
        if (null == recruitFileId) {
            return null;
        }
        return this.getRecruitFileModelById(recruitFileId);
    }

    @Override
    public void deleteRecruitFile(Integer recruitFileId) throws ApiException {
        if (null == recruitFileId) {
            return;
        }
        this.deleteRecruitFileModel(recruitFileId);
    }

    @Override
    public QueryResult<RecRecruitFile> queryRecruitFilePage(Map<String, Object> map) {
        List<RecRecruitFile> recRecruitFileList = this.queryRecruitFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecruitFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitFileList);
        return queryResult;
    }

    @Override
    public RecRecruitFile getRecruitFileByCode(String tenantCode, String recruitFilecode) throws ApiException {
        if (StringUtils.isBlank((String)recruitFilecode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitFilecode", recruitFilecode);
        return this.getRecruitFileModelByCode(map);
    }

    @Override
    public void deleteRecruitFileByCode(String tenantCode, String recruitFilecode) throws ApiException {
        if (StringUtils.isBlank((String)recruitFilecode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitFilecode", recruitFilecode);
        this.delRecruitFileModelByCode(map);
    }

    @Override
    public void deleteRecruitFileByRecruitCode(String tenantCode, String recruitCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitCode", recruitCode);
        this.deleteRecruitFileModelByRecruitCode(map);
    }
}

