/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecSupplierMapper;
import com.yqbsoft.laser.service.recruit.domain.RecSupplierDomain;
import com.yqbsoft.laser.service.recruit.domain.RecSupplierReDomain;
import com.yqbsoft.laser.service.recruit.model.RecSupplier;
import com.yqbsoft.laser.service.recruit.service.RecSupplierService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecSupplierServiceImpl
extends BaseServiceImpl
implements RecSupplierService {
    private static final String SYS_CODE = "rec.RecSupplierServiceImpl";
    private RecSupplierMapper recSupplierMapper;

    public void setRecSupplierMapper(RecSupplierMapper recSupplierMapper) {
        this.recSupplierMapper = recSupplierMapper;
    }

    private Date getSysDate() {
        try {
            return this.recSupplierMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSupplier(RecSupplierDomain recSupplierDomain) {
        if (null == recSupplierDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recSupplierDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSupplierDefault(RecSupplier recSupplier) {
        if (null == recSupplier) {
            return;
        }
        if (null == recSupplier.getDataState()) {
            recSupplier.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recSupplier.getGmtCreate()) {
            recSupplier.setGmtCreate(date);
        }
        recSupplier.setGmtModified(date);
        if (StringUtils.isBlank((String)recSupplier.getSupplierCode())) {
            recSupplier.setSupplierCode(this.getNo(null, "RecSupplier", "recSupplier", recSupplier.getTenantCode()));
        }
    }

    private int getSupplierMaxCode() {
        int code = 0;
        try {
            return this.recSupplierMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierServiceImpl.getSupplierMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSupplierUpdataDefault(RecSupplier recSupplier) {
        if (null == recSupplier) {
            return;
        }
        recSupplier.setGmtModified(this.getSysDate());
    }

    private void saveSupplierModel(RecSupplier recSupplier) throws ApiException {
        if (null == recSupplier) {
            return;
        }
        try {
            this.logger.error("saveSupplierModel", (Object)JsonUtil.buildNormalBinder().toJson((Object)recSupplier));
            this.recSupplierMapper.insert(recSupplier);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.saveSupplierModel.ex", (Throwable)e);
        }
    }

    private void saveSupplierBatchModel(List<RecSupplier> recSupplierList) throws ApiException {
        if (null == recSupplierList || recSupplierList.isEmpty()) {
            return;
        }
        try {
            this.recSupplierMapper.insertBatch(recSupplierList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.saveSupplierBatchModel.ex", (Throwable)e);
        }
    }

    private RecSupplier getSupplierModelById(Integer supplierId) {
        if (null == supplierId) {
            return null;
        }
        try {
            return this.recSupplierMapper.selectByPrimaryKey(supplierId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierServiceImpl.getSupplierModelById", (Throwable)e);
            return null;
        }
    }

    private RecSupplier getSupplierModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recSupplierMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierServiceImpl.getSupplierModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSupplierModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recSupplierMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.delSupplierModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecSupplierServiceImpl.delSupplierModelByCode.num");
        }
    }

    private void deleteSupplierModel(Integer supplierId) throws ApiException {
        if (null == supplierId) {
            return;
        }
        int i = 0;
        try {
            i = this.recSupplierMapper.deleteByPrimaryKey(supplierId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.deleteSupplierModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecSupplierServiceImpl.deleteSupplierModel.num");
        }
    }

    private void updateSupplierModel(RecSupplier recSupplier) throws ApiException {
        if (null == recSupplier) {
            return;
        }
        int i = 0;
        try {
            i = this.recSupplierMapper.updateByPrimaryKey(recSupplier);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateSupplierModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateSupplierModel.num");
        }
    }

    private void updateStateSupplierModel(Integer supplierId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == supplierId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supplierId", supplierId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recSupplierMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModel.null");
        }
    }

    private void updateBlackStateSupplierModel(Integer supplierId, Integer supplierBlack, Integer oldSupplierBlack, Map<String, Object> expmap) throws ApiException {
        if (null == supplierId || null == supplierBlack) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supplierId", supplierId);
        map.put("supplierBlack", supplierBlack);
        map.put("oldSupplierBlack", oldSupplierBlack);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recSupplierMapper.updateBlackStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModel.null");
        }
    }

    private void updateSupplierSortModel(Integer supplierId, String suppliersortCode, Map<String, Object> expmap) throws ApiException {
        if (null == supplierId) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supplierId", supplierId);
        map.put("suppliersortCode", suppliersortCode);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        this.logger.error("updateSupplierLableModel.map", (Object)((Object)map).toString());
        int i = 0;
        try {
            i = this.recSupplierMapper.updateSupplierSortByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModel.null");
        }
    }

    private void updateSupplierLableModel(Integer supplierId, String supplierlableCode, Map<String, Object> expmap) throws ApiException {
        if (null == supplierId) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supplierId", supplierId);
        map.put("supplierlableCode", supplierlableCode);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        this.logger.error("updateSupplierLableModel.map", (Object)((Object)map).toString());
        int i = 0;
        try {
            i = this.recSupplierMapper.updateSupplierLableByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModel.null");
        }
    }

    private void updateStateSupplierModelByCode(String tenantCode, String supplierCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)supplierCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("supplierCode", supplierCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recSupplierMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateStateSupplierModelByCode.null");
        }
    }

    private RecSupplier makeSupplier(RecSupplierDomain recSupplierDomain, RecSupplier recSupplier) {
        if (null == recSupplierDomain) {
            return null;
        }
        if (null == recSupplier) {
            recSupplier = new RecSupplier();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recSupplier, (Object)recSupplierDomain);
            return recSupplier;
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierServiceImpl.makeSupplier", (Throwable)e);
            return null;
        }
    }

    private RecSupplierReDomain makeRecSupplierReDomain(RecSupplier recSupplier) {
        if (null == recSupplier) {
            return null;
        }
        RecSupplierReDomain recSupplierReDomain = new RecSupplierReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recSupplierReDomain, (Object)recSupplier);
            return recSupplierReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierServiceImpl.makeRecSupplierReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecSupplier> querySupplierModelPage(Map<String, Object> parammap) {
        try {
            return this.recSupplierMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierServiceImpl.querySupplierModel", (Throwable)e);
            return null;
        }
    }

    private int countSupplier(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recSupplierMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierServiceImpl.countSupplier", (Throwable)e);
        }
        return i;
    }

    private RecSupplier createRecSupplier(RecSupplierDomain recSupplierDomain) {
        String msg = this.checkSupplier(recSupplierDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecSupplierServiceImpl.saveSupplier.checkSupplier", msg);
        }
        RecSupplier recSupplier = this.makeSupplier(recSupplierDomain, null);
        this.setSupplierDefault(recSupplier);
        return recSupplier;
    }

    @Override
    public String saveSupplier(RecSupplierDomain recSupplierDomain) throws ApiException {
        RecSupplier recSupplier = this.createRecSupplier(recSupplierDomain);
        this.saveSupplierModel(recSupplier);
        return recSupplier.getSupplierCode();
    }

    @Override
    public String saveSupplierBatch(List<RecSupplierDomain> recSupplierDomainList) throws ApiException {
        if (null == recSupplierDomainList || recSupplierDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecSupplier> recSupplierList = new ArrayList<RecSupplier>();
        String code = "";
        for (RecSupplierDomain recSupplierDomain : recSupplierDomainList) {
            RecSupplier recSupplier = this.createRecSupplier(recSupplierDomain);
            code = recSupplier.getSupplierCode();
            recSupplierList.add(recSupplier);
        }
        this.saveSupplierBatchModel(recSupplierList);
        return code;
    }

    @Override
    public void updateSupplierState(Integer supplierId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == supplierId) {
            return;
        }
        this.updateStateSupplierModel(supplierId, dataState, oldDataState, map);
    }

    @Override
    public void updateSupplierStateByCode(String tenantCode, String supplierCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)supplierCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSupplierModelByCode(tenantCode, supplierCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSupplier(RecSupplierDomain recSupplierDomain) throws ApiException {
        String msg = this.checkSupplier(recSupplierDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateSupplier.checkSupplier", msg);
        }
        RecSupplier oldRecSupplier = this.getSupplierModelById(recSupplierDomain.getSupplierId());
        if (null == oldRecSupplier) {
            throw new ApiException("rec.RecSupplierServiceImpl.updateSupplier.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecSupplier recSupplier = this.makeSupplier(recSupplierDomain, oldRecSupplier);
        this.setSupplierUpdataDefault(recSupplier);
        this.updateSupplierModel(recSupplier);
    }

    @Override
    public RecSupplier getSupplier(Integer supplierId) {
        if (null == supplierId) {
            return null;
        }
        return this.getSupplierModelById(supplierId);
    }

    @Override
    public void deleteSupplier(Integer supplierId) throws ApiException {
        if (null == supplierId) {
            return;
        }
        this.deleteSupplierModel(supplierId);
    }

    @Override
    public QueryResult<RecSupplier> querySupplierPage(Map<String, Object> map) {
        List<RecSupplier> recSupplierList = this.querySupplierModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        int count = 0;
        if (ListUtil.isNotEmpty(recSupplierList)) {
            count = this.countSupplier(map);
        }
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recSupplierList);
        return queryResult;
    }

    @Override
    public RecSupplier getSupplierByCode(String tenantCode, String supplierCode) throws ApiException {
        if (StringUtils.isBlank((String)supplierCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("supplierCode", supplierCode);
        return this.getSupplierModelByCode(map);
    }

    @Override
    public void deleteSupplierByCode(String tenantCode, String supplierCode) throws ApiException {
        if (StringUtils.isBlank((String)supplierCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("supplierCode", supplierCode);
        this.delSupplierModelByCode(map);
    }

    @Override
    public void updateSupplierBlackState(Integer supplierId, Integer supplierBlack, Integer oldSupplierBlack, Map<String, Object> map) throws ApiException {
        if (null == supplierId) {
            return;
        }
        this.updateBlackStateSupplierModel(supplierId, supplierBlack, oldSupplierBlack, map);
    }

    @Override
    public void updateSupplierLable(Integer supplierId, String supplierlableCode, Map<String, Object> map) throws ApiException {
        this.logger.error("updateSupplierLable.map", (Object)map.toString());
        this.updateSupplierLableModel(supplierId, supplierlableCode, map);
    }

    @Override
    public void updateSupplierSortState(Integer supplierId, String suppliersortCode, Map<String, Object> map) throws ApiException {
        this.logger.error("updateSupplierLable.map", (Object)map.toString());
        this.updateSupplierSortModel(supplierId, suppliersortCode, map);
    }
}

