/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecRecruitPersonnelMapper;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitPersonnelDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitPersonnelReDomain;
import com.yqbsoft.laser.service.recruit.model.RecRecruitPersonnel;
import com.yqbsoft.laser.service.recruit.service.RecRecruitPersonnelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecRecruitPersonnelServiceImpl
extends BaseServiceImpl
implements RecRecruitPersonnelService {
    private static final String SYS_CODE = "rec.RecRecruitPersonnelServiceImpl";
    private RecRecruitPersonnelMapper recRecruitPersonnelMapper;

    public void setRecRecruitPersonnelMapper(RecRecruitPersonnelMapper recRecruitPersonnelMapper) {
        this.recRecruitPersonnelMapper = recRecruitPersonnelMapper;
    }

    private Date getSysDate() {
        try {
            return this.recRecruitPersonnelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitPersonnelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecRecruitPersonnel(RecRecruitPersonnelDomain recRecruitPersonnelDomain) {
        if (null == recRecruitPersonnelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recRecruitPersonnelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRecRecruitPersonnelDefault(RecRecruitPersonnel recRecruitPersonnel) {
        if (null == recRecruitPersonnel) {
            return;
        }
        if (null == recRecruitPersonnel.getDataState()) {
            recRecruitPersonnel.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recRecruitPersonnel.getGmtCreate()) {
            recRecruitPersonnel.setGmtCreate(date);
        }
        recRecruitPersonnel.setGmtModified(date);
        if (StringUtils.isBlank((String)recRecruitPersonnel.getRecruitPersionnelCode())) {
            recRecruitPersonnel.setRecruitPersionnelCode(this.getNo(null, "RecRecruitPersonnel", "recRecruitPersonnel", recRecruitPersonnel.getTenantCode()));
        }
    }

    private int getRecRecruitPersonnelMaxCode() {
        int code = 0;
        try {
            return this.recRecruitPersonnelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitPersonnelServiceImpl.getRecRecruitPersonnelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecRecruitPersonnelUpdataDefault(RecRecruitPersonnel recRecruitPersonnel) {
        if (null == recRecruitPersonnel) {
            return;
        }
        recRecruitPersonnel.setGmtModified(this.getSysDate());
    }

    private void saveRecRecruitPersonnelModel(RecRecruitPersonnel recRecruitPersonnel) throws ApiException {
        if (null == recRecruitPersonnel) {
            return;
        }
        try {
            int n = this.recRecruitPersonnelMapper.insert(recRecruitPersonnel);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.saveRecRecruitPersonnelModel.ex", (Throwable)e);
        }
    }

    private void saveRecRecruitPersonnelBatchModel(List<RecRecruitPersonnel> recRecruitPersonnelList) throws ApiException {
        if (null == recRecruitPersonnelList || recRecruitPersonnelList.isEmpty()) {
            return;
        }
        try {
            this.recRecruitPersonnelMapper.insertBatch(recRecruitPersonnelList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.saveRecRecruitPersonnelBatchModel.ex", (Throwable)e);
        }
    }

    private RecRecruitPersonnel getRecRecruitPersonnelModelById(Integer recruitPersionnelId) {
        if (null == recruitPersionnelId) {
            return null;
        }
        try {
            return this.recRecruitPersonnelMapper.selectByPrimaryKey(recruitPersionnelId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitPersonnelServiceImpl.getRecRecruitPersonnelModelById", (Throwable)e);
            return null;
        }
    }

    private RecRecruitPersonnel getRecRecruitPersonnelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recRecruitPersonnelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitPersonnelServiceImpl.getRecRecruitPersonnelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRecRecruitPersonnelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitPersonnelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.delRecRecruitPersonnelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.delRecRecruitPersonnelModelByCode.num");
        }
    }

    private void deleteRecRecruitPersonnelModel(Integer recruitPersionnelId) throws ApiException {
        if (null == recruitPersionnelId) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitPersonnelMapper.deleteByPrimaryKey(recruitPersionnelId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.deleteRecRecruitPersonnelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.deleteRecRecruitPersonnelModel.num");
        }
    }

    private void updateRecRecruitPersonnelModel(RecRecruitPersonnel recRecruitPersonnel) throws ApiException {
        if (null == recRecruitPersonnel) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitPersonnelMapper.updateByPrimaryKey(recRecruitPersonnel);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.updateRecRecruitPersonnelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.updateRecRecruitPersonnelModel.num");
        }
    }

    private void updateStateRecRecruitPersonnelModel(Integer recruitPersionnelId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitPersionnelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitPersionnelId", recruitPersionnelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitPersonnelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.updateStateRecRecruitPersonnelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.updateStateRecRecruitPersonnelModel.null");
        }
    }

    private void updateStateRecRecruitPersonnelModelByCode(String tenantCode, String recruitPersionnelCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitPersionnelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitPersionnelCode", recruitPersionnelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitPersonnelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.updateStateRecRecruitPersonnelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.updateStateRecRecruitPersonnelModelByCode.null");
        }
    }

    private RecRecruitPersonnel makeRecRecruitPersonnel(RecRecruitPersonnelDomain recRecruitPersonnelDomain, RecRecruitPersonnel recRecruitPersonnel) {
        if (null == recRecruitPersonnelDomain) {
            return null;
        }
        if (null == recRecruitPersonnel) {
            recRecruitPersonnel = new RecRecruitPersonnel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitPersonnel, (Object)recRecruitPersonnelDomain);
            return recRecruitPersonnel;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitPersonnelServiceImpl.makeRecRecruitPersonnel", (Throwable)e);
            return null;
        }
    }

    private RecRecruitPersonnelReDomain makeRecRecruitPersonnelReDomain(RecRecruitPersonnel recRecruitPersonnel) {
        if (null == recRecruitPersonnel) {
            return null;
        }
        RecRecruitPersonnelReDomain recRecruitPersonnelReDomain = new RecRecruitPersonnelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitPersonnelReDomain, (Object)recRecruitPersonnel);
            return recRecruitPersonnelReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitPersonnelServiceImpl.makeRecRecruitPersonnelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruitPersonnel> queryRecRecruitPersonnelModelPage(Map<String, Object> parammap) {
        try {
            return this.recRecruitPersonnelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitPersonnelServiceImpl.queryRecRecruitPersonnelModel", (Throwable)e);
            return null;
        }
    }

    private int countRecRecruitPersonnel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitPersonnelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitPersonnelServiceImpl.countRecRecruitPersonnel", (Throwable)e);
        }
        return i;
    }

    private RecRecruitPersonnel createRecRecruitPersonnel(RecRecruitPersonnelDomain recRecruitPersonnelDomain) {
        String msg = this.checkRecRecruitPersonnel(recRecruitPersonnelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.saveRecRecruitPersonnel.checkRecRecruitPersonnel", msg);
        }
        RecRecruitPersonnel recRecruitPersonnel = this.makeRecRecruitPersonnel(recRecruitPersonnelDomain, null);
        this.setRecRecruitPersonnelDefault(recRecruitPersonnel);
        return recRecruitPersonnel;
    }

    @Override
    public String saveRecRecruitPersonnel(RecRecruitPersonnelDomain recRecruitPersonnelDomain) throws ApiException {
        RecRecruitPersonnel recRecruitPersonnel = this.createRecRecruitPersonnel(recRecruitPersonnelDomain);
        this.saveRecRecruitPersonnelModel(recRecruitPersonnel);
        return recRecruitPersonnel.getRecruitPersionnelCode();
    }

    @Override
    public String saveRecRecruitPersonnelBatch(List<RecRecruitPersonnelDomain> recRecruitPersonnelDomainList) throws ApiException {
        if (null == recRecruitPersonnelDomainList || recRecruitPersonnelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecRecruitPersonnel> recRecruitPersonnelList = new ArrayList<RecRecruitPersonnel>();
        String code = "";
        for (RecRecruitPersonnelDomain recRecruitPersonnelDomain : recRecruitPersonnelDomainList) {
            RecRecruitPersonnel recRecruitPersonnel = this.createRecRecruitPersonnel(recRecruitPersonnelDomain);
            code = recRecruitPersonnel.getRecruitPersionnelCode();
            recRecruitPersonnelList.add(recRecruitPersonnel);
        }
        this.saveRecRecruitPersonnelBatchModel(recRecruitPersonnelList);
        return code;
    }

    @Override
    public void updateRecRecruitPersonnelState(Integer recruitPersionnelId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitPersionnelId) {
            return;
        }
        this.updateStateRecRecruitPersonnelModel(recruitPersionnelId, dataState, oldDataState, map);
    }

    @Override
    public void updateRecRecruitPersonnelStateByCode(String tenantCode, String recruitPersionnelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitPersionnelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRecRecruitPersonnelModelByCode(tenantCode, recruitPersionnelCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRecRecruitPersonnel(RecRecruitPersonnelDomain recRecruitPersonnelDomain) throws ApiException {
        String msg = this.checkRecRecruitPersonnel(recRecruitPersonnelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.updateRecRecruitPersonnel.checkRecRecruitPersonnel", msg);
        }
        RecRecruitPersonnel oldRecRecruitPersonnel = this.getRecRecruitPersonnelModelById(recRecruitPersonnelDomain.getRecruitPersionnelId());
        if (null == oldRecRecruitPersonnel) {
            throw new ApiException("rec.RecRecruitPersonnelServiceImpl.updateRecRecruitPersonnel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecRecruitPersonnel recRecruitPersonnel = this.makeRecRecruitPersonnel(recRecruitPersonnelDomain, oldRecRecruitPersonnel);
        this.setRecRecruitPersonnelUpdataDefault(recRecruitPersonnel);
        this.updateRecRecruitPersonnelModel(recRecruitPersonnel);
    }

    @Override
    public RecRecruitPersonnel getRecRecruitPersonnel(Integer recruitPersionnelId) {
        if (null == recruitPersionnelId) {
            return null;
        }
        return this.getRecRecruitPersonnelModelById(recruitPersionnelId);
    }

    @Override
    public void deleteRecRecruitPersonnel(Integer recruitPersionnelId) throws ApiException {
        if (null == recruitPersionnelId) {
            return;
        }
        this.deleteRecRecruitPersonnelModel(recruitPersionnelId);
    }

    @Override
    public QueryResult<RecRecruitPersonnel> queryRecRecruitPersonnelPage(Map<String, Object> map) {
        List<RecRecruitPersonnel> recRecruitPersonnelList = this.queryRecRecruitPersonnelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecRecruitPersonnel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitPersonnelList);
        return queryResult;
    }

    @Override
    public RecRecruitPersonnel getRecRecruitPersonnelByCode(String tenantCode, String recruitPersionnelCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitPersionnelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitPersionnelCode", recruitPersionnelCode);
        return this.getRecRecruitPersonnelModelByCode(map);
    }

    @Override
    public void deleteRecRecruitPersonnelByCode(String tenantCode, String recruitPersionnelCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitPersionnelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitPersionnelCode", recruitPersionnelCode);
        this.delRecRecruitPersonnelModelByCode(map);
    }
}

