/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecSupplierLableMapper;
import com.yqbsoft.laser.service.recruit.domain.RecSupplierLableDomain;
import com.yqbsoft.laser.service.recruit.domain.RecSupplierLableReDomain;
import com.yqbsoft.laser.service.recruit.model.RecSupplierLable;
import com.yqbsoft.laser.service.recruit.service.RecSupplierLableService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecSupplierLableServiceImpl
extends BaseServiceImpl
implements RecSupplierLableService {
    private static final String SYS_CODE = "rec.RecSupplierLableServiceImpl";
    private RecSupplierLableMapper recSupplierLableMapper;

    public void setRecSupplierLableMapper(RecSupplierLableMapper recSupplierLableMapper) {
        this.recSupplierLableMapper = recSupplierLableMapper;
    }

    private Date getSysDate() {
        try {
            return this.recSupplierLableMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierLableServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSupplierLable(RecSupplierLableDomain recSupplierLableDomain) {
        if (null == recSupplierLableDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recSupplierLableDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSupplierLableDefault(RecSupplierLable recSupplierLable) {
        if (null == recSupplierLable) {
            return;
        }
        if (null == recSupplierLable.getDataState()) {
            recSupplierLable.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recSupplierLable.getGmtCreate()) {
            recSupplierLable.setGmtCreate(date);
        }
        recSupplierLable.setGmtModified(date);
        if (StringUtils.isBlank((String)recSupplierLable.getSupplierlableCode())) {
            recSupplierLable.setSupplierlableCode(this.getNo(null, "RecSupplierLable", "recSupplierLable", recSupplierLable.getTenantCode()));
        }
    }

    private int getSupplierLableMaxCode() {
        int code = 0;
        try {
            return this.recSupplierLableMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierLableServiceImpl.getSupplierLableMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSupplierLableUpdataDefault(RecSupplierLable recSupplierLable) {
        if (null == recSupplierLable) {
            return;
        }
        recSupplierLable.setGmtModified(this.getSysDate());
    }

    private void saveSupplierLableModel(RecSupplierLable recSupplierLable) throws ApiException {
        if (null == recSupplierLable) {
            return;
        }
        try {
            this.recSupplierLableMapper.insert(recSupplierLable);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.saveSupplierLableModel.ex", (Throwable)e);
        }
    }

    private void saveSupplierLableBatchModel(List<RecSupplierLable> recSupplierLableList) throws ApiException {
        if (null == recSupplierLableList || recSupplierLableList.isEmpty()) {
            return;
        }
        try {
            this.recSupplierLableMapper.insertBatch(recSupplierLableList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.saveSupplierLableBatchModel.ex", (Throwable)e);
        }
    }

    private RecSupplierLable getSupplierLableModelById(Integer supplierlableId) {
        if (null == supplierlableId) {
            return null;
        }
        try {
            return this.recSupplierLableMapper.selectByPrimaryKey(supplierlableId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierLableServiceImpl.getSupplierLableModelById", (Throwable)e);
            return null;
        }
    }

    private RecSupplierLable getSupplierLableModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recSupplierLableMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierLableServiceImpl.getSupplierLableModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSupplierLableModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recSupplierLableMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.delSupplierLableModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.delSupplierLableModelByCode.num");
        }
    }

    private void deleteSupplierLableModel(Integer supplierlableId) throws ApiException {
        if (null == supplierlableId) {
            return;
        }
        int i = 0;
        try {
            i = this.recSupplierLableMapper.deleteByPrimaryKey(supplierlableId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.deleteSupplierLableModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.deleteSupplierLableModel.num");
        }
    }

    private void updateSupplierLableModel(RecSupplierLable recSupplierLable) throws ApiException {
        if (null == recSupplierLable) {
            return;
        }
        int i = 0;
        try {
            i = this.recSupplierLableMapper.updateByPrimaryKeySelective(recSupplierLable);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.updateSupplierLableModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.updateSupplierLableModel.num");
        }
    }

    private void updateStateSupplierLableModel(Integer supplierlableId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == supplierlableId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supplierlableId", supplierlableId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recSupplierLableMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.updateStateSupplierLableModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.updateStateSupplierLableModel.null");
        }
    }

    private void updateStateSupplierLableModelByCode(String tenantCode, String supplierlableCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)supplierlableCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("supplierlableCode", supplierlableCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recSupplierLableMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.updateStateSupplierLableModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.updateStateSupplierLableModelByCode.null");
        }
    }

    private RecSupplierLable makeSupplierLable(RecSupplierLableDomain recSupplierLableDomain, RecSupplierLable recSupplierLable) {
        if (null == recSupplierLableDomain) {
            return null;
        }
        if (null == recSupplierLable) {
            recSupplierLable = new RecSupplierLable();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recSupplierLable, (Object)recSupplierLableDomain);
            return recSupplierLable;
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierLableServiceImpl.makeSupplierLable", (Throwable)e);
            return null;
        }
    }

    private RecSupplierLableReDomain makeRecSupplierLableReDomain(RecSupplierLable recSupplierLable) {
        if (null == recSupplierLable) {
            return null;
        }
        RecSupplierLableReDomain recSupplierLableReDomain = new RecSupplierLableReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recSupplierLableReDomain, (Object)recSupplierLable);
            return recSupplierLableReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierLableServiceImpl.makeRecSupplierLableReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecSupplierLable> querySupplierLableModelPage(Map<String, Object> parammap) {
        try {
            return this.recSupplierLableMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierLableServiceImpl.querySupplierLableModel", (Throwable)e);
            return null;
        }
    }

    private int countSupplierLable(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recSupplierLableMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierLableServiceImpl.countSupplierLable", (Throwable)e);
        }
        return i;
    }

    private RecSupplierLable createRecSupplierLable(RecSupplierLableDomain recSupplierLableDomain) {
        String msg = this.checkSupplierLable(recSupplierLableDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.saveSupplierLable.checkSupplierLable", msg);
        }
        RecSupplierLable recSupplierLable = this.makeSupplierLable(recSupplierLableDomain, null);
        this.setSupplierLableDefault(recSupplierLable);
        return recSupplierLable;
    }

    @Override
    public String saveSupplierLable(RecSupplierLableDomain recSupplierLableDomain) throws ApiException {
        RecSupplierLable recSupplierLable = this.createRecSupplierLable(recSupplierLableDomain);
        this.saveSupplierLableModel(recSupplierLable);
        return recSupplierLable.getSupplierlableCode();
    }

    @Override
    public String saveSupplierLableBatch(List<RecSupplierLableDomain> recSupplierLableDomainList) throws ApiException {
        if (null == recSupplierLableDomainList || recSupplierLableDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecSupplierLable> recSupplierLableList = new ArrayList<RecSupplierLable>();
        String code = "";
        for (RecSupplierLableDomain recSupplierLableDomain : recSupplierLableDomainList) {
            RecSupplierLable recSupplierLable = this.createRecSupplierLable(recSupplierLableDomain);
            code = recSupplierLable.getSupplierlableCode();
            recSupplierLableList.add(recSupplierLable);
        }
        this.saveSupplierLableBatchModel(recSupplierLableList);
        return code;
    }

    @Override
    public void updateSupplierLableState(Integer supplierlableId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == supplierlableId) {
            return;
        }
        this.updateStateSupplierLableModel(supplierlableId, dataState, oldDataState, map);
    }

    @Override
    public void updateSupplierLableStateByCode(String tenantCode, String supplierlableCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)supplierlableCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSupplierLableModelByCode(tenantCode, supplierlableCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSupplierLable(RecSupplierLableDomain recSupplierLableDomain) throws ApiException {
        String msg = this.checkSupplierLable(recSupplierLableDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.updateSupplierLable.checkSupplierLable", msg);
        }
        RecSupplierLable oldRecSupplierLable = this.getSupplierLableModelById(recSupplierLableDomain.getSupplierlableId());
        if (null == oldRecSupplierLable) {
            throw new ApiException("rec.RecSupplierLableServiceImpl.updateSupplierLable.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecSupplierLable recSupplierLable = this.makeSupplierLable(recSupplierLableDomain, oldRecSupplierLable);
        this.setSupplierLableUpdataDefault(recSupplierLable);
        this.updateSupplierLableModel(recSupplierLable);
    }

    @Override
    public RecSupplierLable getSupplierLable(Integer supplierlableId) {
        if (null == supplierlableId) {
            return null;
        }
        return this.getSupplierLableModelById(supplierlableId);
    }

    @Override
    public void deleteSupplierLable(Integer supplierlableId) throws ApiException {
        if (null == supplierlableId) {
            return;
        }
        this.deleteSupplierLableModel(supplierlableId);
    }

    @Override
    public QueryResult<RecSupplierLable> querySupplierLablePage(Map<String, Object> map) {
        List<RecSupplierLable> recSupplierLableList = this.querySupplierLableModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        int count = 0;
        if (ListUtil.isNotEmpty(recSupplierLableList)) {
            count = this.countSupplierLable(map);
        }
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recSupplierLableList);
        return queryResult;
    }

    @Override
    public RecSupplierLable getSupplierLableByCode(String tenantCode, String supplierlableCode) throws ApiException {
        if (StringUtils.isBlank((String)supplierlableCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("supplierlableCode", supplierlableCode);
        return this.getSupplierLableModelByCode(map);
    }

    @Override
    public void deleteSupplierLableByCode(String tenantCode, String supplierlableCode) throws ApiException {
        if (StringUtils.isBlank((String)supplierlableCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("supplierlableCode", supplierlableCode);
        this.delSupplierLableModelByCode(map);
    }
}

