/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecSupplierSortMapper;
import com.yqbsoft.laser.service.recruit.domain.RecSupplierSortDomain;
import com.yqbsoft.laser.service.recruit.domain.RecSupplierSortReDomain;
import com.yqbsoft.laser.service.recruit.model.RecSupplierSort;
import com.yqbsoft.laser.service.recruit.service.RecSupplierSortService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecSupplierSortServiceImpl
extends BaseServiceImpl
implements RecSupplierSortService {
    private static final String SYS_CODE = "rec.RecSupplierSortServiceImpl";
    private RecSupplierSortMapper recSupplierSortMapper;

    public void setRecSupplierSortMapper(RecSupplierSortMapper recSupplierSortMapper) {
        this.recSupplierSortMapper = recSupplierSortMapper;
    }

    private Date getSysDate() {
        try {
            return this.recSupplierSortMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierSortServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSupplierSort(RecSupplierSortDomain recSupplierSortDomain) {
        if (null == recSupplierSortDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recSupplierSortDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSupplierSortDefault(RecSupplierSort recSupplierSort) {
        if (null == recSupplierSort) {
            return;
        }
        if (null == recSupplierSort.getDataState()) {
            recSupplierSort.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recSupplierSort.getGmtCreate()) {
            recSupplierSort.setGmtCreate(date);
        }
        recSupplierSort.setGmtModified(date);
        if (StringUtils.isBlank((String)recSupplierSort.getSuppliersortCode())) {
            recSupplierSort.setSuppliersortCode(this.getNo(null, "RecSupplierSort", "recSupplierSort", recSupplierSort.getTenantCode()));
        }
    }

    private int getSupplierSortMaxCode() {
        int code = 0;
        try {
            return this.recSupplierSortMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierSortServiceImpl.getSupplierSortMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSupplierSortUpdataDefault(RecSupplierSort recSupplierSort) {
        if (null == recSupplierSort) {
            return;
        }
        recSupplierSort.setGmtModified(this.getSysDate());
    }

    private void saveSupplierSortModel(RecSupplierSort recSupplierSort) throws ApiException {
        if (null == recSupplierSort) {
            return;
        }
        try {
            this.recSupplierSortMapper.insert(recSupplierSort);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.saveSupplierSortModel.ex", (Throwable)e);
        }
    }

    private void saveSupplierSortBatchModel(List<RecSupplierSort> recSupplierSortList) throws ApiException {
        if (null == recSupplierSortList || recSupplierSortList.isEmpty()) {
            return;
        }
        try {
            this.recSupplierSortMapper.insertBatch(recSupplierSortList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.saveSupplierSortBatchModel.ex", (Throwable)e);
        }
    }

    private RecSupplierSort getSupplierSortModelById(Integer suppliersortId) {
        if (null == suppliersortId) {
            return null;
        }
        try {
            return this.recSupplierSortMapper.selectByPrimaryKey(suppliersortId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierSortServiceImpl.getSupplierSortModelById", (Throwable)e);
            return null;
        }
    }

    private RecSupplierSort getSupplierSortModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recSupplierSortMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierSortServiceImpl.getSupplierSortModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSupplierSortModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recSupplierSortMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.delSupplierSortModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.delSupplierSortModelByCode.num");
        }
    }

    private void deleteSupplierSortModel(Integer suppliersortId) throws ApiException {
        if (null == suppliersortId) {
            return;
        }
        int i = 0;
        try {
            i = this.recSupplierSortMapper.deleteByPrimaryKey(suppliersortId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.deleteSupplierSortModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.deleteSupplierSortModel.num");
        }
    }

    private void updateSupplierSortModel(RecSupplierSort recSupplierSort) throws ApiException {
        if (null == recSupplierSort) {
            return;
        }
        int i = 0;
        try {
            i = this.recSupplierSortMapper.updateByPrimaryKeySelective(recSupplierSort);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.updateSupplierSortModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.updateSupplierSortModel.num");
        }
    }

    private void updateStateSupplierSortModel(Integer suppliersortId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == suppliersortId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("suppliersortId", suppliersortId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recSupplierSortMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.updateStateSupplierSortModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.updateStateSupplierSortModel.null");
        }
    }

    private void updateStateSupplierSortModelByCode(String tenantCode, String suppliersortCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)suppliersortCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("suppliersortCode", suppliersortCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recSupplierSortMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.updateStateSupplierSortModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.updateStateSupplierSortModelByCode.null");
        }
    }

    private RecSupplierSort makeSupplierSort(RecSupplierSortDomain recSupplierSortDomain, RecSupplierSort recSupplierSort) {
        if (null == recSupplierSortDomain) {
            return null;
        }
        if (null == recSupplierSort) {
            recSupplierSort = new RecSupplierSort();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recSupplierSort, (Object)recSupplierSortDomain);
            return recSupplierSort;
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierSortServiceImpl.makeSupplierSort", (Throwable)e);
            return null;
        }
    }

    private RecSupplierSortReDomain makeRecSupplierSortReDomain(RecSupplierSort recSupplierSort) {
        if (null == recSupplierSort) {
            return null;
        }
        RecSupplierSortReDomain recSupplierSortReDomain = new RecSupplierSortReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recSupplierSortReDomain, (Object)recSupplierSort);
            return recSupplierSortReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierSortServiceImpl.makeRecSupplierSortReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecSupplierSort> querySupplierSortModelPage(Map<String, Object> parammap) {
        try {
            return this.recSupplierSortMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierSortServiceImpl.querySupplierSortModel", (Throwable)e);
            return null;
        }
    }

    private int countSupplierSort(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recSupplierSortMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecSupplierSortServiceImpl.countSupplierSort", (Throwable)e);
        }
        return i;
    }

    private RecSupplierSort createRecSupplierSort(RecSupplierSortDomain recSupplierSortDomain) {
        String msg = this.checkSupplierSort(recSupplierSortDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.saveSupplierSort.checkSupplierSort", msg);
        }
        RecSupplierSort recSupplierSort = this.makeSupplierSort(recSupplierSortDomain, null);
        this.setSupplierSortDefault(recSupplierSort);
        return recSupplierSort;
    }

    @Override
    public String saveSupplierSort(RecSupplierSortDomain recSupplierSortDomain) throws ApiException {
        this.logger.error(".----saveSupplierSort\u5f00\u59cb-----", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)recSupplierSortDomain));
        RecSupplierSort recSupplierSort = this.createRecSupplierSort(recSupplierSortDomain);
        this.saveSupplierSortModel(recSupplierSort);
        return recSupplierSort.getSuppliersortCode();
    }

    @Override
    public String saveSupplierSortBatch(List<RecSupplierSortDomain> recSupplierSortDomainList) throws ApiException {
        if (null == recSupplierSortDomainList || recSupplierSortDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecSupplierSort> recSupplierSortList = new ArrayList<RecSupplierSort>();
        String code = "";
        for (RecSupplierSortDomain recSupplierSortDomain : recSupplierSortDomainList) {
            RecSupplierSort recSupplierSort = this.createRecSupplierSort(recSupplierSortDomain);
            code = recSupplierSort.getSuppliersortCode();
            recSupplierSortList.add(recSupplierSort);
        }
        this.saveSupplierSortBatchModel(recSupplierSortList);
        return code;
    }

    @Override
    public void updateSupplierSortState(Integer suppliersortId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == suppliersortId) {
            return;
        }
        this.updateStateSupplierSortModel(suppliersortId, dataState, oldDataState, map);
    }

    @Override
    public void updateSupplierSortStateByCode(String tenantCode, String suppliersortCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)suppliersortCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSupplierSortModelByCode(tenantCode, suppliersortCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSupplierSort(RecSupplierSortDomain recSupplierSortDomain) throws ApiException {
        this.logger.error(".----updateSupplierSort\u5f00\u59cb-----", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)recSupplierSortDomain));
        String msg = this.checkSupplierSort(recSupplierSortDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.updateSupplierSort.checkSupplierSort", msg);
        }
        RecSupplierSort oldRecSupplierSort = this.getSupplierSortModelById(recSupplierSortDomain.getSuppliersortId());
        if (null == oldRecSupplierSort) {
            throw new ApiException("rec.RecSupplierSortServiceImpl.updateSupplierSort.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecSupplierSort recSupplierSort = this.makeSupplierSort(recSupplierSortDomain, oldRecSupplierSort);
        this.logger.error(".updateSupplierSort.memo", (Object)recSupplierSort.getMemo());
        this.setSupplierSortUpdataDefault(recSupplierSort);
        this.updateSupplierSortModel(recSupplierSort);
    }

    @Override
    public RecSupplierSort getSupplierSort(Integer suppliersortId) {
        if (null == suppliersortId) {
            return null;
        }
        return this.getSupplierSortModelById(suppliersortId);
    }

    @Override
    public void deleteSupplierSort(Integer suppliersortId) throws ApiException {
        if (null == suppliersortId) {
            return;
        }
        this.deleteSupplierSortModel(suppliersortId);
    }

    @Override
    public QueryResult<RecSupplierSort> querySupplierSortPage(Map<String, Object> map) {
        List<RecSupplierSort> recSupplierSortList = this.querySupplierSortModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        int count = 0;
        if (ListUtil.isNotEmpty(recSupplierSortList)) {
            count = this.countSupplierSort(map);
        }
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recSupplierSortList);
        return queryResult;
    }

    @Override
    public RecSupplierSort getSupplierSortByCode(String tenantCode, String suppliersortCode) throws ApiException {
        if (StringUtils.isBlank((String)suppliersortCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("suppliersortCode", suppliersortCode);
        return this.getSupplierSortModelByCode(map);
    }

    @Override
    public void deleteSupplierSortByCode(String tenantCode, String suppliersortCode) throws ApiException {
        if (StringUtils.isBlank((String)suppliersortCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("suppliersortCode", suppliersortCode);
        this.delSupplierSortModelByCode(map);
    }
}

