/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsBrandauMapper;
import com.yqbsoft.laser.service.resources.domain.RsBrandDomain;
import com.yqbsoft.laser.service.resources.domain.RsBrandauDomain;
import com.yqbsoft.laser.service.resources.domain.RsBrandauReDomain;
import com.yqbsoft.laser.service.resources.model.RsBrandau;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.service.RsBrandService;
import com.yqbsoft.laser.service.resources.service.RsBrandauService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsBrandauServiceImpl
extends BaseServiceImpl
implements RsBrandauService {
    private static final String SYS_CODE = "rs.RsBrandauServiceImpl";
    private RsBrandauMapper rsBrandauMapper;
    private RsBrandService rsBrandService;
    private RsSenddataBaseService rsSenddataBaseService;

    public void setRsBrandauMapper(RsBrandauMapper rsBrandauMapper) {
        this.rsBrandauMapper = rsBrandauMapper;
    }

    public void setRsBrandService(RsBrandService rsBrandService) {
        this.rsBrandService = rsBrandService;
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    private Date getSysDate() {
        try {
            return this.rsBrandauMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandauServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBrandau(RsBrandauDomain rsBrandauDomain) {
        if (null == rsBrandauDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsBrandauDomain.getBrandName())) {
            msg = msg + "BrandName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsBrandauDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setBrandauDefault(RsBrandau rsBrandau) {
        if (null == rsBrandau) {
            return;
        }
        if (null == rsBrandau.getDataState()) {
            rsBrandau.setDataState(0);
        }
        if (null == rsBrandau.getGmtCreate()) {
            rsBrandau.setGmtCreate(this.getSysDate());
        }
        rsBrandau.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsBrandau.getBrandauCode())) {
            rsBrandau.setBrandauCode(this.createUUIDString());
        }
    }

    private int getBrandauMaxCode() {
        int code = 0;
        try {
            return this.rsBrandauMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandauServiceImpl.getBrandauMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBrandauUpdataDefault(RsBrandau rsBrandau) {
        if (null == rsBrandau) {
            return;
        }
        rsBrandau.setGmtModified(this.getSysDate());
    }

    private void saveBrandauModel(RsBrandau rsBrandau) throws ApiException {
        if (null == rsBrandau) {
            return;
        }
        try {
            this.rsBrandauMapper.insert(rsBrandau);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandauServiceImpl.saveBrandauModel.ex", (Throwable)e);
        }
    }

    private void saveBrandauBatchModel(List<RsBrandau> rsBrandauList) throws ApiException {
        if (null == rsBrandauList || rsBrandauList.isEmpty()) {
            return;
        }
        try {
            this.rsBrandauMapper.insertBatch(rsBrandauList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandauServiceImpl.saveBrandauBatchModel.ex", (Throwable)e);
        }
    }

    private RsBrandau getBrandauModelById(Integer brandauId) {
        if (null == brandauId) {
            return null;
        }
        try {
            return this.rsBrandauMapper.selectByPrimaryKey(brandauId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandauServiceImpl.getBrandauModelById", (Throwable)e);
            return null;
        }
    }

    private RsBrandau getBrandauModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsBrandauMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandauServiceImpl.getBrandauModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBrandauModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsBrandauMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandauServiceImpl.delBrandauModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsBrandauServiceImpl.delBrandauModelByCode.num");
        }
    }

    private void deleteBrandauModel(Integer brandauId) throws ApiException {
        if (null == brandauId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsBrandauMapper.deleteByPrimaryKey(brandauId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandauServiceImpl.deleteBrandauModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsBrandauServiceImpl.deleteBrandauModel.num");
        }
    }

    private void updateBrandauModel(RsBrandau rsBrandau) throws ApiException {
        if (null == rsBrandau) {
            return;
        }
        int i = 0;
        try {
            i = this.rsBrandauMapper.updateByPrimaryKeySelective(rsBrandau);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateBrandauModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateBrandauModel.num");
        }
    }

    private void updateStateBrandauModel(Integer brandauId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        if (null == brandauId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("brandauId", brandauId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (StringUtils.isNotBlank((String)memo)) {
            map.put("memo", memo);
        }
        int i = 0;
        try {
            i = this.rsBrandauMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateStateBrandauModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateStateBrandauModel.null");
        }
    }

    private void updateStateBrandauModelByCode(String tenantCode, String brandauCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)brandauCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("brandauCode", brandauCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsBrandauMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateStateBrandauModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateStateBrandauModelByCode.null");
        }
    }

    private RsBrandau makeBrandau(RsBrandauDomain rsBrandauDomain, RsBrandau rsBrandau) {
        if (null == rsBrandauDomain) {
            return null;
        }
        if (null == rsBrandau) {
            rsBrandau = new RsBrandau();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsBrandau, (Object)rsBrandauDomain);
            return rsBrandau;
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandauServiceImpl.makeBrandau", (Throwable)e);
            return null;
        }
    }

    private RsBrandauReDomain makeRsBrandauReDomain(RsBrandau rsBrandau) {
        if (null == rsBrandau) {
            return null;
        }
        RsBrandauReDomain rsBrandauReDomain = new RsBrandauReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsBrandauReDomain, (Object)rsBrandau);
            return rsBrandauReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandauServiceImpl.makeRsBrandauReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsBrandau> queryBrandauModelPage(Map<String, Object> parammap) {
        try {
            return this.rsBrandauMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandauServiceImpl.queryBrandauModel", (Throwable)e);
            return null;
        }
    }

    private int countBrandau(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsBrandauMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandauServiceImpl.countBrandau", (Throwable)e);
        }
        return i;
    }

    private RsBrandau createRsBrandau(RsBrandauDomain rsBrandauDomain) {
        String msg = this.checkBrandau(rsBrandauDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsBrandauServiceImpl.saveBrandau.checkBrandau", msg);
        }
        RsBrandau rsBrandau = this.makeBrandau(rsBrandauDomain, null);
        this.setBrandauDefault(rsBrandau);
        return rsBrandau;
    }

    @Override
    public String saveBrandau(RsBrandauDomain rsBrandauDomain) throws ApiException {
        RsBrandau rsBrandau = this.createRsBrandau(rsBrandauDomain);
        this.saveBrandauModel(rsBrandau);
        return rsBrandau.getBrandauCode();
    }

    @Override
    public String saveBrandauBatch(List<RsBrandauDomain> rsBrandauDomainList) throws ApiException {
        if (null == rsBrandauDomainList || rsBrandauDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsBrandau> rsBrandauList = new ArrayList<RsBrandau>();
        String code = "";
        for (RsBrandauDomain rsBrandauDomain : rsBrandauDomainList) {
            RsBrandau rsBrandau = this.createRsBrandau(rsBrandauDomain);
            code = rsBrandau.getBrandauCode();
            rsBrandauList.add(rsBrandau);
        }
        this.saveBrandauBatchModel(rsBrandauList);
        return code;
    }

    @Override
    public List<RsSenddata> updateBrandauState(Integer brandauId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        this.updateStateBrandauModel(brandauId, dataState, oldDataState, memo);
        if (1 == dataState) {
            RsBrandau rsBrandau = this.getBrandau(brandauId);
            if (null == rsBrandau) {
                throw new ApiException("rs.RsBrandauServiceImpl.updateBrandauState.rsBrandau");
            }
            List<RsSenddata> rsSenddata = this.saveBrand(rsBrandau);
            if (ListUtil.isNotEmpty(rsSenddata)) {
                this.getRsSenddataBaseService().sendOpData(rsSenddata);
            }
            return rsSenddata;
        }
        return null;
    }

    private List<RsSenddata> saveBrand(RsBrandau rsBrandau) {
        if (null == rsBrandau) {
            return null;
        }
        RsBrandDomain rsBrandDomain = new RsBrandDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsBrandDomain, (Object)rsBrandau);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandauServiceImpl.saveBrand.e", (Throwable)e);
        }
        return this.rsBrandService.saveBrand(rsBrandDomain);
    }

    @Override
    public List<RsSenddata> updateBrandauStateByCode(String tenantCode, String brandauCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBrandauModelByCode(tenantCode, brandauCode, dataState, oldDataState);
        if (1 == dataState) {
            RsBrandau rsBrandau = this.getBrandauByCode(tenantCode, brandauCode);
            if (null == rsBrandau) {
                throw new ApiException("rs.RsBrandauServiceImpl.updateBrandauStateByCode.rsBrandau");
            }
            return this.saveBrand(rsBrandau);
        }
        return null;
    }

    @Override
    public void updateBrandau(RsBrandauDomain rsBrandauDomain) throws ApiException {
        String msg = this.checkBrandau(rsBrandauDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateBrandau.checkBrandau", msg);
        }
        RsBrandau oldRsBrandau = this.getBrandauModelById(rsBrandauDomain.getBrandauId());
        if (null == oldRsBrandau) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateBrandau.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsBrandau rsBrandau = this.makeBrandau(rsBrandauDomain, oldRsBrandau);
        this.setBrandauUpdataDefault(rsBrandau);
        this.updateBrandauModel(rsBrandau);
    }

    @Override
    public List<RsSenddata> sendUpdateBrandau(RsBrandauDomain rsBrandauDomain) throws ApiException {
        String msg = this.checkBrandau(rsBrandauDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateBrandau.checkBrandau", msg);
        }
        RsBrandau oldRsBrandau = this.getBrandauModelById(rsBrandauDomain.getBrandauId());
        if (null == oldRsBrandau) {
            throw new ApiException("rs.RsBrandauServiceImpl.updateBrandau.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsBrandau rsBrandau = this.makeBrandau(rsBrandauDomain, oldRsBrandau);
        this.setBrandauUpdataDefault(rsBrandau);
        this.updateBrandauModel(rsBrandau);
        oldRsBrandau = this.getBrandauModelById(rsBrandauDomain.getBrandauId());
        return null;
    }

    public RsSenddata makeRsSendDate(RsBrandau rsBrandau) {
        RsSenddata rsSenddata = new RsSenddata();
        return rsSenddata;
    }

    @Override
    public RsBrandau getBrandau(Integer brandauId) {
        return this.getBrandauModelById(brandauId);
    }

    @Override
    public void deleteBrandau(Integer brandauId) throws ApiException {
        this.deleteBrandauModel(brandauId);
    }

    @Override
    public QueryResult<RsBrandau> queryBrandauPage(Map<String, Object> map) {
        List<RsBrandau> rsBrandauList = this.queryBrandauModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBrandau(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsBrandauList);
        return queryResult;
    }

    @Override
    public RsBrandau getBrandauByCode(String tenantCode, String brandauCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("brandauCode", brandauCode);
        return this.getBrandauModelByCode(map);
    }

    @Override
    public void deleteBrandauByCode(String tenantCode, String brandauCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("brandauCode", brandauCode);
        this.delBrandauModelByCode(map);
    }
}

