/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.BaseDomain;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.ches.ChEsEnginePollThread;
import com.yqbsoft.laser.service.resources.ches.ChEsEngineService;
import com.yqbsoft.laser.service.resources.dao.RsFlowdataFinishMapper;
import com.yqbsoft.laser.service.resources.dao.RsFlowdataMapper;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisChannelsendDomain;
import com.yqbsoft.laser.service.resources.domain.DisDgnumDomain;
import com.yqbsoft.laser.service.resources.domain.DisDgnumList;
import com.yqbsoft.laser.service.resources.domain.DisDgoods;
import com.yqbsoft.laser.service.resources.domain.DisDgoodsScopelist;
import com.yqbsoft.laser.service.resources.domain.DisDgoodsScopelistnewReDomain;
import com.yqbsoft.laser.service.resources.domain.DisDpriceConf;
import com.yqbsoft.laser.service.resources.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.HtmlRelease;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.domain.RsBrandDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsShopDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsWhDomain;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueBean;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.es.EsEnginePollThread;
import com.yqbsoft.laser.service.resources.es.EsEnginePutThread;
import com.yqbsoft.laser.service.resources.es.EsEngineService;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsFlowdata;
import com.yqbsoft.laser.service.resources.model.RsFlowdataFinish;
import com.yqbsoft.laser.service.resources.model.RsGoodsClass;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsProperties;
import com.yqbsoft.laser.service.resources.model.RsPropertiesOption;
import com.yqbsoft.laser.service.resources.model.RsPropertiesValue;
import com.yqbsoft.laser.service.resources.model.RsRessendApi;
import com.yqbsoft.laser.service.resources.model.RsRessendApiconf;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.numes.NumEsEnginePollThread;
import com.yqbsoft.laser.service.resources.numes.NumEsEngineService;
import com.yqbsoft.laser.service.resources.opes.OpEsEnginePollThread;
import com.yqbsoft.laser.service.resources.opes.OpEsEngineService;
import com.yqbsoft.laser.service.resources.service.RsBrandService;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataAssistService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassService;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsPropertiesService;
import com.yqbsoft.laser.service.resources.service.RsPropertiesValueService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsRessendApiService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsFlowDataServiceImpl
extends BaseServiceImpl
implements RsFlowDataService {
    public static final String SYS_CODE = "rs.RsFlowdataServiceImpl";
    private static EsEngineService esEngineService;
    private static OpEsEngineService opEsEngineService;
    private static ChEsEngineService chEsEngineService;
    private static NumEsEngineService numEsEngineService;
    private static Object lock;
    private static Object oplock;
    private static Object numlock;
    private static Object chlock;
    public static String DISCHANNEL_TYPE_ONLINE;
    public static String DISCHANNEL_TYPE_THRID;
    public static String DISCHANNEL_TYPE_STORE;
    public static String DISCHANNEL_SALE;
    public static String DISCHANNEL_CON;
    public static String DISCHANNEL_BUS;
    private RsFlowdataMapper rsFlowdataMapper;
    private RsFlowdataFinishMapper rsFlowdataFinishMapper;
    private RsSpecValueService rsSpecValueService;
    private RsFlowDataAssistService rsFlowDataAssistService;
    private RsRessendApiService rsRessendApiService;
    private RsGoodsClassService rsGoodsClassService;
    private RsPropertiesService rsPropertiesService;
    private RsPropertiesValueService rsPropertiesValueService;
    private RsResourceGoodsService rsResourceGoodsService;
    private RsSkuService rsSkuService;
    private RsBrandService rsBrandService;
    private RsClasstreeService rsClasstreeService;
    private RsGoodsOtherService rsGoodsOtherService;
    private String cacheonePcode = "DisChannel-onepCode";

    public RsFlowdataFinishMapper getRsFlowdataFinishMapper() {
        return this.rsFlowdataFinishMapper;
    }

    public void setRsFlowdataFinishMapper(RsFlowdataFinishMapper rsFlowdataFinishMapper) {
        this.rsFlowdataFinishMapper = rsFlowdataFinishMapper;
    }

    public RsGoodsOtherService getRsGoodsOtherService() {
        if (null == this.rsGoodsOtherService) {
            this.rsGoodsOtherService = (RsGoodsOtherService)ApplicationContextUtil.getService((String)"rsGoodsOtherService");
        }
        return this.rsGoodsOtherService;
    }

    public RsSkuService getRsSkuService() {
        if (null == this.rsSkuService) {
            this.rsSkuService = (RsSkuService)ApplicationContextUtil.getService((String)"rsSkuService");
        }
        return this.rsSkuService;
    }

    public RsBrandService getRsBrandService() {
        if (null == this.rsBrandService) {
            this.rsBrandService = (RsBrandService)ApplicationContextUtil.getService((String)"rsBrandService");
        }
        return this.rsBrandService;
    }

    public RsClasstreeService getRsClasstreeService() {
        if (null == this.rsClasstreeService) {
            this.rsClasstreeService = (RsClasstreeService)ApplicationContextUtil.getService((String)"rsClasstreeService");
        }
        return this.rsClasstreeService;
    }

    public RsSpecValueService getRsSpecValueService() {
        if (null == this.rsSpecValueService) {
            this.rsSpecValueService = (RsSpecValueService)ApplicationContextUtil.getService((String)"rsSpecValueService");
        }
        return this.rsSpecValueService;
    }

    public RsPropertiesService getRsPropertiesService() {
        if (null == this.rsPropertiesService) {
            this.rsPropertiesService = (RsPropertiesService)ApplicationContextUtil.getService((String)"rsPropertiesService");
        }
        return this.rsPropertiesService;
    }

    public RsPropertiesValueService getRsPropertiesValueService() {
        if (null == this.rsPropertiesValueService) {
            this.rsPropertiesValueService = (RsPropertiesValueService)ApplicationContextUtil.getService((String)"rsPropertiesValueService");
        }
        return this.rsPropertiesValueService;
    }

    public RsResourceGoodsService getRsResourceGoodsService() {
        if (null == this.rsResourceGoodsService) {
            this.rsResourceGoodsService = (RsResourceGoodsService)ApplicationContextUtil.getService((String)"rsResourceGoodsService");
        }
        return this.rsResourceGoodsService;
    }

    public void setRsRessendApiService(RsRessendApiService rsRessendApiService) {
        this.rsRessendApiService = rsRessendApiService;
    }

    public void setRsFlowdataMapper(RsFlowdataMapper rsFlowdataMapper) {
        this.rsFlowdataMapper = rsFlowdataMapper;
    }

    public void setRsFlowDataAssistService(RsFlowDataAssistService rsFlowDataAssistService) {
        this.rsFlowDataAssistService = rsFlowDataAssistService;
    }

    public RsGoodsClassService getRsGoodsClassService() {
        if (null == this.rsGoodsClassService) {
            this.rsGoodsClassService = (RsGoodsClassService)ApplicationContextUtil.getService((String)"rsGoodsClassService");
        }
        return this.rsGoodsClassService;
    }

    private void saveRsFlowdataModel(RsFlowdata rsFlowData) throws ApiException {
        if (null == rsFlowData) {
            return;
        }
        try {
            this.rsFlowdataMapper.insert(rsFlowData);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsFlowdataServiceImpl.saveRsFlowdataModel.ex", (Throwable)e);
        }
    }

    private void saveRsFlowdataFinishModel(RsFlowdataFinish rsFlowDataFinish) throws ApiException {
        if (null == rsFlowDataFinish) {
            return;
        }
        try {
            this.rsFlowdataFinishMapper.insert(rsFlowDataFinish);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsFlowdataServiceImpl.saveRsFlowdataFinishModel.ex", (Throwable)e);
        }
    }

    private void insertBatchFlowDataModel(List<RsFlowdata> rsFlowDataList) throws ApiException {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        try {
            this.rsFlowdataMapper.insertBatch(rsFlowDataList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsFlowdataServiceImpl.insertBatchFlowDataModel.ex", (Throwable)e);
        }
    }

    private Date getSysDate() {
        try {
            return this.rsFlowdataMapper.selectSysDate();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void deleteFlowDataModel(String fdCode, String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)fdCode) || StringUtils.isEmpty((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fdCode", fdCode);
        map.put("tenantCode", tenantCode);
        try {
            int i = this.rsFlowdataMapper.delByCode(map);
            if (i <= 0) {
                this.logger.error("rs.RsFlowdataServiceImpl.deleteFlowDataModel.i", (Object)((Object)map).toString());
            }
        }
        catch (Exception e) {
            throw new ApiException("rs.RsFlowdataServiceImpl.deleteFlowDataModel.ex", (Throwable)e);
        }
    }

    @Override
    public void sendBatchFlowDataModel(List<RsFlowdata> rsFlowDataList) {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        rsFlowDataList = this.saveBatchFlowDataList(rsFlowDataList);
        RsFlowDataServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(RsFlowDataServiceImpl.getEsEngineService(), rsFlowDataList));
    }

    private List<RsFlowdata> saveBatchFlowDataList(List<RsFlowdata> rsFlowDataList) {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return null;
        }
        Date date = null;
        for (RsFlowdata rsFlowData : rsFlowDataList) {
            date = this.getSysDate();
            rsFlowData.setDataState(1);
            rsFlowData.setGmtCreate(date);
            rsFlowData.setGmtModified(date);
            String fdCode1 = this.getNo(null, RsFlowdata.class.getSimpleName(), "fdCode", rsFlowData.getTenantCode());
            rsFlowData.setFdCode(fdCode1);
            if (!StringUtils.isNotBlank((String)rsFlowData.getSenddataCode())) continue;
        }
        this.insertBatchFlowDataModel(rsFlowDataList);
        return rsFlowDataList;
    }

    @Override
    public List<RsFlowdata> saveBatchFlowDataModel(List<RsFlowdata> rsFlowDataList) {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return null;
        }
        return this.saveBatchFlowDataList(rsFlowDataList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 100; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChEsEngineService getChEsEngineService() {
        Object object = chlock;
        synchronized (object) {
            if (null == chEsEngineService) {
                chEsEngineService = new ChEsEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 30; ++i) {
                    chEsEngineService.addPollPool(new ChEsEnginePollThread(chEsEngineService));
                }
            }
            return chEsEngineService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumEsEngineService getNumEsEngineService() {
        Object object = numlock;
        synchronized (object) {
            if (null == numEsEngineService) {
                numEsEngineService = new NumEsEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 50; ++i) {
                    numEsEngineService.addPollPool(new NumEsEnginePollThread(numEsEngineService));
                }
            }
            return numEsEngineService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpEsEngineService getOpEsEngineService() {
        Object object = oplock;
        synchronized (object) {
            if (null == opEsEngineService) {
                opEsEngineService = new OpEsEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 50; ++i) {
                    opEsEngineService.addPollPool(new OpEsEnginePollThread(opEsEngineService));
                }
            }
            return opEsEngineService;
        }
    }

    @Override
    public void loadFlowDataProcess() {
        this.loadDb();
    }

    private int countChannelsend(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsFlowdataMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.countChannelsend", (Throwable)e);
        }
        return i;
    }

    public QueryResult<RsFlowdata> queryRsFlowdataPage(Map<String, Object> map) {
        List<RsFlowdata> disChannelsendList = this.rsFlowdataMapper.query(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelsend(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disChannelsendList);
        return queryResult;
    }

    private void loadDb() {
        try {
            this.logger.info("rs.RsFlowdataServiceImpl.loadDb.start");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<RsFlowdata> result = null;
            int xh = 0;
            do {
                startRow = RsFlowDataServiceImpl.getEsEngineService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", RsFlowDataServiceImpl.getEsEngineService().getPage());
                result = this.queryRsFlowdataPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    RsFlowDataServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(RsFlowDataServiceImpl.getEsEngineService(), result.getRows()));
                    if (result.getRows().size() != RsFlowDataServiceImpl.getEsEngineService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(3000L);
                if (++xh <= 100) continue;
                flag = false;
            } while (flag);
            RsFlowDataServiceImpl.getEsEngineService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("rs.RsFlowdataServiceImpl.loadDb.an.e", (Throwable)e);
        }
        this.logger.info("rs.RsFlowdataServiceImpl.loadDb.end");
    }

    @Override
    public List<RsSenddata> newTransRsToEsAndStatic(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return null;
        }
        try {
            return this.saveRsToEsAndStatic(rsFlowData);
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.newTransRsToEsAndStatic.e", (Object)rsFlowData.getFdCode(), (Throwable)e);
            return null;
        }
    }

    private List<RsSenddata> saveRsToEsAndStatic(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        if (null == rsFlowData.getChannelsendApiApicode()) {
            rsFlowData.setChannelsendApiApicode("");
        }
        if (rsFlowData.getChannelsendApiApicode().equals("RsResourceGoods")) {
            if (!this.sendGoods(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "RsResourceGoods"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("RsSku")) {
            if (!this.sendSku(rsFlowData)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "RsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("McRsSku")) {
            if (!this.sendMcSku(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "McRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("TypeRsSku")) {
            if (!this.saveTypeNum(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "McRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("TypeInitRsSku")) {
            if (!this.saveTypeInitNum(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "McRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("TcRsSku")) {
            if (!this.sendTcSku(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "TcRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("MkRsSku")) {
            if (!this.sendMkSku(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "MkRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("NumRsSku")) {
            if (!this.sendNumSku(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "NumRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("RsClasstree")) {
            if (!this.sendClass(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "RsClasstree"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("RsGoodsClass")) {
            if (!this.sendGoodsClass(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "RsGoodsClass"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("DisRsGoodsClass")) {
            if (!this.sendDisGoodsClass(rsFlowData)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "DisRsGoodsClass"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("DisRsResourceGoods")) {
            if (!this.sendDisGoods(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "DisRsResourceGoods"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("DisRsSku")) {
            if (!this.sendDisSku(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "DisRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("CentDisRsResourceGoods")) {
            if (!this.sendCentDisGoods(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "CentDisRsResourceGoods"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("CentDisRsSku")) {
            if (!this.sendCentDisSku(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "CentDisRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("outGoods")) {
            if (!this.sendOutGoods(rsFlowData)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "outGoods"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("dataUpdate")) {
            if (!this.sendDataUpdateGoods(rsFlowData)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "dataUpdate"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("Updata")) {
            if (!this.sendUpdateSku(rsFlowData)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "Updata"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("RsBrand")) {
            if (!this.sendDisBrand(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "RsBrand"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("RcRsSku")) {
            if (!this.sendNumMrSku(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "RcRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("RsSkuResetPrice")) {
            if (!this.sendResetPrice(rsFlowData, rsSenddataList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "RcRsSku"));
                return null;
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("DisRsResourceGoodsSingle") && !this.sendDisGoodsSingle(rsFlowData, rsSenddataList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "DisRsResourceGoods"));
            return null;
        }
        this.deleteFlowDataModel(rsFlowData.getFdCode(), rsFlowData.getTenantCode());
        RsFlowdataFinish rsFlowDataFinish = new RsFlowdataFinish();
        try {
            BeanUtils.copyAllPropertys((Object)rsFlowDataFinish, (Object)rsFlowData);
            rsFlowDataFinish.setFdId(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveRsFlowdataFinishModel(rsFlowDataFinish);
        return rsSenddataList;
    }

    private boolean sendResetPrice(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        if (null == rsResourceGoodsReDomain) {
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        }
        List<RsSku> skuList = this.getRsSkuService().querySkuByGoodsCode(rsResourceGoodsReDomain.getGoodsCode(), rsResourceGoodsReDomain.getTenantCode());
        HashMap<String, Object> maps = new HashMap<String, Object>();
        HashMap<String, String> mapSku = new HashMap<String, String>();
        maps.put("skuCode", rsFlowData.getFdBizcode());
        maps.put("goodsId", rsResourceGoodsReDomain.getGoodsId());
        maps.put("orderBom", rsResourceGoodsReDomain.getGoodsShowno());
        maps.put("priceSetNPrice", skuList.get(0).getPricesetNprice());
        mapSku.put("map", JsonUtil.buildNormalBinder().toJson(maps));
        try {
            this.internalInvoke("dis.dpriceConf.resetDisPriceConf", mapSku);
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.resetDisPriceConf.ex", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean sendUpdateSku(RsFlowdata rsFlowData) {
        List<RsSkuDomain> rsSkuDomainList;
        if (null == rsFlowData) {
            return false;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            RsSkuDomain rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        if (ListUtil.isEmpty(rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList())) {
            return false;
        }
        for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
            if (this.sendCom(rsSkuDomain2, rsFlowData, rsResourceGoodsReDomain)) continue;
            return false;
        }
        return true;
    }

    private boolean sendCom(RsSkuDomain rsSkuDomain, RsFlowdata rsFlowData, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsSkuDomain || null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataOpbillstate", rsSkuDomain.getDataOpbillstate());
        map.put("skuCode", rsSkuDomain.getSkuCode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        map.put("pricesetNprice", rsSkuDomain.getPricesetNprice());
        map.put("goodsSupplynum", rsSkuDomain.getGoodsSupplynum());
        map.put("goodsSupplyweight", rsSkuDomain.getGoodsSupplyweight());
        map.put("dataPic", rsSkuDomain.getDataPic());
        map.put("goodsName", rsSkuDomain.getGoodsName());
        map.put("partsnameNumunit", rsSkuDomain.getPartsnameNumunit());
        map.put("partsnameWeightunit", rsSkuDomain.getPartsnameWeightunit());
        map.put("goodsMinnum", rsSkuDomain.getGoodsMinnum());
        map.put("goodsOneweight", rsSkuDomain.getGoodsOneweight());
        map.put("skuNo", rsSkuDomain.getSkuNo());
        map.put("skuEocode", rsSkuDomain.getSkuEocode());
        map.put("goodsCode", rsSkuDomain.getGoodsCode());
        map.put("goodsEocode", rsSkuDomain.getGoodsEocode());
        map.put("memberCode", rsSkuDomain.getMemberCode());
        map.put("memberCcode", rsSkuDomain.getMemberCcode());
        map.put("channelCode", rsSkuDomain.getChannelCode());
        map.put("tenantCode", rsSkuDomain.getTenantCode());
        Map paramMap = this.getQueryParamMap("tenantCode,ressendApiType", new Object[]{rsFlowData.getTenantCode(), rsFlowData.getChannelsendApiApicode()});
        QueryResult<RsRessendApi> ressendApiResult = this.rsRessendApiService.queryRessendApiPage(paramMap);
        if (null == ressendApiResult || ListUtil.isEmpty((Collection)ressendApiResult.getList())) {
            return true;
        }
        List<RsRessendApi> listRessendApi = this.structureApi(ressendApiResult.getList(), rsResourceGoodsReDomain);
        if (ListUtil.isEmpty(listRessendApi)) {
            return true;
        }
        for (RsRessendApi rsRessendApi : listRessendApi) {
            if (this.sendDataUpdateGood(map, rsRessendApi.getRessendApiApicode()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean sendDataUpdateGoods(RsFlowdata rsFlowData) {
        List<RsSkuDomain> rsSkuDomainList;
        if (null == rsFlowData) {
            return false;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            RsSkuDomain rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDataUpdateGoods.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDataUpdateGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        if (ListUtil.isEmpty(rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList())) {
            return false;
        }
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            if (this.updateData(rsSkuDomain, rsFlowData)) continue;
            return false;
        }
        return true;
    }

    private boolean updateData(RsSkuDomain rsSkuDomain, RsFlowdata rsFlowData) {
        if (null == rsSkuDomain || null == rsFlowData) {
            this.logger.error("rs.RsFlowdataServiceImpl.updateData.", (Object)("param is null : " + (null == rsSkuDomain) + "=:=" + (null == rsFlowData)));
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsSkuDomain.getSkuCode());
        map.put("goodsCode", rsSkuDomain.getGoodsCode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        Integer dataState = 0;
        if (null == rsSkuDomain || rsFlowData.getEsrequestType().equals("skudown") || rsFlowData.getEsrequestType().equals("down") || rsFlowData.getEsrequestType().equals("delete") || rsFlowData.getEsrequestType().equals("deleteop")) {
            dataState = rsFlowData.getEsrequestType().equals("skudown") || rsFlowData.getEsrequestType().equals("down") ? 2 : 3;
        } else if (!"add".equals(rsFlowData.getEsrequestType())) {
            if (rsSkuDomain.getGoodsSupplynum().intValue() <= 0) {
                // empty if block
            }
            map.put("dataState", dataState);
            if (rsFlowData.getEsrequestType().equals("edit")) {
                map.put("pricesetNprice", rsSkuDomain.getPricesetNprice());
                map.put("goodsSupplynum", rsSkuDomain.getGoodsSupplynum());
                map.put("partsnameNumunit", rsSkuDomain.getPartsnameNumunit());
                map.put("partsnameWeightunit", rsSkuDomain.getPartsnameWeightunit());
                map.put("goodsMinnum", rsSkuDomain.getGoodsMinnum());
                map.put("goodsOneweight", rsSkuDomain.getGoodsOneweight());
                map.put("goodsType", rsSkuDomain.getGoodsType());
                map.put("goodsPro", rsSkuDomain.getGoodsPro());
            } else if (rsFlowData.getEsrequestType().equals("insert")) {
                String goodsName = rsSkuDomain.getGoodsName();
                if (StringUtils.isBlank((String)goodsName)) {
                    this.logger.error("rs.RsFlowdataServiceImpl.updateData.", (Object)"goodsName is null");
                    return false;
                }
                map.put("pricesetNprice", rsSkuDomain.getPricesetNprice());
                map.put("goodsSupplynum", rsSkuDomain.getGoodsSupplynum());
                map.put("goodsSupplyweight", rsSkuDomain.getGoodsSupplyweight());
                map.put("dataPic", rsSkuDomain.getDataPic());
                map.put("goodsName", goodsName);
                map.put("partsnameNumunit", rsSkuDomain.getPartsnameNumunit());
                map.put("partsnameWeightunit", rsSkuDomain.getPartsnameWeightunit());
                map.put("goodsMinnum", rsSkuDomain.getGoodsMinnum());
                map.put("goodsOneweight", rsSkuDomain.getGoodsOneweight());
                map.put("goodsType", rsSkuDomain.getGoodsType());
                map.put("goodsPro", rsSkuDomain.getGoodsPro());
            } else {
                map.put("goodsSupplynum", rsSkuDomain.getGoodsSupplynum());
            }
        }
        map.put("dataState", dataState);
        if (!this.sendDataUpdateGood(map, "um.collect.updateCollectByOpCode").booleanValue()) {
            this.logger.error("rs.RsFlowdataServiceImpl.updateData.updateCollectByOpCode", map);
            return false;
        }
        if (!this.sendDataUpdateGood(map, "um.footprint.updateFootprintByOpCode").booleanValue()) {
            this.logger.error("rs.RsFlowdataServiceImpl.updateData.updateFootprintByOpCode", map);
            return false;
        }
        if (!this.sendDataUpdateGood(map, "oc.shopping.updateShopGoodsBySkuCode").booleanValue()) {
            this.logger.error("rs.RsFlowdataServiceImpl.updateData.updateShopGoodsBySkuCode", map);
            return false;
        }
        if (!this.sendDataUpdateGood(map, "oc.regular.updateGoodsBySkuCode").booleanValue()) {
            this.logger.error("rs.RsFlowdataServiceImpl.updateData.updateGoodsBySkuCode", map);
            return false;
        }
        return true;
    }

    private Boolean sendDataUpdateGood(Map<String, Object> paramMap, String api) {
        if (null == paramMap || null == api) {
            return false;
        }
        HashMap<String, String> paramMapStr = new HashMap<String, String>();
        paramMapStr.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        try {
            this.getInternalRouter().inInvoke(api, paramMapStr);
            return true;
        }
        catch (ApiException e) {
            this.logger.error("rsFlowDataServiceImpl.sendDataUpdateGood.ex", (Throwable)e);
            return false;
        }
    }

    private boolean sendOutGoods(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        if (null == rsResourceGoodsReDomain) {
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        }
        if (null == rsResourceGoodsReDomain) {
            return false;
        }
        Map paramMap = this.getQueryParamMap("tenantCode,ressendApiType", new Object[]{rsFlowData.getTenantCode(), rsFlowData.getChannelsendApiApicode()});
        QueryResult<RsRessendApi> ressendApiResult = this.rsRessendApiService.queryRessendApiPage(paramMap);
        if (ListUtil.isEmpty((Collection)ressendApiResult.getList())) {
            return true;
        }
        List<RsRessendApi> listRessendApi = this.structureApi(ressendApiResult.getList(), rsResourceGoodsReDomain);
        if (ListUtil.isEmpty(listRessendApi)) {
            return true;
        }
        for (RsRessendApi rsRessendApi : listRessendApi) {
            HashMap<String, String> paramMap1 = new HashMap<String, String>();
            paramMap1.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain));
            if (!ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) continue;
            HashMap<String, String> paramMap2 = new HashMap<String, String>();
            for (RsSkuDomain rsSkuDomain : rsResourceGoodsReDomain.getRsSkuDomainList()) {
                paramMap2.put("skuBarcode", rsSkuDomain.getSkuNo());
                paramMap2.put("tenantCode", rsSkuDomain.getTenantCode());
                paramMap1.put("map", JsonUtil.buildNormalBinder().toJson(paramMap2));
                paramMap1.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain));
                String result = (String)this.getInternalRouter().inInvoke(rsRessendApi.getRessendApiApicode(), "1.0", "0", paramMap1);
                if (!StringUtils.isEmpty((String)result) && !"false".equals(result)) continue;
                this.logger.error("\u672a\u6210\u529f\u5904\u7406\u7684api *****" + rsRessendApi.getRessendApiCode() + "*****" + rsFlowData.getFdBizcode());
                return false;
            }
        }
        return true;
    }

    private List<RsRessendApi> structureApi(List<RsRessendApi> ressendApiList, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        ArrayList<RsRessendApi> sendApiList = new ArrayList<RsRessendApi>();
        for (RsRessendApi rsRessendApi : ressendApiList) {
            List apiconfList;
            Map<String, List<String>> map;
            HashMap<String, Object> apiconfMap = new HashMap<String, Object>();
            apiconfMap.put("ressendApiApicode", rsRessendApi.getRessendApiApicode());
            apiconfMap.put("tenantCode", rsRessendApi.getTenantCode());
            QueryResult<RsRessendApiconf> apiconf = this.rsRessendApiService.queryRessendApiconfPage(apiconfMap);
            if (null == apiconf || apiconf.getList().size() <= 0) {
                sendApiList.add(rsRessendApi);
            }
            if (null == (map = this.makeRessendScopelist(apiconfList = apiconf.getList())) || map.isEmpty()) continue;
            boolean flag = true;
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.newForceGetProperty((Object)rsResourceGoodsReDomain, (String)key);
                if (null == objValue) {
                    flag = false;
                    break;
                }
                if (map.get(key).contains(objValue)) continue;
                flag = false;
                break;
            }
            if (!flag || sendApiList.contains(rsRessendApi)) continue;
            sendApiList.add(rsRessendApi);
        }
        return sendApiList;
    }

    private Map<String, List<String>> makeRessendScopelist(List<RsRessendApiconf> apiconfList) {
        if (ListUtil.isEmpty(apiconfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (RsRessendApiconf rsRessendApiconf : apiconfList) {
            ArrayList<String> list = (ArrayList<String>)map.get(rsRessendApiconf.getRessendApiconfType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(rsRessendApiconf.getRessendApiconfType(), list);
            }
            list.add(rsRessendApiconf.getRessendApiconfOp());
        }
        return map;
    }

    private boolean sendDisGoodsClass(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return true;
        }
        RsGoodsClass rsGoodsClass = (RsGoodsClass)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsGoodsClass.class);
        if (null == rsGoodsClass) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoodsClass.rsGoodsClass", (Object)(rsFlowData.getFdCode() + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return false;
        }
        List<DisChannel> disChannelList = this.queryThirdChannel(rsGoodsClass.getMemberCode(), rsFlowData.getTenantCode());
        if (ListUtil.isEmpty(disChannelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoodsClass.disChannelList", (Object)(rsGoodsClass.getMemberCode() + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return true;
        }
        String apiCode = "dis.channelsendBase.sendChannelsendBatch";
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        for (DisChannel disChannel : disChannelList) {
            DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
            disChannelsendDomain.setChannelCode(disChannel.getChannelCode());
            disChannelsendDomain.setChannelsendDir(rsFlowData.getEsrequestType());
            disChannelsendDomain.setChannelsendTxt(rsFlowData.getFdBizcodestr());
            disChannelsendDomain.setChannelsendType("RsGoodsClass");
            disChannelsendDomain.setTenantCode(rsFlowData.getTenantCode());
            disChannelsendDomainList.add(disChannelsendDomain);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(disChannelsendDomainList));
        this.internalInvoke(apiCode, paramMap);
        return true;
    }

    private boolean sendGoodsClassHtml(RsFlowdata rsFlowData) {
        String memberCode;
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "";
        }
        if (StringUtils.isBlank((String)(memberCode = rsFlowData.getFdBizcode()))) {
            memberCode = "";
        }
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsGoodsClass");
        htmlRelease.setHtmldataFilename("goodsclass.html");
        htmlRelease.setHtmldataFilepath("goodsclass");
        htmlRelease.setHtmldataMenu(channelCode);
        htmlRelease.setHtmlcontOpparam(rsFlowData.getFdBizcodestr());
        return this.sendHtml(htmlRelease);
    }

    private boolean sendGoodsClass(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        DisChannel disChannel;
        if (null == rsFlowData || null == rsSenddataList) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsClass.rsFlowData");
            return false;
        }
        if (!this.sendGoodsClassHtml(rsFlowData)) {
            return false;
        }
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isNotBlank((String)channelCode) && null == (disChannel = this.getChannel(channelCode, rsFlowData.getTenantCode()))) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsClass.disChannel", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return false;
        }
        List<DisChannel> channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getChannelCode(), rsFlowData.getTenantCode(), true);
        if (ListUtil.isEmpty(channelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsClass.channelList.null", (Object)(rsFlowData.getMemberCode() + "-" + rsFlowData.getChannelCode()));
            return true;
        }
        List<RsSenddata> ctrsSenddataList = null;
        if ("delete".equals(rsFlowData.getEsrequestType())) {
            RsGoodsClassDomain rsGoodsClassDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsGoodsClassDomain = (RsGoodsClassDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsGoodsClassDomain.class);
            }
            if (null == rsGoodsClassDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsClass.rsGoodsClassDomain", (Object)(rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            ctrsSenddataList = this.getRsGoodsClassService().deleteGoodsClassByCode(rsGoodsClassDomain.getGoodsClassCode(), null, rsFlowData.getTenantCode());
        } else if ("add".equals(rsFlowData.getEsrequestType())) {
            List<RsGoodsClassDomain> goodsClassDomains = this.getDisRsGoodsClassList(rsFlowData, channelList, "add");
            if (ListUtil.isEmpty(goodsClassDomains)) {
                if (null != goodsClassDomains) {
                    this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsClass.goodsClassDomains", (Object)(JsonUtil.buildNormalBinder().toJson((Object)rsFlowData) + "=:=" + JsonUtil.buildNormalBinder().toJson(channelList)));
                    return true;
                }
                this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsClass.null", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            ctrsSenddataList = this.getRsGoodsClassService().saveBatchDisGoodsClass(goodsClassDomains);
        } else if ("update".equals(rsFlowData.getEsrequestType())) {
            List<RsGoodsClassDomain> goodsClassDomains = this.getDisRsGoodsClassList(rsFlowData, channelList, "update");
            if (ListUtil.isEmpty(goodsClassDomains)) {
                return true;
            }
            ctrsSenddataList = this.getRsGoodsClassService().saveBatchDisGoodsClass(goodsClassDomains);
        }
        if (ListUtil.isNotEmpty(ctrsSenddataList)) {
            rsSenddataList.addAll(ctrsSenddataList);
        }
        return true;
    }

    private boolean sendClassHtml(RsFlowdata rsFlowData) {
        String memberCode;
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "";
        }
        if (StringUtils.isBlank((String)(memberCode = rsFlowData.getFdBizcode()))) {
            memberCode = "";
        }
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsClasstree");
        htmlRelease.setHtmldataFilename("classtree.html");
        htmlRelease.setHtmldataFilepath("classtree");
        htmlRelease.setHtmldataMenu(channelCode);
        htmlRelease.setHtmlcontOpparam(rsFlowData.getFdBizcodestr());
        if (!this.sendHtml(htmlRelease)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendClass.sendHtml", (Object)rsFlowData.getFdCode());
            return false;
        }
        return true;
    }

    private boolean sendClass(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        DisChannel disChannel;
        if (null == rsFlowData || null == rsSenddataList) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendClass.rsFlowData");
            return false;
        }
        if (!this.sendClassHtml(rsFlowData)) {
            return false;
        }
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isNotBlank((String)channelCode) && null == (disChannel = this.getChannel(channelCode, rsFlowData.getTenantCode()))) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendClass.disChannel", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return false;
        }
        List<DisChannel> channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getChannelCode(), rsFlowData.getTenantCode(), true);
        if (ListUtil.isEmpty(channelList)) {
            return true;
        }
        List<RsSenddata> ctrsSenddataList = null;
        if ("delete".equals(rsFlowData.getEsrequestType())) {
            RsClasstreeDomain rsClasstreeDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsClasstreeDomain = (RsClasstreeDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsClasstreeDomain.class);
            }
            if (null == rsClasstreeDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendClass.rsClasstreeDomain", (Object)(rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            ctrsSenddataList = this.getRsClasstreeService().deleteClasstreeByCode(rsClasstreeDomain.getClasstreeCode(), null, rsFlowData.getTenantCode());
        } else if ("add".equals(rsFlowData.getEsrequestType())) {
            List<RsClasstreeDomain> rsClasstreeDomains = this.getDisRsClasstreeList(rsFlowData, channelList);
            if (ListUtil.isEmpty(rsClasstreeDomains)) {
                if (null != rsClasstreeDomains) {
                    this.logger.error("rs.RsFlowdataServiceImpl.sendClass.rsClasstreeDomains ", (Object)(JsonUtil.buildNormalBinder().toJson((Object)rsFlowData) + "=:=" + JsonUtil.buildNormalBinder().toJson(channelList)));
                    return true;
                }
                this.logger.error("rs.RsFlowdataServiceImpl.sendClass.rsClasstreeDomains", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            ctrsSenddataList = this.getRsClasstreeService().saveBatchDisClasstree(rsClasstreeDomains);
        } else if ("update".equals(rsFlowData.getEsrequestType())) {
            List<RsClasstreeDomain> rsClasstreeDomains = this.getDisRsClasstreeList(rsFlowData, channelList);
            if (ListUtil.isEmpty(rsClasstreeDomains)) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendClass.rsClasstreeDomains2", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return true;
            }
            ctrsSenddataList = this.getRsClasstreeService().saveBatchDisClasstree(rsClasstreeDomains);
        }
        if (ListUtil.isNotEmpty(ctrsSenddataList)) {
            rsSenddataList.addAll(ctrsSenddataList);
        }
        return true;
    }

    private List<RsGoodsClass> queryByClasstreeCode(String classtreeCode, String tenantCode) {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rsFlowDataServiceImpl.queryByClasstreeCode", (Object)"param is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeCode", classtreeCode);
        map.put("tenantCode", tenantCode);
        QueryResult<RsGoodsClass> queryResult = this.getRsGoodsClassService().queryGoodsClassPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.info("rsFlowDataServiceImpl.queryByClasstreeCode", (Object)((Object)map).toString());
            return null;
        }
        ArrayList<RsGoodsClass> reGoodsClassList = new ArrayList<RsGoodsClass>();
        for (RsGoodsClass rsGoodsClass : queryResult.getList()) {
            reGoodsClassList.add(this.makeRsRsGoodsClass(rsGoodsClass));
        }
        return reGoodsClassList;
    }

    private RsGoodsClass makeRsRsGoodsClass(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass || rsGoodsClass.getGoodsClassParentcode().equals("-1")) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsClassCode", rsGoodsClass.getGoodsClassParentcode());
        map.put("tenantCode", rsGoodsClass.getTenantCode());
        QueryResult<RsGoodsClass> queryResult = this.getRsGoodsClassService().queryGoodsClassPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("rsFlowDataServiceImpl.makeRsRsGoodsClass", (Object)"return is null");
            return null;
        }
        RsGoodsClass rsGoodsClass1 = (RsGoodsClass)queryResult.getList().get(0);
        ArrayList<RsGoodsClass> childList = new ArrayList<RsGoodsClass>();
        childList.add(rsGoodsClass);
        rsGoodsClass1.setChildList(childList);
        if (!rsGoodsClass1.getGoodsClassParentcode().equals("-1")) {
            ArrayList<RsGoodsClass> rsGoodsClasses = new ArrayList<RsGoodsClass>();
            RsGoodsClass rsGoodsClass2 = this.makeRsRsGoodsClass(rsGoodsClass1);
            if (null == rsGoodsClass2) {
                return rsGoodsClass1;
            }
            rsGoodsClasses.add(rsGoodsClass1);
            rsGoodsClass2.setChildList(rsGoodsClasses);
            return rsGoodsClass2;
        }
        return rsGoodsClass1;
    }

    private boolean sendMkSku(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        if (null == rsFlowData || null == rsSenddataList) {
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        ResourceStockDomain resourceStockDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            resourceStockDomain = (ResourceStockDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), ResourceStockDomain.class);
        }
        if (null == resourceStockDomain) {
            return true;
        }
        List<RsSenddata> rersSenddataList = this.getRsResourceGoodsService().updateResourceMkStock(resourceStockDomain);
        if (ListUtil.isNotEmpty(rersSenddataList)) {
            rsSenddataList.addAll(rersSenddataList);
        }
        return true;
    }

    private boolean sendTcSku(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        List<RsSenddata> rersSenddataList;
        List<RsSkuDomain> rsSkuDomainList;
        if (null == rsFlowData || null == rsSenddataList) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        RsSkuDomain rsSkuDomain = null;
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendSku.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendTcSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        if (ListUtil.isEmpty(rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList())) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendTcSku.rsSkuDomainList", (Object)rsFlowData.getFdCode());
            return false;
        }
        if (null == rsSkuDomain) {
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                rsSkuDomain = rsSkuDomain2;
                break;
            }
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        }
        if (ListUtil.isNotEmpty(rersSenddataList = this.getRsResourceGoodsService().saveTcNum(rsSkuDomain))) {
            rsSenddataList.addAll(rersSenddataList);
        }
        return true;
    }

    private boolean sendNumSku(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        List<RsSenddata> rersSenddataList;
        List<RsSkuDomain> rsSkuDomainList;
        if (null == rsFlowData || null == rsSenddataList) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        RsSkuDomain rsSkuDomain = null;
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendNumSku.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendNumSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        if (ListUtil.isEmpty(rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList())) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendNumSku.rsSkuDomainList", (Object)rsFlowData.getFdCode());
            return false;
        }
        if (null == rsSkuDomain) {
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                rsSkuDomain = rsSkuDomain2;
                break;
            }
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        }
        if (ListUtil.isNotEmpty(rersSenddataList = this.getRsResourceGoodsService().saveMinNum(rsSkuDomain))) {
            rsSenddataList.addAll(rersSenddataList);
        }
        return true;
    }

    private boolean saveTypeNum(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        List<RsSenddata> rersSenddataList;
        List<RsSkuDomain> rsSkuDomainList;
        if (null == rsFlowData || null == rsSenddataList) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        RsSkuDomain rsSkuDomain = null;
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendMcSku.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendMcSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        if (ListUtil.isEmpty(rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList())) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendMcSku.rsSkuDomainList", (Object)rsFlowData.getFdCode());
            return false;
        }
        if (null == rsSkuDomain) {
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                rsSkuDomain = rsSkuDomain2;
                break;
            }
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        }
        if (ListUtil.isNotEmpty(rersSenddataList = this.getRsResourceGoodsService().saveTypeNum(rsSkuDomain))) {
            rsSenddataList.addAll(rersSenddataList);
        }
        return true;
    }

    private boolean saveTypeInitNum(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        List<RsSenddata> rersSenddataList;
        List<RsSkuDomain> rsSkuDomainList;
        if (null == rsFlowData || null == rsSenddataList) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        RsSkuDomain rsSkuDomain = null;
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendMcSku.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendMcSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        if (ListUtil.isEmpty(rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList())) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendMcSku.rsSkuDomainList", (Object)rsFlowData.getFdCode());
            return false;
        }
        if (null == rsSkuDomain) {
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                rsSkuDomain = rsSkuDomain2;
                break;
            }
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        }
        if (ListUtil.isNotEmpty(rersSenddataList = this.getRsResourceGoodsService().saveTypeInitNum(rsSkuDomain))) {
            rsSenddataList.addAll(rersSenddataList);
        }
        return true;
    }

    private boolean sendMcSku(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        List<RsSenddata> rersSenddataList;
        List<RsSkuDomain> rsSkuDomainList;
        if (null == rsFlowData || null == rsSenddataList) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        RsSkuDomain rsSkuDomain = null;
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendMcSku.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendMcSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        if (ListUtil.isEmpty(rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList())) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendMcSku.rsSkuDomainList", (Object)rsFlowData.getFdCode());
            return false;
        }
        if (null == rsSkuDomain) {
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                rsSkuDomain = rsSkuDomain2;
                break;
            }
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        }
        if (ListUtil.isNotEmpty(rersSenddataList = this.getRsResourceGoodsService().saveMcNum(rsSkuDomain))) {
            rsSenddataList.addAll(rersSenddataList);
        }
        return true;
    }

    private boolean sendSku(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        RsSkuDomain rsSkuDomain = null;
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendSku.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        for (RsSkuDomain rsSkuDomain2 : rsResourceGoodsReDomain.getRsSkuDomainList()) {
            if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
            rsSkuDomain = rsSkuDomain2;
            break;
        }
        return this.sendSku(rsResourceGoodsReDomain, rsSkuDomain, rsFlowData);
    }

    private boolean sendSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, RsFlowdata rsFlowData) {
        if (null == rsResourceGoodsReDomain || null == rsSkuDomain) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendSku.null");
            return true;
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType(rsFlowData.getEsrequestType());
        storeDomain.setBizType("sku");
        if (!(rsFlowData.getEsrequestType().equals("delete") || rsFlowData.getEsrequestType().equals("deleteop") || "skudelete".equals(rsFlowData.getEsrequestType()) || "skudeleteop".equals(rsFlowData.getEsrequestType()))) {
            this.makeEsSku(rsResourceGoodsReDomain, storeDomain, rsSkuDomain);
        }
        if (!rsSkuDomain.getGoodsOrigin().equals("13")) {
            // empty if block
        }
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        storeDomain.setBizId(rsFlowData.getTenantCode() + rsSkuDomain.getSkuCode());
        boolean flag = this.sendEs(storeDomain);
        if ("13".equals(rsSkuDomain.getGoodsOrigin())) {
            this.logger.error("rs.RsFlowdataServiceImpl.ES.sku\u63a8\u9001\u6210\u529f >>> sku=", (Object)(rsSkuDomain.getSkuNo() + ",channelName=" + rsSkuDomain.getChannelName() + ",EsType=" + rsFlowData.getEsrequestType() + ",esStoreType=" + storeDomain.getBizType() + ",flag=" + flag));
        }
        if (!flag) {
            return flag;
        }
        storeDomain.setBizType("skuNo");
        storeDomain.setBizId(rsFlowData.getTenantCode() + rsSkuDomain.getGoodsType() + rsSkuDomain.getSkuNo());
        return flag;
    }

    private void optSkuEs(String esRequestType, RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain) {
        this.logger.error("rs.RsFlowdataServiceImpl.optSkuEs.params{}", (Object)("esRequestType:" + esRequestType + "," + "skuNo:" + rsSkuDomain.getSkuNo() + ",channelName" + rsSkuDomain.getChannelName() + "skuCode:" + rsSkuDomain.getSkuCode()));
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType(esRequestType);
        storeDomain.setBizType("sku");
        this.makeEsSku(rsResourceGoodsReDomain, storeDomain, rsSkuDomain);
        storeDomain.setTenantCode(rsSkuDomain.getTenantCode());
        storeDomain.setBizId(rsSkuDomain.getTenantCode() + rsSkuDomain.getSkuCode());
        boolean flag = this.sendEs(storeDomain);
        this.logger.error("rs.RsFlowdataServiceImpl.optSkuEs.params{}", (Object)("flag:" + flag));
    }

    private boolean sendEs(StoreDomain storeDomain) {
        if (null == storeDomain) {
            return false;
        }
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
        if (StringUtils.isEmpty((String)result) || "false".equals(result)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendEs.result", (Object)result);
            return false;
        }
        return true;
    }

    private boolean sendHtml(HtmlRelease htmlRelease) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
        try {
            this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
            return true;
        }
        catch (Exception e) {
            this.logger.error("rsFlowDataServiceImpl.sendHtml.ex", (Throwable)e);
            return false;
        }
    }

    private List<RsPropertiesValueBean> makeRsPropertiesValue(RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        List propertiesValueList = rsResourceGoodsReDomain.getRsPropertiesValueDomainList();
        if (ListUtil.isEmpty(propertiesValueList)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            map.put("tenantCode", rsResourceGoodsReDomain.getTenantCode());
            QueryResult<RsPropertiesValue> qlist = this.getRsPropertiesValueService().queryPropertiesValuePage(map);
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
                propertiesValueList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)qlist.getList()), RsPropertiesValueDomain.class);
            }
        }
        if (ListUtil.isEmpty(propertiesValueList)) {
            return null;
        }
        ArrayList<RsPropertiesValueBean> rsPropertiesValueBeanList = new ArrayList<RsPropertiesValueBean>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (RsPropertiesValueDomain rsPropertiesValueDomain : propertiesValueList) {
            RsPropertiesValueBean rsPropertiesValueBean = new RsPropertiesValueBean();
            rsPropertiesValueBeanList.add(rsPropertiesValueBean);
            try {
                BeanUtils.copyAllPropertys((Object)rsPropertiesValueBean, (Object)rsPropertiesValueDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank((String)rsPropertiesValueBean.getPropertiesName())) {
                map.put("propertiesCode", rsPropertiesValueBean.getPropertiesCode());
                map.put("tenantCode", rsPropertiesValueBean.getTenantCode());
                RsProperties rsProperties = this.getRsPropertiesService().getPropertiesByCode(map);
                if (null != rsProperties) {
                    rsPropertiesValueBean.setPropertiesName(rsProperties.getPropertiesName());
                }
            }
            rsPropertiesValueBean.setPropertiesValueName(rsPropertiesValueBean.getPropertiesValueValue());
            if (!"0".equals(rsPropertiesValueBean.getPropertiesValueType())) continue;
            map.put("propertiesOptionCode", rsPropertiesValueBean.getPropertiesValueValue());
            map.put("tenantCode", rsPropertiesValueBean.getTenantCode());
            RsPropertiesOption rsPropertiesOption = this.getRsPropertiesService().getPropertiesOptionByCode(map);
            if (null == rsPropertiesOption) continue;
            rsPropertiesValueBean.setPropertiesValueName(rsPropertiesOption.getPropertiesOptionName());
        }
        return rsPropertiesValueBeanList;
    }

    private boolean makeHtml(RsFlowdata rsFlowData, RsSkuDomain rsSkuDomain, Map<String, Object> htmlMap, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsFlowData || null == rsSkuDomain || null == rsResourceGoodsReDomain || null == htmlMap) {
            return false;
        }
        htmlMap.put("goods", rsResourceGoodsReDomain);
        htmlMap.put("goodsClassList", this.queryByClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode(), rsResourceGoodsReDomain.getTenantCode()));
        List<RsPropertiesValueBean> rsPropertiesValueBeanList = this.makeRsPropertiesValue(rsResourceGoodsReDomain);
        htmlMap.put("propertiesList", rsPropertiesValueBeanList);
        List<RsSpecValueDomain> rsSpecValueDomainList = rsResourceGoodsReDomain.getRsSpecValueDomainList();
        HashMap<String, ArrayList<String>> specValueMap = new HashMap<String, ArrayList<String>>();
        if (ListUtil.isEmpty(rsSpecValueDomainList)) {
            HashMap<String, Object> svMap = new HashMap<String, Object>();
            svMap.put("specValueBillno", rsSkuDomain.getGoodsCode());
            svMap.put("tenantCode", rsSkuDomain.getTenantCode());
            QueryResult<RsSpecValue> rsSpecValueListResult = this.getRsSpecValueService().querySpecValuePage(svMap);
            if (null != rsSpecValueListResult && null != rsSpecValueListResult.getList() && rsSpecValueListResult.getList().size() > 0) {
                for (RsSpecValue rsSpecValue : rsSpecValueListResult.getList()) {
                    String specName = rsSpecValue.getSpecName();
                    ArrayList<String> specValueList = (ArrayList<String>)specValueMap.get(specName);
                    if (null == specValueList || specValueList.size() == 0) {
                        specValueList = new ArrayList<String>();
                    }
                    specValueList.add(rsSpecValue.getSpecValueValue());
                    if (!StringUtils.isNotBlank((String)specName)) continue;
                    specValueMap.put(specName, specValueList);
                }
            } else {
                this.logger.error("rs.RsFlowdataServiceImpl.makeHtml.RsSpecValue", (Object)rsFlowData.getFdCode());
            }
        } else {
            for (RsSpecValueDomain rsSpecValueDomain : rsSpecValueDomainList) {
                String specName = rsSpecValueDomain.getSpecName();
                ArrayList<String> specValueList = (ArrayList<String>)specValueMap.get(specName);
                if (null == specValueList || specValueList.size() == 0) {
                    specValueList = new ArrayList<String>();
                }
                specValueList.add(rsSpecValueDomain.getSpecValueValue());
                if (!StringUtils.isNotBlank((String)specName)) continue;
                specValueMap.put(specName, specValueList);
            }
        }
        htmlMap.put("spec", specValueMap);
        htmlMap.put("rsSku", rsSkuDomain);
        List<RsGoodsRelDomain> rsGoodsRelList = rsResourceGoodsReDomain.getRsGoodsRelDomainList();
        ArrayList<RsSkuDomain> rsSkuList = new ArrayList<RsSkuDomain>();
        if (ListUtil.isNotEmpty(rsGoodsRelList)) {
            for (RsGoodsRelDomain rsGoodsRel : rsGoodsRelList) {
                QueryResult<RsSkuDomain> rsSkuList1;
                RsResourceGoodsReDomain rsResourceGoodsReDomain1 = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(this.getQueryParamMap("goodsCode,tenantCode,unwantedRelatedData", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode(), "1"}));
                if (null == rsResourceGoodsReDomain1 || null == (rsSkuList1 = this.rsFlowDataAssistService.querySkuPageAssist(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode()}))).getList() || rsSkuList1.getList().size() <= 0) continue;
                RsSkuDomain rsSku1 = (RsSkuDomain)rsSkuList1.getList().get(0);
                rsSkuList.add(rsSku1);
            }
        }
        htmlMap.put("rsSkuRel", rsSkuList);
        return true;
    }

    private boolean sendCentDisSku(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        if (null == rsFlowData) {
            return false;
        }
        List<DisChannel> centchannelList = this.queryCenterChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode());
        if (ListUtil.isNotEmpty(centchannelList)) {
            for (DisChannel disChannel : centchannelList) {
                this.sendDisSku(rsFlowData, disChannel, true);
            }
        }
        return true;
    }

    private boolean sendDisSku(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        List<DisChannel> channelList;
        if (null == rsFlowData) {
            return false;
        }
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isNotBlank((String)channelCode)) {
            DisChannel disChannel = this.getChannel(channelCode, rsFlowData.getTenantCode());
            if (null == disChannel) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.disChannel", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            if (DISCHANNEL_TYPE_THRID.equals(disChannel.getChannelType())) {
                return this.sendDisSku(rsFlowData, disChannel, false);
            }
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsSkuDomain rsSkuDomain = null;
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.info("rs.RsFlowdataServiceImpl.sendDisSku.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.info("rs.RsFlowdataServiceImpl.sendDisSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        if (!"skuinsert".equals(rsFlowData.getEsrequestType()) && !"edit".equals(rsFlowData.getEsrequestType()) || StringUtils.isBlank((String)rsFlowData.getChannelCode())) {
            // empty if block
        }
        if (ListUtil.isEmpty(channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getChannelCode(), rsFlowData.getTenantCode()))) {
            if (("skuinsert".equals(rsFlowData.getEsrequestType()) || "edit".equals(rsFlowData.getEsrequestType())) && StringUtils.isBlank((String)rsFlowData.getChannelCode()) && StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getMemberMcode()) && !rsResourceGoodsReDomain.getMemberMcode().equals(rsFlowData.getMemberCode())) {
                channelList = this.queryChannel(rsResourceGoodsReDomain.getMemberMcode(), rsFlowData.getChannelCode(), rsFlowData.getTenantCode());
            }
            if (ListUtil.isEmpty(channelList)) {
                this.logger.info("rs.RsFlowdataServiceImpl.sendDisSku.channelList.null.\u4e0b\u7ea7\u6e20\u9053", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return true;
            }
        }
        String skuOldcode = rsFlowData.getFdBizcode();
        String tenantCode = rsFlowData.getTenantCode();
        List<RsSenddata> skursSenddataList = null;
        if ("skudelete".equals(rsFlowData.getEsrequestType())) {
            skursSenddataList = this.getRsResourceGoodsService().deleteDisSku(skuOldcode, null, tenantCode);
        } else if ("skuinsert".equals(rsFlowData.getEsrequestType())) {
            List<DisRsSkuDomain> disRsSkuList = this.getDisRsSkuList(rsFlowData, channelList);
            if (ListUtil.isEmpty(disRsSkuList)) {
                if (null != disRsSkuList) {
                    this.logger.info("rs.RsFlowdataServiceImpl.sendDisSku.disRsSkuList1", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                    return true;
                }
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.disRsSkuList", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            skursSenddataList = this.getRsResourceGoodsService().saveDisSku(disRsSkuList);
        } else if ("edit".equals(rsFlowData.getEsrequestType())) {
            List<DisRsSkuDomain> disRsSkuList = this.getDisRsSkuList(rsFlowData, channelList);
            if (ListUtil.isEmpty(disRsSkuList)) {
                this.logger.info("rs.RsFlowdataServiceImpl.sendDisSku.disRsSkuList2", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return null != disRsSkuList;
            }
            skursSenddataList = this.getRsResourceGoodsService().saveDisSkuEdit(disRsSkuList);
        } else if ("skudeleteop".equals(rsFlowData.getEsrequestType()) || "skuadd".equals(rsFlowData.getEsrequestType())) {
            List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
            if (ListUtil.isEmpty(rsSkuDomainList)) {
                this.logger.info("rs.RsFlowdataServiceImpl.sendDisSku.disRsSkuList3", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                rsSkuDomain = rsSkuDomain2;
                break;
            }
            if (null == rsSkuDomain) {
                rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            }
            if ("skuadd".equals(rsFlowData.getEsrequestType())) {
                map.put("dataState", ResourcesConstants.GOODS_DATA_STATE_3);
            } else {
                map.put("dataState", rsFlowData.getFdState());
            }
            skursSenddataList = this.getRsResourceGoodsService().updateDisCannelSkuState(map);
        } else if ("skudown".equals(rsFlowData.getEsrequestType())) {
            skursSenddataList = this.getRsResourceGoodsService().updateDisCannelSku(skuOldcode, null, tenantCode);
        }
        if (ListUtil.isNotEmpty(skursSenddataList)) {
            rsSenddataList.addAll(skursSenddataList);
        }
        return true;
    }

    private List<DisRsSkuDomain> getDisRsSkuList(RsFlowdata rsFlowData, List<DisChannel> channelList) {
        RsResourceGoodsDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        if (null == rsResourceGoodsReDomain) {
            this.logger.error("rs.RsFlowdataServiceImpl.getDisRsSkuList.rsResourceGoodsReDomain", (Object)(rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return null;
        }
        List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
        if (ListUtil.isEmpty(rsSkuDomainList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.getDisRsSkuList.rsResourceGoodsReDomain", (Object)(rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsSkuDomain rsSkuDomain = null;
        for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
            if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
            rsSkuDomain = rsSkuDomain2;
            break;
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        }
        List<DisRsSkuDomain> disRsSkuList = this.makeDisSku((RsResourceGoodsReDomain)rsResourceGoodsReDomain, rsSkuDomain, channelList, rsFlowData.getEsrequestType());
        return disRsSkuList;
    }

    private boolean sendDisBrand(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        DisChannel disChannel;
        if (null == rsFlowData) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisBrand.", (Object)("param is null " + rsSenddataList));
            return false;
        }
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isNotBlank((String)channelCode) && null == (disChannel = this.getChannel(channelCode, rsFlowData.getTenantCode()))) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisBrand.disChannel", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return false;
        }
        List<DisChannel> channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getChannelCode(), rsFlowData.getTenantCode());
        if (ListUtil.isEmpty(channelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisBrand.channelList ", (Object)(rsFlowData.getMemberCode() + "=:=" + rsFlowData.getChannelCode() + "=:=" + rsFlowData.getTenantCode()));
            return true;
        }
        String tenantCode = rsFlowData.getTenantCode();
        List<RsSenddata> senddataList = null;
        if ("delete".equals(rsFlowData.getEsrequestType())) {
            RsBrandDomain rsBrandDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsBrandDomain = (RsBrandDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsBrandDomain.class);
            }
            if (null == rsBrandDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisBrand.delrsBrandDomain", (Object)(rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            senddataList = this.getRsBrandService().deleteBrandByCode(rsBrandDomain.getBrandCode(), null, tenantCode);
        } else if ("add".equals(rsFlowData.getEsrequestType())) {
            List<RsBrandDomain> rsBrandDomains = this.getDisRsBrandList(rsFlowData, channelList);
            if (ListUtil.isEmpty(rsBrandDomains)) {
                if (null != rsBrandDomains) {
                    this.logger.error("rs.RsFlowdataServiceImpl.sendDisBrand.addrsBrandDomains ", (Object)(JsonUtil.buildNormalBinder().toJson((Object)rsFlowData) + "=:=" + JsonUtil.buildNormalBinder().toJson(channelList)));
                    return true;
                }
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisBrand.addrsBrandDomains.null", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            senddataList = this.getRsBrandService().saveBatchDisBrand(rsBrandDomains);
        } else if ("update".equals(rsFlowData.getEsrequestType())) {
            List<RsBrandDomain> rsBrandDomains = this.getDisRsBrandList(rsFlowData, channelList);
            if (ListUtil.isEmpty(rsBrandDomains)) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisBrand.addrsBrandDomains.2", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return true;
            }
            senddataList = this.getRsBrandService().saveBatchDisBrand(rsBrandDomains);
        }
        if (ListUtil.isNotEmpty(senddataList)) {
            rsSenddataList.addAll(senddataList);
        }
        return true;
    }

    private List<RsGoodsClassDomain> getDisRsGoodsClassList(RsFlowdata rsFlowData, List<DisChannel> channelList, String type) {
        QueryResult<RsGoodsClass> queryResult;
        RsGoodsClassDomain rsGoodsClassDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsGoodsClassDomain = (RsGoodsClassDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsGoodsClassDomain.class);
        }
        if (null == rsGoodsClassDomain) {
            this.logger.error("rs.RsFlowdataServiceImpl.getDisRsGoodsClassList.rsGoodsClassDomain", (Object)(rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return null;
        }
        if (!this.checkChannelEnd(rsGoodsClassDomain.getChannelCode(), rsGoodsClassDomain.getTenantCode(), channelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.getDisRsGoodsClassList.checkChannelEnd");
            return null;
        }
        String channelCodeStr = "";
        if ("add".equals(type) && null != (queryResult = this.getRsGoodsClassService().queryGoodsClassPage(this.getQueryParamMap("goodsClassCode,tenantCode", new Object[]{rsGoodsClassDomain.getGoodsClassCode(), rsGoodsClassDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            for (RsGoodsClass rsGoodsClass : queryResult.getList()) {
                if (!StringUtils.isNotBlank((String)rsGoodsClass.getChannelCode())) continue;
                channelCodeStr = channelCodeStr + rsGoodsClass.getChannelCode() + ",";
            }
        }
        ArrayList<RsGoodsClassDomain> disList = new ArrayList<RsGoodsClassDomain>();
        for (DisChannel disChannel : channelList) {
            if (channelCodeStr.contains(disChannel.getChannelCode())) continue;
            RsGoodsClassDomain rsGoodsClassDomain1 = this.makeRsGoodsClass(rsGoodsClassDomain, disChannel);
            disList.add(rsGoodsClassDomain1);
        }
        return disList;
    }

    private RsGoodsClassDomain makeRsGoodsClass(RsGoodsClassDomain rsGoodsClassDomain, DisChannel disChannel) {
        if (null == rsGoodsClassDomain || null == disChannel) {
            return null;
        }
        RsGoodsClassDomain goodsClassDomain = new RsGoodsClassDomain();
        try {
            BeanUtils.copyAllPropertys((Object)goodsClassDomain, (Object)rsGoodsClassDomain);
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeRsGoodsClass.e", (Throwable)e);
            return null;
        }
        goodsClassDomain.setChannelCode(disChannel.getChannelCode());
        goodsClassDomain.setChannelName(disChannel.getChannelName());
        goodsClassDomain.setMemberCode(disChannel.getMemberCode());
        goodsClassDomain.setMemberName(disChannel.getMemberName());
        goodsClassDomain.setGoodsClassNo(null);
        goodsClassDomain.setGoodsClassId(null);
        goodsClassDomain.setGoodsClassOldno(rsGoodsClassDomain.getGoodsClassNo());
        return goodsClassDomain;
    }

    private List<RsClasstreeDomain> getDisRsClasstreeList(RsFlowdata rsFlowData, List<DisChannel> channelList) {
        RsClasstreeDomain rsClasstreeDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsClasstreeDomain = (RsClasstreeDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsClasstreeDomain.class);
        }
        if (null == rsClasstreeDomain) {
            this.logger.error("rs.RsFlowdataServiceImpl.getDisRsClasstreeList.rsClasstreeDomain", (Object)(rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return null;
        }
        if (!this.checkChannelEnd(rsClasstreeDomain.getChannelCode(), rsClasstreeDomain.getTenantCode(), channelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.getDisRsClasstreeList.checkChannelEnd");
            return null;
        }
        ArrayList<RsClasstreeDomain> disList = new ArrayList<RsClasstreeDomain>();
        for (DisChannel disChannel : channelList) {
            RsClasstreeDomain rsClasstreeDomain1 = this.makeRsClasstree(rsClasstreeDomain, disChannel);
            disList.add(rsClasstreeDomain1);
        }
        return disList;
    }

    private RsClasstreeDomain makeRsClasstree(RsClasstreeDomain rsClasstreeDomain, DisChannel disChannel) {
        if (null == rsClasstreeDomain || null == disChannel) {
            return null;
        }
        RsClasstreeDomain classtreeDomain = new RsClasstreeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)classtreeDomain, (Object)rsClasstreeDomain);
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeRsClasstree.e", (Throwable)e);
            return null;
        }
        classtreeDomain.setChannelCode(disChannel.getChannelCode());
        classtreeDomain.setChannelName(disChannel.getChannelName());
        classtreeDomain.setMemberCode(disChannel.getMemberCode());
        classtreeDomain.setMemberName(disChannel.getMemberName());
        classtreeDomain.setClasstreeNo(null);
        classtreeDomain.setClasstreeId(null);
        classtreeDomain.setClasstreeOldno(rsClasstreeDomain.getClasstreeNo());
        return classtreeDomain;
    }

    private List<RsBrandDomain> getDisRsBrandList(RsFlowdata rsFlowData, List<DisChannel> channelList) {
        RsBrandDomain rsBrandDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsBrandDomain = (RsBrandDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsBrandDomain.class);
        }
        if (null == rsBrandDomain) {
            this.logger.error("rs.RsFlowdataServiceImpl.getDisRsBrandList.rsBrandDomain", (Object)(rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return null;
        }
        if (!this.checkChannelEnd(rsBrandDomain.getChannelCode(), rsBrandDomain.getTenantCode(), channelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisSku.checkChannelEnd");
            return null;
        }
        ArrayList<RsBrandDomain> disList = new ArrayList<RsBrandDomain>();
        for (DisChannel disChannel : channelList) {
            RsBrandDomain rsBrandDomain1 = this.makeRsBrand(rsBrandDomain, disChannel);
            disList.add(rsBrandDomain1);
        }
        return disList;
    }

    private RsBrandDomain makeRsBrand(RsBrandDomain rsBrandDomain, DisChannel disChannel) {
        if (null == rsBrandDomain || null == disChannel) {
            return null;
        }
        RsBrandDomain reBrand = new RsBrandDomain();
        try {
            BeanUtils.copyAllPropertys((Object)reBrand, (Object)rsBrandDomain);
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeRsBrand.e", (Throwable)e);
            return null;
        }
        reBrand.setChannelCode(disChannel.getChannelCode());
        reBrand.setChannelName(disChannel.getChannelName());
        reBrand.setMemberCode(disChannel.getMemberCode());
        reBrand.setMemberName(disChannel.getMemberName());
        reBrand.setBrandNo(null);
        reBrand.setBrandId(null);
        reBrand.setBrandOldno(rsBrandDomain.getBrandNo());
        return reBrand;
    }

    private List<DisChannel> queryCenterChannel(String memberCode, String tenantCode) {
        return DisUtil.getMapListJson((String)"DisChannel-channelMemcode", (String)(memberCode + "-" + DISCHANNEL_SALE + "-" + tenantCode), DisChannel.class);
    }

    private List<DisChannel> queryThirdChannel(String memberCode, String tenantCode) {
        return DisUtil.getMapListJson((String)"DisChannel-thirdmemberCode", (String)(memberCode + "-" + DISCHANNEL_TYPE_THRID + "-" + tenantCode), DisChannel.class);
    }

    private List<DisChannel> queryChannel(String memberCode, String channelCode, String tenantCode) {
        return this.queryChannel(memberCode, channelCode, tenantCode, false);
    }

    private List<DisChannel> queryChannel(String memberCode, String channelCode, String tenantCode, boolean one) {
        List memchannelList1;
        DisChannel memchannel;
        List memchannelList;
        if (StringUtils.isBlank((String)memberCode)) {
            this.logger.error("rs.RsFlowdataServiceImpl.queryChannel.param.", (Object)" is null");
            return null;
        }
        ArrayList<DisChannel> channelList = new ArrayList<DisChannel>();
        if (StringUtils.isNotBlank((String)channelCode)) {
            List memchannelList2;
            String key = "DisChannel-pCode";
            if (one) {
                key = this.cacheonePcode;
            }
            if (ListUtil.isNotEmpty((Collection)(memchannelList2 = DisUtil.getMapListJson((String)key, (String)(channelCode + "-" + tenantCode), DisChannel.class)))) {
                channelList.addAll(memchannelList2);
                return channelList;
            }
            DisChannel disChannel = this.getChannel(channelCode, tenantCode);
            if (null == disChannel) {
                this.logger.error("rs.RsFlowdataServiceImpl.queryChannel.disChannel", (Object)(channelCode + "-" + tenantCode));
                return null;
            }
            if (StringUtils.isNotBlank((String)disChannel.getChannelPcode()) && !"-1".equals(disChannel.getChannelPcode())) {
                return null;
            }
        }
        if (ListUtil.isNotEmpty((Collection)(memchannelList = DisUtil.getMapListJson((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_SALE + "-" + tenantCode), DisChannel.class)))) {
            if (StringUtils.isBlank((String)channelCode)) {
                for (DisChannel disChannel : memchannelList) {
                    if (!StringUtils.isBlank((String)disChannel.getChannelPcode()) && !"-1".equals(disChannel.getChannelPcode())) continue;
                    channelList.add(disChannel);
                }
            } else {
                channelList.addAll(memchannelList);
            }
        }
        if (null != (memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-memberCcode", (String)(memberCode + "-" + DISCHANNEL_CON + "-" + tenantCode), DisChannel.class)) && (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)memchannel.getChannelPcode()) || "-1".equals(memchannel.getChannelPcode()))) {
            channelList.add(memchannel);
        }
        if (ListUtil.isNotEmpty((Collection)(memchannelList1 = DisUtil.getMapListJson((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_BUS + "-" + tenantCode), DisChannel.class)))) {
            if (StringUtils.isBlank((String)channelCode)) {
                for (DisChannel disChannel : memchannelList1) {
                    if (!StringUtils.isBlank((String)disChannel.getChannelPcode()) && !"-1".equals(disChannel.getChannelPcode())) continue;
                    channelList.add(disChannel);
                }
            } else {
                channelList.addAll(memchannelList1);
            }
        }
        return channelList;
    }

    private DisChannel getChannel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisChannel memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        return memchannel;
    }

    private void makeInfo(RsSkuDomain rsSkuDomain) {
        List disFile;
        String[] skuShownoS;
        if (null == rsSkuDomain) {
            return;
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getChannelCode())) {
            return;
        }
        String showInfo = DisUtil.getMap((String)"DisDgoodsuplist-No-channelCode", (String)(rsSkuDomain.getChannelCode() + "-1-" + rsSkuDomain.getSkuNo() + "-" + rsSkuDomain.getTenantCode()));
        if (StringUtils.isNotBlank((String)showInfo) && null != (skuShownoS = showInfo.split("\\|")) && skuShownoS.length > 0 && StringUtils.isNotBlank((String)skuShownoS[0])) {
            rsSkuDomain.setSkuShowno(skuShownoS[0]);
        }
        if (ListUtil.isNotEmpty((Collection)(disFile = DisUtil.getMapListJson((String)"DisDgoodsuplistFile-No-channelCode", (String)(rsSkuDomain.getChannelCode() + "-1-" + rsSkuDomain.getSkuNo() + "-" + rsSkuDomain.getTenantCode()), RsGoodsFileDomain.class)))) {
            ArrayList<RsGoodsFileDomain> goodsFile = new ArrayList<RsGoodsFileDomain>();
            for (RsGoodsFileDomain rsGoodsFileDomain1 : disFile) {
                RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFileDomain1);
                    rsGoodsFileDomain.setGoodsFileCode(null);
                    goodsFile.add(rsGoodsFileDomain);
                }
                catch (Exception exception) {}
            }
            rsSkuDomain.setRsGoodsFileDomainList(goodsFile);
        }
    }

    private void setShowInfo(RsResourceGoodsDomain rsResourceGoodsDomain) {
        List disFile;
        if (null == rsResourceGoodsDomain) {
            return;
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getChannelCode())) {
            return;
        }
        String showInfo = DisUtil.getMap((String)"DisDgoodsuplist-No-channelCode", (String)(rsResourceGoodsDomain.getChannelCode() + "-0-" + rsResourceGoodsDomain.getGoodsNo() + "-" + rsResourceGoodsDomain.getTenantCode()));
        if (StringUtils.isNotBlank((String)showInfo)) {
            String[] skuShownoS = showInfo.split("\\|");
            if (null != skuShownoS && skuShownoS.length > 1 && StringUtils.isNotBlank((String)skuShownoS[1])) {
                rsResourceGoodsDomain.setGoodsShowno(skuShownoS[1]);
            }
            if (null != skuShownoS && skuShownoS.length > 2 && StringUtils.isNotBlank((String)skuShownoS[2])) {
                rsResourceGoodsDomain.setGoodsShowname(skuShownoS[2]);
            }
            if (null != skuShownoS && skuShownoS.length > 3 && StringUtils.isNotBlank((String)skuShownoS[3])) {
                rsResourceGoodsDomain.setClasstreeShopcode(skuShownoS[3]);
            }
            if (null != skuShownoS && skuShownoS.length > 4 && StringUtils.isNotBlank((String)skuShownoS[4])) {
                rsResourceGoodsDomain.setClasstreeShopname(skuShownoS[4]);
            }
        }
        if (ListUtil.isNotEmpty((Collection)(disFile = DisUtil.getMapListJson((String)"DisDgoodsuplistFile-No-channelCode", (String)(rsResourceGoodsDomain.getChannelCode() + "-0-" + rsResourceGoodsDomain.getGoodsNo() + "-" + rsResourceGoodsDomain.getTenantCode()), RsGoodsFileDomain.class)))) {
            ArrayList<RsGoodsFileDomain> rsGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
            for (RsGoodsFileDomain rsGoodsFileDomain1 : disFile) {
                RsGoodsFileDomain rsGoodsFileDomain2 = new RsGoodsFileDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain2, (Object)rsGoodsFileDomain1);
                    rsGoodsFileDomain2.setGoodsFileCode(null);
                    rsGoodsFileDomainList.add(rsGoodsFileDomain2);
                }
                catch (Exception exception) {}
            }
            rsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileDomainList);
        }
    }

    private boolean sendDisSku(RsFlowdata rsFlowData, DisChannel disChannel, boolean centFlag) {
        List<RsSkuDomain> rsSkuDomainList;
        if (null == rsFlowData || null == disChannel) {
            return false;
        }
        String apiCode = "dis.channelsendBase.sendChannelsendBatch";
        DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
        String channelsendTxt = "";
        HashMap<String, BaseDomain> datamap = new HashMap<String, BaseDomain>();
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        RsSkuDomain rsSkuDomain = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.rsSkuDomain", (Object)((Object)map).toString());
                return true;
            }
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return true;
            }
        }
        if (centFlag && null != rsResourceGoodsReDomain) {
            this.setShowInfo(rsResourceGoodsReDomain);
        }
        if ("delete".equals(rsFlowData.getEsrequestType()) || "skudelete".equals(rsFlowData.getEsrequestType()) || "deleteop".equals(rsFlowData.getEsrequestType()) || "skudeleteop".equals(rsFlowData.getEsrequestType())) {
            rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
            if (ListUtil.isEmpty(rsSkuDomainList)) {
                return false;
            }
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                rsSkuDomain = rsSkuDomain2;
                break;
            }
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSkudel.rsSkuDomain");
                return false;
            }
            datamap.put("rsSku", rsSkuDomain);
            if (centFlag && null != rsSkuDomain) {
                this.makeInfo(rsSkuDomain);
            }
            datamap.put("rsResourceGoods", rsResourceGoodsReDomain);
            channelsendTxt = JsonUtil.buildNormalBinder().toJson(datamap);
        } else {
            if (null == rsResourceGoodsReDomain) {
                return false;
            }
            rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
            if (ListUtil.isEmpty(rsSkuDomainList)) {
                return false;
            }
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                rsSkuDomain = rsSkuDomain2;
                break;
            }
            if (null == rsSkuDomain) {
                rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            }
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.rsSkuDomain", (Object)((Object)map).toString());
                return false;
            }
            if (centFlag && null != rsSkuDomain) {
                this.makeInfo(rsSkuDomain);
            }
            datamap.put("rsSku", rsSkuDomain);
            DisDgoods disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, rsSkuDomain, disChannel, rsFlowData.getEsrequestType());
            if (null == disDgoods) {
                this.logger.info("rs.RsFlowdataServiceImpl.sendDisSku.disDgoods", (Object)(rsSkuDomain.getSkuCode() + "=" + disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
                return true;
            }
            datamap.put("rsResourceGoods", rsResourceGoodsReDomain);
            channelsendTxt = JsonUtil.buildNormalBinder().toJson(datamap);
        }
        disChannelsendDomain.setChannelCode(disChannel.getChannelCode());
        disChannelsendDomain.setChannelsendDir(rsFlowData.getEsrequestType());
        disChannelsendDomain.setChannelsendTxt(channelsendTxt);
        disChannelsendDomain.setChannelsendType("RsSku");
        disChannelsendDomain.setTenantCode(rsFlowData.getTenantCode());
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        disChannelsendDomainList.add(disChannelsendDomain);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(disChannelsendDomainList));
        this.internalInvoke(apiCode, paramMap);
        return true;
    }

    private boolean sendDisGoods(RsFlowdata rsFlowData, DisChannel disChannel, boolean centFlag) {
        if (null == rsFlowData || null == disChannel) {
            return false;
        }
        String apiCode = "dis.channelsendBase.sendChannelsendBatch";
        DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
        String channelsendTxt = rsFlowData.getFdBizcodestr();
        if ("delete".equals(rsFlowData.getEsrequestType()) || "skudelete".equals(rsFlowData.getEsrequestType()) || "deleteop".equals(rsFlowData.getEsrequestType()) || "skudeleteop".equals(rsFlowData.getEsrequestType())) {
            channelsendTxt = rsFlowData.getFdBizcodestr();
        } else {
            List<RsSkuDomain> rsSkuDomainList;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizcode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
            }
            if (null == rsResourceGoodsReDomain) {
                rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            }
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return false;
            }
            if (centFlag) {
                this.setShowInfo(rsResourceGoodsReDomain);
            }
            if (ListUtil.isEmpty(rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList())) {
                return false;
            }
            ArrayList<RsSkuDomain> disRsSkuDomainList = new ArrayList<RsSkuDomain>();
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                DisDgoods disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, rsSkuDomain2, disChannel, rsFlowData.getEsrequestType());
                if (null == disDgoods) {
                    this.logger.info("rs.RsFlowdataServiceImpl.sendDisGoods.rsSkuDomain2", (Object)(rsSkuDomain2.getSkuCode() + "=" + disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
                    continue;
                }
                if (centFlag) {
                    this.makeInfo(rsSkuDomain2);
                }
                disRsSkuDomainList.add(rsSkuDomain2);
            }
            if (ListUtil.isEmpty(disRsSkuDomainList)) {
                return true;
            }
            rsResourceGoodsReDomain.setRsSkuDomainList(disRsSkuDomainList);
            channelsendTxt = JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain);
        }
        disChannelsendDomain.setChannelCode(disChannel.getChannelCode());
        disChannelsendDomain.setChannelsendDir(rsFlowData.getEsrequestType());
        disChannelsendDomain.setChannelsendTxt(channelsendTxt);
        disChannelsendDomain.setChannelsendType("RsResourceGoods");
        disChannelsendDomain.setTenantCode(rsFlowData.getTenantCode());
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        disChannelsendDomainList.add(disChannelsendDomain);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(disChannelsendDomainList));
        this.internalInvoke(apiCode, paramMap);
        return true;
    }

    private boolean sendCentDisGoods(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        if (null == rsFlowData || null == rsSenddataList) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsFlowData");
            return false;
        }
        List<DisChannel> centchannelList = this.queryCenterChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode());
        if (ListUtil.isNotEmpty(centchannelList)) {
            for (DisChannel disChannel : centchannelList) {
                this.sendDisGoods(rsFlowData, disChannel, true);
            }
        }
        return true;
    }

    private boolean sendDisGoodsSingle(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        if (null == rsFlowData || null == rsSenddataList) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsFlowData");
            return false;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        if (null == rsResourceGoodsReDomain) {
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        }
        if (null == rsResourceGoodsReDomain) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
            return false;
        }
        DisChannel disChannel = null;
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isNotBlank((String)channelCode)) {
            disChannel = this.getChannel(channelCode, rsFlowData.getTenantCode());
            if (null == disChannel) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.disChannel", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            if (DISCHANNEL_TYPE_THRID.equals(disChannel.getChannelType())) {
                return this.sendDisGoods(rsFlowData, disChannel, false);
            }
        }
        DisDgoods disDgoods = (DisDgoods)DisUtil.getMapJson((String)"DisDgoods-channelCode", (String)(channelCode + "-" + rsFlowData.getTenantCode()), DisDgoods.class);
        String goodsOldcode = rsFlowData.getFdBizcode();
        List<RsSenddata> goodsrsSenddataList = null;
        if ("delete".equals(rsFlowData.getEsrequestType())) {
            goodsrsSenddataList = this.getRsResourceGoodsService().deleteDisGoods(goodsOldcode, null, rsFlowData.getTenantCode());
        } else if ("insert".equals(rsFlowData.getEsrequestType())) {
            ArrayList<DisRsResourceGoodsDomain> disRsResourceGoodsList = new ArrayList<DisRsResourceGoodsDomain>();
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoodsReDomain, disChannel, disDgoods, true);
            disRsResourceGoodsList.add(disRsResourceGoodsDomain);
            if (ListUtil.isNotEmpty(disRsResourceGoodsList)) {
                goodsrsSenddataList = this.getRsResourceGoodsService().saveDisResourceGoods(disRsResourceGoodsList);
            }
        }
        if (ListUtil.isNotEmpty(goodsrsSenddataList)) {
            rsSenddataList.addAll(goodsrsSenddataList);
        }
        if (rsResourceGoodsReDomain != null && rsSenddataList.size() > 0) {
            this.logger.error("rs.RsFlowdataServiceImpl.\u5546\u54c1\u6e20\u9053\u540c\u6b65 >>> skuNo=", (Object)(rsResourceGoodsReDomain.getGoodsShowno() + ",channelName=" + rsResourceGoodsReDomain.getChannelName() + ",channelCode=" + rsResourceGoodsReDomain.getChannelCode() + ",EsType=" + rsFlowData.getEsrequestType() + ",sendSize=" + rsSenddataList.size()));
        }
        return true;
    }

    private boolean sendDisGoods(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        List<DisChannel> channelList;
        if (null == rsFlowData || null == rsSenddataList) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsFlowData");
            return false;
        }
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isNotBlank((String)channelCode)) {
            DisChannel disChannel = this.getChannel(channelCode, rsFlowData.getTenantCode());
            if (null == disChannel) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.disChannel", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            if (DISCHANNEL_TYPE_THRID.equals(disChannel.getChannelType())) {
                return this.sendDisGoods(rsFlowData, disChannel, false);
            }
        }
        RsResourceGoodsDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isBlank((String)rsFlowData.getChannelCode()) && "insert".equals(rsFlowData.getEsrequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizcode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
            }
            if (null == rsResourceGoodsReDomain) {
                rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            }
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return false;
            }
        }
        if (rsResourceGoodsReDomain != null && "13".equals(rsResourceGoodsReDomain.getGoodsOrigin())) {
            this.logger.error("rs.RsFlowdataServiceImpl.customer\u5546\u54c1\u5ba2\u6237\u6e20\u9053\u540c\u6b65 >>> skuNo=", (Object)(rsResourceGoodsReDomain.getGoodsShowno() + ",channelName=" + rsResourceGoodsReDomain.getChannelName() + ",EsType=" + rsFlowData.getEsrequestType()));
        }
        if (ListUtil.isEmpty(channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getChannelCode(), rsFlowData.getTenantCode())) && StringUtils.isBlank((String)rsFlowData.getChannelCode()) && "insert".equals(rsFlowData.getEsrequestType()) && StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getMemberMcode()) && !rsFlowData.getMemberCode().equals(rsResourceGoodsReDomain.getMemberMcode()) && ListUtil.isEmpty(channelList = this.queryChannel(rsResourceGoodsReDomain.getMemberMcode(), rsFlowData.getChannelCode(), rsFlowData.getTenantCode()))) {
            this.logger.error("rs.RsFlowdataServiceImpl.\u5546\u54c1\u6e20\u9053\u540c\u6b65.channelList.null >>> skuNo=", (Object)(rsResourceGoodsReDomain.getGoodsShowno() + ",channelName=" + rsResourceGoodsReDomain.getChannelName() + ",memberMcode=" + rsResourceGoodsReDomain.getMemberMcode() + ",EsType=" + rsFlowData.getEsrequestType() + ",sendSize=" + rsSenddataList.size()));
            return true;
        }
        String goodsOldcode = rsFlowData.getFdBizcode();
        String tenantCode = rsFlowData.getTenantCode();
        List<RsSenddata> goodsrsSenddataList = null;
        if ("delete".equals(rsFlowData.getEsrequestType())) {
            goodsrsSenddataList = this.getRsResourceGoodsService().deleteDisGoods(goodsOldcode, null, rsFlowData.getTenantCode());
        } else if ("insert".equals(rsFlowData.getEsrequestType())) {
            List<DisRsResourceGoodsDomain> disRsResourceGoodsList;
            if (null == rsResourceGoodsReDomain) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("goodsCode", rsFlowData.getFdBizcode());
                map.put("tenantCode", rsFlowData.getTenantCode());
                if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                    rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
                }
                if (null == rsResourceGoodsReDomain) {
                    rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
                }
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                    return false;
                }
            }
            if (ListUtil.isNotEmpty(disRsResourceGoodsList = this.makeDisGoods((RsResourceGoodsReDomain)rsResourceGoodsReDomain, channelList, rsFlowData.getEsrequestType()))) {
                goodsrsSenddataList = this.getRsResourceGoodsService().saveDisResourceGoods(disRsResourceGoodsList);
            }
        } else if ("edit".equals(rsFlowData.getEsrequestType())) {
            List<DisRsResourceGoodsDomain> disRsResourceGoodsList;
            if (null == rsResourceGoodsReDomain) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("goodsCode", rsFlowData.getFdBizcode());
                map.put("tenantCode", rsFlowData.getTenantCode());
                if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                    rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
                }
                if (null == rsResourceGoodsReDomain) {
                    rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
                }
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                    return false;
                }
            }
            if (ListUtil.isNotEmpty(disRsResourceGoodsList = this.makeDisGoods((RsResourceGoodsReDomain)rsResourceGoodsReDomain, channelList, rsFlowData.getEsrequestType()))) {
                goodsrsSenddataList = this.getRsResourceGoodsService().updateDisResourceGoods(disRsResourceGoodsList);
            } else {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods", (Object)"disRsResourceGoodsList is null");
            }
        } else if ("deleteop".equals(rsFlowData.getEsrequestType()) || "add".equals(rsFlowData.getEsrequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizcode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            rsResourceGoodsReDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
            }
            if (null == rsResourceGoodsReDomain) {
                rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            }
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return false;
            }
            if ("add".equals(rsFlowData.getEsrequestType())) {
                map.put("dataState", ResourcesConstants.GOODS_DATA_STATE_3);
            } else {
                map.put("dataState", rsFlowData.getFdState());
            }
            goodsrsSenddataList = this.getRsResourceGoodsService().updateDisCannelGoodsState(map);
        } else if ("down".equals(rsFlowData.getEsrequestType())) {
            goodsrsSenddataList = this.getRsResourceGoodsService().updateDisCannelGoods(goodsOldcode, null, tenantCode);
        }
        if (ListUtil.isNotEmpty(goodsrsSenddataList)) {
            rsSenddataList.addAll(goodsrsSenddataList);
        }
        if (rsResourceGoodsReDomain != null && rsSenddataList.size() > 0) {
            this.logger.error("rs.RsFlowdataServiceImpl.\u5546\u54c1\u6e20\u9053\u540c\u6b65 >>> skuNo=", (Object)(rsResourceGoodsReDomain.getGoodsShowno() + ",channelName=" + rsResourceGoodsReDomain.getChannelName() + ",channelCode=" + rsResourceGoodsReDomain.getChannelCode() + ",EsType=" + rsFlowData.getEsrequestType() + ",sendSize=" + rsSenddataList.size()));
        }
        return true;
    }

    private boolean checkChannelEnd(String channelCode, String tenantCode, List<DisChannel> channelList) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode) || ListUtil.isEmpty(channelList)) {
            return true;
        }
        DisChannel oldDisChannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        if (StringUtils.isNotBlank((String)oldDisChannel.getChannelPcode()) && !"-1".equals(oldDisChannel.getChannelPcode())) {
            return true;
        }
        if (null != oldDisChannel && "0".equals(oldDisChannel.getChannelType()) && "2".equals(oldDisChannel.getChannelSort())) {
            return false;
        }
        for (DisChannel toDisChannel : channelList) {
            if (null == toDisChannel.getMemberCcode()) {
                toDisChannel.setMemberCcode("");
            }
            if (null == oldDisChannel.getMemberCcode()) {
                oldDisChannel.setMemberCcode("");
            }
            if (null == toDisChannel.getMemberCode()) {
                toDisChannel.setMemberCode("");
            }
            if (null == oldDisChannel.getMemberCode()) {
                oldDisChannel.setMemberCode("");
            }
            if ("0".equals(oldDisChannel.getChannelType()) && "0".equals(toDisChannel.getChannelSort()) && oldDisChannel.getMemberMcode().equals(toDisChannel.getMemberCode()) && oldDisChannel.getMemberCcode().equals(toDisChannel.getMemberCcode()) && oldDisChannel.getMemberMcode().equals(toDisChannel.getMemberMcode())) {
                return false;
            }
            if ("1".equals(oldDisChannel.getChannelType()) && "1".equals(toDisChannel.getChannelSort()) && oldDisChannel.getMemberMcode().equals(toDisChannel.getMemberCode()) && oldDisChannel.getMemberCcode().equals(toDisChannel.getMemberCcode())) {
                return false;
            }
            if (!"0".equals(oldDisChannel.getChannelType()) || !"1".equals(toDisChannel.getChannelSort()) && !"2".equals(toDisChannel.getChannelSort()) || !oldDisChannel.getMemberCode().equals(toDisChannel.getMemberCode()) || !oldDisChannel.getMemberCcode().equals(toDisChannel.getMemberCcode())) continue;
            return false;
        }
        return true;
    }

    private List<DisRsSkuDomain> makeDisSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, List<DisChannel> channelList, String esrequestType) {
        if (null == rsResourceGoodsReDomain || null == rsSkuDomain || ListUtil.isEmpty(channelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisSku.makeDisSku");
            return null;
        }
        if (!this.checkChannelEnd(rsResourceGoodsReDomain.getChannelCode(), rsResourceGoodsReDomain.getTenantCode(), channelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisSku.checkChannelEnd");
            return null;
        }
        ArrayList<DisRsSkuDomain> disList = new ArrayList<DisRsSkuDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain;
            DisRsSkuDomain disRsSkuDomain;
            DisDgoods disDgoods;
            if ("5".equals(rsSkuDomain.getGoodsPro()) && ListUtil.isNotEmpty(rsSkuDomain.getRsGoodsRelDomainList())) {
                disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, rsSkuDomain.getRsGoodsRelDomainList(), disChannel, esrequestType);
                if (null == disDgoods) {
                    this.logger.error("rs.RsFlowdataServiceImpl.makeDisSku.disDgoodspro5", (Object)(rsSkuDomain.getSkuCode() + "=" + disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
                    continue;
                }
            } else {
                disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, rsSkuDomain, disChannel, esrequestType);
                if (null == disDgoods) {
                    this.logger.error("rs.RsFlowdataServiceImpl.makeDisSku.disDgoods", (Object)("disDgoods:" + rsSkuDomain.getSkuCode() + "=" + disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
                    continue;
                }
            }
            if (null == (disRsSkuDomain = this.makeDisSku(rsResourceGoodsReDomain, rsSkuDomain, disChannel, disDgoods, disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoodsReDomain, disChannel, disDgoods, false)))) {
                this.logger.error("rs.RsFlowdataServiceImpl.makeDisSku.disRsSkuDomain");
                continue;
            }
            disList.add(disRsSkuDomain);
            disRsSkuDomain.setGoodsClass(disChannel.getGoodsClass());
            if ("0".equals(disChannel.getChannelMcode())) {
                disRsSkuDomain.setMemberMcode(disChannel.getMemberMcode());
                disRsSkuDomain.setMemberMname(disChannel.getMemberMname());
            } else if ("1".equals(disChannel.getChannelMcode())) {
                disRsSkuDomain.setMemberMcode(rsResourceGoodsReDomain.getMemberCode());
                disRsSkuDomain.setMemberMname(rsResourceGoodsReDomain.getMemberName());
            }
            disRsSkuDomain.setGoodsOrigin(disRsResourceGoodsDomain.getGoodsOrigin());
            disRsSkuDomain.setMemberCcode(disRsResourceGoodsDomain.getMemberCcode());
            disRsSkuDomain.setMemberCname(disRsResourceGoodsDomain.getMemberCname());
            disRsSkuDomain.setDisRsResourceGoodsDomain(disRsResourceGoodsDomain);
            disRsSkuDomain.setEditflag(false);
            if (!"edit".equals(esrequestType)) continue;
            disRsSkuDomain.setEditflag(true);
        }
        return disList;
    }

    private DisRsSkuDomain makeDisSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, DisChannel disChannel, DisDgoods disDgoods, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (null == rsResourceGoodsReDomain || null == disChannel || null == disDgoods) {
            return null;
        }
        rsSkuDomain.setMemberCcode(rsResourceGoodsReDomain.getMemberCcode());
        rsSkuDomain.setMemberCname(rsResourceGoodsReDomain.getMemberCname());
        rsSkuDomain.setMemberMcode(disRsResourceGoodsDomain.getMemberMcode());
        rsSkuDomain.setMemberMname(disRsResourceGoodsDomain.getMemberMname());
        rsSkuDomain.setGoodsOrigin(rsResourceGoodsReDomain.getGoodsOrigin());
        DisRsSkuDomain disRsSkuDomain = new DisRsSkuDomain();
        String dgoodsPut = disDgoods.getDgoodsPut();
        try {
            boolean flagPublic;
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsSkuDomain);
            if (StringUtils.isNotBlank((String)dgoodsPut)) {
                disRsSkuDomain.setDgoodsPut(dgoodsPut);
            }
            disRsSkuDomain.setDgoodsPic(disDgoods.getDgoodsPic());
            disRsSkuDomain.setDgoodsRemark(disDgoods.getDgoodsRemark());
            disRsResourceGoodsDomain.setDgoodsPic(disRsSkuDomain.getDgoodsPic());
            disRsResourceGoodsDomain.setDgoodsRemark(disRsSkuDomain.getDgoodsRemark());
            disRsSkuDomain.setMemberBcode(disRsResourceGoodsDomain.getMemberBcode());
            disRsSkuDomain.setMemberBname(disRsResourceGoodsDomain.getMemberBname());
            disRsSkuDomain.setPricesetOldMakeprice(rsSkuDomain.getPricesetMakeprice());
            disRsSkuDomain.setPricesetOldNprice(rsSkuDomain.getPricesetNprice());
            disRsSkuDomain.setPricesetOldRefrice(rsSkuDomain.getPricesetRefrice());
            disRsSkuDomain.setGoodsOldnum(rsSkuDomain.getGoodsNum());
            disRsSkuDomain.setGoodsOldweight(rsSkuDomain.getGoodsWeight());
            disRsSkuDomain.setGoodsShowname(StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getGoodsShowname()) ? rsResourceGoodsReDomain.getGoodsShowname() : rsResourceGoodsReDomain.getGoodsName());
            disRsSkuDomain.setGoodsShowno(StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getGoodsShowno()) ? rsResourceGoodsReDomain.getGoodsShowno() : rsResourceGoodsReDomain.getGoodsNo());
            disRsSkuDomain.setSkuShowno(StringUtils.isNotBlank((String)rsSkuDomain.getSkuShowno()) ? rsSkuDomain.getSkuShowno() : rsSkuDomain.getSkuNo());
            disRsSkuDomain.setSkuCodeOld(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setSkuOldcode(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsSkuDomain.setChannelCode(disChannel.getChannelCode());
            disRsSkuDomain.setChannelName(disChannel.getChannelName());
            disRsSkuDomain.setMemberCode(disChannel.getMemberCode());
            disRsSkuDomain.setGoodsClass(disChannel.getGoodsClass());
            disRsSkuDomain.setMemberName(disChannel.getMemberName());
            disRsSkuDomain.setDgoodsUprice(disDgoods.getDgoodsUprice());
            disRsSkuDomain.setDgoodsUnum(disDgoods.getDgoodsUnum());
            disRsSkuDomain.setGinfoCode(rsResourceGoodsReDomain.getGinfoCode());
            if (null == disChannel.getChannelVer()) {
                disChannel.setChannelVer(0);
            }
            disRsSkuDomain.setChannelVer(disChannel.getChannelVer());
            if (null != disRsResourceGoodsDomain) {
                if (null == disRsResourceGoodsDomain.getChannelVer()) {
                    disRsResourceGoodsDomain.setChannelVer(0);
                }
                if (disChannel.getChannelVer() - disRsResourceGoodsDomain.getChannelVer() > 0) {
                    disRsResourceGoodsDomain.setChannelVer(disChannel.getChannelVer());
                }
            }
            if ("24".equals(disRsResourceGoodsDomain.getGoodsType()) || "26".equals(disRsResourceGoodsDomain.getGoodsType()) || "06".equals(disRsResourceGoodsDomain.getGoodsType()) || !(flagPublic = this.makePice(disRsResourceGoodsDomain, disRsSkuDomain, disChannel))) {
                // empty if block
            }
            this.makeNum(disRsResourceGoodsDomain, disRsSkuDomain, disChannel);
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisSku.e", (Throwable)e);
            return null;
        }
        disRsSkuDomain.setPricesetAsprice(rsSkuDomain.getPricesetNprice());
        disRsSkuDomain.setPricesetInsideprice(rsSkuDomain.getPricesetRefrice());
        if ("2020050600004084".equals(rsSkuDomain.getTenantCode())) {
            disRsSkuDomain.setPricesetAsprice(rsSkuDomain.getPricesetAsprice());
            disRsSkuDomain.setPricesetInsideprice(rsSkuDomain.getPricesetInsideprice());
            disRsSkuDomain.setGoodsTopweight(rsSkuDomain.getGoodsTopweight());
        }
        try {
            ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomains = new ArrayList<RsPropertiesValueDomain>();
            if (null != rsSkuDomain.getPropertiesList() && rsSkuDomain.getPropertiesList().size() > 0) {
                for (RsPropertiesValueDomain rsPropertiesValueDomain : rsSkuDomain.getPropertiesList()) {
                    RsPropertiesValueDomain rsPropertiesValueDomain1 = new RsPropertiesValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain1, (Object)rsPropertiesValueDomain);
                    rsPropertiesValueDomain1.setPropertiesValueId(null);
                    rsPropertiesValueDomain1.setPropertiesValueCode(this.createUUIDString());
                    rsPropertiesValueDomains.add(rsPropertiesValueDomain1);
                }
            }
            disRsSkuDomain.setPropertiesList(rsPropertiesValueDomains);
            ArrayList<RsSpecValueDomain> rsSpecValueDomains = new ArrayList<RsSpecValueDomain>();
            if (null != rsSkuDomain.getSpecList() && rsSkuDomain.getSpecList().size() > 0) {
                for (RsSpecValueDomain rsSpecValueDomain : rsSkuDomain.getSpecList()) {
                    RsSpecValueDomain rsSpecValueDomain1 = new RsSpecValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsSpecValueDomain1, (Object)rsSpecValueDomain);
                    rsSpecValueDomain1.setSpecValueId(null);
                    rsSpecValueDomain1.setSpecValueCode(this.createUUIDString());
                    rsSpecValueDomains.add(rsSpecValueDomain1);
                }
            }
            disRsSkuDomain.setSpecList(rsSpecValueDomains);
            ArrayList<RsGoodsFileDomain> rsGoodsFileDomains = new ArrayList<RsGoodsFileDomain>();
            if (null != rsSkuDomain.getRsGoodsFileDomainList() && rsSkuDomain.getRsGoodsFileDomainList().size() > 0) {
                for (RsGoodsFileDomain rsGoodsFileDomain : rsSkuDomain.getRsGoodsFileDomainList()) {
                    RsGoodsFileDomain rsGoodsFileDomain1 = new RsGoodsFileDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain1, (Object)rsGoodsFileDomain);
                    rsGoodsFileDomain1.setGoodsFileId(null);
                    rsGoodsFileDomain1.setGoodsFileCode(this.createUUIDString());
                    rsGoodsFileDomains.add(rsGoodsFileDomain1);
                }
            }
            disRsSkuDomain.setRsGoodsFileDomainList(rsGoodsFileDomains);
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomains = new ArrayList<RsGoodsRelDomain>();
            if (null != rsSkuDomain.getRsGoodsRelDomainList() && rsSkuDomain.getRsGoodsRelDomainList().size() > 0) {
                for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
                    RsGoodsRelDomain rsGoodsRelDomain1 = new RsGoodsRelDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain1, (Object)rsGoodsRelDomain);
                    rsGoodsRelDomain1.setGoodsRelId(null);
                    rsGoodsRelDomain1.setGoodsRelCode(this.createUUIDString());
                    rsGoodsRelDomains.add(rsGoodsRelDomain1);
                }
            }
            disRsSkuDomain.setRsGoodsRelDomainList(rsGoodsRelDomains);
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisSkuList.e", (Object)(disChannel.getChannelCode() + "=" + disChannel.getChannelName()), (Throwable)e);
            return null;
        }
        return disRsSkuDomain;
    }

    private List<DisRsResourceGoodsDomain> makeDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, List<DisChannel> channelList, String esrequestType) {
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(channelList)) {
            return null;
        }
        if (!this.checkChannelEnd(rsResourceGoodsReDomain.getChannelCode(), rsResourceGoodsReDomain.getTenantCode(), channelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisGoods.checkChannelEnd.", (Object)(rsResourceGoodsReDomain.getChannelCode() + "=:=" + rsResourceGoodsReDomain.getTenantCode() + "=:=" + JsonUtil.buildNormalBinder().toJson(channelList)));
            return null;
        }
        ArrayList<DisRsResourceGoodsDomain> disList = new ArrayList<DisRsResourceGoodsDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.checkDisGoods(rsResourceGoodsReDomain, disChannel, esrequestType);
            if (null == disRsResourceGoodsDomain) continue;
            disList.add(disRsResourceGoodsDomain);
        }
        return disList;
    }

    private DisRsResourceGoodsDomain makeDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel, DisDgoods disDgoods, boolean flag) {
        if (null == rsResourceGoodsReDomain || null == disChannel || null == disDgoods) {
            this.logger.error("rs.RsFlowdataServiceImpl,makeDisGoods.param is null");
            return null;
        }
        String nowChannelCode = rsResourceGoodsReDomain.getChannelCode();
        if (null == nowChannelCode) {
            nowChannelCode = "";
        }
        if (nowChannelCode.equals(disChannel.getChannelCode())) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisGoods.nowChannelCode", (Object)(disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
            return null;
        }
        DisRsResourceGoodsDomain disRsResourceGoodsDomain = new DisRsResourceGoodsDomain();
        try {
            QueryResult<RsGoodsClass> qglist;
            BeanUtils.copyAllPropertys((Object)disRsResourceGoodsDomain, (Object)rsResourceGoodsReDomain);
            disRsResourceGoodsDomain.setGoodsShowname(StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getGoodsShowname()) ? rsResourceGoodsReDomain.getGoodsShowname() : rsResourceGoodsReDomain.getGoodsName());
            disRsResourceGoodsDomain.setGoodsShowno(StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getGoodsShowno()) ? rsResourceGoodsReDomain.getGoodsShowno() : rsResourceGoodsReDomain.getGoodsNo());
            disRsResourceGoodsDomain.setGoodsCodeOld(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setChannelCode(disChannel.getChannelCode());
            disRsResourceGoodsDomain.setChannelName(disChannel.getChannelName());
            disRsResourceGoodsDomain.setMemberCode(disChannel.getMemberCode());
            disRsResourceGoodsDomain.setMemberName(disChannel.getMemberName());
            disRsResourceGoodsDomain.setPricesetOldNprice(rsResourceGoodsReDomain.getPricesetNprice());
            disRsResourceGoodsDomain.setPricesetOldMakeprice(rsResourceGoodsReDomain.getPricesetMakeprice());
            disRsResourceGoodsDomain.setPricesetOldRefrice(rsResourceGoodsReDomain.getPricesetRefrice());
            disRsResourceGoodsDomain.setGoodsOldnum(rsResourceGoodsReDomain.getGoodsNum());
            disRsResourceGoodsDomain.setGoodsOldweight(rsResourceGoodsReDomain.getGoodsWeight());
            disRsResourceGoodsDomain.setGoodsClass(disChannel.getGoodsClass());
            if ("0".equals(disChannel.getChannelMcode())) {
                disRsResourceGoodsDomain.setMemberMcode(disChannel.getMemberMcode());
                disRsResourceGoodsDomain.setMemberMname(disChannel.getMemberMname());
            } else if ("1".equals(disChannel.getChannelMcode())) {
                disRsResourceGoodsDomain.setMemberMcode(rsResourceGoodsReDomain.getMemberCode());
                disRsResourceGoodsDomain.setMemberMname(rsResourceGoodsReDomain.getMemberName());
            } else if ("2".equals(disChannel.getChannelMcode())) {
                disRsResourceGoodsDomain.setMemberMcode(rsResourceGoodsReDomain.getMemberMcode());
                disRsResourceGoodsDomain.setMemberMname(rsResourceGoodsReDomain.getMemberMname());
            } else if ("3".equals(disChannel.getChannelMcode())) {
                disRsResourceGoodsDomain.setMemberMcode(rsResourceGoodsReDomain.getMemberCode());
                disRsResourceGoodsDomain.setMemberMname(rsResourceGoodsReDomain.getMemberName());
            }
            if ("0".equals(disChannel.getChannelCcode())) {
                disRsResourceGoodsDomain.setMemberCcode(disChannel.getMemberCcode());
                disRsResourceGoodsDomain.setMemberCname(disChannel.getMemberCname());
            } else if ("1".equals(disChannel.getChannelCcode())) {
                disRsResourceGoodsDomain.setMemberCcode(rsResourceGoodsReDomain.getMemberCcode());
                disRsResourceGoodsDomain.setMemberCname(rsResourceGoodsReDomain.getMemberCname());
            } else if ("2".equals(disChannel.getChannelCcode())) {
                disRsResourceGoodsDomain.setMemberCcode(rsResourceGoodsReDomain.getMemberMcode());
                disRsResourceGoodsDomain.setMemberCname(rsResourceGoodsReDomain.getMemberMname());
            } else if ("3".equals(disChannel.getChannelCcode())) {
                disRsResourceGoodsDomain.setMemberCcode(rsResourceGoodsReDomain.getMemberCode());
                disRsResourceGoodsDomain.setMemberCname(rsResourceGoodsReDomain.getMemberName());
            }
            if (DISCHANNEL_TYPE_STORE.equals(disChannel.getChannelType())) {
                disRsResourceGoodsDomain.setGoodsOrigin("17");
            } else if (DISCHANNEL_TYPE_THRID.equals(disChannel.getChannelType())) {
                disRsResourceGoodsDomain.setGoodsOrigin("18");
            } else if (DISCHANNEL_CON.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setGoodsOrigin("12");
                disRsResourceGoodsDomain.setMemberCcode(disChannel.getMemberCcode());
                disRsResourceGoodsDomain.setMemberCname(disChannel.getMemberCname());
            } else if (DISCHANNEL_SALE.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setGoodsOrigin("11");
            } else if (DISCHANNEL_BUS.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setGoodsOrigin("13");
                disRsResourceGoodsDomain.setMemberBcode(disChannel.getMemberCcode());
                disRsResourceGoodsDomain.setMemberBname(disChannel.getMemberCname());
            }
            if (null == disChannel.getChannelVer()) {
                disChannel.setChannelVer(0);
            }
            if (null == disRsResourceGoodsDomain.getChannelVer()) {
                disRsResourceGoodsDomain.setChannelVer(0);
            }
            if (disChannel.getChannelVer() - disRsResourceGoodsDomain.getChannelVer() > 0) {
                disRsResourceGoodsDomain.setChannelVer(disChannel.getChannelVer());
            }
            if (StringUtils.isBlank((String)disRsResourceGoodsDomain.getClasstreeShopcode()) && null != (qglist = this.getRsGoodsClassService().queryGoodsClassPage(this.getQueryMapParam("classtreeCode,tenantCode", new Object[]{disRsResourceGoodsDomain.getClasstreeCode(), disRsResourceGoodsDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qglist.getList()) && qglist.getList().size() == 1) {
                disRsResourceGoodsDomain.setClasstreeShopcode(((RsGoodsClass)qglist.getList().get(0)).getGoodsClassCode());
                disRsResourceGoodsDomain.setClasstreeShopname(((RsGoodsClass)qglist.getList().get(0)).getGoodsClassName());
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsSpecValueDomainList())) {
                ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
                for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsReDomain.getRsSpecValueDomainList()) {
                    RsSpecValueDomain rsSpecValueDomain1 = new RsSpecValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsSpecValueDomain1, (Object)rsSpecValueDomain);
                    rsSpecValueDomain1.setSpecValueId(null);
                    rsSpecValueDomain1.setSpecValueCode(this.createUUIDString());
                    rsSpecValueDomainList.add(rsSpecValueDomain1);
                }
                disRsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsFileDomainList())) {
                ArrayList<RsGoodsFileDomain> rsGoodsFileDomains = new ArrayList<RsGoodsFileDomain>();
                for (RsGoodsFileDomain rsGoodsFileDomain : rsResourceGoodsReDomain.getRsGoodsFileDomainList()) {
                    RsGoodsFileDomain rsGoodsFileDomain1 = new RsGoodsFileDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain1, (Object)rsGoodsFileDomain);
                    rsGoodsFileDomain1.setGoodsFileId(null);
                    rsGoodsFileDomain1.setGoodsFileCode(this.createUUIDString());
                    rsGoodsFileDomains.add(rsGoodsFileDomain1);
                }
                disRsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileDomains);
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsWhDomainList())) {
                ArrayList<RsGoodsWhDomain> rsGoodsWhDomains = new ArrayList<RsGoodsWhDomain>();
                for (RsGoodsWhDomain rsGoodsWhDomain : rsResourceGoodsReDomain.getRsGoodsWhDomainList()) {
                    RsGoodsWhDomain rsGoodsWhDomain1 = new RsGoodsWhDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsWhDomain1, (Object)rsGoodsWhDomain);
                    rsGoodsWhDomain1.setGoodsWhId(null);
                    rsGoodsWhDomain1.setGoodsWhCode(this.createUUIDString());
                    rsGoodsWhDomains.add(rsGoodsWhDomain1);
                }
                disRsResourceGoodsDomain.setRsGoodsWhDomainList(rsGoodsWhDomains);
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsShopDomainList())) {
                ArrayList<RsGoodsShopDomain> rsGoodsShopDomains = new ArrayList<RsGoodsShopDomain>();
                for (RsGoodsShopDomain rsGoodsShopDomain : rsResourceGoodsReDomain.getRsGoodsShopDomainList()) {
                    RsGoodsShopDomain rsGoodsShopDomain1 = new RsGoodsShopDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsShopDomain1, (Object)rsGoodsShopDomain);
                    rsGoodsShopDomain1.setGoodsShopId(null);
                    rsGoodsShopDomain1.setGoodsShopCode(this.createUUIDString());
                    rsGoodsShopDomains.add(rsGoodsShopDomain1);
                }
                disRsResourceGoodsDomain.setRsGoodsShopDomainList(rsGoodsShopDomains);
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsRelDomainList())) {
                ArrayList<RsGoodsRelDomain> rsGoodsRelDomains = new ArrayList<RsGoodsRelDomain>();
                for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                    RsGoodsRelDomain rsGoodsRelDomain1 = new RsGoodsRelDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain1, (Object)rsGoodsRelDomain);
                    rsGoodsRelDomain1.setGoodsRelId(null);
                    rsGoodsRelDomain1.setGoodsRelCode(this.createUUIDString());
                    rsGoodsRelDomains.add(rsGoodsRelDomain1);
                }
                disRsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomains);
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsPropertiesValueDomainList())) {
                ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomains = new ArrayList<RsPropertiesValueDomain>();
                for (RsPropertiesValueDomain rsPropertiesValueDomain : rsResourceGoodsReDomain.getRsPropertiesValueDomainList()) {
                    RsPropertiesValueDomain rsPropertiesValueDomain1 = new RsPropertiesValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain1, (Object)rsPropertiesValueDomain);
                    rsPropertiesValueDomain1.setPropertiesValueId(null);
                    rsPropertiesValueDomain1.setPropertiesValueCode(this.createUUIDString());
                    rsPropertiesValueDomains.add(rsPropertiesValueDomain1);
                }
                disRsResourceGoodsDomain.setRsPropertiesValueDomainList(rsPropertiesValueDomains);
            }
            disRsResourceGoodsDomain.setPricesetAsprice(disRsResourceGoodsDomain.getPricesetNprice());
            disRsResourceGoodsDomain.setPricesetInsideprice(disRsResourceGoodsDomain.getPricesetRefrice());
            if ("2020050600004084".equals(rsResourceGoodsReDomain.getTenantCode())) {
                disRsResourceGoodsDomain.setPricesetAsprice(rsResourceGoodsReDomain.getPricesetAsprice());
                disRsResourceGoodsDomain.setPricesetInsideprice(rsResourceGoodsReDomain.getPricesetInsideprice());
            }
            if (StringUtils.isBlank((String)disDgoods.getDgoodsPut())) {
                disDgoods.setDgoodsPut("1");
            }
            if ("1".equals(disDgoods.getDgoodsPut())) {
                disRsResourceGoodsDomain.setDataOpbillstate(1);
            } else if ("0".equals(disDgoods.getDgoodsPut())) {
                disRsResourceGoodsDomain.setDataOpbillstate(0);
            }
            disRsResourceGoodsDomain.setDgoodsPut(disDgoods.getDgoodsPut());
            disRsResourceGoodsDomain.setDgoodsPic(disDgoods.getDgoodsPic());
            disRsResourceGoodsDomain.setDgoodsRemark(disDgoods.getDgoodsRemark());
            if (flag) {
                disRsResourceGoodsDomain.setDisRsSkuDomainList(this.makeDisSkuList(rsResourceGoodsReDomain.getRsSkuDomainList(), rsResourceGoodsReDomain, disChannel, disDgoods, disRsResourceGoodsDomain));
            }
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisGoods.e", (Object)(rsResourceGoodsReDomain.getGoodsCode() + "=" + disChannel.getChannelCode() + "=" + disChannel.getChannelName()), (Throwable)e);
            return null;
        }
        return disRsResourceGoodsDomain;
    }

    private List<DisRsSkuDomain> makeDisSkuList(List<RsSkuDomain> rsSkuDomainList, RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel, DisDgoods disDgoods, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (ListUtil.isEmpty(rsSkuDomainList) || null == disChannel || null == disRsResourceGoodsDomain || null == disDgoods) {
            return null;
        }
        ArrayList<DisRsSkuDomain> disRsSkuDomainList = new ArrayList<DisRsSkuDomain>();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            DisRsSkuDomain disRsSkuDomain = this.makeDisSku(rsResourceGoodsReDomain, rsSkuDomain, disChannel, disDgoods, disRsResourceGoodsDomain);
            if (null == disRsSkuDomain) continue;
            disRsSkuDomainList.add(disRsSkuDomain);
        }
        return disRsSkuDomainList;
    }

    private <T> T getRemoteMapCache(String key, String field, Class<T> classT) {
        Object obj = null;
        try {
            String json = DisUtil.getRemotMap((String)key, (String)field);
            if (null == json) {
                return null;
            }
            obj = JsonUtil.buildNormalBinder().getJsonToObject(json, classT);
            if (null == obj) {
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.getRemoteCache.e", (Throwable)e);
        }
        return (T)obj;
    }

    private <T> T getRemoteMapCacheToList(String key, String field, Class<T> classT) {
        Object obj = null;
        try {
            String json = DisUtil.getRemotMap((String)key, (String)field);
            if (null == json) {
                return null;
            }
            obj = JsonUtil.buildNormalBinder().getJsonToList(json, classT);
            if (null == obj) {
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.getRemoteCacheToList.e", (Throwable)e);
        }
        return (T)obj;
    }

    private DisDgoods checkDgoods(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDgoods.params.null", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        DisDgoods disDgoods = (DisDgoods)DisUtil.getMapJson((String)"DisDgoods-channelCode", (String)(channelCode + "-" + tenantCode), DisDgoods.class);
        if (disDgoods == null) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDgoods >>> channelCode\u627e\u4e0d\u5230\u6e20\u9053\u8303\u56f4\u7f13\u5b58", (Object)("channelCode:" + channelCode + ",tenantCode:" + tenantCode));
            return null;
        }
        if (!"1".equals(disDgoods.getDgoodsSync())) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDgoods.dgoodsSync", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        return disDgoods;
    }

    private Map<String, Object> makeObject(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (null != rsResourceGoodsReDomain) {
            obj.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain), String.class, Object.class));
        }
        if (null != rsSkuDomain) {
            obj.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)rsSkuDomain), String.class, Object.class));
        }
        return obj;
    }

    private boolean checkDgoods(DisDgoodsScopelistnewReDomain disDgoodsScopelistnewReDomain, Map<String, Object> obj) {
        if (null == disDgoodsScopelistnewReDomain || MapUtil.isEmpty(obj)) {
            return false;
        }
        ArrayList<DisDgoodsScopelistnewReDomain> disDgoodsScopelistnewReDomainList = new ArrayList<DisDgoodsScopelistnewReDomain>();
        disDgoodsScopelistnewReDomainList.add(disDgoodsScopelistnewReDomain);
        Map<String, List<String>> map = this.makeScopelistNew(disDgoodsScopelistnewReDomainList);
        if (!this.checkParentDgoods(obj, map)) {
            return false;
        }
        if (ListUtil.isNotEmpty(disDgoodsScopelistnewReDomain.getChildList())) {
            map = this.makeScopelistNew(disDgoodsScopelistnewReDomain.getChildList());
            return this.checkParentDgoods(obj, map);
        }
        return true;
    }

    private boolean checkParentDgoods(Map<String, Object> obj, Map<String, List<String>> map) {
        if (null == map || map.isEmpty() || null == obj || obj.isEmpty()) {
            return false;
        }
        String term = "";
        String key = "";
        boolean flag = true;
        block0: for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.newForceGetProperty(obj, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs = objValue.toString().split("\\,");
                flag = false;
                for (String o : otrs) {
                    if (!this.cond(valueList, term, o)) continue;
                    flag = true;
                    continue block0;
                }
                continue;
            }
            if (this.cond(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private DisDgoods checkDisGoodsChannel(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, DisChannel disChannel, String esrequestType) {
        List disDgoodsScopelistList;
        if (null == disChannel) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoodsChannel.disChannel.null");
            return null;
        }
        DisDgoods disDgoods = this.checkDgoods(disChannel.getChannelCode(), disChannel.getTenantCode());
        if (null == disDgoods) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoodsChannel >>> \u6e20\u9053\u63a8\u9001\u6821\u9a8c.null", (Object)("channelName:" + disChannel.getChannelName() + "-" + disChannel.getChannelCode() + ",parentGoodsChannelName:" + rsResourceGoodsReDomain.getChannelName() + "-" + rsResourceGoodsReDomain.getChannelCode() + ",goodsCode" + rsResourceGoodsReDomain.getGoodsCode()));
            return null;
        }
        if (StringUtils.isBlank((String)disDgoods.getDgoodsEdit())) {
            disDgoods.setDgoodsEdit("1");
        }
        if ("edit".equals(esrequestType) && "0".equals(disDgoods.getDgoodsEdit())) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoodsChannel.edit", (Object)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()));
            return null;
        }
        if (StringUtils.isBlank((String)disDgoods.getDgoodsPut())) {
            disDgoods.setDgoodsPut("1");
        }
        if (StringUtils.isBlank((String)disDgoods.getDgoodsUnum())) {
            disDgoods.setDgoodsUnum("1");
        }
        if (StringUtils.isBlank((String)disDgoods.getDgoodsUprice())) {
            disDgoods.setDgoodsUprice("1");
        }
        if (ListUtil.isEmpty((Collection)(disDgoodsScopelistList = (List)((Object)this.getRemoteMapCacheToList("DisDgoodsScopelist-DgoodsCode", disDgoods.getDgoodsCode() + "-" + disChannel.getTenantCode(), DisDgoodsScopelist.class))))) {
            disDgoodsScopelistList = DisUtil.getMapListJson((String)"DisDgoodsScopelist-DgoodsCode", (String)(disDgoods.getDgoodsCode() + "-" + disChannel.getTenantCode()), DisDgoodsScopelist.class);
        }
        List disDgoodsScopelistnewReDomainList = DisUtil.getMapListJson((String)"DisDgoodsScopelist-DgoodsCode", (String)("all-" + disDgoods.getDgoodsCode() + "-" + disChannel.getTenantCode()), DisDgoodsScopelistnewReDomain.class);
        if (ListUtil.isEmpty((Collection)disDgoodsScopelistList) && ListUtil.isEmpty((Collection)disDgoodsScopelistnewReDomainList) || "28".equals(rsResourceGoodsReDomain.getGoodsType())) {
            if ("2".equals(disDgoods.getChannelSort()) || "8".equals(disDgoods.getChannelSort())) {
                return null;
            }
            return disDgoods;
        }
        Map<String, Object> obj = this.makeObject(rsResourceGoodsReDomain, rsSkuDomain);
        if (ListUtil.isNotEmpty((Collection)disDgoodsScopelistnewReDomainList)) {
            for (DisDgoodsScopelistnewReDomain disDgoodsScopelistnewReDomain : disDgoodsScopelistnewReDomainList) {
                if (!this.checkDgoods(disDgoodsScopelistnewReDomain, obj)) continue;
                return disDgoods;
            }
        }
        boolean flag = true;
        if (ListUtil.isNotEmpty((Collection)disDgoodsScopelistList)) {
            Map<String, List<String>> map = this.makeScopelist(disDgoodsScopelistList);
            if (null == map || map.isEmpty()) {
                return disDgoods;
            }
            String term = "";
            String key = "";
            block1: for (String keys : map.keySet()) {
                String[] keyStr = keys.split("\\|");
                if (null == keyStr || keyStr.length == 0) continue;
                key = keyStr[0];
                if (keyStr.length > 1) {
                    term = keyStr[1];
                }
                Object objValue = BeanUtils.newForceGetProperty(obj, (String)key);
                List<String> valueList = map.get(keys);
                if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                    String[] otrs = objValue.toString().split("\\,");
                    flag = false;
                    for (String o : otrs) {
                        if (!this.cond(valueList, term, o)) continue;
                        flag = true;
                        continue block1;
                    }
                    continue;
                }
                if (this.cond(valueList, term, objValue)) continue;
                flag = false;
                break;
            }
        }
        if (!flag) {
            return null;
        }
        return disDgoods;
    }

    private DisDgoods checkDisGoodsChannel(RsResourceGoodsReDomain rsResourceGoodsReDomain, List<RsGoodsRelDomain> rsGoodsRelDomainList, DisChannel disChannel, String esrequestType) {
        if (ListUtil.isEmpty(rsGoodsRelDomainList)) {
            return null;
        }
        DisDgoods disDgoods = null;
        for (RsGoodsRelDomain rsGoodsRelDomain : rsGoodsRelDomainList) {
            RsSku relrsSku = this.getRsSkuService().getSkuBySkuNo(rsGoodsRelDomain.getSkuNo(), rsGoodsRelDomain.getMemberCode(), null, rsResourceGoodsReDomain.getChannelCode(), rsGoodsRelDomain.getTenantCode());
            if (null == relrsSku) {
                this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoodsChannel.tcsku.relrsSku", (Object)(rsGoodsRelDomain.getSkuNo() + "-" + rsGoodsRelDomain.getMemberCode() + "-" + null + "-" + rsResourceGoodsReDomain.getChannelCode() + "-" + rsResourceGoodsReDomain.getTenantCode()));
                return null;
            }
            RsSkuDomain rsSkuDomain = new RsSkuDomain();
            try {
                BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)relrsSku);
            }
            catch (Exception e) {
                this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoodsChannel.tcsku.e", (Object)(rsGoodsRelDomain.getSkuNo() + "-" + rsGoodsRelDomain.getMemberCode() + "-" + rsResourceGoodsReDomain.getChannelCode() + "-" + rsResourceGoodsReDomain.getTenantCode()));
            }
            if (null != (disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, rsSkuDomain, disChannel, esrequestType))) continue;
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoodsChannel.tcsku.disDgoods", (Object)(rsGoodsRelDomain.getSkuNo() + "-" + rsGoodsRelDomain.getMemberCode() + "-" + rsGoodsRelDomain.getMemberCcode() + "-" + rsResourceGoodsReDomain.getChannelCode() + "-" + rsResourceGoodsReDomain.getTenantCode()));
            return null;
        }
        return disDgoods;
    }

    private DisRsResourceGoodsDomain checkDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel, String esrequestType) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoods.", (Object)"param is null");
            return null;
        }
        List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
        if (ListUtil.isEmpty(rsSkuDomainList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoods.rsSkuDomainList.", (Object)"is null");
            return null;
        }
        DisDgoods disDgoods = null;
        ArrayList<RsSkuDomain> disRsSkuDomainList = new ArrayList<RsSkuDomain>();
        for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
            if ("5".equals(rsSkuDomain2.getGoodsPro()) && ListUtil.isNotEmpty(rsSkuDomain2.getRsGoodsRelDomainList())) {
                disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, rsSkuDomain2.getRsGoodsRelDomainList(), disChannel, esrequestType);
                if (null == disDgoods) {
                    this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoods.disDgoodspro5", (Object)(rsSkuDomain2.getSkuCode() + "=" + disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
                    continue;
                }
                disRsSkuDomainList.add(rsSkuDomain2);
                continue;
            }
            disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, rsSkuDomain2, disChannel, esrequestType);
            if (null == disDgoods) continue;
            disRsSkuDomainList.add(rsSkuDomain2);
        }
        if (ListUtil.isEmpty(disRsSkuDomainList)) {
            return null;
        }
        rsResourceGoodsReDomain.setRsSkuDomainList(disRsSkuDomainList);
        DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoodsReDomain, disChannel, disDgoods, true);
        if (null == disRsResourceGoodsDomain) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoods.null", (Object)(rsResourceGoodsReDomain.getGoodsCode() + "=" + disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
            return null;
        }
        return disRsResourceGoodsDomain;
    }

    private boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = false;
            }
        }
        return flag;
    }

    private boolean makeNum(List<DisDgnumDomain> disDpriceList, DisRsSkuDomain disRsSkuDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (ListUtil.isEmpty(disDpriceList) || null == disRsSkuDomain) {
            return false;
        }
        for (DisDgnumDomain disDgnumDomain : disDpriceList) {
            if (!this.makeDisDgnumDomain(disDgnumDomain, disRsSkuDomain, disRsResourceGoodsDomain)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> makeObject(DisRsSkuDomain disRsSkuDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (null != disRsResourceGoodsDomain) {
            obj.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)disRsResourceGoodsDomain), String.class, Object.class));
        }
        if (null != disRsSkuDomain) {
            obj.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)disRsSkuDomain), String.class, Object.class));
        }
        return obj;
    }

    private boolean makeDisDgnumDomain(DisDgnumDomain disDgnumDomain, DisRsSkuDomain disRsSkuDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        Map<String, Object> objMap;
        if (null == disDgnumDomain) {
            return false;
        }
        Map<String, List<String>> map = this.makeDgnumlist(disDgnumDomain.getDisDgnumListList());
        if (!this.checkConf(map, objMap = this.makeObject(disRsSkuDomain, disRsResourceGoodsDomain))) {
            return false;
        }
        if (ListUtil.isNotEmpty(disDgnumDomain.getDisDgnumListList())) {
            String confList = disDgnumDomain.getDisDgnumListList().get(0).getDgnumListType();
            if ("2".equals(disDgnumDomain.getDgnumPro()) || "goodsNo".equals(confList) || "skuNo".equals(confList)) {
                for (DisDgnumList disDgnumList : disDgnumDomain.getDisDgnumListList()) {
                    Object objValue = BeanUtils.newForceGetProperty(objMap, (String)disDgnumList.getDgnumListType());
                    ArrayList<String> relist = new ArrayList<String>();
                    relist.add(disDgnumList.getDgnumListValue());
                    if (!this.cond(relist, disDgnumList.getDgnumListTerm(), objValue)) continue;
                    if (null != disDgnumList.getDgnumListPrice() && disDgnumList.getDgnumListPrice().compareTo(BigDecimal.ZERO) > 0) {
                        disDgnumDomain.setDgnumPrice(disDgnumList.getDgnumListPrice());
                    } else if (StringUtils.isNotBlank((String)disDgnumList.getDgnumListValuename())) {
                        try {
                            disDgnumDomain.setDgnumPrice(new BigDecimal(disDgnumList.getDgnumListValuename()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (null != disDgnumList.getDgnumListMax() && disDgnumList.getDgnumListMax().compareTo(BigDecimal.ZERO) > 0) {
                        disDgnumDomain.setDgnumMax(disDgnumList.getDgnumListMax());
                    }
                    if (null == disDgnumList.getDgnumListMinx() || disDgnumList.getDgnumListMinx().compareTo(BigDecimal.ZERO) <= 0) break;
                    disDgnumDomain.setDgnumMin(disDgnumList.getDgnumListMinx());
                    break;
                }
            }
        }
        this.setNum(disDgnumDomain, disRsResourceGoodsDomain, disRsSkuDomain);
        return true;
    }

    private void makeNum(DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisRsSkuDomain disRsSkuDomain, DisChannel disChannel) {
        if (null == disChannel || null == disRsSkuDomain) {
            return;
        }
        List disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        boolean flag = false;
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            flag = true;
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        }
        if (this.makeNum(disDpriceList, disRsSkuDomain, disRsResourceGoodsDomain)) {
            return;
        }
        if (!flag) {
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
            this.makeNum(disDpriceList, disRsSkuDomain, disRsResourceGoodsDomain);
        }
    }

    private boolean makePric(List<DisDpriceDomain> disDpriceList, DisRsSkuDomain disRsSkuDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (ListUtil.isEmpty(disDpriceList)) {
            return false;
        }
        Map<String, Object> objMap = this.makeObject(disRsSkuDomain, disRsResourceGoodsDomain);
        String confList = "";
        boolean flagPublic = false;
        for (DisDpriceDomain disDpriceDomain : disDpriceList) {
            Map<String, List<String>> map = this.makeDpeicelist(disDpriceDomain.getDisDpriceConfList());
            if (!this.checkConf(map, objMap)) continue;
            if (ListUtil.isNotEmpty(disDpriceDomain.getDisDpriceConfList())) {
                confList = disDpriceDomain.getDisDpriceConfList().get(0).getDpriceConfType();
                if ("2".equals(disDpriceDomain.getDpricePro()) || "goodsNo".equals(confList) || "skuNo".equals(confList)) {
                    for (DisDpriceConf disDpriceConf : disDpriceDomain.getDisDpriceConfList()) {
                        Object objValue = BeanUtils.newForceGetProperty(objMap, (String)disDpriceConf.getDpriceConfType());
                        ArrayList<String> relist = new ArrayList<String>();
                        relist.add(disDpriceConf.getDpriceConfValue());
                        if (!this.cond(relist, disDpriceConf.getDpriceConfTerm(), objValue)) continue;
                        if (disDpriceConf.getDataState() == 1) {
                            flagPublic = true;
                        }
                        if (null != disDpriceConf.getDpriceConfPrice() && disDpriceConf.getDpriceConfPrice().compareTo(BigDecimal.ZERO) > 0) {
                            disDpriceDomain.setDpricePrice(disDpriceConf.getDpriceConfPrice());
                        }
                        if (null != disDpriceConf.getDpriceConfMprice() && disDpriceConf.getDpriceConfMprice().compareTo(BigDecimal.ZERO) > 0) {
                            disDpriceDomain.setDpriceMprice(disDpriceConf.getDpriceConfMprice());
                        }
                        if (null != disDpriceConf.getDpriceConfPricedef() && disDpriceConf.getDpriceConfPricedef().compareTo(BigDecimal.ZERO) > 0) {
                            disDpriceDomain.setDpricePricedef(disDpriceConf.getDpriceConfPricedef());
                        }
                        if (null == disDpriceConf.getDpriceConfMpricedef() || disDpriceConf.getDpriceConfMpricedef().compareTo(BigDecimal.ZERO) <= 0) break;
                        disDpriceDomain.setDpriceMpricedef(disDpriceConf.getDpriceConfMpricedef());
                        break;
                    }
                }
            }
            if (!flagPublic) {
                disRsSkuDomain.setChannelTver(0);
                continue;
            }
            disRsSkuDomain.setChannelTver(1);
            this.setPrice(disDpriceDomain, disRsSkuDomain, disRsResourceGoodsDomain);
            return flagPublic;
        }
        return false;
    }

    private boolean makePice(DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisRsSkuDomain disRsSkuDomain, DisChannel disChannel) {
        if (null == disRsSkuDomain || null == disChannel) {
            return false;
        }
        List disDpriceList = DisUtil.getMapListJson((String)"DisDpriceConf-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), DisDpriceDomain.class);
        boolean flag = false;
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            flag = true;
            disDpriceList = DisUtil.getMapListJson((String)"DisDpriceConf-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDpriceDomain.class);
        }
        if (this.makePric(disDpriceList, disRsSkuDomain, disRsResourceGoodsDomain)) {
            return true;
        }
        if (!flag) {
            disDpriceList = DisUtil.getMapListJson((String)"DisDpriceConf-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDpriceDomain.class);
            return this.makePric(disDpriceList, disRsSkuDomain, disRsResourceGoodsDomain);
        }
        return false;
    }

    private boolean checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        block0: for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs = objValue.toString().split("\\,");
                flag = false;
                for (String o : otrs) {
                    if (!this.cond(valueList, term, o)) continue;
                    flag = true;
                    continue block0;
                }
                continue;
            }
            if (this.cond(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private void setNum(DisDgnumDomain disDgnumDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisRsSkuDomain disRsSkuDomain) {
        if (null == disDgnumDomain || null == disRsSkuDomain) {
            return;
        }
        if (StringUtils.isBlank((String)disDgnumDomain.getDgnumSync())) {
            disDgnumDomain.setDgnumSync("1");
        }
        if (null != disRsResourceGoodsDomain) {
            disRsResourceGoodsDomain.setDgnumSync(disDgnumDomain.getDgnumSync());
        }
        int ver = null == disDgnumDomain.getDgnumVer() ? 0 : disDgnumDomain.getDgnumVer();
        disRsSkuDomain.setDgnumSync(disDgnumDomain.getDgnumSync());
        String pro = disDgnumDomain.getDgnumPro();
        if (StringUtils.isBlank((String)pro)) {
            pro = "1";
        }
        disDgnumDomain.setDgnumPro(pro);
        if (null == disDgnumDomain.getDgnumMin()) {
            disDgnumDomain.setDgnumMin(BigDecimal.ZERO);
        }
        BigDecimal rnum = BigDecimal.ZERO;
        BigDecimal rweight = BigDecimal.ZERO;
        if (null != disRsResourceGoodsDomain) {
            if (null == disRsResourceGoodsDomain.getGoodsNum()) {
                disRsResourceGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == disRsResourceGoodsDomain.getGoodsWeight()) {
                disRsResourceGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            disRsResourceGoodsDomain.setDgnumMax(disDgnumDomain.getDgnumMax());
            disRsResourceGoodsDomain.setDgnumMin(disDgnumDomain.getDgnumMin());
            disRsResourceGoodsDomain.setDgnumPrice(disDgnumDomain.getDgnumPrice());
            disRsResourceGoodsDomain.setDgnumPro(disDgnumDomain.getDgnumPro());
            disRsResourceGoodsDomain.setDgnumVer(ver);
        }
        disRsSkuDomain.setDgnumMax(disDgnumDomain.getDgnumMax());
        disRsSkuDomain.setDgnumMin(disDgnumDomain.getDgnumMin());
        disRsSkuDomain.setDgnumPrice(disDgnumDomain.getDgnumPrice());
        disRsSkuDomain.setDgnumPro(disDgnumDomain.getDgnumPro());
        disRsSkuDomain.setDgnumVer(ver);
        if ("0".equals(disDgnumDomain.getDgnumSync())) {
            return;
        }
        if (null == disRsSkuDomain.getGoodsNum()) {
            disRsSkuDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == disRsSkuDomain.getGoodsWeight()) {
            disRsSkuDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == disDgnumDomain.getDgnumPrice()) {
            disDgnumDomain.setDgnumPrice(BigDecimal.ZERO);
        }
        BigDecimal goodsNum = disRsSkuDomain.getGoodsNum();
        BigDecimal goodsWeight = disRsSkuDomain.getGoodsWeight();
        if ("0".equals(pro)) {
            rnum = goodsNum.subtract(disDgnumDomain.getDgnumPrice());
            rweight = goodsWeight.subtract(disDgnumDomain.getDgnumPrice());
        } else if ("1".equals(pro)) {
            rnum = disDgnumDomain.getDgnumPrice().divide(new BigDecimal("100"), 2, 4).multiply(goodsNum);
            rweight = disDgnumDomain.getDgnumPrice().divide(new BigDecimal("100"), 2, 4).multiply(goodsWeight);
        } else if ("2".equals(pro)) {
            rnum = disDgnumDomain.getDgnumPrice();
            rweight = disDgnumDomain.getDgnumPrice();
        }
        if (0 != ver) {
            if (1 == ver) {
                rnum = rnum.setScale(1, 4);
                rweight = rweight.setScale(1, 4);
            } else if (2 == ver) {
                rnum = rnum.setScale(0, 4);
                rweight = rweight.setScale(0, 4);
            } else if (3 == ver) {
                rnum = rnum.setScale(0, 1);
                rweight = rweight.setScale(0, 1);
            } else if (4 == ver) {
                rnum = rnum.setScale(2, 4);
                rweight = rweight.setScale(2, 4);
            }
        }
        disRsSkuDomain.setGoodsNum(rnum);
        disRsSkuDomain.setGoodsWeight(rweight);
        disRsSkuDomain.setGoodsSupplynum(rnum);
        disRsSkuDomain.setGoodsSupplyweight(rweight);
        if (null != disRsResourceGoodsDomain) {
            disRsResourceGoodsDomain.setGoodsNum(disRsResourceGoodsDomain.getGoodsNum().subtract(goodsNum).add(rnum));
            disRsResourceGoodsDomain.setGoodsWeight(disRsResourceGoodsDomain.getGoodsWeight().subtract(goodsWeight).add(rweight));
            disRsResourceGoodsDomain.setGoodsSupplynum(disRsResourceGoodsDomain.getGoodsNum());
            disRsResourceGoodsDomain.setGoodsSupplyweight(disRsResourceGoodsDomain.getGoodsWeight());
        }
    }

    private void setPrice(DisDpriceDomain disDpriceDomain, DisRsSkuDomain disRsSkuDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        Integer ver;
        if (null == disDpriceDomain || null == disRsSkuDomain) {
            return;
        }
        String pro = disDpriceDomain.getDpricePro();
        String dpriceSync = disDpriceDomain.getDpriceSync();
        if (StringUtils.isBlank((String)dpriceSync)) {
            dpriceSync = "1";
        }
        if (null == (ver = disDpriceDomain.getDpriceVer())) {
            ver = 0;
        }
        if (null != disRsResourceGoodsDomain) {
            if (null == disRsResourceGoodsDomain.getPricesetMakeprice()) {
                disRsResourceGoodsDomain.setPricesetMakeprice(BigDecimal.ZERO);
            }
            if (null == disRsResourceGoodsDomain.getPricesetNprice()) {
                disRsResourceGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null == disRsResourceGoodsDomain.getPricesetRefrice()) {
                disRsResourceGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            disRsResourceGoodsDomain.setDpriceSync(dpriceSync);
        }
        if (null != disRsSkuDomain) {
            if (null == disRsSkuDomain.getPricesetMakeprice()) {
                disRsSkuDomain.setPricesetMakeprice(BigDecimal.ZERO);
            }
            if (null == disRsSkuDomain.getPricesetNprice()) {
                disRsSkuDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null == disRsSkuDomain.getPricesetRefrice()) {
                disRsSkuDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            disRsSkuDomain.setDpriceSync(dpriceSync);
        }
        if (null == disDpriceDomain.getDpricePrice()) {
            disDpriceDomain.setDpricePrice(BigDecimal.ZERO);
        }
        if (null == disDpriceDomain.getDpriceMprice()) {
            disDpriceDomain.setDpriceMprice(BigDecimal.ZERO);
        }
        if (null == disDpriceDomain.getDpricePricedef()) {
            disDpriceDomain.setDpricePricedef(BigDecimal.ZERO);
        }
        if (null == disDpriceDomain.getDpriceMpricedef()) {
            disDpriceDomain.setDpriceMpricedef(BigDecimal.ZERO);
        }
        if ("0".equals(dpriceSync)) {
            if (null != disRsResourceGoodsDomain) {
                disRsResourceGoodsDomain.setDpricePricedef(disDpriceDomain.getDpricePricedef());
                disRsResourceGoodsDomain.setDpriceMpricedef(disDpriceDomain.getDpriceMpricedef());
                disRsResourceGoodsDomain.setDpriceMax(disDpriceDomain.getDpriceMax());
                disRsResourceGoodsDomain.setDpriceMin(disDpriceDomain.getDpriceMin());
                disRsResourceGoodsDomain.setDpriceMprice(disDpriceDomain.getDpriceMprice());
                disRsResourceGoodsDomain.setDpricePrice(disDpriceDomain.getDpricePrice());
                disRsResourceGoodsDomain.setDpricePro(disDpriceDomain.getDpricePro());
                disRsResourceGoodsDomain.setDpriceVer(disDpriceDomain.getDpriceVer());
            }
            if (null != disRsSkuDomain) {
                disRsSkuDomain.setDpricePricedef(disDpriceDomain.getDpricePricedef());
                disRsSkuDomain.setDpriceMpricedef(disDpriceDomain.getDpriceMpricedef());
                disRsSkuDomain.setDpriceMax(disDpriceDomain.getDpriceMax());
                disRsSkuDomain.setDpriceMin(disDpriceDomain.getDpriceMin());
                disRsSkuDomain.setDpriceMprice(disDpriceDomain.getDpriceMprice());
                disRsSkuDomain.setDpricePrice(disDpriceDomain.getDpricePrice());
                disRsSkuDomain.setDpricePro(disDpriceDomain.getDpricePro());
                disRsSkuDomain.setDpriceVer(disDpriceDomain.getDpriceVer());
            }
        } else {
            BigDecimal rmoney = BigDecimal.ZERO;
            BigDecimal money = disRsSkuDomain.getPricesetNprice();
            BigDecimal rmmoney = BigDecimal.ZERO;
            BigDecimal mmoney = disRsSkuDomain.getPricesetMakeprice();
            if (null != disRsSkuDomain) {
                money = disRsSkuDomain.getPricesetNprice();
                mmoney = disRsSkuDomain.getPricesetMakeprice();
            }
            if (null == money) {
                money = BigDecimal.ZERO;
            }
            if (null == mmoney) {
                mmoney = BigDecimal.ZERO;
            }
            if ("0".equals(pro)) {
                rmoney = money.add(disDpriceDomain.getDpricePrice());
                rmmoney = mmoney.add(disDpriceDomain.getDpriceMprice());
            } else if ("1".equals(pro)) {
                rmoney = disDpriceDomain.getDpricePrice().divide(new BigDecimal("100"), 2, 4).multiply(money);
                rmmoney = disDpriceDomain.getDpriceMprice().divide(new BigDecimal("100"), 2, 4).multiply(money);
            } else if ("2".equals(pro)) {
                rmoney = disDpriceDomain.getDpricePrice();
                rmmoney = disDpriceDomain.getDpriceMprice();
            }
            if (0 == ver) {
                rmoney = rmoney.setScale(2, 4);
                rmmoney = rmmoney.setScale(2, 4);
            } else if (1 == ver) {
                rmoney = rmoney.setScale(1, 4);
                rmmoney = rmmoney.setScale(1, 4);
            } else if (2 == ver) {
                rmoney = rmoney.setScale(0, 4);
                rmmoney = rmmoney.setScale(0, 4);
            } else if (3 == ver) {
                rmoney = rmoney.setScale(0, 1);
                rmmoney = rmmoney.setScale(0, 1);
            }
            if (null != disRsResourceGoodsDomain) {
                disRsResourceGoodsDomain.setPricesetNprice(rmoney);
            }
            if (disDpriceDomain.getDpriceMprice().compareTo(BigDecimal.ZERO) != 0) {
                if (null != disRsResourceGoodsDomain) {
                    disRsResourceGoodsDomain.setPricesetMakeprice(rmmoney);
                }
                if (null != disRsSkuDomain) {
                    disRsSkuDomain.setPricesetMakeprice(rmoney);
                }
            }
            if (null != disRsSkuDomain) {
                disRsSkuDomain.setPricesetNprice(rmoney);
            }
            rmoney = BigDecimal.ZERO;
            money = BigDecimal.ZERO;
            if (null != disRsResourceGoodsDomain) {
                money = disRsResourceGoodsDomain.getPricesetRefrice();
            }
            if (null != disRsSkuDomain) {
                money = disRsSkuDomain.getPricesetRefrice();
            }
            if (null == money) {
                money = BigDecimal.ZERO;
            }
            if (money.compareTo(BigDecimal.ZERO) > 0) {
                if ("0".equals(pro)) {
                    rmoney = money.add(disDpriceDomain.getDpricePrice());
                } else if ("1".equals(pro)) {
                    rmoney = disDpriceDomain.getDpricePrice().divide(new BigDecimal("100"), 2, 4).multiply(money);
                } else if ("2".equals(pro)) {
                    rmoney = disDpriceDomain.getDpricePrice();
                }
                if (null != disRsResourceGoodsDomain) {
                    disRsResourceGoodsDomain.setPricesetRefrice(rmoney);
                }
                if (null != disRsSkuDomain) {
                    disRsSkuDomain.setPricesetRefrice(rmoney);
                }
            }
        }
    }

    private Map<String, List<String>> makeDgnumlist(List<DisDgnumList> disDgnumListList) {
        if (ListUtil.isEmpty(disDgnumListList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgnumList disDpriceConf : disDgnumListList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDpriceConf.getDgnumListTerm())) {
                disDpriceConf.setDgnumListTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDpriceConf.getDgnumListType() + "|" + disDpriceConf.getDgnumListTerm()))) {
                list = new ArrayList<String>();
                map.put(disDpriceConf.getDgnumListType() + "|" + disDpriceConf.getDgnumListTerm(), list);
            }
            list.add(disDpriceConf.getDgnumListValue());
        }
        return map;
    }

    private Map<String, List<String>> makeDpeicelist(List<DisDpriceConf> disDpriceConfList) {
        if (ListUtil.isEmpty(disDpriceConfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDpriceConf disDpriceConf : disDpriceConfList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDpriceConf.getDpriceConfTerm())) {
                disDpriceConf.setDpriceConfTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDpriceConf.getDpriceConfType() + "|" + disDpriceConf.getDpriceConfTerm()))) {
                list = new ArrayList<String>();
                map.put(disDpriceConf.getDpriceConfType() + "|" + disDpriceConf.getDpriceConfTerm(), list);
            }
            list.add(disDpriceConf.getDpriceConfValue());
        }
        return map;
    }

    private Map<String, List<String>> makeScopelistNew(List<DisDgoodsScopelistnewReDomain> disDgoodsScopelistnewReDomainList) {
        if (ListUtil.isEmpty(disDgoodsScopelistnewReDomainList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeScopelistNew.param is null");
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgoodsScopelistnewReDomain disDgoodsScopelistnewReDomain : disDgoodsScopelistnewReDomainList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDgoodsScopelistnewReDomain.getDgoodsScopelistTerm())) {
                disDgoodsScopelistnewReDomain.setDgoodsScopelistTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDgoodsScopelistnewReDomain.getDgoodsScopelistType() + "|" + disDgoodsScopelistnewReDomain.getDgoodsScopelistTerm()))) {
                list = new ArrayList<String>();
                map.put(disDgoodsScopelistnewReDomain.getDgoodsScopelistType() + "|" + disDgoodsScopelistnewReDomain.getDgoodsScopelistTerm(), list);
            }
            list.add(disDgoodsScopelistnewReDomain.getDgoodsScopelistValue());
        }
        return map;
    }

    private Map<String, List<String>> makeScopelist(List<DisDgoodsScopelist> disDgoodsScopelistList) {
        if (ListUtil.isEmpty(disDgoodsScopelistList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeScopelist.param is null");
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgoodsScopelist disDgoodsScopelist : disDgoodsScopelistList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDgoodsScopelist.getDgoodsScopelistTerm())) {
                disDgoodsScopelist.setDgoodsScopelistTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDgoodsScopelist.getDgoodsScopelistType() + "|" + disDgoodsScopelist.getDgoodsScopelistTerm()))) {
                list = new ArrayList<String>();
                map.put(disDgoodsScopelist.getDgoodsScopelistType() + "|" + disDgoodsScopelist.getDgoodsScopelistTerm(), list);
            }
            list.add(disDgoodsScopelist.getDgoodsScopelistValue());
        }
        return map;
    }

    private boolean sendGoodsSkuHtml(HtmlRelease htmlRelease, RsFlowdata rsFlowData, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsFlowData || null == htmlRelease) {
            return false;
        }
        HashMap<String, Object> htmlMap = new HashMap<String, Object>();
        htmlMap.put("esRequestType", rsFlowData.getEsrequestType());
        htmlMap.put("channelCode", rsFlowData.getChannelCode());
        htmlMap.put("memberCode", rsFlowData.getMemberCode());
        if (!"delete".equals(rsFlowData.getEsrequestType())) {
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsSkuHtml.rsResourceGoodsReDomain", (Object)rsFlowData.getFdCode());
                return false;
            }
            if (ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsSkuHtml.getRsSkuDomainList", (Object)rsFlowData.getFdCode());
                return false;
            }
            List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
            RsSkuDomain rsSkuDomain = rsSkuDomainList.get(0);
            if (!this.makeHtml(rsFlowData, rsSkuDomain, htmlMap, rsResourceGoodsReDomain)) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsSkuHtml.makeHtml", (Object)rsFlowData.getFdCode());
                return false;
            }
        }
        htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(htmlMap));
        return this.sendHtml(htmlRelease);
    }

    private boolean sendGoods(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        if (null == rsFlowData || null == rsSenddataList) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        if (null == rsResourceGoodsReDomain) {
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        }
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(rsFlowData.getTenantCode());
        htmlRelease.setHtmldataCode("RsResourceGoods");
        htmlRelease.setHtmldataFilename(rsFlowData.getFdBizcode() + ".html");
        htmlRelease.setHtmldataFilepath("goods");
        if (!"2020050600004084".equals(rsFlowData.getTenantCode()) && !this.sendGoodsSkuHtml(htmlRelease, rsFlowData, rsResourceGoodsReDomain)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendGoods.sendGoodsSkuHtml", (Object)rsFlowData.getFdCode());
            return false;
        }
        StoreDomain storeDomain = new StoreDomain();
        List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
        if (ListUtil.isEmpty(rsSkuDomainList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendGoods.getRsSkuDomainList", (Object)rsFlowData.getFdCode());
            return false;
        }
        storeDomain.setRequestType(rsFlowData.getEsrequestType());
        if (!(ResourcesConstants.DATA_OPBILLSTATE_1 == rsResourceGoodsReDomain.getDataOpbillstate() || rsFlowData.getEsrequestType().equals("down") || rsFlowData.getEsrequestType().equals("delete") || rsFlowData.getEsrequestType().equals("deleteop"))) {
            storeDomain.setRequestType("down");
        }
        storeDomain.setBizType("goods");
        if (!rsFlowData.getEsrequestType().equals("delete") && !rsFlowData.getEsrequestType().equals("deleteop")) {
            RsSkuDomain rsSkuDomain = rsSkuDomainList.get(0);
            this.makeEsSku(rsResourceGoodsReDomain, storeDomain, rsSkuDomain);
        }
        storeDomain.setBizId(rsFlowData.getTenantCode() + rsFlowData.getFdBizcode());
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        boolean re = false;
        if ("13".equals(rsResourceGoodsReDomain.getGoodsOrigin())) {
            // empty if block
        }
        storeDomain.setBizType("goodsNo");
        storeDomain.setBizId(rsFlowData.getTenantCode() + rsResourceGoodsReDomain.getGoodsType() + rsResourceGoodsReDomain.getGoodsNo());
        if ("13".equals(rsResourceGoodsReDomain.getGoodsOrigin())) {
            // empty if block
        }
        String type = rsFlowData.getEsrequestType();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            if (ResourcesConstants.DATA_OPBILLSTATE_1 != rsSkuDomain.getDataOpbillstate()) {
                if (!(type.equals("down") || type.equals("delete") || type.equals("deleteop"))) {
                    rsFlowData.setEsrequestType("skudown");
                }
            } else {
                rsFlowData.setEsrequestType(type);
            }
            if (re = this.sendSku(rsResourceGoodsReDomain, rsSkuDomain, rsFlowData)) continue;
            return re;
        }
        return true;
    }

    private void makeEsSkuStr(RsResourceGoodsReDomain rsResourceGoodsReDomain, EsSku esSku) {
        if (null == rsResourceGoodsReDomain || null == esSku) {
            return;
        }
        ArrayList<String> goodsWhCodeStr = new ArrayList<String>();
        ArrayList<String> goodsWhNameStr = new ArrayList<String>();
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsWhDomainList())) {
            for (RsGoodsWhDomain rsGoodsWhDomain : rsResourceGoodsReDomain.getRsGoodsWhDomainList()) {
                goodsWhCodeStr.add(rsGoodsWhDomain.getWarehouseCode());
                goodsWhNameStr.add(rsGoodsWhDomain.getWarehouseName());
            }
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getWarehouseCode())) {
            goodsWhCodeStr.add(rsResourceGoodsReDomain.getWarehouseCode());
            goodsWhNameStr.add(rsResourceGoodsReDomain.getWarehouseName());
        }
        if (ListUtil.isNotEmpty(goodsWhCodeStr)) {
            esSku.setGoodsWhCodeStr(goodsWhCodeStr);
            esSku.setGoodsWhNameStr(goodsWhNameStr);
        }
        ArrayList<String> goodsShopCodeStr = new ArrayList<String>();
        ArrayList<String> goodsShopNameStr = new ArrayList<String>();
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsShopDomainList())) {
            for (RsGoodsShopDomain rsGoodsShopDomain : rsResourceGoodsReDomain.getRsGoodsShopDomainList()) {
                goodsShopCodeStr.add(rsGoodsShopDomain.getGoodsClassCode());
                goodsShopNameStr.add(rsGoodsShopDomain.getGoodsClassName());
            }
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getClasstreeShopcode())) {
            goodsShopCodeStr.add(rsResourceGoodsReDomain.getClasstreeShopcode());
            goodsShopNameStr.add(rsResourceGoodsReDomain.getClasstreeShopname());
        }
        if (ListUtil.isNotEmpty(goodsShopCodeStr)) {
            esSku.setGoodsShopCodeStr(goodsShopCodeStr);
            esSku.setGoodsShopNameStr(goodsShopNameStr);
        }
    }

    private void makeEsSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, StoreDomain storeDomain, RsSkuDomain rsSkuDomain) {
        if (null == rsResourceGoodsReDomain || null == storeDomain || null == rsSkuDomain) {
            return;
        }
        EsSku esSku = new EsSku();
        try {
            BeanUtils.copyAllPropertys((Object)esSku, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)esSku, (Object)rsSkuDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        esSku.setSpecList(rsResourceGoodsReDomain.getRsSpecValueDomainList());
        if ("goods".equals(storeDomain.getBizType())) {
            esSku.setDataPic(rsResourceGoodsReDomain.getDataPic());
            esSku.setDataOpbillstate(rsResourceGoodsReDomain.getDataOpbillstate());
            esSku.setDataOpnextbillstate(rsResourceGoodsReDomain.getDataOpnextbillstate());
            esSku.setDataPicpath(rsResourceGoodsReDomain.getDataPicpath());
            esSku.setDataState(rsResourceGoodsReDomain.getDataState());
            if (null != rsResourceGoodsReDomain.getPricesetAsprice()) {
                esSku.setPricesetAsprice(rsResourceGoodsReDomain.getPricesetAsprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetBaseprice()) {
                esSku.setPricesetBaseprice(rsResourceGoodsReDomain.getPricesetBaseprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetInsideprice()) {
                esSku.setPricesetInsideprice(rsResourceGoodsReDomain.getPricesetInsideprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetMakeprice()) {
                esSku.setPricesetMakeprice(rsResourceGoodsReDomain.getPricesetMakeprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetMakeshow()) {
                esSku.setPricesetMakeshow(rsResourceGoodsReDomain.getPricesetMakeshow());
            }
            if (null != rsResourceGoodsReDomain.getPricesetPrefprice()) {
                esSku.setPricesetPrefprice(rsResourceGoodsReDomain.getPricesetPrefprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetType()) {
                esSku.setPricesetType(rsResourceGoodsReDomain.getPricesetType());
            }
        }
        this.makeEsSkuStr(rsResourceGoodsReDomain, esSku);
        esSku.setRsGoodsFileDomainList(rsSkuDomain.getRsGoodsFileDomainList());
        esSku.setRsSpecValueMap(rsSkuDomain.getRsSpecValueMap());
        esSku.setGoodsNo(rsResourceGoodsReDomain.getGoodsNo());
        esSku.setPntreeCode(rsResourceGoodsReDomain.getPntreeCode());
        esSku.setMemberName(rsResourceGoodsReDomain.getMemberName());
        esSku.setClasstreeName(rsResourceGoodsReDomain.getClasstreeName());
        esSku.setClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode());
        esSku.setPntreeName(rsResourceGoodsReDomain.getPntreeName());
        esSku.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
        esSku.setGoodsProperty(rsResourceGoodsReDomain.getGoodsProperty());
        esSku.setBrandCode(rsResourceGoodsReDomain.getBrandCode());
        esSku.setBrandName(rsResourceGoodsReDomain.getBrandName());
        esSku.setGoodsSpec(null == rsResourceGoodsReDomain.getGoodsSpec() ? "" : rsResourceGoodsReDomain.getGoodsSpec());
        if (null == esSku.getGoodsSalesvolume()) {
            esSku.setGoodsSalesvolume(BigDecimal.ZERO);
        }
        esSku.setPropertiesName(this.rsFlowDataAssistService.getPropertiesName(esSku.getTenantCode(), esSku.getGoodsCode()));
        Map<String, String> specCodeMap = this.getSpec(rsResourceGoodsReDomain, rsSkuDomain);
        String esSkuStr = "";
        if (MapUtil.isNotEmpty(specCodeMap)) {
            esSkuStr = JsonUtil.buildNormalBinder().toJson((Object)esSku);
            HashMap<String, String> remap = (HashMap<String, String>)JsonUtil.buildNormalBinder().getJsonToMap(esSkuStr, String.class, Object.class);
            if (null == remap) {
                remap = new HashMap<String, String>();
            }
            remap.putAll(specCodeMap);
            esSkuStr = JsonUtil.buildNormalBinder().toJson(remap);
        } else {
            esSkuStr = JsonUtil.buildNormalBinder().toJson((Object)esSku);
        }
        storeDomain.setStoreObj((Object)esSkuStr);
    }

    private Map<String, String> getSpec(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain) {
        String[] specStr;
        if (null == rsSkuDomain) {
            return null;
        }
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        String skuName = rsSkuDomain.getSkuName();
        if (StringUtils.isBlank((String)skuName)) {
            return null;
        }
        List<RsSpecValueDomain> rsSpecValueDomainList = rsResourceGoodsReDomain.getRsSpecValueDomainList();
        HashMap<String, String> specValueMap = new HashMap<String, String>();
        if (ListUtil.isEmpty(rsSpecValueDomainList)) {
            HashMap<String, Object> svMap = new HashMap<String, Object>();
            svMap.put("specValueBillno", rsSkuDomain.getGoodsCode());
            svMap.put("tenantCode", rsSkuDomain.getTenantCode());
            QueryResult<RsSpecValue> rsSpecValueListResult = this.getRsSpecValueService().querySpecValuePage(svMap);
            if (null != rsSpecValueListResult && null != rsSpecValueListResult.getList() && rsSpecValueListResult.getList().size() > 0) {
                for (RsSpecValue rsSpecValue : rsSpecValueListResult.getList()) {
                    specValueMap.put(rsSpecValue.getSpecValueValue(), rsSpecValue.getSpecCode());
                }
            }
        } else {
            for (RsSpecValueDomain rsSpecValueDomain : rsSpecValueDomainList) {
                specValueMap.put(rsSpecValueDomain.getSpecValueValue(), rsSpecValueDomain.getSpecCode());
            }
        }
        if (MapUtil.isEmpty(specValueMap)) {
            return null;
        }
        HashMap<String, String> specCodeMap = new HashMap<String, String>();
        for (String value : specStr = skuName.split("/")) {
            String value1 = (String)specValueMap.get(value);
            if (!StringUtils.isNotBlank((String)value1)) continue;
            specCodeMap.put(value1, value);
        }
        return specCodeMap;
    }

    private boolean sendNumMrSku(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        this.logger.error("rs.RsFlowdataServiceImpl.sendNumMrSku.rsFlowData", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsFlowData));
        this.logger.error("rs.RsFlowdataServiceImpl.sendNumMrSku.rsSenddataList", (Object)JsonUtil.buildNonDefaultBinder().toJson(rsSenddataList));
        if (null == rsFlowData) {
            return false;
        }
        if (null == rsSenddataList) {
            rsSenddataList = new ArrayList<RsSenddata>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        RsSkuDomain rsSkuDomain = null;
        rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        if (null == rsSkuDomain) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendNumSku.rsSkuDomain", (Object)((Object)map).toString());
            return true;
        }
        map.put("goodsCode", rsSkuDomain.getGoodsCode());
        rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendNumSku.rsResourceGoodsReDomain", (Object)((Object)map).toString());
            return true;
        }
        HashMap<String, Object> relMap = new HashMap<String, Object>();
        relMap.put("skuNo", rsSkuDomain.getSkuNo());
        relMap.put("tenantCode", rsFlowData.getTenantCode());
        QueryResult<RsGoodsRel> rsGoodsRelQueryResult = this.getRsGoodsOtherService().queryGoodsRelPage(relMap);
        if (null == rsGoodsRelQueryResult || ListUtil.isEmpty((Collection)rsGoodsRelQueryResult.getList())) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendNumSku.rsGoodsRelQueryResult", (Object)((Object)relMap).toString());
            return true;
        }
        ArrayList<ResourceStockDomain> setResourceGoodsList = new ArrayList<ResourceStockDomain>();
        for (RsGoodsRel rsGoodsRel : rsGoodsRelQueryResult.getList()) {
            RsSku rsSku;
            HashMap<String, Object> mrRelMap = new HashMap<String, Object>();
            mrRelMap.put("goodsSkuCode", rsGoodsRel.getGoodsSkuCode());
            mrRelMap.put("tenantCode", rsFlowData.getTenantCode());
            QueryResult<RsGoodsRel> mrRsGoodsRelQueryResult = this.getRsGoodsOtherService().queryGoodsRelPage(mrRelMap);
            if (null == mrRsGoodsRelQueryResult || ListUtil.isEmpty((Collection)mrRsGoodsRelQueryResult.getList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendNumSku.mrRsGoodsRelQueryResult", (Object)((Object)map).toString());
                continue;
            }
            if (StringUtils.isBlank((String)rsGoodsRel.getGoodsSkuCode()) || null == (rsSku = this.getRsSkuService().getSkuByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{rsGoodsRel.getGoodsSkuCode(), rsGoodsRel.getTenantCode()})))) continue;
            setResourceGoodsList.add(this.create(rsSku, null, null, mrRsGoodsRelQueryResult.getList()));
        }
        if (ListUtil.isNotEmpty(setResourceGoodsList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendNumMrSku.setResourceGoodsList", (Object)JsonUtil.buildNonDefaultBinder().toJson(setResourceGoodsList));
            List<RsSenddata> rsSenddata = this.getRsResourceGoodsService().updateResourceStock(setResourceGoodsList, "5");
            if (ListUtil.isNotEmpty(rsSenddata)) {
                rsSenddataList.addAll(rsSenddata);
            }
        }
        return true;
    }

    private ResourceStockDomain create(RsSku rsSku, ResourceStockDomain parentResourceStockDomain, String channelCode, List<RsGoodsRel> relList) {
        if (null == rsSku) {
            return null;
        }
        ResourceStockDomain resourceStockDomain = new ResourceStockDomain();
        if (StringUtils.isBlank((String)channelCode)) {
            resourceStockDomain.setGoodsCode(rsSku.getGoodsCode());
            resourceStockDomain.setSkuCode(rsSku.getSkuCode());
        } else {
            QueryResult<RsSku> qlist = this.getRsSkuService().querySkuOnePage(this.getQueryMapParam("skuNo,channelCode,tenantCode", new Object[]{rsSku.getSkuNo(), channelCode, rsSku.getTenantCode()}));
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                return null;
            }
            resourceStockDomain.setGoodsCode(((RsSku)qlist.getList().get(0)).getGoodsCode());
            resourceStockDomain.setSkuCode(((RsSku)qlist.getList().get(0)).getSkuCode());
        }
        if (null == rsSku.getGoodsNum()) {
            rsSku.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == rsSku.getGoodsWeight()) {
            rsSku.setGoodsWeight(BigDecimal.ZERO);
        }
        for (RsGoodsRel rsGoodsRel : relList) {
            RsSku relRsSku = this.getRsSkuService().getSkuByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{rsGoodsRel.getSkuCode(), rsGoodsRel.getTenantCode()}));
            BigDecimal divide = relRsSku.getGoodsSupplynum().divide(rsGoodsRel.getGoodsRelNum(), 4);
            if (null == resourceStockDomain.getGoodsNum()) {
                resourceStockDomain.setGoodsNum(divide);
                continue;
            }
            if (-1 != divide.compareTo(resourceStockDomain.getGoodsNum())) continue;
            resourceStockDomain.setGoodsNum(divide);
        }
        resourceStockDomain.setGoodsNum(new BigDecimal(resourceStockDomain.getGoodsNum().intValue()));
        resourceStockDomain.setTenantCode(rsSku.getTenantCode());
        resourceStockDomain.setType("5");
        return resourceStockDomain;
    }

    public static void main(String[] args) {
        String[] specStr;
        String skuName = "add/sada";
        for (String value : specStr = skuName.split("/")) {
            System.out.println(value);
        }
    }

    static {
        lock = new Object();
        oplock = new Object();
        numlock = new Object();
        chlock = new Object();
        DISCHANNEL_TYPE_ONLINE = "0";
        DISCHANNEL_TYPE_THRID = "2";
        DISCHANNEL_TYPE_STORE = "1";
        DISCHANNEL_SALE = "0";
        DISCHANNEL_CON = "1";
        DISCHANNEL_BUS = "2";
    }
}

