/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.saleforecast.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.saleforecast.dao.StSalequotaMapper;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaReDomain;
import com.yqbsoft.laser.service.saleforecast.model.StSalequota;
import com.yqbsoft.laser.service.saleforecast.service.StSalequotaService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StSalequotaServiceImpl
extends BaseServiceImpl
implements StSalequotaService {
    private static final String SYS_CODE = "st.StSalequotaServiceImpl";
    private StSalequotaMapper stSalequotaMapper;

    public void setStSalequotaMapper(StSalequotaMapper stSalequotaMapper) {
        this.stSalequotaMapper = stSalequotaMapper;
    }

    private Date getSysDate() {
        try {
            return this.stSalequotaMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSalequota(StSalequotaDomain stSalequotaDomain) {
        if (null == stSalequotaDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)stSalequotaDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSalequotaDefault(StSalequota stSalequota) {
        if (null == stSalequota) {
            return;
        }
        if (null == stSalequota.getDataState()) {
            stSalequota.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == stSalequota.getGmtCreate()) {
            stSalequota.setGmtCreate(date);
        }
        stSalequota.setGmtModified(date);
        if (StringUtils.isBlank((String)stSalequota.getSalequotaCode())) {
            stSalequota.setSalequotaCode(this.getNo(null, "StSalequota", "stSalequota", stSalequota.getTenantCode()));
        }
    }

    private int getSalequotaMaxCode() {
        int code = 0;
        try {
            return this.stSalequotaMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSalequotaMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSalequotaUpdataDefault(StSalequota stSalequota) {
        if (null == stSalequota) {
            return;
        }
        stSalequota.setGmtModified(this.getSysDate());
    }

    private void saveSalequotaModel(StSalequota stSalequota) throws ApiException {
        if (null == stSalequota) {
            return;
        }
        try {
            this.stSalequotaMapper.insert(stSalequota);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.saveSalequotaModel.ex", (Throwable)e);
        }
    }

    private void saveSalequotaBatchModel(List<StSalequota> stSalequotaList) throws ApiException {
        if (null == stSalequotaList || stSalequotaList.isEmpty()) {
            return;
        }
        try {
            this.stSalequotaMapper.insertBatch(stSalequotaList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.saveSalequotaBatchModel.ex", (Throwable)e);
        }
    }

    private StSalequota getSalequotaModelById(Integer salequotaId) {
        if (null == salequotaId) {
            return null;
        }
        try {
            return this.stSalequotaMapper.selectByPrimaryKey(salequotaId);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSalequotaModelById", (Throwable)e);
            return null;
        }
    }

    private StSalequota getSalequotaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.stSalequotaMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSalequotaModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSalequotaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.delSalequotaModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaServiceImpl.delSalequotaModelByCode.num");
        }
    }

    private void deleteSalequotaModel(Integer salequotaId) throws ApiException {
        if (null == salequotaId) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.deleteByPrimaryKey(salequotaId);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.deleteSalequotaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaServiceImpl.deleteSalequotaModel.num");
        }
    }

    private void updateSalequotaModel(StSalequota stSalequota) throws ApiException {
        if (null == stSalequota) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.updateByPrimaryKey(stSalequota);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequotaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequotaModel.num");
        }
    }

    private void updateStateSalequotaModel(Integer salequotaId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == salequotaId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salequotaId", salequotaId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModel.null");
        }
    }

    private void updateStateSalequotaModelByCode(String tenantCode, String salequotaCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModelByCode.null");
        }
    }

    private StSalequota makeSalequota(StSalequotaDomain stSalequotaDomain, StSalequota stSalequota) {
        if (null == stSalequotaDomain) {
            return null;
        }
        if (null == stSalequota) {
            stSalequota = new StSalequota();
        }
        try {
            BeanUtils.copyAllPropertys((Object)stSalequota, (Object)stSalequotaDomain);
            return stSalequota;
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.makeSalequota", (Throwable)e);
            return null;
        }
    }

    private StSalequotaReDomain makeStSalequotaReDomain(StSalequota stSalequota) {
        if (null == stSalequota) {
            return null;
        }
        StSalequotaReDomain stSalequotaReDomain = new StSalequotaReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)stSalequotaReDomain, (Object)stSalequota);
            return stSalequotaReDomain;
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.makeStSalequotaReDomain", (Throwable)e);
            return null;
        }
    }

    private List<StSalequota> querySalequotaModelPage(Map<String, Object> parammap) {
        try {
            return this.stSalequotaMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.querySalequotaModel", (Throwable)e);
            return null;
        }
    }

    private int countSalequota(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.stSalequotaMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.countSalequota", (Throwable)e);
        }
        return i;
    }

    private StSalequota createStSalequota(StSalequotaDomain stSalequotaDomain) {
        String msg = this.checkSalequota(stSalequotaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaServiceImpl.saveSalequota.checkSalequota", msg);
        }
        StSalequota stSalequota = this.makeSalequota(stSalequotaDomain, null);
        this.setSalequotaDefault(stSalequota);
        return stSalequota;
    }

    @Override
    public String saveSalequota(StSalequotaDomain stSalequotaDomain) throws ApiException {
        StSalequota stSalequota = this.createStSalequota(stSalequotaDomain);
        this.saveSalequotaModel(stSalequota);
        return stSalequota.getSalequotaCode();
    }

    @Override
    public String saveSalequotaBatch(List<StSalequotaDomain> stSalequotaDomainList) throws ApiException {
        if (null == stSalequotaDomainList || stSalequotaDomainList.isEmpty()) {
            return null;
        }
        ArrayList<StSalequota> stSalequotaList = new ArrayList<StSalequota>();
        String code = "";
        for (StSalequotaDomain stSalequotaDomain : stSalequotaDomainList) {
            StSalequota stSalequota = this.createStSalequota(stSalequotaDomain);
            code = stSalequota.getSalequotaCode();
            stSalequotaList.add(stSalequota);
        }
        this.saveSalequotaBatchModel(stSalequotaList);
        return code;
    }

    @Override
    public void updateSalequotaState(Integer salequotaId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == salequotaId) {
            return;
        }
        this.updateStateSalequotaModel(salequotaId, dataState, oldDataState, map);
    }

    @Override
    public void updateSalequotaStateByCode(String tenantCode, String salequotaCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSalequotaModelByCode(tenantCode, salequotaCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSalequota(StSalequotaDomain stSalequotaDomain) throws ApiException {
        String msg = this.checkSalequota(stSalequotaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequota.checkSalequota", msg);
        }
        StSalequota oldStSalequota = this.getSalequotaModelById(stSalequotaDomain.getSalequotaId());
        if (null == oldStSalequota) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequota.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        StSalequota stSalequota = this.makeSalequota(stSalequotaDomain, oldStSalequota);
        this.setSalequotaUpdataDefault(stSalequota);
        this.updateSalequotaModel(stSalequota);
    }

    @Override
    public StSalequota getSalequota(Integer salequotaId) {
        if (null == salequotaId) {
            return null;
        }
        return this.getSalequotaModelById(salequotaId);
    }

    @Override
    public void deleteSalequota(Integer salequotaId) throws ApiException {
        if (null == salequotaId) {
            return;
        }
        this.deleteSalequotaModel(salequotaId);
    }

    @Override
    public QueryResult<StSalequota> querySalequotaPage(Map<String, Object> map) {
        List<StSalequota> stSalequotaList = this.querySalequotaModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSalequota(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(stSalequotaList);
        return queryResult;
    }

    @Override
    public StSalequota getSalequotaByCode(String tenantCode, String salequotaCode) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        return this.getSalequotaModelByCode(map);
    }

    @Override
    public void deleteSalequotaByCode(String tenantCode, String salequotaCode) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        this.delSalequotaModelByCode(map);
    }
}

