/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sub.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sub.dao.SubUsersubMapper;
import com.yqbsoft.laser.service.sub.domain.SubUsersubDomain;
import com.yqbsoft.laser.service.sub.domain.SubUsersubListDomain;
import com.yqbsoft.laser.service.sub.domain.SubUsersubReDomain;
import com.yqbsoft.laser.service.sub.model.SubUsersub;
import com.yqbsoft.laser.service.sub.model.SubUsersubList;
import com.yqbsoft.laser.service.sub.service.SubUsersubListService;
import com.yqbsoft.laser.service.sub.service.SubUsersubService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubUsersubServiceImpl
extends BaseServiceImpl
implements SubUsersubService {
    private static final String SYS_CODE = "sub.SubUsersubServiceImpl";
    private SubUsersubMapper subUsersubMapper;
    private SubUsersubListService subUsersubListService;

    public void setSubUsersubMapper(SubUsersubMapper subUsersubMapper) {
        this.subUsersubMapper = subUsersubMapper;
    }

    public void setSubUsersubListService(SubUsersubListService subUsersubListService) {
        this.subUsersubListService = subUsersubListService;
    }

    private Date getSysDate() {
        try {
            return this.subUsersubMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sub.SubUsersubServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUsersub(SubUsersubDomain subUsersubDomain) {
        if (null == subUsersubDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)subUsersubDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUsersubDefault(SubUsersub subUsersub) {
        if (null == subUsersub) {
            return;
        }
        if (null == subUsersub.getDataState()) {
            subUsersub.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == subUsersub.getGmtCreate()) {
            subUsersub.setGmtCreate(date);
        }
        subUsersub.setGmtModified(date);
        if (StringUtils.isBlank((String)subUsersub.getUsersubCode())) {
            subUsersub.setUsersubCode(this.getNo(null, "SubUsersub", "subUsersub", subUsersub.getTenantCode()));
        }
    }

    private int getUsersubMaxCode() {
        int code = 0;
        try {
            return this.subUsersubMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sub.SubUsersubServiceImpl.getUsersubMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUsersubUpdataDefault(SubUsersub subUsersub) {
        if (null == subUsersub) {
            return;
        }
        subUsersub.setGmtModified(this.getSysDate());
    }

    private void saveUsersubModel(SubUsersub subUsersub) throws ApiException {
        if (null == subUsersub) {
            return;
        }
        try {
            this.subUsersubMapper.insert(subUsersub);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubUsersubServiceImpl.saveUsersubModel.ex", (Throwable)e);
        }
    }

    private void saveUsersubBatchModel(List<SubUsersub> subUsersubList) throws ApiException {
        if (null == subUsersubList || subUsersubList.isEmpty()) {
            return;
        }
        try {
            this.subUsersubMapper.insertBatch(subUsersubList);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubUsersubServiceImpl.saveUsersubBatchModel.ex", (Throwable)e);
        }
    }

    private SubUsersub getUsersubModelById(Integer usersubId) {
        if (null == usersubId) {
            return null;
        }
        try {
            return this.subUsersubMapper.selectByPrimaryKey(usersubId);
        }
        catch (Exception e) {
            this.logger.error("sub.SubUsersubServiceImpl.getUsersubModelById", (Throwable)e);
            return null;
        }
    }

    private SubUsersub getUsersubModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.subUsersubMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sub.SubUsersubServiceImpl.getUsersubModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUsersubModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.subUsersubMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubUsersubServiceImpl.delUsersubModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sub.SubUsersubServiceImpl.delUsersubModelByCode.num");
        }
    }

    private void deleteUsersubModel(Integer usersubId) throws ApiException {
        if (null == usersubId) {
            return;
        }
        int i = 0;
        try {
            i = this.subUsersubMapper.deleteByPrimaryKey(usersubId);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubUsersubServiceImpl.deleteUsersubModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sub.SubUsersubServiceImpl.deleteUsersubModel.num");
        }
    }

    private void updateUsersubModel(SubUsersub subUsersub) throws ApiException {
        if (null == subUsersub) {
            return;
        }
        int i = 0;
        try {
            i = this.subUsersubMapper.updateByPrimaryKey(subUsersub);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubUsersubServiceImpl.updateUsersubModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sub.SubUsersubServiceImpl.updateUsersubModel.num");
        }
    }

    private void updateStateUsersubModel(Integer usersubId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == usersubId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usersubId", usersubId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.subUsersubMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubUsersubServiceImpl.updateStateUsersubModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sub.SubUsersubServiceImpl.updateStateUsersubModel.null");
        }
    }

    private void updateStateUsersubModelByCode(String tenantCode, String usersubCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)usersubCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usersubCode", usersubCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.subUsersubMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubUsersubServiceImpl.updateStateUsersubModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sub.SubUsersubServiceImpl.updateStateUsersubModelByCode.null");
        }
    }

    private SubUsersub makeUsersub(SubUsersubDomain subUsersubDomain, SubUsersub subUsersub) {
        if (null == subUsersubDomain) {
            return null;
        }
        if (null == subUsersub) {
            subUsersub = new SubUsersub();
        }
        try {
            BeanUtils.copyAllPropertys((Object)subUsersub, (Object)subUsersubDomain);
            return subUsersub;
        }
        catch (Exception e) {
            this.logger.error("sub.SubUsersubServiceImpl.makeUsersub", (Throwable)e);
            return null;
        }
    }

    private SubUsersubReDomain makeSubUsersubReDomain(SubUsersub subUsersub) {
        if (null == subUsersub) {
            return null;
        }
        SubUsersubReDomain subUsersubReDomain = new SubUsersubReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)subUsersubReDomain, (Object)subUsersub);
            return subUsersubReDomain;
        }
        catch (Exception e) {
            this.logger.error("sub.SubUsersubServiceImpl.makeSubUsersubReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SubUsersub> queryUsersubModelPage(Map<String, Object> parammap) {
        try {
            return this.subUsersubMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sub.SubUsersubServiceImpl.queryUsersubModel", (Throwable)e);
            return null;
        }
    }

    private int countUsersub(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.subUsersubMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sub.SubUsersubServiceImpl.countUsersub", (Throwable)e);
        }
        return i;
    }

    private SubUsersub createSubUsersub(SubUsersubDomain subUsersubDomain) {
        String msg = this.checkUsersub(subUsersubDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sub.SubUsersubServiceImpl.saveUsersub.checkUsersub", msg);
        }
        SubUsersub subUsersub = this.makeUsersub(subUsersubDomain, null);
        this.setUsersubDefault(subUsersub);
        return subUsersub;
    }

    @Override
    public String saveUsersub(SubUsersubDomain subUsersubDomain) throws ApiException {
        SubUsersub subUsersub = this.createSubUsersub(subUsersubDomain);
        this.saveUsersubModel(subUsersub);
        return subUsersub.getUsersubCode();
    }

    @Override
    public String saveUsersubBatch(List<SubUsersubDomain> subUsersubDomainList) throws ApiException {
        if (null == subUsersubDomainList || subUsersubDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SubUsersub> subUsersubList = new ArrayList<SubUsersub>();
        String code = "";
        for (SubUsersubDomain subUsersubDomain : subUsersubDomainList) {
            SubUsersub subUsersub = this.createSubUsersub(subUsersubDomain);
            code = subUsersub.getUsersubCode();
            subUsersubList.add(subUsersub);
        }
        this.saveUsersubBatchModel(subUsersubList);
        return code;
    }

    @Override
    public void updateUsersubState(Integer usersubId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == usersubId) {
            return;
        }
        this.updateStateUsersubModel(usersubId, dataState, oldDataState, map);
    }

    @Override
    public void updateUsersubStateByCode(String tenantCode, String usersubCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)usersubCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUsersubModelByCode(tenantCode, usersubCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUsersub(SubUsersubDomain subUsersubDomain) throws ApiException {
        String msg = this.checkUsersub(subUsersubDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sub.SubUsersubServiceImpl.updateUsersub.checkUsersub", msg);
        }
        SubUsersub oldSubUsersub = this.getUsersubModelById(subUsersubDomain.getUsersubId());
        if (null == oldSubUsersub) {
            throw new ApiException("sub.SubUsersubServiceImpl.updateUsersub.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SubUsersub subUsersub = this.makeUsersub(subUsersubDomain, oldSubUsersub);
        this.setUsersubUpdataDefault(subUsersub);
        this.updateUsersubModel(subUsersub);
    }

    @Override
    public SubUsersub getUsersub(Integer usersubId) {
        if (null == usersubId) {
            return null;
        }
        return this.getUsersubModelById(usersubId);
    }

    @Override
    public void deleteUsersub(Integer usersubId) throws ApiException {
        if (null == usersubId) {
            return;
        }
        this.deleteUsersubModel(usersubId);
    }

    @Override
    public QueryResult<SubUsersub> queryUsersubPage(Map<String, Object> map) {
        List<SubUsersub> subUsersubList = this.queryUsersubModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUsersub(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(subUsersubList);
        return queryResult;
    }

    @Override
    public SubUsersub getUsersubByCode(String tenantCode, String usersubCode) throws ApiException {
        if (StringUtils.isBlank((String)usersubCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usersubCode", usersubCode);
        return this.getUsersubModelByCode(map);
    }

    @Override
    public void deleteUsersubByCode(String tenantCode, String usersubCode) throws ApiException {
        if (StringUtils.isBlank((String)usersubCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usersubCode", usersubCode);
        this.delUsersubModelByCode(map);
    }

    @Override
    public List<SubUsersubList> saveSubStitle(String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        QueryResult<SubUsersub> usersubQueryResult = this.queryUsersubPage(map);
        if (null == usersubQueryResult || ListUtil.isEmpty((Collection)usersubQueryResult.getList())) {
            this.logger.error("sendQuerySubuser", (Object)"usersubQueryResult is null");
            return null;
        }
        ArrayList<SubUsersubList> listDomains = new ArrayList<SubUsersubList>();
        for (SubUsersub subUsersub : usersubQueryResult.getList()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            Date newDate = new Date();
            String newDateStr = sdf.format(newDate);
            if (!newDateStr.equals(subUsersub.getUsersubCon())) continue;
            SubUsersubListDomain usersubListDomain = new SubUsersubListDomain();
            try {
                BeanUtils.copyAllPropertys((Object)usersubListDomain, (Object)subUsersub);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            usersubListDomain.setTenantCode(tenantCode);
            String userSubListCode = this.subUsersubListService.saveUsersubList(usersubListDomain);
            if (StringUtils.isBlank((String)userSubListCode)) {
                this.logger.error("sendQuerySubuser", (Object)"userSubListCode is null");
                return null;
            }
            SubUsersubList subUsersubList = this.subUsersubListService.getUsersubListByCode(subUsersub.getTenantCode(), userSubListCode);
            this.logger.error("subUsersubList-------" + JsonUtil.buildNormalBinder().toJson((Object)subUsersubList));
            listDomains.add(subUsersubList);
        }
        return listDomains;
    }
}

