/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sub.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sub.dao.SubStoolMapper;
import com.yqbsoft.laser.service.sub.domain.SubStoolDomain;
import com.yqbsoft.laser.service.sub.domain.SubStoolReDomain;
import com.yqbsoft.laser.service.sub.model.SubStool;
import com.yqbsoft.laser.service.sub.model.SubUsersubList;
import com.yqbsoft.laser.service.sub.service.SubStoolService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.util.internal.ConcurrentHashMap;

public class SubStoolServiceImpl
extends BaseServiceImpl
implements SubStoolService {
    private static final String SYS_CODE = "sub.SubStoolServiceImpl";
    private SubStoolMapper subStoolMapper;

    public void setSubStoolMapper(SubStoolMapper subStoolMapper) {
        this.subStoolMapper = subStoolMapper;
    }

    private Date getSysDate() {
        try {
            return this.subStoolMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sub.SubStoolServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStool(SubStoolDomain subStoolDomain) {
        if (null == subStoolDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)subStoolDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStoolDefault(SubStool subStool) {
        if (null == subStool) {
            return;
        }
        if (null == subStool.getDataState()) {
            subStool.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == subStool.getGmtCreate()) {
            subStool.setGmtCreate(date);
        }
        subStool.setGmtModified(date);
        if (StringUtils.isBlank((String)subStool.getStoolCode())) {
            subStool.setStoolCode(this.getNo(null, "SubStool", "subStool", subStool.getTenantCode()));
        }
    }

    private int getStoolMaxCode() {
        int code = 0;
        try {
            return this.subStoolMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sub.SubStoolServiceImpl.getStoolMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoolUpdataDefault(SubStool subStool) {
        if (null == subStool) {
            return;
        }
        subStool.setGmtModified(this.getSysDate());
    }

    private void saveStoolModel(SubStool subStool) throws ApiException {
        if (null == subStool) {
            return;
        }
        try {
            this.subStoolMapper.insert(subStool);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubStoolServiceImpl.saveStoolModel.ex", (Throwable)e);
        }
    }

    private void saveStoolBatchModel(List<SubStool> subStoolList) throws ApiException {
        if (null == subStoolList || subStoolList.isEmpty()) {
            return;
        }
        try {
            this.subStoolMapper.insertBatch(subStoolList);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubStoolServiceImpl.saveStoolBatchModel.ex", (Throwable)e);
        }
    }

    private SubStool getStoolModelById(Integer stoolId) {
        if (null == stoolId) {
            return null;
        }
        try {
            return this.subStoolMapper.selectByPrimaryKey(stoolId);
        }
        catch (Exception e) {
            this.logger.error("sub.SubStoolServiceImpl.getStoolModelById", (Throwable)e);
            return null;
        }
    }

    private SubStool getStoolModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.subStoolMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sub.SubStoolServiceImpl.getStoolModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStoolModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.subStoolMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubStoolServiceImpl.delStoolModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sub.SubStoolServiceImpl.delStoolModelByCode.num");
        }
    }

    private void deleteStoolModel(Integer stoolId) throws ApiException {
        if (null == stoolId) {
            return;
        }
        int i = 0;
        try {
            i = this.subStoolMapper.deleteByPrimaryKey(stoolId);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubStoolServiceImpl.deleteStoolModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sub.SubStoolServiceImpl.deleteStoolModel.num");
        }
    }

    private void updateStoolModel(SubStool subStool) throws ApiException {
        if (null == subStool) {
            return;
        }
        int i = 0;
        try {
            i = this.subStoolMapper.updateByPrimaryKey(subStool);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubStoolServiceImpl.updateStoolModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sub.SubStoolServiceImpl.updateStoolModel.num");
        }
    }

    private void updateStateStoolModel(Integer stoolId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == stoolId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stoolId", stoolId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.subStoolMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubStoolServiceImpl.updateStateStoolModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sub.SubStoolServiceImpl.updateStateStoolModel.null");
        }
    }

    private void updateStateStoolModelByCode(String tenantCode, String stoolCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)stoolCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("stoolCode", stoolCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.subStoolMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sub.SubStoolServiceImpl.updateStateStoolModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sub.SubStoolServiceImpl.updateStateStoolModelByCode.null");
        }
    }

    private SubStool makeStool(SubStoolDomain subStoolDomain, SubStool subStool) {
        if (null == subStoolDomain) {
            return null;
        }
        if (null == subStool) {
            subStool = new SubStool();
        }
        try {
            BeanUtils.copyAllPropertys((Object)subStool, (Object)subStoolDomain);
            return subStool;
        }
        catch (Exception e) {
            this.logger.error("sub.SubStoolServiceImpl.makeStool", (Throwable)e);
            return null;
        }
    }

    private SubStoolReDomain makeSubStoolReDomain(SubStool subStool) {
        if (null == subStool) {
            return null;
        }
        SubStoolReDomain subStoolReDomain = new SubStoolReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)subStoolReDomain, (Object)subStool);
            return subStoolReDomain;
        }
        catch (Exception e) {
            this.logger.error("sub.SubStoolServiceImpl.makeSubStoolReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SubStool> queryStoolModelPage(Map<String, Object> parammap) {
        try {
            return this.subStoolMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sub.SubStoolServiceImpl.queryStoolModel", (Throwable)e);
            return null;
        }
    }

    private int countStool(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.subStoolMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sub.SubStoolServiceImpl.countStool", (Throwable)e);
        }
        return i;
    }

    private SubStool createSubStool(SubStoolDomain subStoolDomain) {
        String msg = this.checkStool(subStoolDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sub.SubStoolServiceImpl.saveStool.checkStool", msg);
        }
        SubStool subStool = this.makeStool(subStoolDomain, null);
        this.setStoolDefault(subStool);
        return subStool;
    }

    @Override
    public String saveStool(SubStoolDomain subStoolDomain) throws ApiException {
        SubStool subStool = this.createSubStool(subStoolDomain);
        this.saveStoolModel(subStool);
        return subStool.getStoolCode();
    }

    @Override
    public String saveStoolBatch(List<SubStoolDomain> subStoolDomainList) throws ApiException {
        if (null == subStoolDomainList || subStoolDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SubStool> subStoolList = new ArrayList<SubStool>();
        String code = "";
        for (SubStoolDomain subStoolDomain : subStoolDomainList) {
            SubStool subStool = this.createSubStool(subStoolDomain);
            code = subStool.getStoolCode();
            subStoolList.add(subStool);
        }
        this.saveStoolBatchModel(subStoolList);
        return code;
    }

    @Override
    public void updateStoolState(Integer stoolId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == stoolId) {
            return;
        }
        this.updateStateStoolModel(stoolId, dataState, oldDataState, map);
    }

    @Override
    public void updateStoolStateByCode(String tenantCode, String stoolCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)stoolCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStoolModelByCode(tenantCode, stoolCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStool(SubStoolDomain subStoolDomain) throws ApiException {
        String msg = this.checkStool(subStoolDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sub.SubStoolServiceImpl.updateStool.checkStool", msg);
        }
        SubStool oldSubStool = this.getStoolModelById(subStoolDomain.getStoolId());
        if (null == oldSubStool) {
            throw new ApiException("sub.SubStoolServiceImpl.updateStool.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SubStool subStool = this.makeStool(subStoolDomain, oldSubStool);
        this.setStoolUpdataDefault(subStool);
        this.updateStoolModel(subStool);
    }

    @Override
    public SubStool getStool(Integer stoolId) {
        if (null == stoolId) {
            return null;
        }
        return this.getStoolModelById(stoolId);
    }

    @Override
    public void deleteStool(Integer stoolId) throws ApiException {
        if (null == stoolId) {
            return;
        }
        this.deleteStoolModel(stoolId);
    }

    @Override
    public QueryResult<SubStool> queryStoolPage(Map<String, Object> map) {
        List<SubStool> subStoolList = this.queryStoolModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStool(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(subStoolList);
        return queryResult;
    }

    @Override
    public SubStool getStoolByCode(String tenantCode, String stoolCode) throws ApiException {
        if (StringUtils.isBlank((String)stoolCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("stoolCode", stoolCode);
        return this.getStoolModelByCode(map);
    }

    @Override
    public void deleteStoolByCode(String tenantCode, String stoolCode) throws ApiException {
        if (StringUtils.isBlank((String)stoolCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("stoolCode", stoolCode);
        this.delStoolModelByCode(map);
    }

    @Override
    public String sendUserSubListByEmail(SubUsersubList subUsersubListDomain) throws ApiException {
        if (null == subUsersubListDomain) {
            this.logger.error("sub.SubStoolServiceImplsendUserSubListByEmail", (Object)"subUsersubListDomain is null");
            return null;
        }
        SubStool subStool = this.getStoolByCode(subUsersubListDomain.getTenantCode(), subUsersubListDomain.getStoolCode());
        ConcurrentHashMap mnsMap = new ConcurrentHashMap();
        mnsMap.put("mnslistSubject", "");
        mnsMap.put("mnslistSource", "0");
        mnsMap.put("mnslistBustype", subStool.getStoolType());
        mnsMap.put("mnslistBusname", subStool.getStoolDesc());
        mnsMap.put("mnslistExp", this.getMnslistExp(subStool.getStoolDesc(), subUsersubListDomain.getUsersubListContext(), subStool.getStoolType().toString(), null, null));
        mnsMap.put("tenantCode", subUsersubListDomain.getTenantCode());
        ConcurrentHashMap sendMap = new ConcurrentHashMap();
        sendMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson((Object)mnsMap));
        Object res = this.getInternalRouter().inInvoke("mns.ser.sendMnslist", "1.0", "0", (Map)sendMap);
        if (null == res) {
            res = "";
        }
        return null;
    }

    private String getMnslistExp(String host, String random, String businessType, String time, String appName) {
        if (StringUtils.isEmpty((String)random)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        ArrayList listReceiver = new ArrayList();
        HashMap<String, String> mapReceiver = new HashMap<String, String>();
        mapReceiver.put("code", "");
        mapReceiver.put("name", "");
        mapReceiver.put("telphone", host);
        mapReceiver.put("email", host);
        listReceiver.add(mapReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
        map.put("theme", host);
        map.put("businessType", businessType);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("random", random);
        paramMap.put("time", time);
        if (StringUtils.isNotBlank((String)appName)) {
            paramMap.put("appName", appName);
        }
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }
}

