/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sw.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.sw.dao.SwSensitivewordMapper;
import com.yqbsoft.laser.service.sw.domain.SwSensitivewordDomain;
import com.yqbsoft.laser.service.sw.domain.SwSensitivewordReDomain;
import com.yqbsoft.laser.service.sw.model.SwSensitiveword;
import com.yqbsoft.laser.service.sw.service.SwSensitivewordService;
import com.yqbsoft.laser.service.sw.util.SensitiveWordUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SwSensitivewordServiceImpl
extends BaseServiceImpl
implements SwSensitivewordService {
    private static final String SYS_CODE = "sw.SwSensitivewordServiceImpl";
    private SwSensitivewordMapper swSensitivewordMapper;

    public void setSwSensitivewordMapper(SwSensitivewordMapper swSensitivewordMapper) {
        this.swSensitivewordMapper = swSensitivewordMapper;
    }

    private Date getSysDate() {
        try {
            return this.swSensitivewordMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sw.SwSensitivewordServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSensitiveword(SwSensitivewordDomain swSensitivewordDomain) {
        if (null == swSensitivewordDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)swSensitivewordDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSensitivewordDefault(SwSensitiveword swSensitiveword) {
        if (null == swSensitiveword) {
            return;
        }
        if (null == swSensitiveword.getDataState()) {
            swSensitiveword.setDataState(0);
        }
        if (null == swSensitiveword.getGmtCreate()) {
            swSensitiveword.setGmtCreate(this.getSysDate());
        }
        swSensitiveword.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)swSensitiveword.getSwCode())) {
            swSensitiveword.setSwCode(this.createUUIDString());
        }
    }

    private int getSensitivewordMaxCode() {
        int code = 0;
        try {
            return this.swSensitivewordMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sw.SwSensitivewordServiceImpl.getSensitivewordMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSensitivewordUpdataDefault(SwSensitiveword swSensitiveword) {
        if (null == swSensitiveword) {
            return;
        }
        swSensitiveword.setGmtModified(this.getSysDate());
    }

    private void saveSensitivewordModel(SwSensitiveword swSensitiveword) throws ApiException {
        if (null == swSensitiveword) {
            return;
        }
        try {
            this.swSensitivewordMapper.insert(swSensitiveword);
        }
        catch (Exception e) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.saveSensitivewordModel.ex", (Throwable)e);
        }
    }

    private void saveSensitivewordBatchModel(List<SwSensitiveword> swSensitivewordList) throws ApiException {
        if (null == swSensitivewordList || swSensitivewordList.isEmpty()) {
            return;
        }
        try {
            this.swSensitivewordMapper.insertBatch(swSensitivewordList);
        }
        catch (Exception e) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.saveSensitivewordBatchModel.ex", (Throwable)e);
        }
    }

    private SwSensitiveword getSensitivewordModelById(Integer swId) {
        if (null == swId) {
            return null;
        }
        try {
            return this.swSensitivewordMapper.selectByPrimaryKey(swId);
        }
        catch (Exception e) {
            this.logger.error("sw.SwSensitivewordServiceImpl.getSensitivewordModelById", (Throwable)e);
            return null;
        }
    }

    private SwSensitiveword getSensitivewordModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.swSensitivewordMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sw.SwSensitivewordServiceImpl.getSensitivewordModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSensitivewordModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.swSensitivewordMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.delSensitivewordModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.delSensitivewordModelByCode.num");
        }
    }

    private void deleteSensitivewordModel(Integer swId) throws ApiException {
        if (null == swId) {
            return;
        }
        int i = 0;
        try {
            i = this.swSensitivewordMapper.deleteByPrimaryKey(swId);
        }
        catch (Exception e) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.deleteSensitivewordModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.deleteSensitivewordModel.num");
        }
    }

    private void updateSensitivewordModel(SwSensitiveword swSensitiveword) throws ApiException {
        if (null == swSensitiveword) {
            return;
        }
        int i = 0;
        try {
            i = this.swSensitivewordMapper.updateByPrimaryKeySelective(swSensitiveword);
        }
        catch (Exception e) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.updateSensitivewordModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.updateSensitivewordModel.num");
        }
    }

    private void updateStateSensitivewordModel(Integer swId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == swId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("swId", swId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.swSensitivewordMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.updateStateSensitivewordModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.updateStateSensitivewordModel.null");
        }
    }

    private void updateStateSensitivewordModelByCode(String tenantCode, String swCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)swCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("swCode", swCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.swSensitivewordMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.updateStateSensitivewordModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.updateStateSensitivewordModelByCode.null");
        }
    }

    private SwSensitiveword makeSensitiveword(SwSensitivewordDomain swSensitivewordDomain, SwSensitiveword swSensitiveword) {
        if (null == swSensitivewordDomain) {
            return null;
        }
        if (null == swSensitiveword) {
            swSensitiveword = new SwSensitiveword();
        }
        try {
            BeanUtils.copyAllPropertys((Object)swSensitiveword, (Object)swSensitivewordDomain);
            return swSensitiveword;
        }
        catch (Exception e) {
            this.logger.error("sw.SwSensitivewordServiceImpl.makeSensitiveword", (Throwable)e);
            return null;
        }
    }

    private SwSensitivewordReDomain makeSwSensitivewordReDomain(SwSensitiveword swSensitiveword) {
        if (null == swSensitiveword) {
            return null;
        }
        SwSensitivewordReDomain swSensitivewordReDomain = new SwSensitivewordReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)swSensitivewordReDomain, (Object)swSensitiveword);
            return swSensitivewordReDomain;
        }
        catch (Exception e) {
            this.logger.error("sw.SwSensitivewordServiceImpl.makeSwSensitivewordReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SwSensitiveword> querySensitivewordModelPage(Map<String, Object> parammap) {
        try {
            return this.swSensitivewordMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sw.SwSensitivewordServiceImpl.querySensitivewordModel", (Throwable)e);
            return null;
        }
    }

    private int countSensitiveword(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.swSensitivewordMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sw.SwSensitivewordServiceImpl.countSensitiveword", (Throwable)e);
        }
        return i;
    }

    private SwSensitiveword createSwSensitiveword(SwSensitivewordDomain swSensitivewordDomain) {
        String msg = this.checkSensitiveword(swSensitivewordDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.saveSensitiveword.checkSensitiveword", msg);
        }
        SwSensitiveword swSensitiveword = this.makeSensitiveword(swSensitivewordDomain, null);
        this.setSensitivewordDefault(swSensitiveword);
        return swSensitiveword;
    }

    @Override
    public String saveSensitiveword(SwSensitivewordDomain swSensitivewordDomain) throws ApiException {
        SwSensitiveword swSensitiveword = this.createSwSensitiveword(swSensitivewordDomain);
        this.saveSensitivewordModel(swSensitiveword);
        return swSensitiveword.getSwCode();
    }

    @Override
    public String saveSensitivewordBatch(List<SwSensitivewordDomain> swSensitivewordDomainList) throws ApiException {
        if (null == swSensitivewordDomainList || swSensitivewordDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SwSensitiveword> swSensitivewordList = new ArrayList<SwSensitiveword>();
        String code = "";
        for (SwSensitivewordDomain swSensitivewordDomain : swSensitivewordDomainList) {
            SwSensitiveword swSensitiveword = this.createSwSensitiveword(swSensitivewordDomain);
            code = swSensitiveword.getSwCode();
            swSensitivewordList.add(swSensitiveword);
        }
        this.saveSensitivewordBatchModel(swSensitivewordList);
        return code;
    }

    @Override
    public void updateSensitivewordState(Integer swId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSensitivewordModel(swId, dataState, oldDataState);
    }

    @Override
    public void updateSensitivewordStateByCode(String tenantCode, String swCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSensitivewordModelByCode(tenantCode, swCode, dataState, oldDataState);
    }

    @Override
    public void updateSensitiveword(SwSensitivewordDomain swSensitivewordDomain) throws ApiException {
        String msg = this.checkSensitiveword(swSensitivewordDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.updateSensitiveword.checkSensitiveword", msg);
        }
        SwSensitiveword oldSwSensitiveword = this.getSensitivewordModelById(swSensitivewordDomain.getSwId());
        if (null == oldSwSensitiveword) {
            throw new ApiException("sw.SwSensitivewordServiceImpl.updateSensitiveword.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SwSensitiveword swSensitiveword = this.makeSensitiveword(swSensitivewordDomain, oldSwSensitiveword);
        this.setSensitivewordUpdataDefault(swSensitiveword);
        this.updateSensitivewordModel(swSensitiveword);
    }

    @Override
    public SwSensitiveword getSensitiveword(Integer swId) {
        return this.getSensitivewordModelById(swId);
    }

    @Override
    public void deleteSensitiveword(Integer swId) throws ApiException {
        this.deleteSensitivewordModel(swId);
    }

    @Override
    public QueryResult<SwSensitiveword> querySensitivewordPage(Map<String, Object> map) {
        List<SwSensitiveword> swSensitivewordList = this.querySensitivewordModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSensitiveword(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(swSensitivewordList);
        return queryResult;
    }

    @Override
    public SwSensitiveword getSensitivewordByCode(String tenantCode, String swCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("swCode", swCode);
        return this.getSensitivewordModelByCode(map);
    }

    @Override
    public void deleteSensitivewordByCode(String tenantCode, String swCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("swCode", swCode);
        this.delSensitivewordModelByCode(map);
    }

    @Override
    public Map<String, String> checkSensitiveword(Map<String, Object> map, String checkWords, String replaceWords) throws ApiException {
        List<SwSensitiveword> swSensitivewordList = this.querySensitivewordModelPage(map);
        List<String> swList = SensitiveWordUtil.checkSensitiveWord(swSensitivewordList, checkWords);
        HashMap<String, String> result = new HashMap<String, String>();
        String swStr = "";
        if (null != swList && swList.size() > 0) {
            for (String str : swList) {
                checkWords = checkWords.replace(str, replaceWords);
                swStr = swStr + "," + str;
            }
        }
        result.put("checkwords", checkWords);
        if (swStr.length() > 0) {
            swStr = swStr.substring(1);
        }
        result.put("sw", swStr);
        return result;
    }
}

