/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sw.util;

import com.yqbsoft.laser.service.sw.model.SwSensitiveword;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveWordUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SensitiveWordUtil.class);
    private static HashMap sensitiveWordMap = null;
    private static final String ENCODING = "utf-8";

    private static void init(List<SwSensitiveword> swSensitivewordList) {
        sensitiveWordMap = new HashMap(swSensitivewordList.size());
        for (SwSensitiveword swSensitiveword : swSensitivewordList) {
            SensitiveWordUtil.createKeyWord(swSensitiveword.getSwWords());
        }
    }

    private static void createKeyWord(String keyWord) {
        if (sensitiveWordMap == null) {
            LOG.error("sensitiveWordMap \u672a\u521d\u59cb\u5316!");
            return;
        }
        Map<Character, HashMap<String, String>> nowMap = sensitiveWordMap;
        char[] arr$ = keyWord.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            Object obj = nowMap.get(c);
            if (obj == null) {
                HashMap<String, String> childMap = new HashMap<String, String>();
                childMap.put("isEnd", "false");
                nowMap.put(c, childMap);
                nowMap = childMap;
                continue;
            }
            nowMap = (Map)obj;
        }
        nowMap.put((Character)((Object)"isEnd"), (HashMap<String, String>)((Object)"true"));
    }

    public static List<String> checkSensitiveWord(List<SwSensitiveword> swSensitivewordList, String text) {
        if (sensitiveWordMap == null) {
            SensitiveWordUtil.init(swSensitivewordList);
        }
        ArrayList<String> sensitiveWords = new ArrayList<String>();
        HashMap nowMap = sensitiveWordMap;
        for (int i = 0; i < text.length(); ++i) {
            Character word = Character.valueOf(text.charAt(i));
            Object obj = nowMap.get(word);
            if (obj == null) continue;
            Map childMap = (Map)obj;
            for (int j = i + 1; j < text.length() && (obj = childMap.get(Character.valueOf(text.charAt(j)))) != null; ++j) {
                childMap = (Map)obj;
                if (!"true".equals(childMap.get("isEnd"))) continue;
                sensitiveWords.add(text.substring(i, j + 1));
            }
        }
        return sensitiveWords;
    }
}

