/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.task.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.task.dao.TkTaskMapper;
import com.yqbsoft.laser.service.task.dao.TkTaskMmMapper;
import com.yqbsoft.laser.service.task.domain.TkTaskDomain;
import com.yqbsoft.laser.service.task.domain.TkTaskMmDomain;
import com.yqbsoft.laser.service.task.model.TkTask;
import com.yqbsoft.laser.service.task.model.TkTaskMm;
import com.yqbsoft.laser.service.task.service.TkTaskService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TkTaskServiceImpl
extends BaseServiceImpl
implements TkTaskService {
    public static final String SYS_CODE = "tk.TASK.TkTaskServiceImpl";
    private TkTaskMapper tkTaskMapper;
    private TkTaskMmMapper tkTaskMmMapper;

    public void setTkTaskMapper(TkTaskMapper tkTaskMapper) {
        this.tkTaskMapper = tkTaskMapper;
    }

    public void setTkTaskMmMapper(TkTaskMmMapper tkTaskMmMapper) {
        this.tkTaskMmMapper = tkTaskMmMapper;
    }

    private Date getSysDate() {
        try {
            return this.tkTaskMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTask(TkTaskDomain tkTaskDomain) {
        if (null == tkTaskDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setTaskDefault(TkTask tkTask) {
        if (null == tkTask) {
            return;
        }
        if (null == tkTask.getDataState()) {
            tkTask.setDataState(0);
        }
        if (null == tkTask.getGmtCreate()) {
            tkTask.setGmtCreate(this.getSysDate());
        }
        tkTask.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tkTask.getTaskCode())) {
            tkTask.setTaskCode(this.createUUIDString());
        }
    }

    private int getTaskMaxCode() {
        int code = 0;
        try {
            return this.tkTaskMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.getTaskMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTaskUpdataDefault(TkTask tkTask) {
        if (null == tkTask) {
            return;
        }
        tkTask.setGmtModified(this.getSysDate());
    }

    private void saveTaskModel(TkTask tkTask) throws ApiException {
        if (null == tkTask) {
            return;
        }
        try {
            this.tkTaskMapper.insert(tkTask);
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.saveTaskModel.ex", (Throwable)e);
        }
    }

    private TkTask getTaskModelById(Integer taskId) {
        if (null == taskId) {
            return null;
        }
        try {
            return this.tkTaskMapper.selectByPrimaryKey(taskId);
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.getTaskModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteTaskModel(Integer taskId) throws ApiException {
        if (null == taskId) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTaskMapper.deleteByPrimaryKey(taskId);
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.deleteTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.deleteTaskModel.num");
        }
    }

    private void updateTaskModel(TkTask tkTask) throws ApiException {
        if (null == tkTask) {
            return;
        }
        try {
            this.tkTaskMapper.updateByPrimaryKeySelective(tkTask);
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.updateTaskModel.ex", (Throwable)e);
        }
    }

    private void updateStateTaskModel(Integer taskId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == taskId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", taskId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tkTaskMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.updateStateTaskModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.updateStateTaskModel.null");
        }
    }

    private TkTask makeTask(TkTaskDomain tkTaskDomain, TkTask tkTask) {
        if (null == tkTaskDomain) {
            return null;
        }
        if (null == tkTask) {
            tkTask = new TkTask();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tkTask, (Object)tkTaskDomain);
            return tkTask;
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.makeTask", (Throwable)e);
            return null;
        }
    }

    private List<TkTask> queryTaskByUserCodeModel(Map<String, Object> parammap) {
        try {
            return this.tkTaskMapper.queryTaskByUserCode(parammap);
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.queryTaskByUserCodeModel", (Throwable)e);
            return null;
        }
    }

    private List<TkTask> queryTaskModelPage(Map<String, Object> parammap) {
        try {
            List<TkTask> tasks = this.tkTaskMapper.query(parammap);
            return tasks;
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.queryTaskModel", (Throwable)e);
            return null;
        }
    }

    private int countTask(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tkTaskMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.countTask", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveTask(TkTaskDomain tkTaskDomain) throws ApiException {
        String msg = this.checkTask(tkTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.saveTask.checkTask", msg);
        }
        TkTask tkTask = this.makeTask(tkTaskDomain, null);
        this.setTaskDefault(tkTask);
        this.saveTaskModel(tkTask);
        this.autoFlushStatusForUpdate();
    }

    @Override
    public void updateTaskState(Integer taskId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTaskModel(taskId, dataState, oldDataState);
    }

    @Override
    public void updateTask(TkTaskDomain tkTaskDomain) throws ApiException {
        String msg = this.checkTask(tkTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.updateTask.checkTask", msg);
        }
        TkTask oldTkTask = this.getTaskModelById(tkTaskDomain.getTaskId());
        if (null == oldTkTask) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.updateTask.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TkTask tkTask = this.makeTask(tkTaskDomain, oldTkTask);
        this.setTaskUpdataDefault(tkTask);
        this.updateTaskModel(tkTask);
    }

    @Override
    public TkTask getTask(Integer taskId) {
        return this.getTaskModelById(taskId);
    }

    @Override
    public void deleteTask(Integer taskId) throws ApiException {
        this.deleteTaskModel(taskId);
    }

    @Override
    public QueryResult<TkTask> queryTaskPage(Map<String, Object> map) {
        List<TkTask> tkTaskList = this.queryTaskModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTask(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tkTaskList);
        return queryResult;
    }

    @Override
    public TkTask getTaskByCode(Map<String, Object> map) {
        return this.getTaskModelByCode(map);
    }

    public TkTask getTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tkTaskMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.getTaskModelByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void delTaskByCode(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        if (map.get("tkMmMark") != null && !"".equals(map.get("tkMmMark")) && "taskMm".equals(map.get("tkMmMark"))) {
            this.deleteTaskAndMmModel(map);
        } else {
            this.delTaskModelByCode(map);
        }
    }

    public void delTaskModelByCode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tkTaskMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.delTaskModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.delTaskModelByCode.num");
        }
    }

    private void deleteTaskAndMmModel(Map<String, Object> map) throws ApiException {
        try {
            TkTask tkTask = this.tkTaskMapper.getByCode(map);
            if (tkTask != null && tkTask.getDataState() == 0) {
                int taskRetNum = this.tkTaskMapper.delByCode(map);
                if (1 != taskRetNum) {
                    throw new ApiException("tk.TASK.TkTaskServiceImpl.deleteTaskAndMmModel.num.task");
                }
            } else {
                throw new ApiException("tk.TASK.TkTaskServiceImpl.deleteTaskAndMmModel.task", "\u672a\u627e\u5230\u8be5\u4efb\u52a1\u4fe1\u606f\uff0c\u6216\u8be5\u4efb\u52a1\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f");
            }
            this.tkTaskMmMapper.deleteByTaskCode(tkTask.getTaskCode());
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.deleteTaskAndMmModel.ex", (Throwable)e);
        }
    }

    @Override
    public void saveTaskAndMm(TkTaskDomain tkTaskDomain) throws ApiException {
        String msg = this.checkTask(tkTaskDomain, "insert");
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.saveTaskAndMm.checkTask", msg);
        }
        TkTask tkTask = this.makeTask(tkTaskDomain, null);
        this.setTaskDefault(tkTask);
        this.saveTaskAndMmModel(tkTask);
        this.autoFlushStatusForUpdate();
    }

    private void saveTaskAndMmModel(TkTask tkTask) throws ApiException {
        if (null == tkTask) {
            return;
        }
        try {
            this.tkTaskMapper.insert(tkTask);
            List<TkTaskMm> taskMmLists = tkTask.getTaskMmLists();
            for (int i = 0; i < taskMmLists.size(); ++i) {
                TkTaskMm tkTaskMm = this.makeTaskMm(taskMmLists.get(i), null);
                tkTaskMm.setDataState(0);
                tkTaskMm.setGmtCreate(tkTask.getGmtCreate());
                tkTaskMm.setGmtModified(tkTask.getGmtModified());
                tkTaskMm.setTmmCode(this.createUUIDString());
                tkTaskMm.setTaskCode(tkTask.getTaskCode());
                tkTaskMm.setTenantCode(tkTask.getTenantCode());
                tkTaskMm.setTokerNum("0");
                this.tkTaskMmMapper.insert(tkTaskMm);
            }
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.saveTaskAndMmModel.ex", (Throwable)e);
        }
    }

    private String checkTask(TkTaskDomain tkTaskDomain, String type) {
        if (null == tkTaskDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        StringBuffer msg = new StringBuffer();
        if ("update".equals(type)) {
            if (tkTaskDomain.getTaskCode() == null || "".equals(tkTaskDomain.getTaskCode())) {
                msg.append("\u4efb\u52a1Code\u4e3a\u7a7a;");
            }
        } else if ("insert".equals(type)) {
            List<TkTaskMmDomain> taskMmLists;
            if (StringUtils.isBlank((String)tkTaskDomain.getTaskTitle())) {
                msg.append("\u4efb\u52a1\u540d\u4e3a\u7a7a;");
            }
            if (StringUtils.isBlank((String)tkTaskDomain.getTaskSdate().toString())) {
                msg.append("\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a;");
            }
            if (StringUtils.isBlank((String)tkTaskDomain.getTaskEdate().toString())) {
                msg.append("\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a;");
            }
            if (StringUtils.isBlank((String)tkTaskDomain.getTaskAddr())) {
                msg.append("\u4efb\u52a1\u5730\u70b9\u4e3a\u7a7a;");
            }
            if ((taskMmLists = tkTaskDomain.getTaskMmLists()) == null || taskMmLists.size() == 0) {
                msg.append("\u4efb\u52a1\u6210\u5458\u4e3a\u7a7a;");
            }
        }
        return msg.toString();
    }

    private TkTaskMm makeTaskMm(Object obj, TkTaskMm tkTaskMm) {
        if (null == tkTaskMm) {
            tkTaskMm = new TkTaskMm();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tkTaskMm, (Object)obj);
            return tkTaskMm;
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.makeTaskMm", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateTaskAndMm(TkTaskDomain tkTaskDomain) throws ApiException {
        String msg = this.checkTask(tkTaskDomain, "update");
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.updateTask.checkTask", msg);
        }
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        taskMap.put("taskCode", tkTaskDomain.getTaskCode());
        taskMap.put("tenantCode", tkTaskDomain.getTenantCode());
        TkTask oldTkTask = this.getTaskByCode(taskMap);
        if (null == oldTkTask) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.updateTask.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        tkTaskDomain.setTaskId(oldTkTask.getTaskId());
        tkTaskDomain.setTaskCode(oldTkTask.getTaskCode());
        TkTask tkTask = this.makeTask(tkTaskDomain, oldTkTask);
        this.setTaskUpdataDefault(tkTask);
        this.updateTaskAndMmModel(tkTask);
    }

    private void updateTaskAndMmModel(TkTask tkTask) throws ApiException {
        if (null == tkTask) {
            return;
        }
        try {
            this.tkTaskMapper.updateByPrimaryKeySelective(tkTask);
            List<TkTaskMm> taskMmLists = tkTask.getTaskMmLists();
            for (int i = 0; i < taskMmLists.size(); ++i) {
                TkTaskMm tkTaskMm = this.makeTaskMm(taskMmLists.get(i), null);
                TkTaskMm existsObj = this.tkTaskMmMapper.getByTaskAndUserCode(tkTask.getTaskCode(), tkTaskMm.getUserCode(), tkTask.getTenantCode());
                if (existsObj != null) continue;
                tkTaskMm.setDataState(0);
                tkTaskMm.setGmtCreate(this.getSysDate());
                tkTaskMm.setGmtModified(tkTask.getGmtModified());
                tkTaskMm.setTmmCode(this.createUUIDString());
                tkTaskMm.setTaskCode(tkTask.getTaskCode());
                tkTaskMm.setTenantCode(tkTask.getTenantCode());
                tkTaskMm.setTokerNum("0");
                this.tkTaskMmMapper.insert(tkTaskMm);
            }
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.updateTaskAndMmModel.ex", (Throwable)e);
        }
    }

    @Override
    public QueryResult<TkTask> queryTaskAndMmPage(Map<String, Object> map) {
        List<TkTask> tkTaskList = this.queryTaskModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTask(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tkTaskList);
        return queryResult;
    }

    @Override
    public QueryResult<TkTask> specialiTaskAndMmPage(Map<String, Object> map) {
        List<TkTask> tkTaskList = this.specialiTaskAndMmModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.specialiTaskAndMmCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tkTaskList);
        return queryResult;
    }

    private List<TkTask> specialiTaskAndMmModel(Map<String, Object> parammap) {
        try {
            List<TkTask> tasks = this.tkTaskMapper.specialiTaskAndMm(parammap);
            return tasks;
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.specialiTaskAndMmModel", (Throwable)e);
            return null;
        }
    }

    private int specialiTaskAndMmCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tkTaskMapper.specialiTaskAndMmCount(map);
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.specialiTaskAndMmCountTask", (Throwable)e);
        }
        return i;
    }

    @Override
    public List<TkTask> queryTaskAndMm(Map<String, Object> map) {
        List<TkTask> tkTaskList = this.queryTaskByUserCodeModel(map);
        return tkTaskList;
    }

    @Override
    public void deleteTaskAndMm(Integer taskId) throws ApiException {
    }

    @Override
    public TkTask getTaskAndMm(Integer taskId) {
        if (taskId == null) {
            return null;
        }
        List<Map<String, Object>> tkTaskMaps = this.getTaskAndMmModel(taskId);
        TkTask retTkTask = new TkTask();
        ArrayList<TkTaskMm> taskMmLists = new ArrayList<TkTaskMm>();
        boolean flag = true;
        for (Map<String, Object> tkTaskMap : tkTaskMaps) {
            if (flag) {
                try {
                    BeanUtils.copyAllPropertys((Object)retTkTask, tkTaskMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                flag = false;
            }
            TkTaskMm retTkTaskMm = new TkTaskMm();
            retTkTaskMm.setUserName((String)tkTaskMap.get("userName1"));
            retTkTaskMm.setUserCode((String)tkTaskMap.get("userCode1"));
            retTkTaskMm.setTokerNum((String)tkTaskMap.get("tokerNum1"));
            retTkTaskMm.setTmmId((Integer)tkTaskMap.get("tmmId"));
            retTkTaskMm.setTmmCode((String)tkTaskMap.get("tmmCode"));
            retTkTaskMm.setTenantCode(retTkTask.getTenantCode());
            retTkTaskMm.setTaskCode(retTkTask.getTaskCode());
            retTkTaskMm.setDataState((Integer)tkTaskMap.get("dataState1"));
            taskMmLists.add(retTkTaskMm);
        }
        retTkTask.setTaskMmLists(taskMmLists);
        return retTkTask;
    }

    private List<Map<String, Object>> getTaskAndMmModel(Integer taskId) {
        try {
            return this.tkTaskMapper.getTaskAndMmEditor(taskId);
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.getTaskAndMmModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> queryTaskStateCount(Map<String, Object> map) {
        List<Map<String, Object>> list = this.tkTaskMmMapper.queryStateCount(map);
        return list;
    }

    @Override
    public Map<String, String> getTasksAddrByCodes(List<String> taskCodes) {
        return this.getTasksModelByCodes(taskCodes);
    }

    public Map<String, String> getTasksModelByCodes(List<String> taskCodes) {
        try {
            if (taskCodes == null || taskCodes.size() == 0) {
                throw new ApiException("tk.TASK.TkTaskServiceImpl.getTasksModelByCodes.ex", "codes\u4e3a\u7a7a");
            }
            List<Map<String, String>> tasks = this.tkTaskMapper.getAddrByCodes(taskCodes);
            HashMap<String, String> tempTask = new HashMap<String, String>();
            if (tasks == null || tasks.size() <= 0) {
                return tempTask;
            }
            String codeKey = "taskCode";
            String addrKey = "taskAddr";
            for (Map<String, String> task : tasks) {
                if (task.get("taskCode") == null) continue;
                tempTask.put(task.get("taskCode"), task.get("taskAddr"));
            }
            return tempTask;
        }
        catch (Exception e) {
            this.logger.error("tk.TASK.TkTaskServiceImpl.getTasksModelByCodes", (Throwable)e);
            return null;
        }
    }

    @Override
    public void autoFlushStatusForUpdate() throws ApiException {
        this.info("tk.TASK.TkTaskServiceImpl.autoFlushStatusForUpdate", "=====taskautoflush==start====" + ServletMain.getAppName());
        this.autoForUpdateModel();
        this.info("tk.TASK.TkTaskServiceImpl.autoFlushStatusForUpdate", "=====taskautoflush==end====" + ServletMain.getAppName());
    }

    public void autoForUpdateModel() throws ApiException {
        try {
            this.tkTaskMapper.autoForUpdateToIng();
            this.tkTaskMapper.autoForUpdateToEnd();
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.autoForUpdateModel.ex", (Throwable)e);
        }
    }

    @Override
    public void updateReportByTaskNum(String taskCode) throws ApiException {
        this.updateReportByTaskNumModel(taskCode);
    }

    public void updateReportByTaskNumModel(String taskCode) throws ApiException {
        try {
            this.tkTaskMapper.updateReportByTaskNum(taskCode);
        }
        catch (Exception e) {
            throw new ApiException("tk.TASK.TkTaskServiceImpl.addReportByTaskNumModel.ex", (Throwable)e);
        }
    }
}

