/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTenantMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTenantSecondaryMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTenantDomain;
import com.yqbsoft.laser.service.tenantmanag.model.TmTenant;
import com.yqbsoft.laser.service.tenantmanag.model.VdFaccountInnerCtrlDomain;
import com.yqbsoft.laser.service.tenantmanag.service.TmTenantService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class TmTenantServiceImpl
extends BaseServiceImpl
implements TmTenantService {
    public static final String SYS_CODE = "tm.TmTenantServiceImpl";
    private TmTenantMapper tmTenantMapper;
    private TmTenantSecondaryMapper tmTenantSecondaryMapper;

    public void setTmTenantMapper(TmTenantMapper tmTenantMapper) {
        this.tmTenantMapper = tmTenantMapper;
    }

    public void setTmTenantSecondaryMapper(TmTenantSecondaryMapper tmTenantSecondaryMapper) {
        this.tmTenantSecondaryMapper = tmTenantSecondaryMapper;
    }

    private Date getSysDate() {
        try {
            return this.tmTenantMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTenant(TmTenantDomain tmTenantDomain) {
        if (null == tmTenantDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setTenantDefault(TmTenant tmTenant) {
        if (null == tmTenant) {
            return;
        }
        if (null == tmTenant.getDataState()) {
            tmTenant.setDataState(0);
        }
        if (null == tmTenant.getGmtCreate()) {
            tmTenant.setGmtCreate(this.getSysDate());
        }
        tmTenant.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmTenant.getTenantCode())) {
            tmTenant.setTenantCode(this.getNo(null, "TmTenant", "tenantCode", "00000000"));
        }
    }

    public int getTenantMaxCode() {
        int code = 0;
        try {
            return this.tmTenantMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.getTenantMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTenantUpdataDefault(TmTenant tmTenant) {
        if (null == tmTenant) {
            return;
        }
        tmTenant.setGmtModified(this.getSysDate());
    }

    private void saveTenantModel(TmTenant tmTenant) throws ApiException {
        if (null == tmTenant) {
            return;
        }
        try {
            this.tmTenantMapper.insert(tmTenant);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.saveTenantModel.ex", (Throwable)e);
        }
    }

    private TmTenant getTenantModelById(Integer tenantId) {
        if (null == tenantId) {
            return null;
        }
        try {
            return this.tmTenantMapper.selectByPrimaryKey(tenantId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.getTenantModelById", (Throwable)e);
            return null;
        }
    }

    public TmTenant getTenantModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmTenantMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.getTenantModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delTenantModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTenantMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.delTenantModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTenantServiceImpl.delTenantModelByCode.num");
        }
    }

    private void deleteTenantModel(Integer tenantId) throws ApiException {
        if (null == tenantId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTenantMapper.deleteByPrimaryKey(tenantId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.deleteTenantModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTenantServiceImpl.deleteTenantModel.num");
        }
    }

    private void updateTenantModel(TmTenant tmTenant) throws ApiException {
        if (null == tmTenant) {
            return;
        }
        try {
            this.tmTenantMapper.updateByPrimaryKeySelective(tmTenant);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.updateTenantModel.ex", (Throwable)e);
        }
    }

    private void updateStateTenantModel(Integer tenantId, Integer dataState, Integer oldDataState) throws ApiException {
        int i;
        if (null == tenantId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", tenantId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            i = this.tmTenantMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.updateStateTenantModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTenantServiceImpl.updateStateTenantModel.null");
        }
        TmTenant tmTenant = this.getTenant(tenantId);
        DisUtil.setMap((String)"tmtenant-code", (String)tmTenant.getTenantCode(), (String)JsonUtil.buildNormalBinder().toJson((Object)tmTenant));
    }

    private TmTenant makeTenant(TmTenantDomain tmTenantDomain, TmTenant tmTenant) {
        if (null == tmTenantDomain) {
            return null;
        }
        if (null == tmTenant) {
            tmTenant = new TmTenant();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmTenant, (Object)tmTenantDomain);
            return tmTenant;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.makeTenant", (Throwable)e);
            return null;
        }
    }

    private List<TmTenant> queryTenantModelPage(Map<String, Object> parammap) {
        try {
            return this.tmTenantMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.queryTenantModel", (Throwable)e);
            return null;
        }
    }

    private int countTenant(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmTenantMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.countTenant", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveTenant(TmTenantDomain tmTenantDomain) throws ApiException {
        String msg = this.checkTenant(tmTenantDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTenantServiceImpl.saveTenant.checkTenant", msg);
        }
        TmTenant tmTenant = this.makeTenant(tmTenantDomain, null);
        this.setTenantDefault(tmTenant);
        tmTenant.setMemo(tmTenantDomain.getProappCode());
        this.saveTenantModel(tmTenant);
        DisUtil.setMap((String)"tmtenant-code", (String)tmTenant.getTenantCode(), (String)JsonUtil.buildNormalBinder().toJson((Object)tmTenant));
        HashMap<String, String> map = new HashMap<String, String>();
        VdFaccountInnerCtrlDomain vdFaccountInnerCtrlDomain = new VdFaccountInnerCtrlDomain();
        vdFaccountInnerCtrlDomain.setTenantCode(tmTenant.getTenantCode());
        vdFaccountInnerCtrlDomain.setFaccountDefBatchcode("0901");
        map.put("vdFaccountOuterCtrlDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountInnerCtrlDomain));
        this.internalInvoke("vd.faccount.saveOpenFaccoun", map);
        map.clear();
        map.put("tenantCode", tmTenant.getTenantCode());
        map.put("fchannelCode", "01");
        this.internalInvoke("pte.ptfchannel.savePtfchannelInit", map);
        map.put("tenantCode", tmTenant.getTenantCode());
        map.put("fchannelCode", "02");
        this.internalInvoke("pte.ptfchannel.savePtfchannelInit", map);
        return tmTenant.getTenantCode();
    }

    @Override
    public void updateTenantState(Integer tenantId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTenantModel(tenantId, dataState, oldDataState);
        this.queryTenantCache();
        TmTenant tmTenant = this.getTenant(tenantId);
        try {
            this.tmTenantSecondaryMapper.updateStateBySecondaryTenantCode(tmTenant.getTenantCode(), dataState, oldDataState);
        }
        catch (Exception e) {
            this.logger.error("updateTenantState.updateStateBySecondaryTenantCode.ERROR", (Throwable)e);
            throw new ApiException("UPDATE.SECONDARY.ERROR", "update sencondary tenant fail", (Throwable)e);
        }
    }

    @Override
    public void upadteTenantStateByOpUser(String tenantOpUser, Integer dataSate, Integer oldDataState) throws ApiException {
        assert (StringUtils.isNotBlank((String)tenantOpUser));
        TmTenant tmTenantSearch = new TmTenant();
        tmTenantSearch.setTenantOpuser(tenantOpUser);
        TmTenant result = this.getTenantByUnique(tmTenantSearch);
        this.updateTenantState(result.getTenantId(), dataSate, oldDataState);
    }

    @Override
    public void updateTenant(TmTenantDomain tmTenantDomain) throws ApiException {
        String msg = this.checkTenant(tmTenantDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTenantServiceImpl.updateTenant.checkTenant", msg);
        }
        TmTenant oldTmTenant = this.getTenantModelById(tmTenantDomain.getTenantId());
        if (null == oldTmTenant) {
            throw new ApiException("tm.TmTenantServiceImpl.updateTenant.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmTenant tmTenant = this.makeTenant(tmTenantDomain, oldTmTenant);
        this.setTenantUpdataDefault(tmTenant);
        this.updateTenantModel(tmTenant);
    }

    @Override
    public TmTenant getTenant(Integer tenantId) {
        return this.getTenantModelById(tenantId);
    }

    @Override
    public void deleteTenant(Integer tenantId) throws ApiException {
        this.deleteTenantModel(tenantId);
    }

    @Override
    public QueryResult<TmTenant> queryTenantPage(Map<String, Object> map) {
        List<TmTenant> tmTenantList = this.queryTenantModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTenant(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmTenantList);
        return queryResult;
    }

    @Override
    public TmTenant getTenantByCode(Map<String, Object> map) {
        return this.getTenantModelByCode(map);
    }

    @Override
    public void delTenantByCode(Map<String, Object> map) throws ApiException {
        this.delTenantModelByCode(map);
    }

    @Override
    public void queryTenantCache() {
        this.info("tm.TmTenantServiceImpl.queryTenantCache.start", "=======Tenant\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1L);
        List<TmTenant> tenantList = this.queryTenantModelPage(params);
        if (CollectionUtils.isEmpty(tenantList)) {
            DisUtil.delVer((String)"tmtenant-code");
            DisUtil.delVer((String)"tmtenant-user-code");
            this.info("tm.TmTenantServiceImpl.queryTenantCache.null", "=======Tenant\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        HashMap<String, String> usermap = new HashMap<String, String>();
        for (TmTenant tmTenant : tenantList) {
            if (StringUtils.isNotBlank((String)tmTenant.getTenantOpuser())) {
                usermap.put(tmTenant.getTenantCode(), tmTenant.getTenantOpuser());
            }
            if (StringUtils.isNotBlank((String)tmTenant.getTenantMdomain())) {
                mmap.put(tmTenant.getTenantMdomain(), tmTenant.getTenantCode());
            }
            if (StringUtils.isNotBlank((String)tmTenant.getTenantMdomain1())) {
                mmap.put(tmTenant.getTenantMdomain1(), tmTenant.getTenantCode());
            }
            if (StringUtils.isNotBlank((String)tmTenant.getTenantMdomain2())) {
                mmap.put(tmTenant.getTenantMdomain2(), tmTenant.getTenantCode());
            }
            DisUtil.setMap((String)"tmtenant-code", (String)tmTenant.getTenantCode(), (String)JsonUtil.buildNormalBinder().toJson((Object)tmTenant));
        }
        mmap.put("list", JsonUtil.buildNormalBinder().toJson(tenantList));
        DisUtil.setMap((String)"tmtenant-code", mmap);
        DisUtil.setMap((String)"tmtenant-user-code", usermap);
        this.info("tm.TmTenantServiceImpl.queryTenantCache.end", "=======Tenant\u8c03\u5ea6end=======");
    }

    @Override
    public TmTenant getTenantByUnique(TmTenant tmTenantSearch) {
        if (tmTenantSearch == null) {
            throw new ApiException("QUERY.PARAMS.NULL", "params can`t be null");
        }
        return this.tmTenantMapper.getTenantByUnique(tmTenantSearch);
    }
}

