/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.flow.SoaUtil;
import com.yqbsoft.laser.service.esb.core.flow.UddiUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTmsceneApiMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTmsceneMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTmsceneProappMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.FlowStartCon;
import com.yqbsoft.laser.service.tenantmanag.domain.OcReorderDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappEnvBean;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappMenuBean;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappMenupriBean;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneApiDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneApiReDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneProappDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneProappReDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneReDomain;
import com.yqbsoft.laser.service.tenantmanag.es.EsEnginePollThread;
import com.yqbsoft.laser.service.tenantmanag.es.EsEnginePutThread;
import com.yqbsoft.laser.service.tenantmanag.es.EsEngineService;
import com.yqbsoft.laser.service.tenantmanag.model.TmProapp;
import com.yqbsoft.laser.service.tenantmanag.model.TmProappEnv;
import com.yqbsoft.laser.service.tenantmanag.model.TmScene;
import com.yqbsoft.laser.service.tenantmanag.model.TmSceneApi;
import com.yqbsoft.laser.service.tenantmanag.model.TmSceneMenu;
import com.yqbsoft.laser.service.tenantmanag.model.TmSceneMenupri;
import com.yqbsoft.laser.service.tenantmanag.model.TmSceneProapp;
import com.yqbsoft.laser.service.tenantmanag.model.TmTenant;
import com.yqbsoft.laser.service.tenantmanag.model.TmTmscene;
import com.yqbsoft.laser.service.tenantmanag.model.TmTmsceneApi;
import com.yqbsoft.laser.service.tenantmanag.model.TmTmsceneProapp;
import com.yqbsoft.laser.service.tenantmanag.service.TmProappService;
import com.yqbsoft.laser.service.tenantmanag.service.TmSceneMenupriService;
import com.yqbsoft.laser.service.tenantmanag.service.TmSceneService;
import com.yqbsoft.laser.service.tenantmanag.service.TmTmsceneService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TmTmsceneServiceImpl
extends BaseServiceImpl
implements TmTmsceneService {
    private static final String SYS_CODE = "tm.TmTmsceneServiceImpl";
    private TmTmsceneMapper tmTmsceneMapper;
    private TmTmsceneProappMapper tmTmsceneProappMapper;
    private TmTmsceneApiMapper tmTmsceneApiMapper;
    private TmSceneService tmSceneService;
    private TmSceneMenupriService tmSceneMenupriService;
    private TmProappService tmProappService;
    private static EsEngineService esEngineService;
    private static Object lock;

    public void setTmSceneService(TmSceneService tmSceneService) {
        this.tmSceneService = tmSceneService;
    }

    public void setTmProappService(TmProappService tmProappService) {
        this.tmProappService = tmProappService;
    }

    public void setTmTmsceneMapper(TmTmsceneMapper tmTmsceneMapper) {
        this.tmTmsceneMapper = tmTmsceneMapper;
    }

    public void setTmTmsceneProappMapper(TmTmsceneProappMapper tmTmsceneProappMapper) {
        this.tmTmsceneProappMapper = tmTmsceneProappMapper;
    }

    public void setTmTmsceneApiMapper(TmTmsceneApiMapper tmTmsceneApiMapper) {
        this.tmTmsceneApiMapper = tmTmsceneApiMapper;
    }

    private Date getSysDate() {
        try {
            return this.tmTmsceneMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTmscene(TmTmsceneDomain tmTmsceneDomain) {
        if (null == tmTmsceneDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmTmsceneDomain.getSceneCode())) {
            msg = msg + "SceneCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmTmsceneDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTmsceneDefault(TmTmscene tmTmscene) {
        if (null == tmTmscene) {
            return;
        }
        if (null == tmTmscene.getDataState()) {
            tmTmscene.setDataState(0);
        }
        if (null == tmTmscene.getGmtCreate()) {
            tmTmscene.setGmtCreate(this.getSysDate());
        }
        tmTmscene.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmTmscene.getTmsceneCode())) {
            tmTmscene.setTmsceneCode(this.getNo(null, "TmTmscene", "tmTmscene", tmTmscene.getTenantCode()));
        }
    }

    private int getTmsceneMaxCode() {
        int code = 0;
        try {
            return this.tmTmsceneMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTmsceneUpdataDefault(TmTmscene tmTmscene) {
        if (null == tmTmscene) {
            return;
        }
        tmTmscene.setGmtModified(this.getSysDate());
    }

    private void saveTmsceneModel(TmTmscene tmTmscene) throws ApiException {
        if (null == tmTmscene) {
            return;
        }
        try {
            this.tmTmsceneMapper.insert(tmTmscene);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneModel.ex", (Throwable)e);
        }
    }

    private void saveTmsceneBatchModel(List<TmTmscene> tmTmsceneList) throws ApiException {
        if (null == tmTmsceneList || tmTmsceneList.isEmpty()) {
            return;
        }
        try {
            this.tmTmsceneMapper.insertBatch(tmTmsceneList);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneBatchModel.ex", (Throwable)e);
        }
    }

    private TmTmscene getTmsceneModelById(Integer tmsceneId) {
        if (null == tmsceneId) {
            return null;
        }
        try {
            return this.tmTmsceneMapper.selectByPrimaryKey(tmsceneId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneModelById", (Throwable)e);
            return null;
        }
    }

    private TmTmscene getTmsceneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmTmsceneMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTmsceneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneModelByCode.num");
        }
    }

    private void deleteTmsceneModel(Integer tmsceneId) throws ApiException {
        if (null == tmsceneId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneMapper.deleteByPrimaryKey(tmsceneId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneModel.num");
        }
    }

    private void updateTmsceneModel(TmTmscene tmTmscene) throws ApiException {
        if (null == tmTmscene) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneMapper.updateByPrimaryKey(tmTmscene);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneModel.num");
        }
    }

    private void updateStateTmsceneModel(Integer tmsceneId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == tmsceneId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tmsceneId", tmsceneId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmTmsceneMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneModel.null");
        }
    }

    private void updateStateTmsceneModelByCode(String tenantCode, String tmsceneCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)tmsceneCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneCode", tmsceneCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmTmsceneMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneModelByCode.null");
        }
    }

    private TmTmscene makeTmscene(TmTmsceneDomain tmTmsceneDomain, TmTmscene tmTmscene) {
        TmScene tmScene;
        if (null == tmTmsceneDomain) {
            return null;
        }
        if (null == tmTmscene) {
            tmTmscene = new TmTmscene();
        }
        if (null == (tmScene = this.tmSceneService.getSceneByCode(tmTmsceneDomain.getTenantCode(), tmTmsceneDomain.getSceneCode()))) {
            throw new ApiException("tm.TmTmsceneServiceImpl.setTmsceneDefault.tmScene", tmTmsceneDomain.getTenantCode() + "-" + tmTmsceneDomain.getSceneCode());
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmTmscene, (Object)tmTmsceneDomain);
            BeanUtils.copyAllPropertys((Object)tmTmscene, (Object)tmScene);
            return tmTmscene;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmscene", (Throwable)e);
            return null;
        }
    }

    private TmTmsceneReDomain makeTmTmsceneReDomain(TmTmscene tmTmscene) {
        if (null == tmTmscene) {
            return null;
        }
        TmTmsceneReDomain tmTmsceneReDomain = new TmTmsceneReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmTmsceneReDomain, (Object)tmTmscene);
            return tmTmsceneReDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmTmsceneReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmTmscene> queryTmsceneModelPage(Map<String, Object> parammap) {
        try {
            return this.tmTmsceneMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.queryTmsceneModel", (Throwable)e);
            return null;
        }
    }

    private int countTmscene(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmTmsceneMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.countTmscene", (Throwable)e);
        }
        return i;
    }

    private TmTmscene createTmTmscene(TmTmsceneDomain tmTmsceneDomain) {
        String msg = this.checkTmscene(tmTmsceneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmscene.checkTmscene", msg);
        }
        TmTmscene tmTmscene = this.makeTmscene(tmTmsceneDomain, null);
        this.setTmsceneDefault(tmTmscene);
        return tmTmscene;
    }

    private String checkTmsceneProapp(TmTmsceneProappDomain tmTmsceneProappDomain) {
        if (null == tmTmsceneProappDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmTmsceneProappDomain.getProappCode())) {
            msg = msg + "ProappCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmTmsceneProappDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTmsceneProappDefault(TmTmsceneProapp tmTmsceneProapp) {
        if (null == tmTmsceneProapp) {
            return;
        }
        if (null == tmTmsceneProapp.getDataState()) {
            tmTmsceneProapp.setDataState(0);
        }
        if (null == tmTmsceneProapp.getGmtCreate()) {
            tmTmsceneProapp.setGmtCreate(this.getSysDate());
        }
        tmTmsceneProapp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmTmsceneProapp.getTmsceneProappCode())) {
            tmTmsceneProapp.setTmsceneProappCode(this.getNo(null, "TmTmsceneProapp", "tmTmsceneProapp", tmTmsceneProapp.getTenantCode()));
        }
    }

    private int getTmsceneProappMaxCode() {
        int code = 0;
        try {
            return this.tmTmsceneProappMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneProappMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTmsceneProappUpdataDefault(TmTmsceneProapp tmTmsceneProapp) {
        if (null == tmTmsceneProapp) {
            return;
        }
        tmTmsceneProapp.setGmtModified(this.getSysDate());
    }

    private void saveTmsceneProappModel(TmTmsceneProapp tmTmsceneProapp) throws ApiException {
        if (null == tmTmsceneProapp) {
            return;
        }
        try {
            this.tmTmsceneProappMapper.insert(tmTmsceneProapp);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneProappModel.ex", (Throwable)e);
        }
    }

    private void saveTmsceneProappBatchModel(List<TmTmsceneProapp> tmTmsceneProappList) throws ApiException {
        if (null == tmTmsceneProappList || tmTmsceneProappList.isEmpty()) {
            return;
        }
        try {
            this.tmTmsceneProappMapper.insertBatch(tmTmsceneProappList);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneProappBatchModel.ex", (Throwable)e);
        }
    }

    private TmTmsceneProapp getTmsceneProappModelById(Integer tmsceneProappId) {
        if (null == tmsceneProappId) {
            return null;
        }
        try {
            return this.tmTmsceneProappMapper.selectByPrimaryKey(tmsceneProappId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneProappModelById", (Throwable)e);
            return null;
        }
    }

    private TmTmsceneProapp getTmsceneProappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmTmsceneProappMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneProappModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTmsceneProappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneProappMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneProappModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneProappModelByCode.num");
        }
    }

    private void deleteTmsceneProappModel(Integer tmsceneProappId) throws ApiException {
        if (null == tmsceneProappId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneProappMapper.deleteByPrimaryKey(tmsceneProappId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneProappModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneProappModel.num");
        }
    }

    private void updateTmsceneProappModel(TmTmsceneProapp tmTmsceneProapp) throws ApiException {
        if (null == tmTmsceneProapp) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneProappMapper.updateByPrimaryKey(tmTmsceneProapp);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneProappModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneProappModel.num");
        }
    }

    private void updateStateTmsceneProappModel(Integer tmsceneProappId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == tmsceneProappId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tmsceneProappId", tmsceneProappId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmTmsceneProappMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneProappModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneProappModel.null");
        }
    }

    private void updateStateTmsceneProappModelByCode(String tenantCode, String tmsceneProappCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)tmsceneProappCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneProappCode", tmsceneProappCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmTmsceneProappMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneProappModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneProappModelByCode.null");
        }
    }

    private TmTmsceneProapp makeTmsceneProapp(TmTmsceneProappDomain tmTmsceneProappDomain, TmTmsceneProapp tmTmsceneProapp) {
        if (null == tmTmsceneProappDomain) {
            return null;
        }
        if (null == tmTmsceneProapp) {
            tmTmsceneProapp = new TmTmsceneProapp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmTmsceneProapp, (Object)tmTmsceneProappDomain);
            return tmTmsceneProapp;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmsceneProapp", (Throwable)e);
            return null;
        }
    }

    private TmTmsceneProappDomain makeTmsceneProappDomain(TmTmsceneProappDomain tmTmsceneProappDomain, TmSceneProapp tmSceneProapp) {
        if (null == tmSceneProapp) {
            return null;
        }
        if (null == tmTmsceneProappDomain) {
            tmTmsceneProappDomain = new TmTmsceneProappDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmTmsceneProappDomain, (Object)tmSceneProapp);
            return tmTmsceneProappDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmsceneProappDomain", (Throwable)e);
            return null;
        }
    }

    private TmTmsceneProappReDomain makeTmTmsceneProappReDomain(TmTmsceneProapp tmTmsceneProapp) {
        if (null == tmTmsceneProapp) {
            return null;
        }
        TmTmsceneProappReDomain tmTmsceneProappReDomain = new TmTmsceneProappReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmTmsceneProappReDomain, (Object)tmTmsceneProapp);
            return tmTmsceneProappReDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmTmsceneProappReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmTmsceneProapp> queryTmsceneProappModelPage(Map<String, Object> parammap) {
        try {
            return this.tmTmsceneProappMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.queryTmsceneProappModel", (Throwable)e);
            return null;
        }
    }

    private int countTmsceneProapp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmTmsceneProappMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.countTmsceneProapp", (Throwable)e);
        }
        return i;
    }

    private TmTmsceneProapp createTmTmsceneProapp(TmTmsceneProappDomain tmTmsceneProappDomain) {
        String msg = this.checkTmsceneProapp(tmTmsceneProappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneProapp.checkTmsceneProapp", msg);
        }
        TmTmsceneProapp tmTmsceneProapp = this.makeTmsceneProapp(tmTmsceneProappDomain, null);
        this.setTmsceneProappDefault(tmTmsceneProapp);
        return tmTmsceneProapp;
    }

    private String checkTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain) {
        if (null == tmTmsceneApiDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmTmsceneApiDomain.getSceneApiCode())) {
            msg = msg + "SceneApiCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmTmsceneApiDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTmsceneApiDefault(TmTmsceneApi tmTmsceneApi) {
        if (null == tmTmsceneApi) {
            return;
        }
        if (null == tmTmsceneApi.getDataState()) {
            tmTmsceneApi.setDataState(0);
        }
        if (null == tmTmsceneApi.getGmtCreate()) {
            tmTmsceneApi.setGmtCreate(this.getSysDate());
        }
        tmTmsceneApi.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmTmsceneApi.getTmsceneApiCode())) {
            tmTmsceneApi.setTmsceneApiCode(this.getNo(null, "TmTmsceneApi", "tmTmsceneApi", tmTmsceneApi.getTenantCode()));
        }
    }

    private int getTmsceneApiMaxCode() {
        int code = 0;
        try {
            return this.tmTmsceneApiMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneApiMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTmsceneApiUpdataDefault(TmTmsceneApi tmTmsceneApi) {
        if (null == tmTmsceneApi) {
            return;
        }
        tmTmsceneApi.setGmtModified(this.getSysDate());
    }

    private void saveTmsceneApiModel(TmTmsceneApi tmTmsceneApi) throws ApiException {
        if (null == tmTmsceneApi) {
            return;
        }
        try {
            this.tmTmsceneApiMapper.insert(tmTmsceneApi);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneApiModel.ex", (Throwable)e);
        }
    }

    private void saveTmsceneApiBatchModel(List<TmTmsceneApi> tmTmsceneApiList) throws ApiException {
        if (null == tmTmsceneApiList || tmTmsceneApiList.isEmpty()) {
            return;
        }
        try {
            this.tmTmsceneApiMapper.insertBatch(tmTmsceneApiList);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneApiBatchModel.ex", (Throwable)e);
        }
    }

    private TmTmsceneApi getTmsceneApiModelById(Integer tmsceneApiId) {
        if (null == tmsceneApiId) {
            return null;
        }
        try {
            return this.tmTmsceneApiMapper.selectByPrimaryKey(tmsceneApiId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneApiModelById", (Throwable)e);
            return null;
        }
    }

    private TmTmsceneApi getTmsceneApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmTmsceneApiMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneApiModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTmsceneApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneApiModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneApiModelByCode.num");
        }
    }

    private void deleteTmsceneApiModel(Integer tmsceneApiId) throws ApiException {
        if (null == tmsceneApiId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.deleteByPrimaryKey(tmsceneApiId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneApiModel.num");
        }
    }

    private void updateTmsceneApiModel(TmTmsceneApi tmTmsceneApi) throws ApiException {
        if (null == tmTmsceneApi) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.updateByPrimaryKey(tmTmsceneApi);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneApiModel.num");
        }
    }

    private void updateStateTmsceneApiModel(Integer tmsceneApiId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == tmsceneApiId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tmsceneApiId", tmsceneApiId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneApiModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneApiModel.null");
        }
    }

    private void updateStateTmsceneApiModelByCode(String tenantCode, String tmsceneApiCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)tmsceneApiCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneApiCode", tmsceneApiCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneApiModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneApiModelByCode.null");
        }
    }

    private void updateResultTmsceneApiModelByCode(String tenantCode, String tmsceneApiCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)tmsceneApiCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneApiCode", tmsceneApiCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.updateResultByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateResultTmsceneApiModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateResultTmsceneApiModelByCode.null");
        }
    }

    private TmTmsceneApi makeTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain, TmTmsceneApi tmTmsceneApi) {
        if (null == tmTmsceneApiDomain) {
            return null;
        }
        if (null == tmTmsceneApi) {
            tmTmsceneApi = new TmTmsceneApi();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmTmsceneApi, (Object)tmTmsceneApiDomain);
            return tmTmsceneApi;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmsceneApi", (Throwable)e);
            return null;
        }
    }

    private TmTmsceneApiReDomain makeTmTmsceneApiReDomain(TmTmsceneApi tmTmsceneApi) {
        if (null == tmTmsceneApi) {
            return null;
        }
        TmTmsceneApiReDomain tmTmsceneApiReDomain = new TmTmsceneApiReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmTmsceneApiReDomain, (Object)tmTmsceneApi);
            return tmTmsceneApiReDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmTmsceneApiReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmTmsceneApi> queryTmsceneApiModelPage(Map<String, Object> parammap) {
        try {
            return this.tmTmsceneApiMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.queryTmsceneApiModel", (Throwable)e);
            return null;
        }
    }

    private int countTmsceneApi(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.countTmsceneApi", (Throwable)e);
        }
        return i;
    }

    private TmTmsceneApi createTmTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain) {
        String msg = this.checkTmsceneApi(tmTmsceneApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneApi.checkTmsceneApi", msg);
        }
        TmTmsceneApi tmTmsceneApi = this.makeTmsceneApi(tmTmsceneApiDomain, null);
        this.setTmsceneApiDefault(tmTmsceneApi);
        return tmTmsceneApi;
    }

    @Override
    public List<TmTmsceneApi> saveTmscene(TmTmsceneDomain tmTmsceneDomain) throws ApiException {
        TmTmscene tmTmscene = this.createTmTmscene(tmTmsceneDomain);
        this.saveTmsceneModel(tmTmscene);
        this.saveProappList(tmTmscene, tmTmsceneDomain.getTmTmsceneProappDomainList());
        List<TmTmsceneApi> tmTmsceneApiList = this.saveApiList(tmTmscene);
        return tmTmsceneApiList;
    }

    private void saveProappList(TmTmscene tmTmscene, List<TmTmsceneProappDomain> tmTmsceneProappDomainList) {
        if (null == tmTmscene || StringUtils.isBlank((String)tmTmscene.getSceneroleCode())) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sceneroleCode", tmTmscene.getSceneroleCode());
        map.put("tenantCode", tmTmscene.getTenantCode());
        Map<String, TmSceneProapp> sceneProappMap = this.querySceneProappToMap(map);
        if (ListUtil.isEmpty(tmTmsceneProappDomainList)) {
            tmTmsceneProappDomainList = new ArrayList<TmTmsceneProappDomain>();
            for (String key : sceneProappMap.keySet()) {
                TmTmsceneProappDomain tmTmsceneProappDomain = new TmTmsceneProappDomain();
                tmTmsceneProappDomain.setTmsceneCode(tmTmscene.getTmsceneCode());
                tmTmsceneProappDomain.setSceneroleCode(tmTmscene.getSceneroleCode());
                tmTmsceneProappDomain.setProappName(tmTmscene.getSceneroleName());
                TmSceneProapp tmSceneProapp = sceneProappMap.get(key);
                if (null == tmSceneProapp) continue;
                this.makeTmsceneProappDomain(tmTmsceneProappDomain, tmSceneProapp);
                tmTmsceneProappDomainList.add(tmTmsceneProappDomain);
            }
        } else {
            for (TmTmsceneProappDomain tmTmsceneProappDomain : tmTmsceneProappDomainList) {
                tmTmsceneProappDomain.setTmsceneCode(tmTmscene.getTmsceneCode());
                tmTmsceneProappDomain.setSceneroleCode(tmTmscene.getSceneroleCode());
                tmTmsceneProappDomain.setProappName(tmTmscene.getSceneroleName());
                TmSceneProapp tmSceneProapp = sceneProappMap.get(tmTmsceneProappDomain.getProappCode() + "-" + tmTmscene.getSceneroleCode());
                if (null == tmSceneProapp) continue;
                this.makeTmsceneProappDomain(tmTmsceneProappDomain, tmSceneProapp);
            }
        }
        this.saveTmsceneProappBatch(tmTmsceneProappDomainList);
    }

    public List<TmTmsceneApi> saveApiList(TmTmscene tmTmscene) {
        if (null == tmTmscene) {
            return null;
        }
        TmScene tmScene = this.tmSceneService.getSceneByCode(tmTmscene.getTenantCode(), tmTmscene.getSceneCode());
        if (null == tmScene) {
            return null;
        }
        List<TmTmsceneApiDomain> tmTmsceneApiDomainList = this.makeApiList(tmTmscene, tmScene);
        if (ListUtil.isEmpty(tmTmsceneApiDomainList)) {
            return null;
        }
        List<TmTmsceneApi> tmTmsceneApiList = this.saveTmsceneApiReList(tmTmsceneApiDomainList);
        return tmTmsceneApiList;
    }

    private List<TmTmsceneApiDomain> makeApiList(TmTmscene tmTmscene, TmScene tmScene) {
        List<TmScene> tmScenePList;
        if (null == tmTmscene || null == tmScene) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sceneCode", tmScene.getSceneCode());
        map.put("tenantCode", tmTmscene.getTenantCode());
        ArrayList<TmTmsceneApiDomain> tmTmsceneApiDomainList = new ArrayList<TmTmsceneApiDomain>();
        List<TmSceneApi> tmSceneApiList = this.querySceneApiModelPage(map);
        if (ListUtil.isNotEmpty(tmSceneApiList)) {
            for (TmSceneApi TmSceneApi2 : tmSceneApiList) {
                TmTmsceneApiDomain tmTmsceneApiDomain = new TmTmsceneApiDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)tmTmsceneApiDomain, (Object)tmScene);
                    BeanUtils.copyAllPropertys((Object)tmTmsceneApiDomain, (Object)TmSceneApi2);
                    tmTmsceneApiDomain.setTmsceneCode(tmTmscene.getTmsceneCode());
                    tmTmsceneApiDomain.setTenantCode(tmTmscene.getTenantCode());
                    tmTmsceneApiDomainList.add(tmTmsceneApiDomain);
                }
                catch (Exception e) {
                    this.logger.error("tm.TmTmsceneServiceImpl.makeList<TmTmsceneApi>", (Throwable)e);
                }
            }
        }
        if (ListUtil.isEmpty(tmScenePList = this.tmSceneService.querySceneByPcode(tmTmscene.getTenantCode(), tmScene.getSceneCode(), tmScene.getSceneType()))) {
            return tmTmsceneApiDomainList;
        }
        List<TmTmsceneApiDomain> tmTmsceneApiDomainPList = null;
        for (TmScene tmScene1 : tmScenePList) {
            tmTmsceneApiDomainPList = this.makeApiList(tmTmscene, tmScene1);
            if (!ListUtil.isNotEmpty(tmTmsceneApiDomainPList)) continue;
            tmTmsceneApiDomainList.addAll(tmTmsceneApiDomainPList);
        }
        return tmTmsceneApiDomainList;
    }

    @Override
    public String saveTmsceneBatch(List<TmTmsceneDomain> tmTmsceneDomainList) throws ApiException {
        if (null == tmTmsceneDomainList || tmTmsceneDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (TmTmsceneDomain tmTmsceneDomain : tmTmsceneDomainList) {
            this.saveTmscene(tmTmsceneDomain);
        }
        return code;
    }

    @Override
    public void updateTmsceneState(Integer tmsceneId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateTmsceneModel(tmsceneId, dataState, oldDataState, map);
    }

    @Override
    public void updateTmsceneStateByCode(String tenantCode, String tmsceneCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateTmsceneModelByCode(tenantCode, tmsceneCode, dataState, oldDataState, map);
    }

    @Override
    public void updateTmscene(TmTmsceneDomain tmTmsceneDomain) throws ApiException {
        String msg = this.checkTmscene(tmTmsceneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmscene.checkTmscene", msg);
        }
        TmTmscene oldTmTmscene = this.getTmsceneModelById(tmTmsceneDomain.getTmsceneId());
        if (null == oldTmTmscene) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmscene.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmTmscene tmTmscene = this.makeTmscene(tmTmsceneDomain, oldTmTmscene);
        this.setTmsceneUpdataDefault(tmTmscene);
        this.updateTmsceneModel(tmTmscene);
    }

    @Override
    public TmTmscene getTmscene(Integer tmsceneId) {
        return this.getTmsceneModelById(tmsceneId);
    }

    @Override
    public void deleteTmscene(Integer tmsceneId) throws ApiException {
        this.deleteTmsceneModel(tmsceneId);
    }

    @Override
    public QueryResult<TmTmscene> queryTmscenePage(Map<String, Object> map) {
        List<TmTmscene> tmTmsceneList = this.queryTmsceneModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTmscene(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmTmsceneList);
        return queryResult;
    }

    @Override
    public TmTmscene getTmsceneByCode(String tenantCode, String tmsceneCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneCode", tmsceneCode);
        return this.getTmsceneModelByCode(map);
    }

    @Override
    public void deleteTmsceneByCode(String tenantCode, String tmsceneCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneCode", tmsceneCode);
        this.delTmsceneModelByCode(map);
    }

    @Override
    public String saveTmsceneProapp(TmTmsceneProappDomain tmTmsceneProappDomain) throws ApiException {
        TmTmsceneProapp tmTmsceneProapp = this.createTmTmsceneProapp(tmTmsceneProappDomain);
        this.saveTmsceneProappModel(tmTmsceneProapp);
        return tmTmsceneProapp.getTmsceneProappCode();
    }

    @Override
    public String saveTmsceneProappBatch(List<TmTmsceneProappDomain> tmTmsceneProappDomainList) throws ApiException {
        if (null == tmTmsceneProappDomainList || tmTmsceneProappDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TmTmsceneProapp> tmTmsceneProappList = new ArrayList<TmTmsceneProapp>();
        String code = "";
        for (TmTmsceneProappDomain tmTmsceneProappDomain : tmTmsceneProappDomainList) {
            TmTmsceneProapp tmTmsceneProapp = this.createTmTmsceneProapp(tmTmsceneProappDomain);
            code = tmTmsceneProapp.getTmsceneProappCode();
            tmTmsceneProappList.add(tmTmsceneProapp);
        }
        this.saveTmsceneProappBatchModel(tmTmsceneProappList);
        return code;
    }

    @Override
    public void updateTmsceneProappState(Integer tmsceneProappId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateTmsceneProappModel(tmsceneProappId, dataState, oldDataState, map);
    }

    @Override
    public void updateTmsceneProappStateByCode(String tenantCode, String tmsceneProappCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateTmsceneProappModelByCode(tenantCode, tmsceneProappCode, dataState, oldDataState, map);
    }

    @Override
    public void updateTmsceneProapp(TmTmsceneProappDomain tmTmsceneProappDomain) throws ApiException {
        String msg = this.checkTmsceneProapp(tmTmsceneProappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneProapp.checkTmsceneProapp", msg);
        }
        TmTmsceneProapp oldTmTmsceneProapp = this.getTmsceneProappModelById(tmTmsceneProappDomain.getTmsceneProappId());
        if (null == oldTmTmsceneProapp) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneProapp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmTmsceneProapp tmTmsceneProapp = this.makeTmsceneProapp(tmTmsceneProappDomain, oldTmTmsceneProapp);
        this.setTmsceneProappUpdataDefault(tmTmsceneProapp);
        this.updateTmsceneProappModel(tmTmsceneProapp);
    }

    @Override
    public TmTmsceneProapp getTmsceneProapp(Integer tmsceneProappId) {
        return this.getTmsceneProappModelById(tmsceneProappId);
    }

    @Override
    public void deleteTmsceneProapp(Integer tmsceneProappId) throws ApiException {
        this.deleteTmsceneProappModel(tmsceneProappId);
    }

    @Override
    public QueryResult<TmTmsceneProapp> queryTmsceneProappPage(Map<String, Object> map) {
        List<TmTmsceneProapp> tmTmsceneProappList = this.queryTmsceneProappModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTmsceneProapp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmTmsceneProappList);
        return queryResult;
    }

    @Override
    public TmTmsceneProapp getTmsceneProappByCode(String tenantCode, String tmsceneProappCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneProappCode", tmsceneProappCode);
        return this.getTmsceneProappModelByCode(map);
    }

    @Override
    public void deleteTmsceneProappByCode(String tenantCode, String tmsceneProappCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneProappCode", tmsceneProappCode);
        this.delTmsceneProappModelByCode(map);
    }

    @Override
    public String saveTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain) throws ApiException {
        TmTmsceneApi tmTmsceneApi = this.createTmTmsceneApi(tmTmsceneApiDomain);
        this.saveTmsceneApiModel(tmTmsceneApi);
        return tmTmsceneApi.getTmsceneApiCode();
    }

    @Override
    public String saveTmsceneApiBatch(List<TmTmsceneApiDomain> tmTmsceneApiDomainList) throws ApiException {
        List<TmTmsceneApi> tmTmsceneApiList = this.saveTmsceneApiReList(tmTmsceneApiDomainList);
        if (ListUtil.isEmpty(tmTmsceneApiList)) {
            return null;
        }
        return tmTmsceneApiList.get(0).getSceneApiCode();
    }

    private List<TmTmsceneApi> saveTmsceneApiReList(List<TmTmsceneApiDomain> tmTmsceneApiDomainList) {
        if (null == tmTmsceneApiDomainList || tmTmsceneApiDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TmTmsceneApi> tmTmsceneApiList = new ArrayList<TmTmsceneApi>();
        for (TmTmsceneApiDomain tmTmsceneApiDomain : tmTmsceneApiDomainList) {
            TmTmsceneApi tmTmsceneApi = this.createTmTmsceneApi(tmTmsceneApiDomain);
            tmTmsceneApiList.add(tmTmsceneApi);
        }
        this.saveTmsceneApiBatchModel(tmTmsceneApiList);
        return tmTmsceneApiList;
    }

    @Override
    public void updateTmsceneApiState(Integer tmsceneApiId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateTmsceneApiModel(tmsceneApiId, dataState, oldDataState, map);
    }

    @Override
    public void updateTmsceneApiStateByCode(String tenantCode, String tmsceneApiCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateTmsceneApiModelByCode(tenantCode, tmsceneApiCode, dataState, oldDataState, map);
    }

    @Override
    public void updateTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain) throws ApiException {
        String msg = this.checkTmsceneApi(tmTmsceneApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneApi.checkTmsceneApi", msg);
        }
        TmTmsceneApi oldTmTmsceneApi = this.getTmsceneApiModelById(tmTmsceneApiDomain.getTmsceneApiId());
        if (null == oldTmTmsceneApi) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneApi.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmTmsceneApi tmTmsceneApi = this.makeTmsceneApi(tmTmsceneApiDomain, oldTmTmsceneApi);
        this.setTmsceneApiUpdataDefault(tmTmsceneApi);
        this.updateTmsceneApiModel(tmTmsceneApi);
    }

    @Override
    public TmTmsceneApi getTmsceneApi(Integer tmsceneApiId) {
        return this.getTmsceneApiModelById(tmsceneApiId);
    }

    @Override
    public void deleteTmsceneApi(Integer tmsceneApiId) throws ApiException {
        this.deleteTmsceneApiModel(tmsceneApiId);
    }

    @Override
    public QueryResult<TmTmsceneApi> queryTmsceneApiPage(Map<String, Object> map) {
        List<TmTmsceneApi> tmTmsceneApiList = this.queryTmsceneApiModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTmsceneApi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmTmsceneApiList);
        return queryResult;
    }

    @Override
    public TmTmsceneApi getTmsceneApiByCode(String tenantCode, String tmsceneApiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneApiCode", tmsceneApiCode);
        return this.getTmsceneApiModelByCode(map);
    }

    @Override
    public void deleteTmsceneApiByCode(String tenantCode, String tmsceneApiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneApiCode", tmsceneApiCode);
        this.delTmsceneApiModelByCode(map);
    }

    @Override
    public String saveTmsceneForPlat(TmTmsceneDomain tmTmsceneDomain) throws ApiException {
        TmTmscene tmTmscene = this.createTmTmscene(tmTmsceneDomain);
        this.saveTmsceneModel(tmTmscene);
        TmTmsceneProapp tmTmsceneProapp = new TmTmsceneProapp();
        List<TmTmsceneProappDomain> tmsceneProappList = tmTmsceneDomain.getTmTmsceneProappDomainList();
        for (TmTmsceneProappDomain domain : tmsceneProappList) {
            TmTmsceneProapp proapp = this.makeTmsceneProapp(domain, tmTmsceneProapp);
            this.saveTmsceneProappModel(proapp);
        }
        String sceneCode = tmTmscene.getSceneCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sceneCode", sceneCode);
        List<TmSceneApi> tmSceneApis = this.querySceneApiModelPage(map);
        ArrayList<TmTmsceneApi> tmTmsceneApis = new ArrayList<TmTmsceneApi>();
        try {
            BeanUtils.copyAllPropertys(tmTmsceneApis, tmSceneApis);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeList<TmTmsceneApi>", (Throwable)e);
        }
        this.saveTmsceneApiBatchModel(tmTmsceneApis);
        return tmTmscene.getTmsceneCode();
    }

    private List<TmSceneApi> querySceneApiModelPage(Map<String, Object> parammap) {
        QueryResult<TmSceneApi> qapi = this.tmSceneService.querySceneApiPage(parammap);
        if (null == qapi || ListUtil.isEmpty((Collection)qapi.getRows())) {
            return null;
        }
        return qapi.getRows();
    }

    private Map<String, TmSceneProapp> querySceneProappToMap(Map<String, Object> parammap) {
        QueryResult<TmSceneProapp> qproapp = this.tmSceneService.querySceneProappPage(parammap);
        if (null == qproapp || ListUtil.isEmpty((Collection)qproapp.getRows())) {
            return null;
        }
        HashMap<String, TmSceneProapp> map = new HashMap<String, TmSceneProapp>();
        for (TmSceneProapp tmSceneProapp : qproapp.getRows()) {
            map.put(tmSceneProapp.getProappCode() + "-" + tmSceneProapp.getSceneroleCode(), tmSceneProapp);
        }
        return map;
    }

    @Override
    public void saveTmsceneInit(String sceneType, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)sceneType)) {
            sceneType = "init";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sceneType", sceneType);
        map.put("tenantCode", "00000000");
        QueryResult<TmScene> qscene = this.tmSceneService.queryScenePage(map);
        if (null == qscene || ListUtil.isEmpty((Collection)qscene.getRows())) {
            return;
        }
        for (TmScene tmScene : qscene.getRows()) {
            TmTmsceneDomain tmTmsceneDomain = new TmTmsceneDomain();
            try {
                BeanUtils.copyAllPropertys((Object)tmTmsceneDomain, (Object)tmScene);
                tmTmsceneDomain.setTmsceneTenant(tenantCode);
            }
            catch (Exception e) {
                continue;
            }
            this.saveTmscene(tmTmsceneDomain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((TmTmsceneService)SpringApplicationContextUtil.getBean((String)"tmTmsceneService"));
                for (int i = 0; i < 5; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    @Override
    public void loadDb() {
        this.loadDb(0);
        this.loadDb(2);
    }

    public void loadDb(Integer dataState) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("dataState", dataState);
            map.put("orderStr", "SCENE_API_ORDER asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<TmTmsceneApi> result = null;
            do {
                startRow = this.getEsEngineService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getEsEngineService().getPage());
                result = this.queryTmsceneApiPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), result.getRows()));
                    if (result.getRows().size() != this.getEsEngineService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            this.getEsEngineService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public void sendTmsceneApi(TmTmsceneApi tmTmsceneApi) {
        if (null == tmTmsceneApi) {
            return;
        }
        TmTmsceneApi oldTmTmsceneApi = this.getTmsceneApiByCode(tmTmsceneApi.getTenantCode(), tmTmsceneApi.getTmsceneApiCode());
        if (null == oldTmTmsceneApi) {
            throw new ApiException("tm.TmTmsceneServiceImpl.sendTmsceneApi.oldTmTmsceneApi", tmTmsceneApi.getTenantCode() + "-" + tmTmsceneApi.getTmsceneApiCode());
        }
        if (1 == oldTmTmsceneApi.getDataState()) {
            return;
        }
        TmTmscene tmTmscene = this.getTmsceneByCode(tmTmsceneApi.getTenantCode(), tmTmsceneApi.getTmsceneCode());
        if (null == tmTmscene) {
            throw new ApiException("tm.TmTmsceneServiceImpl.sendTmsceneApi.tmTmscene", tmTmsceneApi.getTenantCode() + "-" + tmTmsceneApi.getTmsceneCode());
        }
        this.updateStateTmsceneModelByCode(tmTmscene.getTenantCode(), tmTmsceneApi.getTmsceneCode(), 1, null, null);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("tmTmscene", tmTmscene);
        String json = DisUtil.getRemotMap((String)"tmtenant-code", (String)tmTmscene.getTmsceneTenant());
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.sendTmsceneApi.json", tmTmsceneApi.getTenantCode() + "-" + tmTmscene.getTmsceneTenant());
        }
        TmTenant tmTenant = (TmTenant)JsonUtil.buildNormalBinder().getJsonToObject(json, TmTenant.class);
        if (null == tmTenant) {
            throw new ApiException("tm.TmTmsceneServiceImpl.sendTmsceneApi.tmTmscene", tmTmsceneApi.getTenantCode() + "-" + tmTmsceneApi.getTmsceneCode());
        }
        dataMap.put("tmTenant", tmTenant);
        TmSceneApi tmSceneApi = this.tmSceneService.getSceneApiByCode(tmTmscene.getTenantCode(), tmTmsceneApi.getSceneApiCode());
        this.makeProapp(dataMap, tmTmsceneApi, tmTmscene);
        String cflowNodeStart = this.callService(tmSceneApi, dataMap);
        Integer dataState = FlowStartCon.CE.getCode().equals(cflowNodeStart) ? Integer.valueOf(2) : Integer.valueOf(1);
        this.updateResultTmsceneApiModelByCode(tmTmscene.getTenantCode(), tmTmsceneApi.getTmsceneApiCode(), dataState, oldTmTmsceneApi.getDataState(), null);
        if (1 == dataState) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tmsceneCode", tmTmsceneApi.getTmsceneCode());
            map.put("dataState", 0);
            map.put("tenantCode", tmTmsceneApi.getTenantCode());
            List<TmTmsceneApi> result = this.queryTmsceneApiModelPage(map);
            if (ListUtil.isEmpty(result)) {
                map.put("dataState", 2);
                result = this.queryTmsceneApiModelPage(map);
                if (ListUtil.isNotEmpty(result)) {
                    return;
                }
            } else {
                return;
            }
            this.updateStateTmsceneModelByCode(tmTmscene.getTenantCode(), tmTmsceneApi.getTmsceneCode(), 2, 1, null);
        }
    }

    private String callService2(TmSceneApi tmSceneApi, Map<String, Object> map) {
        String res;
        String paramStr;
        if (null == tmSceneApi) {
            return null;
        }
        if (!this.excetuConJs(map, tmSceneApi.getDataCallcon2())) {
            return FlowStartCon.CS.getCode();
        }
        if ("mock".equals(tmSceneApi.getDataCallurl2())) {
            return FlowStartCon.CS.getCode();
        }
        if (!"tmProappEnvBeanList".equals(tmSceneApi.getDataParam2())) {
            paramStr = SoaUtil.makeParam((String)tmSceneApi.getDataParam2(), (String)tmSceneApi.getDataCom2(), map);
        } else {
            HashMap<String, Object> callmap = new HashMap<String, Object>();
            callmap.put("tmProappEnvBeanList", map.get("tmProappEnvBeanList"));
            paramStr = JsonUtil.buildNormalBinder().toJson(callmap);
        }
        Object obj = null;
        try {
            obj = UddiUtil.invokeUrl((String)tmSceneApi.getDataCalltype2(), (String)tmSceneApi.getDataCallurl2(), (String)paramStr, null);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.callService.error.e", (Object)(tmSceneApi.getDataCallurl2() + "=" + paramStr), (Throwable)e);
            return FlowStartCon.CE.getCode();
        }
        OutMessage outMessage = null;
        if (obj instanceof OutMessage) {
            outMessage = (OutMessage)obj;
            if (outMessage.isError()) {
                this.logger.error("tm.TmTmsceneServiceImpl.callService.error.obj", (Object)(outMessage.getReObj() + "======" + outMessage.isError() + "======" + tmSceneApi.getDataCallurl2() + "=" + paramStr));
                throw new ApiException("tm.TmTmsceneServiceImpl.callService.error", tmSceneApi.getDataCallurl2() + "==" + paramStr);
            }
            res = null == outMessage.getReObj() ? null : outMessage.getReObj().toString();
        } else {
            res = (String)obj;
        }
        if ("null".equals(tmSceneApi.getDataFlag2())) {
            return FlowStartCon.CS.getCode();
        }
        if ("String".equals(tmSceneApi.getDataFlag2())) {
            if (StringUtils.isBlank((String)res)) {
                return FlowStartCon.CE.getCode();
            }
            return FlowStartCon.CS.getCode();
        }
        if (res.equals(tmSceneApi.getDataFlag2())) {
            return FlowStartCon.CS.getCode();
        }
        if (res.indexOf("{") >= 0) {
            OcReorderDomain ocReorderDomain = (OcReorderDomain)JsonUtil.buildNormalBinder().getJsonToObject(res, OcReorderDomain.class);
            if (ocReorderDomain.isError()) {
                return FlowStartCon.CE.getCode();
            }
            if (ocReorderDomain.isSuccess()) {
                return FlowStartCon.CS.getCode();
            }
        }
        return FlowStartCon.CE.getCode();
    }

    private boolean excetuConJs(Map<String, Object> conMap, String conStr) {
        if (StringUtils.isBlank((String)conStr)) {
            return true;
        }
        String res = (String)ScriptUtil.evel((String)conStr, conMap);
        if (!"ok".equals(res)) {
            this.logger.debug("tm.TmTmsceneServiceImpl.excetuCon.js", (Object)("condition:" + conStr));
            return false;
        }
        return true;
    }

    private String callService(TmSceneApi tmSceneApi, Map<String, Object> map) {
        String res;
        String paramStr;
        if (null == tmSceneApi) {
            return null;
        }
        if (!this.excetuConJs(map, tmSceneApi.getDataCallcon())) {
            return FlowStartCon.CS.getCode();
        }
        if ("mock".equals(tmSceneApi.getDataCallurl())) {
            if (StringUtils.isNotBlank((String)tmSceneApi.getDataCallurl2())) {
                return this.callService2(tmSceneApi, map);
            }
            return FlowStartCon.CS.getCode();
        }
        if (!"tmProappEnvBeanList".equals(tmSceneApi.getDataParam())) {
            paramStr = SoaUtil.makeParam((String)tmSceneApi.getDataParam(), (String)tmSceneApi.getDataCom(), map);
        } else {
            HashMap<String, Object> callmap = new HashMap<String, Object>();
            callmap.put("tmProappEnvBeanList", map.get("tmProappEnvBeanList"));
            paramStr = JsonUtil.buildNormalBinder().toJson(callmap);
        }
        Object obj = null;
        try {
            obj = UddiUtil.invokeUrl((String)tmSceneApi.getDataCalltype(), (String)tmSceneApi.getDataCallurl(), (String)paramStr, null);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.callService.error.e", (Object)(tmSceneApi.getDataCallurl() + "=" + paramStr), (Throwable)e);
            return FlowStartCon.CE.getCode();
        }
        OutMessage outMessage = null;
        if (obj instanceof OutMessage) {
            outMessage = (OutMessage)obj;
            if (outMessage.isError()) {
                this.logger.error("tm.TmTmsceneServiceImpl.callService.error.obj", (Object)(outMessage.getReObj() + "======" + outMessage.isError() + "======" + tmSceneApi.getDataCallurl() + "=" + paramStr));
                throw new ApiException("tm.TmTmsceneServiceImpl.callService.error", tmSceneApi.getDataCallurl() + "==" + paramStr);
            }
            res = null == outMessage.getReObj() ? null : outMessage.getReObj().toString();
        } else {
            res = (String)obj;
        }
        if ("null".equals(tmSceneApi.getDataFlag())) {
            if (StringUtils.isNotBlank((String)tmSceneApi.getDataCallurl2())) {
                return this.callService2(tmSceneApi, map);
            }
            return FlowStartCon.CS.getCode();
        }
        if ("String".equals(tmSceneApi.getDataFlag())) {
            if (StringUtils.isBlank((String)res)) {
                return FlowStartCon.CE.getCode();
            }
            if (StringUtils.isNotBlank((String)tmSceneApi.getDataCallurl2())) {
                map.put("result", res);
                return this.callService2(tmSceneApi, map);
            }
            return FlowStartCon.CS.getCode();
        }
        if (res.equals(tmSceneApi.getDataFlag())) {
            if (StringUtils.isNotBlank((String)tmSceneApi.getDataCallurl2())) {
                map.put("result", res);
                return this.callService2(tmSceneApi, map);
            }
            return FlowStartCon.CS.getCode();
        }
        if (res.indexOf("{") >= 0) {
            OcReorderDomain ocReorderDomain = (OcReorderDomain)JsonUtil.buildNormalBinder().getJsonToObject(res, OcReorderDomain.class);
            if (ocReorderDomain.isError()) {
                return FlowStartCon.CE.getCode();
            }
            if (ocReorderDomain.isSuccess()) {
                if (StringUtils.isNotBlank((String)tmSceneApi.getDataCallurl2())) {
                    map.put("result", res);
                    return this.callService2(tmSceneApi, map);
                }
                return FlowStartCon.CS.getCode();
            }
        }
        return FlowStartCon.CE.getCode();
    }

    private void makeProapp(Map<String, Object> dataMap, TmTmsceneApi tmTmsceneApi, TmTmscene tmTmscene) {
        if (null == tmTmsceneApi || null == dataMap || null == tmTmscene) {
            return;
        }
        String tenantCode = tmTmscene.getTmsceneTenant();
        String conf = tmTmscene.getTmsceneConf();
        Map tmsceneConfMap = null;
        if (StringUtils.isNotBlank((String)conf)) {
            tmsceneConfMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(conf, String.class, Object.class);
            dataMap.put("tmsceneConf", tmsceneConfMap);
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tmTmsceneApi.getTenantCode());
        parammap.put("tmsceneCode", tmTmsceneApi.getTmsceneCode());
        List<TmTmsceneProapp> tmTmsceneProappList = this.queryTmsceneProappModelPage(parammap);
        if (ListUtil.isEmpty(tmTmsceneProappList)) {
            return;
        }
        ArrayList<TmProappEnvBean> tmProappEnvBeanList = new ArrayList<TmProappEnvBean>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<TmProappEnvBean> buyTmProappEnvBeanList = new ArrayList<TmProappEnvBean>();
        for (TmTmsceneProapp tmTmsceneProapp : tmTmsceneProappList) {
            TmProappEnvBean tmProappEnvBean = this.makeTmProappEnvBean(tmTmsceneProapp);
            if (null == tmProappEnvBean) continue;
            tmProappEnvBean.setTenantCode(tenantCode);
            map.put("tenantCode", "00000000");
            map.put("proappCode", tmTmsceneProapp.getProappCode());
            map.put("rel", "rel");
            TmProapp tmProapp = this.tmProappService.getProappByCode(map);
            if (null != tmProapp) {
                tmProappEnvBean.setOauthEnvCode(tmProapp.getOauthEnvCode());
            }
            tmProappEnvBean.setTmProappMenuBeanList(this.makeMenuList(tmTmsceneProapp, tenantCode));
            QueryResult<TmProappEnv> qt = this.tmProappService.queryProappEnvPage(map);
            if (null != qt && ListUtil.isNotEmpty((Collection)qt.getRows())) {
                tmProappEnvBean.setChannelCode(((TmProappEnv)qt.getRows().get(0)).getChannelCode());
                if (StringUtils.isBlank((String)tmProappEnvBean.getProappEnvDomain())) {
                    tmProappEnvBean.setProappEnvDomain(((TmProappEnv)qt.getRows().get(0)).getProappEnvDomain());
                }
                if (StringUtils.isBlank((String)tmProappEnvBean.getProappEnvDomain1())) {
                    tmProappEnvBean.setProappEnvDomain1(((TmProappEnv)qt.getRows().get(0)).getProappEnvDomain1());
                }
                if (StringUtils.isBlank((String)tmProappEnvBean.getProappEnvDomain2())) {
                    tmProappEnvBean.setProappEnvDomain2(((TmProappEnv)qt.getRows().get(0)).getProappEnvDomain2());
                }
                String domain = "";
                if (null != tmsceneConfMap) {
                    domain = (String)tmsceneConfMap.get("domain");
                }
                if (StringUtils.isNotBlank((String)tmProappEnvBean.getProappEnvDomain()) && tmProappEnvBean.getProappEnvDomain().indexOf("{domain}") >= 0) {
                    if (StringUtils.isBlank((String)domain)) {
                        domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnvBean.getTenantCode() + "-domain"));
                    }
                    if (StringUtils.isNotBlank((String)domain)) {
                        tmProappEnvBean.setProappEnvDomain(tmProappEnvBean.getProappEnvDomain().replace("{domain}", domain));
                    }
                }
                if (StringUtils.isNotBlank((String)tmProappEnvBean.getProappEnvDomain1()) && tmProappEnvBean.getProappEnvDomain1().indexOf("{domain0}") >= 0) {
                    if (StringUtils.isBlank((String)domain)) {
                        domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnvBean.getTenantCode() + "-domain0"));
                    }
                    if (StringUtils.isNotBlank((String)domain)) {
                        tmProappEnvBean.setProappEnvDomain1(tmProappEnvBean.getProappEnvDomain1().replace("{domain0}", domain));
                    }
                }
                if (StringUtils.isNotBlank((String)tmProappEnvBean.getProappEnvDomain2()) && tmProappEnvBean.getProappEnvDomain2().indexOf("{domain1}") >= 0) {
                    if (StringUtils.isBlank((String)domain)) {
                        domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnvBean.getTenantCode() + "-domain1"));
                    }
                    if (StringUtils.isNotBlank((String)domain)) {
                        tmProappEnvBean.setProappEnvDomain2(tmProappEnvBean.getProappEnvDomain2().replace("{domain1}", domain));
                    }
                }
                if ("2".equals(((TmProappEnv)qt.getRows().get(0)).getProappSort())) {
                    buyTmProappEnvBeanList.add(tmProappEnvBean);
                }
                if ("0".equals(((TmProappEnv)qt.getRows().get(0)).getProappSort())) {
                    dataMap.put("proappType", tmProapp.getProappType());
                }
            }
            tmProappEnvBeanList.add(tmProappEnvBean);
        }
        dataMap.put("tmProappEnvBeanList", tmProappEnvBeanList);
        dataMap.put("buyTmProappEnvBeanList", buyTmProappEnvBeanList);
    }

    private List<TmProappMenuBean> makeMenuList(TmTmsceneProapp tmTmsceneProapp, String tenantCode) {
        if (null == tmTmsceneProapp) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tmTmsceneProapp.getTenantCode());
        map.put("sceneProappCode", tmTmsceneProapp.getSceneProappCode());
        QueryResult<TmSceneMenu> qmenu = this.tmSceneService.querySceneMenuPage(map);
        if (null == qmenu || ListUtil.isEmpty((Collection)qmenu.getRows())) {
            return null;
        }
        ArrayList<TmProappMenuBean> tmProappMenuBeanList = new ArrayList<TmProappMenuBean>();
        for (TmSceneMenu tmSceneMenu : qmenu.getRows()) {
            TmProappMenuBean tmProappMenuBean = new TmProappMenuBean();
            try {
                BeanUtils.copyAllPropertys((Object)tmProappMenuBean, (Object)tmSceneMenu);
                tmProappMenuBean.setTenantCode(tenantCode);
            }
            catch (Exception e) {
                // empty catch block
            }
            map.put("sceneProappCode", tmSceneMenu.getSceneMenuCode());
            QueryResult<TmSceneMenupri> qMenupri = this.tmSceneMenupriService.querySceneMenupriPage(map);
            tmProappMenuBean.setTmProappMenupriBeanList(this.makePriBean(qMenupri.getList(), tenantCode));
            tmProappMenuBeanList.add(tmProappMenuBean);
        }
        return tmProappMenuBeanList;
    }

    private List<TmProappMenupriBean> makePriBean(List<TmSceneMenupri> tmSceneMenupriList, String tenantCode) {
        if (ListUtil.isEmpty(tmSceneMenupriList)) {
            return null;
        }
        ArrayList<TmProappMenupriBean> beanList = new ArrayList<TmProappMenupriBean>();
        for (TmSceneMenupri tmSceneMenupri : tmSceneMenupriList) {
            TmProappMenupriBean tmProappMenupriBean = new TmProappMenupriBean();
            try {
                BeanUtils.copyAllPropertys((Object)tmProappMenupriBean, (Object)tmSceneMenupri);
                tmProappMenupriBean.setTenantCode(tenantCode);
                beanList.add(tmProappMenupriBean);
            }
            catch (Exception e) {}
        }
        return beanList;
    }

    private TmProappEnvBean makeTmProappEnvBean(TmTmsceneProapp tmTmsceneProapp) {
        if (null == tmTmsceneProapp) {
            return null;
        }
        TmProappEnvBean tmProappEnvBean = null;
        String json = tmTmsceneProapp.getTmsceneProappConf();
        if (StringUtils.isNotBlank((String)json)) {
            tmProappEnvBean = (TmProappEnvBean)JsonUtil.buildNormalBinder().getJsonToObject(json, TmProappEnvBean.class);
        }
        if (null == tmProappEnvBean) {
            tmProappEnvBean = new TmProappEnvBean();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmProappEnvBean, (Object)tmTmsceneProapp);
            return tmProappEnvBean;
        }
        catch (Exception e) {
            return tmProappEnvBean;
        }
    }

    static {
        lock = new Object();
    }
}

