/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTenantMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTenantSecondaryMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTenantDomain;
import com.yqbsoft.laser.service.tenantmanag.model.TmTenant;
import com.yqbsoft.laser.service.tenantmanag.service.TmProappService;
import com.yqbsoft.laser.service.tenantmanag.service.TmTenantService;
import com.yqbsoft.laser.service.tenantmanag.service.TmTmsceneService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class TmTenantServiceImpl
extends BaseServiceImpl
implements TmTenantService {
    public static final String SYS_CODE = "tm.TmTenantServiceImpl";
    private TmTenantMapper tmTenantMapper;
    private TmTenantSecondaryMapper tmTenantSecondaryMapper;
    private TmTmsceneService tmTmsceneService;
    private TmProappService tmProappService;

    public void setTmProappService(TmProappService tmProappService) {
        this.tmProappService = tmProappService;
    }

    public void setTmTmsceneService(TmTmsceneService tmTmsceneService) {
        this.tmTmsceneService = tmTmsceneService;
    }

    public void setTmTenantMapper(TmTenantMapper tmTenantMapper) {
        this.tmTenantMapper = tmTenantMapper;
    }

    public void setTmTenantSecondaryMapper(TmTenantSecondaryMapper tmTenantSecondaryMapper) {
        this.tmTenantSecondaryMapper = tmTenantSecondaryMapper;
    }

    private Date getSysDate() {
        try {
            return this.tmTenantMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTenant(TmTenantDomain tmTenantDomain) {
        if (null == tmTenantDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setTenantDefault(TmTenant tmTenant) {
        if (null == tmTenant) {
            return;
        }
        if (null == tmTenant.getDataState()) {
            tmTenant.setDataState(0);
        }
        if (null == tmTenant.getGmtCreate()) {
            tmTenant.setGmtCreate(this.getSysDate());
        }
        tmTenant.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmTenant.getTenantCode())) {
            tmTenant.setTenantCode(this.getNo(null, "TmTenant", "tenantCode", "00000000"));
        }
    }

    public int getTenantMaxCode() {
        int code = 0;
        try {
            return this.tmTenantMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.getTenantMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTenantUpdataDefault(TmTenant tmTenant) {
        if (null == tmTenant) {
            return;
        }
        tmTenant.setGmtModified(this.getSysDate());
    }

    private void saveTenantModel(TmTenant tmTenant) throws ApiException {
        if (null == tmTenant) {
            return;
        }
        try {
            this.tmTenantMapper.insert(tmTenant);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.saveTenantModel.ex", (Throwable)e);
        }
    }

    private TmTenant getTenantModelById(Integer tenantId) {
        if (null == tenantId) {
            return null;
        }
        try {
            return this.tmTenantMapper.selectByPrimaryKey(tenantId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.getTenantModelById", (Throwable)e);
            return null;
        }
    }

    public TmTenant getTenantModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmTenantMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.getTenantModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delTenantModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTenantMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.delTenantModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTenantServiceImpl.delTenantModelByCode.num");
        }
    }

    public void updatetenantModelOpuser(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTenantMapper.updatetenantOpuser(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.updatetenantModelOpuser.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTenantServiceImpl.updatetenantModelOpuser.num");
        }
    }

    private void deleteTenantModel(Integer tenantId) throws ApiException {
        if (null == tenantId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTenantMapper.deleteByPrimaryKey(tenantId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.deleteTenantModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTenantServiceImpl.deleteTenantModel.num");
        }
    }

    private void updateTenantModel(TmTenant tmTenant) throws ApiException {
        if (null == tmTenant) {
            return;
        }
        try {
            this.tmTenantMapper.updateByPrimaryKeySelective(tmTenant);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.updateTenantModel.ex", (Throwable)e);
        }
    }

    private void updateStateTenantModel(Integer tenantId, Integer dataState, Integer oldDataState) throws ApiException {
        int i;
        if (null == tenantId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", tenantId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            i = this.tmTenantMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantServiceImpl.updateStateTenantModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTenantServiceImpl.updateStateTenantModel.null");
        }
        TmTenant tmTenant = this.getTenant(tenantId);
        this.updateCache(tmTenant);
    }

    private TmTenant makeTenant(TmTenantDomain tmTenantDomain, TmTenant tmTenant) {
        if (null == tmTenantDomain) {
            return null;
        }
        if (null == tmTenant) {
            tmTenant = new TmTenant();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmTenant, (Object)tmTenantDomain);
            return tmTenant;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.makeTenant", (Throwable)e);
            return null;
        }
    }

    private List<TmTenant> queryTenantModelPage(Map<String, Object> parammap) {
        try {
            return this.tmTenantMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.queryTenantModel", (Throwable)e);
            return null;
        }
    }

    private List<TmTenant> queryTenantModelPageToTenantCodes(Map<String, Object> parammap) {
        try {
            return this.tmTenantMapper.queryToTenantCodes(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.queryTenantModelPageToTenantCodes", (Throwable)e);
            return null;
        }
    }

    private int countTenant(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmTenantMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.countTenant", (Throwable)e);
        }
        return i;
    }

    private int countTenants(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmTenantMapper.counts(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantServiceImpl.countTenants", (Throwable)e);
        }
        return i;
    }

    @Override
    public String sendSaveTenant(TmTenantDomain tmTenantDomain) throws ApiException {
        String code = this.saveTenant(tmTenantDomain);
        this.tmTmsceneService.loadDb();
        return code;
    }

    @Override
    public String saveTenant(TmTenantDomain tmTenantDomain) throws ApiException {
        String msg = this.checkTenant(tmTenantDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTenantServiceImpl.saveTenant.checkTenant", msg);
        }
        TmTenant tmTenant = this.makeTenant(tmTenantDomain, null);
        this.setTenantDefault(tmTenant);
        this.saveTenantModel(tmTenant);
        this.tmTmsceneService.saveTmsceneInit("init", tmTenant.getTenantCode());
        this.updateCache(tmTenant);
        return tmTenant.getTenantCode();
    }

    private void updateCache(TmTenant tmTenant) {
        if (null == tmTenant) {
            return;
        }
        DisUtil.setMap((String)"tmtenant-code", (String)tmTenant.getTenantCode(), (String)JsonUtil.buildNormalBinder().toJson((Object)tmTenant));
        if (StringUtils.isNotBlank((String)tmTenant.getTenantOpuser())) {
            DisUtil.setMap((String)"tmtenant-user-code", (String)tmTenant.getTenantCode(), (String)tmTenant.getTenantOpuser());
        }
        if (StringUtils.isNotBlank((String)tmTenant.getTenantMember())) {
            DisUtil.setMap((String)"tmtenant-mem-code", (String)tmTenant.getTenantMember(), (String)tmTenant.getTenantCode());
        }
        if (StringUtils.isNotBlank((String)tmTenant.getTenantDomain())) {
            DisUtil.setMap((String)"tmtenant-code_dmain", (String)(tmTenant.getTenantCode() + "-domain"), (String)tmTenant.getTenantDomain());
        }
        if (StringUtils.isNotBlank((String)tmTenant.getTenantMdomain())) {
            DisUtil.setMap((String)"tmtenant-code_dmain", (String)(tmTenant.getTenantCode() + "-domain0"), (String)tmTenant.getTenantMdomain());
        }
        if (StringUtils.isNotBlank((String)tmTenant.getTenantMdomain1())) {
            DisUtil.setMap((String)"tmtenant-code_dmain", (String)(tmTenant.getTenantCode() + "-domain1"), (String)tmTenant.getTenantMdomain1());
        }
        if (StringUtils.isNotBlank((String)tmTenant.getTenantMdomain2())) {
            DisUtil.setMap((String)"tmtenant-code_dmain", (String)(tmTenant.getTenantCode() + "-domain2"), (String)tmTenant.getTenantMdomain2());
        }
        this.tmProappService.queryProappEnvTenantLoadCache(tmTenant.getTenantCode());
    }

    @Override
    public void upadteTenantOpuser(String tenantOpuser, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantOpuser) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("tm.TmTenantServiceImpl.upadteTenantOpuser.checkTenant");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantOpuser", tenantOpuser);
        map.put("tenantCode", tenantCode);
        this.updatetenantModelOpuser(map);
        TmTenant tmTenant = this.getTenantModelByCode(map);
        this.updateCache(tmTenant);
    }

    @Override
    public void updateTenantState(Integer tenantId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTenantModel(tenantId, dataState, oldDataState);
        this.queryTenantCache();
        TmTenant tmTenant = this.getTenant(tenantId);
        try {
            this.tmTenantSecondaryMapper.updateStateBySecondaryTenantCode(tmTenant.getTenantCode(), dataState, oldDataState);
        }
        catch (Exception e) {
            this.logger.error("updateTenantState.updateStateBySecondaryTenantCode.ERROR", (Throwable)e);
            throw new ApiException("UPDATE.SECONDARY.ERROR", "update sencondary tenant fail", (Throwable)e);
        }
    }

    @Override
    public void upadteTenantStateByOpUser(String tenantOpUser, Integer dataSate, Integer oldDataState) throws ApiException {
        assert (StringUtils.isNotBlank((String)tenantOpUser));
        TmTenant tmTenantSearch = new TmTenant();
        tmTenantSearch.setTenantOpuser(tenantOpUser);
        TmTenant result = this.getTenantByUnique(tmTenantSearch);
        this.updateTenantState(result.getTenantId(), dataSate, oldDataState);
    }

    @Override
    public void updateTenant(TmTenantDomain tmTenantDomain) throws ApiException {
        String msg = this.checkTenant(tmTenantDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTenantServiceImpl.updateTenant.checkTenant", msg);
        }
        TmTenant oldTmTenant = this.getTenantModelById(tmTenantDomain.getTenantId());
        if (null == oldTmTenant) {
            throw new ApiException("tm.TmTenantServiceImpl.updateTenant.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmTenant tmTenant = this.makeTenant(tmTenantDomain, oldTmTenant);
        this.setTenantUpdataDefault(tmTenant);
        this.updateTenantModel(tmTenant);
        this.updateCache(tmTenant);
    }

    @Override
    public TmTenant getTenant(Integer tenantId) {
        return this.getTenantModelById(tenantId);
    }

    @Override
    public void deleteTenant(Integer tenantId) throws ApiException {
        this.deleteTenantModel(tenantId);
    }

    @Override
    public QueryResult<TmTenant> queryTenantPage(Map<String, Object> map) {
        List<TmTenant> tmTenantList = this.queryTenantModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTenant(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmTenantList);
        return queryResult;
    }

    @Override
    public QueryResult<TmTenant> queryToTenantCodes(Map<String, Object> map) {
        List<TmTenant> tmTenantList = this.queryTenantModelPageToTenantCodes(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTenants(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmTenantList);
        return queryResult;
    }

    @Override
    public TmTenant getTenantByCode(Map<String, Object> map) {
        return this.getTenantModelByCode(map);
    }

    @Override
    public void delTenantByCode(Map<String, Object> map) throws ApiException {
        this.delTenantModelByCode(map);
    }

    @Override
    public void queryTenantCache() {
        this.info("tm.TmTenantServiceImpl.queryTenantCache.start", "=======Tenant\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<TmTenant> tenantList = this.queryTenantModelPage(params);
        if (CollectionUtils.isEmpty(tenantList)) {
            DisUtil.delVer((String)"tmtenant-code");
            DisUtil.delVer((String)"tmtenant-user-code");
            this.info("tm.TmTenantServiceImpl.queryTenantCache.null", "=======Tenant\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> usermap = new HashMap<String, String>();
        for (TmTenant tmTenant : tenantList) {
            if (StringUtils.isNotBlank((String)tmTenant.getTenantOpuser())) {
                usermap.put(tmTenant.getTenantCode(), tmTenant.getTenantOpuser());
            }
            if (StringUtils.isNotBlank((String)tmTenant.getTenantMember())) {
                DisUtil.setMap((String)"tmtenant-mem-code", (String)tmTenant.getTenantMember(), (String)tmTenant.getTenantCode());
            }
            DisUtil.setMap((String)"tmtenant-code", (String)tmTenant.getTenantCode(), (String)JsonUtil.buildNormalBinder().toJson((Object)tmTenant));
            if (StringUtils.isNotBlank((String)tmTenant.getTenantDomain())) {
                DisUtil.setMap((String)"tmtenant-code_dmain", (String)(tmTenant.getTenantCode() + "-domain"), (String)tmTenant.getTenantDomain());
            }
            if (StringUtils.isNotBlank((String)tmTenant.getTenantMdomain())) {
                DisUtil.setMap((String)"tmtenant-code_dmain", (String)(tmTenant.getTenantCode() + "-domain0"), (String)tmTenant.getTenantMdomain());
            }
            if (StringUtils.isNotBlank((String)tmTenant.getTenantMdomain1())) {
                DisUtil.setMap((String)"tmtenant-code_dmain", (String)(tmTenant.getTenantCode() + "-domain1"), (String)tmTenant.getTenantMdomain1());
            }
            if (!StringUtils.isNotBlank((String)tmTenant.getTenantMdomain2())) continue;
            DisUtil.setMap((String)"tmtenant-code_dmain", (String)(tmTenant.getTenantCode() + "-domain2"), (String)tmTenant.getTenantMdomain2());
        }
        DisUtil.setMap((String)"tmtenant-user-code", usermap);
        this.info("tm.TmTenantServiceImpl.queryTenantCache.end", "=======Tenant\u8c03\u5ea6end=======");
    }

    @Override
    public TmTenant getTenantByUnique(TmTenant tmTenantSearch) {
        if (tmTenantSearch == null) {
            throw new ApiException("QUERY.PARAMS.NULL", "params can`t be null");
        }
        return this.tmTenantMapper.getTenantByUnique(tmTenantSearch);
    }
}

