/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ImpUserInfoBean;
import com.yqbsoft.laser.service.tool.util.User;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReaderUtils<T> {
    private static final String SERIALVERSIONUID = "serialVersionUID";

    public static <T> List<List<T>> parseExcelByStream(InputStream input, T clazz, Map<String, String> columnMap) {
        ArrayList<List<T>> lists = new ArrayList();
        Workbook workBook = null;
        Sheet sheet = null;
        lists = ExcelReaderUtils.readExcel(input, workBook, sheet, clazz, columnMap);
        return lists;
    }

    public static <T> List<List<T>> parseExcel(String path, T clazz, Map<String, String> columnMap) throws FileNotFoundException {
        ArrayList<List<T>> lists = new ArrayList();
        Workbook workBook = null;
        Sheet sheet = null;
        InputStream input = ExcelReaderUtils.pathToStream(path);
        lists = ExcelReaderUtils.readExcel(input, workBook, sheet, clazz, columnMap);
        return lists;
    }

    public static String getSheetsNameByPath(String path) throws InvalidFormatException, IOException {
        Workbook workBook = null;
        Sheet sheet = null;
        InputStream input = ExcelReaderUtils.pathToStream(path);
        String sheetsName = ExcelReaderUtils.readExcelRetSheetsName(input, workBook, sheet);
        return sheetsName;
    }

    public static String getSheetsNameByStream(InputStream input) throws InvalidFormatException, IOException {
        Workbook workBook = null;
        Sheet sheet = null;
        String sheetsName = ExcelReaderUtils.readExcelRetSheetsName(input, workBook, sheet);
        return sheetsName;
    }

    public static <T> void buildXSLXExcel(String exportFileName, String[] cellTitle, String[] sheetNames, List<T> list) {
        XSSFWorkbook workBook = null;
        try {
            workBook = new XSSFWorkbook();
            XSSFSheet sheet = workBook.createSheet();
            workBook.setSheetName(0, sheetNames[0]);
            XSSFFont font = workBook.createFont();
            font.setColor((short)Short.MAX_VALUE);
            font.setBoldweight((short)700);
            XSSFCellStyle cellStyle = workBook.createCellStyle();
            cellStyle.setFont((Font)font);
            cellStyle.setAlignment((short)2);
            cellStyle.setVerticalAlignment((short)1);
            XSSFRow titleRow = sheet.createRow(0);
            int size = cellTitle.length;
            for (int i = 0; i < size; ++i) {
                sheet.setColumnWidth(i, 3000);
                XSSFCell cell = titleRow.createCell(i, 0);
                cell.setCellStyle((CellStyle)cellStyle);
                cell.setCellType(1);
                cell.setCellValue(cellTitle[i]);
            }
            if (list != null && !list.isEmpty()) {
                XSSFCellStyle style = workBook.createCellStyle();
                int size2 = list.size();
                for (int i = 0; i < size2; ++i) {
                    T t = list.get(i);
                    Field[] fields = t.getClass().getDeclaredFields();
                    if (fields.length != cellTitle.length) {
                        return;
                    }
                    XSSFRow row = sheet.createRow((short)i + 1);
                    int length = cellTitle.length;
                    for (int j = 0; j < length; ++j) {
                        XSSFCell cell = row.createCell(j, 0);
                        cell.setCellType(1);
                        Field field = fields[j];
                        field.setAccessible(true);
                        PropertyDescriptor pd = new PropertyDescriptor(field.getName(), t.getClass());
                        Method getMethod = pd.getReadMethod();
                        cell.setCellValue((String)getMethod.invoke(t, new Object[0]));
                        style.setAlignment((short)2);
                        cell.setCellStyle((CellStyle)style);
                    }
                }
            }
            File file = new File(exportFileName);
            FileOutputStream outStream = new FileOutputStream(file);
            workBook.write((OutputStream)outStream);
            outStream.flush();
            outStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> void buildXSLXExcelByModelStream(String modelExcelPath, String exportFilePathName, String[] sheetNames, List<List<T>> list, Map<String, String> columnMap) {
        XSSFWorkbook workBook = null;
        try {
            InputStream pathToStream = ExcelReaderUtils.pathToStream(modelExcelPath);
            workBook = new XSSFWorkbook(pathToStream);
            if (workBook != null) {
                XSSFSheet sheet = null;
                int numberSheet = workBook.getNumberOfSheets();
                if (numberSheet > 0) {
                    sheet = workBook.getSheetAt(0);
                    int rowCount = sheet.getPhysicalNumberOfRows();
                    if (rowCount > 1 && list != null && !list.isEmpty()) {
                        XSSFCellStyle style = workBook.createCellStyle();
                        List<T> list2 = list.get(0);
                        int size = list2.size();
                        for (int i = 0; i < size; ++i) {
                            XSSFRow row = sheet.createRow((short)rowCount + i);
                            T t = list2.get(i);
                            for (Map.Entry<String, String> columnEntry : columnMap.entrySet()) {
                                Field[] fields;
                                for (Field field : fields = t.getClass().getDeclaredFields()) {
                                    if (!columnEntry.getKey().equals(field.getName())) continue;
                                    XSSFCell cell = row.createCell(Integer.valueOf(columnEntry.getValue()).intValue());
                                    cell.setCellType(1);
                                    field.setAccessible(true);
                                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), t.getClass());
                                    Method getMethod = pd.getReadMethod();
                                    cell.setCellValue((String)getMethod.invoke(t, new Object[0]));
                                    style.setAlignment((short)2);
                                    cell.setCellStyle((CellStyle)style);
                                }
                            }
                        }
                    }
                } else {
                    System.out.println("\u6a21\u677f\u8868\u683c\u5de5\u4f5c\u7c3f(Sheet)\u6570\u76ee\u4e3a0\uff01");
                }
                File file = new File(exportFilePathName);
                FileOutputStream outStream = new FileOutputStream(file);
                workBook.write((OutputStream)outStream);
                outStream.flush();
                outStream.close();
            }
        }
        catch (IntrospectionException | IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static InputStream pathToStream(String path) throws FileNotFoundException {
        FileInputStream input = null;
        File file = null;
        String suffix = path.substring(path.lastIndexOf("."), path.length());
        if (".xls".equals(suffix) || ".xlsx".equals(suffix)) {
            file = new File(path);
            try {
                input = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("\u672a\u627e\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
            }
            catch (Exception e) {
                throw new FileNotFoundException("\u8bfb\u53d6Excel\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff01");
            }
            return input;
        }
        throw new FileNotFoundException("\u975e\u6cd5\u7684Excel\u6587\u4ef6\u540e\u7f00\uff01");
    }

    private static String readExcelRetSheetsName(InputStream input, Workbook workBook, Sheet sheet) throws IOException, InvalidFormatException {
        StringBuffer sb = new StringBuffer();
        if (!input.markSupported()) {
            input = new PushbackInputStream(input, 8);
        }
        try {
            if (!POIFSFileSystem.hasPOIFSHeader((InputStream)input) && !POIXMLDocument.hasOOXMLHeader((InputStream)input)) {
                throw new InvalidFormatException("\u975e\u6cd5\u7684\u8f93\u5165\u6d41\uff1a\u5f53\u524d\u8f93\u5165\u6d41\u975eOLE2\u6d41\u6216OOXML\u6d41\uff01");
            }
            workBook = WorkbookFactory.create((InputStream)input);
        }
        catch (IOException e) {
            throw new IOException("\u521b\u5efa\u8868\u683c\u5de5\u4f5c\u7c3f\u5bf9\u8c61\u53d1\u751fIO\u5f02\u5e38\uff01\u539f\u56e0\uff1a" + e.getMessage());
        }
        catch (InvalidFormatException e) {
            throw new InvalidFormatException("\u975e\u6cd5\u7684\u8f93\u5165\u6d41\uff1a\u5f53\u524d\u8f93\u5165\u6d41\u975eOLE2\u6d41\u6216OOXML\u6d41\uff01");
        }
        try {
            int numberSheet;
            if (workBook != null && (numberSheet = workBook.getNumberOfSheets()) > 0) {
                String sheetName = "";
                for (int i = 0; i < numberSheet; ++i) {
                    sheet = workBook.getSheetAt(i);
                    sheetName = sheet.getSheetName();
                    sb.append(sheetName + "|");
                }
            }
            input.close();
        }
        catch (IOException e) {
            throw new IOException("\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38\uff01" + e.getMessage());
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    private static <T> List<List<T>> readExcel(InputStream input, Workbook workBook, Sheet sheet, T clazz, Map<String, String> columnMap) {
        ArrayList<List<T>> lists = new ArrayList<List<T>>();
        if (!input.markSupported()) {
            input = new PushbackInputStream(input, 8);
        }
        try {
            if (POIFSFileSystem.hasPOIFSHeader((InputStream)input) || POIXMLDocument.hasOOXMLHeader((InputStream)input)) {
                workBook = WorkbookFactory.create((InputStream)input);
            } else {
                System.out.println("\u975e\u6cd5\u7684\u8f93\u5165\u6d41\uff1a\u5f53\u524d\u8f93\u5165\u6d41\u975eOLE2\u6d41\u6216OOXML\u6d41\uff01");
            }
        }
        catch (IOException e) {
            System.out.println("\u521b\u5efa\u8868\u683c\u5de5\u4f5c\u7c3f\u5bf9\u8c61\u53d1\u751fIO\u5f02\u5e38\uff01\u539f\u56e0\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        catch (InvalidFormatException e) {
            System.out.println("\u975e\u6cd5\u7684\u8f93\u5165\u6d41\uff1a\u5f53\u524d\u8f93\u5165\u6d41\u975eOLE2\u6d41\u6216OOXML\u6d41\uff01");
            e.printStackTrace();
        }
        try {
            if (workBook != null) {
                int numberSheet = workBook.getNumberOfSheets();
                if (numberSheet > 0) {
                    for (int i = 0; i < numberSheet; ++i) {
                        List<Object> list = new ArrayList();
                        sheet = workBook.getSheetAt(i);
                        list = ExcelReaderUtils.getExcelContent(sheet, clazz, columnMap);
                        lists.add(list);
                    }
                } else {
                    System.out.println("\u76ee\u6807\u8868\u683c\u5de5\u4f5c\u7c3f(Sheet)\u6570\u76ee\u4e3a0\uff01");
                }
            }
            input.close();
        }
        catch (IOException e) {
            System.out.println("\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38\uff01" + e.getMessage());
            e.printStackTrace();
        }
        return lists;
    }

    /*
     * Unable to fully structure code
     */
    private static <T> List<T> getExcelContent_new(Sheet sheet, T t, String[] titles) {
        block14: {
            list = new ArrayList<?>();
            try {
                rowCount = sheet.getPhysicalNumberOfRows();
                if (rowCount <= 1) break block14;
                titleRow = sheet.getRow(0);
                for (i = 1; i < rowCount; ++i) {
                    clazz = t.getClass().newInstance();
                    row = sheet.getRow(i);
                    if (row == null) continue;
                    fields = clazz.getClass().getDeclaredFields();
                    for (j = 0; j < fields.length; ++j) {
                        block15: {
                            field = fields[j];
                            cell = row.getCell(j);
                            field.setAccessible(true);
                            if ("serialVersionUID".equals(field.getName())) continue;
                            pd = new PropertyDescriptor(field.getName(), clazz.getClass());
                            getMethod = pd.getWriteMethod();
                            var = "";
                            if (row.getCell(j) == null) continue;
                            if (titleRow.getCell(j).getStringCellValue().trim().indexOf(titles[j]) < 0) break block15;
                            if (cell == null) ** GOTO lbl-1000
                            if (cell.getCellType() == 1) {
                                var = cell.getStringCellValue().trim();
                            } else if (cell != null) {
                                if (cell.getCellType() == 0) {
                                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                        sdf = null;
                                        sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd");
                                        date = cell.getDateCellValue();
                                        var = sdf.format(date);
                                    } else if (cell.getCellStyle().getDataFormat() == 58) {
                                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                                        value = cell.getNumericCellValue();
                                        date = DateUtil.getJavaDate((double)value);
                                        var = sdf.format(date);
                                    } else {
                                        value = cell.getNumericCellValue();
                                        style = cell.getCellStyle();
                                        format = new DecimalFormat();
                                        temp = style.getDataFormatString();
                                        if (temp.equals("General")) {
                                            format.applyPattern("#");
                                            var = format.format(value);
                                        } else {
                                            var = String.valueOf(cell.getNumericCellValue());
                                        }
                                    }
                                }
                            }
                            getMethod.invoke(clazz, new Object[]{var});
                            continue;
                        }
                        throw new Exception("\u6807\u9898\u884c\u4e2d\u7684\u6807\u9898\u4e0e\u5b9a\u4e49\u7684\u6807\u9898\u4e0d\u5339\u914d");
                    }
                    list.add(clazz);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private static <T> List<T> getExcelContent(Sheet sheet, T t, Map<String, String> columnMap) {
        ArrayList list = new ArrayList();
        try {
            int rowCount = sheet.getPhysicalNumberOfRows();
            if (rowCount > 1) {
                Row titleRow = sheet.getRow(0);
                for (int i = 1; i < rowCount; ++i) {
                    Object clazz = ((Class)t).newInstance();
                    Row row = sheet.getRow(i);
                    if (row == null) continue;
                    for (Map.Entry<String, String> columnEntry : columnMap.entrySet()) {
                        Field[] fields = clazz.getClass().getDeclaredFields();
                        block4: for (int j = 0; j < fields.length; ++j) {
                            Field field = fields[j];
                            if (!columnEntry.getKey().equals(field.getName())) continue;
                            Iterator titleCells = titleRow.cellIterator();
                            int w = -1;
                            while (titleCells.hasNext()) {
                                ++w;
                                Cell c = (Cell)titleCells.next();
                                if (!c.getStringCellValue().equals(columnEntry.getValue())) continue;
                                Cell cell = row.getCell(w);
                                field.setAccessible(true);
                                String var = "";
                                if (cell != null) {
                                    if (cell.getCellType() == 1) {
                                        var = cell.getStringCellValue().trim();
                                        BeanUtils.setObjValue(clazz, field.getName(), var);
                                        continue block4;
                                    }
                                }
                                if (cell == null) continue block4;
                                if (cell.getCellType() != 0) continue block4;
                                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                    SimpleDateFormat sdf = null;
                                    sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd");
                                    var = sdf.format(cell.getDateCellValue());
                                    BeanUtils.setObjValue(clazz, field.getName(), var);
                                    continue block4;
                                }
                                if (cell.getCellStyle().getDataFormat() == 58) {
                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                    double value = cell.getNumericCellValue();
                                    Date date = DateUtil.getJavaDate((double)value);
                                    var = sdf.format(date);
                                    BeanUtils.setObjValue(clazz, field.getName(), var);
                                    continue block4;
                                }
                                double value = cell.getNumericCellValue();
                                CellStyle style = cell.getCellStyle();
                                DecimalFormat format = new DecimalFormat();
                                String temp = style.getDataFormatString();
                                if (temp.equals("General")) {
                                    format.applyPattern("#");
                                    var = format.format(value);
                                    BeanUtils.setObjValue(clazz, field.getName(), var);
                                    continue block4;
                                }
                                format.applyPattern("#.##");
                                var = String.valueOf(cell.getNumericCellValue());
                                BeanUtils.setObjValue(clazz, field.getName(), format.format(value));
                                continue block4;
                            }
                        }
                    }
                    list.add(clazz);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void main(String[] args) {
        ExcelReaderUtils.outTest();
        ExcelReaderUtils.impTest();
    }

    public static void outTest() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss");
        String now = format.format(new Date());
        String exportFileName = "D:\\\u4eba\u5458\u4fe1\u606f\u5bfc\u51fa2007_" + now + ".xlsx";
        String title = "\u59d3\u540d|\u6027\u522b|\u5e74\u9f84";
        String[] sheetNames = new String[]{"\u4eba\u5458\u4fe1\u606f"};
        String[] cellTitle = title.split("\\|");
        HashMap<String, String> columnMap = new HashMap<String, String>();
        try {
            List<List<User>> list = ExcelReaderUtils.parseExcel("D:\\cc.xlsx", new User(), columnMap);
            ExcelReaderUtils.buildXSLXExcel(exportFileName, cellTitle, sheetNames, list);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void impTest() {
        String path2007 = "D:\\userInfo.xlsx";
        long start2007 = System.currentTimeMillis();
        System.out.println("Excel\u6587\u4ef6\u8def\u5f84\uff1a" + path2007);
        HashMap<String, String> columnMap = new HashMap<String, String>();
        try {
            List<List<ImpUserInfoBean>> lists = ExcelReaderUtils.parseExcel(path2007, new ImpUserInfoBean(), columnMap);
            List<ImpUserInfoBean> list2007 = lists.get(0);
            System.out.println("\u89e3\u67902007\u8f93\u51fa\u603b\u4eba\u6570\uff1a" + list2007.size());
            long end2007 = System.currentTimeMillis();
            System.out.println("\u89e3\u6790Excel\u5b8c\u6bd5\uff01\u5171\u7528\u65f6" + (end2007 - start2007) + "\u6beb\u79d2\uff01");
            for (ImpUserInfoBean user : list2007) {
                System.out.println(user.toString());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

