/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

public class FileUtil {
    private static final int BUFFER_SIZE = 16384;

    public static InputStream getStringStream(String sInputString) {
        ByteArrayInputStream tInputStringStream = null;
        if (sInputString != null && !sInputString.trim().equals("")) {
            tInputStringStream = new ByteArrayInputStream(sInputString.getBytes());
        }
        return tInputStringStream;
    }

    public static void doTxtFile(String targetDir, String fileName, String content, String encoding) {
        try {
            FileUtil.makeMoreDir(targetDir);
            File file = new File("");
            file = new File(targetDir + fileName);
            if (file.exists()) {
                file.delete();
            }
            FileUtil.writeFile(file, content, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dst) {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(src), 16384);
            out = new BufferedOutputStream(new FileOutputStream(dst), 16384);
            byte[] buffer = new byte[16384];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeFile(File file, String content, String encoding, boolean append) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        if (StringUtils.isBlank(encoding)) {
            encoding = "UTF-8";
        }
        try {
            fos = new FileOutputStream(file, append);
            osw = new OutputStreamWriter((OutputStream)fos, encoding);
            osw.write(content);
            osw.flush();
            int n = 1;
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            try {
                osw.close();
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static int writeFile(File file, String content, String encoding) {
        return FileUtil.writeFile(file, content, encoding, false);
    }

    public static Image readImage(File file, String encoding) {
        BufferedImage src = null;
        try {
            src = ImageIO.read(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return src;
    }

    public static int getTxtFileNum(String filePathName, String encoding) {
        if (StringUtils.isBlank(encoding)) {
            encoding = "UTF-8";
        }
        int iFileSize = 0;
        String s = null;
        File file = new File(filePathName);
        try {
            if (file.exists()) {
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                BufferedReader br = new BufferedReader(read);
                while ((s = br.readLine()) != null && !"".equals(s)) {
                    ++iFileSize;
                }
                br.close();
                read.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iFileSize;
    }

    public static String getTxtFileContent(String filePathName, String encoding) {
        String strContent = "";
        File file = new File(filePathName);
        strContent = FileUtil.readFile(file, encoding);
        return strContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String encoding) {
        if (StringUtils.isBlank(encoding)) {
            encoding = "UTF-8";
        }
        String strContent = "";
        String s = null;
        if (file.exists()) {
            InputStreamReader read = null;
            BufferedReader br = null;
            try {
                read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                br = new BufferedReader(read);
                while ((s = br.readLine()) != null) {
                    strContent = strContent + s + "\n";
                }
            }
            catch (Exception e) {
                String string = strContent;
                return string;
            }
            finally {
                try {
                    read.close();
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return strContent;
    }

    public static void delFile(String filePathName) {
        File file = new File(filePathName);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void allDelete(String filePath) {
        try {
            File f = new File(filePath);
            if (f.exists() && f.isDirectory()) {
                if (f.listFiles().length == 0) {
                    f.delete();
                } else {
                    File[] delFile = f.listFiles();
                    int i = f.listFiles().length;
                    for (int j = 0; j < i; ++j) {
                        if (delFile[j].isDirectory()) {
                            FileUtil.allDelete(delFile[j].getAbsolutePath());
                        }
                        delFile[j].delete();
                    }
                }
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List getSubFilesName(String baseDir) {
        File f = new File(baseDir);
        return FileUtil.getSubFilesName(f);
    }

    public static List getSubFilesName(File baseDir) {
        try {
            ArrayList<String> ret = new ArrayList<String>();
            File[] tmp = baseDir.listFiles();
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i].isFile()) {
                    ret.add(tmp[i].getName());
                }
                if (!tmp[i].isDirectory()) continue;
                ret.addAll(FileUtil.getSubFilesName(tmp[i]));
            }
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List getSubFiles(File baseDir) {
        try {
            ArrayList<File> ret = new ArrayList<File>();
            File[] tmp = baseDir.listFiles();
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i].isFile()) {
                    ret.add(tmp[i]);
                }
                if (!tmp[i].isDirectory()) continue;
                ret.addAll(FileUtil.getSubFiles(tmp[i]));
            }
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void copyFile(File file, File targetFile, String targetEncoding, String encoding) {
        targetFile.delete();
        FileUtil.createFile(targetFile, true);
        String exStr = targetFile.getAbsolutePath().substring(targetFile.getAbsolutePath().lastIndexOf(".") + 1);
        if (exStr.equals("jpg") || exStr.equals("png") || exStr.equals("gif") || exStr.equals("bmp") || exStr.equals("jpeg")) {
            FileUtil.upLoadPicFile(file, targetFile, 1024);
        } else {
            FileUtil.copy(file, targetFile);
        }
    }

    public static void copyFile(String filepath, String targetfilepath, String targetEncoding, String encoding) {
        FileUtil.copyFile(new File(filepath), new File(targetfilepath), targetEncoding, encoding);
    }

    public static void copy(File source, File target, String encoding, String targetEncoding) {
        File tarpath = new File(target, source.getName());
        if (tarpath.exists()) {
            tarpath.delete();
        }
        if (source.isDirectory()) {
            tarpath.mkdir();
            File[] dir = source.listFiles();
            for (int i = 0; i < dir.length; ++i) {
                FileUtil.copy(dir[i], tarpath, encoding, targetEncoding);
            }
        } else {
            FileUtil.copyFile(source, target, encoding, targetEncoding);
        }
    }

    public static void makeMoreDir(String path) {
        String path1;
        StringTokenizer st = new StringTokenizer(path, System.getProperties().getProperty("file.separator"));
        String path2 = path1 = st.nextToken() + System.getProperties().getProperty("file.separator");
        while (st.hasMoreTokens()) {
            path1 = st.nextToken() + System.getProperties().getProperty("file.separator");
            File inbox = new File(path2 = path2 + path1);
            if (inbox.exists()) continue;
            inbox.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upLoadPicFile(File src, File dst, int buffer_size) {
        try {
            InputStream in = null;
            OutputStream out = null;
            try {
                in = new BufferedInputStream(new FileInputStream(src), buffer_size);
                out = new BufferedOutputStream(new FileOutputStream(dst), buffer_size);
                byte[] buffer = new byte[buffer_size];
                while (in.read(buffer) > 0) {
                    out.write(buffer);
                }
            }
            finally {
                if (null != in) {
                    in.close();
                }
                if (null != out) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upLoadPicFileByStream(InputStream in, File dst, int buffer_size) {
        try {
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(dst), buffer_size);
                byte[] buffer = new byte[buffer_size];
                while (in.read(buffer) > 0) {
                    ((OutputStream)out).write(buffer);
                }
            }
            finally {
                if (null != in) {
                    in.close();
                }
                if (null != out) {
                    ((OutputStream)out).close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upLoadPicFile(File src, String dstpath, int buffer_size) {
        FileUtil.makeMoreDir(dstpath);
        File dst = new File(dstpath);
        try {
            InputStream in = null;
            OutputStream out = null;
            try {
                in = new BufferedInputStream(new FileInputStream(src), buffer_size);
                out = new BufferedOutputStream(new FileOutputStream(dst), buffer_size);
                byte[] buffer = new byte[buffer_size];
                while (in.read(buffer) > 0) {
                    out.write(buffer);
                }
            }
            finally {
                if (null != in) {
                    in.close();
                }
                if (null != out) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] listFile(File dir) {
        String absolutPath = dir.getAbsolutePath();
        String[] paths = dir.list();
        String[] files = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = absolutPath + System.getProperties().getProperty("file.separator") + paths[i];
        }
        return files;
    }

    public static void createFile(String path, boolean isFile) {
        FileUtil.createFile(new File(path), isFile);
    }

    public static void createFile(File file, boolean isFile) {
        if (!file.exists()) {
            FileUtil.makeDir(file.getParentFile());
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void makeDir(File dir) {
        if (!dir.getParentFile().exists()) {
            FileUtil.makeDir(dir.getParentFile());
        }
        dir.mkdir();
    }

    public static boolean DeleteFolder(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (!file.exists()) {
            return flag;
        }
        if (file.isFile()) {
            return FileUtil.deleteFile(sPath);
        }
        return FileUtil.deleteDirectory(sPath);
    }

    public static boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public static boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileUtil.deleteFile(files[i].getAbsolutePath())) : !(flag = FileUtil.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static String getFileName(String path) {
        String name = "";
        if (StringUtils.isNotBlank(path)) {
            String[] str = path.split("\\\\");
            if (null == str || str.length == 0) {
                str = path.split("/");
            }
            if (null != str && str.length != 0) {
                str = str[str.length - 1].split("/");
                name = str[str.length - 1];
            } else {
                name = path;
            }
        }
        return name;
    }

    public static InputStream getFile(String path) {
        FileInputStream inStream = null;
        try {
            int fileLength;
            File file = new File(path);
            if (file.exists() && (fileLength = (int)file.length()) != 0) {
                inStream = new FileInputStream(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inStream;
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.getAppPath(DateUtil.class));
    }

    public static String getAppPath(Class<?> cls) {
        URL url;
        String realPath;
        int pos;
        if (cls == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ClassLoader loader = cls.getClassLoader();
        String clsName = cls.getName() + ".class";
        Package pack = cls.getPackage();
        String path = "";
        if (pack != null) {
            String packName = pack.getName();
            if (packName.startsWith("java.") || packName.startsWith("javax.")) {
                throw new IllegalArgumentException("\u4e0d\u8981\u4f20\u9001\u7cfb\u7edf\u7c7b\uff01");
            }
            clsName = clsName.substring(packName.length() + 1);
            if (packName.indexOf(".") < 0) {
                path = packName + "/";
            } else {
                int start = 0;
                int end = 0;
                end = packName.indexOf(".");
                while (end != -1) {
                    path = path + packName.substring(start, end) + "/";
                    start = end + 1;
                    end = packName.indexOf(".", start);
                }
                path = path + packName.substring(start) + "/";
            }
        }
        if ((pos = (realPath = (url = loader.getResource(path + clsName)).getPath()).indexOf("file:")) > -1) {
            realPath = realPath.substring(pos + 5);
        }
        if ((realPath = realPath.substring(0, (pos = realPath.indexOf(path + clsName)) - 1)).endsWith("!")) {
            realPath = realPath.substring(0, realPath.lastIndexOf("/"));
        }
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println(realPath);
        return realPath;
    }

    public static String jointPathAndName(String filePath, String fileName) {
        if (!filePath.endsWith("/")) {
            filePath = filePath + "/";
        }
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        filePath = filePath + fileName;
        return filePath;
    }
}

