/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class JsonUtil {
    private static JsonUtil allJsonUtil;
    private static JsonUtil notNullJsonUtil;
    private static JsonUtil notDefJsonUtil;
    private static JsonUtil notEmpJsonUtil;
    private ObjectMapper mapper = new ObjectMapper();

    public static JsonUtil getAllJsonUtil() {
        return allJsonUtil;
    }

    public static void setAllJsonUtil(JsonUtil allJsonUtil) {
        JsonUtil.allJsonUtil = allJsonUtil;
    }

    public static JsonUtil getNotNullJsonUtil() {
        return notNullJsonUtil;
    }

    public static void setNotNullJsonUtil(JsonUtil notNullJsonUtil) {
        JsonUtil.notNullJsonUtil = notNullJsonUtil;
    }

    public static JsonUtil getNotDefJsonUtil() {
        return notDefJsonUtil;
    }

    public static void setNotDefJsonUtil(JsonUtil notDefJsonUtil) {
        JsonUtil.notDefJsonUtil = notDefJsonUtil;
    }

    public static JsonUtil getNotEmpJsonUtil() {
        return notEmpJsonUtil;
    }

    public static void setNotEmpJsonUtil(JsonUtil notEmpJsonUtil) {
        JsonUtil.notEmpJsonUtil = notEmpJsonUtil;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public JsonUtil(JsonInclude.Include include) {
        this.mapper.setSerializationInclusion(include);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
        switch (include) {
            case NON_NULL: 
            case NON_EMPTY: {
                this.mapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
            }
        }
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Date.class, new CustomDateDeserializer());
        this.mapper.registerModule((Module)module);
        this.setDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonUtil buildNormalBinder() {
        Class<JsonUtil> clazz = JsonUtil.class;
        synchronized (JsonUtil.class) {
            if (allJsonUtil == null) {
                allJsonUtil = new JsonUtil(JsonInclude.Include.ALWAYS);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return allJsonUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonUtil buildNonNullBinder() {
        Class<JsonUtil> clazz = JsonUtil.class;
        synchronized (JsonUtil.class) {
            if (notNullJsonUtil == null) {
                notNullJsonUtil = new JsonUtil(JsonInclude.Include.NON_NULL);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return notNullJsonUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonUtil buildNonDefaultBinder() {
        Class<JsonUtil> clazz = JsonUtil.class;
        synchronized (JsonUtil.class) {
            if (notDefJsonUtil == null) {
                notDefJsonUtil = new JsonUtil(JsonInclude.Include.NON_DEFAULT);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return notDefJsonUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonUtil buildNonEmptyBinder() {
        Class<JsonUtil> clazz = JsonUtil.class;
        synchronized (JsonUtil.class) {
            if (notEmpJsonUtil == null) {
                notEmpJsonUtil = new JsonUtil(JsonInclude.Include.NON_EMPTY);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return notEmpJsonUtil;
        }
    }

    public <T> T getJsonToObject(String json, Class<T> clazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)object;
    }

    public Object getJsonToList(String json, Class clazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructCollectionType(ArrayList.class, clazz));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public <T, P extends List<T>> List<T> getList(String json, Class<P> collectionType, Class<T> clazz) {
        if (StringUtils.isBlank(json)) {
            return Collections.emptyList();
        }
        try {
            return (List)this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructCollectionType(collectionType, clazz));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public Object getJsonToListByMap(String json, Class clazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructArrayType((JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, clazz)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object[] getJsonToArray(String json, Class clazz) {
        Object[] object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = (Object[])this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructArrayType(clazz));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public byte[] getJsonTobyteArray(String json) {
        byte[] object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = (byte[])this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructArrayType(Byte.TYPE));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToMap(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(HashMap.class, new Class[]{keyclazz, valueclazz}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToLinkedMap(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(LinkedHashMap.class, new Class[]{keyclazz, valueclazz}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToConcMap(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(ConcurrentHashMap.class, new Class[]{keyclazz, valueclazz}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToMapByMap(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, TypeFactory.defaultInstance().uncheckedSimpleType(keyclazz), (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, valueclazz)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToMapByList(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, TypeFactory.defaultInstance().uncheckedSimpleType(keyclazz), (JavaType)TypeFactory.defaultInstance().constructCollectionType(ArrayList.class, valueclazz)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public static Map<String, String> getJsonToMap(String str) {
        String[] s;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank(str) && (s = str.split(",")).length > 0) {
            for (int i = 0; i < s.length; ++i) {
                String con = s[i];
                int s1 = con.indexOf(":");
                if (s1 > 0) {
                    map.put(con.substring(0, s1).trim().replace("\"", ""), con.substring(s1 + 1).replace("\"", ""));
                    continue;
                }
                map.put(con.trim().replace("\"", ""), "");
            }
        }
        return map;
    }

    public String getMapToJson(Map<String, String> map) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (null != map && !map.isEmpty()) {
            for (String key : map.keySet()) {
                String[] strS = new String[]{key, map.get(key)};
                list.add(strS);
            }
        }
        return this.jsonObject(list);
    }

    public String jsonObject(List list) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator gen = new JsonFactory().createGenerator((Writer)sw);
            this.getMapper().writeValue(gen, (Object)list);
            gen.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return sw.toString();
    }

    public Object getJsonToObject(String json, Class objclazz, Class ... pclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(objclazz, pclazz));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return object;
    }

    public <T> Object getJsonToObject(String json, TypeReference<T> typeReference) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, typeReference);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public String toJson(Object object) {
        String json = null;
        try {
            json = this.getMapper().writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public void setDateFormat(String pattern) {
        if (StringUtils.isNotBlank(pattern)) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            this.getMapper().setDateFormat((DateFormat)df);
            this.getMapper().setTimeZone(TimeZone.getDefault());
        }
    }

    public static Object getResultObject(String json) {
        return json;
    }

    public static void main(String[] args) {
        String da = "{\"username\":\"\u4e0a\u6d77\u6709\u8272\u7f51\u667a\u91c7\",\"host\":\"https://open-oauth.jd.com\",\"ophost\":\"https://api.jd.com/routerjson\",\"secret\":\"40f6b68097b24e0ba1ad3b62dc69b831\",\"rsa_public\":\"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQChmUBKeOFKk5POC2KzqiPzS/oZnDqy98X/TOLabLvPoa9QRVE8Y7peRt9HvY36v8sHwD9TjzWY//1FNBXLr4Pa6H8bZi/VKw9uSg/W2dNyWpheHSiG97jEi9M1BPH/TNU7Uo8vkMveYc9yKgW8oaPeaRjHeIm0hwVW0OD6YUGxFwIDAQAB\",\"password\":\"*8888888Z\",\"key\":\"F203DCB9B45FC527B0146BF93509F032\",\"rsa_key\":\"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAKGZQEp44UqTk84LYrOqI/NL+hmcOrL3xf9M4tpsu8+hr1BFUTxjul5G30e9jfq/ywfAP1OPNZj//UU0Fcuvg9rofxtmL9UrD25KD9bZ03JamF4dKIb3uMSL0zUE8f9M1TtSjy+Qy95hz3IqBbyho95pGMd4ibSHBVbQ4PphQbEXAgMBAAECgYBdyGTJU5HcB/2VbIIhprIqdoN07XgbeTRNT7+v576vZzQpL7FPjMkSAat/JQEK7tfTbbzSr5/5ZUcFLI8hoICyTuDX8zpsL4bGL8EqcHEZFzke3IGtqWTDenskGQp+2FZZ0cUzmJ8nhWFjb7c2IZBpgZ2G6vN9BB0M4a03i849gQJBAPzLQfumwBY0NpVgA6//c9vgUPt+jHZi2R/RyHqiLDzxsaAKb7wfn84CQ/vlUC2OheCQFCpVi+9MwVs0rFd+kyECQQCjpekxVZ9Yp/iYFc8WT9S1OUTdfZgpJUNs++2AZmnyrraeNiatymJT7u/KoJfLch3Cd0cHwZmo3ucE0s9zknU3AkEAowoEuGVHpgpu2dBfEHfVJY57LHjl5sTB/H+0qUNG/Nd1FB8nCVHsI1Xauu+e0oMFXVwPZW5fHiuG2WgTbyq3gQJADaJA709G20gDOgh3HFDCU+bVie5wwtzL5USH4O6nXQSZSk0Qo+H8lymM6MDAZL65I/5z+H10o9EORiSaC/LjuQJAda31QduQFM1jOdyMNamA43VpXOHHFdefjvsaIlR6RcSu1GYuvHmeN3PFxhuu4US2sgnbPibfqAPJBwfmbh5GTA==\"}";
        Map obj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(da, String.class, String.class);
        System.out.println(obj);
    }

    public class CustomDateDeserializer<Date>
    extends DateDeserializers.DateDeserializer {
        private static final long serialVersionUID = -3912203293075877780L;

        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                return super.deserialize(jp, ctxt);
            }
            catch (JsonMappingException e) {
                return this.retryParse(jp.getText());
            }
        }

        private Date retryParse(String dateStr) {
            if (StringUtils.isBlank(dateStr)) {
                return null;
            }
            try {
                if (dateStr.length() == "yyyy-MM-dd".length()) {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(dateStr);
                }
                if (dateStr.length() == "yyyyMMdd".length()) {
                    return new SimpleDateFormat("yyyyMMdd").parse(dateStr);
                }
                if (dateStr.length() == "yyyyMMddHHmmss".length()) {
                    return new SimpleDateFormat("yyyyMMddHHmmss").parse(dateStr);
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }
    }
}

