/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ul.dao.UlLevelListconfMapper;
import com.yqbsoft.laser.service.ul.domain.UlLevelListconfDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelListconfReDomain;
import com.yqbsoft.laser.service.ul.model.UlLevelListconf;
import com.yqbsoft.laser.service.ul.service.UlLevelListconfService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UlLevelListconfServiceImpl
extends BaseServiceImpl
implements UlLevelListconfService {
    private static final String SYS_CODE = "ul.UlLevelListconfServiceImpl";
    private UlLevelListconfMapper ulLevelListconfMapper;
    private String cachekey = "UlLevelListConft-type";

    public void setUlLevelListconfMapper(UlLevelListconfMapper ulLevelListconfMapper) {
        this.ulLevelListconfMapper = ulLevelListconfMapper;
    }

    private Date getSysDate() {
        try {
            return this.ulLevelListconfMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelListconfServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlLevelListconf(UlLevelListconfDomain ulLevelListconfDomain) {
        if (null == ulLevelListconfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelListconfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelListconfDefault(UlLevelListconf ulLevelListconf) {
        if (null == ulLevelListconf) {
            return;
        }
        if (null == ulLevelListconf.getDataState()) {
            ulLevelListconf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulLevelListconf.getGmtCreate()) {
            ulLevelListconf.setGmtCreate(date);
        }
        ulLevelListconf.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevelListconf.getLevelListconfCode())) {
            ulLevelListconf.setLevelListconfCode(this.getNo(null, "UlLevelListconf", "ulLevelListconf", ulLevelListconf.getTenantCode()));
        }
    }

    private int getUlLevelListconfMaxCode() {
        int code = 0;
        try {
            return this.ulLevelListconfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelListconfServiceImpl.getUlLevelListconfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelListconfUpdataDefault(UlLevelListconf ulLevelListconf) {
        if (null == ulLevelListconf) {
            return;
        }
        ulLevelListconf.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelListconfModel(UlLevelListconf ulLevelListconf) throws ApiException {
        if (null == ulLevelListconf) {
            return;
        }
        try {
            this.ulLevelListconfMapper.insert(ulLevelListconf);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.saveUlLevelListconfModel.ex", (Throwable)e);
        }
    }

    private void saveUlLevelListconfBatchModel(List<UlLevelListconf> ulLevelListconfList) throws ApiException {
        if (null == ulLevelListconfList || ulLevelListconfList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelListconfMapper.insertBatch(ulLevelListconfList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.saveUlLevelListconfBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevelListconf getUlLevelListconfModelById(Integer levelListconfId) {
        if (null == levelListconfId) {
            return null;
        }
        try {
            return this.ulLevelListconfMapper.selectByPrimaryKey(levelListconfId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelListconfServiceImpl.getUlLevelListconfModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevelListconf getUlLevelListconfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelListconfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelListconfServiceImpl.getUlLevelListconfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelListconfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelListconfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.delUlLevelListconfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.delUlLevelListconfModelByCode.num");
        }
    }

    private void deleteUlLevelListconfModel(Integer levelListconfId) throws ApiException {
        if (null == levelListconfId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelListconfMapper.deleteByPrimaryKey(levelListconfId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.deleteUlLevelListconfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.deleteUlLevelListconfModel.num");
        }
    }

    private void updateUlLevelListconfModel(UlLevelListconf ulLevelListconf) throws ApiException {
        if (null == ulLevelListconf) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelListconfMapper.updateByPrimaryKey(ulLevelListconf);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.updateUlLevelListconfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.updateUlLevelListconfModel.num");
        }
    }

    private void updateStateUlLevelListconfModel(Integer levelListconfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == levelListconfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelListconfId", levelListconfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelListconfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.updateStateUlLevelListconfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.updateStateUlLevelListconfModel.null");
        }
    }

    private void updateStateUlLevelListconfModelByCode(String tenantCode, String levelListconfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)levelListconfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListconfCode", levelListconfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelListconfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.updateStateUlLevelListconfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.updateStateUlLevelListconfModelByCode.null");
        }
    }

    private UlLevelListconf makeUlLevelListconf(UlLevelListconfDomain ulLevelListconfDomain, UlLevelListconf ulLevelListconf) {
        if (null == ulLevelListconfDomain) {
            return null;
        }
        if (null == ulLevelListconf) {
            ulLevelListconf = new UlLevelListconf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelListconf, (Object)ulLevelListconfDomain);
            return ulLevelListconf;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelListconfServiceImpl.makeUlLevelListconf", (Throwable)e);
            return null;
        }
    }

    private UlLevelListconfReDomain makeUlLevelListconfReDomain(UlLevelListconf ulLevelListconf) {
        if (null == ulLevelListconf) {
            return null;
        }
        UlLevelListconfReDomain ulLevelListconfReDomain = new UlLevelListconfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelListconfReDomain, (Object)ulLevelListconf);
            return ulLevelListconfReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelListconfServiceImpl.makeUlLevelListconfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelListconf> queryUlLevelListconfModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelListconfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelListconfServiceImpl.queryUlLevelListconfModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevelListconf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelListconfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelListconfServiceImpl.countUlLevelListconf", (Throwable)e);
        }
        return i;
    }

    private UlLevelListconf createUlLevelListconf(UlLevelListconfDomain ulLevelListconfDomain) {
        String msg = this.checkUlLevelListconf(ulLevelListconfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.saveUlLevelListconf.checkUlLevelListconf", msg);
        }
        UlLevelListconf ulLevelListconf = this.makeUlLevelListconf(ulLevelListconfDomain, null);
        this.setUlLevelListconfDefault(ulLevelListconf);
        return ulLevelListconf;
    }

    @Override
    public String saveUlLevelListconf(UlLevelListconfDomain ulLevelListconfDomain) throws ApiException {
        UlLevelListconf ulLevelListconf = this.createUlLevelListconf(ulLevelListconfDomain);
        this.saveUlLevelListconfModel(ulLevelListconf);
        this.disUtilLevelListconf(ulLevelListconf, false);
        return ulLevelListconf.getLevelListconfCode();
    }

    @Override
    public String saveUlLevelListconfBatch(List<UlLevelListconfDomain> ulLevelListconfDomainList) throws ApiException {
        if (null == ulLevelListconfDomainList || ulLevelListconfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevelListconf> ulLevelListconfList = new ArrayList<UlLevelListconf>();
        String code = "";
        for (UlLevelListconfDomain ulLevelListconfDomain : ulLevelListconfDomainList) {
            UlLevelListconf ulLevelListconf = this.createUlLevelListconf(ulLevelListconfDomain);
            code = ulLevelListconf.getLevelListconfCode();
            ulLevelListconfList.add(ulLevelListconf);
        }
        this.saveUlLevelListconfBatchModel(ulLevelListconfList);
        return code;
    }

    @Override
    public void updateUlLevelListconfState(Integer levelListconfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == levelListconfId) {
            return;
        }
        this.updateStateUlLevelListconfModel(levelListconfId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelListconfStateByCode(String tenantCode, String levelListconfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)levelListconfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlLevelListconfModelByCode(tenantCode, levelListconfCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelListconf(UlLevelListconfDomain ulLevelListconfDomain) throws ApiException {
        String msg = this.checkUlLevelListconf(ulLevelListconfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.updateUlLevelListconf.checkUlLevelListconf", msg);
        }
        UlLevelListconf oldUlLevelListconf = this.getUlLevelListconfModelById(ulLevelListconfDomain.getLevelListconfId());
        if (null == oldUlLevelListconf) {
            throw new ApiException("ul.UlLevelListconfServiceImpl.updateUlLevelListconf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlLevelListconf ulLevelListconf = this.makeUlLevelListconf(ulLevelListconfDomain, oldUlLevelListconf);
        this.setUlLevelListconfUpdataDefault(ulLevelListconf);
        this.updateUlLevelListconfModel(ulLevelListconf);
        this.disUtilLevelListconf(ulLevelListconf, false);
    }

    private void disUtilLevelListconf(UlLevelListconf ulLevelListconf, boolean delete) {
        String key = ulLevelListconf.getLevelDatatype() + "-" + ulLevelListconf.getTenantCode() + "-" + ulLevelListconf.getLevelUserqua() + "-" + ulLevelListconf.getLevelListCode();
        if (delete) {
            DisUtil.delMap((String)this.cachekey, (String[])new String[]{key});
        } else {
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)ulLevelListconf));
        }
    }

    @Override
    public UlLevelListconf getUlLevelListconf(Integer levelListconfId) {
        if (null == levelListconfId) {
            return null;
        }
        return this.getUlLevelListconfModelById(levelListconfId);
    }

    @Override
    public void deleteUlLevelListconf(Integer levelListconfId) throws ApiException {
        if (null == levelListconfId) {
            return;
        }
        UlLevelListconf ulLevelListconf = this.getUlLevelListconf(levelListconfId);
        this.disUtilLevelListconf(ulLevelListconf, true);
        this.deleteUlLevelListconfModel(levelListconfId);
    }

    @Override
    public QueryResult<UlLevelListconf> queryUlLevelListconfPage(Map<String, Object> map) {
        List<UlLevelListconf> ulLevelListconfList = this.queryUlLevelListconfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlLevelListconf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulLevelListconfList);
        return queryResult;
    }

    @Override
    public UlLevelListconf getUlLevelListconfByCode(String tenantCode, String levelListconfCode) throws ApiException {
        if (StringUtils.isBlank((String)levelListconfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListconfCode", levelListconfCode);
        UlLevelListconf ulLevelListconf = this.getUlLevelListconfByCode(tenantCode, levelListconfCode);
        this.disUtilLevelListconf(ulLevelListconf, true);
        return this.getUlLevelListconfModelByCode(map);
    }

    @Override
    public void deleteUlLevelListconfByCode(String tenantCode, String levelListconfCode) throws ApiException {
        if (StringUtils.isBlank((String)levelListconfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListconfCode", levelListconfCode);
        this.delUlLevelListconfModelByCode(map);
    }

    @Override
    public void queryLevelListconfCache() {
        this.logger.info("ul.UlLevelListconfServiceImpl.queryLevelListconfCache", (Object)"===========start==========");
        List<UlLevelListconf> list = this.queryUlLevelListconfModelPage(new HashMap<String, Object>());
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("ul.UlLevelListconfServiceImpl.queryLevelListconfCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (UlLevelListconf ulLevelListconf : list) {
            if (StringUtils.isBlank((String)ulLevelListconf.getLevelType())) continue;
            map.put(ulLevelListconf.getLevelDatatype() + "-" + ulLevelListconf.getTenantCode() + "-" + ulLevelListconf.getLevelUserqua() + "-" + ulLevelListconf.getLevelListCode(), JsonUtil.buildNormalBinder().toJson((Object)ulLevelListconf));
        }
        DisUtil.setMapVer((String)this.cachekey, map);
        this.logger.info("ul.UlLevelListconfServiceImpl.queryLevelCache", (Object)"===========add-end==========");
    }
}

