/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ul.dao.UlLevelListMapper;
import com.yqbsoft.laser.service.ul.dao.UlLevelMapper;
import com.yqbsoft.laser.service.ul.domain.ShShsettlUrateconDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelListDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelListReDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelListconfReDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelReDomain;
import com.yqbsoft.laser.service.ul.model.UlLevel;
import com.yqbsoft.laser.service.ul.model.UlLevelList;
import com.yqbsoft.laser.service.ul.model.UlLevelListconf;
import com.yqbsoft.laser.service.ul.service.UlLevelListconfService;
import com.yqbsoft.laser.service.ul.service.UlLevelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UlLevelServiceImpl
extends BaseServiceImpl
implements UlLevelService {
    private static final String SYS_CODE = "ul.UlLevelServiceImpl";
    private UlLevelMapper ulLevelMapper;
    private UlLevelListMapper ulLevelListMapper;
    private UlLevelListconfService ulLevelListconfService;
    private String cachekey = "UlLevel-type";

    public void setUlLevelMapper(UlLevelMapper ulLevelMapper) {
        this.ulLevelMapper = ulLevelMapper;
    }

    public void setUlLevelListMapper(UlLevelListMapper ulLevelListMapper) {
        this.ulLevelListMapper = ulLevelListMapper;
    }

    public void setUlLevelListconfService(UlLevelListconfService ulLevelListconfService) {
        this.ulLevelListconfService = ulLevelListconfService;
    }

    private Date getSysDate() {
        try {
            return this.ulLevelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlLevel(UlLevelDomain ulLevelDomain) {
        if (null == ulLevelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ulLevelDomain.getLevelSort())) {
            msg = msg + "LevelSort\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ulLevelDomain.getLevelType())) {
            msg = msg + "LevelType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ulLevelDomain.getLevelUserqua())) {
            msg = msg + "LevelUserqua\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelDefault(UlLevel ulLevel) {
        if (null == ulLevel) {
            return;
        }
        if (null == ulLevel.getDataState()) {
            ulLevel.setDataState(0);
        }
        if (null == ulLevel.getLevelStart()) {
            ulLevel.setLevelStart("0");
        }
        Date date = this.getSysDate();
        if (null == ulLevel.getGmtCreate()) {
            ulLevel.setGmtCreate(date);
        }
        ulLevel.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevel.getLevelCode())) {
            ulLevel.setLevelCode(this.getNo(null, "UlLevel", "ulLevel", ulLevel.getTenantCode()));
        }
    }

    private int getUlLevelMaxCode() {
        int code = 0;
        try {
            return this.ulLevelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.getUlLevelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelUpdataDefault(UlLevel ulLevel) {
        if (null == ulLevel) {
            return;
        }
        ulLevel.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelModel(UlLevel ulLevel) throws ApiException {
        if (null == ulLevel) {
            return;
        }
        try {
            this.ulLevelMapper.insert(ulLevel);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.saveUlLevelModel.ex", (Throwable)e);
        }
    }

    private void saveUlLevelBatchModel(List<UlLevel> ulLevelList) throws ApiException {
        if (null == ulLevelList || ulLevelList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelMapper.insertBatch(ulLevelList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.saveUlLevelBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevel getUlLevelModelById(Integer levelId) {
        if (null == levelId) {
            return null;
        }
        try {
            return this.ulLevelMapper.selectByPrimaryKey(levelId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.getUlLevelModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevel getUlLevelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.getUlLevelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.delUlLevelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelServiceImpl.delUlLevelModelByCode.num");
        }
    }

    private void deleteUlLevelModel(Integer levelId) throws ApiException {
        if (null == levelId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelMapper.deleteByPrimaryKey(levelId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.deleteUlLevelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelServiceImpl.deleteUlLevelModel.num");
        }
    }

    private void updateUlLevelModel(UlLevel ulLevel) throws ApiException {
        if (null == ulLevel) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelMapper.updateByPrimaryKeySelective(ulLevel);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.updateUlLevelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelServiceImpl.updateUlLevelModel.num");
        }
    }

    private void updateStateUlLevelModel(Integer levelId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == levelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelId", levelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.updateStateUlLevelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelServiceImpl.updateStateUlLevelModel.null");
        }
    }

    private void updateStateUlLevelModelByCode(String tenantCode, String levelCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)levelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelCode", levelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.updateStateUlLevelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelServiceImpl.updateStateUlLevelModelByCode.null");
        }
    }

    private UlLevel makeUlLevel(UlLevelDomain ulLevelDomain, UlLevel ulLevel) {
        if (null == ulLevelDomain) {
            return null;
        }
        if (null == ulLevel) {
            ulLevel = new UlLevel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevel, (Object)ulLevelDomain);
            return ulLevel;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.makeUlLevel", (Throwable)e);
            return null;
        }
    }

    private UlLevelReDomain makeUlLevelReDomain(UlLevel ulLevel) {
        if (null == ulLevel) {
            return null;
        }
        UlLevelReDomain ulLevelReDomain = new UlLevelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelReDomain, (Object)ulLevel);
            return ulLevelReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.makeUlLevelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevel> queryUlLevelModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.queryUlLevelModel", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelList> queryByLevelListNum(Map<String, Object> parammap) {
        try {
            return this.ulLevelListMapper.queryByLevelCodeAndNum(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.queryUlLevelModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.countUlLevel", (Throwable)e);
        }
        return i;
    }

    private UlLevel createUlLevel(UlLevelDomain ulLevelDomain) {
        String msg = this.checkUlLevel(ulLevelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelServiceImpl.saveUlLevel.checkUlLevel", msg);
        }
        UlLevel ulLevel = this.makeUlLevel(ulLevelDomain, null);
        this.setUlLevelDefault(ulLevel);
        return ulLevel;
    }

    private String checkUlLevelList(UlLevelListDomain ulLevelListDomain) {
        if (null == ulLevelListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelListDefault(UlLevelList ulLevelList) {
        if (null == ulLevelList) {
            return;
        }
        if (null == ulLevelList.getDataState()) {
            ulLevelList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulLevelList.getGmtCreate()) {
            ulLevelList.setGmtCreate(date);
        }
        ulLevelList.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevelList.getLevelListCode())) {
            ulLevelList.setLevelListCode(this.getNo(null, "UlLevelList", "ulLevelList", ulLevelList.getTenantCode()));
        }
    }

    private int getUlLevelListMaxCode() {
        int code = 0;
        try {
            return this.ulLevelListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.getUlLevelListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelListUpdataDefault(UlLevelList ulLevelList) {
        if (null == ulLevelList) {
            return;
        }
        ulLevelList.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelListModel(UlLevelList ulLevelList) throws ApiException {
        if (null == ulLevelList) {
            return;
        }
        try {
            this.ulLevelListMapper.insert(ulLevelList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.saveUlLevelListModel.ex", (Throwable)e);
        }
    }

    private int getMaxUlLevelListLevel(Map<String, Object> map) throws ApiException {
        int code = 0;
        try {
            return this.ulLevelListMapper.getMaxLevelListLevel(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.getMaxUlLevelListLevel", (Throwable)e);
            return code;
        }
    }

    private void saveUlLevelListBatchModel(List<UlLevelList> ulLevelListList) throws ApiException {
        if (null == ulLevelListList || ulLevelListList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelListMapper.insertBatch(ulLevelListList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.saveUlLevelListBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevelList getUlLevelListModelById(Integer levelListId) {
        if (null == levelListId) {
            return null;
        }
        try {
            return this.ulLevelListMapper.selectByPrimaryKey(levelListId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.getUlLevelListModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevelList getUlLevelListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.getUlLevelListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.delUlLevelListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelServiceImpl.delUlLevelListModelByCode.num");
        }
    }

    private void deleteUlLevelListModel(Integer levelListId) throws ApiException {
        if (null == levelListId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelListMapper.deleteByPrimaryKey(levelListId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.deleteUlLevelListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelServiceImpl.deleteUlLevelListModel.num");
        }
    }

    private void updateUlLevelListModel(UlLevelList ulLevelList) throws ApiException {
        if (null == ulLevelList) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelListMapper.updateByPrimaryKeySelective(ulLevelList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.updateUlLevelListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelServiceImpl.updateUlLevelListModel.num");
        }
    }

    private void updateStateUlLevelListModel(Integer levelListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == levelListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelListId", levelListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.updateStateUlLevelListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelServiceImpl.updateStateUlLevelListModel.null");
        }
    }

    private void updateStateUlLevelListModelByCode(String tenantCode, String levelListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListCode", levelListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelServiceImpl.updateStateUlLevelListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelServiceImpl.updateStateUlLevelListModelByCode.null");
        }
    }

    private UlLevelList makeUlLevelList(UlLevelListDomain ulLevelListDomain, UlLevelList ulLevelList) {
        if (null == ulLevelListDomain) {
            return null;
        }
        if (null == ulLevelList) {
            ulLevelList = new UlLevelList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelList, (Object)ulLevelListDomain);
            return ulLevelList;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.makeUlLevelList", (Throwable)e);
            return null;
        }
    }

    private UlLevelListReDomain makeUlLevelListReDomain(UlLevelList ulLevelList) {
        if (null == ulLevelList) {
            return null;
        }
        UlLevelListReDomain ulLevelListReDomain = new UlLevelListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelListReDomain, (Object)ulLevelList);
            return ulLevelListReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.makeUlLevelListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelList> queryUlLevelListModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.queryUlLevelListModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevelList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelServiceImpl.countUlLevelList", (Throwable)e);
        }
        return i;
    }

    private UlLevelList createUlLevelList(UlLevelListDomain ulLevelListDomain) {
        String msg = this.checkUlLevelList(ulLevelListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelServiceImpl.saveUlLevelList.checkUlLevelList", msg);
        }
        UlLevelList ulLevelList = this.makeUlLevelList(ulLevelListDomain, null);
        this.setUlLevelListDefault(ulLevelList);
        return ulLevelList;
    }

    @Override
    public String saveUlLevel(UlLevelDomain ulLevelDomain) throws ApiException {
        UlLevel ulLevel = new UlLevel();
        if (null == ulLevelDomain.getLevelId()) {
            ulLevel = this.createUlLevel(ulLevelDomain);
            this.saveUlLevelModel(ulLevel);
            this.setLevelDis(ulLevel);
        } else {
            ulLevel = this.getUlLevel(ulLevelDomain.getLevelId());
        }
        if (null != ulLevelDomain.getUlLevelListReDomainList() && !ulLevelDomain.getUlLevelListReDomainList().isEmpty()) {
            String levelDatavalue = "0";
            for (UlLevelListReDomain ulLevelListReDomain : ulLevelDomain.getUlLevelListReDomainList()) {
                try {
                    BeanUtils.copyAllPropertys((Object)ulLevelListReDomain, (Object)ulLevel);
                }
                catch (Exception e) {
                    throw new ApiException("ul.UlLevelServiceImpl.savePackageList.e", (Throwable)e);
                }
                ulLevelListReDomain.setLevelDatatype("levelListParentCode");
                ulLevelListReDomain.setLevelDatavalue(levelDatavalue);
                if (StringUtils.isBlank((Integer)ulLevelListReDomain.getLevelListId())) {
                    String code = this.saveUlLevelList(ulLevelListReDomain);
                    ulLevelListReDomain.setLevelListCode(code);
                } else {
                    this.updateUlLevelList(ulLevelListReDomain);
                }
                levelDatavalue = ulLevelListReDomain.getLevelListCode();
                this.saveLevelListconf(ulLevelListReDomain);
            }
        }
        return ulLevel.getLevelCode();
    }

    private void setLevelDis(UlLevel ulLevel) {
        if (null == ulLevel || null == ulLevel.getLevelUserqua() || !"dis".equals(ulLevel.getLevelUserqua())) {
            return;
        }
        String key = ulLevel.getLevelType() + "-" + ulLevel.getTenantCode() + "-" + ulLevel.getLevelUserqua() + "-" + ulLevel.getMemberMcode();
        DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)ulLevel));
    }

    private void saveLevelListconf(UlLevelListReDomain ulLevelListReDomain) {
        if (null == ulLevelListReDomain || ListUtil.isEmpty(ulLevelListReDomain.getUlLevelListconfReDomainList())) {
            return;
        }
        QueryResult<UlLevelListconf> queryResult = this.ulLevelListconfService.queryUlLevelListconfPage(this.getQueryParamMap("tenantCode,levelListCode", new Object[]{ulLevelListReDomain.getTenantCode(), ulLevelListReDomain.getLevelListCode()}));
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            for (UlLevelListconf ulLevelListconf : queryResult.getList()) {
                this.ulLevelListconfService.deleteUlLevelListconf(ulLevelListconf.getLevelListconfId());
            }
        }
        for (UlLevelListconfReDomain ulLevelListconfReDomain : ulLevelListReDomain.getUlLevelListconfReDomainList()) {
            ulLevelListconfReDomain.setTenantCode(ulLevelListReDomain.getTenantCode());
            ulLevelListconfReDomain.setLevelCode(ulLevelListReDomain.getLevelCode());
            ulLevelListconfReDomain.setLevelListCode(ulLevelListReDomain.getLevelListCode());
            ulLevelListconfReDomain.setLevelUserqua(ulLevelListReDomain.getLevelUserqua());
            ulLevelListconfReDomain.setLevelType(ulLevelListReDomain.getLevelType());
            ulLevelListconfReDomain.setLevelListLevel(ulLevelListReDomain.getLevelListLevel());
            ulLevelListconfReDomain.setMemberCode(ulLevelListReDomain.getMemberCode());
            ulLevelListconfReDomain.setMemberName(ulLevelListReDomain.getMemberName());
            ulLevelListconfReDomain.setLevelSort(ulLevelListReDomain.getLevelSort());
            this.ulLevelListconfService.saveUlLevelListconf(ulLevelListconfReDomain);
        }
    }

    @Override
    public String saveUlLevelBatch(List<UlLevelDomain> ulLevelDomainList) throws ApiException {
        if (null == ulLevelDomainList || ulLevelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevel> ulLevelList = new ArrayList<UlLevel>();
        String code = "";
        for (UlLevelDomain ulLevelDomain : ulLevelDomainList) {
            UlLevel ulLevel = this.createUlLevel(ulLevelDomain);
            code = ulLevel.getLevelCode();
            ulLevelList.add(ulLevel);
        }
        this.saveUlLevelBatchModel(ulLevelList);
        return code;
    }

    @Override
    public void updateUlLevelState(Integer levelId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == levelId) {
            return;
        }
        this.updateStateUlLevelModel(levelId, dataState, oldDataState, map);
        this.updateUlLevelListStateByUlLevel(levelId, dataState, oldDataState);
        this.updateUlLevelDisById(dataState, levelId);
    }

    public void updateUlLevelDisById(Integer dataState, Integer levelId) {
        UlLevel ulLevel = this.getUlLevel(levelId);
        if (null == ulLevel) {
            return;
        }
        String key = ulLevel.getLevelType() + "-" + ulLevel.getTenantCode() + "-" + ulLevel.getLevelUserqua() + "-" + ulLevel.getMemberMcode();
        if (1 == dataState) {
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)ulLevel));
        } else if (0 == dataState) {
            DisUtil.delMap((String)this.cachekey, (String[])new String[]{key, JsonUtil.buildNormalBinder().toJson((Object)ulLevel)});
        }
    }

    private void updateUlLevelListStateByUlLevel(Integer levelId, Integer dataState, Integer oldDataState) {
        UlLevel ulLevel = this.getUlLevel(levelId);
        if (null == ulLevel) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("ulLevelCode", ulLevel.getLevelCode());
        parammap.put("tenantCode", ulLevel.getTenantCode());
        parammap.put("levelType", ulLevel.getLevelType());
        parammap.put("dataState", oldDataState);
        parammap.put("fuzzy", false);
        List<UlLevelList> ulLevelLists = this.queryUlLevelListModelPage(parammap);
        if (null != ulLevelLists && !ulLevelLists.isEmpty()) {
            for (UlLevelList ulLevelList : ulLevelLists) {
                this.updateUlLevelListState(ulLevelList.getLevelListId(), dataState, oldDataState, null);
            }
        }
    }

    @Override
    public void updateUlLevelStateByCode(String tenantCode, String levelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)levelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlLevelModelByCode(tenantCode, levelCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevel(UlLevelDomain ulLevelDomain) throws ApiException {
        String msg = this.checkUlLevel(ulLevelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelServiceImpl.updateUlLevel.checkUlLevel", msg);
        }
        UlLevel oldUlLevel = this.getUlLevelModelById(ulLevelDomain.getLevelId());
        if (null == oldUlLevel) {
            throw new ApiException("ul.UlLevelServiceImpl.updateUlLevel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlLevel ulLevel = this.makeUlLevel(ulLevelDomain, oldUlLevel);
        this.setUlLevelUpdataDefault(ulLevel);
        this.updateUlLevelModel(ulLevel);
        this.setLevelDis(ulLevel);
    }

    @Override
    public UlLevel getUlLevel(Integer levelId) {
        if (null == levelId) {
            return null;
        }
        return this.getUlLevelModelById(levelId);
    }

    @Override
    public void deleteUlLevel(Integer levelId) throws ApiException {
        if (null == levelId) {
            return;
        }
        this.deleteUlLevelModel(levelId);
    }

    @Override
    public QueryResult<UlLevel> queryUlLevelPage(Map<String, Object> map) {
        List<UlLevel> ulLevelList = this.queryUlLevelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlLevel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulLevelList);
        return queryResult;
    }

    @Override
    public UlLevel getUlLevelByCode(String tenantCode, String levelCode) throws ApiException {
        if (StringUtils.isBlank((String)levelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelCode", levelCode);
        return this.getUlLevelModelByCode(map);
    }

    @Override
    public void deleteUlLevelByCode(String tenantCode, String levelCode) throws ApiException {
        if (StringUtils.isBlank((String)levelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelCode", levelCode);
        this.delUlLevelModelByCode(map);
    }

    @Override
    public String saveUlLevelList(UlLevelListDomain ulLevelListDomain) throws ApiException {
        UlLevelList ulLevelList = this.createUlLevelList(ulLevelListDomain);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelType", ulLevelList.getLevelType());
        map.put("levelCode", ulLevelList.getLevelCode());
        map.put("tenantCode", ulLevelList.getTenantCode());
        int maxlevel = this.getMaxUlLevelListLevel(map) + 1;
        ulLevelList.setLevelListLevel(maxlevel);
        this.saveUlLevelListModel(ulLevelList);
        this.addShsettlUratecon(ulLevelList);
        return ulLevelList.getLevelListCode();
    }

    private void addShsettlUratecon(UlLevelList ulLevelList) {
        if (null == ulLevelList.getLevelUserqua() || !"dis".equals(ulLevelList.getLevelUserqua())) {
            return;
        }
        HashMap<String, String> parammap = new HashMap<String, String>();
        ShShsettlUrateconDomain shShsettlUrateconDomain = new ShShsettlUrateconDomain();
        shShsettlUrateconDomain.setShsettlUrateconType("ulLevelListCode");
        shShsettlUrateconDomain.setShsettlUrateconOpcode(ulLevelList.getLevelListCode());
        shShsettlUrateconDomain.setTenantCode(ulLevelList.getTenantCode());
        parammap.put("shShsettlUrateconDomain", JsonUtil.buildNormalBinder().toJson((Object)shShsettlUrateconDomain));
        this.internalInvoke("sh.shsettlUratecon.saveShsettlUratecon", parammap);
    }

    @Override
    public String saveUlLevelListBatch(List<UlLevelListDomain> ulLevelListDomainList) throws ApiException {
        if (null == ulLevelListDomainList || ulLevelListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevelList> ulLevelListList = new ArrayList<UlLevelList>();
        String code = "";
        for (UlLevelListDomain ulLevelListDomain : ulLevelListDomainList) {
            UlLevelList ulLevelList = this.createUlLevelList(ulLevelListDomain);
            code = ulLevelList.getLevelListCode();
            ulLevelListList.add(ulLevelList);
        }
        this.saveUlLevelListBatchModel(ulLevelListList);
        return code;
    }

    private String saveUlLevelListBatch(List<UlLevelListReDomain> ulLevelListReDomainList, UlLevel ulLevel) throws ApiException {
        if (null == ulLevelListReDomainList || ulLevelListReDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevelList> ulLevelListList = new ArrayList<UlLevelList>();
        String code = "";
        for (UlLevelListDomain ulLevelListDomain : ulLevelListReDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)ulLevelListDomain, (Object)ulLevel);
            }
            catch (Exception e) {
                throw new ApiException("ul.UlLevelServiceImpl.savePackageList.e", (Throwable)e);
            }
            UlLevelList ulLevelList = this.createUlLevelList(ulLevelListDomain);
            code = ulLevelList.getLevelListCode();
            ulLevelListList.add(ulLevelList);
        }
        this.saveUlLevelListBatchModel(ulLevelListList);
        return code;
    }

    @Override
    public void updateUlLevelListState(Integer levelListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == levelListId) {
            return;
        }
        this.updateStateUlLevelListModel(levelListId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelListStateByCode(String tenantCode, String levelListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlLevelListModelByCode(tenantCode, levelListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelList(UlLevelListDomain ulLevelListDomain) throws ApiException {
        String msg = this.checkUlLevelList(ulLevelListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelServiceImpl.updateUlLevelList.checkUlLevelList", msg);
        }
        UlLevelList oldUlLevelList = this.getUlLevelListModelById(ulLevelListDomain.getLevelListId());
        if (null == oldUlLevelList) {
            throw new ApiException("ul.UlLevelServiceImpl.updateUlLevelList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlLevelList ulLevelList = this.makeUlLevelList(ulLevelListDomain, oldUlLevelList);
        this.setUlLevelListUpdataDefault(ulLevelList);
        this.updateUlLevelListModel(ulLevelList);
    }

    @Override
    public UlLevelList getUlLevelList(Integer levelListId) {
        if (null == levelListId) {
            return null;
        }
        return this.getUlLevelListModelById(levelListId);
    }

    @Override
    public void deleteUlLevelList(Integer levelListId) throws ApiException {
        if (null == levelListId) {
            return;
        }
        this.deleteUlLevelListModel(levelListId);
    }

    @Override
    public QueryResult<UlLevelList> queryUlLevelListPage(Map<String, Object> map) {
        List<UlLevelList> ulLevelListList = this.queryUlLevelListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlLevelList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulLevelListList);
        return queryResult;
    }

    @Override
    public UlLevelList getUlLevelListByCode(String tenantCode, String levelListCode) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListCode", levelListCode);
        return this.getUlLevelListModelByCode(map);
    }

    @Override
    public void deleteUlLevelListByCode(String tenantCode, String levelListCode) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListCode", levelListCode);
        this.delUlLevelListModelByCode(map);
    }

    @Override
    public void queryLevelCache() {
        this.logger.info("UlLevelServiceImpl.queryLevelCache", (Object)"===========start==========");
        List<UlLevel> list = this.queryUlLevelModelPage(new HashMap<String, Object>());
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("UlLevelServiceImpl.queryLevelCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (UlLevel ulLevel : list) {
            if (StringUtils.isBlank((String)ulLevel.getLevelType()) || StringUtils.isBlank((String)ulLevel.getLevelUserqua())) continue;
            if (null == ulLevel.getDataState()) {
                ulLevel.setDataState(0);
            }
            if (!"dis".equals(ulLevel.getLevelUserqua()) && 1 != ulLevel.getDataState()) continue;
            if (StringUtils.isBlank((String)ulLevel.getMemberMcode())) {
                ulLevel.setMemberMcode("all");
            }
            if (StringUtils.isBlank((String)ulLevel.getLevelUserqua())) {
                ulLevel.setLevelUserqua("all");
            }
            String key = ulLevel.getLevelType() + "-" + ulLevel.getTenantCode() + "-" + ulLevel.getLevelUserqua() + "-" + ulLevel.getMemberMcode();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)ulLevel));
        }
        DisUtil.setMapVer((String)this.cachekey, map);
        this.logger.info("UlLevelServiceImpl.queryLevelCache", (Object)"===========add-end==========");
    }

    @Override
    public List<UlLevelList> queryLevelListByLevelNum(Map<String, Object> map) throws ApiException {
        return this.queryByLevelListNum(map);
    }

    @Override
    public String coverageOldLevel(String oldLevelCode, String newLevelCode, String tenantCode) {
        if (StringUtils.isEmpty((String)oldLevelCode) || StringUtils.isEmpty((String)newLevelCode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("ul.UlLevelServiceImpl.coverageOldLevel.param", (Object)(oldLevelCode + "====" + newLevelCode + "===" + tenantCode));
            return "error";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("levelCode", newLevelCode);
        List<UlLevelList> newQuery = this.ulLevelListMapper.query(paramMap);
        if (ListUtil.isEmpty(newQuery)) {
            this.logger.error("ul.UlLevelServiceImpl.coverageOldLevel.newQuery.null", (Object)((Object)paramMap).toString());
            return "success";
        }
        paramMap.put("levelCode", oldLevelCode);
        List<UlLevelList> oldQuery = this.ulLevelListMapper.query(paramMap);
        if (ListUtil.isEmpty(oldQuery)) {
            this.logger.error("ul.UlLevelServiceImpl.coverageOldLevel.oldQuery,null", paramMap);
            for (UlLevelList ulLevelList : newQuery) {
                ulLevelList.setLevelCode(oldLevelCode);
                this.ulLevelListMapper.insert(ulLevelList);
            }
        }
        UlLevelList updateUlLevelList = new UlLevelList();
        for (UlLevelList newUlLevelList : newQuery) {
            for (UlLevelList oldUlLevelList : oldQuery) {
                if (newUlLevelList.getLevelListLevel().equals(oldUlLevelList.getLevelListLevel())) {
                    this.logger.error("ul.UlLevelServiceImpl.coverageOldLevel.update", (Object)oldUlLevelList.getLevelListLevel());
                    updateUlLevelList.setLevelListStart(newUlLevelList.getLevelListStart());
                    updateUlLevelList.setLevelListEnd(newUlLevelList.getLevelListEnd());
                    updateUlLevelList.setLevelListId(oldUlLevelList.getLevelListId());
                    this.ulLevelListMapper.updateByPrimaryKeySelective(updateUlLevelList);
                    continue;
                }
                newUlLevelList.setLevelListId(null);
                newUlLevelList.setLevelListCode(null);
                newUlLevelList.setLevelCode(oldUlLevelList.getLevelCode());
                this.setUlLevelListDefault(newUlLevelList);
                this.ulLevelListMapper.insert(newUlLevelList);
            }
        }
        return "success";
    }
}

