/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmSignMapper;
import com.yqbsoft.laser.service.user.domain.UmSignDomain;
import com.yqbsoft.laser.service.user.model.UmSign;
import com.yqbsoft.laser.service.user.service.UmSignService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmSignServiceImpl
extends BaseServiceImpl
implements UmSignService {
    public static final String SYS_CODE = "um.USER.UmSignServiceImpl";
    private UmSignMapper umSignMapper;

    public void setUmSignMapper(UmSignMapper umSignMapper) {
        this.umSignMapper = umSignMapper;
    }

    private Date getSysDate() {
        try {
            return this.umSignMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmSignServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSign(UmSignDomain umSignDomain, String type) {
        if (null == umSignDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        StringBuffer msg = new StringBuffer();
        if ("insert".equals(type)) {
            if (StringUtils.isBlank((String)umSignDomain.getSignLat())) {
                msg.append("\u4f4d\u7f6e\u7eac\u5ea6\u4e3a\u7a7a;");
            }
            if (StringUtils.isBlank((String)umSignDomain.getSignLong())) {
                msg.append("\u4f4d\u7f6e\u7ecf\u5ea6\u4e3a\u7a7a;");
            }
        }
        return msg.toString();
    }

    private void setSignDefault(UmSign umSign) {
        if (null == umSign) {
            return;
        }
        if (null == umSign.getDataState()) {
            umSign.setDataState(0);
        }
        if (null == umSign.getGmtCreate()) {
            umSign.setGmtCreate(this.getSysDate());
        }
        umSign.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umSign.getSignCode())) {
            umSign.setSignCode(this.createUUIDString());
        }
    }

    private int getSignMaxCode() {
        int code = 0;
        try {
            return this.umSignMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmSignServiceImpl.getSignMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSignUpdataDefault(UmSign umSign) {
        if (null == umSign) {
            return;
        }
        umSign.setGmtModified(this.getSysDate());
    }

    private void saveSignModel(UmSign umSign) throws ApiException {
        if (null == umSign) {
            return;
        }
        try {
            this.umSignMapper.insert(umSign);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmSignServiceImpl.saveSignModel.ex", (Throwable)e);
        }
    }

    private UmSign getSignModelById(Integer signId) {
        if (null == signId) {
            return null;
        }
        try {
            return this.umSignMapper.selectByPrimaryKey(signId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmSignServiceImpl.getSignModelById", (Throwable)e);
            return null;
        }
    }

    public UmSign getSignModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umSignMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmSignServiceImpl.getSignModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSignModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umSignMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmSignServiceImpl.delSignModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmSignServiceImpl.delSignModelByCode.num");
        }
    }

    private void deleteSignModel(Integer signId) throws ApiException {
        if (null == signId) {
            return;
        }
        int i = 0;
        try {
            i = this.umSignMapper.deleteByPrimaryKey(signId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmSignServiceImpl.deleteSignModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmSignServiceImpl.deleteSignModel.num");
        }
    }

    private void updateSignModel(UmSign umSign) throws ApiException {
        if (null == umSign) {
            return;
        }
        try {
            this.umSignMapper.updateByPrimaryKeySelective(umSign);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmSignServiceImpl.updateSignModel.ex", (Throwable)e);
        }
    }

    private void updateStateSignModel(Integer signId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == signId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("signId", signId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umSignMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmSignServiceImpl.updateStateSignModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmSignServiceImpl.updateStateSignModel.null");
        }
    }

    private UmSign makeSign(UmSignDomain umSignDomain, UmSign umSign) {
        if (null == umSignDomain) {
            return null;
        }
        if (null == umSign) {
            umSign = new UmSign();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umSign, (Object)umSignDomain);
            return umSign;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmSignServiceImpl.makeSign", (Throwable)e);
            return null;
        }
    }

    private List<UmSign> querySignModelPage(Map<String, Object> parammap) {
        try {
            return this.umSignMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmSignServiceImpl.querySignModel", (Throwable)e);
            return null;
        }
    }

    private int countSign(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umSignMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmSignServiceImpl.countSign", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveSign(UmSignDomain umSignDomain) throws ApiException {
        String msg = this.checkSign(umSignDomain, "insert");
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmSignServiceImpl.saveSign.checkSign", msg);
        }
        UmSign umSign = this.makeSign(umSignDomain, null);
        this.setSignDefault(umSign);
        this.saveSignModel(umSign);
    }

    @Override
    public void updateSignState(Integer signId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSignModel(signId, dataState, oldDataState);
    }

    @Override
    public void updateSign(UmSignDomain umSignDomain) throws ApiException {
        String msg = this.checkSign(umSignDomain, "update");
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmSignServiceImpl.updateSign.checkSign", msg);
        }
        UmSign oldUmSign = this.getSignModelById(umSignDomain.getSignId());
        if (null == oldUmSign) {
            throw new ApiException("um.USER.UmSignServiceImpl.updateSign.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmSign umSign = this.makeSign(umSignDomain, oldUmSign);
        this.setSignUpdataDefault(umSign);
        this.updateSignModel(umSign);
    }

    @Override
    public UmSign getSign(Integer signId) {
        return this.getSignModelById(signId);
    }

    @Override
    public void deleteSign(Integer signId) throws ApiException {
        this.deleteSignModel(signId);
    }

    @Override
    public QueryResult<UmSign> querySignPage(Map<String, Object> map) {
        List<UmSign> umSignList = this.querySignModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSign(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umSignList);
        return queryResult;
    }

    @Override
    public UmSign getSignByCode(Map<String, Object> map) {
        return this.getSignModelByCode(map);
    }

    @Override
    public void delSignByCode(Map<String, Object> map) throws ApiException {
        this.delSignModelByCode(map);
    }

    @Override
    public List<Map<String, Object>> querySignList(Map<String, Object> map) {
        List<Map<String, Object>> umSignList = this.querySignTrajectory(map);
        return umSignList;
    }

    private List<Map<String, Object>> querySignTrajectory(Map<String, Object> map) {
        try {
            return this.umSignMapper.querySignTrajectory(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmSignServiceImpl.querySignTrajectory", (Throwable)e);
            throw new ApiException("um.USER.UmSignServiceImpl.querySignTrajectory", "\u8003\u52e4\u8f68\u8ff9\u67e5\u770b\u5f02\u5e38");
        }
    }
}

