/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmAddressMapper;
import com.yqbsoft.laser.service.user.domain.UmAddressDomain;
import com.yqbsoft.laser.service.user.model.UmAddress;
import com.yqbsoft.laser.service.user.service.UmAddressService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class UmAddressServiceImpl
extends BaseServiceImpl
implements UmAddressService {
    public static final String SYS_CODE = "um.USER.UmAddressServiceImpl";
    private UmAddressMapper umAddressMapper;

    public void setUmAddressMapper(UmAddressMapper umAddressMapper) {
        this.umAddressMapper = umAddressMapper;
    }

    private Date getSysDate() {
        try {
            return this.umAddressMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmAddressServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAddress(UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umAddressDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)umAddressDomain.getUserCode())) {
            msg = msg + "\u4f1a\u5458\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)umAddressDomain.getAddressMember())) {
            msg = msg + "\u6536\u8d27\u4eba\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)umAddressDomain.getAddressPhone()) && StringUtils.isBlank((String)umAddressDomain.getAddressTel())) {
            msg = msg + "\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a;";
        }
        if ("2".equals(umAddressDomain.getAddressAttribute())) {
            return msg;
        }
        if (StringUtils.isBlank((String)umAddressDomain.getProvinceCode())) {
            msg = msg + "\u7701\u4efd\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)umAddressDomain.getAreaCode())) {
            msg = msg + "\u57ce\u5e02\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)umAddressDomain.getCityCode())) {
            msg = msg + "\u5730\u533a\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)umAddressDomain.getAddressDetail())) {
            msg = msg + "\u4fe1\u606f\u5730\u5740\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAddressDefault(UmAddress umAddress) {
        if (null == umAddress) {
            return;
        }
        if (null == umAddress.getDataState()) {
            umAddress.setDataState(0);
        }
        if (null == umAddress.getGmtCreate()) {
            umAddress.setGmtCreate(this.getSysDate());
        }
        umAddress.setGmtModified(this.getSysDate());
        if (StringUtil.isBlank((String)umAddress.getAddressDefault())) {
            umAddress.setAddressDefault("0");
        }
        if (StringUtils.isBlank((String)umAddress.getAddressCode())) {
            umAddress.setAddressCode(this.createUUIDString());
        }
    }

    private int getAddressMaxCode() {
        int code = 0;
        try {
            return this.umAddressMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmAddressServiceImpl.getAddressMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAddressUpdataDefault(UmAddress umAddress) {
        if (null == umAddress) {
            return;
        }
        umAddress.setGmtModified(this.getSysDate());
    }

    private void saveAddressModel(UmAddress umAddress) throws ApiException {
        if (null == umAddress) {
            return;
        }
        try {
            this.umAddressMapper.insert(umAddress);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmAddressServiceImpl.saveAddressModel.ex", (Throwable)e);
        }
    }

    private UmAddress getAddressModelById(Integer addressId) {
        if (null == addressId) {
            return null;
        }
        try {
            return this.umAddressMapper.selectByPrimaryKey(addressId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmAddressServiceImpl.getAddressModelById", (Throwable)e);
            return null;
        }
    }

    public UmAddress getAddressModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umAddressMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmAddressServiceImpl.getAddressModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAddressModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umAddressMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmAddressServiceImpl.delAddressModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmAddressServiceImpl.delAddressModelByCode.num");
        }
    }

    private void deleteAddressModel(Integer addressId) throws ApiException {
        if (null == addressId) {
            return;
        }
        int i = 0;
        try {
            i = this.umAddressMapper.deleteByPrimaryKey(addressId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmAddressServiceImpl.deleteAddressModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmAddressServiceImpl.deleteAddressModel.num");
        }
    }

    private void updateAddressModel(UmAddress umAddress) throws ApiException {
        if (null == umAddress) {
            return;
        }
        try {
            this.umAddressMapper.updateByPrimaryKeySelective(umAddress);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmAddressServiceImpl.updateAddressModel.ex", (Throwable)e);
        }
    }

    private void updateStateAddressModel(Integer addressId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == addressId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addressId", addressId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umAddressMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmAddressServiceImpl.updateStateAddressModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmAddressServiceImpl.updateStateAddressModel.null");
        }
    }

    private void updateDetailByMerberCode(String userCode, String addressDefault, String tenantCode) throws ApiException {
        if (null == userCode || null == addressDefault) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("addressDefault", addressDefault);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.umAddressMapper.updateDetailByUserCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmAddressServiceImpl.updateStateAddressModel.ex", (Throwable)e);
        }
        if (i < 0) {
            throw new ApiException("um.USER.UmAddressServiceImpl.updateStateAddressModel.null");
        }
    }

    private UmAddress makeAddress(UmAddress umAddress, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            return null;
        }
        if (null == umAddress) {
            umAddress = new UmAddress();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umAddress, (Object)umAddressDomain);
            return umAddress;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmAddressServiceImpl.makeAddress", (Throwable)e);
            return null;
        }
    }

    private List<UmAddress> queryAddressModelPage(Map<String, Object> parammap) {
        try {
            return this.umAddressMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmAddressServiceImpl.queryAddressModel", (Throwable)e);
            return null;
        }
    }

    private int countAddress(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umAddressMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmAddressServiceImpl.countAddress", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveAddress(UmAddressDomain umAddressDomain) throws ApiException {
        String msg = this.checkAddress(umAddressDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmAddressServiceImpl.saveAddress.checkAddress", msg);
        }
        UmAddress umAddress = this.makeAddress(null, umAddressDomain);
        this.setAddressDefault(umAddress);
        if ("1".equals(umAddress.getAddressDefault())) {
            this.updateDetailByMerberCode(umAddress.getUserCode(), "0", umAddress.getTenantCode());
        } else {
            List<UmAddress> addressList = this.queryAddressBymerberCode(umAddressDomain.getUserCode(), umAddressDomain.getTenantCode());
            if (addressList == null || addressList.isEmpty()) {
                umAddress.setAddressDefault("1");
            }
        }
        this.saveAddressModel(umAddress);
    }

    @Override
    public void updateAddressState(Integer addressId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAddressModel(addressId, dataState, oldDataState);
    }

    @Override
    public void updateAddress(UmAddressDomain umAddressDomain) throws ApiException {
        String msg = this.checkAddress(umAddressDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmAddressServiceImpl.updateAddress.checkAddress", msg);
        }
        UmAddress oldUmAddress = this.getAddressModelById(umAddressDomain.getAddressId());
        if (null == oldUmAddress) {
            throw new ApiException("um.USER.UmAddressServiceImpl.updateAddress.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmAddress umAddress = this.makeAddress(oldUmAddress, umAddressDomain);
        this.setAddressUpdataDefault(umAddress);
        this.updateAddressModel(umAddress);
        if ("1".equals(umAddress.getAddressDefault())) {
            this.updateAddressDefault(umAddress.getUserCode(), umAddress.getAddressCode(), umAddress.getTenantCode());
        }
    }

    @Override
    public UmAddress getAddress(Integer addressId) {
        return this.getAddressModelById(addressId);
    }

    @Override
    public void deleteAddress(Integer addressId) throws ApiException {
        this.deleteAddressModel(addressId);
    }

    @Override
    public QueryResult<UmAddress> queryAddressPage(Map<String, Object> map) {
        List<UmAddress> umAddressList = this.queryAddressModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAddress(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umAddressList);
        return queryResult;
    }

    @Override
    public UmAddress getAddressByCode(Map<String, Object> map) {
        return this.getAddressModelByCode(map);
    }

    @Override
    public void delAddressByCode(Map<String, Object> map) throws ApiException {
        this.delAddressModelByCode(map);
    }

    @Override
    public List<UmAddress> getAddressBymerberCode(String userCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        List<UmAddress> umAddressList = this.queryAddressModelPage(map);
        return umAddressList;
    }

    @Override
    public List<UmAddress> queryAddressBymerberCode(String userCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("tenantCode", tenantCode);
        map.put("order", true);
        map.put("orderStr", "ADDRESS_DEFAULT DESC");
        List<UmAddress> umAddressList = this.queryAddressModelPage(map);
        return umAddressList;
    }

    @Override
    public UmAddress getDefAddressBymerberCode(String userCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("tenantCode", tenantCode);
        map.put("addressDefault", "1");
        List<UmAddress> umAddressList = this.queryAddressModelPage(map);
        if (null == umAddressList || umAddressList.isEmpty()) {
            return null;
        }
        return umAddressList.get(0);
    }

    @Override
    public void updateAddressDefault(String userCode, String addressCode, String tenantCode) {
        this.updateDetailByMerberCode(userCode, "0", tenantCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addressCode", addressCode);
        map.put("tenantCode", tenantCode);
        UmAddress umAddress = this.getAddressByCode(map);
        if (umAddress == null) {
            throw new ApiException("um.USER.UmAddressServiceImpl.updateAddress.updateAddressDefault", "\u8bbe\u7f6e\u9ed8\u8ba4\u5730\u5740\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        umAddress.setAddressDefault("1");
        this.updateAddressModel(umAddress);
    }
}

