/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmUserinfoblakMapper;
import com.yqbsoft.laser.service.user.domain.UmUserinfoblakDomain;
import com.yqbsoft.laser.service.user.domain.UmUserinfoblakReDomain;
import com.yqbsoft.laser.service.user.es.SendBlakPollThread;
import com.yqbsoft.laser.service.user.es.SendBlakPutThread;
import com.yqbsoft.laser.service.user.es.SendBlakService;
import com.yqbsoft.laser.service.user.model.UmUserinfoblak;
import com.yqbsoft.laser.service.user.service.UmUserinfoblakService;
import com.yqbsoft.laser.service.user.service.UserBaseService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UmUserinfoblakServiceImpl
extends BaseServiceImpl
implements UmUserinfoblakService {
    private static final String SYS_CODE = "um.USER.UmUserinfoblakServiceImpl";
    private UmUserinfoblakMapper umUserinfoblakMapper;
    private UserBaseService userBaseService;
    private static SendBlakService sendBlakService;
    private static Object lock;
    private String cacheMember = "Blakrange-memberCode";

    public void setUmUserinfoblakMapper(UmUserinfoblakMapper umUserinfoblakMapper) {
        this.umUserinfoblakMapper = umUserinfoblakMapper;
    }

    public UserBaseService getUserBaseService() {
        if (null == this.userBaseService) {
            this.userBaseService = (UserBaseService)ApplicationContextUtil.getService((String)"userBaseService");
        }
        return this.userBaseService;
    }

    private Date getSysDate() {
        try {
            return this.umUserinfoblakMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUserinfoblakServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserinfoblak(UmUserinfoblakDomain umUserinfoblakDomain) {
        if (null == umUserinfoblakDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umUserinfoblakDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserinfoblakDefault(UmUserinfoblak umUserinfoblak) {
        if (null == umUserinfoblak) {
            return;
        }
        if (null == umUserinfoblak.getDataState()) {
            umUserinfoblak.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umUserinfoblak.getGmtCreate()) {
            umUserinfoblak.setGmtCreate(date);
        }
        umUserinfoblak.setGmtModified(date);
        if (StringUtils.isBlank((String)umUserinfoblak.getUserinfoblakCode())) {
            umUserinfoblak.setUserinfoblakCode(this.getNo(null, "UmUserinfoblak", "umUserinfoblak", umUserinfoblak.getTenantCode()));
        }
    }

    private int getUserinfoblakMaxCode() {
        int code = 0;
        try {
            return this.umUserinfoblakMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUserinfoblakServiceImpl.getUserinfoblakMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserinfoblakUpdataDefault(UmUserinfoblak umUserinfoblak) {
        if (null == umUserinfoblak) {
            return;
        }
        umUserinfoblak.setGmtModified(this.getSysDate());
    }

    private void saveUserinfoblakModel(UmUserinfoblak umUserinfoblak) throws ApiException {
        if (null == umUserinfoblak) {
            return;
        }
        try {
            this.umUserinfoblakMapper.insert(umUserinfoblak);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.saveUserinfoblakModel.ex", (Throwable)e);
        }
    }

    private void saveUserinfoblakBatchModel(List<UmUserinfoblak> umUserinfoblakList) throws ApiException {
        if (null == umUserinfoblakList || umUserinfoblakList.isEmpty()) {
            return;
        }
        try {
            this.umUserinfoblakMapper.insertBatch(umUserinfoblakList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.saveUserinfoblakBatchModel.ex", (Throwable)e);
        }
    }

    private UmUserinfoblak getUserinfoblakModelById(Integer userinfoblakId) {
        if (null == userinfoblakId) {
            return null;
        }
        try {
            return this.umUserinfoblakMapper.selectByPrimaryKey(userinfoblakId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUserinfoblakServiceImpl.getUserinfoblakModelById", (Throwable)e);
            return null;
        }
    }

    private UmUserinfoblak getUserinfoblakModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umUserinfoblakMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUserinfoblakServiceImpl.getUserinfoblakModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserinfoblakModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoblakMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.delUserinfoblakModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.delUserinfoblakModelByCode.num");
        }
    }

    private void deleteUserinfoblakModel(Integer userinfoblakId) throws ApiException {
        if (null == userinfoblakId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoblakMapper.deleteByPrimaryKey(userinfoblakId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.deleteUserinfoblakModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.deleteUserinfoblakModel.num");
        }
    }

    private void updateUserinfoblakModel(UmUserinfoblak umUserinfoblak) throws ApiException {
        if (null == umUserinfoblak) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoblakMapper.updateByPrimaryKey(umUserinfoblak);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.updateUserinfoblakModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.updateUserinfoblakModel.num");
        }
    }

    private void updateStateUserinfoblakModel(Integer userinfoblakId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == userinfoblakId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoblakId", userinfoblakId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUserinfoblakMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.updateStateUserinfoblakModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.updateStateUserinfoblakModel.null");
        }
    }

    private void updateStateUserinfoblakModelByCode(String tenantCode, String userinfoblakCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)userinfoblakCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoblakCode", userinfoblakCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUserinfoblakMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.updateStateUserinfoblakModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.updateStateUserinfoblakModelByCode.null");
        }
    }

    private UmUserinfoblak makeUserinfoblak(UmUserinfoblakDomain umUserinfoblakDomain, UmUserinfoblak umUserinfoblak) {
        if (null == umUserinfoblakDomain) {
            return null;
        }
        if (null == umUserinfoblak) {
            umUserinfoblak = new UmUserinfoblak();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoblak, (Object)umUserinfoblakDomain);
            return umUserinfoblak;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUserinfoblakServiceImpl.makeUserinfoblak", (Throwable)e);
            return null;
        }
    }

    private UmUserinfoblakReDomain makeUmUserinfoblakReDomain(UmUserinfoblak umUserinfoblak) {
        if (null == umUserinfoblak) {
            return null;
        }
        UmUserinfoblakReDomain umUserinfoblakReDomain = new UmUserinfoblakReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoblakReDomain, (Object)umUserinfoblak);
            return umUserinfoblakReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUserinfoblakServiceImpl.makeUmUserinfoblakReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmUserinfoblak> queryUserinfoblakModelPage(Map<String, Object> parammap) {
        try {
            return this.umUserinfoblakMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUserinfoblakServiceImpl.queryUserinfoblakModel", (Throwable)e);
            return null;
        }
    }

    private int countUserinfoblak(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserinfoblakMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUserinfoblakServiceImpl.countUserinfoblak", (Throwable)e);
        }
        return i;
    }

    private UmUserinfoblak createUmUserinfoblak(UmUserinfoblakDomain umUserinfoblakDomain) {
        String msg = this.checkUserinfoblak(umUserinfoblakDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.saveUserinfoblak.checkUserinfoblak", msg);
        }
        UmUserinfoblak umUserinfoblak = this.makeUserinfoblak(umUserinfoblakDomain, null);
        this.setUserinfoblakDefault(umUserinfoblak);
        return umUserinfoblak;
    }

    @Override
    public String saveUserinfoblak(UmUserinfoblakDomain umUserinfoblakDomain) throws ApiException {
        UmUserinfoblak umUserinfoblak = this.createUmUserinfoblak(umUserinfoblakDomain);
        this.saveUserinfoblakModel(umUserinfoblak);
        this.queryBlakLoadCache();
        return umUserinfoblak.getUserinfoblakCode();
    }

    @Override
    public String saveUserinfoblakBatch(List<UmUserinfoblakDomain> umUserinfoblakDomainList) throws ApiException {
        if (null == umUserinfoblakDomainList || umUserinfoblakDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmUserinfoblak> umUserinfoblakList = new ArrayList<UmUserinfoblak>();
        String code = "";
        for (UmUserinfoblakDomain umUserinfoblakDomain : umUserinfoblakDomainList) {
            UmUserinfoblak umUserinfoblak = this.createUmUserinfoblak(umUserinfoblakDomain);
            code = umUserinfoblak.getUserinfoblakCode();
            umUserinfoblakList.add(umUserinfoblak);
        }
        this.saveUserinfoblakBatchModel(umUserinfoblakList);
        this.queryBlakLoadCache();
        return code;
    }

    @Override
    public void updateUserinfoblakState(Integer userinfoblakId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateUserinfoblakModel(userinfoblakId, dataState, oldDataState, map);
    }

    @Override
    public void updateUserinfoblakStateByCode(String tenantCode, String userinfoblakCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateUserinfoblakModelByCode(tenantCode, userinfoblakCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUserinfoblak(UmUserinfoblakDomain umUserinfoblakDomain) throws ApiException {
        String msg = this.checkUserinfoblak(umUserinfoblakDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.updateUserinfoblak.checkUserinfoblak", msg);
        }
        UmUserinfoblak oldUmUserinfoblak = this.getUserinfoblakModelById(umUserinfoblakDomain.getUserinfoblakId());
        if (null == oldUmUserinfoblak) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.updateUserinfoblak.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserinfoblak umUserinfoblak = this.makeUserinfoblak(umUserinfoblakDomain, oldUmUserinfoblak);
        this.setUserinfoblakUpdataDefault(umUserinfoblak);
        this.updateUserinfoblakModel(umUserinfoblak);
        this.updateBlakCache(umUserinfoblak);
    }

    @Override
    public UmUserinfoblak getUserinfoblak(Integer userinfoblakId) {
        return this.getUserinfoblakModelById(userinfoblakId);
    }

    @Override
    public void deleteUserinfoblak(Integer userinfoblakId) throws ApiException {
        UmUserinfoblak umUserinfoblak = this.getUserinfoblak(userinfoblakId);
        this.deleteUserinfoblakModel(userinfoblakId);
        this.deleteBlakCache(umUserinfoblak);
    }

    @Override
    public QueryResult<UmUserinfoblak> queryUserinfoblakPage(Map<String, Object> map) {
        List<UmUserinfoblak> umUserinfoblakList = this.queryUserinfoblakModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserinfoblak(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserinfoblakList);
        return queryResult;
    }

    @Override
    public UmUserinfoblak getUserinfoblakByCode(String tenantCode, String userinfoblakCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoblakCode", userinfoblakCode);
        return this.getUserinfoblakModelByCode(map);
    }

    @Override
    public void deleteUserinfoblakByCode(String tenantCode, String userinfoblakCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoblakCode", userinfoblakCode);
        UmUserinfoblak userinfoblakBy = this.getUserinfoblakByCode(tenantCode, userinfoblakCode);
        this.delUserinfoblakModelByCode(map);
        this.deleteBlakCache(userinfoblakBy);
    }

    @Override
    public void saveblakuserByCode() throws ApiException {
        this.saveblak();
    }

    private void saveblak() {
        this.logger.error("=============================");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int startRow = 0;
            boolean flag = true;
            QueryResult<UmUserinfoblak> result = null;
            do {
                startRow = this.getsendBlakService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getsendBlakService().getPage());
                result = this.queryUserinfoblakPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getsendBlakService().addPutPool(new SendBlakPutThread(this.getsendBlakService(), result.getRows()));
                    if (result.getRows().size() != this.getsendBlakService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            this.getsendBlakService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUserinfoblakServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendBlakService getsendBlakService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendBlakService) {
                sendBlakService = new SendBlakService((UserBaseService)SpringApplicationContextUtil.getBean((String)"userBaseService"));
                for (int i = 0; i < 3; ++i) {
                    sendBlakService.addPollPool(new SendBlakPollThread(sendBlakService));
                }
            }
            return sendBlakService;
        }
    }

    @Override
    public void queryBlakLoadCache() {
        this.logger.info("UmUserinfoblakService.queryBlakLoadCache", (Object)"===========start==========");
        List<UmUserinfoblak> userinfoblakList = this.queryUserinfoblakModelPage(null);
        if (null == userinfoblakList || userinfoblakList.isEmpty()) {
            DisUtil.delVer((String)this.cacheMember);
            this.logger.info("UmUserinfoblakService.queryBlakLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> memberMap = new ConcurrentHashMap<String, String>();
        String memberKey = null;
        for (UmUserinfoblak umUserinfoblak : userinfoblakList) {
            String blakRange = "0".equals(umUserinfoblak.getUserinfoblakType()) ? "all" : umUserinfoblak.getMemberScode();
            memberKey = blakRange + "-" + umUserinfoblak.getUserinfoCode() + "-" + umUserinfoblak.getTenantCode();
            memberMap.put(memberKey, memberKey);
        }
        DisUtil.setMapVer((String)this.cacheMember, memberMap);
    }

    private void deleteBlakCache(UmUserinfoblak umUserinfoblak) {
        if (null == umUserinfoblak) {
            return;
        }
        String blakRange = StringUtils.isNotBlank((String)umUserinfoblak.getMemberScode()) ? umUserinfoblak.getMemberScode() : "all";
        DisUtil.delMap((String)this.cacheMember, (String[])new String[]{blakRange + "-" + umUserinfoblak.getUserinfoCode() + "-" + umUserinfoblak.getTenantCode()});
    }

    private void updateBlakCache(UmUserinfoblak umUserinfoblak) {
        if (null == umUserinfoblak) {
            return;
        }
        String blakRange = StringUtils.isNotBlank((String)umUserinfoblak.getMemberScode()) ? umUserinfoblak.getMemberScode() : "all";
        DisUtil.setMapVer((String)this.cacheMember, (String)(blakRange + "-" + umUserinfoblak.getUserinfoCode() + "-" + umUserinfoblak.getTenantCode()), (String)(blakRange + "-" + umUserinfoblak.getUserinfoCode() + "-" + umUserinfoblak.getTenantCode()));
    }

    static {
        lock = new Object();
    }
}

