/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmCollectMapper;
import com.yqbsoft.laser.service.user.domain.UmCollectDomain;
import com.yqbsoft.laser.service.user.domain.UmCollectReDomain;
import com.yqbsoft.laser.service.user.model.UmCollect;
import com.yqbsoft.laser.service.user.service.UmCollectService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmCollectServiceImpl
extends BaseServiceImpl
implements UmCollectService {
    private static final String SYS_CODE = "um.USER.UmCollectServiceImpl";
    private UmCollectMapper umCollectMapper;

    public void setUmCollectMapper(UmCollectMapper umCollectMapper) {
        this.umCollectMapper = umCollectMapper;
    }

    private Date getSysDate() {
        try {
            return this.umCollectMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCollectServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCollect(UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umCollectDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCollectDefault(UmCollect umCollect) {
        if (null == umCollect) {
            return;
        }
        if (null == umCollect.getDataState()) {
            umCollect.setDataState(0);
        }
        if (null == umCollect.getGmtCreate()) {
            umCollect.setGmtCreate(this.getSysDate());
        }
        umCollect.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umCollect.getCollectCode())) {
            umCollect.setCollectCode(this.createUUIDString());
        }
    }

    private int getCollectMaxCode() {
        int code = 0;
        try {
            return this.umCollectMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCollectServiceImpl.getCollectMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCollectUpdataDefault(UmCollect umCollect) {
        if (null == umCollect) {
            return;
        }
        umCollect.setGmtModified(this.getSysDate());
    }

    private void saveCollectModel(UmCollect umCollect) throws ApiException {
        if (null == umCollect) {
            return;
        }
        try {
            this.umCollectMapper.insert(umCollect);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCollectServiceImpl.saveCollectModel.ex", (Throwable)e);
        }
    }

    private void saveCollectBatchModel(List<UmCollect> umCollectList) throws ApiException {
        if (null == umCollectList || umCollectList.isEmpty()) {
            return;
        }
        try {
            this.umCollectMapper.insertBatch(umCollectList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCollectServiceImpl.saveCollectBatchModel.ex", (Throwable)e);
        }
    }

    private UmCollect getCollectModelById(Integer collectId) {
        if (null == collectId) {
            return null;
        }
        try {
            return this.umCollectMapper.selectByPrimaryKey(collectId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCollectServiceImpl.getCollectModelById", (Throwable)e);
            return null;
        }
    }

    private UmCollect getCollectModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umCollectMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCollectServiceImpl.getCollectModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCollectModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umCollectMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCollectServiceImpl.delCollectModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmCollectServiceImpl.delCollectModelByCode.num");
        }
    }

    private void deleteCollectModel(Integer collectId) throws ApiException {
        if (null == collectId) {
            return;
        }
        int i = 0;
        try {
            i = this.umCollectMapper.deleteByPrimaryKey(collectId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCollectServiceImpl.deleteCollectModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmCollectServiceImpl.deleteCollectModel.num");
        }
    }

    private void updateCollectModel(UmCollect umCollect) throws ApiException {
        if (null == umCollect) {
            return;
        }
        int i = 0;
        try {
            i = this.umCollectMapper.updateByPrimaryKeySelective(umCollect);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateCollectModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateCollectModel.num");
        }
    }

    private void updateStateCollectModel(Integer collectId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == collectId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collectId", collectId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umCollectMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateStateCollectModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateStateCollectModel.null");
        }
    }

    private void updateStateCollectModelByCode(String tenantCode, String collectCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)collectCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("collectCode", collectCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umCollectMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateStateCollectModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateStateCollectModelByCode.null");
        }
    }

    private UmCollect makeCollect(UmCollectDomain umCollectDomain, UmCollect umCollect) {
        if (null == umCollectDomain) {
            return null;
        }
        if (null == umCollect) {
            umCollect = new UmCollect();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umCollect, (Object)umCollectDomain);
            return umCollect;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCollectServiceImpl.makeCollect", (Throwable)e);
            return null;
        }
    }

    private UmCollectReDomain makeUmCollectReDomain(UmCollect umCollect) {
        if (null == umCollect) {
            return null;
        }
        UmCollectReDomain umCollectReDomain = new UmCollectReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umCollectReDomain, (Object)umCollect);
            return umCollectReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCollectServiceImpl.makeUmCollectReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmCollect> queryCollectModelPage(Map<String, Object> parammap) {
        try {
            return this.umCollectMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCollectServiceImpl.queryCollectModel", (Throwable)e);
            return null;
        }
    }

    private int countCollect(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umCollectMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCollectServiceImpl.countCollect", (Throwable)e);
        }
        return i;
    }

    private UmCollect createUmCollect(UmCollectDomain umCollectDomain) {
        String msg = this.checkCollect(umCollectDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmCollectServiceImpl.saveCollect.checkCollect", msg);
        }
        UmCollect umCollect = this.makeCollect(umCollectDomain, null);
        this.setCollectDefault(umCollect);
        return umCollect;
    }

    @Override
    public String saveCollect(UmCollectDomain umCollectDomain) throws ApiException {
        UmCollect umCollect = this.createUmCollect(umCollectDomain);
        this.saveCollectModel(umCollect);
        return umCollect.getCollectCode();
    }

    @Override
    public String saveCollectBatch(List<UmCollectDomain> umCollectDomainList) throws ApiException {
        if (null == umCollectDomainList || umCollectDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmCollect> umCollectList = new ArrayList<UmCollect>();
        String code = "";
        for (UmCollectDomain umCollectDomain : umCollectDomainList) {
            UmCollect umCollect = this.createUmCollect(umCollectDomain);
            code = umCollect.getCollectCode();
            umCollectList.add(umCollect);
        }
        this.saveCollectBatchModel(umCollectList);
        return code;
    }

    @Override
    public void updateCollectState(Integer collectId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCollectModel(collectId, dataState, oldDataState);
    }

    @Override
    public void updateCollectStateByCode(String tenantCode, String collectCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCollectModelByCode(tenantCode, collectCode, dataState, oldDataState);
    }

    @Override
    public void updateCollect(UmCollectDomain umCollectDomain) throws ApiException {
        String msg = this.checkCollect(umCollectDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateCollect.checkCollect", msg);
        }
        UmCollect oldUmCollect = this.getCollectModelById(umCollectDomain.getCollectId());
        if (null == oldUmCollect) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateCollect.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmCollect umCollect = this.makeCollect(umCollectDomain, oldUmCollect);
        this.setCollectUpdataDefault(umCollect);
        this.updateCollectModel(umCollect);
    }

    @Override
    public UmCollect getCollect(Integer collectId) {
        return this.getCollectModelById(collectId);
    }

    @Override
    public void deleteCollect(Integer collectId) throws ApiException {
        this.deleteCollectModel(collectId);
    }

    @Override
    public QueryResult<UmCollect> queryCollectPage(Map<String, Object> map) {
        List<UmCollect> umCollectList = this.queryCollectModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCollect(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umCollectList);
        return queryResult;
    }

    @Override
    public UmCollect getCollectByCode(String tenantCode, String collectCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("collectCode", collectCode);
        return this.getCollectModelByCode(map);
    }

    @Override
    public void deleteCollectByCode(String tenantCode, String collectCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("collectCode", collectCode);
        this.delCollectModelByCode(map);
    }

    @Override
    public void updateCollectByOpCode(Map<String, Object> map) throws ApiException {
        String msg = this.checkCollectByMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateCollectByOpCode.checkCollectByMap", msg);
        }
        Map<String, Object> paramMap = this.makeMap(map);
        this.updateCollectByOpCodeModel(paramMap);
    }

    @Override
    public void updateCollectDataStateByOpCode(Map<String, Object> map) throws ApiException {
        String msg = this.checkCollectDataByMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateCollectByOpCode.updateCollectDataStateByOpCode", msg);
        }
        this.updateCollectByOpCodeModel(map);
    }

    private Map<String, Object> makeMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("collectOpcode", map.get("skuCode"));
        paramMap.put("tenantCode", map.get("tenantCode"));
        paramMap.put("collectOpnum", map.get("pricesetNprice"));
        paramMap.put("collectOppic", map.get("dataPic"));
        paramMap.put("collectOpcont", map.get("goodsName"));
        paramMap.put("dataState", map.get("dataState"));
        return paramMap;
    }

    private String checkCollectByMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            msg = msg + "tenantCode is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("skuCode")))) {
            msg = msg + "skuCode is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("pricesetNprice")))) {
            msg = msg + "collectOpnum is null";
        }
        return msg;
    }

    private String checkCollectDataByMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            msg = msg + "tenantCode is null";
        }
        return msg;
    }

    private void updateCollectByOpCodeModel(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        try {
            this.umCollectMapper.updateByOpCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCollectServiceImpl.updateCollectByOpCodeModel.ex", (Throwable)e);
        }
    }
}

