/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmDepartmentMapper;
import com.yqbsoft.laser.service.user.domain.UmDepartmentDomain;
import com.yqbsoft.laser.service.user.domain.UmDepartmentReDomain;
import com.yqbsoft.laser.service.user.model.UmDepartment;
import com.yqbsoft.laser.service.user.service.UmDepartmentService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmDepartmentServiceImpl
extends BaseServiceImpl
implements UmDepartmentService {
    private static final String SYS_CODE = "um.USER.UmDepartmentServiceImpl";
    private UmDepartmentMapper umDepartmentMapper;

    public void setUmDepartmentMapper(UmDepartmentMapper umDepartmentMapper) {
        this.umDepartmentMapper = umDepartmentMapper;
    }

    private Date getSysDate() {
        try {
            return this.umDepartmentMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmDepartmentServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDepartment(UmDepartmentDomain umDepartmentDomain) {
        if (null == umDepartmentDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umDepartmentDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDepartmentDefault(UmDepartment umDepartment) {
        if (null == umDepartment) {
            return;
        }
        if (null == umDepartment.getDataState()) {
            umDepartment.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umDepartment.getGmtCreate()) {
            umDepartment.setGmtCreate(date);
        }
        umDepartment.setGmtModified(date);
        if (StringUtils.isBlank((String)umDepartment.getDepartmentCode())) {
            umDepartment.setDepartmentCode(this.getNo(null, "UmDepartment", "umDepartment", umDepartment.getTenantCode()));
        }
    }

    private int getDepartmentMaxCode() {
        int code = 0;
        try {
            return this.umDepartmentMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmDepartmentServiceImpl.getDepartmentMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDepartmentUpdataDefault(UmDepartment umDepartment) {
        if (null == umDepartment) {
            return;
        }
        umDepartment.setGmtModified(this.getSysDate());
    }

    private void saveDepartmentModel(UmDepartment umDepartment) throws ApiException {
        if (null == umDepartment) {
            return;
        }
        try {
            this.umDepartmentMapper.insert(umDepartment);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.saveDepartmentModel.ex", (Throwable)e);
        }
    }

    private void saveDepartmentBatchModel(List<UmDepartment> umDepartmentList) throws ApiException {
        if (null == umDepartmentList || umDepartmentList.isEmpty()) {
            return;
        }
        try {
            this.umDepartmentMapper.insertBatch(umDepartmentList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.saveDepartmentBatchModel.ex", (Throwable)e);
        }
    }

    private UmDepartment getDepartmentModelById(Integer departmentId) {
        if (null == departmentId) {
            return null;
        }
        try {
            return this.umDepartmentMapper.selectByPrimaryKey(departmentId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmDepartmentServiceImpl.getDepartmentModelById", (Throwable)e);
            return null;
        }
    }

    private UmDepartment getDepartmentModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umDepartmentMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmDepartmentServiceImpl.getDepartmentModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDepartmentModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umDepartmentMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.delDepartmentModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.delDepartmentModelByCode.num");
        }
    }

    private void deleteDepartmentModel(Integer departmentId) throws ApiException {
        if (null == departmentId) {
            return;
        }
        int i = 0;
        try {
            i = this.umDepartmentMapper.deleteByPrimaryKey(departmentId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.deleteDepartmentModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.deleteDepartmentModel.num");
        }
    }

    private void updateDepartmentModel(UmDepartment umDepartment) throws ApiException {
        if (null == umDepartment) {
            return;
        }
        int i = 0;
        try {
            i = this.umDepartmentMapper.updateByPrimaryKeySelective(umDepartment);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.updateDepartmentModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.updateDepartmentModel.num");
        }
    }

    private void updateStateDepartmentModel(Integer departmentId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == departmentId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("departmentId", departmentId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umDepartmentMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.updateStateDepartmentModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.updateStateDepartmentModel.null");
        }
    }

    private void updateStateDepartmentModelByCode(String tenantCode, String departmenCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)departmenCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departmenCode", departmenCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umDepartmentMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.updateStateDepartmentModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.updateStateDepartmentModelByCode.null");
        }
    }

    private UmDepartment makeDepartment(UmDepartmentDomain umDepartmentDomain, UmDepartment umDepartment) {
        if (null == umDepartmentDomain) {
            return null;
        }
        if (null == umDepartment) {
            umDepartment = new UmDepartment();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umDepartment, (Object)umDepartmentDomain);
            return umDepartment;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmDepartmentServiceImpl.makeDepartment", (Throwable)e);
            return null;
        }
    }

    private UmDepartmentReDomain makeUmDepartmentReDomain(UmDepartment umDepartment) {
        if (null == umDepartment) {
            return null;
        }
        UmDepartmentReDomain umDepartmentReDomain = new UmDepartmentReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umDepartmentReDomain, (Object)umDepartment);
            return umDepartmentReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmDepartmentServiceImpl.makeUmDepartmentReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmDepartment> queryDepartmentModelPage(Map<String, Object> parammap) {
        try {
            return this.umDepartmentMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmDepartmentServiceImpl.queryDepartmentModel", (Throwable)e);
            return null;
        }
    }

    private int countDepartment(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umDepartmentMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmDepartmentServiceImpl.countDepartment", (Throwable)e);
        }
        return i;
    }

    private UmDepartment createUmDepartment(UmDepartmentDomain umDepartmentDomain) {
        String msg = this.checkDepartment(umDepartmentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.saveDepartment.checkDepartment", msg);
        }
        UmDepartment umDepartment = this.makeDepartment(umDepartmentDomain, null);
        this.setDepartmentDefault(umDepartment);
        return umDepartment;
    }

    @Override
    public String saveDepartment(UmDepartmentDomain umDepartmentDomain) throws ApiException {
        UmDepartment umDepartment = this.createUmDepartment(umDepartmentDomain);
        this.saveDepartmentModel(umDepartment);
        return umDepartment.getDepartmentCode();
    }

    @Override
    public String saveDepartmentBatch(List<UmDepartmentDomain> umDepartmentDomainList) throws ApiException {
        if (null == umDepartmentDomainList || umDepartmentDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmDepartment> umDepartmentList = new ArrayList<UmDepartment>();
        String code = "";
        for (UmDepartmentDomain umDepartmentDomain : umDepartmentDomainList) {
            UmDepartment umDepartment = this.createUmDepartment(umDepartmentDomain);
            code = umDepartment.getDepartmentCode();
            umDepartmentList.add(umDepartment);
        }
        this.saveDepartmentBatchModel(umDepartmentList);
        return code;
    }

    @Override
    public void updateDepartmentState(Integer departmentId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == departmentId) {
            return;
        }
        this.updateStateDepartmentModel(departmentId, dataState, oldDataState, map);
    }

    @Override
    public void updateDepartmentStateByCode(String tenantCode, String departmenCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)departmenCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDepartmentModelByCode(tenantCode, departmenCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDepartment(UmDepartmentDomain umDepartmentDomain) throws ApiException {
        String msg = this.checkDepartment(umDepartmentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.updateDepartment.checkDepartment", msg);
        }
        UmDepartment oldUmDepartment = this.getDepartmentModelById(umDepartmentDomain.getDepartmentId());
        if (null == oldUmDepartment) {
            throw new ApiException("um.USER.UmDepartmentServiceImpl.updateDepartment.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmDepartment umDepartment = this.makeDepartment(umDepartmentDomain, oldUmDepartment);
        this.setDepartmentUpdataDefault(umDepartment);
        this.updateDepartmentModel(umDepartment);
    }

    @Override
    public UmDepartment getDepartment(Integer departmentId) {
        if (null == departmentId) {
            return null;
        }
        return this.getDepartmentModelById(departmentId);
    }

    @Override
    public void deleteDepartment(Integer departmentId) throws ApiException {
        if (null == departmentId) {
            return;
        }
        this.deleteDepartmentModel(departmentId);
    }

    @Override
    public QueryResult<UmDepartment> queryDepartmentPage(Map<String, Object> map) {
        List<UmDepartment> umDepartmentList = this.queryDepartmentModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDepartment(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umDepartmentList);
        return queryResult;
    }

    @Override
    public UmDepartment getDepartmentByCode(String tenantCode, String departmenCode) throws ApiException {
        if (StringUtils.isBlank((String)departmenCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departmenCode", departmenCode);
        return this.getDepartmentModelByCode(map);
    }

    @Override
    public void deleteDepartmentByCode(String tenantCode, String departmenCode) throws ApiException {
        if (StringUtils.isBlank((String)departmenCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departmenCode", departmenCode);
        this.delDepartmentModelByCode(map);
    }
}

