/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.userpointsmanager.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.userpointsmanager.dao.UpmUpointsClearMapper;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmUpointsClearDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmUpointsClearReDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmUpointsSaveDomain;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmPoints;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmPointsRule;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmUpointsClear;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmUpointsClearService;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmUpointsService;
import com.yqbsoft.laser.service.userpointsmanager.service.impl.UpointsClearPollThread;
import com.yqbsoft.laser.service.userpointsmanager.service.impl.UpointsClearService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpmUpointsClearServiceImpl
extends BaseServiceImpl
implements UpmUpointsClearService {
    private static final String SYS_CODE = "upm.UpmUpointsClearServiceImpl";
    private UpmUpointsService upmUpointsService;
    private UpmUpointsClearMapper upmUpointsClearMapper;
    private static UpointsClearService upointsClearService;
    private static Object lock;

    public UpmUpointsService getUpmUpointsService() {
        return this.upmUpointsService;
    }

    public void setUpmUpointsService(UpmUpointsService upmUpointsService) {
        this.upmUpointsService = upmUpointsService;
    }

    public void setUpmUpointsClearMapper(UpmUpointsClearMapper upmUpointsClearMapper) {
        this.upmUpointsClearMapper = upmUpointsClearMapper;
    }

    private Date getSysDate() {
        try {
            return this.upmUpointsClearMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmUpointsClearServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUpointsClear(UpmUpointsClearDomain upmUpointsClearDomain) {
        if (null == upmUpointsClearDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upmUpointsClearDomain.getUpointsType())) {
            msg = msg + "UpointsType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)upmUpointsClearDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)upmUpointsClearDomain.getPointsRuleApi())) {
            msg = msg + "PointsRuleApi\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)upmUpointsClearDomain.getUpointsClearOpcode())) {
            msg = msg + "UpointsClearOpcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)upmUpointsClearDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUpointsClearDefault(UpmUpointsClear upmUpointsClear) {
        if (null == upmUpointsClear) {
            return;
        }
        if (null == upmUpointsClear.getDataState()) {
            upmUpointsClear.setDataState(0);
        }
        if (null == upmUpointsClear.getGmtCreate()) {
            upmUpointsClear.setGmtCreate(this.getSysDate());
        }
        upmUpointsClear.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)upmUpointsClear.getUpointsClearCode())) {
            upmUpointsClear.setUpointsClearCode(this.createUUIDString());
        }
    }

    private int getUpointsClearMaxCode() {
        int code = 0;
        try {
            return this.upmUpointsClearMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmUpointsClearServiceImpl.getUpointsClearMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpointsClearUpdataDefault(UpmUpointsClear upmUpointsClear) {
        if (null == upmUpointsClear) {
            return;
        }
        upmUpointsClear.setGmtModified(this.getSysDate());
    }

    private void saveUpointsClearModel(UpmUpointsClear upmUpointsClear) throws ApiException {
        if (null == upmUpointsClear) {
            return;
        }
        try {
            this.upmUpointsClearMapper.insert(upmUpointsClear);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.saveUpointsClearModel.ex", (Throwable)e);
        }
    }

    private void saveUpointsClearBatchModel(List<UpmUpointsClear> upmUpointsClearList) throws ApiException {
        if (null == upmUpointsClearList || upmUpointsClearList.isEmpty()) {
            return;
        }
        try {
            this.upmUpointsClearMapper.insertBatch(upmUpointsClearList);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.saveUpointsClearBatchModel.ex", (Throwable)e);
        }
    }

    private UpmUpointsClear getUpointsClearModelById(Integer upointsClearId) {
        if (null == upointsClearId) {
            return null;
        }
        try {
            return this.upmUpointsClearMapper.selectByPrimaryKey(upointsClearId);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmUpointsClearServiceImpl.getUpointsClearModelById", (Throwable)e);
            return null;
        }
    }

    private UpmUpointsClear getUpointsClearModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upmUpointsClearMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmUpointsClearServiceImpl.getUpointsClearModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUpointsClearModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upmUpointsClearMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.delUpointsClearModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.delUpointsClearModelByCode.num");
        }
    }

    private void deleteUpointsClearModel(Integer upointsClearId) throws ApiException {
        if (null == upointsClearId) {
            return;
        }
        int i = 0;
        try {
            i = this.upmUpointsClearMapper.deleteByPrimaryKey(upointsClearId);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.deleteUpointsClearModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.deleteUpointsClearModel.num");
        }
    }

    private void updateUpointsClearModel(UpmUpointsClear upmUpointsClear) throws ApiException {
        if (null == upmUpointsClear) {
            return;
        }
        int i = 0;
        try {
            i = this.upmUpointsClearMapper.updateByPrimaryKeySelective(upmUpointsClear);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.updateUpointsClearModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.updateUpointsClearModel.num");
        }
    }

    private void updateStateUpointsClearModel(Integer upointsClearId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == upointsClearId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upointsClearId", upointsClearId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.upmUpointsClearMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.updateStateUpointsClearModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.updateStateUpointsClearModel.null");
        }
    }

    private void updateStateUpointsClearModelByCode(String tenantCode, String upointsClearCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)upointsClearCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsClearCode", upointsClearCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.upmUpointsClearMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.updateStateUpointsClearModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.updateStateUpointsClearModelByCode.null");
        }
    }

    private UpmUpointsClear makeUpointsClear(UpmUpointsClearDomain upmUpointsClearDomain, UpmUpointsClear upmUpointsClear) {
        if (null == upmUpointsClearDomain) {
            return null;
        }
        if (null == upmUpointsClear) {
            upmUpointsClear = new UpmUpointsClear();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upmUpointsClear, (Object)upmUpointsClearDomain);
            return upmUpointsClear;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmUpointsClearServiceImpl.makeUpointsClear", (Throwable)e);
            return null;
        }
    }

    private UpmUpointsClearReDomain makeUpmUpointsClearReDomain(UpmUpointsClear upmUpointsClear) {
        if (null == upmUpointsClear) {
            return null;
        }
        UpmUpointsClearReDomain upmUpointsClearReDomain = new UpmUpointsClearReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upmUpointsClearReDomain, (Object)upmUpointsClear);
            return upmUpointsClearReDomain;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmUpointsClearServiceImpl.makeUpmUpointsClearReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UpmUpointsClear> queryUpointsClearModelPage(Map<String, Object> parammap) {
        try {
            return this.upmUpointsClearMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmUpointsClearServiceImpl.queryUpointsClearModel", (Throwable)e);
            return null;
        }
    }

    private int countUpointsClear(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upmUpointsClearMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmUpointsClearServiceImpl.countUpointsClear", (Throwable)e);
        }
        return i;
    }

    private UpmUpointsClear createUpmUpointsClear(UpmUpointsClearDomain upmUpointsClearDomain) {
        String msg = this.checkUpointsClear(upmUpointsClearDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.createUpmUpointsClear.checkUpointsClear", msg);
        }
        UpmUpointsClear upmUpointsClear = this.makeUpointsClear(upmUpointsClearDomain, null);
        this.setUpointsClearDefault(upmUpointsClear);
        return upmUpointsClear;
    }

    @Override
    public String sendUpointsClear(UpmUpointsClearDomain upmUpointsClearDomain) throws ApiException {
        UpmUpointsClear upmUpointsClear = this.saveUpointsClearReModel(upmUpointsClearDomain);
        if (null == upmUpointsClear) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.saveUpointsClear.null");
        }
        this.getUpointsClearService().putQueue(upmUpointsClear);
        return upmUpointsClear.getUpointsClearCode();
    }

    @Override
    public String saveUpointsClearToPoints(UpmUpointsClear upmUpointsClear) throws ApiException {
        if (null == upmUpointsClear) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.saveUpointsClearToPoints.null");
        }
        String upmPointsStr = DisUtil.getMap((String)"UpmPoints-type", (String)(upmUpointsClear.getUpointsType() + "-" + upmUpointsClear.getTenantCode()));
        if (StringUtils.isBlank((String)upmPointsStr)) {
            return null;
        }
        UpmPoints upmPoints = (UpmPoints)JsonUtil.buildNormalBinder().getJsonToObject(upmPointsStr, UpmPoints.class);
        if (null == upmPoints) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.saveUpointsClearToPoints.upmPoints");
        }
        if (!"0".equals(upmPoints.getPointsStart())) {
            return null;
        }
        String upmPointsRuleStr = DisUtil.getMap((String)"UpmPointsRule-api", (String)(upmUpointsClear.getUpointsType() + "-" + upmUpointsClear.getPointsRuleApi() + "-" + upmUpointsClear.getTenantCode()));
        if (StringUtils.isBlank((String)upmPointsRuleStr)) {
            return null;
        }
        UpmPointsRule upmPointsRule = (UpmPointsRule)JsonUtil.buildNormalBinder().getJsonToObject(upmPointsRuleStr, UpmPointsRule.class);
        if (null == upmPointsRule) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.saveUpointsClearToPoints.upmPointsRule");
        }
        UpmUpointsSaveDomain upmUpointsSaveDomain = this.makeUpoints(upmUpointsClear, upmPointsRule, upmPoints);
        if (null == upmUpointsSaveDomain) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.saveUpointsClearToPoints.upmUpointsSaveDomain");
        }
        this.updateStateUpointsClearModel(upmUpointsClear.getUpointsClearId(), 1, 0);
        this.upmUpointsService.saveUpointsByList(upmUpointsSaveDomain);
        return null;
    }

    private UpmUpointsSaveDomain makeUpoints(UpmUpointsClear upmUpointsClear, UpmPointsRule upmPointsRule, UpmPoints upmPoints) {
        if (null == upmPointsRule || null == upmPoints || null == upmUpointsClear) {
            return null;
        }
        UpmUpointsSaveDomain upmUpointsSaveDomain = new UpmUpointsSaveDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upmUpointsSaveDomain, (Object)upmUpointsClear);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmUpointsClearServiceImpl.makeUpoints.e", (Throwable)e);
            return null;
        }
        if (null == upmPointsRule.getPointsRuleRatio()) {
            upmPointsRule.setPointsRuleRatio(new BigDecimal("1"));
        }
        upmUpointsSaveDomain.setPointsRuleCode(upmPointsRule.getPointsRuleCode());
        upmUpointsSaveDomain.setPointsRuleName(upmPointsRule.getPointsRuleName());
        upmUpointsSaveDomain.setUpointsListDirection(upmUpointsClear.getUpointsClearDirection());
        upmUpointsSaveDomain.setUpointsListNum(upmPointsRule.getPointsRuleRatio().multiply(upmUpointsClear.getUpointsClearNum()));
        upmUpointsSaveDomain.setUpointsListOpcode(upmUpointsClear.getUpointsClearOpcode());
        upmUpointsSaveDomain.setUpointsListOpmark(upmUpointsClear.getUpointsClearOpmark());
        upmUpointsSaveDomain.setUpointsListRemark(upmUpointsClear.getUpointsClearRemark());
        return upmUpointsSaveDomain;
    }

    @Override
    public String saveUpointsClear(UpmUpointsClearDomain upmUpointsClearDomain) throws ApiException {
        UpmUpointsClear upmUpointsClear = this.saveUpointsClearReModel(upmUpointsClearDomain);
        if (null == upmUpointsClear) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.saveUpointsClear.null");
        }
        return upmUpointsClear.getUpointsClearCode();
    }

    private UpmUpointsClear saveUpointsClearReModel(UpmUpointsClearDomain upmUpointsClearDomain) {
        UpmUpointsClear upmUpointsClear = this.createUpmUpointsClear(upmUpointsClearDomain);
        this.saveUpointsClearModel(upmUpointsClear);
        return upmUpointsClear;
    }

    @Override
    public String saveUpointsClearBatch(List<UpmUpointsClearDomain> upmUpointsClearDomainList) throws ApiException {
        if (null == upmUpointsClearDomainList || upmUpointsClearDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UpmUpointsClear> upmUpointsClearList = new ArrayList<UpmUpointsClear>();
        String code = "";
        for (UpmUpointsClearDomain upmUpointsClearDomain : upmUpointsClearDomainList) {
            UpmUpointsClear upmUpointsClear = this.createUpmUpointsClear(upmUpointsClearDomain);
            code = upmUpointsClear.getUpointsClearCode();
            upmUpointsClearList.add(upmUpointsClear);
        }
        this.saveUpointsClearBatchModel(upmUpointsClearList);
        return code;
    }

    @Override
    public void updateUpointsClearState(Integer upointsClearId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUpointsClearModel(upointsClearId, dataState, oldDataState);
    }

    @Override
    public void updateUpointsClearStateByCode(String tenantCode, String upointsClearCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUpointsClearModelByCode(tenantCode, upointsClearCode, dataState, oldDataState);
    }

    @Override
    public void updateUpointsClear(UpmUpointsClearDomain upmUpointsClearDomain) throws ApiException {
        String msg = this.checkUpointsClear(upmUpointsClearDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.updateUpointsClear.checkUpointsClear", msg);
        }
        UpmUpointsClear oldUpmUpointsClear = this.getUpointsClearModelById(upmUpointsClearDomain.getUpointsClearId());
        if (null == oldUpmUpointsClear) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.updateUpointsClear.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpmUpointsClear upmUpointsClear = this.makeUpointsClear(upmUpointsClearDomain, oldUpmUpointsClear);
        this.setUpointsClearUpdataDefault(upmUpointsClear);
        this.updateUpointsClearModel(upmUpointsClear);
    }

    @Override
    public UpmUpointsClear getUpointsClear(Integer upointsClearId) {
        return this.getUpointsClearModelById(upointsClearId);
    }

    @Override
    public void deleteUpointsClear(Integer upointsClearId) throws ApiException {
        this.deleteUpointsClearModel(upointsClearId);
    }

    @Override
    public QueryResult<UpmUpointsClear> queryUpointsClearPage(Map<String, Object> map) {
        List<UpmUpointsClear> upmUpointsClearList = this.queryUpointsClearModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUpointsClear(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upmUpointsClearList);
        return queryResult;
    }

    @Override
    public UpmUpointsClear getUpointsClearByCode(String tenantCode, String upointsClearCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsClearCode", upointsClearCode);
        return this.getUpointsClearModelByCode(map);
    }

    @Override
    public void deleteUpointsClearByCode(String tenantCode, String upointsClearCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsClearCode", upointsClearCode);
        this.delUpointsClearModelByCode(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpointsClearService getUpointsClearService() {
        Object object = lock;
        synchronized (object) {
            if (null == upointsClearService) {
                upointsClearService = new UpointsClearService((UpmUpointsClearService)SpringApplicationContextUtil.getBean((String)"upmUpointsClearService"));
                upointsClearService.addPollPool(new UpointsClearPollThread(upointsClearService));
                upointsClearService.addPollPool(new UpointsClearPollThread(upointsClearService));
                upointsClearService.addPollPool(new UpointsClearPollThread(upointsClearService));
                upointsClearService.addPollPool(new UpointsClearPollThread(upointsClearService));
                upointsClearService.addPollPool(new UpointsClearPollThread(upointsClearService));
            }
            return upointsClearService;
        }
    }

    @Override
    public void loadUpointsClearProcess() {
        this.loadSendDb();
    }

    private void loadSendDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", 0);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<UpmUpointsClear> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getUpointsClearService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getUpointsClearService().getPage());
                result = this.queryUpointsClearPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    for (UpmUpointsClear upmUpointsClear : result.getRows()) {
                        this.getUpointsClearService().putQueue(upmUpointsClear);
                    }
                    if (result.getRows().size() == this.getUpointsClearService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getUpointsClearService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmUpointsClearServiceImpl.loadSendDb.e", (Throwable)e);
        }
    }

    static {
        lock = new Object();
    }
}

