/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.userpointsmanager.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.userpointsmanager.UserPointsManagerConstants;
import com.yqbsoft.laser.service.userpointsmanager.dao.UpmPointsMapper;
import com.yqbsoft.laser.service.userpointsmanager.domain.UmUserDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsReDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsRuleDomain;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmPoints;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmPointsRule;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmPointsRuleService;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmPointsService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;

public class UpmPointsServiceImpl
extends BaseServiceImpl
implements UpmPointsService {
    private static final String SYS_CODE = "upm.UpmPointsServiceImpl";
    private UpmPointsMapper upmPointsMapper;
    private UpmPointsRuleService upmPointsRuleService;
    private String cachekey = "UpmPoints-type";

    public void setUpmPointsMapper(UpmPointsMapper upmPointsMapper) {
        this.upmPointsMapper = upmPointsMapper;
    }

    public void setUpmPointsRuleService(UpmPointsRuleService upmPointsRuleService) {
        this.upmPointsRuleService = upmPointsRuleService;
    }

    private Date getSysDate() {
        try {
            return this.upmPointsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPoints(UpmPointsDomain upmPointsDomain) {
        if (null == upmPointsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upmPointsDomain.getUpointsType())) {
            msg = msg + "UpointsType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)upmPointsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsDefault(UpmPoints upmPoints) {
        if (null == upmPoints) {
            return;
        }
        if (null == upmPoints.getDataState()) {
            upmPoints.setDataState(0);
        }
        if (null == upmPoints.getGmtCreate()) {
            upmPoints.setGmtCreate(this.getSysDate());
        }
        upmPoints.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)upmPoints.getPointsCode())) {
            upmPoints.setPointsCode(this.createUUIDString());
        }
    }

    private int getPointsMaxCode() {
        int code = 0;
        try {
            return this.upmPointsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsServiceImpl.getPointsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsUpdataDefault(UpmPoints upmPoints) {
        if (null == upmPoints) {
            return;
        }
        upmPoints.setGmtModified(this.getSysDate());
    }

    private void savePointsModel(UpmPoints upmPoints) throws ApiException {
        if (null == upmPoints) {
            return;
        }
        try {
            this.upmPointsMapper.insert(upmPoints);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsServiceImpl.savePointsModel.ex", (Throwable)e);
        }
    }

    private void savePointsBatchModel(List<UpmPoints> upmPointsList) throws ApiException {
        if (null == upmPointsList || upmPointsList.isEmpty()) {
            return;
        }
        try {
            this.upmPointsMapper.insertBatch(upmPointsList);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsServiceImpl.savePointsBatchModel.ex", (Throwable)e);
        }
    }

    private UpmPoints getPointsModelById(Integer pointsId) {
        if (null == pointsId) {
            return null;
        }
        try {
            return this.upmPointsMapper.selectByPrimaryKey(pointsId);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsServiceImpl.getPointsModelById", (Throwable)e);
            return null;
        }
    }

    private UpmPoints getPointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upmPointsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsServiceImpl.getPointsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsServiceImpl.delPointsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsServiceImpl.delPointsModelByCode.num");
        }
    }

    private void deletePointsModel(Integer pointsId) throws ApiException {
        if (null == pointsId) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsMapper.deleteByPrimaryKey(pointsId);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsServiceImpl.deletePointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsServiceImpl.deletePointsModel.num");
        }
    }

    private void updatePointsModel(UpmPoints upmPoints) throws ApiException {
        if (null == upmPoints) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsMapper.updateByPrimaryKeySelective(upmPoints);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsServiceImpl.updatePointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsServiceImpl.updatePointsModel.num");
        }
    }

    private void updateStatePointsModel(Integer pointsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pointsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsId", pointsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.upmPointsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsServiceImpl.updateStatePointsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmPointsServiceImpl.updateStatePointsModel.null");
        }
    }

    private void updateStatePointsModelByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.upmPointsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsServiceImpl.updateStatePointsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmPointsServiceImpl.updateStatePointsModelByCode.null");
        }
    }

    private UpmPoints makePoints(UpmPointsDomain upmPointsDomain, UpmPoints upmPoints) {
        if (null == upmPointsDomain) {
            return null;
        }
        if (null == upmPoints) {
            upmPoints = new UpmPoints();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upmPoints, (Object)upmPointsDomain);
            return upmPoints;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsServiceImpl.makePoints", (Throwable)e);
            return null;
        }
    }

    private UpmPointsReDomain makeUpmPointsReDomain(UpmPoints upmPoints) {
        if (null == upmPoints) {
            return null;
        }
        UpmPointsReDomain upmPointsReDomain = new UpmPointsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsReDomain, (Object)upmPoints);
            return upmPointsReDomain;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsServiceImpl.makeUpmPointsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UpmPoints> queryPointsModelPage(Map<String, Object> parammap) {
        try {
            return this.upmPointsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsServiceImpl.queryPointsModel", (Throwable)e);
            return null;
        }
    }

    private int countPoints(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upmPointsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsServiceImpl.countPoints", (Throwable)e);
        }
        return i;
    }

    private UpmPoints createUpmPoints(UpmPointsDomain upmPointsDomain) {
        String msg = this.checkPoints(upmPointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsServiceImpl.savePoints.checkPoints", msg);
        }
        UpmPoints upmPoints = this.makePoints(upmPointsDomain, null);
        this.setPointsDefault(upmPoints);
        return upmPoints;
    }

    @Override
    public String savePoints(UpmPointsDomain upmPointsDomain) throws ApiException {
        UpmPoints upmPoints = this.createUpmPoints(upmPointsDomain);
        this.savePointsModel(upmPoints);
        return upmPoints.getPointsCode();
    }

    @Override
    public String savePointsBatch(List<UpmPointsDomain> upmPointsDomainList) throws ApiException {
        if (null == upmPointsDomainList || upmPointsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UpmPoints> upmPointsList = new ArrayList<UpmPoints>();
        String code = "";
        for (UpmPointsDomain upmPointsDomain : upmPointsDomainList) {
            UpmPoints upmPoints = this.createUpmPoints(upmPointsDomain);
            code = upmPoints.getPointsCode();
            upmPointsList.add(upmPoints);
        }
        this.savePointsBatchModel(upmPointsList);
        return code;
    }

    @Override
    public void updatePointsState(Integer pointsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePointsModel(pointsId, dataState, oldDataState);
        this.updatePointsDisById(dataState, pointsId);
    }

    @Override
    public void updatePointsStateByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePointsModelByCode(tenantCode, pointsCode, dataState, oldDataState);
        this.updatePointsDisByCode(dataState, tenantCode, pointsCode);
    }

    @Override
    public void updatePoints(UpmPointsDomain upmPointsDomain) throws ApiException {
        String msg = this.checkPoints(upmPointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsServiceImpl.updatePoints.checkPoints", msg);
        }
        UpmPoints oldUpmPoints = this.getPointsModelById(upmPointsDomain.getPointsId());
        if (null == oldUpmPoints) {
            throw new ApiException("upm.UpmPointsServiceImpl.updatePoints.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpmPoints upmPoints = this.makePoints(upmPointsDomain, oldUpmPoints);
        this.setPointsUpdataDefault(upmPoints);
        this.updatePointsModel(upmPoints);
        this.updatePointsDisById(upmPoints.getDataState(), upmPoints.getPointsId());
    }

    private void updatePointsDisById(Integer dataState, Integer pointsId) {
        UpmPoints upmPoints = this.getPoints(pointsId);
        if (null == upmPoints) {
            return;
        }
        if (StringUtils.isEmpty((String)upmPoints.getMemberMcode())) {
            upmPoints.setMemberMcode("all");
        }
        String key = upmPoints.getUpointsType() + "-" + upmPoints.getMemberMcode() + "-" + upmPoints.getLevelUserqua() + "-" + upmPoints.getTenantCode();
        if (1 == dataState) {
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)upmPoints));
        } else if (0 == dataState) {
            DisUtil.delMap((String)this.cachekey, (String[])new String[]{key});
        }
    }

    private void updatePointsDisByCode(Integer dataState, String tenantCode, String pointsCode) {
        UpmPoints upmPoints = this.getPointsByCode(tenantCode, pointsCode);
        if (null == upmPoints) {
            return;
        }
        if (StringUtils.isEmpty((String)upmPoints.getMemberMcode())) {
            upmPoints.setMemberMcode("all");
        }
        String key = upmPoints.getUpointsType() + "-" + upmPoints.getMemberMcode() + "-" + upmPoints.getLevelUserqua() + "-" + upmPoints.getTenantCode();
        if (1 == dataState) {
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)upmPoints));
        } else if (0 == dataState) {
            DisUtil.delMap((String)this.cachekey, (String[])new String[]{key});
        }
    }

    @Override
    public UpmPoints getPoints(Integer pointsId) {
        return this.getPointsModelById(pointsId);
    }

    @Override
    public void deletePoints(Integer pointsId) throws ApiException {
        this.updatePointsDisById(0, pointsId);
        this.deletePointsModel(pointsId);
    }

    @Override
    public QueryResult<UpmPoints> queryPointsPage(Map<String, Object> map) {
        List<UpmPoints> upmPointsList = this.queryPointsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upmPointsList);
        return queryResult;
    }

    @Override
    public UpmPoints getPointsByCode(String tenantCode, String pointsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        return this.getPointsModelByCode(map);
    }

    @Override
    public void deletePointsByCode(String tenantCode, String pointsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        this.updatePointsDisByCode(0, tenantCode, pointsCode);
        this.delPointsModelByCode(map);
    }

    @Override
    public void queryPointsCache() {
        this.logger.info("UpmPointsServiceImpl.queryPointsCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<UpmPoints> list = this.queryPointsModelPage(parammap);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("UpmPointsServiceImpl.queryPointsCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (UpmPoints upmPoints : list) {
            if (StringUtils.isBlank((String)upmPoints.getMemberMcode())) {
                upmPoints.setMemberMcode("all");
            }
            if (!StringUtils.isNotBlank((String)upmPoints.getUpointsType())) continue;
            String key = upmPoints.getUpointsType() + "-" + upmPoints.getMemberMcode() + "-" + upmPoints.getLevelUserqua() + "-" + upmPoints.getTenantCode();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)upmPoints));
        }
        DisUtil.setMapVer((String)this.cachekey, map);
        this.logger.info("UpmPointsServiceImpl.queryPointsCache", (Object)"===========add-end==========");
    }

    @Override
    public String saveInitializationByUser(UmUserinfoDomain umUserinfo, UmUserDomain umUser, String optype) throws ApiException {
        if (null == umUserinfo) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberMcode", umUserinfo.getUserinfoCode());
        map.put("memberMname", umUserinfo.getUserinfoCompname());
        map.put("tenantCode", umUserinfo.getTenantCode());
        String goodsClass = this.getUrl(umUserinfo.getTenantCode(), "ul_goodsClass", "ul_goodsClass");
        if (StringUtils.isNotBlank((String)goodsClass)) {
            map.put("goodsClass", goodsClass);
        }
        String channelCode = this.getUrl(umUserinfo.getTenantCode(), "ul_channelCode", "ul_channelCode");
        String channelName = this.getUrl(umUserinfo.getTenantCode(), "ul_channelName", "ul_channelName");
        if (StringUtils.isNotBlank((String)channelCode) && StringUtils.isNotBlank((String)channelName)) {
            map.put("channelCode", channelCode);
            map.put("channelName", channelName);
        }
        return this.savePointsInitialization(map);
    }

    @Override
    public void savePointsInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        this.savePointsInitialization(map);
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isBlank((String)value)) {
            field = "00000000".concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
            value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        }
        this.logger.error("upm.UpmPointsServiceImpl.getUrl", (Object)value);
        return value;
    }

    @Override
    public String savePointsInitialization(Map<String, Object> map) throws ApiException {
        if (MapUtils.isEmpty(map) || null == map.get("tenantCode")) {
            this.logger.error("upm.UpmPointsServiceImpl.savePointsInitialization", (Object)map.toString());
            return "error";
        }
        List<UpmPoints> upmPointsList = this.queryPointsModelPage(map);
        if (ListUtil.isNotEmpty(upmPointsList)) {
            return "success";
        }
        HashMap<String, Object> parem = new HashMap<String, Object>();
        parem.put("tenantCode", "00000000");
        upmPointsList = this.queryPointsModelPage(parem);
        if (ListUtil.isEmpty(upmPointsList)) {
            this.logger.error("upm.UpmPointsServiceImpl.savePointsInitialization.upmPoints", (Object)map.toString());
            return "error";
        }
        for (UpmPoints upmPoints : upmPointsList) {
            this.savePointsRule(this.queryPointsRule(upmPoints), map);
            UpmPointsDomain upmPointsDomain = this.makeUpmPointsDomain(upmPoints, map);
            String code = this.savePoints(upmPointsDomain);
            if (UserPointsManagerConstants.dataState0 == upmPoints.getDataState()) continue;
            this.updatePointsStateByCode(upmPointsDomain.getTenantCode(), code, upmPoints.getDataState(), UserPointsManagerConstants.dataState0);
        }
        return "success";
    }

    private UpmPointsDomain makeUpmPointsDomain(UpmPoints upmPoints, Map<String, Object> map) {
        if (null == upmPoints || MapUtils.isEmpty(map) || null == map.get("tenantCode")) {
            return null;
        }
        UpmPointsDomain upmPointsDomain = new UpmPointsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsDomain, (Object)upmPoints);
            upmPointsDomain.setPointsId(null);
            upmPointsDomain.setPointsCode(null);
            if (null != map.get("tenantCode")) {
                upmPointsDomain.setTenantCode(map.get("tenantCode").toString());
            }
            if (null != map.get("goodsClass")) {
                upmPointsDomain.setGoodsClass(map.get("goodsClass").toString());
            }
            if (null != map.get("memberMcode") && null != map.get("memberMname")) {
                upmPointsDomain.setMemberMcode(map.get("memberMcode").toString());
                upmPointsDomain.setMemberMname(map.get("memberMname").toString());
            }
            if (null != map.get("channelCode") && null != map.get("channelName")) {
                upmPointsDomain.setChannelCode(map.get("channelCode").toString());
                upmPointsDomain.setChannelName(map.get("channelName").toString());
            }
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsServiceImpl.savePackageList.e", (Throwable)e);
        }
        return upmPointsDomain;
    }

    private UpmPointsRuleDomain makeUpmPointsRuleDomain(UpmPointsRule upmPointsRule, Map<String, Object> map) {
        if (null == upmPointsRule || MapUtils.isEmpty(map) || null == map.get("tenantCode")) {
            return null;
        }
        UpmPointsRuleDomain upmPointsRuleDomain = new UpmPointsRuleDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsRuleDomain, (Object)upmPointsRule);
            upmPointsRuleDomain.setPointsRuleId(null);
            upmPointsRuleDomain.setPointsRuleCode(null);
            if (null != map.get("tenantCode")) {
                upmPointsRuleDomain.setTenantCode(map.get("tenantCode").toString());
            }
            if (null != map.get("goodsClass")) {
                upmPointsRuleDomain.setGoodsClass(map.get("goodsClass").toString());
            }
            if (null != map.get("memberMcode") && null != map.get("memberMname")) {
                upmPointsRuleDomain.setMemberMcode(map.get("memberMcode").toString());
                upmPointsRuleDomain.setMemberMname(map.get("memberMname").toString());
            }
            if (null != map.get("channelCode") && null != map.get("channelName")) {
                upmPointsRuleDomain.setChannelCode(map.get("channelCode").toString());
                upmPointsRuleDomain.setChannelName(map.get("channelName").toString());
            }
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsServiceImpl.savePackageList.e", (Throwable)e);
        }
        return upmPointsRuleDomain;
    }

    private List<UpmPointsRule> queryPointsRule(UpmPoints upmPoints) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", upmPoints.getTenantCode());
        map.put("upointsType", upmPoints.getUpointsType());
        map.put("memberMcode", upmPoints.getMemberMcode());
        QueryResult<UpmPointsRule> queryResult = this.upmPointsRuleService.queryPointsRulePage(map);
        return queryResult.getList();
    }

    private void savePointsRule(List<UpmPointsRule> upmPointsRules, Map<String, Object> map) {
        if (ListUtil.isEmpty(upmPointsRules) || MapUtil.isEmpty(map)) {
            return;
        }
        for (UpmPointsRule upmPointsRule : upmPointsRules) {
            UpmPointsRuleDomain upmPointsRuleDomain = this.makeUpmPointsRuleDomain(upmPointsRule, map);
            String code = this.upmPointsRuleService.savePointsRule(upmPointsRuleDomain);
            if (UserPointsManagerConstants.dataState0 == upmPointsRule.getDataState()) continue;
            this.upmPointsRuleService.updatePointsRuleStateByCode(upmPointsRuleDomain.getTenantCode(), code, upmPointsRule.getDataState(), UserPointsManagerConstants.dataState0);
        }
    }
}

